/*
** ###################################################################
**     Processors:          MCXN236VDF
**                          MCXN236VNL
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    MCX N1xNxxx Reference Manual
**     Version:             rev. 1.0, 2022-10-01
**     Build:               b240115
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MCXN236
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2022-10-01)
**         Initial version based on SPEC1.14
**
** ###################################################################
*/

/*!
 * @file MCXN236.h
 * @version 1.0
 * @date 2022-10-01
 * @brief CMSIS Peripheral Access Layer for MCXN236
 *
 * CMSIS Peripheral Access Layer for MCXN236
 */

#if !defined(MCXN236_H_)
#define MCXN236_H_                               /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 172                /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M33 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M33 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M33 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M33 Usage Fault Interrupt */
  SecureFault_IRQn             = -9,               /**< Cortex-M33 Secure Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M33 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M33 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M33 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M33 System Tick Interrupt */

  /* Device specific interrupts */
  OR_IRQn                      = 0,                /**< OR IRQ */
  EDMA_0_CH0_IRQn              = 1,                /**< eDMA_0_CH0 error or transfer complete */
  EDMA_0_CH1_IRQn              = 2,                /**< eDMA_0_CH1 error or transfer complete */
  EDMA_0_CH2_IRQn              = 3,                /**< eDMA_0_CH2 error or transfer complete */
  EDMA_0_CH3_IRQn              = 4,                /**< eDMA_0_CH3 error or transfer complete */
  EDMA_0_CH4_IRQn              = 5,                /**< eDMA_0_CH4 error or transfer complete */
  EDMA_0_CH5_IRQn              = 6,                /**< eDMA_0_CH5 error or transfer complete */
  EDMA_0_CH6_IRQn              = 7,                /**< eDMA_0_CH6 error or transfer complete */
  EDMA_0_CH7_IRQn              = 8,                /**< eDMA_0_CH7 error or transfer complete */
  EDMA_0_CH8_IRQn              = 9,                /**< eDMA_0_CH8 error or transfer complete */
  EDMA_0_CH9_IRQn              = 10,               /**< eDMA_0_CH9 error or transfer complete */
  EDMA_0_CH10_IRQn             = 11,               /**< eDMA_0_CH10 error or transfer complete */
  EDMA_0_CH11_IRQn             = 12,               /**< eDMA_0_CH11 error or transfer complete */
  EDMA_0_CH12_IRQn             = 13,               /**< eDMA_0_CH12 error or transfer complete */
  EDMA_0_CH13_IRQn             = 14,               /**< eDMA_0_CH13 error or transfer complete */
  EDMA_0_CH14_IRQn             = 15,               /**< eDMA_0_CH14 error or transfer complete */
  EDMA_0_CH15_IRQn             = 16,               /**< eDMA_0_CH15 error or transfer complete */
  GPIO00_IRQn                  = 17,               /**< GPIO0 interrupt 0 */
  GPIO01_IRQn                  = 18,               /**< GPIO0 interrupt 1 */
  GPIO10_IRQn                  = 19,               /**< GPIO1 interrupt 0 */
  GPIO11_IRQn                  = 20,               /**< GPIO1 interrupt 1 */
  GPIO20_IRQn                  = 21,               /**< GPIO2 interrupt 0 */
  GPIO21_IRQn                  = 22,               /**< GPIO2 interrupt 1 */
  GPIO30_IRQn                  = 23,               /**< GPIO3 interrupt 0 */
  GPIO31_IRQn                  = 24,               /**< GPIO3 interrupt 1 */
  GPIO40_IRQn                  = 25,               /**< GPIO4 interrupt 0 */
  GPIO41_IRQn                  = 26,               /**< GPIO4 interrupt 1 */
  GPIO50_IRQn                  = 27,               /**< GPIO5 interrupt 0 */
  GPIO51_IRQn                  = 28,               /**< GPIO5 interrupt 1 */
  UTICK0_IRQn                  = 29,               /**< Micro-Tick Timer interrupt */
  MRT0_IRQn                    = 30,               /**< Multi-Rate Timer interrupt */
  CTIMER0_IRQn                 = 31,               /**< Standard counter/timer 0 interrupt */
  CTIMER1_IRQn                 = 32,               /**< Standard counter/timer 1 interrupt */
  Reserved49_IRQn              = 33,               /**< Reserved interrupt */
  CTIMER2_IRQn                 = 34,               /**< Standard counter/timer 2 interrupt */
  LP_FLEXCOMM0_IRQn            = 35,               /**< LP_FLEXCOMM0 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM1_IRQn            = 36,               /**< LP_FLEXCOMM1 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM2_IRQn            = 37,               /**< LP_FLEXCOMM2 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM3_IRQn            = 38,               /**< LP_FLEXCOMM3 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM4_IRQn            = 39,               /**< LP_FLEXCOMM4 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM5_IRQn            = 40,               /**< LP_FLEXCOMM5 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM6_IRQn            = 41,               /**< LP_FLEXCOMM6 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM7_IRQn            = 42,               /**< LP_FLEXCOMM7 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  Reserved59_IRQn              = 43,               /**< Reserved interrupt */
  Reserved60_IRQn              = 44,               /**< Reserved interrupt */
  ADC0_IRQn                    = 45,               /**< Analog-to-Digital Converter 0 - General Purpose interrupt */
  ADC1_IRQn                    = 46,               /**< Analog-to-Digital Converter 1 - General Purpose interrupt */
  PINT0_IRQn                   = 47,               /**< Pin Interrupt Pattern Match Interrupt */
  PDM_EVENT_IRQn               = 48,               /**<   */
  Reserved65_IRQn              = 49,               /**< Reserved interrupt */
  Reserved66_IRQn              = 50,               /**< Reserved interrupt */
  USB0_DCD_IRQn                = 51,               /**< Universal Serial Bus - Device Charge Detect interrupt */
  RTC_IRQn                     = 52,               /**< RTC Subsystem interrupt (RTC interrupt or Wake timer interrupt) */
  SMARTDMA_IRQn                = 53,               /**< SmartDMA_IRQ */
  Reserved70_IRQn              = 54,               /**< Reserved interrupt */
  CTIMER3_IRQn                 = 55,               /**< Standard counter/timer 3 interrupt */
  CTIMER4_IRQn                 = 56,               /**< Standard counter/timer 4 interrupt */
  OS_EVENT_IRQn                = 57,               /**< OS event timer interrupt */
  Reserved74_IRQn              = 58,               /**< Reserved interrupt */
  SAI0_IRQn                    = 59,               /**< Serial Audio Interface 0 interrupt */
  SAI1_IRQn                    = 60,               /**< Serial Audio Interface 1 interrupt */
  Reserved77_IRQn              = 61,               /**< Reserved interrupt */
  CAN0_IRQn                    = 62,               /**< Controller Area Network 0 interrupt */
  CAN1_IRQn                    = 63,               /**< Controller Area Network 1 interrupt */
  Reserved80_IRQn              = 64,               /**< Reserved interrupt */
  Reserved81_IRQn              = 65,               /**< Reserved interrupt */
  USB1_HS_PHY_IRQn             = 66,               /**< USBHS DCD or USBHS Phy interrupt */
  USB1_HS_IRQn                 = 67,               /**< USB High Speed OTG Controller interrupt  */
  SEC_HYPERVISOR_CALL_IRQn     = 68,               /**< AHB Secure Controller hypervisor call interrupt */
  Reserved85_IRQn              = 69,               /**< Reserved interrupt */
  Reserved86_IRQn              = 70,               /**< Reserved interrupt */
  Freqme_IRQn                  = 71,               /**< Frequency Measurement interrupt */
  SEC_VIO_IRQn                 = 72,               /**< Secure violation interrupt (Memory Block Checker interrupt or secure AHB matrix violation interrupt) */
  ELS_IRQn                     = 73,               /**< ELS interrupt */
  PKC_IRQn                     = 74,               /**< PKC interrupt */
  PUF_IRQn                     = 75,               /**< Physical Unclonable Function interrupt */
  Reserved92_IRQn              = 76,               /**< Reserved interrupt */
  EDMA_1_CH0_IRQn              = 77,               /**< eDMA_1_CH0 error or transfer complete */
  EDMA_1_CH1_IRQn              = 78,               /**< eDMA_1_CH1 error or transfer complete */
  EDMA_1_CH2_IRQn              = 79,               /**< eDMA_1_CH2 error or transfer complete */
  EDMA_1_CH3_IRQn              = 80,               /**< eDMA_1_CH3 error or transfer complete */
  EDMA_1_CH4_IRQn              = 81,               /**< eDMA_1_CH4 error or transfer complete */
  EDMA_1_CH5_IRQn              = 82,               /**< eDMA_1_CH5 error or transfer complete */
  EDMA_1_CH6_IRQn              = 83,               /**< eDMA_1_CH6 error or transfer complete */
  EDMA_1_CH7_IRQn              = 84,               /**< eDMA_1_CH7 error or transfer complete */
  Reserved101_IRQn             = 85,               /**< Reserved interrupt */
  Reserved102_IRQn             = 86,               /**< Reserved interrupt */
  Reserved103_IRQn             = 87,               /**< Reserved interrupt */
  Reserved104_IRQn             = 88,               /**< Reserved interrupt */
  Reserved105_IRQn             = 89,               /**< Reserved interrupt */
  Reserved106_IRQn             = 90,               /**< Reserved interrupt */
  Reserved107_IRQn             = 91,               /**< Reserved interrupt */
  Reserved108_IRQn             = 92,               /**< Reserved interrupt */
  CDOG0_IRQn                   = 93,               /**< Code Watchdog Timer 0 interrupt */
  CDOG1_IRQn                   = 94,               /**< Code Watchdog Timer 1 interrupt */
  I3C0_IRQn                    = 95,               /**< Improved Inter Integrated Circuit interrupt 0 */
  I3C1_IRQn                    = 96,               /**< Improved Inter Integrated Circuit interrupt 1 */
  Reserved113_IRQn             = 97,               /**< Reserved interrupt */
  GDET_IRQn                    = 98,               /**< Digital Glitch Detect 0 interrupt  or Digital Glitch Detect 1 interrupt */
  VBAT0_IRQn                   = 99,               /**< VBAT interrupt( VBAT interrupt or digital tamper interrupt) */
  EWM0_IRQn                    = 100,              /**< External Watchdog Monitor interrupt */
  Reserved117_IRQn             = 101,              /**< Reserved interrupt */
  Reserved118_IRQn             = 102,              /**< Reserved interrupt */
  Reserved119_IRQn             = 103,              /**< Reserved interrupt */
  Reserved120_IRQn             = 104,              /**< Reserved interrupt */
  FLEXIO_IRQn                  = 105,              /**< Flexible Input/Output interrupt */
  Reserved122_IRQn             = 106,              /**< Reserved interrupt */
  Reserved123_IRQn             = 107,              /**< Reserved interrupt */
  Reserved124_IRQn             = 108,              /**< Reserved interrupt */
  HSCMP0_IRQn                  = 109,              /**< High-Speed comparator0 interrupt */
  HSCMP1_IRQn                  = 110,              /**< High-Speed comparator1 interrupt */
  Reserved127_IRQn             = 111,              /**< Reserved interrupt */
  FLEXPWM0_RELOAD_ERROR_IRQn   = 112,              /**< FlexPWM0_reload_error interrupt */
  FLEXPWM0_FAULT_IRQn          = 113,              /**< FlexPWM0_fault interrupt */
  FLEXPWM0_SUBMODULE0_IRQn     = 114,              /**< FlexPWM0 Submodule 0 capture/compare/reload interrupt */
  FLEXPWM0_SUBMODULE1_IRQn     = 115,              /**< FlexPWM0 Submodule 1 capture/compare/reload interrupt */
  FLEXPWM0_SUBMODULE2_IRQn     = 116,              /**< FlexPWM0 Submodule 2 capture/compare/reload interrupt */
  FLEXPWM0_SUBMODULE3_IRQn     = 117,              /**< FlexPWM0 Submodule 3 capture/compare/reload interrupt */
  FLEXPWM1_RELOAD_ERROR_IRQn   = 118,              /**< FlexPWM1_reload_error interrupt */
  FLEXPWM1_FAULT_IRQn          = 119,              /**< FlexPWM1_fault interrupt */
  FLEXPWM1_SUBMODULE0_IRQn     = 120,              /**< FlexPWM1 Submodule 0 capture/compare/reload interrupt */
  FLEXPWM1_SUBMODULE1_IRQn     = 121,              /**< FlexPWM1 Submodule 1 capture/compare/reload interrupt */
  FLEXPWM1_SUBMODULE2_IRQn     = 122,              /**< FlexPWM1 Submodule 2 capture/compare/reload interrupt */
  FLEXPWM1_SUBMODULE3_IRQn     = 123,              /**< FlexPWM1 Submodule 3 capture/compare/reload interrupt */
  ENC0_COMPARE_IRQn            = 124,              /**< ENC0_Compare interrupt */
  ENC0_HOME_IRQn               = 125,              /**< ENC0_Home interrupt */
  ENC0_WDG_SAB_IRQn            = 126,              /**< ENC0_WDG_IRQ/SAB interrupt */
  ENC0_IDX_IRQn                = 127,              /**< ENC0_IDX interrupt */
  ENC1_COMPARE_IRQn            = 128,              /**< ENC1_Compare interrupt */
  ENC1_HOME_IRQn               = 129,              /**< ENC1_Home interrupt */
  ENC1_WDG_SAB_IRQn            = 130,              /**< ENC1_WDG_IRQ/SAB interrupt */
  ENC1_IDX_IRQn                = 131,              /**< ENC1_IDX interrupt */
  ITRC0_IRQn                   = 132,              /**< Intrusion and Tamper Response Controller interrupt */
  Reserved149_IRQn             = 133,              /**< Reserved interrupt */
  ELS_ERR_IRQn                 = 134,              /**< ELS error interrupt */
  PKC_ERR_IRQn                 = 135,              /**< PKC error interrupt */
  ERM_SINGLE_BIT_ERROR_IRQn    = 136,              /**< ERM Single Bit error interrupt */
  ERM_MULTI_BIT_ERROR_IRQn     = 137,              /**< ERM Multi Bit error interrupt */
  FMU0_IRQn                    = 138,              /**< Flash Management Unit interrupt */
  Reserved155_IRQn             = 139,              /**< Reserved interrupt */
  Reserved156_IRQn             = 140,              /**< Reserved interrupt */
  Reserved157_IRQn             = 141,              /**< Reserved interrupt */
  Reserved158_IRQn             = 142,              /**< Reserved interrupt */
  LPTMR0_IRQn                  = 143,              /**< Low Power Timer 0 interrupt */
  LPTMR1_IRQn                  = 144,              /**< Low Power Timer 1 interrupt */
  SCG_IRQn                     = 145,              /**< System Clock Generator interrupt */
  SPC_IRQn                     = 146,              /**< System Power Controller interrupt */
  WUU_IRQn                     = 147,              /**< Wake Up Unit interrupt */
  PORT_EFT_IRQn                = 148,              /**< PORT0~5 EFT interrupt */
  Reserved165_IRQn             = 149,              /**< Reserved interrupt */
  Reserved166_IRQn             = 150,              /**< Reserved interrupt */
  TRNG0_IRQn                   = 151,              /**< True Random Number Generator interrupt */
  WWDT0_IRQn                   = 152,              /**< Windowed Watchdog Timer 0 interrupt */
  WWDT1_IRQn                   = 153,              /**< Windowed Watchdog Timer 1 interrupt */
  CMC0_IRQn                    = 154,              /**< Core Mode Controller interrupt */
  Reserved171_IRQn             = 155               /**< Reserved interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M33 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M33 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               3         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */
#define __DSP_PRESENT                  1         /**< Defines if Armv8-M Mainline core supports DSP instructions */
#define __SAUREGION_PRESENT            1         /**< Defines if an SAU is present or not */

#include "core_cm33.h"                 /* Core Peripheral Access Layer */
#include "system_MCXN236.h"            /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup eim_memory_channel
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the eim_memory_channel
 *
 * Defines the structure for the EIM resource collections.
 */

typedef enum _eim_memory_channel
{
    kEIM_MemoryChannelRAMX          = 0U,          /**< Memory RAMX */
    kEIM_MemoryChannelRAMA          = 1U,          /**< Memory RAMA  */
    kEIM_MemoryChannelRAMB          = 2U,          /**< Memory RAMB */
    kEIM_MemoryChannelRAMC          = 3U,          /**< Memory RAMC */
    kEIM_MemoryChannelRAMD          = 4U,          /**< Memory RAMD */
    kEIM_MemoryChannelRAME          = 5U,          /**< Memory RAME */
    kEIM_MemoryChannelRAMF          = 6U,          /**< Memory RAMF */
    kEIM_MemoryChannelLPCACRAM      = 7U,          /**< Memory LPCACRAM */
    kEIM_MemoryChannelPKCRAM        = 8U,          /**< Memory PKCRAM */
} eim_memory_channel_t;

/* @} */

/*!
 * @addtogroup eim_error_injection_channel_enable
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the eim_error_injection_channel_enable
 *
 * Defines the structure for the EIM error injection resource collections.
 */

typedef enum _eim_error_injection_channel_enable
{
    kEIM_MemoryChannelRAMXEnable    = 0x80000000U, /**< Memory channel 0(RAMX) error injection enable */
    kEIM_MemoryChannelRAMAEnable    = 0x40000000U, /**< Memory channel 1(RAMA) error injection enable  */
    kEIM_MemoryChannelRAMBEnable    = 0x20000000U, /**< Memory channel 2(RAMB) error injection enable */
    kEIM_MemoryChannelRAMCEnable    = 0x10000000U, /**< Memory channel 3(RAMC) error injection enable */
    kEIM_MemoryChannelRAMDEnable    = 0x8000000U,  /**< Memory channel 4(RAMD) error injection enable */
    kEIM_MemoryChannelRAMEEnable    = 0x4000000U,  /**< Memory channel 5(RAME) error injection enable */
    kEIM_MemoryChannelRAMFEnable    = 0x2000000U,  /**< Memory channel 6(RAMF) error injection enable */
    kEIM_MemoryChannelLPCACRAMEnable = 0x1000000U, /**< Memory channel 7(LPCACRAM) error injection enable */
    kEIM_MemoryChannelPKCRAMEnable  = 0x800000U,   /**< Memory channel 8(PKCRAM) error injection enable */
} eim_error_injection_channel_enable_t;

/* @} */

/*!
 * @addtogroup erm_memory_channel
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the erm_memory_channel
 *
 * Defines the structure for the ERM resource collections.
 */

typedef enum _erm_memory_channel
{
    kERM_MemoryChannelRAMX          = 0U,          /**< Memory RAMX */
    kERM_MemoryChannelRAMA          = 1U,          /**< Memory RAMA  */
    kERM_MemoryChannelRAMB          = 2U,          /**< Memory RAMB */
    kERM_MemoryChannelRAMC          = 3U,          /**< Memory RAMC */
    kERM_MemoryChannelRAMD          = 4U,          /**< Memory RAMD */
    kERM_MemoryChannelRAME          = 5U,          /**< Memory RAME */
    kERM_MemoryChannelRAMF          = 6U,          /**< Memory RAMF */
    kERM_MemoryChannelLPCACRAM      = 7U,          /**< Memory LPCACRAM */
    kERM_MemoryChannelPKCRAM        = 8U,          /**< Memory PKCRAM */
    kERM_MemoryChannelFLASH         = 9U,          /**< Memory FLASH */
} erm_memory_channel_t;

/* @} */

/*!
 * @addtogroup dma_request
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum _dma_request_source
{
    kDma0RequestMuxPinInt0          = 3U,          /**< PINT0 INT0 */
    kDma1RequestMuxPinInt0          = 3U,          /**< PINT0 INT0 */
    kDma0RequestMuxPinInt1          = 4U,          /**< PINT0 INT1 */
    kDma1RequestMuxPinInt1          = 4U,          /**< PINT0 INT1 */
    kDma0RequestMuxPinInt2          = 5U,          /**< PINT0 INT2 */
    kDma1RequestMuxPinInt2          = 5U,          /**< PINT0 INT2 */
    kDma0RequestMuxPinInt3          = 6U,          /**< PINT0 INT3 */
    kDma1RequestMuxPinInt3          = 6U,          /**< PINT0 INT3 */
    kDma0RequestMuxCtimer0M0        = 7U,          /**< CTIMER0 Match channel 0 request */
    kDma1RequestMuxCtimer0M0        = 7U,          /**< CTIMER0 Match channel 0 request */
    kDma0RequestMuxCtimer0M1        = 8U,          /**< CTIMER0 Match channel 1 request */
    kDma1RequestMuxCtimer0M1        = 8U,          /**< CTIMER0 Match channel 1 request */
    kDma0RequestMuxCtimer1M0        = 9U,          /**< CTIMER1 Match channel 0 request */
    kDma1RequestMuxCtimer1M0        = 9U,          /**< CTIMER1 Match channel 0 request */
    kDma0RequestMuxCtimer1M1        = 10U,         /**< CTIMER1 Match channel 1 request */
    kDma1RequestMuxCtimer1M1        = 10U,         /**< CTIMER1 Match channel 1 request */
    kDma0RequestMuxCtimer2M0        = 11U,         /**< CTIMER2 Match channel 0 request */
    kDma1RequestMuxCtimer2M0        = 11U,         /**< CTIMER2 Match channel 0 request */
    kDma0RequestMuxCtimer2M1        = 12U,         /**< CTIMER2 Match channel 1 request */
    kDma1RequestMuxCtimer2M1        = 12U,         /**< CTIMER2 Match channel 1 request */
    kDma0RequestMuxCtimer3M0        = 13U,         /**< CTIMER3 Match channel 0 request */
    kDma1RequestMuxCtimer3M0        = 13U,         /**< CTIMER3 Match channel 0 request */
    kDma0RequestMuxCtimer3M1        = 14U,         /**< CTIMER3 Match channel 1 request */
    kDma1RequestMuxCtimer3M1        = 14U,         /**< CTIMER3 Match channel 1 request */
    kDma0RequestMuxCtimer4M0        = 15U,         /**< CTIMER4 Match channel 0 request */
    kDma1RequestMuxCtimer4M0        = 15U,         /**< CTIMER4 Match channel 0 request */
    kDma0RequestMuxCtimer4M1        = 16U,         /**< CTIMER4 Match channel 1 request */
    kDma1RequestMuxCtimer4M1        = 16U,         /**< CTIMER4 Match channel 1 request */
    kDma0RequestMuxWuu0             = 17U,         /**< WUU0 Wake up event */
    kDma1RequestMuxWuu0             = 17U,         /**< WUU0 Wake up event */
    kDma0RequestMuxMicfil0FifoRequest = 18U,       /**< MICFIL0 FIFO_request */
    kDma1RequestMuxMicfil0FifoRequest = 18U,       /**< MICFIL0 FIFO_request */
    kDma0RequestMuxAdc0FifoARequest = 21U,         /**< ADC0 FIFO A request */
    kDma1RequestMuxAdc0FifoARequest = 21U,         /**< ADC0 FIFO A request */
    kDma0RequestMuxAdc0FifoBRequest = 22U,         /**< ADC0 FIFO B request */
    kDma1RequestMuxAdc0FifoBRequest = 22U,         /**< ADC0 FIFO B request */
    kDma0RequestMuxAdc1FifoARequest = 23U,         /**< ADC1 FIFO A request */
    kDma1RequestMuxAdc1FifoARequest = 23U,         /**< ADC1 FIFO A request */
    kDma0RequestMuxAdc1FifoBRequest = 24U,         /**< ADC1 FIFO B request */
    kDma1RequestMuxAdc1FifoBRequest = 24U,         /**< ADC1 FIFO B request */
    kDma0RequestMuxHsCmp0DmaRequest = 28U,         /**< CMP0 DMA_request */
    kDma1RequestMuxHsCmp0DmaRequest = 28U,         /**< CMP0 DMA_request */
    kDma0RequestMuxHsCmp1DmaRequest = 29U,         /**< CMP1 DMA_request */
    kDma1RequestMuxHsCmp1DmaRequest = 29U,         /**< CMP1 DMA_request */
    kDma0RequestMuxEvtg0Out0A       = 31U,         /**< EVTG0 OUT0A */
    kDma1RequestMuxEvtg0Out0A       = 31U,         /**< EVTG0 OUT0A */
    kDma0RequestMuxEvtg0Out0B       = 32U,         /**< EVTG0 OUT0B */
    kDma1RequestMuxEvtg0Out0B       = 32U,         /**< EVTG0 OUT0B */
    kDma0RequestMuxEvtg0Out1A       = 33U,         /**< EVTG0 OUT1A */
    kDma1RequestMuxEvtg0Out1A       = 33U,         /**< EVTG0 OUT1A */
    kDma0RequestMuxEvtg0Out1B       = 34U,         /**< EVTG0 OUT1B */
    kDma1RequestMuxEvtg0Out1B       = 34U,         /**< EVTG0 OUT1B */
    kDma0RequestMuxEvtg0Out2A       = 35U,         /**< EVTG0 OUT2A */
    kDma1RequestMuxEvtg0Out2A       = 35U,         /**< EVTG0 OUT2A */
    kDma0RequestMuxEvtg0Out2B       = 36U,         /**< EVTG0 OUT2B */
    kDma1RequestMuxEvtg0Out2B       = 36U,         /**< EVTG0 OUT2B */
    kDma0RequestMuxEvtg0Out3A       = 37U,         /**< EVTG0 OUT3A */
    kDma1RequestMuxEvtg0Out3A       = 37U,         /**< EVTG0 OUT3A */
    kDma0RequestMuxEvtg0Out3B       = 38U,         /**< EVTG0 OUT3B */
    kDma1RequestMuxEvtg0Out3B       = 38U,         /**< EVTG0 OUT3B */
    kDma0RequestMuxFlexPwm0ReqCapt0 = 39U,         /**< PWM0 capture0 request */
    kDma1RequestMuxFlexPwm0ReqCapt0 = 39U,         /**< PWM0 capture0 request */
    kDma0RequestMuxFlexPwm0ReqCapt1 = 40U,         /**< PWM0 capture1 request */
    kDma1RequestMuxFlexPwm0ReqCapt1 = 40U,         /**< PWM0 capture1 request */
    kDma0RequestMuxFlexPwm0ReqCapt2 = 41U,         /**< PWM0 capture2 request */
    kDma1RequestMuxFlexPwm0ReqCapt2 = 41U,         /**< PWM0 capture2 request */
    kDma0RequestMuxFlexPwm0ReqCapt3 = 42U,         /**< PWM0 capture3 request */
    kDma1RequestMuxFlexPwm0ReqCapt3 = 42U,         /**< PWM0 capture3 request */
    kDma0RequestMuxFlexPwm0ReqVal0  = 43U,         /**< PWM0 value0 request */
    kDma1RequestMuxFlexPwm0ReqVal0  = 43U,         /**< PWM0 value0 request */
    kDma0RequestMuxFlexPwm0ReqVal1  = 44U,         /**< PWM0 value1 request */
    kDma1RequestMuxFlexPwm0ReqVal1  = 44U,         /**< PWM0 value1 request */
    kDma0RequestMuxFlexPwm0ReqVal2  = 45U,         /**< PWM0 value2 request */
    kDma1RequestMuxFlexPwm0ReqVal2  = 45U,         /**< PWM0 value2 request */
    kDma0RequestMuxFlexPwm0ReqVal3  = 46U,         /**< PWM0 value3 request */
    kDma1RequestMuxFlexPwm0ReqVal3  = 46U,         /**< PWM0 value3 request */
    kDma0RequestMuxFlexPwm1ReqCapt0 = 47U,         /**< PWM1 capture0 request */
    kDma1RequestMuxFlexPwm1ReqCapt0 = 47U,         /**< PWM1 capture0 request */
    kDma0RequestMuxFlexPwm1ReqCapt1 = 48U,         /**< PWM1 capture1 request */
    kDma1RequestMuxFlexPwm1ReqCapt1 = 48U,         /**< PWM1 capture1 request */
    kDma0RequestMuxFlexPwm1ReqCapt2 = 49U,         /**< PWM1 capture2 request */
    kDma1RequestMuxFlexPwm1ReqCapt2 = 49U,         /**< PWM1 capture2 request */
    kDma0RequestMuxFlexPwm1ReqCapt3 = 50U,         /**< PWM1 capture3 request */
    kDma1RequestMuxFlexPwm1ReqCapt3 = 50U,         /**< PWM1 capture3 request */
    kDma0RequestMuxFlexPwm1ReqVal0  = 51U,         /**< PWM1 value0 request */
    kDma1RequestMuxFlexPwm1ReqVal0  = 51U,         /**< PWM1 value0 request */
    kDma0RequestMuxFlexPwm1ReqVal1  = 52U,         /**< PWM1 value1 request */
    kDma1RequestMuxFlexPwm1ReqVal1  = 52U,         /**< PWM1 value1 request */
    kDma0RequestMuxFlexPwm1ReqVal2  = 53U,         /**< PWM1 value2 request */
    kDma1RequestMuxFlexPwm1ReqVal2  = 53U,         /**< PWM1 value2 request */
    kDma0RequestMuxFlexPwm1ReqVal3  = 54U,         /**< PWM0 value3 request */
    kDma1RequestMuxFlexPwm1ReqVal3  = 54U,         /**< PWM0 value3 request */
    kDma0RequestMuxLptmr0           = 57U,         /**< LPTMR0 Counter match event */
    kDma1RequestMuxLptmr0           = 57U,         /**< LPTMR0 Counter match event */
    kDma0RequestMuxLptmr1           = 58U,         /**< LPTMR1 Counter match event */
    kDma1RequestMuxLptmr1           = 58U,         /**< LPTMR1 Counter match event */
    kDma0RequestMuxFlexCan0DmaRequest = 59U,       /**< CAN0 DMA request */
    kDma1RequestMuxFlexCan0DmaRequest = 59U,       /**< CAN0 DMA request */
    kDma0RequestMuxFlexCan1DmaRequest = 60U,       /**< CAN1 DMA request */
    kDma1RequestMuxFlexCan1DmaRequest = 60U,       /**< CAN1 DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister0Request = 61U, /**< FlexIO0 Shifter0 Status DMA request OR Timer0 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister0Request = 61U, /**< FlexIO0 Shifter0 Status DMA request OR Timer0 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister1Request = 62U, /**< FlexIO0 Shifter1 Status DMA request OR Timer1 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister1Request = 62U, /**< FlexIO0 Shifter1 Status DMA request OR Timer1 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister2Request = 63U, /**< FlexIO0 Shifter2 Status DMA request OR Timer2 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister2Request = 63U, /**< FlexIO0 Shifter2 Status DMA request OR Timer2 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister3Request = 64U, /**< FlexIO0 Shifter3 Status DMA request OR Timer3 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister3Request = 64U, /**< FlexIO0 Shifter3 Status DMA request OR Timer3 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister4Request = 65U, /**< FlexIO0 Shifter4 Status DMA request OR Timer4 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister4Request = 65U, /**< FlexIO0 Shifter4 Status DMA request OR Timer4 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister5Request = 66U, /**< FlexIO0 Shifter5 Status DMA request OR Timer5 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister5Request = 66U, /**< FlexIO0 Shifter5 Status DMA request OR Timer5 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister6Request = 67U, /**< FlexIO0 Shifter6 Status DMA request OR Timer6 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister6Request = 67U, /**< FlexIO0 Shifter6 Status DMA request OR Timer6 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister7Request = 68U, /**< FlexIO0 Shifter7 Status DMA request OR Timer7 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister7Request = 68U, /**< FlexIO0 Shifter7 Status DMA request OR Timer7 Status DMA request */
    kDma0RequestMuxLpFlexcomm0Rx    = 69U,         /**< LP_FLEXCOMM0 Receive request */
    kDma1RequestMuxLpFlexcomm0Rx    = 69U,         /**< LP_FLEXCOMM0 Receive request */
    kDma0RequestMuxLpFlexcomm0Tx    = 70U,         /**< LP_FLEXCOMM0 Transmit request */
    kDma1RequestMuxLpFlexcomm0Tx    = 70U,         /**< LP_FLEXCOMM0 Transmit request */
    kDma0RequestMuxLpFlexcomm1Rx    = 71U,         /**< LP_FLEXCOMM1 Receive request */
    kDma1RequestMuxLpFlexcomm1Rx    = 71U,         /**< LP_FLEXCOMM1 Receive request */
    kDma0RequestMuxLpFlexcomm1Tx    = 72U,         /**< LP_FLEXCOMM1 Transmit request */
    kDma1RequestMuxLpFlexcomm1Tx    = 72U,         /**< LP_FLEXCOMM1 Transmit request */
    kDma0RequestMuxLpFlexcomm2Rx    = 73U,         /**< LP_FLEXCOMM2 Receive request */
    kDma1RequestMuxLpFlexcomm2Rx    = 73U,         /**< LP_FLEXCOMM2 Receive request */
    kDma0RequestMuxLpFlexcomm2Tx    = 74U,         /**< LP_FLEXCOMM2 Transmit request */
    kDma1RequestMuxLpFlexcomm2Tx    = 74U,         /**< LP_FLEXCOMM2 Transmit request */
    kDma0RequestMuxLpFlexcomm3Rx    = 75U,         /**< LP_FLEXCOMM3 Receive request */
    kDma1RequestMuxLpFlexcomm3Rx    = 75U,         /**< LP_FLEXCOMM3 Receive request */
    kDma0RequestMuxLpFlexcomm3Tx    = 76U,         /**< LP_FLEXCOMM3 Transmit request */
    kDma1RequestMuxLpFlexcomm3Tx    = 76U,         /**< LP_FLEXCOMM3 Transmit request */
    kDma0RequestMuxLpFlexcomm4Rx    = 77U,         /**< LP_FLEXCOMM4 Receive request */
    kDma1RequestMuxLpFlexcomm4Rx    = 77U,         /**< LP_FLEXCOMM4 Receive request */
    kDma0RequestMuxLpFlexcomm4Tx    = 78U,         /**< LP_FLEXCOMM4 Transmit request */
    kDma1RequestMuxLpFlexcomm4Tx    = 78U,         /**< LP_FLEXCOMM4 Transmit request */
    kDma0RequestMuxLpFlexcomm5Rx    = 79U,         /**< LP_FLEXCOMM5 Receive request */
    kDma1RequestMuxLpFlexcomm5Rx    = 79U,         /**< LP_FLEXCOMM5 Receive request */
    kDma0RequestMuxLpFlexcomm5Tx    = 80U,         /**< LP_FLEXCOMM5 Transmit request */
    kDma1RequestMuxLpFlexcomm5Tx    = 80U,         /**< LP_FLEXCOMM5 Transmit request */
    kDma0RequestMuxLpFlexcomm6Rx    = 81U,         /**< LP_FLEXCOMM6 Receive request */
    kDma1RequestMuxLpFlexcomm6Rx    = 81U,         /**< LP_FLEXCOMM6 Receive request */
    kDma0RequestMuxLpFlexcomm6Tx    = 82U,         /**< LP_FLEXCOMM6 Transmit request */
    kDma1RequestMuxLpFlexcomm6Tx    = 82U,         /**< LP_FLEXCOMM6 Transmit request */
    kDma0RequestMuxLpFlexcomm7Rx    = 83U,         /**< LP_FLEXCOMM7 Receive request */
    kDma1RequestMuxLpFlexcomm7Rx    = 83U,         /**< LP_FLEXCOMM7 Receive request */
    kDma0RequestMuxLpFlexcomm7Tx    = 84U,         /**< LP_FLEXCOMM7 Transmit request */
    kDma1RequestMuxLpFlexcomm7Tx    = 84U,         /**< LP_FLEXCOMM7 Transmit request */
    kDma0RequestMuxI3c0Rx           = 95U,         /**< I3C0 Receive request */
    kDma1RequestMuxI3c0Rx           = 95U,         /**< I3C0 Receive request */
    kDma0RequestMuxI3c0Tx           = 96U,         /**< I3C0 Transmit request */
    kDma1RequestMuxI3c0Tx           = 96U,         /**< I3C0 Transmit request */
    kDma0RequestMuxI3c1Rx           = 97U,         /**< I3C1 Receive request */
    kDma1RequestMuxI3c1Rx           = 97U,         /**< I3C1 Receive request */
    kDma0RequestMuxI3c1Tx           = 98U,         /**< I3C1 Transmit request */
    kDma1RequestMuxI3c1Tx           = 98U,         /**< I3C1 Transmit request */
    kDma0RequestMuxSai0Rx           = 99U,         /**< SAI0 Receive request */
    kDma1RequestMuxSai0Rx           = 99U,         /**< SAI0 Receive request */
    kDma0RequestMuxSai0Tx           = 100U,        /**< SAI0 Transmit request */
    kDma1RequestMuxSai0Tx           = 100U,        /**< SAI0 Transmit request */
    kDma0RequestMuxSai1Rx           = 101U,        /**< SAI1 Receive request */
    kDma1RequestMuxSai1Rx           = 101U,        /**< SAI1 Receive request */
    kDma0RequestMuxSai1Tx           = 102U,        /**< SAI1 Transmit request */
    kDma1RequestMuxSai1Tx           = 102U,        /**< SAI1 Transmit request */
    kDma0RequestMuxGpio0PinEventRequest0 = 108U,   /**< GPIO0 Pin event request 0 */
    kDma1RequestMuxGpio0PinEventRequest0 = 108U,   /**< GPIO0 Pin event request 0 */
    kDma0RequestMuxGpio0PinEventRequest1 = 109U,   /**< GPIO0 Pin event request 1 */
    kDma1RequestMuxGpio0PinEventRequest1 = 109U,   /**< GPIO0 Pin event request 1 */
    kDma0RequestMuxGpio1PinEventRequest0 = 110U,   /**< GPIO1 Pin event request 0 */
    kDma1RequestMuxGpio1PinEventRequest0 = 110U,   /**< GPIO1 Pin event request 0 */
    kDma0RequestMuxGpio1PinEventRequest1 = 111U,   /**< GPIO1 Pin event request 1 */
    kDma1RequestMuxGpio1PinEventRequest1 = 111U,   /**< GPIO1 Pin event request 1 */
    kDma0RequestMuxGpio2PinEventRequest0 = 112U,   /**< GPIO2 Pin event request 0 */
    kDma1RequestMuxGpio2PinEventRequest0 = 112U,   /**< GPIO2 Pin event request 0 */
    kDma0RequestMuxGpio2PinEventRequest1 = 113U,   /**< GPIO2 Pin event request 1 */
    kDma1RequestMuxGpio2PinEventRequest1 = 113U,   /**< GPIO2 Pin event request 1 */
    kDma0RequestMuxGpio3PinEventRequest0 = 114U,   /**< GPIO3 Pin event request 0 */
    kDma1RequestMuxGpio3PinEventRequest0 = 114U,   /**< GPIO3 Pin event request 0 */
    kDma0RequestMuxGpio3PinEventRequest1 = 115U,   /**< GPIO3 Pin event request 1 */
    kDma1RequestMuxGpio3PinEventRequest1 = 115U,   /**< GPIO3 Pin event request 1 */
    kDma0RequestMuxGpio4PinEventRequest0 = 116U,   /**< GPIO4 Pin event request 0 */
    kDma1RequestMuxGpio4PinEventRequest0 = 116U,   /**< GPIO4 Pin event request 0 */
    kDma0RequestMuxGpio4PinEventRequest1 = 117U,   /**< GPIO4 Pin event request 1 */
    kDma1RequestMuxGpio4PinEventRequest1 = 117U,   /**< GPIO4 Pin event request 1 */
    kDma0RequestMuxGpio5PinEventRequest0 = 118U,   /**< GPIO5 Pin event request 0 */
    kDma1RequestMuxGpio5PinEventRequest0 = 118U,   /**< GPIO5 Pin event request 0 */
    kDma0RequestMuxGpio5PinEventRequest1 = 119U,   /**< GPIO5 Pin event request 1 */
    kDma1RequestMuxGpio5PinEventRequest1 = 119U,   /**< GPIO5 Pin event request 1 */
} dma_request_source_t;

/* @} */


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CTRL;                              /**< Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< Pause Register, offset: 0x24 */
       uint8_t RESERVED_1[12];
  __O  uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
  __IO uint32_t TSTAT;                             /**< Trigger Status Register, offset: 0x38 */
       uint8_t RESERVED_2[4];
  __IO uint32_t OFSTRIM;                           /**< Offset Trim Register, offset: 0x40 */
       uint8_t RESERVED_3[92];
  __IO uint32_t TCTRL[4];                          /**< Trigger Control Register, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_4[48];
  __IO uint32_t FCTRL[2];                          /**< FIFO Control Register, array offset: 0xE0, array step: 0x4 */
       uint8_t RESERVED_5[8];
  __I  uint32_t GCC[2];                            /**< Gain Calibration Control, array offset: 0xF0, array step: 0x4 */
  __IO uint32_t GCR[2];                            /**< Gain Calculation Result, array offset: 0xF8, array step: 0x4 */
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[15];
       uint8_t RESERVED_6[136];
  __IO uint32_t CV[15];                            /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_7[196];
  __I  uint32_t RESFIFO[2];                        /**< Data Result FIFO Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_8[248];
  __IO uint32_t CAL_GAR0;                          /**< Calibration General A-Side Registers, offset: 0x400 */
  __IO uint32_t CAL_GAR1;                          /**< Calibration General A-Side Registers, offset: 0x404 */
  __IO uint32_t CAL_GAR2;                          /**< Calibration General A-Side Registers, offset: 0x408 */
  __IO uint32_t CAL_GAR3;                          /**< Calibration General A-Side Registers, offset: 0x40C */
  __IO uint32_t CAL_GAR4;                          /**< Calibration General A-Side Registers, offset: 0x410 */
  __IO uint32_t CAL_GAR5;                          /**< Calibration General A-Side Registers, offset: 0x414 */
  __IO uint32_t CAL_GAR6;                          /**< Calibration General A-Side Registers, offset: 0x418 */
  __IO uint32_t CAL_GAR7;                          /**< Calibration General A-Side Registers, offset: 0x41C */
  __IO uint32_t CAL_GAR8;                          /**< Calibration General A-Side Registers, offset: 0x420 */
  __IO uint32_t CAL_GAR9;                          /**< Calibration General A-Side Registers, offset: 0x424 */
  __IO uint32_t CAL_GAR10;                         /**< Calibration General A-Side Registers, offset: 0x428 */
  __IO uint32_t CAL_GAR11;                         /**< Calibration General A-Side Registers, offset: 0x42C */
  __IO uint32_t CAL_GAR12;                         /**< Calibration General A-Side Registers, offset: 0x430 */
  __IO uint32_t CAL_GAR13;                         /**< Calibration General A-Side Registers, offset: 0x434 */
  __IO uint32_t CAL_GAR14;                         /**< Calibration General A-Side Registers, offset: 0x438 */
  __IO uint32_t CAL_GAR15;                         /**< Calibration General A-Side Registers, offset: 0x43C */
  __IO uint32_t CAL_GAR16;                         /**< Calibration General A-Side Registers, offset: 0x440 */
  __IO uint32_t CAL_GAR17;                         /**< Calibration General A-Side Registers, offset: 0x444 */
  __IO uint32_t CAL_GAR18;                         /**< Calibration General A-Side Registers, offset: 0x448 */
  __IO uint32_t CAL_GAR19;                         /**< Calibration General A-Side Registers, offset: 0x44C */
  __IO uint32_t CAL_GAR20;                         /**< Calibration General A-Side Registers, offset: 0x450 */
  __IO uint32_t CAL_GAR21;                         /**< Calibration General A-Side Registers, offset: 0x454 */
  __IO uint32_t CAL_GAR22;                         /**< Calibration General A-Side Registers, offset: 0x458 */
  __IO uint32_t CAL_GAR23;                         /**< Calibration General A-Side Registers, offset: 0x45C */
  __IO uint32_t CAL_GAR24;                         /**< Calibration General A-Side Registers, offset: 0x460 */
  __IO uint32_t CAL_GAR25;                         /**< Calibration General A-Side Registers, offset: 0x464 */
  __IO uint32_t CAL_GAR26;                         /**< Calibration General A-Side Registers, offset: 0x468 */
  __IO uint32_t CAL_GAR27;                         /**< Calibration General A-Side Registers, offset: 0x46C */
  __IO uint32_t CAL_GAR28;                         /**< Calibration General A-Side Registers, offset: 0x470 */
  __IO uint32_t CAL_GAR29;                         /**< Calibration General A-Side Registers, offset: 0x474 */
  __IO uint32_t CAL_GAR30;                         /**< Calibration General A-Side Registers, offset: 0x478 */
  __IO uint32_t CAL_GAR31;                         /**< Calibration General A-Side Registers, offset: 0x47C */
  __IO uint32_t CAL_GAR32;                         /**< Calibration General A-Side Registers, offset: 0x480 */
       uint8_t RESERVED_9[124];
  __IO uint32_t CAL_GBR0;                          /**< Calibration General B-Side Registers, offset: 0x500 */
  __IO uint32_t CAL_GBR1;                          /**< Calibration General B-Side Registers, offset: 0x504 */
  __IO uint32_t CAL_GBR2;                          /**< Calibration General B-Side Registers, offset: 0x508 */
  __IO uint32_t CAL_GBR3;                          /**< Calibration General B-Side Registers, offset: 0x50C */
  __IO uint32_t CAL_GBR4;                          /**< Calibration General B-Side Registers, offset: 0x510 */
  __IO uint32_t CAL_GBR5;                          /**< Calibration General B-Side Registers, offset: 0x514 */
  __IO uint32_t CAL_GBR6;                          /**< Calibration General B-Side Registers, offset: 0x518 */
  __IO uint32_t CAL_GBR7;                          /**< Calibration General B-Side Registers, offset: 0x51C */
  __IO uint32_t CAL_GBR8;                          /**< Calibration General B-Side Registers, offset: 0x520 */
  __IO uint32_t CAL_GBR9;                          /**< Calibration General B-Side Registers, offset: 0x524 */
  __IO uint32_t CAL_GBR10;                         /**< Calibration General B-Side Registers, offset: 0x528 */
  __IO uint32_t CAL_GBR11;                         /**< Calibration General B-Side Registers, offset: 0x52C */
  __IO uint32_t CAL_GBR12;                         /**< Calibration General B-Side Registers, offset: 0x530 */
  __IO uint32_t CAL_GBR13;                         /**< Calibration General B-Side Registers, offset: 0x534 */
  __IO uint32_t CAL_GBR14;                         /**< Calibration General B-Side Registers, offset: 0x538 */
  __IO uint32_t CAL_GBR15;                         /**< Calibration General B-Side Registers, offset: 0x53C */
  __IO uint32_t CAL_GBR16;                         /**< Calibration General B-Side Registers, offset: 0x540 */
  __IO uint32_t CAL_GBR17;                         /**< Calibration General B-Side Registers, offset: 0x544 */
  __IO uint32_t CAL_GBR18;                         /**< Calibration General B-Side Registers, offset: 0x548 */
  __IO uint32_t CAL_GBR19;                         /**< Calibration General B-Side Registers, offset: 0x54C */
  __IO uint32_t CAL_GBR20;                         /**< Calibration General B-Side Registers, offset: 0x550 */
  __IO uint32_t CAL_GBR21;                         /**< Calibration General B-Side Registers, offset: 0x554 */
  __IO uint32_t CAL_GBR22;                         /**< Calibration General B-Side Registers, offset: 0x558 */
  __IO uint32_t CAL_GBR23;                         /**< Calibration General B-Side Registers, offset: 0x55C */
  __IO uint32_t CAL_GBR24;                         /**< Calibration General B-Side Registers, offset: 0x560 */
  __IO uint32_t CAL_GBR25;                         /**< Calibration General B-Side Registers, offset: 0x564 */
  __IO uint32_t CAL_GBR26;                         /**< Calibration General B-Side Registers, offset: 0x568 */
  __IO uint32_t CAL_GBR27;                         /**< Calibration General B-Side Registers, offset: 0x56C */
  __IO uint32_t CAL_GBR28;                         /**< Calibration General B-Side Registers, offset: 0x570 */
  __IO uint32_t CAL_GBR29;                         /**< Calibration General B-Side Registers, offset: 0x574 */
  __IO uint32_t CAL_GBR30;                         /**< Calibration General B-Side Registers, offset: 0x578 */
  __IO uint32_t CAL_GBR31;                         /**< Calibration General B-Side Registers, offset: 0x57C */
  __IO uint32_t CAL_GBR32;                         /**< Calibration General B-Side Registers, offset: 0x580 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define ADC_VERID_RES_MASK                       (0x1U)
#define ADC_VERID_RES_SHIFT                      (0U)
/*! RES - Resolution
 *  0b0..Up to 13-bit differential or 12-bit single-ended resolution supported.
 *  0b1..Up to 16-bit differential or 16-bit single-ended resolution supported. CMDLn[MODE] available for
 *       selecting the resolution of conversions for the associated command.
 */
#define ADC_VERID_RES(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)

#define ADC_VERID_DIFFEN_MASK                    (0x2U)
#define ADC_VERID_DIFFEN_SHIFT                   (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Not supported
 *  0b1..Supported. CMDLn[CTYPE] controls fields implemented.
 */
#define ADC_VERID_DIFFEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)

#define ADC_VERID_MVI_MASK                       (0x8U)
#define ADC_VERID_MVI_SHIFT                      (3U)
/*! MVI - Multiple Vref Implemented
 *  0b0..Single VREFH input supported.
 *  0b1..Multiple VREFH inputs supported.
 */
#define ADC_VERID_MVI(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)

#define ADC_VERID_CSW_MASK                       (0x70U)
#define ADC_VERID_CSW_SHIFT                      (4U)
/*! CSW - Channel Scale Width
 *  0b000..Not supported.
 *  0b001..Supported with one-bit CSCALE control field.
 *  0b110..Supported with six-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)

#define ADC_VERID_VR1RNGI_MASK                   (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT                  (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required.
 *  0b1..Range control required.
 */
#define ADC_VERID_VR1RNGI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)

#define ADC_VERID_IADCKI_MASK                    (0x200U)
#define ADC_VERID_IADCKI_SHIFT                   (9U)
/*! IADCKI - Internal ADC Clock Implemented
 *  0b0..Not implemented
 *  0b1..Implemented
 */
#define ADC_VERID_IADCKI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)

#define ADC_VERID_CALOFSI_MASK                   (0x400U)
#define ADC_VERID_CALOFSI_SHIFT                  (10U)
/*! CALOFSI - Calibration Function Implemented
 *  0b0..Not implemented
 *  0b1..Implemented
 */
#define ADC_VERID_CALOFSI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)

#define ADC_VERID_NUM_SEC_MASK                   (0x800U)
#define ADC_VERID_NUM_SEC_SHIFT                  (11U)
/*! NUM_SEC - Number of Single-Ended Outputs Supported
 *  0b0..One
 *  0b1..Two
 */
#define ADC_VERID_NUM_SEC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_SEC_SHIFT)) & ADC_VERID_NUM_SEC_MASK)

#define ADC_VERID_NUM_FIFO_MASK                  (0x7000U)
#define ADC_VERID_NUM_FIFO_SHIFT                 (12U)
/*! NUM_FIFO - Number of FIFOs
 *  0b000..N/A
 *  0b001..One
 *  0b010..Two
 *  0b011..Three
 *  0b100..Four
 */
#define ADC_VERID_NUM_FIFO(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_FIFO_SHIFT)) & ADC_VERID_NUM_FIFO_MASK)

#define ADC_VERID_MINOR_MASK                     (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number */
#define ADC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)

#define ADC_VERID_MAJOR_MASK                     (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number */
#define ADC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)

#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..2
 *  0b00000100..4
 *  0b00001000..8
 *  0b00010000..16
 *  0b00100000..32
 *  0b01000000..64
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)

#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)

#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - Control Register */
/*! @{ */

#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - ADC Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)

#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)

#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in low-power mode.
 *  0b1..ADC is disabled in low-power mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)

#define ADC_CTRL_CAL_REQ_MASK                    (0x8U)
#define ADC_CTRL_CAL_REQ_SHIFT                   (3U)
/*! CAL_REQ - Auto-Calibration Request
 *  0b0..No request made.
 *  0b1..Request has been made.
 */
#define ADC_CTRL_CAL_REQ(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_REQ_SHIFT)) & ADC_CTRL_CAL_REQ_MASK)

#define ADC_CTRL_CALOFS_MASK                     (0x10U)
#define ADC_CTRL_CALOFS_SHIFT                    (4U)
/*! CALOFS - Offset Calibration Request
 *  0b0..Calibration function disabled
 *  0b1..Request for offset calibration function
 */
#define ADC_CTRL_CALOFS(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CALOFS_SHIFT)) & ADC_CTRL_CALOFS_MASK)

#define ADC_CTRL_RSTFIFO0_MASK                   (0x100U)
#define ADC_CTRL_RSTFIFO0_SHIFT                  (8U)
/*! RSTFIFO0 - Reset FIFO 0
 *  0b0..No effect.
 *  0b1..FIFO 0 is reset.
 */
#define ADC_CTRL_RSTFIFO0(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO0_SHIFT)) & ADC_CTRL_RSTFIFO0_MASK)

#define ADC_CTRL_RSTFIFO1_MASK                   (0x200U)
#define ADC_CTRL_RSTFIFO1_SHIFT                  (9U)
/*! RSTFIFO1 - Reset FIFO 1
 *  0b0..No effect.
 *  0b1..FIFO 1 is reset.
 */
#define ADC_CTRL_RSTFIFO1(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO1_SHIFT)) & ADC_CTRL_RSTFIFO1_MASK)

#define ADC_CTRL_CAL_AVGS_MASK                   (0xF0000U)
#define ADC_CTRL_CAL_AVGS_SHIFT                  (16U)
/*! CAL_AVGS - Auto-Calibration Averages
 *  0b0000..Single conversion.
 *  0b0001..2 conversions averaged.
 *  0b0010..4 conversions averaged.
 *  0b0011..8 conversions averaged.
 *  0b0100..16 conversions averaged.
 *  0b0101..32 conversions averaged.
 *  0b0110..64 conversions averaged.
 *  0b0111..128 conversions averaged.
 *  0b1000..256 conversions averaged.
 *  0b1001..512 conversions averaged.
 *  0b1010..1024 conversions averaged.
 */
#define ADC_CTRL_CAL_AVGS(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_AVGS_SHIFT)) & ADC_CTRL_CAL_AVGS_MASK)
/*! @} */

/*! @name STAT - Status Register */
/*! @{ */

#define ADC_STAT_RDY0_MASK                       (0x1U)
#define ADC_STAT_RDY0_SHIFT                      (0U)
/*! RDY0 - Result FIFO 0 Ready Flag
 *  0b0..Not above watermark
 *  0b1..Above watermark
 */
#define ADC_STAT_RDY0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY0_SHIFT)) & ADC_STAT_RDY0_MASK)

#define ADC_STAT_FOF0_MASK                       (0x2U)
#define ADC_STAT_FOF0_SHIFT                      (1U)
/*! FOF0 - Result FIFO 0 Overflow Flag
 *  0b0..No result FIFO 0 overflow has occurred since the last time that the flag was cleared.
 *  0b1..At least one result FIFO 0 overflow has occurred since the last time that the flag was cleared.
 */
#define ADC_STAT_FOF0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF0_SHIFT)) & ADC_STAT_FOF0_MASK)

#define ADC_STAT_RDY1_MASK                       (0x4U)
#define ADC_STAT_RDY1_SHIFT                      (2U)
/*! RDY1 - Result FIFO1 Ready Flag
 *  0b0..Not above watermark
 *  0b1..Above watermark
 */
#define ADC_STAT_RDY1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY1_SHIFT)) & ADC_STAT_RDY1_MASK)

#define ADC_STAT_FOF1_MASK                       (0x8U)
#define ADC_STAT_FOF1_SHIFT                      (3U)
/*! FOF1 - Result FIFO1 Overflow Flag
 *  0b0..No result FIFO1 overflow has occurred since the last time that the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time that the flag was cleared.
 */
#define ADC_STAT_FOF1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF1_SHIFT)) & ADC_STAT_FOF1_MASK)

#define ADC_STAT_TEXC_INT_MASK                   (0x100U)
#define ADC_STAT_TEXC_INT_SHIFT                  (8U)
/*! TEXC_INT - Interrupt Flag For High-Priority Trigger Exception
 *  0b0..No trigger exceptions have occurred.
 *  0b1..A trigger exception has occurred and is pending acknowledgment.
 */
#define ADC_STAT_TEXC_INT(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TEXC_INT_SHIFT)) & ADC_STAT_TEXC_INT_MASK)

#define ADC_STAT_TCOMP_INT_MASK                  (0x200U)
#define ADC_STAT_TCOMP_INT_SHIFT                 (9U)
/*! TCOMP_INT - Interrupt Flag For Trigger Completion
 *  0b0..Either IE[TCOMP_IE] = 0, or no trigger sequences have run to completion.
 *  0b1..Trigger sequence has been completed and all data is stored in the associated FIFO.
 */
#define ADC_STAT_TCOMP_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TCOMP_INT_SHIFT)) & ADC_STAT_TCOMP_INT_MASK)

#define ADC_STAT_CAL_RDY_MASK                    (0x400U)
#define ADC_STAT_CAL_RDY_SHIFT                   (10U)
/*! CAL_RDY - Calibration Ready
 *  0b0..Calibration is incomplete or has not been run.
 *  0b1..ADC is calibrated.
 */
#define ADC_STAT_CAL_RDY(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CAL_RDY_SHIFT)) & ADC_STAT_CAL_RDY_MASK)

#define ADC_STAT_ADC_ACTIVE_MASK                 (0x800U)
#define ADC_STAT_ADC_ACTIVE_SHIFT                (11U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..ADC is idle. There are no pending triggers to service and no active commands are being processed.
 *  0b1..ADC is processing a conversion, running through the power-up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)

#define ADC_STAT_TRGACT_MASK                     (0x30000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b00..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b01..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b10..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b11..Command (sequence) associated with Trigger 3 currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)

#define ADC_STAT_CMDACT_MASK                     (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b0000..No command currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b0011-0b1111..Associated command number currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */

#define ADC_IE_FWMIE0_MASK                       (0x1U)
#define ADC_IE_FWMIE0_SHIFT                      (0U)
/*! FWMIE0 - FIFO 0 Watermark Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_FWMIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE0_SHIFT)) & ADC_IE_FWMIE0_MASK)

#define ADC_IE_FOFIE0_MASK                       (0x2U)
#define ADC_IE_FOFIE0_SHIFT                      (1U)
/*! FOFIE0 - Result FIFO 0 Overflow Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_FOFIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE0_SHIFT)) & ADC_IE_FOFIE0_MASK)

#define ADC_IE_FWMIE1_MASK                       (0x4U)
#define ADC_IE_FWMIE1_SHIFT                      (2U)
/*! FWMIE1 - FIFO1 Watermark Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_FWMIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE1_SHIFT)) & ADC_IE_FWMIE1_MASK)

#define ADC_IE_FOFIE1_MASK                       (0x8U)
#define ADC_IE_FOFIE1_SHIFT                      (3U)
/*! FOFIE1 - Result FIFO1 Overflow Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_FOFIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE1_SHIFT)) & ADC_IE_FOFIE1_MASK)

#define ADC_IE_TEXC_IE_MASK                      (0x100U)
#define ADC_IE_TEXC_IE_SHIFT                     (8U)
/*! TEXC_IE - Trigger Exception Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_TEXC_IE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_IE_TEXC_IE_SHIFT)) & ADC_IE_TEXC_IE_MASK)

#define ADC_IE_TCOMP_IE_MASK                     (0xF0000U)
#define ADC_IE_TCOMP_IE_SHIFT                    (16U)
/*! TCOMP_IE - Trigger Completion Interrupt Enable
 *  0b0000..All disabled
 *  0b0001..Trigger completion interrupts are enabled for trigger source 0 only.
 *  0b0010..Trigger completion interrupts are enabled for trigger source 1 only.
 *  0b0011-0b1110..Associated trigger completion interrupts are enabled.
 *  0b1111..All enabled
 */
#define ADC_IE_TCOMP_IE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_IE_TCOMP_IE_SHIFT)) & ADC_IE_TCOMP_IE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */

#define ADC_DE_FWMDE0_MASK                       (0x1U)
#define ADC_DE_FWMDE0_SHIFT                      (0U)
/*! FWMDE0 - FIFO 0 Watermark DMA Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_DE_FWMDE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE0_SHIFT)) & ADC_DE_FWMDE0_MASK)

#define ADC_DE_FWMDE1_MASK                       (0x2U)
#define ADC_DE_FWMDE1_SHIFT                      (1U)
/*! FWMDE1 - FIFO1 Watermark DMA Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_DE_FWMDE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE1_SHIFT)) & ADC_DE_FWMDE1_MASK)
/*! @} */

/*! @name CFG - Configuration Register */
/*! @{ */

#define ADC_CFG_TPRICTRL_MASK                    (0x3U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - ADC Trigger Priority Control
 *  0b00..Current conversion is aborted and the new command specified by the trigger is started.
 *  0b01..Current command is stopped after completing the current conversion. If averaging is enabled, the
 *        averaging loop is completed. CMDHn[LOOP] is ignored and the higher-priority trigger is serviced.
 *  0b10..Current command is completed (averaging, looping, compare) before servicing the higher-priority trigger.
 *  0b11..
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)

#define ADC_CFG_PWRSEL_MASK                      (0x30U)
#define ADC_CFG_PWRSEL_SHIFT                     (4U)
/*! PWRSEL - Power Configuration Select
 *  0b0x..Low power
 *  0b1x..High power
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)

#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..Option 1
 *  0b01..Option 2
 *  0b10..Option 3
 *  0b11..
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)

#define ADC_CFG_TRES_MASK                        (0x100U)
#define ADC_CFG_TRES_SHIFT                       (8U)
/*! TRES - Trigger Resume Enable
 *  0b0..Not automatically resumed or restarted
 *  0b1..Automatically resumed or restarted
 */
#define ADC_CFG_TRES(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TRES_SHIFT)) & ADC_CFG_TRES_MASK)

#define ADC_CFG_TCMDRES_MASK                     (0x200U)
#define ADC_CFG_TCMDRES_SHIFT                    (9U)
/*! TCMDRES - Trigger Command Resume
 *  0b0..Trigger sequence automatically restarted.
 *  0b1..Trigger sequence resumed from the command that was executed prior to the exception.
 */
#define ADC_CFG_TCMDRES(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TCMDRES_SHIFT)) & ADC_CFG_TCMDRES_MASK)

#define ADC_CFG_HPT_EXDI_MASK                    (0x400U)
#define ADC_CFG_HPT_EXDI_SHIFT                   (10U)
/*! HPT_EXDI - High-Priority Trigger Exception Disable
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define ADC_CFG_HPT_EXDI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_HPT_EXDI_SHIFT)) & ADC_CFG_HPT_EXDI_MASK)

#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power-up Delay */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)

#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Analog startup delays affect performance.
 *  0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays, at the cost
 *       of higher DC current consumption. A single power-up delay (CFG[PUDLY]) is executed immediately once PWREN
 *       is set. No detected triggers begin ADC operation until the power-up delay time has passed. After this
 *       initial delay expires, the analog circuits remain pre-enabled, and no additional delays are executed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - Pause Register */
/*! @{ */

#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)

#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - Pause Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */

#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software Trigger 0
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)

#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software Trigger 1
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)

#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software Trigger 2
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)

#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software Trigger 3
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)
/*! @} */

/*! @name TSTAT - Trigger Status Register */
/*! @{ */

#define ADC_TSTAT_TEXC_NUM_MASK                  (0xFU)
#define ADC_TSTAT_TEXC_NUM_SHIFT                 (0U)
/*! TEXC_NUM - Trigger Exception Number
 *  0b0000..No triggers have been interrupted by a high-priority exception.
 *  0b0001..Trigger 0 has been interrupted by a high-priority exception.
 *  0b0010..Trigger 1 has been interrupted by a high-priority exception.
 *  0b0011-0b1110..Associated trigger sequence has interrupted by a high-priority exception.
 *  0b1111..Every trigger sequence has been interrupted by a high-priority exception.
 */
#define ADC_TSTAT_TEXC_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TEXC_NUM_SHIFT)) & ADC_TSTAT_TEXC_NUM_MASK)

#define ADC_TSTAT_TCOMP_FLAG_MASK                (0xF0000U)
#define ADC_TSTAT_TCOMP_FLAG_SHIFT               (16U)
/*! TCOMP_FLAG - Trigger Completion Flag
 *  0b0000..No triggers have been completed. Trigger completion interrupts are disabled.
 *  0b0001..Trigger 0 has been completed and trigger 0 has enabled completion interrupts.
 *  0b0010..Trigger 1 has been completed and trigger 1 has enabled completion interrupts.
 *  0b0011-0b1110..Associated trigger sequence has completed and has enabled completion interrupts.
 *  0b1111..Every trigger sequence has been completed and every trigger has enabled completion interrupts.
 */
#define ADC_TSTAT_TCOMP_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TCOMP_FLAG_SHIFT)) & ADC_TSTAT_TCOMP_FLAG_MASK)
/*! @} */

/*! @name OFSTRIM - Offset Trim Register */
/*! @{ */

#define ADC_OFSTRIM_OFSTRIM_A_MASK               (0x1FU)
#define ADC_OFSTRIM_OFSTRIM_A_SHIFT              (0U)
/*! OFSTRIM_A - Trim for Offset */
#define ADC_OFSTRIM_OFSTRIM_A(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_A_SHIFT)) & ADC_OFSTRIM_OFSTRIM_A_MASK)

#define ADC_OFSTRIM_OFSTRIM_B_MASK               (0x1F0000U)
#define ADC_OFSTRIM_OFSTRIM_B_SHIFT              (16U)
/*! OFSTRIM_B - Trim for Offset */
#define ADC_OFSTRIM_OFSTRIM_B(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_B_SHIFT)) & ADC_OFSTRIM_OFSTRIM_B_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */

#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)

#define ADC_TCTRL_FIFO_SEL_A_MASK                (0x2U)
#define ADC_TCTRL_FIFO_SEL_A_SHIFT               (1U)
/*! FIFO_SEL_A - SAR Result Destination for Channel A
 *  0b0..FIFO 0
 *  0b1..FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_A(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_A_SHIFT)) & ADC_TCTRL_FIFO_SEL_A_MASK)

#define ADC_TCTRL_FIFO_SEL_B_MASK                (0x4U)
#define ADC_TCTRL_FIFO_SEL_B_SHIFT               (2U)
/*! FIFO_SEL_B - SAR Result Destination for Channel B
 *  0b0..FIFO 0
 *  0b1..FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_B(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_B_SHIFT)) & ADC_TCTRL_FIFO_SEL_B_MASK)

#define ADC_TCTRL_TPRI_MASK                      (0x300U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger Priority Setting
 *  0b00..Highest priority, Level 1
 *  0b01-0b10..Set to corresponding priority level.
 *  0b11..Lowest priority, Level 4
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)

#define ADC_TCTRL_RSYNC_MASK                     (0x8000U)
#define ADC_TCTRL_RSYNC_SHIFT                    (15U)
/*! RSYNC - Trigger Resync
 *  0b0..Disable
 *  0b1..Enable
 */
#define ADC_TCTRL_RSYNC(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_RSYNC_SHIFT)) & ADC_TCTRL_RSYNC_MASK)

#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger Delay Select */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)

#define ADC_TCTRL_TCMD_MASK                      (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger Command Select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (4U)

/*! @name FCTRL - FIFO Control Register */
/*! @{ */

#define ADC_FCTRL_FCOUNT_MASK                    (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO Counter */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)

#define ADC_FCTRL_FWMARK_MASK                    (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark Level Selection */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/* The count of ADC_FCTRL */
#define ADC_FCTRL_COUNT                          (2U)

/*! @name GCC - Gain Calibration Control */
/*! @{ */

#define ADC_GCC_GAIN_CAL_MASK                    (0xFFFFU)
#define ADC_GCC_GAIN_CAL_SHIFT                   (0U)
/*! GAIN_CAL - Gain Calibration Value */
#define ADC_GCC_GAIN_CAL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_GCC_GAIN_CAL_SHIFT)) & ADC_GCC_GAIN_CAL_MASK)

#define ADC_GCC_RDY_MASK                         (0x1000000U)
#define ADC_GCC_RDY_SHIFT                        (24U)
/*! RDY - Gain Calibration Value Valid
 *  0b0..Invalid
 *  0b1..Valid
 */
#define ADC_GCC_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCC_RDY_SHIFT)) & ADC_GCC_RDY_MASK)
/*! @} */

/* The count of ADC_GCC */
#define ADC_GCC_COUNT                            (2U)

/*! @name GCR - Gain Calculation Result */
/*! @{ */

#define ADC_GCR_GCALR_MASK                       (0xFFFFU)
#define ADC_GCR_GCALR_SHIFT                      (0U)
/*! GCALR - Gain Calculation Result */
#define ADC_GCR_GCALR(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_GCR_GCALR_SHIFT)) & ADC_GCR_GCALR_MASK)

#define ADC_GCR_RDY_MASK                         (0x1000000U)
#define ADC_GCR_RDY_SHIFT                        (24U)
/*! RDY - Gain Calculation Ready
 *  0b0..Invalid
 *  0b1..Valid
 */
#define ADC_GCR_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCR_RDY_SHIFT)) & ADC_GCR_RDY_MASK)
/*! @} */

/* The count of ADC_GCR */
#define ADC_GCR_COUNT                            (2U)

/*! @name CMDL - Command Low Buffer Register */
/*! @{ */

#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input Channel Select
 *  0b00000..CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)

#define ADC_CMDL_CTYPE_MASK                      (0x60U)
#define ADC_CMDL_CTYPE_SHIFT                     (5U)
/*! CTYPE - Conversion Type
 *  0b00..Single-Ended mode. Only A-side channel is converted.
 *  0b01..Single-Ended mode. Only B-side channel is converted.
 *  0b10..Differential mode. A-B.
 *  0b11..Dual-Single-Ended mode. Both A-side and B-side channels are converted independently.
 */
#define ADC_CMDL_CTYPE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CTYPE_SHIFT)) & ADC_CMDL_CTYPE_MASK)

#define ADC_CMDL_MODE_MASK                       (0x80U)
#define ADC_CMDL_MODE_SHIFT                      (7U)
/*! MODE - Select Resolution of Conversions
 *  0b0..Standard resolution. Single-ended 12-bit conversion; differential 13-bit conversion with 2's complement output.
 *  0b1..High resolution. Single-ended 16-bit conversion; differential 16-bit conversion with 2's complement output.
 */
#define ADC_CMDL_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_MODE_SHIFT)) & ADC_CMDL_MODE_MASK)

#define ADC_CMDL_ALTB_ADCH_MASK                  (0x1F0000U)
#define ADC_CMDL_ALTB_ADCH_SHIFT                 (16U)
/*! ALTB_ADCH - Alternate Channel B Input Channel Select
 *  0b00000..Select CH0B
 *  0b00001..Select CH1B
 *  0b00010..Select CH2B
 *  0b00011..Select CH3B
 *  0b00100-0b11101..Select corresponding channel CHnB
 *  0b11110..Select CH30B
 *  0b11111..Select CH31B
 */
#define ADC_CMDL_ALTB_ADCH(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ALTB_ADCH_SHIFT)) & ADC_CMDL_ALTB_ADCH_MASK)

#define ADC_CMDL_ALTBEN_MASK                     (0x200000U)
#define ADC_CMDL_ALTBEN_SHIFT                    (21U)
/*! ALTBEN - Alternate Channel B Select Enable
 *  0b0..ALTBEN_ADCH disabled. Channel-A and Channel-B inputs are selected based on ADCH settings.
 *  0b1..ALTBEN_ADCH enabled. Channel-A inputs are selected by ADCH setting and Channel-B inputs are selected by ALTB_ADCH setting.
 */
#define ADC_CMDL_ALTBEN(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ALTBEN_SHIFT)) & ADC_CMDL_ALTBEN_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (15U)

/*! @name CMDH - Command High Buffer Register */
/*! @{ */

#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Disabled
 *  0b01..
 *  0b10..Enabled. Store on true.
 *  0b11..Enabled. Repeat channel acquisition (sample, convert, and compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)

#define ADC_CMDH_WAIT_TRIG_MASK                  (0x4U)
#define ADC_CMDH_WAIT_TRIG_SHIFT                 (2U)
/*! WAIT_TRIG - Wait for Trigger Assertion Before Execution
 *  0b0..Command executes automatically.
 *  0b1..Active trigger must be asserted again before executing this command.
 */
#define ADC_CMDH_WAIT_TRIG(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_WAIT_TRIG_SHIFT)) & ADC_CMDH_WAIT_TRIG_MASK)

#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)

#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3.5 ADCK cycles.
 *  0b001..5.5 ADCK cycles
 *  0b010..7.5 ADCK cycles
 *  0b011..11.5 ADCK cycles
 *  0b100..19.5 ADCK cycles
 *  0b101..35.5 ADCK cycles
 *  0b110..67.5 ADCK cycles
 *  0b111..131.5 ADCK cycles
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)

#define ADC_CMDH_AVGS_MASK                       (0xF000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b0000..Single conversion
 *  0b0001..2
 *  0b0010..4
 *  0b0011..8
 *  0b0100..16
 *  0b0101..32
 *  0b0110..64
 *  0b0111..128
 *  0b1000..256
 *  0b1001..512
 *  0b1010..1024
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)

#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes one time.
 *  0b0001..Loop one time. Command executes two times.
 *  0b0010..Loop two times. Command executes three times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP + 1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)

#define ADC_CMDH_NEXT_MASK                       (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..CMD1
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..CMD15
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (15U)

/*! @name CV - Compare Value Register */
/*! @{ */

#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)

#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (15U)

/*! @name RESFIFO - Data Result FIFO Register */
/*! @{ */

#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data Result */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)

#define ADC_RESFIFO_TSRC_MASK                    (0x30000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b00..Trigger source 0
 *  0b01..Trigger source 1
 *  0b10..Trigger source 2
 *  0b11..Trigger source 3
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)

#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop Count Value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from (LOOPCNT + 1) conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)

#define ADC_RESFIFO_CMDSRC_MASK                  (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a data word in RESFIFO. 0h is only found in the initial FIFO state,
 *          prior to the storage of an ADC conversion result into a RESFIFO buffer.
 *  0b0001..CMD1
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)

#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO Entry is Valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO contains data. FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */

/* The count of ADC_RESFIFO */
#define ADC_RESFIFO_COUNT                        (2U)

/*! @name CAL_GAR0 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR0_CAL_GAR_VAL_MASK            (0x7FFU)
#define ADC_CAL_GAR0_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR0_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR0_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR0_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR1 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR1_CAL_GAR_VAL_MASK            (0xFFFU)
#define ADC_CAL_GAR1_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR1_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR1_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR1_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR2 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR2_CAL_GAR_VAL_MASK            (0x1FFFU)
#define ADC_CAL_GAR2_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR2_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR2_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR2_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR3 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR3_CAL_GAR_VAL_MASK            (0x1FFFU)
#define ADC_CAL_GAR3_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR3_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR3_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR3_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR4 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR4_CAL_GAR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GAR4_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR4_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR4_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR4_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR5 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR5_CAL_GAR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GAR5_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR5_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR5_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR5_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR6 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR6_CAL_GAR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GAR6_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR6_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR6_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR6_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR7 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR7_CAL_GAR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GAR7_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR7_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR7_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR7_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR8 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR8_CAL_GAR_VAL_MASK            (0x7FFFU)
#define ADC_CAL_GAR8_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR8_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR8_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR8_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR9 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR9_CAL_GAR_VAL_MASK            (0x7FFFU)
#define ADC_CAL_GAR9_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR9_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR9_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR9_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR10 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR10_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR10_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR10_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR10_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR10_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR11 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR11_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR11_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR11_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR11_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR11_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR12 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR12_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR12_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR12_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR12_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR12_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR13 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR13_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR13_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR13_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR13_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR13_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR14 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR14_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR14_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR14_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR14_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR14_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR15 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR15_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR15_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR15_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR15_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR15_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR16 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR16_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR16_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR16_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR16_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR16_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR17 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR17_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR17_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR17_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR17_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR17_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR18 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR18_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR18_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR18_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR18_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR18_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR19 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR19_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR19_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR19_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR19_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR19_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR20 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR20_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR20_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR20_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR20_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR20_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR21 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR21_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR21_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR21_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR21_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR21_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR22 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR22_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR22_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR22_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR22_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR22_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR23 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR23_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR23_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR23_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR23_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR23_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR24 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR24_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR24_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR24_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR24_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR24_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR25 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR25_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR25_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR25_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR25_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR25_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR26 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR26_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR26_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR26_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR26_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR26_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR27 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR27_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR27_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR27_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR27_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR27_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR28 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR28_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR28_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR28_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR28_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR28_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR29 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR29_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR29_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR29_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR29_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR29_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR30 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR30_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR30_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR30_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR30_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR30_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR31 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR31_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR31_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR31_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR31_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR31_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR32 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR32_CAL_GAR_VAL_MASK           (0x7FFU)
#define ADC_CAL_GAR32_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR32_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR32_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR32_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR0 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR0_CAL_GBR_VAL_MASK            (0x7FFU)
#define ADC_CAL_GBR0_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR0_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR0_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR0_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR1 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR1_CAL_GBR_VAL_MASK            (0xFFFU)
#define ADC_CAL_GBR1_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR1_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR1_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR1_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR2 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR2_CAL_GBR_VAL_MASK            (0x1FFFU)
#define ADC_CAL_GBR2_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR2_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR2_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR2_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR3 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR3_CAL_GBR_VAL_MASK            (0x1FFFU)
#define ADC_CAL_GBR3_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR3_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR3_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR3_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR4 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR4_CAL_GBR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GBR4_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR4_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR4_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR4_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR5 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR5_CAL_GBR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GBR5_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR5_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR5_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR5_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR6 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR6_CAL_GBR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GBR6_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR6_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR6_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR6_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR7 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR7_CAL_GBR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GBR7_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR7_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR7_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR7_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR8 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR8_CAL_GBR_VAL_MASK            (0x7FFFU)
#define ADC_CAL_GBR8_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR8_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR8_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR8_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR9 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR9_CAL_GBR_VAL_MASK            (0x7FFFU)
#define ADC_CAL_GBR9_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR9_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR9_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR9_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR10 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR10_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR10_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR10_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR10_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR10_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR11 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR11_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR11_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR11_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR11_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR11_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR12 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR12_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR12_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR12_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR12_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR12_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR13 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR13_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR13_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR13_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR13_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR13_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR14 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR14_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR14_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR14_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR14_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR14_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR15 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR15_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR15_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR15_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR15_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR15_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR16 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR16_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR16_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR16_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR16_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR16_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR17 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR17_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR17_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR17_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR17_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR17_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR18 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR18_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR18_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR18_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR18_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR18_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR19 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR19_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR19_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR19_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR19_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR19_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR20 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR20_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR20_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR20_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR20_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR20_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR21 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR21_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR21_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR21_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR21_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR21_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR22 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR22_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR22_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR22_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR22_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR22_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR23 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR23_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR23_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR23_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR23_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR23_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR24 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR24_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR24_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR24_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR24_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR24_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR25 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR25_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR25_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR25_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR25_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR25_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR26 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR26_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR26_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR26_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR26_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR26_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR27 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR27_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR27_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR27_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR27_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR27_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR28 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR28_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR28_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR28_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR28_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR28_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR29 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR29_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR29_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR29_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR29_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR29_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR30 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR30_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR30_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR30_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR30_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR30_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR31 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR31_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR31_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR31_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR31_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR31_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR32 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR32_CAL_GBR_VAL_MASK           (0x7FFU)
#define ADC_CAL_GBR32_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR32_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR32_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR32_CAL_GBR_VAL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x5010D000u)
  /** Peripheral ADC0 base address */
  #define ADC0_BASE_NS                             (0x4010D000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Peripheral ADC0 base pointer */
  #define ADC0_NS                                  ((ADC_Type *)ADC0_BASE_NS)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE                                (0x5010E000u)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE_NS                             (0x4010E000u)
  /** Peripheral ADC1 base pointer */
  #define ADC1                                     ((ADC_Type *)ADC1_BASE)
  /** Peripheral ADC1 base pointer */
  #define ADC1_NS                                  ((ADC_Type *)ADC1_BASE_NS)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE, ADC1_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0, ADC1 }
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS_NS                        { ADC0_BASE_NS, ADC1_BASE_NS }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS_NS                         { ADC0_NS, ADC1_NS }
#else
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x4010D000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE                                (0x4010E000u)
  /** Peripheral ADC1 base pointer */
  #define ADC1                                     ((ADC_Type *)ADC1_BASE)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE, ADC1_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0, ADC1 }
#endif
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { ADC0_IRQn, ADC1_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AHBSC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHBSC_Peripheral_Access_Layer AHBSC Peripheral Access Layer
 * @{
 */

/** AHBSC - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t FLASH00_MEM_RULE[4];               /**< Flash Memory Rule, array offset: 0x10, array step: 0x4 */
       uint8_t RESERVED_1[16];
  __IO uint32_t FLASH02_MEM_RULE;                  /**< Flash Memory Rule, offset: 0x30 */
       uint8_t RESERVED_2[12];
  __IO uint32_t FLASH03_MEM_RULE;                  /**< Flash Memory Rule, offset: 0x40 */
       uint8_t RESERVED_3[28];
  __IO uint32_t ROM_MEM_RULE[4];                   /**< ROM Memory Rule, array offset: 0x60, array step: 0x4 */
       uint8_t RESERVED_4[16];
  __IO uint32_t RAMX_MEM_RULE[3];                  /**< RAMX Memory Rule, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_5[20];
  __IO uint32_t RAMA_MEM_RULE;                     /**< RAMA Memory Rule 0, offset: 0xA0 */
       uint8_t RESERVED_6[28];
  __IO uint32_t RAMB_MEM_RULE;                     /**< RAMB Memory Rule, offset: 0xC0 */
       uint8_t RESERVED_7[28];
  __IO uint32_t RAMC_MEM_RULE[2];                  /**< RAMC Memory Rule, array offset: 0xE0, array step: 0x4 */
       uint8_t RESERVED_8[24];
  __IO uint32_t RAMD_MEM_RULE[2];                  /**< RAMD Memory Rule, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_9[24];
  __IO uint32_t RAME_MEM_RULE[2];                  /**< RAME Memory Rule, array offset: 0x120, array step: 0x4 */
       uint8_t RESERVED_10[120];
  __IO uint32_t APB_PERIPHERAL_GROUP0_MEM_RULE0;   /**< APB Bridge Group 0 Memory Rule 0, offset: 0x1A0 */
  __IO uint32_t APB_PERIPHERAL_GROUP0_MEM_RULE1;   /**< APB Bridge Group 0 Memory Rule 1, offset: 0x1A4 */
  __IO uint32_t APB_PERIPHERAL_GROUP0_MEM_RULE2;   /**< APB Bridge Group 0 Rule 2, offset: 0x1A8 */
  __IO uint32_t APB_PERIPHERAL_GROUP0_MEM_RULE3;   /**< APB Bridge Group 0 Memory Rule 3, offset: 0x1AC */
  __IO uint32_t APB_PERIPHERAL_GROUP1_MEM_RULE0;   /**< APB Bridge Group 1 Memory Rule 0, offset: 0x1B0 */
  __IO uint32_t APB_PERIPHERAL_GROUP1_MEM_RULE1;   /**< APB Bridge Group 1 Memory Rule 1, offset: 0x1B4 */
       uint8_t RESERVED_11[4];
  __IO uint32_t APB_PERIPHERAL_GROUP1_MEM_RULE2;   /**< APB Bridge Group 1 Memory Rule 2, offset: 0x1BC */
  __IO uint32_t AIPS_BRIDGE_GROUP0_MEM_RULE0;      /**< AIPS Bridge Group 0 Memory Rule 0, offset: 0x1C0 */
  __IO uint32_t AIPS_BRIDGE_GROUP0_MEM_RULE1;      /**< AIPS Bridge Group 0 Memory Rule 1, offset: 0x1C4 */
  __IO uint32_t AIPS_BRIDGE_GROUP0_MEM_RULE2;      /**< AIPS Bridge Group 0 Memory Rule 2, offset: 0x1C8 */
  __IO uint32_t AIPS_BRIDGE_GROUP0_MEM_RULE3;      /**< AIPS Bridge Group 0 Memory Rule 3, offset: 0x1CC */
  __IO uint32_t AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0; /**< AHB Peripheral 0 Slave Port 12 Slave Rule 0, offset: 0x1D0 */
  __IO uint32_t AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1; /**< AHB Peripheral 0 Slave Port 12 Slave Rule 1, offset: 0x1D4 */
  __IO uint32_t AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2; /**< AHB Peripheral 0 Slave Port 12 Slave Rule 2, offset: 0x1D8 */
       uint8_t RESERVED_12[4];
  __IO uint32_t AIPS_BRIDGE_GROUP1_MEM_RULE0;      /**< AIPS Bridge Group 1 Rule 0, offset: 0x1E0 */
  __IO uint32_t AIPS_BRIDGE_GROUP1_MEM_RULE1;      /**< AIPS Bridge Group 1 Rule 1, offset: 0x1E4 */
       uint8_t RESERVED_13[8];
  __IO uint32_t AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0; /**< AHB Peripheral 1 Slave Port 13 Slave Rule 0, offset: 0x1F0 */
  __IO uint32_t AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1; /**< AHB Peripheral 1 Slave Port 13 Slave Rule 1, offset: 0x1F4 */
       uint32_t AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE2; /**< AHB Peripheral 1 Slave Port 13 Slave Rule 2, offset: 0x1F8 */
       uint8_t RESERVED_14[4];
  __IO uint32_t AIPS_BRIDGE_GROUP2_MEM_RULE0;      /**< AIPS Bridge Group 2 Rule 0, offset: 0x200 */
  __IO uint32_t AIPS_BRIDGE_GROUP2_MEM_RULE1;      /**< AIPS Bridge Group 2 Memory Rule 1, offset: 0x204 */
       uint8_t RESERVED_15[24];
  __IO uint32_t AIPS_BRIDGE_GROUP3_MEM_RULE0;      /**< AIPS Bridge Group 3 Rule 0, offset: 0x220 */
  __IO uint32_t AIPS_BRIDGE_GROUP3_MEM_RULE1;      /**< AIPS Bridge Group 3 Memory Rule 1, offset: 0x224 */
  __IO uint32_t AIPS_BRIDGE_GROUP3_MEM_RULE2;      /**< AIPS Bridge Group 3 Rule 2, offset: 0x228 */
  __IO uint32_t AIPS_BRIDGE_GROUP3_MEM_RULE3;      /**< AIPS Bridge Group 3 Rule 3, offset: 0x22C */
       uint8_t RESERVED_16[16];
  __IO uint32_t AIPS_BRIDGE_GROUP4_MEM_RULE0;      /**< AIPS Bridge Group 4 Rule 0, offset: 0x240 */
  __IO uint32_t AIPS_BRIDGE_GROUP4_MEM_RULE1;      /**< AIPS Bridge Group 4 Rule 1, offset: 0x244 */
  __IO uint32_t AIPS_BRIDGE_GROUP4_MEM_RULE2;      /**< AIPS Bridge Group 4 Rule 2, offset: 0x248 */
  __IO uint32_t AIPS_BRIDGE_GROUP4_MEM_RULE3;      /**< AIPS Bridge Group 4 Rule 3, offset: 0x24C */
  __IO uint32_t AHB_SECURE_CTRL_PERIPHERAL_RULE0;  /**< AHB Secure Control Peripheral Rule 0, offset: 0x250 */
       uint8_t RESERVED_17[2988];
  __I  uint32_t SEC_VIO_ADDR[32];                  /**< Security Violation Address, array offset: 0xE00, array step: 0x4 */
  __I  uint32_t SEC_VIO_MISC_INFO[32];             /**< Security Violation Miscellaneous Information at Address, array offset: 0xE80, array step: 0x4 */
  __IO uint32_t SEC_VIO_INFO_VALID;                /**< Security Violation Info Validity for Address, offset: 0xF00 */
       uint8_t RESERVED_18[124];
  __IO uint32_t SEC_GPIO_MASK[2];                  /**< GPIO Mask for Port 0..GPIO Mask for Port 1, array offset: 0xF80, array step: 0x4 */
       uint8_t RESERVED_19[72];
  __IO uint32_t MASTER_SEC_LEVEL;                  /**< Master Secure Level, offset: 0xFD0 */
  __IO uint32_t MASTER_SEC_ANTI_POL_REG;           /**< Master Secure Level, offset: 0xFD4 */
       uint8_t RESERVED_20[20];
  __IO uint32_t CPU0_LOCK_REG;                     /**< Miscellaneous CPU0 Control Signals, offset: 0xFEC */
       uint8_t RESERVED_21[8];
  __IO uint32_t MISC_CTRL_DP_REG;                  /**< Secure Control Duplicate, offset: 0xFF8 */
  __IO uint32_t MISC_CTRL_REG;                     /**< Secure Control, offset: 0xFFC */
} AHBSC_Type;

/* ----------------------------------------------------------------------------
   -- AHBSC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHBSC_Register_Masks AHBSC Register Masks
 * @{
 */

/*! @name FLASH00_MEM_RULE - Flash Memory Rule */
/*! @{ */

#define AHBSC_FLASH00_MEM_RULE_RULE0_MASK        (0x3U)
#define AHBSC_FLASH00_MEM_RULE_RULE0_SHIFT       (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE0_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE1_MASK        (0x30U)
#define AHBSC_FLASH00_MEM_RULE_RULE1_SHIFT       (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE1_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE2_MASK        (0x300U)
#define AHBSC_FLASH00_MEM_RULE_RULE2_SHIFT       (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE2(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE2_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE3_MASK        (0x3000U)
#define AHBSC_FLASH00_MEM_RULE_RULE3_SHIFT       (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE3(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE3_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE4_MASK        (0x30000U)
#define AHBSC_FLASH00_MEM_RULE_RULE4_SHIFT       (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE4(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE4_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE4_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE5_MASK        (0x300000U)
#define AHBSC_FLASH00_MEM_RULE_RULE5_SHIFT       (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE5(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE5_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE5_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE6_MASK        (0x3000000U)
#define AHBSC_FLASH00_MEM_RULE_RULE6_SHIFT       (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE6(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE6_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE6_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE7_MASK        (0x30000000U)
#define AHBSC_FLASH00_MEM_RULE_RULE7_SHIFT       (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE7(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE7_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_FLASH00_MEM_RULE */
#define AHBSC_FLASH00_MEM_RULE_COUNT             (4U)

/*! @name FLASH02_MEM_RULE - Flash Memory Rule */
/*! @{ */

#define AHBSC_FLASH02_MEM_RULE_RULE0_MASK        (0x3U)
#define AHBSC_FLASH02_MEM_RULE_RULE0_SHIFT       (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH02_MEM_RULE_RULE0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH02_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLASH02_MEM_RULE_RULE0_MASK)

#define AHBSC_FLASH02_MEM_RULE_RULE1_MASK        (0x30U)
#define AHBSC_FLASH02_MEM_RULE_RULE1_SHIFT       (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH02_MEM_RULE_RULE1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH02_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLASH02_MEM_RULE_RULE1_MASK)

#define AHBSC_FLASH02_MEM_RULE_RULE2_MASK        (0x300U)
#define AHBSC_FLASH02_MEM_RULE_RULE2_SHIFT       (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH02_MEM_RULE_RULE2(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH02_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLASH02_MEM_RULE_RULE2_MASK)

#define AHBSC_FLASH02_MEM_RULE_RULE3_MASK        (0x3000U)
#define AHBSC_FLASH02_MEM_RULE_RULE3_SHIFT       (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH02_MEM_RULE_RULE3(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH02_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLASH02_MEM_RULE_RULE3_MASK)
/*! @} */

/*! @name FLASH03_MEM_RULE - Flash Memory Rule */
/*! @{ */

#define AHBSC_FLASH03_MEM_RULE_RULE0_MASK        (0x3U)
#define AHBSC_FLASH03_MEM_RULE_RULE0_SHIFT       (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE0_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE1_MASK        (0x30U)
#define AHBSC_FLASH03_MEM_RULE_RULE1_SHIFT       (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE1_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE2_MASK        (0x300U)
#define AHBSC_FLASH03_MEM_RULE_RULE2_SHIFT       (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE2(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE2_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE3_MASK        (0x3000U)
#define AHBSC_FLASH03_MEM_RULE_RULE3_SHIFT       (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE3(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE3_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE4_MASK        (0x30000U)
#define AHBSC_FLASH03_MEM_RULE_RULE4_SHIFT       (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE4(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE4_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE4_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE5_MASK        (0x300000U)
#define AHBSC_FLASH03_MEM_RULE_RULE5_SHIFT       (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE5(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE5_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE5_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE6_MASK        (0x3000000U)
#define AHBSC_FLASH03_MEM_RULE_RULE6_SHIFT       (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE6(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE6_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE6_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE7_MASK        (0x30000000U)
#define AHBSC_FLASH03_MEM_RULE_RULE7_SHIFT       (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE7(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE7_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE7_MASK)
/*! @} */

/*! @name ROM_MEM_RULE - ROM Memory Rule */
/*! @{ */

#define AHBSC_ROM_MEM_RULE_RULE0_MASK            (0x3U)
#define AHBSC_ROM_MEM_RULE_RULE0_SHIFT           (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE0(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE0_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE0_MASK)

#define AHBSC_ROM_MEM_RULE_RULE1_MASK            (0x30U)
#define AHBSC_ROM_MEM_RULE_RULE1_SHIFT           (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE1(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE1_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE1_MASK)

#define AHBSC_ROM_MEM_RULE_RULE2_MASK            (0x300U)
#define AHBSC_ROM_MEM_RULE_RULE2_SHIFT           (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE2(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE2_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE2_MASK)

#define AHBSC_ROM_MEM_RULE_RULE3_MASK            (0x3000U)
#define AHBSC_ROM_MEM_RULE_RULE3_SHIFT           (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE3(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE3_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE3_MASK)

#define AHBSC_ROM_MEM_RULE_RULE4_MASK            (0x30000U)
#define AHBSC_ROM_MEM_RULE_RULE4_SHIFT           (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE4(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE4_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE4_MASK)

#define AHBSC_ROM_MEM_RULE_RULE5_MASK            (0x300000U)
#define AHBSC_ROM_MEM_RULE_RULE5_SHIFT           (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE5(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE5_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE5_MASK)

#define AHBSC_ROM_MEM_RULE_RULE6_MASK            (0x3000000U)
#define AHBSC_ROM_MEM_RULE_RULE6_SHIFT           (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE6(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE6_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE6_MASK)

#define AHBSC_ROM_MEM_RULE_RULE7_MASK            (0x30000000U)
#define AHBSC_ROM_MEM_RULE_RULE7_SHIFT           (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE7(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE7_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_ROM_MEM_RULE */
#define AHBSC_ROM_MEM_RULE_COUNT                 (4U)

/*! @name RAMX_MEM_RULE0_RAMX_MEM_RULE - RAMX Memory Rule */
/*! @{ */

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0_MASK (0x3U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1_MASK (0x30U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2_MASK (0x300U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3_MASK (0x3000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4_MASK (0x30000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5_MASK (0x300000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_COUNT (3U)

/*! @name RAMA_MEM_RULE - RAMA Memory Rule 0 */
/*! @{ */

#define AHBSC_RAMA_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMA_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMA_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMA_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMA_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMA_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMA_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMA_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMA_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE7_MASK)
/*! @} */

/*! @name RAMB_MEM_RULE - RAMB Memory Rule */
/*! @{ */

#define AHBSC_RAMB_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMB_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMB_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMB_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMB_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMB_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMB_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMB_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMB_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE7_MASK)
/*! @} */

/*! @name RAMC_MEM_RULE - RAMC Memory Rule */
/*! @{ */

#define AHBSC_RAMC_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMC_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMC_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMC_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMC_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMC_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMC_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMC_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMC_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAMC_MEM_RULE */
#define AHBSC_RAMC_MEM_RULE_COUNT                (2U)

/*! @name RAMD_MEM_RULE - RAMD Memory Rule */
/*! @{ */

#define AHBSC_RAMD_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMD_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMD_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMD_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMD_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMD_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMD_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMD_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMD_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAMD_MEM_RULE */
#define AHBSC_RAMD_MEM_RULE_COUNT                (2U)

/*! @name RAME_MEM_RULE - RAME Memory Rule */
/*! @{ */

#define AHBSC_RAME_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAME_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE0_MASK)

#define AHBSC_RAME_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAME_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE1_MASK)

#define AHBSC_RAME_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAME_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE2_MASK)

#define AHBSC_RAME_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAME_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE3_MASK)

#define AHBSC_RAME_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAME_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE4_MASK)

#define AHBSC_RAME_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAME_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE5_MASK)

#define AHBSC_RAME_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAME_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE6_MASK)

#define AHBSC_RAME_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAME_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAME_MEM_RULE */
#define AHBSC_RAME_MEM_RULE_COUNT                (2U)

/*! @name APB_PERIPHERAL_GROUP0_MEM_RULE0 - APB Bridge Group 0 Memory Rule 0 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON_MASK (0x3U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON_SHIFT (0U)
/*! SYSCON - SYSCON
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0_SHIFT (16U)
/*! PINT0 - PINT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX_SHIFT (24U)
/*! INPUTMUX - INPUTMUX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP0_MEM_RULE1 - APB Bridge Group 0 Memory Rule 1 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0_SHIFT (16U)
/*! CTIMER0 - CTIMER0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1_MASK (0x300000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1_SHIFT (20U)
/*! CTIMER1 - CTIMER1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2_SHIFT (24U)
/*! CTIMER2 - CTIMER2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3_MASK (0x30000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3_SHIFT (28U)
/*! CTIMER3 - CTIMER3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP0_MEM_RULE2 - APB Bridge Group 0 Rule 2 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4_MASK (0x3U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4_SHIFT (0U)
/*! CTIMER4 - CTIMER4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0_MASK (0x30U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0_SHIFT (4U)
/*! FREQME0 - FREQME0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0_MASK (0x300U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0_SHIFT (8U)
/*! UTCIK0 - UTCIK0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0_MASK (0x3000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0_SHIFT (12U)
/*! MRT0 - MRT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0_SHIFT (16U)
/*! OSTIMER0 - OSTIMER0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0_SHIFT (24U)
/*! WWDT0 - WWDT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1_MASK (0x30000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1_SHIFT (28U)
/*! WWDT1 - WWDT1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP0_MEM_RULE3 - APB Bridge Group 0 Memory Rule 3 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0_MASK (0x3000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0_SHIFT (12U)
/*! CACHE64_POLSEL0 - CACHE64_POLSEL0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP1_MEM_RULE0 - APB Bridge Group 1 Memory Rule 0 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0_MASK (0x30U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0_SHIFT (4U)
/*! I3C0 - I3C0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1_MASK (0x300U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1_SHIFT (8U)
/*! I3C1 - I3C1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET_MASK (0x300000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET_SHIFT (20U)
/*! GDET - GDET
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC_SHIFT (24U)
/*! ITRC - ITRC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP1_MEM_RULE1 - APB Bridge Group 1 Memory Rule 1 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC_MASK (0x3000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC_SHIFT (12U)
/*! PKC - PKC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0_SHIFT (16U)
/*! PUF_ALIAS0 - PUF_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1_MASK (0x300000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1_SHIFT (20U)
/*! PUF_ALIAS1 - PUF_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2_SHIFT (24U)
/*! PUF_ALIAS2 - PUF_ALIAS2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3_MASK (0x30000000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3_SHIFT (28U)
/*! PUF_ALIAS3 - PUF_ALIAS3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP1_MEM_RULE2 - APB Bridge Group 1 Memory Rule 2 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX_MASK (0x300U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX_SHIFT (8U)
/*! COOLFLUX - COOLFLUX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA_MASK (0x3000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA_SHIFT (12U)
/*! SMARTDMA - SmartDMA
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU_SHIFT (16U)
/*! PLU - PLU
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP0_MEM_RULE0 - AIPS Bridge Group 0 Memory Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0_SHIFT (0U)
/*! GPIO5_ALIAS0 - GPIO5_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1_SHIFT (4U)
/*! GPIO5_ALIAS1 - GPIO5_ALIAS2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5_SHIFT (8U)
/*! PORT5 - PORT5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0_SHIFT (12U)
/*! FMU0 - FMU0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0_SHIFT (16U)
/*! SCG0 - SCG0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0_SHIFT (20U)
/*! SPC0 - SPC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0_SHIFT (24U)
/*! WUU0 - WUU0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP0_MEM_RULE1 - AIPS Bridge Group 0 Memory Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0_SHIFT (8U)
/*! LPTMR0 - LPTMR0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1_SHIFT (12U)
/*! LPTMR1 - LPTMR1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC_SHIFT (16U)
/*! RTC - RTC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST_SHIFT (24U)
/*! FMU_TEST - FMU_TEST
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP0_MEM_RULE2 - AIPS Bridge Group 0 Memory Rule 2 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI_SHIFT (0U)
/*! TSI - TSI
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0_SHIFT (4U)
/*! CMP0 - CMP0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1_SHIFT (8U)
/*! CMP1 - CMP1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2_SHIFT (12U)
/*! CMP2 - CMP2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_SHIFT (16U)
/*! ELS - ELS
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1_SHIFT (20U)
/*! ELS_ALIAS1 - ELS_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2_SHIFT (24U)
/*! ELS_ALIAS2 - ELS_ALIAS2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3_SHIFT (28U)
/*! ELS_ALIAS3 - ELS_ALIAS3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP0_MEM_RULE3 - AIPS Bridge Group 0 Memory Rule 3 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP_SHIFT (0U)
/*! DIGTMP - DIGTMP
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT_SHIFT (4U)
/*! VBAT - VBAT
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG_SHIFT (8U)
/*! TRNG - TRNG
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0_SHIFT (12U)
/*! EIM0 - EIM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0_SHIFT (16U)
/*! ERM0 - ERM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0_SHIFT (20U)
/*! INTM0 - INTM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0 - AHB Peripheral 0 Slave Port 12 Slave Rule 0 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15_MASK (0x30U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15_SHIFT (4U)
/*! eDMA0_CH15 - eDMA0_CH15
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0_MASK (0x300U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0_SHIFT (8U)
/*! SCT0 - SCT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0_MASK (0x3000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0_SHIFT (12U)
/*! LP_FLEXCOMM0 - LP_FLEXCOMM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1_MASK (0x30000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1_SHIFT (16U)
/*! LP_FLEXCOMM1 - LP_FLEXCOMM1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2_MASK (0x300000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2_SHIFT (20U)
/*! LP_FLEXCOMM2 - LP_FLEXCOMM2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3_MASK (0x3000000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3_SHIFT (24U)
/*! LP_FLEXCOMM3 - LP_FLEXCOMM3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0_MASK (0x30000000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0_SHIFT (28U)
/*! GPIO0_ALIAS0 - GPIO0_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1 - AHB Peripheral 0 Slave Port 12 Slave Rule 1 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1_MASK (0x3U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1_SHIFT (0U)
/*! GPIO0_ALIAS1 - GPIO0_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0_MASK (0x30U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0_SHIFT (4U)
/*! GPIO1_ALIAS0 - GPIO1_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1_MASK (0x300U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1_SHIFT (8U)
/*! GPIO1_ALIAS1 - GPIO1_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0_MASK (0x3000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0_SHIFT (12U)
/*! GPIO2_ALIAS0 - GPIO2_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1_MASK (0x30000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1_SHIFT (16U)
/*! GPIO2_ALIAS1 - GPIO2_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0_MASK (0x300000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0_SHIFT (20U)
/*! GPIO3_ALIAS0 - GPIO3_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1_MASK (0x3000000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1_SHIFT (24U)
/*! GPIO3_ALIAS1 - GPIO3_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0_MASK (0x30000000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0_SHIFT (28U)
/*! GPIO4_ALIAS0 - GPIO4_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2 - AHB Peripheral 0 Slave Port 12 Slave Rule 2 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1_MASK (0x3U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1_SHIFT (0U)
/*! GPIO4_ALIAS1 - GPIO4_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP1_MEM_RULE0 - AIPS Bridge Group 1 Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP_SHIFT (0U)
/*! eDMA0_MP - eDMA0_MP
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0_SHIFT (4U)
/*! eDMA0_CH0 - eDMA0_CH0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1_SHIFT (8U)
/*! eDMA0_CH1 - eDMA0_CH1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2_SHIFT (12U)
/*! eDMA0_CH2 - eDMA0_CH2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3_SHIFT (16U)
/*! eDMA0_CH3 - FLEXSPI0 Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4_SHIFT (20U)
/*! eDMA0_CH4 - eDMA0_CH4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5_SHIFT (24U)
/*! eDMA0_CH5 - eDMA0_CH5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6_SHIFT (28U)
/*! eDMA0_CH6 - eDMA0_CH6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP1_MEM_RULE1 - AIPS Bridge Group 1 Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7_SHIFT (0U)
/*! eDMA0_CH7 - eDMA0_CH7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8_SHIFT (4U)
/*! eDMA0_CH8 - eDMA0_CH8
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9_SHIFT (8U)
/*! eDMA0_CH9 - eDMA0_CH9
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10_SHIFT (12U)
/*! eDMA0_CH10 - eDMA0_CH10
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11_SHIFT (16U)
/*! eDMA0_CH11 - FLEXSPI0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12_SHIFT (20U)
/*! eDMA0_CH12 - eDMA0_CH12
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13_SHIFT (24U)
/*! eDMA0_CH13 - eDMA0_CH13
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14_SHIFT (28U)
/*! eDMA0_CH14 - eDMA0_CH14
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0 - AHB Peripheral 1 Slave Port 13 Slave Rule 0 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15_MASK (0x30U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15_SHIFT (4U)
/*! eDMA1_CH15 - eDMA1_CH15
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42_MASK (0x300U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42_SHIFT (8U)
/*! SEMA42 - SEMA42
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX_MASK (0x3000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX_SHIFT (12U)
/*! MAILBOX - MAILBOX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM_MASK (0x30000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM_SHIFT (16U)
/*! PKC_RAM - PKC_RAM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4_MASK (0x300000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4_SHIFT (20U)
/*! FLEXCOMM4 - FLEXCOMM4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5_MASK (0x3000000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5_SHIFT (24U)
/*! FLEXCOMM5 - FLEXCOMM5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6_MASK (0x30000000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6_SHIFT (28U)
/*! FLEXCOMM6 - FLEXCOMM6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1 - AHB Peripheral 1 Slave Port 13 Slave Rule 1 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7_MASK (0x3U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7_SHIFT (0U)
/*! FLEXCOMM7 - FLEXCOMM7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8_MASK (0x30U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8_SHIFT (4U)
/*! FLEXCOMM8 - FLEXCOMM8
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9_MASK (0x300U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9_SHIFT (8U)
/*! FLEXCOMM9 - FLEXCOMM9
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM_MASK (0x3000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM_SHIFT (12U)
/*! USB_FS_OTG_RAM - USB FS OTG RAM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0_MASK (0x30000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0_SHIFT (16U)
/*! CDOG0 - CDOG0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1_MASK (0x300000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1_SHIFT (20U)
/*! CDOG1 - CDOG1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX_MASK (0x3000000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX_SHIFT (24U)
/*! DEBUG_MAILBOX - DEBUG_MAILBOX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU_MASK (0x30000000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU_SHIFT (28U)
/*! NPU - NPU
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP2_MEM_RULE0 - AIPS Bridge Group 2 Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP_SHIFT (0U)
/*! eDMA1_MP - eDMA1_MP
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0_SHIFT (4U)
/*! eDMA1_CH0 - eDMA1_CH0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1_SHIFT (8U)
/*! eDMA1_CH1 - eDMA1_CH1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2_SHIFT (12U)
/*! eDMA1_CH2 - eDMA1_CH2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3_SHIFT (16U)
/*! eDMA1_CH3 - eDMA1_CH3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4_SHIFT (20U)
/*! eDMA1_CH4 - eDMA1_CH4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5_SHIFT (24U)
/*! eDMA1_CH5 - eDMA1_CH5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6_SHIFT (28U)
/*! eDMA1_CH6 - eDMA1_CH6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP2_MEM_RULE1 - AIPS Bridge Group 2 Memory Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7_SHIFT (0U)
/*! eDMA1_CH7 - eDMA1_CH7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP3_MEM_RULE0 - AIPS Bridge Group 3 Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0_SHIFT (0U)
/*! EWM0 - EWM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC_SHIFT (4U)
/*! LPCAC - LPCAC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX_SHIFT (8U)
/*! FLEXSPI_CMX - FLEXSPI_CMX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA_SHIFT (20U)
/*! SFA - SFA
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC_SHIFT (28U)
/*! MBC - MBC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP3_MEM_RULE1 - AIPS Bridge Group 3 Memory Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI_SHIFT (0U)
/*! FLEXSPI - FLEXSPI
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC_SHIFT (4U)
/*! OTPC - OTPC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC_SHIFT (12U)
/*! CRC - CRC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX_SHIFT (16U)
/*! NPX - NPX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM_SHIFT (24U)
/*! PWM - PWM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC_SHIFT (28U)
/*! ENC - ENC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP3_MEM_RULE2 - AIPS Bridge Group 3 Rule 2 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1_SHIFT (0U)
/*! PWM1 - PWM1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1_SHIFT (4U)
/*! ENC1 - ENC1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG_SHIFT (8U)
/*! EVTG - EVTG
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0_SHIFT (16U)
/*! CAN0_RULE0 - CAN0 RULE0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1_SHIFT (20U)
/*! CAN0_RULE1 - CAN0 RULE1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2_SHIFT (24U)
/*! CAN0_RULE2 - CAN0 RULE2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3_SHIFT (28U)
/*! CAN0_RULE3 - CAN0 RULE3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP3_MEM_RULE3 - AIPS Bridge Group 3 Rule 3 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0_SHIFT (0U)
/*! CAN1_RULE0 - CAN1 RULE0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1_SHIFT (4U)
/*! CAN1_RULE1 - CAN1 RULE1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2_SHIFT (8U)
/*! CAN1_RULE2 - CAN1 RULE2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3_SHIFT (12U)
/*! CAN1_RULE3 - CAN1 RULE3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD_SHIFT (16U)
/*! USBDCD - USBDCD
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS_SHIFT (20U)
/*! USBFS - USBFS
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP4_MEM_RULE0 - AIPS Bridge Group 4 Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET_MASK (0xFU)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET_SHIFT (0U)
/*! ENET - ENET
 *  0b0000..Non-secure and non-privilege user access allowed
 *  0b0001..Non-secure and privilege access allowed
 *  0b0010..Secure and non-privilege user access allowed
 *  0b0011..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0_SHIFT (12U)
/*! EMVSIM0 - EMVSIM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1_SHIFT (16U)
/*! EMVSIM1 - EMVSIM1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO_SHIFT (20U)
/*! FLEXIO - FLEXIO
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0_SHIFT (24U)
/*! SAI0 - SAI0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1_SHIFT (28U)
/*! SAI1 - SAI1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP4_MEM_RULE1 - AIPS Bridge Group 4 Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0_SHIFT (0U)
/*! SINC0 - SINC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0_SHIFT (4U)
/*! uSDHC0 - uSDHC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY_SHIFT (8U)
/*! USBHSPHY - USBHSPHY
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS_SHIFT (12U)
/*! USBHS - USBHS
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD_SHIFT (16U)
/*! MICD - MICD
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0_SHIFT (20U)
/*! ADC0 - ADC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1_SHIFT (24U)
/*! ADC1 - ADC1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0_SHIFT (28U)
/*! DAC0 - DAC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP4_MEM_RULE2 - AIPS Bridge Group 4 Rule 2 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0_SHIFT (0U)
/*! OPAMP0 - OPAMP0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF_SHIFT (4U)
/*! VREF - VREF
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC_SHIFT (8U)
/*! DAC - DAC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1_SHIFT (12U)
/*! OPAMP1 - OPAMP1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0_SHIFT (16U)
/*! HPDAC0 - HPDAC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2_SHIFT (20U)
/*! OPAMP2 - OPAMP2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0_SHIFT (24U)
/*! PORT0 - PORT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1_SHIFT (28U)
/*! PORT1 - PORT1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP4_MEM_RULE3 - AIPS Bridge Group 4 Rule 3 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2_SHIFT (0U)
/*! PORT2 - PORT2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3_SHIFT (4U)
/*! PORT3 - PORT3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4_SHIFT (8U)
/*! PORT4 - PORT4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0_SHIFT (24U)
/*! MTR0 - MTR0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0_SHIFT (28U)
/*! ATX0 - ATX0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0_MASK)
/*! @} */

/*! @name AHB_SECURE_CTRL_PERIPHERAL_RULE0 - AHB Secure Control Peripheral Rule 0 */
/*! @{ */

#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0_MASK (0x3U)
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0_SHIFT)) & AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0_MASK)

#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1_MASK (0x30U)
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1_SHIFT)) & AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1_MASK)

#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2_MASK (0x300U)
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2_SHIFT)) & AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2_MASK)

#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3_MASK (0x3000U)
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3_SHIFT)) & AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3_MASK)
/*! @} */

/*! @name SEC_VIO_ADDRN_SEC_VIO_ADDR - Security Violation Address */
/*! @{ */

#define AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR_MASK (0xFFFFFFFFU)
#define AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR_SHIFT (0U)
/*! SEC_VIO_ADDR - Security violation address for AHB layer a reset value 0 */
#define AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR_SHIFT)) & AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR_MASK)
/*! @} */

/* The count of AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR */
#define AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_COUNT   (32U)

/*! @name SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO - Security Violation Miscellaneous Information at Address */
/*! @{ */

#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK (0x1U)
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT (0U)
/*! SEC_VIO_INFO_WRITE - Security violation access read/write indicator
 *  0b0..Read access
 *  0b1..Write access
 */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT)) & AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK)

#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK (0x2U)
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT (1U)
/*! SEC_VIO_INFO_DATA_ACCESS - Security Violation Info Data Access
 *  0b0..Code
 *  0b1..Data
 */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT)) & AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK)

#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK (0xF0U)
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT (4U)
/*! SEC_VIO_INFO_MASTER_SEC_LEVEL - Security Violation Info Master Security Level */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT)) & AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK)

#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK (0x1F00U)
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT (8U)
/*! SEC_VIO_INFO_MASTER - Security violation master number
 *  0b00000..M33 Code
 *  0b00001..M33 System
 *  0b00011..SMARTDMA Instruction
 *  0b00101..SMARTDMA Data
 *  0b00110..eDMA0
 *  0b00111..eDMA1
 *  0b01000..PKC
 *  0b01001..ELS S50
 *  0b01010..PKC M0
 *  0b01011..NPU Operands
 *  0b01100..DSP Instruction
 *  0b01101..DSPX
 *  0b01110..DSPY
 *  0b10000..NPU Data
 *  0b10010..Ethernet
 *  0b10011..USB HS
 */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT)) & AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK)
/*! @} */

/* The count of AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_COUNT (32U)

/*! @name SEC_VIO_INFO_VALID - Security Violation Info Validity for Address */
/*! @{ */

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK (0x1U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT (0U)
/*! VIO_INFO_VALID0 - Violation information valid flag for AHB port 0
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK (0x2U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT (1U)
/*! VIO_INFO_VALID1 - Violation information valid flag for AHB port 1
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK (0x4U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT (2U)
/*! VIO_INFO_VALID2 - Violation information valid flag for AHB port 2
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK (0x8U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT (3U)
/*! VIO_INFO_VALID3 - Violation information valid flag for AHB port 3
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK (0x10U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT (4U)
/*! VIO_INFO_VALID4 - Violation information valid flag for AHB port 4
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK (0x20U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT (5U)
/*! VIO_INFO_VALID5 - Violation information valid flag for AHB port 5
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK (0x40U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT (6U)
/*! VIO_INFO_VALID6 - Violation information valid flag for AHB port 6
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK (0x80U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT (7U)
/*! VIO_INFO_VALID7 - Violation information valid flag for AHB port 7
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK (0x100U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT (8U)
/*! VIO_INFO_VALID8 - Violation information valid flag for AHB port 8
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK (0x200U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT (9U)
/*! VIO_INFO_VALID9 - Violation information valid flag for AHB port 9
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK (0x400U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT (10U)
/*! VIO_INFO_VALID10 - Violation information valid flag for AHB port 10
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK (0x800U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT (11U)
/*! VIO_INFO_VALID11 - Violation information valid flag for AHB port 11
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_MASK (0x1000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_SHIFT (12U)
/*! VIO_INFO_VALID12 - Violation information valid flag for AHB port 12
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_MASK (0x2000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_SHIFT (13U)
/*! VIO_INFO_VALID13 - Violation information valid flag for AHB port 13
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_MASK (0x4000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_SHIFT (14U)
/*! VIO_INFO_VALID14 - Violation information valid flag for AHB port 14
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_MASK (0x8000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_SHIFT (15U)
/*! VIO_INFO_VALID15 - Violation information valid flag for AHB port 15
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_MASK (0x10000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_SHIFT (16U)
/*! VIO_INFO_VALID16 - Violation information valid flag for AHB port 16
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_MASK (0x20000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_SHIFT (17U)
/*! VIO_INFO_VALID17 - Violation information valid flag for AHB port 17
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_MASK (0x40000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_SHIFT (18U)
/*! VIO_INFO_VALID18 - Violation information valid flag for AHB port 18
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_MASK)
/*! @} */

/*! @name SEC_GPIO_MASKN_SEC_GPIO_MASK - GPIO Mask for Port 0..GPIO Mask for Port 1 */
/*! @{ */

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK_MASK (0x1U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO0_PIN0_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK_MASK (0x1U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO1_PIN0_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK_MASK (0x2U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO0_PIN1_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK_MASK (0x2U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO1_PIN1_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK_MASK (0x4U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO0_PIN2_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK_MASK (0x4U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO1_PIN2_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK_MASK (0x8U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO0_PIN3_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK_MASK (0x8U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO1_PIN3_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK_MASK (0x10U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO0_PIN4_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK_MASK (0x10U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO1_PIN4_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK_MASK (0x20U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO0_PIN5_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK_MASK (0x20U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO1_PIN5_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK_MASK (0x40U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO0_PIN6_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK_MASK (0x40U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO1_PIN6_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK_MASK (0x80U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO0_PIN7_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK_MASK (0x80U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO1_PIN7_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK_MASK (0x100U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO0_PIN8_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK_MASK (0x100U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO1_PIN8_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK_MASK (0x200U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO0_PIN9_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK_MASK (0x200U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO1_PIN9_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK_MASK (0x400U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO0_PIN10_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK_MASK (0x400U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO1_PIN10_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK_MASK (0x800U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO0_PIN11_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK_MASK (0x800U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO1_PIN11_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK_MASK (0x1000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO0_PIN12_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK_MASK (0x1000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO1_PIN12_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK_MASK (0x2000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO0_PIN13_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK_MASK (0x2000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO1_PIN13_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK_MASK (0x4000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO0_PIN14_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK_MASK (0x4000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO1_PIN14_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK_MASK (0x8000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO0_PIN15_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK_MASK (0x8000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO1_PIN15_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK_MASK (0x10000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO0_PIN16_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK_MASK (0x10000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO1_PIN16_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK_MASK (0x20000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO0_PIN17_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK_MASK (0x20000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO1_PIN17_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK_MASK (0x40000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO0_PIN18_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK_MASK (0x40000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO1_PIN18_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK_MASK (0x80000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO0_PIN19_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK_MASK (0x80000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO1_PIN19_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK_MASK (0x100000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO0_PIN20_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK_MASK (0x100000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO1_PIN20_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK_MASK (0x200000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO0_PIN21_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK_MASK (0x200000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO1_PIN21_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK_MASK (0x400000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO0_PIN22_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK_MASK (0x400000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO1_PIN22_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK_MASK (0x800000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO0_PIN23_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK_MASK (0x800000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO1_PIN23_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO0_PIN24_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO1_PIN24_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO0_PIN25_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO1_PIN25_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO0_PIN26_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO1_PIN26_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO0_PIN27_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO1_PIN27_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO0_PIN28_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO1_PIN28_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO0_PIN29_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO1_PIN29_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO0_PIN30_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO1_PIN30_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO0_PIN31_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO1_PIN31_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK_MASK)
/*! @} */

/* The count of AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_COUNT (2U)

/*! @name MASTER_SEC_LEVEL - Master Secure Level */
/*! @{ */

#define AHBSC_MASTER_SEC_LEVEL_SMARTDMA_MASK     (0x30U)
#define AHBSC_MASTER_SEC_LEVEL_SMARTDMA_SHIFT    (4U)
/*! SMARTDMA - SMARTDMA Data
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_SMARTDMA(x)       (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_SMARTDMA_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_SMARTDMA_MASK)

#define AHBSC_MASTER_SEC_LEVEL_EDMA0_MASK        (0xC0U)
#define AHBSC_MASTER_SEC_LEVEL_EDMA0_SHIFT       (6U)
/*! eDMA0 - eDMA0
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_EDMA0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_EDMA0_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_EDMA0_MASK)

#define AHBSC_MASTER_SEC_LEVEL_EDMA1_MASK        (0x300U)
#define AHBSC_MASTER_SEC_LEVEL_EDMA1_SHIFT       (8U)
/*! eDMA1 - eDMA1
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_EDMA1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_EDMA1_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_EDMA1_MASK)

#define AHBSC_MASTER_SEC_LEVEL_PKC_MASK          (0xC00U)
#define AHBSC_MASTER_SEC_LEVEL_PKC_SHIFT         (10U)
/*! PKC - PKC
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_PKC(x)            (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_PKC_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_PKC_MASK)

#define AHBSC_MASTER_SEC_LEVEL_USB_HS_MASK       (0xC000000U)
#define AHBSC_MASTER_SEC_LEVEL_USB_HS_SHIFT      (26U)
/*! USB_HS - USB HS
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_USB_HS(x)         (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_USB_HS_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_USB_HS_MASK)

#define AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK (0xC0000000U)
#define AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_LOCK - Master SEC Level Lock
 *  0b00..Reserved
 *  0b01..MASTER_SEC_LEVEL_LOCK cannot be written
 *  0b10..MASTER_SEC_LEVEL_LOCK can be written
 *  0b11..Reserved
 */
#define AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_ANTI_POL_REG - Master Secure Level */
/*! @{ */

#define AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA_MASK (0x30U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA_SHIFT (4U)
/*! SMARTDMA - SMARTDMA Data
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0_MASK (0xC0U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0_SHIFT (6U)
/*! eDMA0 - eDMA0
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1_MASK (0x300U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1_SHIFT (8U)
/*! eDMA1 - eDMA1
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_PKC_MASK   (0xC00U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_PKC_SHIFT  (10U)
/*! PKC - PKC
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_PKC(x)     (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_PKC_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_PKC_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS_MASK (0xC000000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS_SHIFT (26U)
/*! USB_HS - USB HS
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK (0xC0000000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_ANTIPOL_LOCK - Master SEC Level Antipol Lock
 *  0b00..Reserved
 *  0b01..MASTER_SEC_LEVEL_LOCK cannot be written
 *  0b10..MASTER_SEC_LEVEL_LOCK can be written
 *  0b11..Reserved
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK)
/*! @} */

/*! @name CPU0_LOCK_REG - Miscellaneous CPU0 Control Signals */
/*! @{ */

#define AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR_MASK    (0x3U)
#define AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR_SHIFT   (0U)
/*! LOCK_NS_VTOR - LOCK_NS_VTOR
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCKNSVTOR is 1
 *  0b10..CM33 (CPU0) LOCKNSVTOR is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR(x)      (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR_MASK)

#define AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU_MASK     (0xCU)
#define AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU_SHIFT    (2U)
/*! LOCK_NS_MPU - LOCK_NS_MPU
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_NS_MPU is 1
 *  0b10..CM33 (CPU0) LOCK_NS_MPU is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU(x)       (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU_MASK)

#define AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR_MASK  (0x30U)
#define AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR_SHIFT (4U)
/*! LOCK_S_VTAIRCR - LOCK_S_VTAIRCR
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_S_VTAIRCR is 1
 *  0b10..CM33 (CPU0) LOCK_S_VTAIRCR is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR_MASK)

#define AHBSC_CPU0_LOCK_REG_LOCK_S_MPU_MASK      (0xC0U)
#define AHBSC_CPU0_LOCK_REG_LOCK_S_MPU_SHIFT     (6U)
/*! LOCK_S_MPU - LOCK_S_MPU
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_S_MPU is 1
 *  0b10..CM33 (CPU0) LOCK_S_MPU is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_S_MPU(x)        (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_S_MPU_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_S_MPU_MASK)

#define AHBSC_CPU0_LOCK_REG_LOCK_SAU_MASK        (0x300U)
#define AHBSC_CPU0_LOCK_REG_LOCK_SAU_SHIFT       (8U)
/*! LOCK_SAU - LOCK_SAU
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_SAU is 1
 *  0b10..CM33 (CPU0) LOCK_SAU is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_SAU(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_SAU_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_SAU_MASK)

#define AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK_MASK (0xC0000000U)
#define AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK_SHIFT (30U)
/*! CM33_LOCK_REG_LOCK - CM33_LOCK_REG_LOCK
 *  0b00..Reserved
 *  0b01..CM33_LOCK_REG_LOCK is 1
 *  0b10..CM33_LOCK_REG_LOCK is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK_SHIFT)) & AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK_MASK)
/*! @} */

/*! @name MISC_CTRL_DP_REG - Secure Control Duplicate */
/*! @{ */

#define AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK_MASK   (0x3U)
#define AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT  (0U)
/*! WRITE_LOCK - Write Lock
 *  0b00..Reserved
 *  0b01..Writes to this register and to the Memory and Peripheral RULE registers are not allowed
 *  0b10..Writes to this register and to the Memory and Peripheral RULE registers are allowed
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK(x)     (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK_MASK)

#define AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
/*! ENABLE_SECURE_CHECKING - Enable Secure Checking
 *  0b00..Reserved
 *  0b01..Enables secure checking. Violation can be detected when the security level of a transaction does not
 *        meet the security rule of the slave or memory to be accessed.
 *  0b10..Disables secure checking. Even if the security level of a transaction does not conform to the security
 *        rule of the slave or memory, it will not be detected as a violation.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK)

#define AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
/*! ENABLE_S_PRIV_CHECK - Enable Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enables the privilege checking of secure mode access.
 *  0b10..Disables the privilege checking of secure mode access.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK)

#define AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
/*! ENABLE_NS_PRIV_CHECK - Enable Non-Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enables the privilege checking of non-secure mode access.
 *  0b10..Disables the privilege checking of non-secure mode access.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK)

#define AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
/*! DISABLE_VIOLATION_ABORT - Disable Violation Abort
 *  0b00..Reserved
 *  0b01..The violation detected by the secure checker will not cause an abort, but a secure_violation_irq
 *        (interrupt request) will still be asserted and serviced by ISR.
 *  0b10..The violation detected by the secure checker will cause an abort.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK)

#define AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_MASK (0xC00U)
#define AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_SHIFT (10U)
/*! DISABLE_STRICT_MODE - Disable Strict Mode
 *  0b00..Reserved
 *  0b01..Master can access memories and peripherals at the same level or below that level.
 *  0b10..Master can access memories and peripherals at same level only
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_MASK)

#define AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK  (0xC000U)
#define AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT (14U)
/*! IDAU_ALL_NS - IDAU All Non-Secure
 *  0b00..Reserved
 *  0b01..IDAU is disabled, which means that all memories are attributed as non-secure memory.
 *  0b10..IDAU is enabled (restrictive mode)
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK)
/*! @} */

/*! @name MISC_CTRL_REG - Secure Control */
/*! @{ */

#define AHBSC_MISC_CTRL_REG_WRITE_LOCK_MASK      (0x3U)
#define AHBSC_MISC_CTRL_REG_WRITE_LOCK_SHIFT     (0U)
/*! WRITE_LOCK - Write Lock
 *  0b00..Reserved
 *  0b01..Writes to this register and to the Memory and Peripheral RULE registers are not allowed
 *  0b10..Writes to this register and to the Memory and Peripheral RULE registers are allowed
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_WRITE_LOCK(x)        (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_WRITE_LOCK_SHIFT)) & AHBSC_MISC_CTRL_REG_WRITE_LOCK_MASK)

#define AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
/*! ENABLE_SECURE_CHECKING - Enable Secure Checking
 *  0b00..Reserved
 *  0b01..Enables secure checking. Violation can be detected when the security level of a transaction does not
 *        meet the security rule of the slave or memory to be accessed.
 *  0b10..Disables secure checking. Even if the security level of a transaction does not conform to the security
 *        rule of the slave or memory, it will not be detected as a violation.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT)) & AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK)

#define AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
/*! ENABLE_S_PRIV_CHECK - Enable Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enables privilege checking of secure mode access.
 *  0b10..Disables privilege checking of secure mode access.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK)

#define AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
/*! ENABLE_NS_PRIV_CHECK - Enable Non-Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enables privilege checking of non-secure mode access.
 *  0b10..Disables privilege checking of non-secure mode access is disabled.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK)

#define AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
/*! DISABLE_VIOLATION_ABORT - Disable Violation Abort
 *  0b00..Reserved
 *  0b01..The violation detected by the secure checker will not cause an abort, but a secure_violation_irq
 *        (interrupt request) will still be asserted and serviced by ISR.
 *  0b10..The violation detected by the secure checker will cause an abort.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK)

#define AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE_MASK (0xC00U)
#define AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE_SHIFT (10U)
/*! DISABLE_STRICT_MODE - Disable Strict Mode
 *  0b00..Reserved
 *  0b01..Master strict mode is on and can access memories and peripherals at the same level or below that level
 *  0b10..Master strict mode is disabled and can access memories and peripherals at same level only
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE_SHIFT)) & AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE_MASK)

#define AHBSC_MISC_CTRL_REG_IDAU_ALL_NS_MASK     (0xC000U)
#define AHBSC_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT    (14U)
/*! IDAU_ALL_NS - IDAU All Non-Secure
 *  0b00..Reserved
 *  0b01..IDAU is disabled, which means that all memories are attributed as non-secure memory.
 *  0b10..IDAU is enabled (restrictive mode)
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_IDAU_ALL_NS(x)       (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT)) & AHBSC_MISC_CTRL_REG_IDAU_ALL_NS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AHBSC_Register_Masks */


/* AHBSC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral AHBSC base address */
  #define AHBSC_BASE                               (0x50120000u)
  /** Peripheral AHBSC base address */
  #define AHBSC_BASE_NS                            (0x40120000u)
  /** Peripheral AHBSC base pointer */
  #define AHBSC                                    ((AHBSC_Type *)AHBSC_BASE)
  /** Peripheral AHBSC base pointer */
  #define AHBSC_NS                                 ((AHBSC_Type *)AHBSC_BASE_NS)
  /** Peripheral AHBSC_ALIAS1 base address */
  #define AHBSC_ALIAS1_BASE                        (0x50121000u)
  /** Peripheral AHBSC_ALIAS1 base address */
  #define AHBSC_ALIAS1_BASE_NS                     (0x40121000u)
  /** Peripheral AHBSC_ALIAS1 base pointer */
  #define AHBSC_ALIAS1                             ((AHBSC_Type *)AHBSC_ALIAS1_BASE)
  /** Peripheral AHBSC_ALIAS1 base pointer */
  #define AHBSC_ALIAS1_NS                          ((AHBSC_Type *)AHBSC_ALIAS1_BASE_NS)
  /** Peripheral AHBSC_ALIAS2 base address */
  #define AHBSC_ALIAS2_BASE                        (0x50122000u)
  /** Peripheral AHBSC_ALIAS2 base address */
  #define AHBSC_ALIAS2_BASE_NS                     (0x40122000u)
  /** Peripheral AHBSC_ALIAS2 base pointer */
  #define AHBSC_ALIAS2                             ((AHBSC_Type *)AHBSC_ALIAS2_BASE)
  /** Peripheral AHBSC_ALIAS2 base pointer */
  #define AHBSC_ALIAS2_NS                          ((AHBSC_Type *)AHBSC_ALIAS2_BASE_NS)
  /** Peripheral AHBSC_ALIAS3 base address */
  #define AHBSC_ALIAS3_BASE                        (0x50123000u)
  /** Peripheral AHBSC_ALIAS3 base address */
  #define AHBSC_ALIAS3_BASE_NS                     (0x40123000u)
  /** Peripheral AHBSC_ALIAS3 base pointer */
  #define AHBSC_ALIAS3                             ((AHBSC_Type *)AHBSC_ALIAS3_BASE)
  /** Peripheral AHBSC_ALIAS3 base pointer */
  #define AHBSC_ALIAS3_NS                          ((AHBSC_Type *)AHBSC_ALIAS3_BASE_NS)
  /** Array initializer of AHBSC peripheral base addresses */
  #define AHBSC_BASE_ADDRS                         { AHBSC_BASE, AHBSC_ALIAS1_BASE, AHBSC_ALIAS2_BASE, AHBSC_ALIAS3_BASE }
  /** Array initializer of AHBSC peripheral base pointers */
  #define AHBSC_BASE_PTRS                          { AHBSC, AHBSC_ALIAS1, AHBSC_ALIAS2, AHBSC_ALIAS3 }
  /** Array initializer of AHBSC peripheral base addresses */
  #define AHBSC_BASE_ADDRS_NS                      { AHBSC_BASE_NS, AHBSC_ALIAS1_BASE_NS, AHBSC_ALIAS2_BASE_NS, AHBSC_ALIAS3_BASE_NS }
  /** Array initializer of AHBSC peripheral base pointers */
  #define AHBSC_BASE_PTRS_NS                       { AHBSC_NS, AHBSC_ALIAS1_NS, AHBSC_ALIAS2_NS, AHBSC_ALIAS3_NS }
#else
  /** Peripheral AHBSC base address */
  #define AHBSC_BASE                               (0x40120000u)
  /** Peripheral AHBSC base pointer */
  #define AHBSC                                    ((AHBSC_Type *)AHBSC_BASE)
  /** Peripheral AHBSC_ALIAS1 base address */
  #define AHBSC_ALIAS1_BASE                        (0x40121000u)
  /** Peripheral AHBSC_ALIAS1 base pointer */
  #define AHBSC_ALIAS1                             ((AHBSC_Type *)AHBSC_ALIAS1_BASE)
  /** Peripheral AHBSC_ALIAS2 base address */
  #define AHBSC_ALIAS2_BASE                        (0x40122000u)
  /** Peripheral AHBSC_ALIAS2 base pointer */
  #define AHBSC_ALIAS2                             ((AHBSC_Type *)AHBSC_ALIAS2_BASE)
  /** Peripheral AHBSC_ALIAS3 base address */
  #define AHBSC_ALIAS3_BASE                        (0x40123000u)
  /** Peripheral AHBSC_ALIAS3 base pointer */
  #define AHBSC_ALIAS3                             ((AHBSC_Type *)AHBSC_ALIAS3_BASE)
  /** Array initializer of AHBSC peripheral base addresses */
  #define AHBSC_BASE_ADDRS                         { AHBSC_BASE, AHBSC_ALIAS1_BASE, AHBSC_ALIAS2_BASE, AHBSC_ALIAS3_BASE }
  /** Array initializer of AHBSC peripheral base pointers */
  #define AHBSC_BASE_PTRS                          { AHBSC, AHBSC_ALIAS1, AHBSC_ALIAS2, AHBSC_ALIAS3 }
#endif

/*!
 * @}
 */ /* end of group AHBSC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1, offset: 0x4 */
  __IO uint32_t TIMER;                             /**< Free-Running Timer, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t RXMGMASK;                          /**< RX Message Buffers Global Mask, offset: 0x10 */
  __IO uint32_t RX14MASK;                          /**< Receive 14 Mask, offset: 0x14 */
  __IO uint32_t RX15MASK;                          /**< Receive 15 Mask, offset: 0x18 */
  __IO uint32_t ECR;                               /**< Error Counter, offset: 0x1C */
  __IO uint32_t ESR1;                              /**< Error and Status 1, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __IO uint32_t IMASK1;                            /**< Interrupt Masks 1, offset: 0x28 */
       uint8_t RESERVED_2[4];
  __IO uint32_t IFLAG1;                            /**< Interrupt Flags 1, offset: 0x30 */
  __IO uint32_t CTRL2;                             /**< Control 2, offset: 0x34 */
  __I  uint32_t ESR2;                              /**< Error and Status 2, offset: 0x38 */
       uint8_t RESERVED_3[8];
  __I  uint32_t CRCR;                              /**< Cyclic Redundancy Check, offset: 0x44 */
  __IO uint32_t RXFGMASK;                          /**< Legacy RX FIFO Global Mask, offset: 0x48 */
  __I  uint32_t RXFIR;                             /**< Legacy RX FIFO Information, offset: 0x4C */
  __IO uint32_t CBT;                               /**< CAN Bit Timing, offset: 0x50 */
       uint8_t RESERVED_4[44];
  union {                                          /* offset: 0x80 */
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD[2];                           /**< Message Buffer 0 WORD_8B Register..Message Buffer 31 WORD_8B Register, array offset: 0x88, array step: index*0x10, index2*0x4 */
    } MB_8B[32];
    struct {                                         /* offset: 0x80, array step: 0x18 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 20 CS Register, array offset: 0x80, array step: 0x18 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 20 ID Register, array offset: 0x84, array step: 0x18 */
      __IO uint32_t WORD[4];                           /**< Message Buffer 0 WORD_16B Register..Message Buffer 20 WORD_16B Register, array offset: 0x88, array step: index*0x18, index2*0x4 */
    } MB_16B[21];
    struct {                                         /* offset: 0x80, array step: 0x28 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 11 CS Register, array offset: 0x80, array step: 0x28 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 11 ID Register, array offset: 0x84, array step: 0x28 */
      __IO uint32_t WORD[8];                           /**< Message Buffer 0 WORD_32B Register..Message Buffer 11 WORD_32B Register, array offset: 0x88, array step: index*0x28, index2*0x4 */
    } MB_32B[12];
    struct {                                         /* offset: 0x80, array step: 0x48 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 6 CS Register, array offset: 0x80, array step: 0x48 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 6 ID Register, array offset: 0x84, array step: 0x48 */
      __IO uint32_t WORD[16];                          /**< Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register, array offset: 0x88, array step: index*0x48, index2*0x4 */
    } MB_64B[7];
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD0;                             /**< Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register, array offset: 0x88, array step: 0x10 */
      __IO uint32_t WORD1;                             /**< Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register, array offset: 0x8C, array step: 0x10 */
    } MB[32];
  };
       uint8_t RESERVED_5[1536];
  __IO uint32_t RXIMR[32];                         /**< Receive Individual Mask, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_6[512];
  __IO uint32_t CTRL1_PN;                          /**< Pretended Networking Control 1, offset: 0xB00 */
  __IO uint32_t CTRL2_PN;                          /**< Pretended Networking Control 2, offset: 0xB04 */
  __IO uint32_t WU_MTC;                            /**< Pretended Networking Wake-Up Match, offset: 0xB08 */
  __IO uint32_t FLT_ID1;                           /**< Pretended Networking ID Filter 1, offset: 0xB0C */
  __IO uint32_t FLT_DLC;                           /**< Pretended Networking Data Length Code (DLC) Filter, offset: 0xB10 */
  __IO uint32_t PL1_LO;                            /**< Pretended Networking Payload Low Filter 1, offset: 0xB14 */
  __IO uint32_t PL1_HI;                            /**< Pretended Networking Payload High Filter 1, offset: 0xB18 */
  __IO uint32_t FLT_ID2_IDMASK;                    /**< Pretended Networking ID Filter 2 or ID Mask, offset: 0xB1C */
  __IO uint32_t PL2_PLMASK_LO;                     /**< Pretended Networking Payload Low Filter 2 and Payload Low Mask, offset: 0xB20 */
  __IO uint32_t PL2_PLMASK_HI;                     /**< Pretended Networking Payload High Filter 2 and Payload High Mask, offset: 0xB24 */
       uint8_t RESERVED_7[24];
  struct {                                         /* offset: 0xB40, array step: 0x10 */
    __I  uint32_t CS;                                /**< Wake-Up Message Buffer, array offset: 0xB40, array step: 0x10 */
    __I  uint32_t ID;                                /**< Wake-Up Message Buffer for ID, array offset: 0xB44, array step: 0x10 */
    __I  uint32_t D03;                               /**< Wake-Up Message Buffer for Data 0-3, array offset: 0xB48, array step: 0x10 */
    __I  uint32_t D47;                               /**< Wake-Up Message Buffer Register Data 4-7, array offset: 0xB4C, array step: 0x10 */
  } WMB[4];
       uint8_t RESERVED_8[112];
  __IO uint32_t EPRS;                              /**< Enhanced CAN Bit Timing Prescalers, offset: 0xBF0 */
  __IO uint32_t ENCBT;                             /**< Enhanced Nominal CAN Bit Timing, offset: 0xBF4 */
  __IO uint32_t EDCBT;                             /**< Enhanced Data Phase CAN Bit Timing, offset: 0xBF8 */
  __IO uint32_t ETDC;                              /**< Enhanced Transceiver Delay Compensation, offset: 0xBFC */
  __IO uint32_t FDCTRL;                            /**< CAN FD Control, offset: 0xC00 */
  __IO uint32_t FDCBT;                             /**< CAN FD Bit Timing, offset: 0xC04 */
  __I  uint32_t FDCRC;                             /**< CAN FD CRC, offset: 0xC08 */
  __IO uint32_t ERFCR;                             /**< Enhanced RX FIFO Control, offset: 0xC0C */
  __IO uint32_t ERFIER;                            /**< Enhanced RX FIFO Interrupt Enable, offset: 0xC10 */
  __IO uint32_t ERFSR;                             /**< Enhanced RX FIFO Status, offset: 0xC14 */
       uint8_t RESERVED_9[9192];
  __IO uint32_t ERFFEL[32];                        /**< Enhanced RX FIFO Filter Element, array offset: 0x3000, array step: 0x4 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name MCR - Module Configuration */
/*! @{ */

#define CAN_MCR_MAXMB_MASK                       (0x7FU)
#define CAN_MCR_MAXMB_SHIFT                      (0U)
/*! MAXMB - Number of the Last Message Buffer */
#define CAN_MCR_MAXMB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MAXMB_SHIFT)) & CAN_MCR_MAXMB_MASK)

#define CAN_MCR_IDAM_MASK                        (0x300U)
#define CAN_MCR_IDAM_SHIFT                       (8U)
/*! IDAM - ID Acceptance Mode
 *  0b00..Format A: One full ID (standard and extended) per ID filter table element.
 *  0b01..Format B: Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID filter table element.
 *  0b10..Format C: Four partial 8-bit standard IDs per ID filter table element.
 *  0b11..Format D: All frames rejected.
 */
#define CAN_MCR_IDAM(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IDAM_SHIFT)) & CAN_MCR_IDAM_MASK)

#define CAN_MCR_FDEN_MASK                        (0x800U)
#define CAN_MCR_FDEN_SHIFT                       (11U)
/*! FDEN - CAN FD Operation Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define CAN_MCR_FDEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FDEN_SHIFT)) & CAN_MCR_FDEN_MASK)

#define CAN_MCR_AEN_MASK                         (0x1000U)
#define CAN_MCR_AEN_SHIFT                        (12U)
/*! AEN - Abort Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_MCR_AEN(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_AEN_SHIFT)) & CAN_MCR_AEN_MASK)

#define CAN_MCR_LPRIOEN_MASK                     (0x2000U)
#define CAN_MCR_LPRIOEN_SHIFT                    (13U)
/*! LPRIOEN - Local Priority Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_LPRIOEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPRIOEN_SHIFT)) & CAN_MCR_LPRIOEN_MASK)

#define CAN_MCR_PNET_EN_MASK                     (0x4000U)
#define CAN_MCR_PNET_EN_SHIFT                    (14U)
/*! PNET_EN - Pretended Networking Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_PNET_EN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_PNET_EN_SHIFT)) & CAN_MCR_PNET_EN_MASK)

#define CAN_MCR_DMA_MASK                         (0x8000U)
#define CAN_MCR_DMA_SHIFT                        (15U)
/*! DMA - DMA Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_DMA(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DMA_SHIFT)) & CAN_MCR_DMA_MASK)

#define CAN_MCR_IRMQ_MASK                        (0x10000U)
#define CAN_MCR_IRMQ_SHIFT                       (16U)
/*! IRMQ - Individual RX Masking and Queue Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_IRMQ(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IRMQ_SHIFT)) & CAN_MCR_IRMQ_MASK)

#define CAN_MCR_SRXDIS_MASK                      (0x20000U)
#define CAN_MCR_SRXDIS_SHIFT                     (17U)
/*! SRXDIS - Self-Reception Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_MCR_SRXDIS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SRXDIS_SHIFT)) & CAN_MCR_SRXDIS_MASK)

#define CAN_MCR_WAKSRC_MASK                      (0x80000U)
#define CAN_MCR_WAKSRC_SHIFT                     (19U)
/*! WAKSRC - Wake-Up Source
 *  0b0..No filter applied
 *  0b1..Filter applied
 */
#define CAN_MCR_WAKSRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKSRC_SHIFT)) & CAN_MCR_WAKSRC_MASK)

#define CAN_MCR_LPMACK_MASK                      (0x100000U)
#define CAN_MCR_LPMACK_SHIFT                     (20U)
/*! LPMACK - Low-Power Mode Acknowledge
 *  0b0..Not in a low-power mode
 *  0b1..In a low-power mode
 */
#define CAN_MCR_LPMACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPMACK_SHIFT)) & CAN_MCR_LPMACK_MASK)

#define CAN_MCR_WRNEN_MASK                       (0x200000U)
#define CAN_MCR_WRNEN_SHIFT                      (21U)
/*! WRNEN - Warning Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_WRNEN(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WRNEN_SHIFT)) & CAN_MCR_WRNEN_MASK)

#define CAN_MCR_SLFWAK_MASK                      (0x400000U)
#define CAN_MCR_SLFWAK_SHIFT                     (22U)
/*! SLFWAK - Self Wake-Up
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_SLFWAK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SLFWAK_SHIFT)) & CAN_MCR_SLFWAK_MASK)

#define CAN_MCR_FRZACK_MASK                      (0x1000000U)
#define CAN_MCR_FRZACK_SHIFT                     (24U)
/*! FRZACK - Freeze Mode Acknowledge
 *  0b0..Not in Freeze mode, prescaler running.
 *  0b1..In Freeze mode, prescaler stopped.
 */
#define CAN_MCR_FRZACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZACK_SHIFT)) & CAN_MCR_FRZACK_MASK)

#define CAN_MCR_SOFTRST_MASK                     (0x2000000U)
#define CAN_MCR_SOFTRST_SHIFT                    (25U)
/*! SOFTRST - Soft Reset
 *  0b0..No reset
 *  0b1..Soft reset affects reset registers
 */
#define CAN_MCR_SOFTRST(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SOFTRST_SHIFT)) & CAN_MCR_SOFTRST_MASK)

#define CAN_MCR_WAKMSK_MASK                      (0x4000000U)
#define CAN_MCR_WAKMSK_SHIFT                     (26U)
/*! WAKMSK - Wake-Up Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_MCR_WAKMSK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKMSK_SHIFT)) & CAN_MCR_WAKMSK_MASK)

#define CAN_MCR_NOTRDY_MASK                      (0x8000000U)
#define CAN_MCR_NOTRDY_SHIFT                     (27U)
/*! NOTRDY - FlexCAN Not Ready
 *  0b0..FlexCAN is in Normal mode, Listen-Only mode, or Loopback mode.
 *  0b1..FlexCAN is in Disable mode, Stop mode, or Freeze mode.
 */
#define CAN_MCR_NOTRDY(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_NOTRDY_SHIFT)) & CAN_MCR_NOTRDY_MASK)

#define CAN_MCR_HALT_MASK                        (0x10000000U)
#define CAN_MCR_HALT_SHIFT                       (28U)
/*! HALT - Halt FlexCAN
 *  0b0..No request
 *  0b1..Enter Freeze mode, if MCR[FRZ] = 1.
 */
#define CAN_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_HALT_SHIFT)) & CAN_MCR_HALT_MASK)

#define CAN_MCR_RFEN_MASK                        (0x20000000U)
#define CAN_MCR_RFEN_SHIFT                       (29U)
/*! RFEN - Legacy RX FIFO Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_RFEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_RFEN_SHIFT)) & CAN_MCR_RFEN_MASK)

#define CAN_MCR_FRZ_MASK                         (0x40000000U)
#define CAN_MCR_FRZ_SHIFT                        (30U)
/*! FRZ - Freeze Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZ_SHIFT)) & CAN_MCR_FRZ_MASK)

#define CAN_MCR_MDIS_MASK                        (0x80000000U)
#define CAN_MCR_MDIS_SHIFT                       (31U)
/*! MDIS - Module Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MDIS_SHIFT)) & CAN_MCR_MDIS_MASK)
/*! @} */

/*! @name CTRL1 - Control 1 */
/*! @{ */

#define CAN_CTRL1_PROPSEG_MASK                   (0x7U)
#define CAN_CTRL1_PROPSEG_SHIFT                  (0U)
/*! PROPSEG - Propagation Segment */
#define CAN_CTRL1_PROPSEG(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PROPSEG_SHIFT)) & CAN_CTRL1_PROPSEG_MASK)

#define CAN_CTRL1_LOM_MASK                       (0x8U)
#define CAN_CTRL1_LOM_SHIFT                      (3U)
/*! LOM - Listen-Only Mode
 *  0b0..Listen-Only mode is deactivated.
 *  0b1..FlexCAN module operates in Listen-Only mode.
 */
#define CAN_CTRL1_LOM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LOM_SHIFT)) & CAN_CTRL1_LOM_MASK)

#define CAN_CTRL1_LBUF_MASK                      (0x10U)
#define CAN_CTRL1_LBUF_SHIFT                     (4U)
/*! LBUF - Lowest Buffer Transmitted First
 *  0b0..Buffer with highest priority is transmitted first.
 *  0b1..Lowest number buffer is transmitted first.
 */
#define CAN_CTRL1_LBUF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LBUF_SHIFT)) & CAN_CTRL1_LBUF_MASK)

#define CAN_CTRL1_TSYN_MASK                      (0x20U)
#define CAN_CTRL1_TSYN_SHIFT                     (5U)
/*! TSYN - Timer Sync
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_TSYN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TSYN_SHIFT)) & CAN_CTRL1_TSYN_MASK)

#define CAN_CTRL1_BOFFREC_MASK                   (0x40U)
#define CAN_CTRL1_BOFFREC_SHIFT                  (6U)
/*! BOFFREC - Bus Off Recovery
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define CAN_CTRL1_BOFFREC(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFREC_SHIFT)) & CAN_CTRL1_BOFFREC_MASK)

#define CAN_CTRL1_SMP_MASK                       (0x80U)
#define CAN_CTRL1_SMP_SHIFT                      (7U)
/*! SMP - CAN Bit Sampling
 *  0b0..One sample is used to determine the bit value.
 *  0b1..Three samples are used to determine the value of the received bit: the regular one (sample point) and two
 *       preceding samples. A majority rule is used.
 */
#define CAN_CTRL1_SMP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_SMP_SHIFT)) & CAN_CTRL1_SMP_MASK)

#define CAN_CTRL1_RWRNMSK_MASK                   (0x400U)
#define CAN_CTRL1_RWRNMSK_SHIFT                  (10U)
/*! RWRNMSK - RX Warning Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_RWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RWRNMSK_SHIFT)) & CAN_CTRL1_RWRNMSK_MASK)

#define CAN_CTRL1_TWRNMSK_MASK                   (0x800U)
#define CAN_CTRL1_TWRNMSK_SHIFT                  (11U)
/*! TWRNMSK - TX Warning Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_TWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TWRNMSK_SHIFT)) & CAN_CTRL1_TWRNMSK_MASK)

#define CAN_CTRL1_LPB_MASK                       (0x1000U)
#define CAN_CTRL1_LPB_SHIFT                      (12U)
/*! LPB - Loopback Mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_LPB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LPB_SHIFT)) & CAN_CTRL1_LPB_MASK)

#define CAN_CTRL1_ERRMSK_MASK                    (0x4000U)
#define CAN_CTRL1_ERRMSK_SHIFT                   (14U)
/*! ERRMSK - Error Interrupt Mask
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_CTRL1_ERRMSK(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_ERRMSK_SHIFT)) & CAN_CTRL1_ERRMSK_MASK)

#define CAN_CTRL1_BOFFMSK_MASK                   (0x8000U)
#define CAN_CTRL1_BOFFMSK_SHIFT                  (15U)
/*! BOFFMSK - Bus Off Interrupt Mask
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_CTRL1_BOFFMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFMSK_SHIFT)) & CAN_CTRL1_BOFFMSK_MASK)

#define CAN_CTRL1_PSEG2_MASK                     (0x70000U)
#define CAN_CTRL1_PSEG2_SHIFT                    (16U)
/*! PSEG2 - Phase Segment 2 */
#define CAN_CTRL1_PSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG2_SHIFT)) & CAN_CTRL1_PSEG2_MASK)

#define CAN_CTRL1_PSEG1_MASK                     (0x380000U)
#define CAN_CTRL1_PSEG1_SHIFT                    (19U)
/*! PSEG1 - Phase Segment 1 */
#define CAN_CTRL1_PSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG1_SHIFT)) & CAN_CTRL1_PSEG1_MASK)

#define CAN_CTRL1_RJW_MASK                       (0xC00000U)
#define CAN_CTRL1_RJW_SHIFT                      (22U)
/*! RJW - Resync Jump Width */
#define CAN_CTRL1_RJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RJW_SHIFT)) & CAN_CTRL1_RJW_MASK)

#define CAN_CTRL1_PRESDIV_MASK                   (0xFF000000U)
#define CAN_CTRL1_PRESDIV_SHIFT                  (24U)
/*! PRESDIV - Prescaler Division Factor */
#define CAN_CTRL1_PRESDIV(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PRESDIV_SHIFT)) & CAN_CTRL1_PRESDIV_MASK)
/*! @} */

/*! @name TIMER - Free-Running Timer */
/*! @{ */

#define CAN_TIMER_TIMER_MASK                     (0xFFFFU)
#define CAN_TIMER_TIMER_SHIFT                    (0U)
/*! TIMER - Timer Value */
#define CAN_TIMER_TIMER(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TIMER_TIMER_SHIFT)) & CAN_TIMER_TIMER_MASK)
/*! @} */

/*! @name RXMGMASK - RX Message Buffers Global Mask */
/*! @{ */

#define CAN_RXMGMASK_MG_MASK                     (0xFFFFFFFFU)
#define CAN_RXMGMASK_MG_SHIFT                    (0U)
/*! MG - Global Mask for RX Message Buffers */
#define CAN_RXMGMASK_MG(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXMGMASK_MG_SHIFT)) & CAN_RXMGMASK_MG_MASK)
/*! @} */

/*! @name RX14MASK - Receive 14 Mask */
/*! @{ */

#define CAN_RX14MASK_RX14M_MASK                  (0xFFFFFFFFU)
#define CAN_RX14MASK_RX14M_SHIFT                 (0U)
/*! RX14M - RX Buffer 14 Mask Bits */
#define CAN_RX14MASK_RX14M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX14MASK_RX14M_SHIFT)) & CAN_RX14MASK_RX14M_MASK)
/*! @} */

/*! @name RX15MASK - Receive 15 Mask */
/*! @{ */

#define CAN_RX15MASK_RX15M_MASK                  (0xFFFFFFFFU)
#define CAN_RX15MASK_RX15M_SHIFT                 (0U)
/*! RX15M - RX Buffer 15 Mask Bits */
#define CAN_RX15MASK_RX15M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX15MASK_RX15M_SHIFT)) & CAN_RX15MASK_RX15M_MASK)
/*! @} */

/*! @name ECR - Error Counter */
/*! @{ */

#define CAN_ECR_TXERRCNT_MASK                    (0xFFU)
#define CAN_ECR_TXERRCNT_SHIFT                   (0U)
/*! TXERRCNT - Transmit Error Counter */
#define CAN_ECR_TXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_SHIFT)) & CAN_ECR_TXERRCNT_MASK)

#define CAN_ECR_RXERRCNT_MASK                    (0xFF00U)
#define CAN_ECR_RXERRCNT_SHIFT                   (8U)
/*! RXERRCNT - Receive Error Counter */
#define CAN_ECR_RXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_SHIFT)) & CAN_ECR_RXERRCNT_MASK)

#define CAN_ECR_TXERRCNT_FAST_MASK               (0xFF0000U)
#define CAN_ECR_TXERRCNT_FAST_SHIFT              (16U)
/*! TXERRCNT_FAST - Transmit Error Counter for Fast Bits */
#define CAN_ECR_TXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_FAST_SHIFT)) & CAN_ECR_TXERRCNT_FAST_MASK)

#define CAN_ECR_RXERRCNT_FAST_MASK               (0xFF000000U)
#define CAN_ECR_RXERRCNT_FAST_SHIFT              (24U)
/*! RXERRCNT_FAST - Receive Error Counter for Fast Bits */
#define CAN_ECR_RXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_FAST_SHIFT)) & CAN_ECR_RXERRCNT_FAST_MASK)
/*! @} */

/*! @name ESR1 - Error and Status 1 */
/*! @{ */

#define CAN_ESR1_WAKINT_MASK                     (0x1U)
#define CAN_ESR1_WAKINT_SHIFT                    (0U)
/*! WAKINT - Wake-Up Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Indicates that a recessive-to-dominant transition was received on the CAN bus.
 */
#define CAN_ESR1_WAKINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_WAKINT_SHIFT)) & CAN_ESR1_WAKINT_MASK)

#define CAN_ESR1_ERRINT_MASK                     (0x2U)
#define CAN_ESR1_ERRINT_SHIFT                    (1U)
/*! ERRINT - Error Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error flag in the Error and Status register.
 */
#define CAN_ESR1_ERRINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_SHIFT)) & CAN_ESR1_ERRINT_MASK)

#define CAN_ESR1_BOFFINT_MASK                    (0x4U)
#define CAN_ESR1_BOFFINT_SHIFT                   (2U)
/*! BOFFINT - Bus Off Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module entered Bus Off state.
 */
#define CAN_ESR1_BOFFINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFINT_SHIFT)) & CAN_ESR1_BOFFINT_MASK)

#define CAN_ESR1_RX_MASK                         (0x8U)
#define CAN_ESR1_RX_SHIFT                        (3U)
/*! RX - FlexCAN in Reception Flag
 *  0b0..Not receiving
 *  0b1..Receiving
 */
#define CAN_ESR1_RX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RX_SHIFT)) & CAN_ESR1_RX_MASK)

#define CAN_ESR1_FLTCONF_MASK                    (0x30U)
#define CAN_ESR1_FLTCONF_SHIFT                   (4U)
/*! FLTCONF - Fault Confinement State
 *  0b00..Error Active
 *  0b01..Error Passive
 *  0b1x..Bus Off
 */
#define CAN_ESR1_FLTCONF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FLTCONF_SHIFT)) & CAN_ESR1_FLTCONF_MASK)

#define CAN_ESR1_TX_MASK                         (0x40U)
#define CAN_ESR1_TX_SHIFT                        (6U)
/*! TX - FlexCAN In Transmission
 *  0b0..Not transmitting
 *  0b1..Transmitting
 */
#define CAN_ESR1_TX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TX_SHIFT)) & CAN_ESR1_TX_MASK)

#define CAN_ESR1_IDLE_MASK                       (0x80U)
#define CAN_ESR1_IDLE_SHIFT                      (7U)
/*! IDLE - Idle
 *  0b0..Not IDLE
 *  0b1..IDLE
 */
#define CAN_ESR1_IDLE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_IDLE_SHIFT)) & CAN_ESR1_IDLE_MASK)

#define CAN_ESR1_RXWRN_MASK                      (0x100U)
#define CAN_ESR1_RXWRN_SHIFT                     (8U)
/*! RXWRN - RX Error Warning Flag
 *  0b0..No such occurrence.
 *  0b1..RXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_RXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RXWRN_SHIFT)) & CAN_ESR1_RXWRN_MASK)

#define CAN_ESR1_TXWRN_MASK                      (0x200U)
#define CAN_ESR1_TXWRN_SHIFT                     (9U)
/*! TXWRN - TX Error Warning Flag
 *  0b0..No such occurrence.
 *  0b1..TXERRCNT is 96 or greater.
 */
#define CAN_ESR1_TXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TXWRN_SHIFT)) & CAN_ESR1_TXWRN_MASK)

#define CAN_ESR1_STFERR_MASK                     (0x400U)
#define CAN_ESR1_STFERR_SHIFT                    (10U)
/*! STFERR - Stuffing Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_SHIFT)) & CAN_ESR1_STFERR_MASK)

#define CAN_ESR1_FRMERR_MASK                     (0x800U)
#define CAN_ESR1_FRMERR_SHIFT                    (11U)
/*! FRMERR - Form Error Flag
 *  0b0..No error
 *  0b1..A Form Error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_SHIFT)) & CAN_ESR1_FRMERR_MASK)

#define CAN_ESR1_CRCERR_MASK                     (0x1000U)
#define CAN_ESR1_CRCERR_SHIFT                    (12U)
/*! CRCERR - Cyclic Redundancy Check Error Flag
 *  0b0..No error
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_SHIFT)) & CAN_ESR1_CRCERR_MASK)

#define CAN_ESR1_ACKERR_MASK                     (0x2000U)
#define CAN_ESR1_ACKERR_SHIFT                    (13U)
/*! ACKERR - Acknowledge Error Flag
 *  0b0..No error
 *  0b1..An ACK error occurred since last read of this register.
 */
#define CAN_ESR1_ACKERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ACKERR_SHIFT)) & CAN_ESR1_ACKERR_MASK)

#define CAN_ESR1_BIT0ERR_MASK                    (0x4000U)
#define CAN_ESR1_BIT0ERR_SHIFT                   (14U)
/*! BIT0ERR - Bit0 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_SHIFT)) & CAN_ESR1_BIT0ERR_MASK)

#define CAN_ESR1_BIT1ERR_MASK                    (0x8000U)
#define CAN_ESR1_BIT1ERR_SHIFT                   (15U)
/*! BIT1ERR - Bit1 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_SHIFT)) & CAN_ESR1_BIT1ERR_MASK)

#define CAN_ESR1_RWRNINT_MASK                    (0x10000U)
#define CAN_ESR1_RWRNINT_SHIFT                   (16U)
/*! RWRNINT - RX Warning Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..RX error counter changed from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_RWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RWRNINT_SHIFT)) & CAN_ESR1_RWRNINT_MASK)

#define CAN_ESR1_TWRNINT_MASK                    (0x20000U)
#define CAN_ESR1_TWRNINT_SHIFT                   (17U)
/*! TWRNINT - TX Warning Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..TX error counter changed from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_TWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TWRNINT_SHIFT)) & CAN_ESR1_TWRNINT_MASK)

#define CAN_ESR1_SYNCH_MASK                      (0x40000U)
#define CAN_ESR1_SYNCH_SHIFT                     (18U)
/*! SYNCH - CAN Synchronization Status Flag
 *  0b0..Not synchronized
 *  0b1..Synchronized
 */
#define CAN_ESR1_SYNCH(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_SYNCH_SHIFT)) & CAN_ESR1_SYNCH_MASK)

#define CAN_ESR1_BOFFDONEINT_MASK                (0x80000U)
#define CAN_ESR1_BOFFDONEINT_SHIFT               (19U)
/*! BOFFDONEINT - Bus Off Done Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..FlexCAN module has completed Bus Off process.
 */
#define CAN_ESR1_BOFFDONEINT(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFDONEINT_SHIFT)) & CAN_ESR1_BOFFDONEINT_MASK)

#define CAN_ESR1_ERRINT_FAST_MASK                (0x100000U)
#define CAN_ESR1_ERRINT_FAST_SHIFT               (20U)
/*! ERRINT_FAST - Fast Error Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Error flag set in the data phase of CAN FD frames that have BRS = 1.
 */
#define CAN_ESR1_ERRINT_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_FAST_SHIFT)) & CAN_ESR1_ERRINT_FAST_MASK)

#define CAN_ESR1_ERROVR_MASK                     (0x200000U)
#define CAN_ESR1_ERROVR_SHIFT                    (21U)
/*! ERROVR - Error Overrun Flag
 *  0b0..No overrun
 *  0b1..Overrun
 */
#define CAN_ESR1_ERROVR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERROVR_SHIFT)) & CAN_ESR1_ERROVR_MASK)

#define CAN_ESR1_STFERR_FAST_MASK                (0x4000000U)
#define CAN_ESR1_STFERR_FAST_SHIFT               (26U)
/*! STFERR_FAST - Fast Stuffing Error Flag
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_FAST_SHIFT)) & CAN_ESR1_STFERR_FAST_MASK)

#define CAN_ESR1_FRMERR_FAST_MASK                (0x8000000U)
#define CAN_ESR1_FRMERR_FAST_SHIFT               (27U)
/*! FRMERR_FAST - Fast Form Error Flag
 *  0b0..No such occurrence.
 *  0b1..A form error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_FAST_SHIFT)) & CAN_ESR1_FRMERR_FAST_MASK)

#define CAN_ESR1_CRCERR_FAST_MASK                (0x10000000U)
#define CAN_ESR1_CRCERR_FAST_SHIFT               (28U)
/*! CRCERR_FAST - Fast Cyclic Redundancy Check Error Flag
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_FAST_SHIFT)) & CAN_ESR1_CRCERR_FAST_MASK)

#define CAN_ESR1_BIT0ERR_FAST_MASK               (0x40000000U)
#define CAN_ESR1_BIT0ERR_FAST_SHIFT              (30U)
/*! BIT0ERR_FAST - Fast Bit0 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_FAST_SHIFT)) & CAN_ESR1_BIT0ERR_FAST_MASK)

#define CAN_ESR1_BIT1ERR_FAST_MASK               (0x80000000U)
#define CAN_ESR1_BIT1ERR_FAST_SHIFT              (31U)
/*! BIT1ERR_FAST - Fast Bit1 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_FAST_SHIFT)) & CAN_ESR1_BIT1ERR_FAST_MASK)
/*! @} */

/*! @name IMASK1 - Interrupt Masks 1 */
/*! @{ */

#define CAN_IMASK1_BUF31TO0M_MASK                (0xFFFFFFFFU)
#define CAN_IMASK1_BUF31TO0M_SHIFT               (0U)
/*! BUF31TO0M - Buffer MBi Mask */
#define CAN_IMASK1_BUF31TO0M(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IMASK1_BUF31TO0M_SHIFT)) & CAN_IMASK1_BUF31TO0M_MASK)
/*! @} */

/*! @name IFLAG1 - Interrupt Flags 1 */
/*! @{ */

#define CAN_IFLAG1_BUF0I_MASK                    (0x1U)
#define CAN_IFLAG1_BUF0I_SHIFT                   (0U)
/*! BUF0I - Buffer MB0 Interrupt or Clear Legacy FIFO bit
 *  0b0..MB0 has no occurrence of successfully completed transmission or reception.
 *  0b1..MB0 has successfully completed transmission or reception.
 */
#define CAN_IFLAG1_BUF0I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF0I_SHIFT)) & CAN_IFLAG1_BUF0I_MASK)

#define CAN_IFLAG1_BUF4TO1I_MASK                 (0x1EU)
#define CAN_IFLAG1_BUF4TO1I_SHIFT                (1U)
/*! BUF4TO1I - Buffer MBi Interrupt or Reserved */
#define CAN_IFLAG1_BUF4TO1I(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF4TO1I_SHIFT)) & CAN_IFLAG1_BUF4TO1I_MASK)

#define CAN_IFLAG1_BUF5I_MASK                    (0x20U)
#define CAN_IFLAG1_BUF5I_SHIFT                   (5U)
/*! BUF5I - Buffer MB5 Interrupt or Frames available in Legacy RX FIFO
 *  0b0..No occurrence of completed transmission or reception, or no frames available
 *  0b1..MB5 completed transmission or reception, or frames available
 */
#define CAN_IFLAG1_BUF5I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF5I_SHIFT)) & CAN_IFLAG1_BUF5I_MASK)

#define CAN_IFLAG1_BUF6I_MASK                    (0x40U)
#define CAN_IFLAG1_BUF6I_SHIFT                   (6U)
/*! BUF6I - Buffer MB6 Interrupt or Legacy RX FIFO Warning
 *  0b0..No occurrence of MB6 completing transmission or reception, or FIFO not almost full.
 *  0b1..MB6 completed transmission or reception, or FIFO almost full.
 */
#define CAN_IFLAG1_BUF6I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF6I_SHIFT)) & CAN_IFLAG1_BUF6I_MASK)

#define CAN_IFLAG1_BUF7I_MASK                    (0x80U)
#define CAN_IFLAG1_BUF7I_SHIFT                   (7U)
/*! BUF7I - Buffer MB7 Interrupt or Legacy RX FIFO Overflow
 *  0b0..No occurrence of MB7 completing transmission or reception, or no FIFO overflow.
 *  0b1..MB7 completed transmission or reception, or FIFO overflow.
 */
#define CAN_IFLAG1_BUF7I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF7I_SHIFT)) & CAN_IFLAG1_BUF7I_MASK)

#define CAN_IFLAG1_BUF31TO8I_MASK                (0xFFFFFF00U)
#define CAN_IFLAG1_BUF31TO8I_SHIFT               (8U)
/*! BUF31TO8I - Buffer MBi Interrupt */
#define CAN_IFLAG1_BUF31TO8I(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF31TO8I_SHIFT)) & CAN_IFLAG1_BUF31TO8I_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 */
/*! @{ */

#define CAN_CTRL2_EDFLTDIS_MASK                  (0x800U)
#define CAN_CTRL2_EDFLTDIS_SHIFT                 (11U)
/*! EDFLTDIS - Edge Filter Disable
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define CAN_CTRL2_EDFLTDIS(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EDFLTDIS_SHIFT)) & CAN_CTRL2_EDFLTDIS_MASK)

#define CAN_CTRL2_ISOCANFDEN_MASK                (0x1000U)
#define CAN_CTRL2_ISOCANFDEN_SHIFT               (12U)
/*! ISOCANFDEN - ISO CAN FD Enable
 *  0b0..Disable. FlexCAN operates using the non-ISO CAN FD protocol.
 *  0b1..Enable. FlexCAN operates using the ISO CAN FD protocol (ISO 11898-1:2015).
 */
#define CAN_CTRL2_ISOCANFDEN(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ISOCANFDEN_SHIFT)) & CAN_CTRL2_ISOCANFDEN_MASK)

#define CAN_CTRL2_BTE_MASK                       (0x2000U)
#define CAN_CTRL2_BTE_SHIFT                      (13U)
/*! BTE - Bit Timing Expansion Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_BTE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BTE_SHIFT)) & CAN_CTRL2_BTE_MASK)

#define CAN_CTRL2_PREXCEN_MASK                   (0x4000U)
#define CAN_CTRL2_PREXCEN_SHIFT                  (14U)
/*! PREXCEN - Protocol Exception Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL2_PREXCEN(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PREXCEN_SHIFT)) & CAN_CTRL2_PREXCEN_MASK)

#define CAN_CTRL2_EACEN_MASK                     (0x10000U)
#define CAN_CTRL2_EACEN_SHIFT                    (16U)
/*! EACEN - Entire Frame Arbitration Field Comparison Enable for RX Message Buffers
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_EACEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EACEN_SHIFT)) & CAN_CTRL2_EACEN_MASK)

#define CAN_CTRL2_RRS_MASK                       (0x20000U)
#define CAN_CTRL2_RRS_SHIFT                      (17U)
/*! RRS - Remote Request Storing
 *  0b0..Generated
 *  0b1..Stored
 */
#define CAN_CTRL2_RRS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RRS_SHIFT)) & CAN_CTRL2_RRS_MASK)

#define CAN_CTRL2_MRP_MASK                       (0x40000U)
#define CAN_CTRL2_MRP_SHIFT                      (18U)
/*! MRP - Message Buffers Reception Priority
 *  0b0..Matching starts from Legacy RX FIFO or Enhanced RX FIFO and continues on message buffers.
 *  0b1..Matching starts from message buffers and continues on Legacy RX FIFO or Enhanced RX FIFO.
 */
#define CAN_CTRL2_MRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_MRP_SHIFT)) & CAN_CTRL2_MRP_MASK)

#define CAN_CTRL2_TASD_MASK                      (0xF80000U)
#define CAN_CTRL2_TASD_SHIFT                     (19U)
/*! TASD - Transmission Arbitration Start Delay */
#define CAN_CTRL2_TASD(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TASD_SHIFT)) & CAN_CTRL2_TASD_MASK)

#define CAN_CTRL2_RFFN_MASK                      (0xF000000U)
#define CAN_CTRL2_RFFN_SHIFT                     (24U)
/*! RFFN - Number of Legacy Receive FIFO Filters */
#define CAN_CTRL2_RFFN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RFFN_SHIFT)) & CAN_CTRL2_RFFN_MASK)

#define CAN_CTRL2_BOFFDONEMSK_MASK               (0x40000000U)
#define CAN_CTRL2_BOFFDONEMSK_SHIFT              (30U)
/*! BOFFDONEMSK - Bus Off Done Interrupt Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_BOFFDONEMSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BOFFDONEMSK_SHIFT)) & CAN_CTRL2_BOFFDONEMSK_MASK)

#define CAN_CTRL2_ERRMSK_FAST_MASK               (0x80000000U)
#define CAN_CTRL2_ERRMSK_FAST_SHIFT              (31U)
/*! ERRMSK_FAST - Error Interrupt Mask for Errors Detected in the Data Phase of Fast CAN FD Frames
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_ERRMSK_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ERRMSK_FAST_SHIFT)) & CAN_CTRL2_ERRMSK_FAST_MASK)
/*! @} */

/*! @name ESR2 - Error and Status 2 */
/*! @{ */

#define CAN_ESR2_IMB_MASK                        (0x2000U)
#define CAN_ESR2_IMB_SHIFT                       (13U)
/*! IMB - Inactive Message Buffer
 *  0b0..Message buffer indicated by ESR2[LPTM] is not inactive.
 *  0b1..At least one message buffer is inactive.
 */
#define CAN_ESR2_IMB(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_IMB_SHIFT)) & CAN_ESR2_IMB_MASK)

#define CAN_ESR2_VPS_MASK                        (0x4000U)
#define CAN_ESR2_VPS_SHIFT                       (14U)
/*! VPS - Valid Priority Status
 *  0b0..Invalid
 *  0b1..Valid
 */
#define CAN_ESR2_VPS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_VPS_SHIFT)) & CAN_ESR2_VPS_MASK)

#define CAN_ESR2_LPTM_MASK                       (0x7F0000U)
#define CAN_ESR2_LPTM_SHIFT                      (16U)
/*! LPTM - Lowest Priority TX Message Buffer */
#define CAN_ESR2_LPTM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_LPTM_SHIFT)) & CAN_ESR2_LPTM_MASK)
/*! @} */

/*! @name CRCR - Cyclic Redundancy Check */
/*! @{ */

#define CAN_CRCR_TXCRC_MASK                      (0x7FFFU)
#define CAN_CRCR_TXCRC_SHIFT                     (0U)
/*! TXCRC - Transmitted CRC value */
#define CAN_CRCR_TXCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_TXCRC_SHIFT)) & CAN_CRCR_TXCRC_MASK)

#define CAN_CRCR_MBCRC_MASK                      (0x7F0000U)
#define CAN_CRCR_MBCRC_SHIFT                     (16U)
/*! MBCRC - CRC Message Buffer */
#define CAN_CRCR_MBCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_MBCRC_SHIFT)) & CAN_CRCR_MBCRC_MASK)
/*! @} */

/*! @name RXFGMASK - Legacy RX FIFO Global Mask */
/*! @{ */

#define CAN_RXFGMASK_FGM_MASK                    (0xFFFFFFFFU)
#define CAN_RXFGMASK_FGM_SHIFT                   (0U)
/*! FGM - Legacy RX FIFO Global Mask Bits */
#define CAN_RXFGMASK_FGM(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_RXFGMASK_FGM_SHIFT)) & CAN_RXFGMASK_FGM_MASK)
/*! @} */

/*! @name RXFIR - Legacy RX FIFO Information */
/*! @{ */

#define CAN_RXFIR_IDHIT_MASK                     (0x1FFU)
#define CAN_RXFIR_IDHIT_SHIFT                    (0U)
/*! IDHIT - Identifier Acceptance Filter Hit Indicator */
#define CAN_RXFIR_IDHIT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXFIR_IDHIT_SHIFT)) & CAN_RXFIR_IDHIT_MASK)
/*! @} */

/*! @name CBT - CAN Bit Timing */
/*! @{ */

#define CAN_CBT_EPSEG2_MASK                      (0x1FU)
#define CAN_CBT_EPSEG2_SHIFT                     (0U)
/*! EPSEG2 - Extended Phase Segment 2 */
#define CAN_CBT_EPSEG2(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG2_SHIFT)) & CAN_CBT_EPSEG2_MASK)

#define CAN_CBT_EPSEG1_MASK                      (0x3E0U)
#define CAN_CBT_EPSEG1_SHIFT                     (5U)
/*! EPSEG1 - Extended Phase Segment 1 */
#define CAN_CBT_EPSEG1(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG1_SHIFT)) & CAN_CBT_EPSEG1_MASK)

#define CAN_CBT_EPROPSEG_MASK                    (0xFC00U)
#define CAN_CBT_EPROPSEG_SHIFT                   (10U)
/*! EPROPSEG - Extended Propagation Segment */
#define CAN_CBT_EPROPSEG(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPROPSEG_SHIFT)) & CAN_CBT_EPROPSEG_MASK)

#define CAN_CBT_ERJW_MASK                        (0x1F0000U)
#define CAN_CBT_ERJW_SHIFT                       (16U)
/*! ERJW - Extended Resync Jump Width */
#define CAN_CBT_ERJW(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CBT_ERJW_SHIFT)) & CAN_CBT_ERJW_MASK)

#define CAN_CBT_EPRESDIV_MASK                    (0x7FE00000U)
#define CAN_CBT_EPRESDIV_SHIFT                   (21U)
/*! EPRESDIV - Extended Prescaler Division Factor */
#define CAN_CBT_EPRESDIV(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPRESDIV_SHIFT)) & CAN_CBT_EPRESDIV_MASK)

#define CAN_CBT_BTF_MASK                         (0x80000000U)
#define CAN_CBT_BTF_SHIFT                        (31U)
/*! BTF - Bit Timing Format Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CBT_BTF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CBT_BTF_SHIFT)) & CAN_CBT_BTF_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB8B                        (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB8B                        (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B                      (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B2                     (2U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB16B                       (21U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB16B                       (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B                     (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B2                    (4U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB32B                       (12U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB32B                       (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B                     (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B2                    (8U)

/*! @name CS - Message Buffer 0 CS Register..Message Buffer 6 CS Register */
/*! @{ */

#define CAN_CS_TIME_STAMP_MASK                   (0xFFFFU)
#define CAN_CS_TIME_STAMP_SHIFT                  (0U)
/*! TIME_STAMP - Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running
 *    Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field
 *    appears on the CAN bus.
 */
#define CAN_CS_TIME_STAMP(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CS_TIME_STAMP_SHIFT)) & CAN_CS_TIME_STAMP_MASK)

#define CAN_CS_DLC_MASK                          (0xF0000U)
#define CAN_CS_DLC_SHIFT                         (16U)
/*! DLC - Length of the data to be stored/transmitted. */
#define CAN_CS_DLC(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_DLC_SHIFT)) & CAN_CS_DLC_MASK)

#define CAN_CS_RTR_MASK                          (0x100000U)
#define CAN_CS_RTR_SHIFT                         (20U)
/*! RTR - Remote Transmission Request. One/zero for remote/data frame. */
#define CAN_CS_RTR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_RTR_SHIFT)) & CAN_CS_RTR_MASK)

#define CAN_CS_IDE_MASK                          (0x200000U)
#define CAN_CS_IDE_SHIFT                         (21U)
/*! IDE - ID Extended. One/zero for extended/standard format frame. */
#define CAN_CS_IDE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_IDE_SHIFT)) & CAN_CS_IDE_MASK)

#define CAN_CS_SRR_MASK                          (0x400000U)
#define CAN_CS_SRR_SHIFT                         (22U)
/*! SRR - Substitute Remote Request. Contains a fixed recessive bit. */
#define CAN_CS_SRR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_SRR_SHIFT)) & CAN_CS_SRR_MASK)

#define CAN_CS_CODE_MASK                         (0xF000000U)
#define CAN_CS_CODE_SHIFT                        (24U)
/*! CODE - Message Buffer Code. This 4-bit field can be accessed (read or write) by the CPU and by
 *    the FlexCAN module itself, as part of the message buffer matching and arbitration process.
 */
#define CAN_CS_CODE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CS_CODE_SHIFT)) & CAN_CS_CODE_MASK)

#define CAN_CS_ESI_MASK                          (0x20000000U)
#define CAN_CS_ESI_SHIFT                         (29U)
/*! ESI - Error State Indicator. This bit indicates if the transmitting node is error active or error passive. */
#define CAN_CS_ESI(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_ESI_SHIFT)) & CAN_CS_ESI_MASK)

#define CAN_CS_BRS_MASK                          (0x40000000U)
#define CAN_CS_BRS_SHIFT                         (30U)
/*! BRS - Bit Rate Switch. This bit defines whether the bit rate is switched inside a CAN FD format frame. */
#define CAN_CS_BRS(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_BRS_SHIFT)) & CAN_CS_BRS_MASK)

#define CAN_CS_EDL_MASK                          (0x80000000U)
#define CAN_CS_EDL_SHIFT                         (31U)
/*! EDL - Extended Data Length. This bit distinguishes between CAN format and CAN FD format frames.
 *    The EDL bit must not be set for Message Buffers configured to RANSWER with code field 0b1010.
 */
#define CAN_CS_EDL(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_EDL_SHIFT)) & CAN_CS_EDL_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB64B                       (7U)

/*! @name ID - Message Buffer 0 ID Register..Message Buffer 6 ID Register */
/*! @{ */

#define CAN_ID_EXT_MASK                          (0x3FFFFU)
#define CAN_ID_EXT_SHIFT                         (0U)
/*! EXT - Contains extended (LOW word) identifier of message buffer. */
#define CAN_ID_EXT(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_EXT_SHIFT)) & CAN_ID_EXT_MASK)

#define CAN_ID_STD_MASK                          (0x1FFC0000U)
#define CAN_ID_STD_SHIFT                         (18U)
/*! STD - Contains standard/extended (HIGH word) identifier of message buffer. */
#define CAN_ID_STD(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_STD_SHIFT)) & CAN_ID_STD_MASK)

#define CAN_ID_PRIO_MASK                         (0xE0000000U)
#define CAN_ID_PRIO_SHIFT                        (29U)
/*! PRIO - Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only
 *    makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular
 *    ID to define the transmission priority.
 */
#define CAN_ID_PRIO(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ID_PRIO_SHIFT)) & CAN_ID_PRIO_MASK)
/*! @} */

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB64B                       (7U)

/*! @name WORD - Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register */
/*! @{ */

#define CAN_WORD_DATA_BYTE_3_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_3_SHIFT               (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_3(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_3_SHIFT)) & CAN_WORD_DATA_BYTE_3_MASK)

#define CAN_WORD_DATA_BYTE_7_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_7_SHIFT               (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_7(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_7_SHIFT)) & CAN_WORD_DATA_BYTE_7_MASK)

#define CAN_WORD_DATA_BYTE_11_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_11_SHIFT              (0U)
/*! DATA_BYTE_11 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_11(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_11_SHIFT)) & CAN_WORD_DATA_BYTE_11_MASK)

#define CAN_WORD_DATA_BYTE_15_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_15_SHIFT              (0U)
/*! DATA_BYTE_15 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_15(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_15_SHIFT)) & CAN_WORD_DATA_BYTE_15_MASK)

#define CAN_WORD_DATA_BYTE_19_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_19_SHIFT              (0U)
/*! DATA_BYTE_19 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_19(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_19_SHIFT)) & CAN_WORD_DATA_BYTE_19_MASK)

#define CAN_WORD_DATA_BYTE_23_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_23_SHIFT              (0U)
/*! DATA_BYTE_23 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_23(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_23_SHIFT)) & CAN_WORD_DATA_BYTE_23_MASK)

#define CAN_WORD_DATA_BYTE_27_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_27_SHIFT              (0U)
/*! DATA_BYTE_27 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_27(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_27_SHIFT)) & CAN_WORD_DATA_BYTE_27_MASK)

#define CAN_WORD_DATA_BYTE_31_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_31_SHIFT              (0U)
/*! DATA_BYTE_31 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_31(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_31_SHIFT)) & CAN_WORD_DATA_BYTE_31_MASK)

#define CAN_WORD_DATA_BYTE_35_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_35_SHIFT              (0U)
/*! DATA_BYTE_35 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_35(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_35_SHIFT)) & CAN_WORD_DATA_BYTE_35_MASK)

#define CAN_WORD_DATA_BYTE_39_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_39_SHIFT              (0U)
/*! DATA_BYTE_39 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_39(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_39_SHIFT)) & CAN_WORD_DATA_BYTE_39_MASK)

#define CAN_WORD_DATA_BYTE_43_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_43_SHIFT              (0U)
/*! DATA_BYTE_43 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_43(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_43_SHIFT)) & CAN_WORD_DATA_BYTE_43_MASK)

#define CAN_WORD_DATA_BYTE_47_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_47_SHIFT              (0U)
/*! DATA_BYTE_47 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_47(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_47_SHIFT)) & CAN_WORD_DATA_BYTE_47_MASK)

#define CAN_WORD_DATA_BYTE_51_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_51_SHIFT              (0U)
/*! DATA_BYTE_51 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_51(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_51_SHIFT)) & CAN_WORD_DATA_BYTE_51_MASK)

#define CAN_WORD_DATA_BYTE_55_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_55_SHIFT              (0U)
/*! DATA_BYTE_55 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_55(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_55_SHIFT)) & CAN_WORD_DATA_BYTE_55_MASK)

#define CAN_WORD_DATA_BYTE_59_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_59_SHIFT              (0U)
/*! DATA_BYTE_59 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_59(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_59_SHIFT)) & CAN_WORD_DATA_BYTE_59_MASK)

#define CAN_WORD_DATA_BYTE_63_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_63_SHIFT              (0U)
/*! DATA_BYTE_63 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_63(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_63_SHIFT)) & CAN_WORD_DATA_BYTE_63_MASK)

#define CAN_WORD_DATA_BYTE_2_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_2_SHIFT               (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_2(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_2_SHIFT)) & CAN_WORD_DATA_BYTE_2_MASK)

#define CAN_WORD_DATA_BYTE_6_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_6_SHIFT               (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_6(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_6_SHIFT)) & CAN_WORD_DATA_BYTE_6_MASK)

#define CAN_WORD_DATA_BYTE_10_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_10_SHIFT              (8U)
/*! DATA_BYTE_10 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_10(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_10_SHIFT)) & CAN_WORD_DATA_BYTE_10_MASK)

#define CAN_WORD_DATA_BYTE_14_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_14_SHIFT              (8U)
/*! DATA_BYTE_14 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_14(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_14_SHIFT)) & CAN_WORD_DATA_BYTE_14_MASK)

#define CAN_WORD_DATA_BYTE_18_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_18_SHIFT              (8U)
/*! DATA_BYTE_18 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_18(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_18_SHIFT)) & CAN_WORD_DATA_BYTE_18_MASK)

#define CAN_WORD_DATA_BYTE_22_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_22_SHIFT              (8U)
/*! DATA_BYTE_22 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_22(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_22_SHIFT)) & CAN_WORD_DATA_BYTE_22_MASK)

#define CAN_WORD_DATA_BYTE_26_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_26_SHIFT              (8U)
/*! DATA_BYTE_26 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_26(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_26_SHIFT)) & CAN_WORD_DATA_BYTE_26_MASK)

#define CAN_WORD_DATA_BYTE_30_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_30_SHIFT              (8U)
/*! DATA_BYTE_30 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_30(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_30_SHIFT)) & CAN_WORD_DATA_BYTE_30_MASK)

#define CAN_WORD_DATA_BYTE_34_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_34_SHIFT              (8U)
/*! DATA_BYTE_34 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_34(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_34_SHIFT)) & CAN_WORD_DATA_BYTE_34_MASK)

#define CAN_WORD_DATA_BYTE_38_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_38_SHIFT              (8U)
/*! DATA_BYTE_38 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_38(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_38_SHIFT)) & CAN_WORD_DATA_BYTE_38_MASK)

#define CAN_WORD_DATA_BYTE_42_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_42_SHIFT              (8U)
/*! DATA_BYTE_42 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_42(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_42_SHIFT)) & CAN_WORD_DATA_BYTE_42_MASK)

#define CAN_WORD_DATA_BYTE_46_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_46_SHIFT              (8U)
/*! DATA_BYTE_46 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_46(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_46_SHIFT)) & CAN_WORD_DATA_BYTE_46_MASK)

#define CAN_WORD_DATA_BYTE_50_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_50_SHIFT              (8U)
/*! DATA_BYTE_50 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_50(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_50_SHIFT)) & CAN_WORD_DATA_BYTE_50_MASK)

#define CAN_WORD_DATA_BYTE_54_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_54_SHIFT              (8U)
/*! DATA_BYTE_54 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_54(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_54_SHIFT)) & CAN_WORD_DATA_BYTE_54_MASK)

#define CAN_WORD_DATA_BYTE_58_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_58_SHIFT              (8U)
/*! DATA_BYTE_58 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_58(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_58_SHIFT)) & CAN_WORD_DATA_BYTE_58_MASK)

#define CAN_WORD_DATA_BYTE_62_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_62_SHIFT              (8U)
/*! DATA_BYTE_62 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_62(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_62_SHIFT)) & CAN_WORD_DATA_BYTE_62_MASK)

#define CAN_WORD_DATA_BYTE_1_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_1_SHIFT               (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_1(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_1_SHIFT)) & CAN_WORD_DATA_BYTE_1_MASK)

#define CAN_WORD_DATA_BYTE_5_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_5_SHIFT               (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_5(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_5_SHIFT)) & CAN_WORD_DATA_BYTE_5_MASK)

#define CAN_WORD_DATA_BYTE_9_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_9_SHIFT               (16U)
/*! DATA_BYTE_9 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_9(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_9_SHIFT)) & CAN_WORD_DATA_BYTE_9_MASK)

#define CAN_WORD_DATA_BYTE_13_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_13_SHIFT              (16U)
/*! DATA_BYTE_13 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_13(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_13_SHIFT)) & CAN_WORD_DATA_BYTE_13_MASK)

#define CAN_WORD_DATA_BYTE_17_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_17_SHIFT              (16U)
/*! DATA_BYTE_17 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_17(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_17_SHIFT)) & CAN_WORD_DATA_BYTE_17_MASK)

#define CAN_WORD_DATA_BYTE_21_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_21_SHIFT              (16U)
/*! DATA_BYTE_21 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_21(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_21_SHIFT)) & CAN_WORD_DATA_BYTE_21_MASK)

#define CAN_WORD_DATA_BYTE_25_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_25_SHIFT              (16U)
/*! DATA_BYTE_25 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_25(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_25_SHIFT)) & CAN_WORD_DATA_BYTE_25_MASK)

#define CAN_WORD_DATA_BYTE_29_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_29_SHIFT              (16U)
/*! DATA_BYTE_29 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_29(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_29_SHIFT)) & CAN_WORD_DATA_BYTE_29_MASK)

#define CAN_WORD_DATA_BYTE_33_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_33_SHIFT              (16U)
/*! DATA_BYTE_33 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_33(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_33_SHIFT)) & CAN_WORD_DATA_BYTE_33_MASK)

#define CAN_WORD_DATA_BYTE_37_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_37_SHIFT              (16U)
/*! DATA_BYTE_37 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_37(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_37_SHIFT)) & CAN_WORD_DATA_BYTE_37_MASK)

#define CAN_WORD_DATA_BYTE_41_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_41_SHIFT              (16U)
/*! DATA_BYTE_41 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_41(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_41_SHIFT)) & CAN_WORD_DATA_BYTE_41_MASK)

#define CAN_WORD_DATA_BYTE_45_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_45_SHIFT              (16U)
/*! DATA_BYTE_45 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_45(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_45_SHIFT)) & CAN_WORD_DATA_BYTE_45_MASK)

#define CAN_WORD_DATA_BYTE_49_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_49_SHIFT              (16U)
/*! DATA_BYTE_49 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_49(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_49_SHIFT)) & CAN_WORD_DATA_BYTE_49_MASK)

#define CAN_WORD_DATA_BYTE_53_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_53_SHIFT              (16U)
/*! DATA_BYTE_53 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_53(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_53_SHIFT)) & CAN_WORD_DATA_BYTE_53_MASK)

#define CAN_WORD_DATA_BYTE_57_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_57_SHIFT              (16U)
/*! DATA_BYTE_57 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_57(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_57_SHIFT)) & CAN_WORD_DATA_BYTE_57_MASK)

#define CAN_WORD_DATA_BYTE_61_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_61_SHIFT              (16U)
/*! DATA_BYTE_61 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_61(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_61_SHIFT)) & CAN_WORD_DATA_BYTE_61_MASK)

#define CAN_WORD_DATA_BYTE_0_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_0_SHIFT               (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_0(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_0_SHIFT)) & CAN_WORD_DATA_BYTE_0_MASK)

#define CAN_WORD_DATA_BYTE_4_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_4_SHIFT               (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_4(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_4_SHIFT)) & CAN_WORD_DATA_BYTE_4_MASK)

#define CAN_WORD_DATA_BYTE_8_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_8_SHIFT               (24U)
/*! DATA_BYTE_8 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_8(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_8_SHIFT)) & CAN_WORD_DATA_BYTE_8_MASK)

#define CAN_WORD_DATA_BYTE_12_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_12_SHIFT              (24U)
/*! DATA_BYTE_12 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_12(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_12_SHIFT)) & CAN_WORD_DATA_BYTE_12_MASK)

#define CAN_WORD_DATA_BYTE_16_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_16_SHIFT              (24U)
/*! DATA_BYTE_16 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_16(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_16_SHIFT)) & CAN_WORD_DATA_BYTE_16_MASK)

#define CAN_WORD_DATA_BYTE_20_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_20_SHIFT              (24U)
/*! DATA_BYTE_20 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_20(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_20_SHIFT)) & CAN_WORD_DATA_BYTE_20_MASK)

#define CAN_WORD_DATA_BYTE_24_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_24_SHIFT              (24U)
/*! DATA_BYTE_24 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_24(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_24_SHIFT)) & CAN_WORD_DATA_BYTE_24_MASK)

#define CAN_WORD_DATA_BYTE_28_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_28_SHIFT              (24U)
/*! DATA_BYTE_28 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_28(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_28_SHIFT)) & CAN_WORD_DATA_BYTE_28_MASK)

#define CAN_WORD_DATA_BYTE_32_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_32_SHIFT              (24U)
/*! DATA_BYTE_32 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_32(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_32_SHIFT)) & CAN_WORD_DATA_BYTE_32_MASK)

#define CAN_WORD_DATA_BYTE_36_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_36_SHIFT              (24U)
/*! DATA_BYTE_36 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_36(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_36_SHIFT)) & CAN_WORD_DATA_BYTE_36_MASK)

#define CAN_WORD_DATA_BYTE_40_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_40_SHIFT              (24U)
/*! DATA_BYTE_40 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_40(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_40_SHIFT)) & CAN_WORD_DATA_BYTE_40_MASK)

#define CAN_WORD_DATA_BYTE_44_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_44_SHIFT              (24U)
/*! DATA_BYTE_44 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_44(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_44_SHIFT)) & CAN_WORD_DATA_BYTE_44_MASK)

#define CAN_WORD_DATA_BYTE_48_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_48_SHIFT              (24U)
/*! DATA_BYTE_48 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_48(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_48_SHIFT)) & CAN_WORD_DATA_BYTE_48_MASK)

#define CAN_WORD_DATA_BYTE_52_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_52_SHIFT              (24U)
/*! DATA_BYTE_52 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_52(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_52_SHIFT)) & CAN_WORD_DATA_BYTE_52_MASK)

#define CAN_WORD_DATA_BYTE_56_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_56_SHIFT              (24U)
/*! DATA_BYTE_56 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_56(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_56_SHIFT)) & CAN_WORD_DATA_BYTE_56_MASK)

#define CAN_WORD_DATA_BYTE_60_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_60_SHIFT              (24U)
/*! DATA_BYTE_60 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_60(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_60_SHIFT)) & CAN_WORD_DATA_BYTE_60_MASK)
/*! @} */

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B                     (7U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B2                    (16U)

/* The count of CAN_CS */
#define CAN_CS_COUNT                             (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT                             (32U)

/*! @name WORD0 - Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register */
/*! @{ */

#define CAN_WORD0_DATA_BYTE_3_MASK               (0xFFU)
#define CAN_WORD0_DATA_BYTE_3_SHIFT              (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_3(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_3_SHIFT)) & CAN_WORD0_DATA_BYTE_3_MASK)

#define CAN_WORD0_DATA_BYTE_2_MASK               (0xFF00U)
#define CAN_WORD0_DATA_BYTE_2_SHIFT              (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_2(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_2_SHIFT)) & CAN_WORD0_DATA_BYTE_2_MASK)

#define CAN_WORD0_DATA_BYTE_1_MASK               (0xFF0000U)
#define CAN_WORD0_DATA_BYTE_1_SHIFT              (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_1(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_1_SHIFT)) & CAN_WORD0_DATA_BYTE_1_MASK)

#define CAN_WORD0_DATA_BYTE_0_MASK               (0xFF000000U)
#define CAN_WORD0_DATA_BYTE_0_SHIFT              (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_0(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_0_SHIFT)) & CAN_WORD0_DATA_BYTE_0_MASK)
/*! @} */

/* The count of CAN_WORD0 */
#define CAN_WORD0_COUNT                          (32U)

/*! @name WORD1 - Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register */
/*! @{ */

#define CAN_WORD1_DATA_BYTE_7_MASK               (0xFFU)
#define CAN_WORD1_DATA_BYTE_7_SHIFT              (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_7(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_7_SHIFT)) & CAN_WORD1_DATA_BYTE_7_MASK)

#define CAN_WORD1_DATA_BYTE_6_MASK               (0xFF00U)
#define CAN_WORD1_DATA_BYTE_6_SHIFT              (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_6(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_6_SHIFT)) & CAN_WORD1_DATA_BYTE_6_MASK)

#define CAN_WORD1_DATA_BYTE_5_MASK               (0xFF0000U)
#define CAN_WORD1_DATA_BYTE_5_SHIFT              (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_5(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_5_SHIFT)) & CAN_WORD1_DATA_BYTE_5_MASK)

#define CAN_WORD1_DATA_BYTE_4_MASK               (0xFF000000U)
#define CAN_WORD1_DATA_BYTE_4_SHIFT              (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_4(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_4_SHIFT)) & CAN_WORD1_DATA_BYTE_4_MASK)
/*! @} */

/* The count of CAN_WORD1 */
#define CAN_WORD1_COUNT                          (32U)

/*! @name RXIMR - Receive Individual Mask */
/*! @{ */

#define CAN_RXIMR_MI_MASK                        (0xFFFFFFFFU)
#define CAN_RXIMR_MI_SHIFT                       (0U)
/*! MI - Individual Mask Bits */
#define CAN_RXIMR_MI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_RXIMR_MI_SHIFT)) & CAN_RXIMR_MI_MASK)
/*! @} */

/* The count of CAN_RXIMR */
#define CAN_RXIMR_COUNT                          (32U)

/*! @name CTRL1_PN - Pretended Networking Control 1 */
/*! @{ */

#define CAN_CTRL1_PN_FCS_MASK                    (0x3U)
#define CAN_CTRL1_PN_FCS_SHIFT                   (0U)
/*! FCS - Filtering Combination Selection
 *  0b00..Message ID filtering only
 *  0b01..Message ID filtering and payload filtering
 *  0b10..Message ID filtering occurring a specified number of times
 *  0b11..Message ID filtering and payload filtering a specified number of times
 */
#define CAN_CTRL1_PN_FCS(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_FCS_SHIFT)) & CAN_CTRL1_PN_FCS_MASK)

#define CAN_CTRL1_PN_IDFS_MASK                   (0xCU)
#define CAN_CTRL1_PN_IDFS_SHIFT                  (2U)
/*! IDFS - ID Filtering Selection
 *  0b00..Match ID contents to an exact target value
 *  0b01..Match an ID value greater than or equal to a specified target value
 *  0b10..Match an ID value smaller than or equal to a specified target value
 *  0b11..Match an ID value within a range of values, inclusive
 */
#define CAN_CTRL1_PN_IDFS(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_IDFS_SHIFT)) & CAN_CTRL1_PN_IDFS_MASK)

#define CAN_CTRL1_PN_PLFS_MASK                   (0x30U)
#define CAN_CTRL1_PN_PLFS_SHIFT                  (4U)
/*! PLFS - Payload Filtering Selection
 *  0b00..Match payload contents to an exact target value
 *  0b01..Match a payload value greater than or equal to a specified target value
 *  0b10..Match a payload value smaller than or equal to a specified target value
 *  0b11..Match upon a payload value within a range of values, inclusive
 */
#define CAN_CTRL1_PN_PLFS(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_PLFS_SHIFT)) & CAN_CTRL1_PN_PLFS_MASK)

#define CAN_CTRL1_PN_NMATCH_MASK                 (0xFF00U)
#define CAN_CTRL1_PN_NMATCH_SHIFT                (8U)
/*! NMATCH - Number of Messages Matching the Same Filtering Criteria
 *  0b00000001..Once
 *  0b00000010..Twice
 *  0b11111111..255 times
 */
#define CAN_CTRL1_PN_NMATCH(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_NMATCH_SHIFT)) & CAN_CTRL1_PN_NMATCH_MASK)

#define CAN_CTRL1_PN_WUMF_MSK_MASK               (0x10000U)
#define CAN_CTRL1_PN_WUMF_MSK_SHIFT              (16U)
/*! WUMF_MSK - Wake-Up by Matching Flag Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_PN_WUMF_MSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_WUMF_MSK_SHIFT)) & CAN_CTRL1_PN_WUMF_MSK_MASK)

#define CAN_CTRL1_PN_WTOF_MSK_MASK               (0x20000U)
#define CAN_CTRL1_PN_WTOF_MSK_SHIFT              (17U)
/*! WTOF_MSK - Wake-Up by Timeout Flag Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_PN_WTOF_MSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_WTOF_MSK_SHIFT)) & CAN_CTRL1_PN_WTOF_MSK_MASK)
/*! @} */

/*! @name CTRL2_PN - Pretended Networking Control 2 */
/*! @{ */

#define CAN_CTRL2_PN_MATCHTO_MASK                (0xFFFFU)
#define CAN_CTRL2_PN_MATCHTO_SHIFT               (0U)
/*! MATCHTO - Timeout for No Message Matching the Filtering Criteria */
#define CAN_CTRL2_PN_MATCHTO(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PN_MATCHTO_SHIFT)) & CAN_CTRL2_PN_MATCHTO_MASK)
/*! @} */

/*! @name WU_MTC - Pretended Networking Wake-Up Match */
/*! @{ */

#define CAN_WU_MTC_MCOUNTER_MASK                 (0xFF00U)
#define CAN_WU_MTC_MCOUNTER_SHIFT                (8U)
/*! MCOUNTER - Number of Matches in Pretended Networking */
#define CAN_WU_MTC_MCOUNTER(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_MCOUNTER_SHIFT)) & CAN_WU_MTC_MCOUNTER_MASK)

#define CAN_WU_MTC_WUMF_MASK                     (0x10000U)
#define CAN_WU_MTC_WUMF_SHIFT                    (16U)
/*! WUMF - Wake-Up by Match Flag
 *  0b0..No event detected
 *  0b1..Event detected
 */
#define CAN_WU_MTC_WUMF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_WUMF_SHIFT)) & CAN_WU_MTC_WUMF_MASK)

#define CAN_WU_MTC_WTOF_MASK                     (0x20000U)
#define CAN_WU_MTC_WTOF_SHIFT                    (17U)
/*! WTOF - Wake Up by Timeout Flag Bit
 *  0b0..No event detected
 *  0b1..Event detected
 */
#define CAN_WU_MTC_WTOF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_WTOF_SHIFT)) & CAN_WU_MTC_WTOF_MASK)
/*! @} */

/*! @name FLT_ID1 - Pretended Networking ID Filter 1 */
/*! @{ */

#define CAN_FLT_ID1_FLT_ID1_MASK                 (0x1FFFFFFFU)
#define CAN_FLT_ID1_FLT_ID1_SHIFT                (0U)
/*! FLT_ID1 - ID Filter 1 for Pretended Networking filtering */
#define CAN_FLT_ID1_FLT_ID1(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_ID1_SHIFT)) & CAN_FLT_ID1_FLT_ID1_MASK)

#define CAN_FLT_ID1_FLT_RTR_MASK                 (0x20000000U)
#define CAN_FLT_ID1_FLT_RTR_SHIFT                (29U)
/*! FLT_RTR - Remote Transmission Request Filter
 *  0b0..Reject remote frame (accept data frame)
 *  0b1..Accept remote frame
 */
#define CAN_FLT_ID1_FLT_RTR(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_RTR_SHIFT)) & CAN_FLT_ID1_FLT_RTR_MASK)

#define CAN_FLT_ID1_FLT_IDE_MASK                 (0x40000000U)
#define CAN_FLT_ID1_FLT_IDE_SHIFT                (30U)
/*! FLT_IDE - ID Extended Filter
 *  0b0..Standard
 *  0b1..Extended
 */
#define CAN_FLT_ID1_FLT_IDE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_IDE_SHIFT)) & CAN_FLT_ID1_FLT_IDE_MASK)
/*! @} */

/*! @name FLT_DLC - Pretended Networking Data Length Code (DLC) Filter */
/*! @{ */

#define CAN_FLT_DLC_FLT_DLC_HI_MASK              (0xFU)
#define CAN_FLT_DLC_FLT_DLC_HI_SHIFT             (0U)
/*! FLT_DLC_HI - Upper Limit for Length of Data Bytes Filter */
#define CAN_FLT_DLC_FLT_DLC_HI(x)                (((uint32_t)(((uint32_t)(x)) << CAN_FLT_DLC_FLT_DLC_HI_SHIFT)) & CAN_FLT_DLC_FLT_DLC_HI_MASK)

#define CAN_FLT_DLC_FLT_DLC_LO_MASK              (0xF0000U)
#define CAN_FLT_DLC_FLT_DLC_LO_SHIFT             (16U)
/*! FLT_DLC_LO - Lower Limit for Length of Data Bytes Filter */
#define CAN_FLT_DLC_FLT_DLC_LO(x)                (((uint32_t)(((uint32_t)(x)) << CAN_FLT_DLC_FLT_DLC_LO_SHIFT)) & CAN_FLT_DLC_FLT_DLC_LO_MASK)
/*! @} */

/*! @name PL1_LO - Pretended Networking Payload Low Filter 1 */
/*! @{ */

#define CAN_PL1_LO_Data_byte_3_MASK              (0xFFU)
#define CAN_PL1_LO_Data_byte_3_SHIFT             (0U)
/*! Data_byte_3 - Data byte 3 */
#define CAN_PL1_LO_Data_byte_3(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_3_SHIFT)) & CAN_PL1_LO_Data_byte_3_MASK)

#define CAN_PL1_LO_Data_byte_2_MASK              (0xFF00U)
#define CAN_PL1_LO_Data_byte_2_SHIFT             (8U)
/*! Data_byte_2 - Data byte 2 */
#define CAN_PL1_LO_Data_byte_2(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_2_SHIFT)) & CAN_PL1_LO_Data_byte_2_MASK)

#define CAN_PL1_LO_Data_byte_1_MASK              (0xFF0000U)
#define CAN_PL1_LO_Data_byte_1_SHIFT             (16U)
/*! Data_byte_1 - Data byte 1 */
#define CAN_PL1_LO_Data_byte_1(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_1_SHIFT)) & CAN_PL1_LO_Data_byte_1_MASK)

#define CAN_PL1_LO_Data_byte_0_MASK              (0xFF000000U)
#define CAN_PL1_LO_Data_byte_0_SHIFT             (24U)
/*! Data_byte_0 - Data byte 0 */
#define CAN_PL1_LO_Data_byte_0(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_0_SHIFT)) & CAN_PL1_LO_Data_byte_0_MASK)
/*! @} */

/*! @name PL1_HI - Pretended Networking Payload High Filter 1 */
/*! @{ */

#define CAN_PL1_HI_Data_byte_7_MASK              (0xFFU)
#define CAN_PL1_HI_Data_byte_7_SHIFT             (0U)
/*! Data_byte_7 - Data byte 7 */
#define CAN_PL1_HI_Data_byte_7(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_7_SHIFT)) & CAN_PL1_HI_Data_byte_7_MASK)

#define CAN_PL1_HI_Data_byte_6_MASK              (0xFF00U)
#define CAN_PL1_HI_Data_byte_6_SHIFT             (8U)
/*! Data_byte_6 - Data byte 6 */
#define CAN_PL1_HI_Data_byte_6(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_6_SHIFT)) & CAN_PL1_HI_Data_byte_6_MASK)

#define CAN_PL1_HI_Data_byte_5_MASK              (0xFF0000U)
#define CAN_PL1_HI_Data_byte_5_SHIFT             (16U)
/*! Data_byte_5 - Data byte 5 */
#define CAN_PL1_HI_Data_byte_5(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_5_SHIFT)) & CAN_PL1_HI_Data_byte_5_MASK)

#define CAN_PL1_HI_Data_byte_4_MASK              (0xFF000000U)
#define CAN_PL1_HI_Data_byte_4_SHIFT             (24U)
/*! Data_byte_4 - Data byte 4 */
#define CAN_PL1_HI_Data_byte_4(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_4_SHIFT)) & CAN_PL1_HI_Data_byte_4_MASK)
/*! @} */

/*! @name FLT_ID2_IDMASK - Pretended Networking ID Filter 2 or ID Mask */
/*! @{ */

#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_MASK   (0x1FFFFFFFU)
#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_SHIFT  (0U)
/*! FLT_ID2_IDMASK - ID Filter 2 for Pretended Networking Filtering or ID Mask Bits for Pretended Networking ID Filtering */
#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK(x)     (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_SHIFT)) & CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_MASK)

#define CAN_FLT_ID2_IDMASK_RTR_MSK_MASK          (0x20000000U)
#define CAN_FLT_ID2_IDMASK_RTR_MSK_SHIFT         (29U)
/*! RTR_MSK - Remote Transmission Request Mask
 *  0b0..The corresponding bit in the filter is "don't care."
 *  0b1..The corresponding bit in the filter is checked.
 */
#define CAN_FLT_ID2_IDMASK_RTR_MSK(x)            (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_RTR_MSK_SHIFT)) & CAN_FLT_ID2_IDMASK_RTR_MSK_MASK)

#define CAN_FLT_ID2_IDMASK_IDE_MSK_MASK          (0x40000000U)
#define CAN_FLT_ID2_IDMASK_IDE_MSK_SHIFT         (30U)
/*! IDE_MSK - ID Extended Mask
 *  0b0..The corresponding bit in the filter is "don't care."
 *  0b1..The corresponding bit in the filter is checked.
 */
#define CAN_FLT_ID2_IDMASK_IDE_MSK(x)            (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_IDE_MSK_SHIFT)) & CAN_FLT_ID2_IDMASK_IDE_MSK_MASK)
/*! @} */

/*! @name PL2_PLMASK_LO - Pretended Networking Payload Low Filter 2 and Payload Low Mask */
/*! @{ */

#define CAN_PL2_PLMASK_LO_Data_byte_3_MASK       (0xFFU)
#define CAN_PL2_PLMASK_LO_Data_byte_3_SHIFT      (0U)
/*! Data_byte_3 - Data Byte 3 */
#define CAN_PL2_PLMASK_LO_Data_byte_3(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_3_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_3_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_2_MASK       (0xFF00U)
#define CAN_PL2_PLMASK_LO_Data_byte_2_SHIFT      (8U)
/*! Data_byte_2 - Data Byte 2 */
#define CAN_PL2_PLMASK_LO_Data_byte_2(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_2_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_2_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_1_MASK       (0xFF0000U)
#define CAN_PL2_PLMASK_LO_Data_byte_1_SHIFT      (16U)
/*! Data_byte_1 - Data Byte 1 */
#define CAN_PL2_PLMASK_LO_Data_byte_1(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_1_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_1_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_0_MASK       (0xFF000000U)
#define CAN_PL2_PLMASK_LO_Data_byte_0_SHIFT      (24U)
/*! Data_byte_0 - Data Byte 0 */
#define CAN_PL2_PLMASK_LO_Data_byte_0(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_0_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_0_MASK)
/*! @} */

/*! @name PL2_PLMASK_HI - Pretended Networking Payload High Filter 2 and Payload High Mask */
/*! @{ */

#define CAN_PL2_PLMASK_HI_Data_byte_7_MASK       (0xFFU)
#define CAN_PL2_PLMASK_HI_Data_byte_7_SHIFT      (0U)
/*! Data_byte_7 - Data Byte 7 */
#define CAN_PL2_PLMASK_HI_Data_byte_7(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_7_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_7_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_6_MASK       (0xFF00U)
#define CAN_PL2_PLMASK_HI_Data_byte_6_SHIFT      (8U)
/*! Data_byte_6 - Data Byte 6 */
#define CAN_PL2_PLMASK_HI_Data_byte_6(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_6_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_6_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_5_MASK       (0xFF0000U)
#define CAN_PL2_PLMASK_HI_Data_byte_5_SHIFT      (16U)
/*! Data_byte_5 - Data Byte 5 */
#define CAN_PL2_PLMASK_HI_Data_byte_5(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_5_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_5_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_4_MASK       (0xFF000000U)
#define CAN_PL2_PLMASK_HI_Data_byte_4_SHIFT      (24U)
/*! Data_byte_4 - Data Byte 4 */
#define CAN_PL2_PLMASK_HI_Data_byte_4(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_4_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_4_MASK)
/*! @} */

/*! @name WMB_CS - Wake-Up Message Buffer */
/*! @{ */

#define CAN_WMB_CS_DLC_MASK                      (0xF0000U)
#define CAN_WMB_CS_DLC_SHIFT                     (16U)
/*! DLC - Length of Data in Bytes */
#define CAN_WMB_CS_DLC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_DLC_SHIFT)) & CAN_WMB_CS_DLC_MASK)

#define CAN_WMB_CS_RTR_MASK                      (0x100000U)
#define CAN_WMB_CS_RTR_SHIFT                     (20U)
/*! RTR - Remote Transmission Request
 *  0b0..Data
 *  0b1..Remote
 */
#define CAN_WMB_CS_RTR(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_RTR_SHIFT)) & CAN_WMB_CS_RTR_MASK)

#define CAN_WMB_CS_IDE_MASK                      (0x200000U)
#define CAN_WMB_CS_IDE_SHIFT                     (21U)
/*! IDE - ID Extended Bit
 *  0b0..Standard
 *  0b1..Extended
 */
#define CAN_WMB_CS_IDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_IDE_SHIFT)) & CAN_WMB_CS_IDE_MASK)

#define CAN_WMB_CS_SRR_MASK                      (0x400000U)
#define CAN_WMB_CS_SRR_SHIFT                     (22U)
/*! SRR - Substitute Remote Request
 *  0b0..Dominant
 *  0b1..Recessive
 */
#define CAN_WMB_CS_SRR(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_SRR_SHIFT)) & CAN_WMB_CS_SRR_MASK)
/*! @} */

/* The count of CAN_WMB_CS */
#define CAN_WMB_CS_COUNT                         (4U)

/*! @name WMB_ID - Wake-Up Message Buffer for ID */
/*! @{ */

#define CAN_WMB_ID_ID_MASK                       (0x1FFFFFFFU)
#define CAN_WMB_ID_ID_SHIFT                      (0U)
/*! ID - Received ID in Pretended Networking Mode */
#define CAN_WMB_ID_ID(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_WMB_ID_ID_SHIFT)) & CAN_WMB_ID_ID_MASK)
/*! @} */

/* The count of CAN_WMB_ID */
#define CAN_WMB_ID_COUNT                         (4U)

/*! @name WMB_D03 - Wake-Up Message Buffer for Data 0-3 */
/*! @{ */

#define CAN_WMB_D03_Data_byte_3_MASK             (0xFFU)
#define CAN_WMB_D03_Data_byte_3_SHIFT            (0U)
/*! Data_byte_3 - Data Byte 3 */
#define CAN_WMB_D03_Data_byte_3(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_3_SHIFT)) & CAN_WMB_D03_Data_byte_3_MASK)

#define CAN_WMB_D03_Data_byte_2_MASK             (0xFF00U)
#define CAN_WMB_D03_Data_byte_2_SHIFT            (8U)
/*! Data_byte_2 - Data Byte 2 */
#define CAN_WMB_D03_Data_byte_2(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_2_SHIFT)) & CAN_WMB_D03_Data_byte_2_MASK)

#define CAN_WMB_D03_Data_byte_1_MASK             (0xFF0000U)
#define CAN_WMB_D03_Data_byte_1_SHIFT            (16U)
/*! Data_byte_1 - Data Byte 1 */
#define CAN_WMB_D03_Data_byte_1(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_1_SHIFT)) & CAN_WMB_D03_Data_byte_1_MASK)

#define CAN_WMB_D03_Data_byte_0_MASK             (0xFF000000U)
#define CAN_WMB_D03_Data_byte_0_SHIFT            (24U)
/*! Data_byte_0 - Data Byte 0 */
#define CAN_WMB_D03_Data_byte_0(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_0_SHIFT)) & CAN_WMB_D03_Data_byte_0_MASK)
/*! @} */

/* The count of CAN_WMB_D03 */
#define CAN_WMB_D03_COUNT                        (4U)

/*! @name WMB_D47 - Wake-Up Message Buffer Register Data 4-7 */
/*! @{ */

#define CAN_WMB_D47_Data_byte_7_MASK             (0xFFU)
#define CAN_WMB_D47_Data_byte_7_SHIFT            (0U)
/*! Data_byte_7 - Data Byte 7 */
#define CAN_WMB_D47_Data_byte_7(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_7_SHIFT)) & CAN_WMB_D47_Data_byte_7_MASK)

#define CAN_WMB_D47_Data_byte_6_MASK             (0xFF00U)
#define CAN_WMB_D47_Data_byte_6_SHIFT            (8U)
/*! Data_byte_6 - Data Byte 6 */
#define CAN_WMB_D47_Data_byte_6(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_6_SHIFT)) & CAN_WMB_D47_Data_byte_6_MASK)

#define CAN_WMB_D47_Data_byte_5_MASK             (0xFF0000U)
#define CAN_WMB_D47_Data_byte_5_SHIFT            (16U)
/*! Data_byte_5 - Data Byte 5 */
#define CAN_WMB_D47_Data_byte_5(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_5_SHIFT)) & CAN_WMB_D47_Data_byte_5_MASK)

#define CAN_WMB_D47_Data_byte_4_MASK             (0xFF000000U)
#define CAN_WMB_D47_Data_byte_4_SHIFT            (24U)
/*! Data_byte_4 - Data Byte 4 */
#define CAN_WMB_D47_Data_byte_4(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_4_SHIFT)) & CAN_WMB_D47_Data_byte_4_MASK)
/*! @} */

/* The count of CAN_WMB_D47 */
#define CAN_WMB_D47_COUNT                        (4U)

/*! @name EPRS - Enhanced CAN Bit Timing Prescalers */
/*! @{ */

#define CAN_EPRS_ENPRESDIV_MASK                  (0x3FFU)
#define CAN_EPRS_ENPRESDIV_SHIFT                 (0U)
/*! ENPRESDIV - Extended Nominal Prescaler Division Factor */
#define CAN_EPRS_ENPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_EPRS_ENPRESDIV_SHIFT)) & CAN_EPRS_ENPRESDIV_MASK)

#define CAN_EPRS_EDPRESDIV_MASK                  (0x3FF0000U)
#define CAN_EPRS_EDPRESDIV_SHIFT                 (16U)
/*! EDPRESDIV - Extended Data Phase Prescaler Division Factor */
#define CAN_EPRS_EDPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_EPRS_EDPRESDIV_SHIFT)) & CAN_EPRS_EDPRESDIV_MASK)
/*! @} */

/*! @name ENCBT - Enhanced Nominal CAN Bit Timing */
/*! @{ */

#define CAN_ENCBT_NTSEG1_MASK                    (0xFFU)
#define CAN_ENCBT_NTSEG1_SHIFT                   (0U)
/*! NTSEG1 - Nominal Time Segment 1 */
#define CAN_ENCBT_NTSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NTSEG1_SHIFT)) & CAN_ENCBT_NTSEG1_MASK)

#define CAN_ENCBT_NTSEG2_MASK                    (0x7F000U)
#define CAN_ENCBT_NTSEG2_SHIFT                   (12U)
/*! NTSEG2 - Nominal Time Segment 2 */
#define CAN_ENCBT_NTSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NTSEG2_SHIFT)) & CAN_ENCBT_NTSEG2_MASK)

#define CAN_ENCBT_NRJW_MASK                      (0x1FC00000U)
#define CAN_ENCBT_NRJW_SHIFT                     (22U)
/*! NRJW - Nominal Resynchronization Jump Width */
#define CAN_ENCBT_NRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NRJW_SHIFT)) & CAN_ENCBT_NRJW_MASK)
/*! @} */

/*! @name EDCBT - Enhanced Data Phase CAN Bit Timing */
/*! @{ */

#define CAN_EDCBT_DTSEG1_MASK                    (0x1FU)
#define CAN_EDCBT_DTSEG1_SHIFT                   (0U)
/*! DTSEG1 - Data Phase Segment 1 */
#define CAN_EDCBT_DTSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DTSEG1_SHIFT)) & CAN_EDCBT_DTSEG1_MASK)

#define CAN_EDCBT_DTSEG2_MASK                    (0xF000U)
#define CAN_EDCBT_DTSEG2_SHIFT                   (12U)
/*! DTSEG2 - Data Phase Time Segment 2 */
#define CAN_EDCBT_DTSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DTSEG2_SHIFT)) & CAN_EDCBT_DTSEG2_MASK)

#define CAN_EDCBT_DRJW_MASK                      (0x3C00000U)
#define CAN_EDCBT_DRJW_SHIFT                     (22U)
/*! DRJW - Data Phase Resynchronization Jump Width */
#define CAN_EDCBT_DRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DRJW_SHIFT)) & CAN_EDCBT_DRJW_MASK)
/*! @} */

/*! @name ETDC - Enhanced Transceiver Delay Compensation */
/*! @{ */

#define CAN_ETDC_ETDCVAL_MASK                    (0xFFU)
#define CAN_ETDC_ETDCVAL_SHIFT                   (0U)
/*! ETDCVAL - Enhanced Transceiver Delay Compensation Value */
#define CAN_ETDC_ETDCVAL(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCVAL_SHIFT)) & CAN_ETDC_ETDCVAL_MASK)

#define CAN_ETDC_ETDCFAIL_MASK                   (0x8000U)
#define CAN_ETDC_ETDCFAIL_SHIFT                  (15U)
/*! ETDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..In range
 *  0b1..Out of range
 */
#define CAN_ETDC_ETDCFAIL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCFAIL_SHIFT)) & CAN_ETDC_ETDCFAIL_MASK)

#define CAN_ETDC_ETDCOFF_MASK                    (0x7F0000U)
#define CAN_ETDC_ETDCOFF_SHIFT                   (16U)
/*! ETDCOFF - Enhanced Transceiver Delay Compensation Offset */
#define CAN_ETDC_ETDCOFF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCOFF_SHIFT)) & CAN_ETDC_ETDCOFF_MASK)

#define CAN_ETDC_TDMDIS_MASK                     (0x40000000U)
#define CAN_ETDC_TDMDIS_SHIFT                    (30U)
/*! TDMDIS - Transceiver Delay Measurement Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_ETDC_TDMDIS(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_TDMDIS_SHIFT)) & CAN_ETDC_TDMDIS_MASK)

#define CAN_ETDC_ETDCEN_MASK                     (0x80000000U)
#define CAN_ETDC_ETDCEN_SHIFT                    (31U)
/*! ETDCEN - Transceiver Delay Compensation Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ETDC_ETDCEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCEN_SHIFT)) & CAN_ETDC_ETDCEN_MASK)
/*! @} */

/*! @name FDCTRL - CAN FD Control */
/*! @{ */

#define CAN_FDCTRL_TDCVAL_MASK                   (0x3FU)
#define CAN_FDCTRL_TDCVAL_SHIFT                  (0U)
/*! TDCVAL - Transceiver Delay Compensation Value */
#define CAN_FDCTRL_TDCVAL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCVAL_SHIFT)) & CAN_FDCTRL_TDCVAL_MASK)

#define CAN_FDCTRL_TDCOFF_MASK                   (0x1F00U)
#define CAN_FDCTRL_TDCOFF_SHIFT                  (8U)
/*! TDCOFF - Transceiver Delay Compensation Offset */
#define CAN_FDCTRL_TDCOFF(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCOFF_SHIFT)) & CAN_FDCTRL_TDCOFF_MASK)

#define CAN_FDCTRL_TDCFAIL_MASK                  (0x4000U)
#define CAN_FDCTRL_TDCFAIL_SHIFT                 (14U)
/*! TDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..In range
 *  0b1..Out of range
 */
#define CAN_FDCTRL_TDCFAIL(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCFAIL_SHIFT)) & CAN_FDCTRL_TDCFAIL_MASK)

#define CAN_FDCTRL_TDCEN_MASK                    (0x8000U)
#define CAN_FDCTRL_TDCEN_SHIFT                   (15U)
/*! TDCEN - Transceiver Delay Compensation Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_FDCTRL_TDCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCEN_SHIFT)) & CAN_FDCTRL_TDCEN_MASK)

#define CAN_FDCTRL_MBDSR0_MASK                   (0x30000U)
#define CAN_FDCTRL_MBDSR0_SHIFT                  (16U)
/*! MBDSR0 - Message Buffer Data Size for Region 0
 *  0b00..8 bytes
 *  0b01..16 bytes
 *  0b10..32 bytes
 *  0b11..64 bytes
 */
#define CAN_FDCTRL_MBDSR0(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_MBDSR0_SHIFT)) & CAN_FDCTRL_MBDSR0_MASK)

#define CAN_FDCTRL_FDRATE_MASK                   (0x80000000U)
#define CAN_FDCTRL_FDRATE_SHIFT                  (31U)
/*! FDRATE - Bit Rate Switch Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_FDCTRL_FDRATE(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_FDRATE_SHIFT)) & CAN_FDCTRL_FDRATE_MASK)
/*! @} */

/*! @name FDCBT - CAN FD Bit Timing */
/*! @{ */

#define CAN_FDCBT_FPSEG2_MASK                    (0x7U)
#define CAN_FDCBT_FPSEG2_SHIFT                   (0U)
/*! FPSEG2 - Fast Phase Segment 2 */
#define CAN_FDCBT_FPSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG2_SHIFT)) & CAN_FDCBT_FPSEG2_MASK)

#define CAN_FDCBT_FPSEG1_MASK                    (0xE0U)
#define CAN_FDCBT_FPSEG1_SHIFT                   (5U)
/*! FPSEG1 - Fast Phase Segment 1 */
#define CAN_FDCBT_FPSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG1_SHIFT)) & CAN_FDCBT_FPSEG1_MASK)

#define CAN_FDCBT_FPROPSEG_MASK                  (0x7C00U)
#define CAN_FDCBT_FPROPSEG_SHIFT                 (10U)
/*! FPROPSEG - Fast Propagation Segment */
#define CAN_FDCBT_FPROPSEG(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPROPSEG_SHIFT)) & CAN_FDCBT_FPROPSEG_MASK)

#define CAN_FDCBT_FRJW_MASK                      (0x70000U)
#define CAN_FDCBT_FRJW_SHIFT                     (16U)
/*! FRJW - Fast Resync Jump Width */
#define CAN_FDCBT_FRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FRJW_SHIFT)) & CAN_FDCBT_FRJW_MASK)

#define CAN_FDCBT_FPRESDIV_MASK                  (0x3FF00000U)
#define CAN_FDCBT_FPRESDIV_SHIFT                 (20U)
/*! FPRESDIV - Fast Prescaler Division Factor */
#define CAN_FDCBT_FPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPRESDIV_SHIFT)) & CAN_FDCBT_FPRESDIV_MASK)
/*! @} */

/*! @name FDCRC - CAN FD CRC */
/*! @{ */

#define CAN_FDCRC_FD_TXCRC_MASK                  (0x1FFFFFU)
#define CAN_FDCRC_FD_TXCRC_SHIFT                 (0U)
/*! FD_TXCRC - Extended Transmitted CRC value */
#define CAN_FDCRC_FD_TXCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_TXCRC_SHIFT)) & CAN_FDCRC_FD_TXCRC_MASK)

#define CAN_FDCRC_FD_MBCRC_MASK                  (0x7F000000U)
#define CAN_FDCRC_FD_MBCRC_SHIFT                 (24U)
/*! FD_MBCRC - CRC Message Buffer Number for FD_TXCRC */
#define CAN_FDCRC_FD_MBCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_MBCRC_SHIFT)) & CAN_FDCRC_FD_MBCRC_MASK)
/*! @} */

/*! @name ERFCR - Enhanced RX FIFO Control */
/*! @{ */

#define CAN_ERFCR_ERFWM_MASK                     (0x1FU)
#define CAN_ERFCR_ERFWM_SHIFT                    (0U)
/*! ERFWM - Enhanced RX FIFO Watermark */
#define CAN_ERFCR_ERFWM(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_ERFWM_SHIFT)) & CAN_ERFCR_ERFWM_MASK)

#define CAN_ERFCR_NFE_MASK                       (0x3F00U)
#define CAN_ERFCR_NFE_SHIFT                      (8U)
/*! NFE - Number of Enhanced RX FIFO Filter Elements */
#define CAN_ERFCR_NFE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_NFE_SHIFT)) & CAN_ERFCR_NFE_MASK)

#define CAN_ERFCR_NEXIF_MASK                     (0x7F0000U)
#define CAN_ERFCR_NEXIF_SHIFT                    (16U)
/*! NEXIF - Number of Extended ID Filter Elements */
#define CAN_ERFCR_NEXIF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_NEXIF_SHIFT)) & CAN_ERFCR_NEXIF_MASK)

#define CAN_ERFCR_DMALW_MASK                     (0x7C000000U)
#define CAN_ERFCR_DMALW_SHIFT                    (26U)
/*! DMALW - DMA Last Word */
#define CAN_ERFCR_DMALW(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_DMALW_SHIFT)) & CAN_ERFCR_DMALW_MASK)

#define CAN_ERFCR_ERFEN_MASK                     (0x80000000U)
#define CAN_ERFCR_ERFEN_SHIFT                    (31U)
/*! ERFEN - Enhanced RX FIFO enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFCR_ERFEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_ERFEN_SHIFT)) & CAN_ERFCR_ERFEN_MASK)
/*! @} */

/*! @name ERFIER - Enhanced RX FIFO Interrupt Enable */
/*! @{ */

#define CAN_ERFIER_ERFDAIE_MASK                  (0x10000000U)
#define CAN_ERFIER_ERFDAIE_SHIFT                 (28U)
/*! ERFDAIE - Enhanced RX FIFO Data Available Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFDAIE(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFDAIE_SHIFT)) & CAN_ERFIER_ERFDAIE_MASK)

#define CAN_ERFIER_ERFWMIIE_MASK                 (0x20000000U)
#define CAN_ERFIER_ERFWMIIE_SHIFT                (29U)
/*! ERFWMIIE - Enhanced RX FIFO Watermark Indication Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFWMIIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFWMIIE_SHIFT)) & CAN_ERFIER_ERFWMIIE_MASK)

#define CAN_ERFIER_ERFOVFIE_MASK                 (0x40000000U)
#define CAN_ERFIER_ERFOVFIE_SHIFT                (30U)
/*! ERFOVFIE - Enhanced RX FIFO Overflow Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFOVFIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFOVFIE_SHIFT)) & CAN_ERFIER_ERFOVFIE_MASK)

#define CAN_ERFIER_ERFUFWIE_MASK                 (0x80000000U)
#define CAN_ERFIER_ERFUFWIE_SHIFT                (31U)
/*! ERFUFWIE - Enhanced RX FIFO Underflow Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFUFWIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFUFWIE_SHIFT)) & CAN_ERFIER_ERFUFWIE_MASK)
/*! @} */

/*! @name ERFSR - Enhanced RX FIFO Status */
/*! @{ */

#define CAN_ERFSR_ERFEL_MASK                     (0x3FU)
#define CAN_ERFSR_ERFEL_SHIFT                    (0U)
/*! ERFEL - Enhanced RX FIFO Elements */
#define CAN_ERFSR_ERFEL(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFEL_SHIFT)) & CAN_ERFSR_ERFEL_MASK)

#define CAN_ERFSR_ERFF_MASK                      (0x10000U)
#define CAN_ERFSR_ERFF_SHIFT                     (16U)
/*! ERFF - Enhanced RX FIFO Full Flag
 *  0b0..Not full
 *  0b1..Full
 */
#define CAN_ERFSR_ERFF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFF_SHIFT)) & CAN_ERFSR_ERFF_MASK)

#define CAN_ERFSR_ERFE_MASK                      (0x20000U)
#define CAN_ERFSR_ERFE_SHIFT                     (17U)
/*! ERFE - Enhanced RX FIFO Empty Flag
 *  0b0..Not empty
 *  0b1..Empty
 */
#define CAN_ERFSR_ERFE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFE_SHIFT)) & CAN_ERFSR_ERFE_MASK)

#define CAN_ERFSR_ERFCLR_MASK                    (0x8000000U)
#define CAN_ERFSR_ERFCLR_SHIFT                   (27U)
/*! ERFCLR - Enhanced RX FIFO Clear
 *  0b0..No effect
 *  0b1..Clear enhanced RX FIFO content
 */
#define CAN_ERFSR_ERFCLR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFCLR_SHIFT)) & CAN_ERFSR_ERFCLR_MASK)

#define CAN_ERFSR_ERFDA_MASK                     (0x10000000U)
#define CAN_ERFSR_ERFDA_SHIFT                    (28U)
/*! ERFDA - Enhanced RX FIFO Data Available Flag
 *  0b0..No such occurrence
 *  0b1..At least one message stored in Enhanced RX FIFO
 */
#define CAN_ERFSR_ERFDA(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFDA_SHIFT)) & CAN_ERFSR_ERFDA_MASK)

#define CAN_ERFSR_ERFWMI_MASK                    (0x20000000U)
#define CAN_ERFSR_ERFWMI_SHIFT                   (29U)
/*! ERFWMI - Enhanced RX FIFO Watermark Indication Flag
 *  0b0..No such occurrence
 *  0b1..Number of messages in FIFO is greater than the watermark
 */
#define CAN_ERFSR_ERFWMI(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFWMI_SHIFT)) & CAN_ERFSR_ERFWMI_MASK)

#define CAN_ERFSR_ERFOVF_MASK                    (0x40000000U)
#define CAN_ERFSR_ERFOVF_SHIFT                   (30U)
/*! ERFOVF - Enhanced RX FIFO Overflow Flag
 *  0b0..No such occurrence
 *  0b1..Overflow
 */
#define CAN_ERFSR_ERFOVF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFOVF_SHIFT)) & CAN_ERFSR_ERFOVF_MASK)

#define CAN_ERFSR_ERFUFW_MASK                    (0x80000000U)
#define CAN_ERFSR_ERFUFW_SHIFT                   (31U)
/*! ERFUFW - Enhanced RX FIFO Underflow Flag
 *  0b0..No such occurrence
 *  0b1..Underflow
 */
#define CAN_ERFSR_ERFUFW(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFUFW_SHIFT)) & CAN_ERFSR_ERFUFW_MASK)
/*! @} */

/*! @name ERFFEL - Enhanced RX FIFO Filter Element */
/*! @{ */

#define CAN_ERFFEL_FEL_MASK                      (0xFFFFFFFFU)
#define CAN_ERFFEL_FEL_SHIFT                     (0U)
/*! FEL - Filter Element Bits */
#define CAN_ERFFEL_FEL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFFEL_FEL_SHIFT)) & CAN_ERFFEL_FEL_MASK)
/*! @} */

/* The count of CAN_ERFFEL */
#define CAN_ERFFEL_COUNT                         (32U)


/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CAN0 base address */
  #define CAN0_BASE                                (0x500D4000u)
  /** Peripheral CAN0 base address */
  #define CAN0_BASE_NS                             (0x400D4000u)
  /** Peripheral CAN0 base pointer */
  #define CAN0                                     ((CAN_Type *)CAN0_BASE)
  /** Peripheral CAN0 base pointer */
  #define CAN0_NS                                  ((CAN_Type *)CAN0_BASE_NS)
  /** Peripheral CAN1 base address */
  #define CAN1_BASE                                (0x500D8000u)
  /** Peripheral CAN1 base address */
  #define CAN1_BASE_NS                             (0x400D8000u)
  /** Peripheral CAN1 base pointer */
  #define CAN1                                     ((CAN_Type *)CAN1_BASE)
  /** Peripheral CAN1 base pointer */
  #define CAN1_NS                                  ((CAN_Type *)CAN1_BASE_NS)
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS                           { CAN0_BASE, CAN1_BASE }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS                            { CAN0, CAN1 }
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS_NS                        { CAN0_BASE_NS, CAN1_BASE_NS }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS_NS                         { CAN0_NS, CAN1_NS }
#else
  /** Peripheral CAN0 base address */
  #define CAN0_BASE                                (0x400D4000u)
  /** Peripheral CAN0 base pointer */
  #define CAN0                                     ((CAN_Type *)CAN0_BASE)
  /** Peripheral CAN1 base address */
  #define CAN1_BASE                                (0x400D8000u)
  /** Peripheral CAN1 base pointer */
  #define CAN1                                     ((CAN_Type *)CAN1_BASE)
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS                           { CAN0_BASE, CAN1_BASE }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS                            { CAN0, CAN1 }
#endif
/** Interrupt vectors for the CAN peripheral type */
#define CAN_Rx_Warning_IRQS                      { CAN0_IRQn, CAN1_IRQn }
#define CAN_Tx_Warning_IRQS                      { CAN0_IRQn, CAN1_IRQn }
#define CAN_Wake_Up_IRQS                         { CAN0_IRQn, CAN1_IRQn }
#define CAN_Error_IRQS                           { CAN0_IRQn, CAN1_IRQn }
#define CAN_Bus_Off_IRQS                         { CAN0_IRQn, CAN1_IRQn }
#define CAN_ORed_Message_buffer_IRQS             { CAN0_IRQn, CAN1_IRQn }

/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CDOG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Peripheral_Access_Layer CDOG Peripheral Access Layer
 * @{
 */

/** CDOG - Register Layout Typedef */
typedef struct {
  __IO uint32_t CONTROL;                           /**< Control Register, offset: 0x0 */
  __IO uint32_t RELOAD;                            /**< Instruction Timer Reload Register, offset: 0x4 */
  __I  uint32_t INSTRUCTION_TIMER;                 /**< Instruction Timer Register, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __I  uint32_t STATUS;                            /**< Status 1 Register, offset: 0x10 */
  __I  uint32_t STATUS2;                           /**< Status 2 Register, offset: 0x14 */
  __IO uint32_t FLAGS;                             /**< Flags Register, offset: 0x18 */
  __IO uint32_t PERSISTENT;                        /**< Persistent Data Storage Register, offset: 0x1C */
  __O  uint32_t START;                             /**< START Command Register, offset: 0x20 */
  __O  uint32_t STOP;                              /**< STOP Command Register, offset: 0x24 */
  __O  uint32_t RESTART;                           /**< RESTART Command Register, offset: 0x28 */
  __O  uint32_t ADD;                               /**< ADD Command Register, offset: 0x2C */
  __O  uint32_t ADD1;                              /**< ADD1 Command Register, offset: 0x30 */
  __O  uint32_t ADD16;                             /**< ADD16 Command Register, offset: 0x34 */
  __O  uint32_t ADD256;                            /**< ADD256 Command Register, offset: 0x38 */
  __O  uint32_t SUB;                               /**< SUB Command Register, offset: 0x3C */
  __O  uint32_t SUB1;                              /**< SUB1 Command Register, offset: 0x40 */
  __O  uint32_t SUB16;                             /**< SUB16 Command Register, offset: 0x44 */
  __O  uint32_t SUB256;                            /**< SUB256 Command Register, offset: 0x48 */
  __O  uint32_t ASSERT16;                          /**< ASSERT16 Command Register, offset: 0x4C */
} CDOG_Type;

/* ----------------------------------------------------------------------------
   -- CDOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Register_Masks CDOG Register Masks
 * @{
 */

/*! @name CONTROL - Control Register */
/*! @{ */

#define CDOG_CONTROL_LOCK_CTRL_MASK              (0x3U)
#define CDOG_CONTROL_LOCK_CTRL_SHIFT             (0U)
/*! LOCK_CTRL - Lock control
 *  0b01..Locked
 *  0b10..Unlocked
 */
#define CDOG_CONTROL_LOCK_CTRL(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_LOCK_CTRL_SHIFT)) & CDOG_CONTROL_LOCK_CTRL_MASK)

#define CDOG_CONTROL_TIMEOUT_CTRL_MASK           (0x1CU)
#define CDOG_CONTROL_TIMEOUT_CTRL_SHIFT          (2U)
/*! TIMEOUT_CTRL - TIMEOUT fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_TIMEOUT_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_TIMEOUT_CTRL_SHIFT)) & CDOG_CONTROL_TIMEOUT_CTRL_MASK)

#define CDOG_CONTROL_MISCOMPARE_CTRL_MASK        (0xE0U)
#define CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT       (5U)
/*! MISCOMPARE_CTRL - MISCOMPARE fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_MISCOMPARE_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT)) & CDOG_CONTROL_MISCOMPARE_CTRL_MASK)

#define CDOG_CONTROL_SEQUENCE_CTRL_MASK          (0x700U)
#define CDOG_CONTROL_SEQUENCE_CTRL_SHIFT         (8U)
/*! SEQUENCE_CTRL - SEQUENCE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_SEQUENCE_CTRL(x)            (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_SEQUENCE_CTRL_SHIFT)) & CDOG_CONTROL_SEQUENCE_CTRL_MASK)

#define CDOG_CONTROL_STATE_CTRL_MASK             (0x1C000U)
#define CDOG_CONTROL_STATE_CTRL_SHIFT            (14U)
/*! STATE_CTRL - STATE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_STATE_CTRL(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_STATE_CTRL_SHIFT)) & CDOG_CONTROL_STATE_CTRL_MASK)

#define CDOG_CONTROL_ADDRESS_CTRL_MASK           (0xE0000U)
#define CDOG_CONTROL_ADDRESS_CTRL_SHIFT          (17U)
/*! ADDRESS_CTRL - ADDRESS fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_ADDRESS_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_ADDRESS_CTRL_SHIFT)) & CDOG_CONTROL_ADDRESS_CTRL_MASK)

#define CDOG_CONTROL_IRQ_PAUSE_MASK              (0x30000000U)
#define CDOG_CONTROL_IRQ_PAUSE_SHIFT             (28U)
/*! IRQ_PAUSE - IRQ pause control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_IRQ_PAUSE(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_IRQ_PAUSE_SHIFT)) & CDOG_CONTROL_IRQ_PAUSE_MASK)

#define CDOG_CONTROL_DEBUG_HALT_CTRL_MASK        (0xC0000000U)
#define CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT       (30U)
/*! DEBUG_HALT_CTRL - DEBUG_HALT control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_DEBUG_HALT_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT)) & CDOG_CONTROL_DEBUG_HALT_CTRL_MASK)
/*! @} */

/*! @name RELOAD - Instruction Timer Reload Register */
/*! @{ */

#define CDOG_RELOAD_RLOAD_MASK                   (0xFFFFFFFFU)
#define CDOG_RELOAD_RLOAD_SHIFT                  (0U)
/*! RLOAD - Instruction Timer reload value */
#define CDOG_RELOAD_RLOAD(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_RELOAD_RLOAD_SHIFT)) & CDOG_RELOAD_RLOAD_MASK)
/*! @} */

/*! @name INSTRUCTION_TIMER - Instruction Timer Register */
/*! @{ */

#define CDOG_INSTRUCTION_TIMER_INSTIM_MASK       (0xFFFFFFFFU)
#define CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT      (0U)
/*! INSTIM - Current value of the Instruction Timer */
#define CDOG_INSTRUCTION_TIMER_INSTIM(x)         (((uint32_t)(((uint32_t)(x)) << CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT)) & CDOG_INSTRUCTION_TIMER_INSTIM_MASK)
/*! @} */

/*! @name STATUS - Status 1 Register */
/*! @{ */

#define CDOG_STATUS_NUMTOF_MASK                  (0xFFU)
#define CDOG_STATUS_NUMTOF_SHIFT                 (0U)
/*! NUMTOF - Number of TIMEOUT faults since the last POR */
#define CDOG_STATUS_NUMTOF(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMTOF_SHIFT)) & CDOG_STATUS_NUMTOF_MASK)

#define CDOG_STATUS_NUMMISCOMPF_MASK             (0xFF00U)
#define CDOG_STATUS_NUMMISCOMPF_SHIFT            (8U)
/*! NUMMISCOMPF - Number of MISCOMPARE faults since the last POR */
#define CDOG_STATUS_NUMMISCOMPF(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMMISCOMPF_SHIFT)) & CDOG_STATUS_NUMMISCOMPF_MASK)

#define CDOG_STATUS_NUMILSEQF_MASK               (0xFF0000U)
#define CDOG_STATUS_NUMILSEQF_SHIFT              (16U)
/*! NUMILSEQF - Number of SEQUENCE faults since the last POR */
#define CDOG_STATUS_NUMILSEQF(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMILSEQF_SHIFT)) & CDOG_STATUS_NUMILSEQF_MASK)

#define CDOG_STATUS_CURST_MASK                   (0xF0000000U)
#define CDOG_STATUS_CURST_SHIFT                  (28U)
/*! CURST - Current State */
#define CDOG_STATUS_CURST(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_CURST_SHIFT)) & CDOG_STATUS_CURST_MASK)
/*! @} */

/*! @name STATUS2 - Status 2 Register */
/*! @{ */

#define CDOG_STATUS2_NUMCNTF_MASK                (0xFFU)
#define CDOG_STATUS2_NUMCNTF_SHIFT               (0U)
/*! NUMCNTF - Number of CONTROL faults since the last POR */
#define CDOG_STATUS2_NUMCNTF(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMCNTF_SHIFT)) & CDOG_STATUS2_NUMCNTF_MASK)

#define CDOG_STATUS2_NUMILLSTF_MASK              (0xFF00U)
#define CDOG_STATUS2_NUMILLSTF_SHIFT             (8U)
/*! NUMILLSTF - Number of STATE faults since the last POR */
#define CDOG_STATUS2_NUMILLSTF(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLSTF_SHIFT)) & CDOG_STATUS2_NUMILLSTF_MASK)

#define CDOG_STATUS2_NUMILLA_MASK                (0xFF0000U)
#define CDOG_STATUS2_NUMILLA_SHIFT               (16U)
/*! NUMILLA - Number of ADDRESS faults since the last POR */
#define CDOG_STATUS2_NUMILLA(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLA_SHIFT)) & CDOG_STATUS2_NUMILLA_MASK)
/*! @} */

/*! @name FLAGS - Flags Register */
/*! @{ */

#define CDOG_FLAGS_TO_FLAG_MASK                  (0x1U)
#define CDOG_FLAGS_TO_FLAG_SHIFT                 (0U)
/*! TO_FLAG - TIMEOUT fault flag
 *  0b0..A TIMEOUT fault has not occurred
 *  0b1..A TIMEOUT fault has occurred
 */
#define CDOG_FLAGS_TO_FLAG(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_TO_FLAG_SHIFT)) & CDOG_FLAGS_TO_FLAG_MASK)

#define CDOG_FLAGS_MISCOM_FLAG_MASK              (0x2U)
#define CDOG_FLAGS_MISCOM_FLAG_SHIFT             (1U)
/*! MISCOM_FLAG - MISCOMPARE fault flag
 *  0b0..A MISCOMPARE fault has not occurred
 *  0b1..A MISCOMPARE fault has occurred
 */
#define CDOG_FLAGS_MISCOM_FLAG(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_MISCOM_FLAG_SHIFT)) & CDOG_FLAGS_MISCOM_FLAG_MASK)

#define CDOG_FLAGS_SEQ_FLAG_MASK                 (0x4U)
#define CDOG_FLAGS_SEQ_FLAG_SHIFT                (2U)
/*! SEQ_FLAG - SEQUENCE fault flag
 *  0b0..A SEQUENCE fault has not occurred
 *  0b1..A SEQUENCE fault has occurred
 */
#define CDOG_FLAGS_SEQ_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_SEQ_FLAG_SHIFT)) & CDOG_FLAGS_SEQ_FLAG_MASK)

#define CDOG_FLAGS_CNT_FLAG_MASK                 (0x8U)
#define CDOG_FLAGS_CNT_FLAG_SHIFT                (3U)
/*! CNT_FLAG - CONTROL fault flag
 *  0b0..A CONTROL fault has not occurred
 *  0b1..A CONTROL fault has occurred
 */
#define CDOG_FLAGS_CNT_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_CNT_FLAG_SHIFT)) & CDOG_FLAGS_CNT_FLAG_MASK)

#define CDOG_FLAGS_STATE_FLAG_MASK               (0x10U)
#define CDOG_FLAGS_STATE_FLAG_SHIFT              (4U)
/*! STATE_FLAG - STATE fault flag
 *  0b0..A STATE fault has not occurred
 *  0b1..A STATE fault has occurred
 */
#define CDOG_FLAGS_STATE_FLAG(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_STATE_FLAG_SHIFT)) & CDOG_FLAGS_STATE_FLAG_MASK)

#define CDOG_FLAGS_ADDR_FLAG_MASK                (0x20U)
#define CDOG_FLAGS_ADDR_FLAG_SHIFT               (5U)
/*! ADDR_FLAG - ADDRESS fault flag
 *  0b0..An ADDRESS fault has not occurred
 *  0b1..An ADDRESS fault has occurred
 */
#define CDOG_FLAGS_ADDR_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_ADDR_FLAG_SHIFT)) & CDOG_FLAGS_ADDR_FLAG_MASK)

#define CDOG_FLAGS_POR_FLAG_MASK                 (0x10000U)
#define CDOG_FLAGS_POR_FLAG_SHIFT                (16U)
/*! POR_FLAG - Power-on reset flag
 *  0b0..A Power-on reset event has not occurred
 *  0b1..A Power-on reset event has occurred
 */
#define CDOG_FLAGS_POR_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_POR_FLAG_SHIFT)) & CDOG_FLAGS_POR_FLAG_MASK)
/*! @} */

/*! @name PERSISTENT - Persistent Data Storage Register */
/*! @{ */

#define CDOG_PERSISTENT_PERSIS_MASK              (0xFFFFFFFFU)
#define CDOG_PERSISTENT_PERSIS_SHIFT             (0U)
/*! PERSIS - Persistent Storage */
#define CDOG_PERSISTENT_PERSIS(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_PERSISTENT_PERSIS_SHIFT)) & CDOG_PERSISTENT_PERSIS_MASK)
/*! @} */

/*! @name START - START Command Register */
/*! @{ */

#define CDOG_START_STRT_MASK                     (0xFFFFFFFFU)
#define CDOG_START_STRT_SHIFT                    (0U)
/*! STRT - Start command */
#define CDOG_START_STRT(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_START_STRT_SHIFT)) & CDOG_START_STRT_MASK)
/*! @} */

/*! @name STOP - STOP Command Register */
/*! @{ */

#define CDOG_STOP_STP_MASK                       (0xFFFFFFFFU)
#define CDOG_STOP_STP_SHIFT                      (0U)
/*! STP - Stop command */
#define CDOG_STOP_STP(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_STOP_STP_SHIFT)) & CDOG_STOP_STP_MASK)
/*! @} */

/*! @name RESTART - RESTART Command Register */
/*! @{ */

#define CDOG_RESTART_RSTRT_MASK                  (0xFFFFFFFFU)
#define CDOG_RESTART_RSTRT_SHIFT                 (0U)
/*! RSTRT - Restart command */
#define CDOG_RESTART_RSTRT(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_RESTART_RSTRT_SHIFT)) & CDOG_RESTART_RSTRT_MASK)
/*! @} */

/*! @name ADD - ADD Command Register */
/*! @{ */

#define CDOG_ADD_AD_MASK                         (0xFFFFFFFFU)
#define CDOG_ADD_AD_SHIFT                        (0U)
/*! AD - ADD Write Value */
#define CDOG_ADD_AD(x)                           (((uint32_t)(((uint32_t)(x)) << CDOG_ADD_AD_SHIFT)) & CDOG_ADD_AD_MASK)
/*! @} */

/*! @name ADD1 - ADD1 Command Register */
/*! @{ */

#define CDOG_ADD1_AD1_MASK                       (0xFFFFFFFFU)
#define CDOG_ADD1_AD1_SHIFT                      (0U)
/*! AD1 - ADD 1 */
#define CDOG_ADD1_AD1(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_ADD1_AD1_SHIFT)) & CDOG_ADD1_AD1_MASK)
/*! @} */

/*! @name ADD16 - ADD16 Command Register */
/*! @{ */

#define CDOG_ADD16_AD16_MASK                     (0xFFFFFFFFU)
#define CDOG_ADD16_AD16_SHIFT                    (0U)
/*! AD16 - ADD 16 */
#define CDOG_ADD16_AD16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_ADD16_AD16_SHIFT)) & CDOG_ADD16_AD16_MASK)
/*! @} */

/*! @name ADD256 - ADD256 Command Register */
/*! @{ */

#define CDOG_ADD256_AD256_MASK                   (0xFFFFFFFFU)
#define CDOG_ADD256_AD256_SHIFT                  (0U)
/*! AD256 - ADD 256 */
#define CDOG_ADD256_AD256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_ADD256_AD256_SHIFT)) & CDOG_ADD256_AD256_MASK)
/*! @} */

/*! @name SUB - SUB Command Register */
/*! @{ */

#define CDOG_SUB_SB_MASK                         (0xFFFFFFFFU)
#define CDOG_SUB_SB_SHIFT                        (0U)
/*! SB - Subtract Write Value */
#define CDOG_SUB_SB(x)                           (((uint32_t)(((uint32_t)(x)) << CDOG_SUB_SB_SHIFT)) & CDOG_SUB_SB_MASK)
/*! @} */

/*! @name SUB1 - SUB1 Command Register */
/*! @{ */

#define CDOG_SUB1_SB1_MASK                       (0xFFFFFFFFU)
#define CDOG_SUB1_SB1_SHIFT                      (0U)
/*! SB1 - Subtract 1 */
#define CDOG_SUB1_SB1(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_SUB1_SB1_SHIFT)) & CDOG_SUB1_SB1_MASK)
/*! @} */

/*! @name SUB16 - SUB16 Command Register */
/*! @{ */

#define CDOG_SUB16_SB16_MASK                     (0xFFFFFFFFU)
#define CDOG_SUB16_SB16_SHIFT                    (0U)
/*! SB16 - Subtract 16 */
#define CDOG_SUB16_SB16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_SUB16_SB16_SHIFT)) & CDOG_SUB16_SB16_MASK)
/*! @} */

/*! @name SUB256 - SUB256 Command Register */
/*! @{ */

#define CDOG_SUB256_SB256_MASK                   (0xFFFFFFFFU)
#define CDOG_SUB256_SB256_SHIFT                  (0U)
/*! SB256 - Subtract 256 */
#define CDOG_SUB256_SB256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_SUB256_SB256_SHIFT)) & CDOG_SUB256_SB256_MASK)
/*! @} */

/*! @name ASSERT16 - ASSERT16 Command Register */
/*! @{ */

#define CDOG_ASSERT16_AST16_MASK                 (0xFFFFFFFFU)
#define CDOG_ASSERT16_AST16_SHIFT                (0U)
/*! AST16 - ASSERT16 Command */
#define CDOG_ASSERT16_AST16(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_ASSERT16_AST16_SHIFT)) & CDOG_ASSERT16_AST16_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CDOG_Register_Masks */


/* CDOG - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CDOG0 base address */
  #define CDOG0_BASE                               (0x500BB000u)
  /** Peripheral CDOG0 base address */
  #define CDOG0_BASE_NS                            (0x400BB000u)
  /** Peripheral CDOG0 base pointer */
  #define CDOG0                                    ((CDOG_Type *)CDOG0_BASE)
  /** Peripheral CDOG0 base pointer */
  #define CDOG0_NS                                 ((CDOG_Type *)CDOG0_BASE_NS)
  /** Peripheral CDOG1 base address */
  #define CDOG1_BASE                               (0x500BC000u)
  /** Peripheral CDOG1 base address */
  #define CDOG1_BASE_NS                            (0x400BC000u)
  /** Peripheral CDOG1 base pointer */
  #define CDOG1                                    ((CDOG_Type *)CDOG1_BASE)
  /** Peripheral CDOG1 base pointer */
  #define CDOG1_NS                                 ((CDOG_Type *)CDOG1_BASE_NS)
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS                          { CDOG0_BASE, CDOG1_BASE }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS                           { CDOG0, CDOG1 }
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS_NS                       { CDOG0_BASE_NS, CDOG1_BASE_NS }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS_NS                        { CDOG0_NS, CDOG1_NS }
#else
  /** Peripheral CDOG0 base address */
  #define CDOG0_BASE                               (0x400BB000u)
  /** Peripheral CDOG0 base pointer */
  #define CDOG0                                    ((CDOG_Type *)CDOG0_BASE)
  /** Peripheral CDOG1 base address */
  #define CDOG1_BASE                               (0x400BC000u)
  /** Peripheral CDOG1 base pointer */
  #define CDOG1                                    ((CDOG_Type *)CDOG1_BASE)
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS                          { CDOG0_BASE, CDOG1_BASE }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS                           { CDOG0, CDOG1 }
#endif
/** Interrupt vectors for the CDOG peripheral type */
#define CDOG_IRQS                                { CDOG0_IRQn, CDOG1_IRQn }

/*!
 * @}
 */ /* end of group CDOG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMC_Peripheral_Access_Layer CMC Peripheral Access Layer
 * @{
 */

/** CMC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t CKCTRL;                            /**< Clock Control, offset: 0x10 */
  __IO uint32_t CKSTAT;                            /**< Clock Status, offset: 0x14 */
  __IO uint32_t PMPROT;                            /**< Power Mode Protection, offset: 0x18 */
  __O  uint32_t GPMCTRL;                           /**< Global Power Mode Control, offset: 0x1C */
  __IO uint32_t PMCTRL[2];                         /**< Power Mode Control, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_1[88];
  __I  uint32_t SRS;                               /**< System Reset Status, offset: 0x80 */
  __IO uint32_t RPC;                               /**< Reset Pin Control, offset: 0x84 */
  __IO uint32_t SSRS;                              /**< Sticky System Reset Status, offset: 0x88 */
  __IO uint32_t SRIE;                              /**< System Reset Interrupt Enable, offset: 0x8C */
  __IO uint32_t SRIF;                              /**< System Reset Interrupt Flag, offset: 0x90 */
       uint8_t RESERVED_2[8];
  __I  uint32_t RSTCNT;                            /**< Reset Count Register, offset: 0x9C */
  __IO uint32_t MR[1];                             /**< Mode, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_3[12];
  __IO uint32_t FM[1];                             /**< Force Mode, array offset: 0xB0, array step: 0x4 */
       uint8_t RESERVED_4[12];
  __IO uint32_t SRAMDIS[1];                        /**< SRAM Disable, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_5[12];
  __IO uint32_t SRAMRET[1];                        /**< SRAM Retention, array offset: 0xD0, array step: 0x4 */
       uint8_t RESERVED_6[12];
  __IO uint32_t FLASHCR;                           /**< Flash Control, offset: 0xE0 */
       uint8_t RESERVED_7[28];
  __IO uint32_t BSR;                               /**< BootROM Status Register, offset: 0x100 */
       uint8_t RESERVED_8[8];
  __IO uint32_t BLR;                               /**< BootROM Lock Register, offset: 0x10C */
  __IO uint32_t CORECTL;                           /**< Core Control, offset: 0x110 */
       uint8_t RESERVED_9[12];
  __IO uint32_t DBGCTL;                            /**< Debug Control, offset: 0x120 */
} CMC_Type;

/* ----------------------------------------------------------------------------
   -- CMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMC_Register_Masks CMC Register Masks
 * @{
 */

/*! @name VERID - Version ID */
/*! @{ */

#define CMC_VERID_FEATURE_MASK                   (0xFFFFU)
#define CMC_VERID_FEATURE_SHIFT                  (0U)
/*! FEATURE - Feature Specification Number */
#define CMC_VERID_FEATURE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_VERID_FEATURE_SHIFT)) & CMC_VERID_FEATURE_MASK)

#define CMC_VERID_MINOR_MASK                     (0xFF0000U)
#define CMC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number */
#define CMC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_VERID_MINOR_SHIFT)) & CMC_VERID_MINOR_MASK)

#define CMC_VERID_MAJOR_MASK                     (0xFF000000U)
#define CMC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number */
#define CMC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_VERID_MAJOR_SHIFT)) & CMC_VERID_MAJOR_MASK)
/*! @} */

/*! @name CKCTRL - Clock Control */
/*! @{ */

#define CMC_CKCTRL_CKMODE_MASK                   (0xFU)
#define CMC_CKCTRL_CKMODE_SHIFT                  (0U)
/*! CKMODE - Clocking Mode
 *  0b0000..No clock gating
 *  0b1111..Core, platform, and peripheral clocks are gated, and core enters Low-Power mode.
 */
#define CMC_CKCTRL_CKMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKCTRL_CKMODE_SHIFT)) & CMC_CKCTRL_CKMODE_MASK)

#define CMC_CKCTRL_LOCK_MASK                     (0x80000000U)
#define CMC_CKCTRL_LOCK_SHIFT                    (31U)
/*! LOCK - Lock
 *  0b0..Allowed
 *  0b1..Blocked
 */
#define CMC_CKCTRL_LOCK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_CKCTRL_LOCK_SHIFT)) & CMC_CKCTRL_LOCK_MASK)
/*! @} */

/*! @name CKSTAT - Clock Status */
/*! @{ */

#define CMC_CKSTAT_CKMODE_MASK                   (0xFU)
#define CMC_CKSTAT_CKMODE_SHIFT                  (0U)
/*! CKMODE - Low Power Status
 *  0b0000..Core clock not gated
 *  0b1111..Core, platform, and peripheral clocks were gated, and power domain entered Low-Power mode
 *  *..
 */
#define CMC_CKSTAT_CKMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_CKMODE_SHIFT)) & CMC_CKSTAT_CKMODE_MASK)

#define CMC_CKSTAT_WAKEUP_MASK                   (0xFF00U)
#define CMC_CKSTAT_WAKEUP_SHIFT                  (8U)
/*! WAKEUP - Wake-up Source */
#define CMC_CKSTAT_WAKEUP(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_WAKEUP_SHIFT)) & CMC_CKSTAT_WAKEUP_MASK)

#define CMC_CKSTAT_VALID_MASK                    (0x80000000U)
#define CMC_CKSTAT_VALID_SHIFT                   (31U)
/*! VALID - Clock Status Valid
 *  0b0..Core clock not gated
 *  0b1..Core clock was gated due to Low-Power mode entry
 */
#define CMC_CKSTAT_VALID(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_VALID_SHIFT)) & CMC_CKSTAT_VALID_MASK)
/*! @} */

/*! @name PMPROT - Power Mode Protection */
/*! @{ */

#define CMC_PMPROT_LPMODE_MASK                   (0xFU)
#define CMC_PMPROT_LPMODE_SHIFT                  (0U)
/*! LPMODE - Low-Power Mode
 *  0b0000..Not allowed
 *  0b0001..Allowed
 *  0b0010..Allowed
 *  0b0011..Allowed
 *  0b0100..Allowed
 *  0b0101..Allowed
 *  0b0110..Allowed
 *  0b0111..Allowed
 *  0b1000..Allowed
 *  0b1001..Allowed
 *  0b1010..Allowed
 *  0b1011..Allowed
 *  0b1100..Allowed
 *  0b1101..Allowed
 *  0b1110..Allowed
 *  0b1111..Allowed
 */
#define CMC_PMPROT_LPMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_PMPROT_LPMODE_SHIFT)) & CMC_PMPROT_LPMODE_MASK)

#define CMC_PMPROT_LOCK_MASK                     (0x80000000U)
#define CMC_PMPROT_LOCK_SHIFT                    (31U)
/*! LOCK - Lock Register
 *  0b0..Allowed
 *  0b1..Blocked
 */
#define CMC_PMPROT_LOCK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_PMPROT_LOCK_SHIFT)) & CMC_PMPROT_LOCK_MASK)
/*! @} */

/*! @name GPMCTRL - Global Power Mode Control */
/*! @{ */

#define CMC_GPMCTRL_LPMODE_MASK                  (0xFU)
#define CMC_GPMCTRL_LPMODE_SHIFT                 (0U)
/*! LPMODE - Low-Power Mode */
#define CMC_GPMCTRL_LPMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CMC_GPMCTRL_LPMODE_SHIFT)) & CMC_GPMCTRL_LPMODE_MASK)
/*! @} */

/*! @name PMCTRL - Power Mode Control */
/*! @{ */

#define CMC_PMCTRL_LPMODE_MASK                   (0xFU)
#define CMC_PMCTRL_LPMODE_SHIFT                  (0U)
/*! LPMODE - Low-Power Mode
 *  0b0000..Active/Sleep
 *  0b0001..Deep Sleep
 *  0b0011..Power Down
 *  0b0111..Reserved
 *  0b1111..Deep-Power Down
 */
#define CMC_PMCTRL_LPMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_PMCTRL_LPMODE_SHIFT)) & CMC_PMCTRL_LPMODE_MASK)
/*! @} */

/* The count of CMC_PMCTRL */
#define CMC_PMCTRL_COUNT                         (2U)

/*! @name SRS - System Reset Status */
/*! @{ */

#define CMC_SRS_WAKEUP_MASK                      (0x1U)
#define CMC_SRS_WAKEUP_SHIFT                     (0U)
/*! WAKEUP - Wake-up Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_WAKEUP(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WAKEUP_SHIFT)) & CMC_SRS_WAKEUP_MASK)

#define CMC_SRS_POR_MASK                         (0x2U)
#define CMC_SRS_POR_SHIFT                        (1U)
/*! POR - Power-on Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_POR(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_POR_SHIFT)) & CMC_SRS_POR_MASK)

#define CMC_SRS_VD_MASK                          (0x4U)
#define CMC_SRS_VD_SHIFT                         (2U)
/*! VD - Voltage Detect Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_VD(x)                            (((uint32_t)(((uint32_t)(x)) << CMC_SRS_VD_SHIFT)) & CMC_SRS_VD_MASK)

#define CMC_SRS_WARM_MASK                        (0x10U)
#define CMC_SRS_WARM_SHIFT                       (4U)
/*! WARM - Warm Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_WARM(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WARM_SHIFT)) & CMC_SRS_WARM_MASK)

#define CMC_SRS_FATAL_MASK                       (0x20U)
#define CMC_SRS_FATAL_SHIFT                      (5U)
/*! FATAL - Fatal Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_FATAL(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_FATAL_SHIFT)) & CMC_SRS_FATAL_MASK)

#define CMC_SRS_PIN_MASK                         (0x100U)
#define CMC_SRS_PIN_SHIFT                        (8U)
/*! PIN - Pin Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_PIN(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_PIN_SHIFT)) & CMC_SRS_PIN_MASK)

#define CMC_SRS_DAP_MASK                         (0x200U)
#define CMC_SRS_DAP_SHIFT                        (9U)
/*! DAP - Debug Access Port Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_DAP(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_DAP_SHIFT)) & CMC_SRS_DAP_MASK)

#define CMC_SRS_RSTACK_MASK                      (0x400U)
#define CMC_SRS_RSTACK_SHIFT                     (10U)
/*! RSTACK - Reset Timeout
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_RSTACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_RSTACK_SHIFT)) & CMC_SRS_RSTACK_MASK)

#define CMC_SRS_LPACK_MASK                       (0x800U)
#define CMC_SRS_LPACK_SHIFT                      (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_LPACK(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LPACK_SHIFT)) & CMC_SRS_LPACK_MASK)

#define CMC_SRS_SCG_MASK                         (0x1000U)
#define CMC_SRS_SCG_SHIFT                        (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_SCG(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SCG_SHIFT)) & CMC_SRS_SCG_MASK)

#define CMC_SRS_WWDT0_MASK                       (0x2000U)
#define CMC_SRS_WWDT0_SHIFT                      (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_WWDT0(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WWDT0_SHIFT)) & CMC_SRS_WWDT0_MASK)

#define CMC_SRS_SW_MASK                          (0x4000U)
#define CMC_SRS_SW_SHIFT                         (14U)
/*! SW - Software Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_SW(x)                            (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SW_SHIFT)) & CMC_SRS_SW_MASK)

#define CMC_SRS_LOCKUP_MASK                      (0x8000U)
#define CMC_SRS_LOCKUP_SHIFT                     (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_LOCKUP(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LOCKUP_SHIFT)) & CMC_SRS_LOCKUP_MASK)

#define CMC_SRS_CPU1_MASK                        (0x10000U)
#define CMC_SRS_CPU1_SHIFT                       (16U)
/*! CPU1 - CPU1 System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_CPU1(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_CPU1_SHIFT)) & CMC_SRS_CPU1_MASK)

#define CMC_SRS_VBAT_MASK                        (0x1000000U)
#define CMC_SRS_VBAT_SHIFT                       (24U)
/*! VBAT - VBAT System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_VBAT(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_VBAT_SHIFT)) & CMC_SRS_VBAT_MASK)

#define CMC_SRS_WWDT1_MASK                       (0x2000000U)
#define CMC_SRS_WWDT1_SHIFT                      (25U)
/*! WWDT1 - Windowed Watchdog 1 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_WWDT1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WWDT1_SHIFT)) & CMC_SRS_WWDT1_MASK)

#define CMC_SRS_CDOG0_MASK                       (0x4000000U)
#define CMC_SRS_CDOG0_SHIFT                      (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_CDOG0(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_CDOG0_SHIFT)) & CMC_SRS_CDOG0_MASK)

#define CMC_SRS_CDOG1_MASK                       (0x8000000U)
#define CMC_SRS_CDOG1_SHIFT                      (27U)
/*! CDOG1 - Code Watchdog 1 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_CDOG1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_CDOG1_SHIFT)) & CMC_SRS_CDOG1_MASK)

#define CMC_SRS_JTAG_MASK                        (0x10000000U)
#define CMC_SRS_JTAG_SHIFT                       (28U)
/*! JTAG - JTAG System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_JTAG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_JTAG_SHIFT)) & CMC_SRS_JTAG_MASK)

#define CMC_SRS_SECVIO_MASK                      (0x40000000U)
#define CMC_SRS_SECVIO_SHIFT                     (30U)
/*! SECVIO - Security Violation Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_SECVIO(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SECVIO_SHIFT)) & CMC_SRS_SECVIO_MASK)

#define CMC_SRS_TAMPER_MASK                      (0x80000000U)
#define CMC_SRS_TAMPER_SHIFT                     (31U)
/*! TAMPER - Tamper Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_TAMPER(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_TAMPER_SHIFT)) & CMC_SRS_TAMPER_MASK)
/*! @} */

/*! @name RPC - Reset Pin Control */
/*! @{ */

#define CMC_RPC_FILTCFG_MASK                     (0x1FU)
#define CMC_RPC_FILTCFG_SHIFT                    (0U)
/*! FILTCFG - Reset Filter Configuration */
#define CMC_RPC_FILTCFG(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_RPC_FILTCFG_SHIFT)) & CMC_RPC_FILTCFG_MASK)

#define CMC_RPC_FILTEN_MASK                      (0x100U)
#define CMC_RPC_FILTEN_SHIFT                     (8U)
/*! FILTEN - Filter Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_RPC_FILTEN(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_RPC_FILTEN_SHIFT)) & CMC_RPC_FILTEN_MASK)

#define CMC_RPC_LPFEN_MASK                       (0x200U)
#define CMC_RPC_LPFEN_SHIFT                      (9U)
/*! LPFEN - Low-Power Filter Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_RPC_LPFEN(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_RPC_LPFEN_SHIFT)) & CMC_RPC_LPFEN_MASK)
/*! @} */

/*! @name SSRS - Sticky System Reset Status */
/*! @{ */

#define CMC_SSRS_WAKEUP_MASK                     (0x1U)
#define CMC_SSRS_WAKEUP_SHIFT                    (0U)
/*! WAKEUP - Wake-up Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_WAKEUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WAKEUP_SHIFT)) & CMC_SSRS_WAKEUP_MASK)

#define CMC_SSRS_POR_MASK                        (0x2U)
#define CMC_SSRS_POR_SHIFT                       (1U)
/*! POR - Power-on Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_POR(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_POR_SHIFT)) & CMC_SSRS_POR_MASK)

#define CMC_SSRS_VD_MASK                         (0x4U)
#define CMC_SSRS_VD_SHIFT                        (2U)
/*! VD - Voltage Detect Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_VD(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_VD_SHIFT)) & CMC_SSRS_VD_MASK)

#define CMC_SSRS_WARM_MASK                       (0x10U)
#define CMC_SSRS_WARM_SHIFT                      (4U)
/*! WARM - Warm Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_WARM(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WARM_SHIFT)) & CMC_SSRS_WARM_MASK)

#define CMC_SSRS_FATAL_MASK                      (0x20U)
#define CMC_SSRS_FATAL_SHIFT                     (5U)
/*! FATAL - Fatal Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SSRS_FATAL(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_FATAL_SHIFT)) & CMC_SSRS_FATAL_MASK)

#define CMC_SSRS_PIN_MASK                        (0x100U)
#define CMC_SSRS_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_PIN_SHIFT)) & CMC_SSRS_PIN_MASK)

#define CMC_SSRS_DAP_MASK                        (0x200U)
#define CMC_SSRS_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_DAP_SHIFT)) & CMC_SSRS_DAP_MASK)

#define CMC_SSRS_RSTACK_MASK                     (0x400U)
#define CMC_SSRS_RSTACK_SHIFT                    (10U)
/*! RSTACK - Reset Timeout
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_RSTACK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_RSTACK_SHIFT)) & CMC_SSRS_RSTACK_MASK)

#define CMC_SSRS_LPACK_MASK                      (0x800U)
#define CMC_SSRS_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LPACK_SHIFT)) & CMC_SSRS_LPACK_MASK)

#define CMC_SSRS_SCG_MASK                        (0x1000U)
#define CMC_SSRS_SCG_SHIFT                       (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_SCG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SCG_SHIFT)) & CMC_SSRS_SCG_MASK)

#define CMC_SSRS_WWDT0_MASK                      (0x2000U)
#define CMC_SSRS_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WWDT0_SHIFT)) & CMC_SSRS_WWDT0_MASK)

#define CMC_SSRS_SW_MASK                         (0x4000U)
#define CMC_SSRS_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SW_SHIFT)) & CMC_SSRS_SW_MASK)

#define CMC_SSRS_LOCKUP_MASK                     (0x8000U)
#define CMC_SSRS_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LOCKUP_SHIFT)) & CMC_SSRS_LOCKUP_MASK)

#define CMC_SSRS_CPU1_MASK                       (0x10000U)
#define CMC_SSRS_CPU1_SHIFT                      (16U)
/*! CPU1 - CPU1 Reset
 *  0b0..Reset not generated from CPU1 reset source.
 *  0b1..Reset generated from CPU1 reset source.
 */
#define CMC_SSRS_CPU1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_CPU1_SHIFT)) & CMC_SSRS_CPU1_MASK)

#define CMC_SSRS_VBAT_MASK                       (0x1000000U)
#define CMC_SSRS_VBAT_SHIFT                      (24U)
/*! VBAT - VBAT System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_VBAT(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_VBAT_SHIFT)) & CMC_SSRS_VBAT_MASK)

#define CMC_SSRS_WWDT1_MASK                      (0x2000000U)
#define CMC_SSRS_WWDT1_SHIFT                     (25U)
/*! WWDT1 - Windowed Watchdog 1 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_WWDT1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WWDT1_SHIFT)) & CMC_SSRS_WWDT1_MASK)

#define CMC_SSRS_CDOG0_MASK                      (0x4000000U)
#define CMC_SSRS_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_CDOG0_SHIFT)) & CMC_SSRS_CDOG0_MASK)

#define CMC_SSRS_CDOG1_MASK                      (0x8000000U)
#define CMC_SSRS_CDOG1_SHIFT                     (27U)
/*! CDOG1 - Code Watchdog 1 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_CDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_CDOG1_SHIFT)) & CMC_SSRS_CDOG1_MASK)

#define CMC_SSRS_JTAG_MASK                       (0x10000000U)
#define CMC_SSRS_JTAG_SHIFT                      (28U)
/*! JTAG - JTAG System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_JTAG(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_JTAG_SHIFT)) & CMC_SSRS_JTAG_MASK)

#define CMC_SSRS_SECVIO_MASK                     (0x40000000U)
#define CMC_SSRS_SECVIO_SHIFT                    (30U)
/*! SECVIO - Security Violation Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_SECVIO(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SECVIO_SHIFT)) & CMC_SSRS_SECVIO_MASK)

#define CMC_SSRS_TAMPER_MASK                     (0x80000000U)
#define CMC_SSRS_TAMPER_SHIFT                    (31U)
/*! TAMPER - Tamper Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_TAMPER(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_TAMPER_SHIFT)) & CMC_SSRS_TAMPER_MASK)
/*! @} */

/*! @name SRIE - System Reset Interrupt Enable */
/*! @{ */

#define CMC_SRIE_PIN_MASK                        (0x100U)
#define CMC_SRIE_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_PIN_SHIFT)) & CMC_SRIE_PIN_MASK)

#define CMC_SRIE_DAP_MASK                        (0x200U)
#define CMC_SRIE_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_DAP_SHIFT)) & CMC_SRIE_DAP_MASK)

#define CMC_SRIE_LPACK_MASK                      (0x800U)
#define CMC_SRIE_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_LPACK_SHIFT)) & CMC_SRIE_LPACK_MASK)

#define CMC_SRIE_SCG_MASK                        (0x1000U)
#define CMC_SRIE_SCG_SHIFT                       (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_SCG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_SCG_SHIFT)) & CMC_SRIE_SCG_MASK)

#define CMC_SRIE_WWDT0_MASK                      (0x2000U)
#define CMC_SRIE_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_WWDT0_SHIFT)) & CMC_SRIE_WWDT0_MASK)

#define CMC_SRIE_SW_MASK                         (0x4000U)
#define CMC_SRIE_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_SW_SHIFT)) & CMC_SRIE_SW_MASK)

#define CMC_SRIE_LOCKUP_MASK                     (0x8000U)
#define CMC_SRIE_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_LOCKUP_SHIFT)) & CMC_SRIE_LOCKUP_MASK)

#define CMC_SRIE_CPU1_MASK                       (0x10000U)
#define CMC_SRIE_CPU1_SHIFT                      (16U)
/*! CPU1 - CPU1 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_CPU1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_CPU1_SHIFT)) & CMC_SRIE_CPU1_MASK)

#define CMC_SRIE_VBAT_MASK                       (0x1000000U)
#define CMC_SRIE_VBAT_SHIFT                      (24U)
/*! VBAT - VBAT System Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_VBAT(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_VBAT_SHIFT)) & CMC_SRIE_VBAT_MASK)

#define CMC_SRIE_WWDT1_MASK                      (0x2000000U)
#define CMC_SRIE_WWDT1_SHIFT                     (25U)
/*! WWDT1 - Windowed Watchdog 1 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_WWDT1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_WWDT1_SHIFT)) & CMC_SRIE_WWDT1_MASK)

#define CMC_SRIE_CDOG0_MASK                      (0x4000000U)
#define CMC_SRIE_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_CDOG0_SHIFT)) & CMC_SRIE_CDOG0_MASK)

#define CMC_SRIE_CDOG1_MASK                      (0x8000000U)
#define CMC_SRIE_CDOG1_SHIFT                     (27U)
/*! CDOG1 - Code Watchdog 1 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_CDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_CDOG1_SHIFT)) & CMC_SRIE_CDOG1_MASK)
/*! @} */

/*! @name SRIF - System Reset Interrupt Flag */
/*! @{ */

#define CMC_SRIF_PIN_MASK                        (0x100U)
#define CMC_SRIF_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_PIN_SHIFT)) & CMC_SRIF_PIN_MASK)

#define CMC_SRIF_DAP_MASK                        (0x200U)
#define CMC_SRIF_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_DAP_SHIFT)) & CMC_SRIF_DAP_MASK)

#define CMC_SRIF_LPACK_MASK                      (0x800U)
#define CMC_SRIF_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_LPACK_SHIFT)) & CMC_SRIF_LPACK_MASK)

#define CMC_SRIF_WWDT0_MASK                      (0x2000U)
#define CMC_SRIF_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_WWDT0_SHIFT)) & CMC_SRIF_WWDT0_MASK)

#define CMC_SRIF_SW_MASK                         (0x4000U)
#define CMC_SRIF_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_SW_SHIFT)) & CMC_SRIF_SW_MASK)

#define CMC_SRIF_LOCKUP_MASK                     (0x8000U)
#define CMC_SRIF_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_LOCKUP_SHIFT)) & CMC_SRIF_LOCKUP_MASK)

#define CMC_SRIF_CPU1_MASK                       (0x10000U)
#define CMC_SRIF_CPU1_SHIFT                      (16U)
/*! CPU1 - CPU1 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_CPU1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_CPU1_SHIFT)) & CMC_SRIF_CPU1_MASK)

#define CMC_SRIF_VBAT_MASK                       (0x1000000U)
#define CMC_SRIF_VBAT_SHIFT                      (24U)
/*! VBAT - VBAT System Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_VBAT(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_VBAT_SHIFT)) & CMC_SRIF_VBAT_MASK)

#define CMC_SRIF_WWDT1_MASK                      (0x2000000U)
#define CMC_SRIF_WWDT1_SHIFT                     (25U)
/*! WWDT1 - Windowed Watchdog 1 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_WWDT1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_WWDT1_SHIFT)) & CMC_SRIF_WWDT1_MASK)

#define CMC_SRIF_CDOG0_MASK                      (0x4000000U)
#define CMC_SRIF_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_CDOG0_SHIFT)) & CMC_SRIF_CDOG0_MASK)

#define CMC_SRIF_CDOG1_MASK                      (0x8000000U)
#define CMC_SRIF_CDOG1_SHIFT                     (27U)
/*! CDOG1 - Code Watchdog 1 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_CDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_CDOG1_SHIFT)) & CMC_SRIF_CDOG1_MASK)
/*! @} */

/*! @name RSTCNT - Reset Count Register */
/*! @{ */

#define CMC_RSTCNT_COUNT_MASK                    (0xFFU)
#define CMC_RSTCNT_COUNT_SHIFT                   (0U)
/*! COUNT - Count */
#define CMC_RSTCNT_COUNT(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_RSTCNT_COUNT_SHIFT)) & CMC_RSTCNT_COUNT_MASK)
/*! @} */

/*! @name MR - Mode */
/*! @{ */

#define CMC_MR_ISPMODE_n_MASK                    (0x1U)
#define CMC_MR_ISPMODE_n_SHIFT                   (0U)
/*! ISPMODE_n - In System Programming Mode */
#define CMC_MR_ISPMODE_n(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_MR_ISPMODE_n_SHIFT)) & CMC_MR_ISPMODE_n_MASK)
/*! @} */

/* The count of CMC_MR */
#define CMC_MR_COUNT                             (1U)

/*! @name FM - Force Mode */
/*! @{ */

#define CMC_FM_FORCECFG_MASK                     (0x1U)
#define CMC_FM_FORCECFG_SHIFT                    (0U)
/*! FORCECFG - Boot Configuration
 *  0b0..No effect
 *  0b1..Asserts
 */
#define CMC_FM_FORCECFG(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_FM_FORCECFG_SHIFT)) & CMC_FM_FORCECFG_MASK)
/*! @} */

/* The count of CMC_FM */
#define CMC_FM_COUNT                             (1U)

/*! @name SRAMDIS - SRAM Disable */
/*! @{ */

#define CMC_SRAMDIS_DIS0_MASK                    (0x1U)
#define CMC_SRAMDIS_DIS0_SHIFT                   (0U)
/*! DIS0 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS0(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS0_SHIFT)) & CMC_SRAMDIS_DIS0_MASK)

#define CMC_SRAMDIS_DIS1_MASK                    (0x2U)
#define CMC_SRAMDIS_DIS1_SHIFT                   (1U)
/*! DIS1 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS1(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS1_SHIFT)) & CMC_SRAMDIS_DIS1_MASK)

#define CMC_SRAMDIS_DIS2_MASK                    (0x4U)
#define CMC_SRAMDIS_DIS2_SHIFT                   (2U)
/*! DIS2 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS2(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS2_SHIFT)) & CMC_SRAMDIS_DIS2_MASK)

#define CMC_SRAMDIS_DIS3_MASK                    (0x8U)
#define CMC_SRAMDIS_DIS3_SHIFT                   (3U)
/*! DIS3 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS3(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS3_SHIFT)) & CMC_SRAMDIS_DIS3_MASK)

#define CMC_SRAMDIS_DIS4_MASK                    (0x10U)
#define CMC_SRAMDIS_DIS4_SHIFT                   (4U)
/*! DIS4 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS4(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS4_SHIFT)) & CMC_SRAMDIS_DIS4_MASK)

#define CMC_SRAMDIS_DIS5_MASK                    (0x20U)
#define CMC_SRAMDIS_DIS5_SHIFT                   (5U)
/*! DIS5 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS5(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS5_SHIFT)) & CMC_SRAMDIS_DIS5_MASK)

#define CMC_SRAMDIS_DIS6_MASK                    (0x40U)
#define CMC_SRAMDIS_DIS6_SHIFT                   (6U)
/*! DIS6 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS6(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS6_SHIFT)) & CMC_SRAMDIS_DIS6_MASK)

#define CMC_SRAMDIS_DIS7_MASK                    (0x80U)
#define CMC_SRAMDIS_DIS7_SHIFT                   (7U)
/*! DIS7 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS7(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS7_SHIFT)) & CMC_SRAMDIS_DIS7_MASK)

#define CMC_SRAMDIS_DIS8_MASK                    (0x100U)
#define CMC_SRAMDIS_DIS8_SHIFT                   (8U)
/*! DIS8 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS8(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS8_SHIFT)) & CMC_SRAMDIS_DIS8_MASK)

#define CMC_SRAMDIS_DIS9_MASK                    (0x200U)
#define CMC_SRAMDIS_DIS9_SHIFT                   (9U)
/*! DIS9 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS9(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS9_SHIFT)) & CMC_SRAMDIS_DIS9_MASK)

#define CMC_SRAMDIS_DIS10_MASK                   (0x400U)
#define CMC_SRAMDIS_DIS10_SHIFT                  (10U)
/*! DIS10 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS10(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS10_SHIFT)) & CMC_SRAMDIS_DIS10_MASK)

#define CMC_SRAMDIS_DIS11_MASK                   (0x800U)
#define CMC_SRAMDIS_DIS11_SHIFT                  (11U)
/*! DIS11 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS11(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS11_SHIFT)) & CMC_SRAMDIS_DIS11_MASK)

#define CMC_SRAMDIS_DIS12_MASK                   (0x1000U)
#define CMC_SRAMDIS_DIS12_SHIFT                  (12U)
/*! DIS12 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS12(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS12_SHIFT)) & CMC_SRAMDIS_DIS12_MASK)

#define CMC_SRAMDIS_DIS13_MASK                   (0x2000U)
#define CMC_SRAMDIS_DIS13_SHIFT                  (13U)
/*! DIS13 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS13(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS13_SHIFT)) & CMC_SRAMDIS_DIS13_MASK)

#define CMC_SRAMDIS_DIS14_MASK                   (0x4000U)
#define CMC_SRAMDIS_DIS14_SHIFT                  (14U)
/*! DIS14 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS14(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS14_SHIFT)) & CMC_SRAMDIS_DIS14_MASK)

#define CMC_SRAMDIS_DIS15_MASK                   (0x8000U)
#define CMC_SRAMDIS_DIS15_SHIFT                  (15U)
/*! DIS15 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS15(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS15_SHIFT)) & CMC_SRAMDIS_DIS15_MASK)

#define CMC_SRAMDIS_DIS16_MASK                   (0x10000U)
#define CMC_SRAMDIS_DIS16_SHIFT                  (16U)
/*! DIS16 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS16(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS16_SHIFT)) & CMC_SRAMDIS_DIS16_MASK)

#define CMC_SRAMDIS_DIS17_MASK                   (0x20000U)
#define CMC_SRAMDIS_DIS17_SHIFT                  (17U)
/*! DIS17 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS17(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS17_SHIFT)) & CMC_SRAMDIS_DIS17_MASK)

#define CMC_SRAMDIS_DIS18_MASK                   (0x40000U)
#define CMC_SRAMDIS_DIS18_SHIFT                  (18U)
/*! DIS18 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS18(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS18_SHIFT)) & CMC_SRAMDIS_DIS18_MASK)

#define CMC_SRAMDIS_DIS19_MASK                   (0x80000U)
#define CMC_SRAMDIS_DIS19_SHIFT                  (19U)
/*! DIS19 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS19(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS19_SHIFT)) & CMC_SRAMDIS_DIS19_MASK)

#define CMC_SRAMDIS_DIS20_MASK                   (0x100000U)
#define CMC_SRAMDIS_DIS20_SHIFT                  (20U)
/*! DIS20 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS20(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS20_SHIFT)) & CMC_SRAMDIS_DIS20_MASK)

#define CMC_SRAMDIS_DIS21_MASK                   (0x200000U)
#define CMC_SRAMDIS_DIS21_SHIFT                  (21U)
/*! DIS21 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS21(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS21_SHIFT)) & CMC_SRAMDIS_DIS21_MASK)

#define CMC_SRAMDIS_DIS22_MASK                   (0x400000U)
#define CMC_SRAMDIS_DIS22_SHIFT                  (22U)
/*! DIS22 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS22(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS22_SHIFT)) & CMC_SRAMDIS_DIS22_MASK)

#define CMC_SRAMDIS_DIS23_MASK                   (0x800000U)
#define CMC_SRAMDIS_DIS23_SHIFT                  (23U)
/*! DIS23 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS23(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS23_SHIFT)) & CMC_SRAMDIS_DIS23_MASK)

#define CMC_SRAMDIS_DIS24_MASK                   (0x1000000U)
#define CMC_SRAMDIS_DIS24_SHIFT                  (24U)
/*! DIS24 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS24(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS24_SHIFT)) & CMC_SRAMDIS_DIS24_MASK)

#define CMC_SRAMDIS_DIS25_MASK                   (0x2000000U)
#define CMC_SRAMDIS_DIS25_SHIFT                  (25U)
/*! DIS25 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS25(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS25_SHIFT)) & CMC_SRAMDIS_DIS25_MASK)

#define CMC_SRAMDIS_DIS26_MASK                   (0x4000000U)
#define CMC_SRAMDIS_DIS26_SHIFT                  (26U)
/*! DIS26 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS26(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS26_SHIFT)) & CMC_SRAMDIS_DIS26_MASK)

#define CMC_SRAMDIS_DIS27_MASK                   (0x8000000U)
#define CMC_SRAMDIS_DIS27_SHIFT                  (27U)
/*! DIS27 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS27(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS27_SHIFT)) & CMC_SRAMDIS_DIS27_MASK)

#define CMC_SRAMDIS_DIS28_MASK                   (0x10000000U)
#define CMC_SRAMDIS_DIS28_SHIFT                  (28U)
/*! DIS28 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS28(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS28_SHIFT)) & CMC_SRAMDIS_DIS28_MASK)

#define CMC_SRAMDIS_DIS29_MASK                   (0x20000000U)
#define CMC_SRAMDIS_DIS29_SHIFT                  (29U)
/*! DIS29 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS29(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS29_SHIFT)) & CMC_SRAMDIS_DIS29_MASK)

#define CMC_SRAMDIS_DIS30_MASK                   (0x40000000U)
#define CMC_SRAMDIS_DIS30_SHIFT                  (30U)
/*! DIS30 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS30(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS30_SHIFT)) & CMC_SRAMDIS_DIS30_MASK)

#define CMC_SRAMDIS_DIS31_MASK                   (0x80000000U)
#define CMC_SRAMDIS_DIS31_SHIFT                  (31U)
/*! DIS31 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS31(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS31_SHIFT)) & CMC_SRAMDIS_DIS31_MASK)
/*! @} */

/* The count of CMC_SRAMDIS */
#define CMC_SRAMDIS_COUNT                        (1U)

/*! @name SRAMRET - SRAM Retention */
/*! @{ */

#define CMC_SRAMRET_RET0_MASK                    (0x1U)
#define CMC_SRAMRET_RET0_SHIFT                   (0U)
/*! RET0 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET0(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET0_SHIFT)) & CMC_SRAMRET_RET0_MASK)

#define CMC_SRAMRET_RET1_MASK                    (0x2U)
#define CMC_SRAMRET_RET1_SHIFT                   (1U)
/*! RET1 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET1(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET1_SHIFT)) & CMC_SRAMRET_RET1_MASK)

#define CMC_SRAMRET_RET2_MASK                    (0x4U)
#define CMC_SRAMRET_RET2_SHIFT                   (2U)
/*! RET2 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET2(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET2_SHIFT)) & CMC_SRAMRET_RET2_MASK)

#define CMC_SRAMRET_RET3_MASK                    (0x8U)
#define CMC_SRAMRET_RET3_SHIFT                   (3U)
/*! RET3 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET3(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET3_SHIFT)) & CMC_SRAMRET_RET3_MASK)

#define CMC_SRAMRET_RET4_MASK                    (0x10U)
#define CMC_SRAMRET_RET4_SHIFT                   (4U)
/*! RET4 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET4(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET4_SHIFT)) & CMC_SRAMRET_RET4_MASK)

#define CMC_SRAMRET_RET5_MASK                    (0x20U)
#define CMC_SRAMRET_RET5_SHIFT                   (5U)
/*! RET5 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET5(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET5_SHIFT)) & CMC_SRAMRET_RET5_MASK)

#define CMC_SRAMRET_RET6_MASK                    (0x40U)
#define CMC_SRAMRET_RET6_SHIFT                   (6U)
/*! RET6 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET6(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET6_SHIFT)) & CMC_SRAMRET_RET6_MASK)

#define CMC_SRAMRET_RET7_MASK                    (0x80U)
#define CMC_SRAMRET_RET7_SHIFT                   (7U)
/*! RET7 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET7(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET7_SHIFT)) & CMC_SRAMRET_RET7_MASK)

#define CMC_SRAMRET_RET8_MASK                    (0x100U)
#define CMC_SRAMRET_RET8_SHIFT                   (8U)
/*! RET8 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET8(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET8_SHIFT)) & CMC_SRAMRET_RET8_MASK)

#define CMC_SRAMRET_RET9_MASK                    (0x200U)
#define CMC_SRAMRET_RET9_SHIFT                   (9U)
/*! RET9 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET9(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET9_SHIFT)) & CMC_SRAMRET_RET9_MASK)

#define CMC_SRAMRET_RET10_MASK                   (0x400U)
#define CMC_SRAMRET_RET10_SHIFT                  (10U)
/*! RET10 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET10(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET10_SHIFT)) & CMC_SRAMRET_RET10_MASK)

#define CMC_SRAMRET_RET11_MASK                   (0x800U)
#define CMC_SRAMRET_RET11_SHIFT                  (11U)
/*! RET11 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET11(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET11_SHIFT)) & CMC_SRAMRET_RET11_MASK)

#define CMC_SRAMRET_RET12_MASK                   (0x1000U)
#define CMC_SRAMRET_RET12_SHIFT                  (12U)
/*! RET12 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET12(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET12_SHIFT)) & CMC_SRAMRET_RET12_MASK)

#define CMC_SRAMRET_RET13_MASK                   (0x2000U)
#define CMC_SRAMRET_RET13_SHIFT                  (13U)
/*! RET13 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET13(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET13_SHIFT)) & CMC_SRAMRET_RET13_MASK)

#define CMC_SRAMRET_RET14_MASK                   (0x4000U)
#define CMC_SRAMRET_RET14_SHIFT                  (14U)
/*! RET14 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET14(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET14_SHIFT)) & CMC_SRAMRET_RET14_MASK)

#define CMC_SRAMRET_RET15_MASK                   (0x8000U)
#define CMC_SRAMRET_RET15_SHIFT                  (15U)
/*! RET15 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET15(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET15_SHIFT)) & CMC_SRAMRET_RET15_MASK)

#define CMC_SRAMRET_RET16_MASK                   (0x10000U)
#define CMC_SRAMRET_RET16_SHIFT                  (16U)
/*! RET16 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET16(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET16_SHIFT)) & CMC_SRAMRET_RET16_MASK)

#define CMC_SRAMRET_RET17_MASK                   (0x20000U)
#define CMC_SRAMRET_RET17_SHIFT                  (17U)
/*! RET17 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET17(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET17_SHIFT)) & CMC_SRAMRET_RET17_MASK)

#define CMC_SRAMRET_RET18_MASK                   (0x40000U)
#define CMC_SRAMRET_RET18_SHIFT                  (18U)
/*! RET18 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET18(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET18_SHIFT)) & CMC_SRAMRET_RET18_MASK)

#define CMC_SRAMRET_RET19_MASK                   (0x80000U)
#define CMC_SRAMRET_RET19_SHIFT                  (19U)
/*! RET19 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET19(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET19_SHIFT)) & CMC_SRAMRET_RET19_MASK)

#define CMC_SRAMRET_RET20_MASK                   (0x100000U)
#define CMC_SRAMRET_RET20_SHIFT                  (20U)
/*! RET20 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET20(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET20_SHIFT)) & CMC_SRAMRET_RET20_MASK)

#define CMC_SRAMRET_RET21_MASK                   (0x200000U)
#define CMC_SRAMRET_RET21_SHIFT                  (21U)
/*! RET21 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET21(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET21_SHIFT)) & CMC_SRAMRET_RET21_MASK)

#define CMC_SRAMRET_RET22_MASK                   (0x400000U)
#define CMC_SRAMRET_RET22_SHIFT                  (22U)
/*! RET22 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET22(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET22_SHIFT)) & CMC_SRAMRET_RET22_MASK)

#define CMC_SRAMRET_RET23_MASK                   (0x800000U)
#define CMC_SRAMRET_RET23_SHIFT                  (23U)
/*! RET23 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET23(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET23_SHIFT)) & CMC_SRAMRET_RET23_MASK)

#define CMC_SRAMRET_RET24_MASK                   (0x1000000U)
#define CMC_SRAMRET_RET24_SHIFT                  (24U)
/*! RET24 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET24(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET24_SHIFT)) & CMC_SRAMRET_RET24_MASK)

#define CMC_SRAMRET_RET25_MASK                   (0x2000000U)
#define CMC_SRAMRET_RET25_SHIFT                  (25U)
/*! RET25 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET25(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET25_SHIFT)) & CMC_SRAMRET_RET25_MASK)

#define CMC_SRAMRET_RET26_MASK                   (0x4000000U)
#define CMC_SRAMRET_RET26_SHIFT                  (26U)
/*! RET26 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET26(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET26_SHIFT)) & CMC_SRAMRET_RET26_MASK)

#define CMC_SRAMRET_RET27_MASK                   (0x8000000U)
#define CMC_SRAMRET_RET27_SHIFT                  (27U)
/*! RET27 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET27(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET27_SHIFT)) & CMC_SRAMRET_RET27_MASK)

#define CMC_SRAMRET_RET28_MASK                   (0x10000000U)
#define CMC_SRAMRET_RET28_SHIFT                  (28U)
/*! RET28 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET28(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET28_SHIFT)) & CMC_SRAMRET_RET28_MASK)

#define CMC_SRAMRET_RET29_MASK                   (0x20000000U)
#define CMC_SRAMRET_RET29_SHIFT                  (29U)
/*! RET29 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET29(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET29_SHIFT)) & CMC_SRAMRET_RET29_MASK)

#define CMC_SRAMRET_RET30_MASK                   (0x40000000U)
#define CMC_SRAMRET_RET30_SHIFT                  (30U)
/*! RET30 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET30(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET30_SHIFT)) & CMC_SRAMRET_RET30_MASK)

#define CMC_SRAMRET_RET31_MASK                   (0x80000000U)
#define CMC_SRAMRET_RET31_SHIFT                  (31U)
/*! RET31 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET31(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET31_SHIFT)) & CMC_SRAMRET_RET31_MASK)
/*! @} */

/* The count of CMC_SRAMRET */
#define CMC_SRAMRET_COUNT                        (1U)

/*! @name FLASHCR - Flash Control */
/*! @{ */

#define CMC_FLASHCR_FLASHDIS_MASK                (0x1U)
#define CMC_FLASHCR_FLASHDIS_SHIFT               (0U)
/*! FLASHDIS - Flash Disable
 *  0b0..No effect
 *  0b1..Flash memory is disabled
 */
#define CMC_FLASHCR_FLASHDIS(x)                  (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHDIS_SHIFT)) & CMC_FLASHCR_FLASHDIS_MASK)

#define CMC_FLASHCR_FLASHDOZE_MASK               (0x2U)
#define CMC_FLASHCR_FLASHDOZE_SHIFT              (1U)
/*! FLASHDOZE - Flash Doze
 *  0b0..No effect
 *  0b1..Flash memory is disabled when core is sleeping (CKMODE > 0)
 */
#define CMC_FLASHCR_FLASHDOZE(x)                 (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHDOZE_SHIFT)) & CMC_FLASHCR_FLASHDOZE_MASK)
/*! @} */

/*! @name BSR - BootROM Status Register */
/*! @{ */

#define CMC_BSR_STAT_MASK                        (0xFFFFFFFFU)
#define CMC_BSR_STAT_SHIFT                       (0U)
/*! STAT - Provides status information written by the BootROM. */
#define CMC_BSR_STAT(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_BSR_STAT_SHIFT)) & CMC_BSR_STAT_MASK)
/*! @} */

/*! @name BLR - BootROM Lock Register */
/*! @{ */

#define CMC_BLR_LOCK_MASK                        (0x7U)
#define CMC_BLR_LOCK_SHIFT                       (0U)
/*! LOCK - Lock
 *  0b010..BootROM Status and Lock Registers can be written
 *  0b101..BootROM Status and Lock Registers cannot be written
 */
#define CMC_BLR_LOCK(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_BLR_LOCK_SHIFT)) & CMC_BLR_LOCK_MASK)
/*! @} */

/*! @name CORECTL - Core Control */
/*! @{ */

#define CMC_CORECTL_NPIE_MASK                    (0x1U)
#define CMC_CORECTL_NPIE_SHIFT                   (0U)
/*! NPIE - Non-maskable Pin Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_CORECTL_NPIE(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_CORECTL_NPIE_SHIFT)) & CMC_CORECTL_NPIE_MASK)
/*! @} */

/*! @name DBGCTL - Debug Control */
/*! @{ */

#define CMC_DBGCTL_SOD_MASK                      (0x1U)
#define CMC_DBGCTL_SOD_SHIFT                     (0U)
/*! SOD - Sleep Or Debug
 *  0b0..Remains enabled
 *  0b1..Disabled
 */
#define CMC_DBGCTL_SOD(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_DBGCTL_SOD_SHIFT)) & CMC_DBGCTL_SOD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CMC_Register_Masks */


/* CMC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CMC0 base address */
  #define CMC0_BASE                                (0x50048000u)
  /** Peripheral CMC0 base address */
  #define CMC0_BASE_NS                             (0x40048000u)
  /** Peripheral CMC0 base pointer */
  #define CMC0                                     ((CMC_Type *)CMC0_BASE)
  /** Peripheral CMC0 base pointer */
  #define CMC0_NS                                  ((CMC_Type *)CMC0_BASE_NS)
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS                           { CMC0_BASE }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS                            { CMC0 }
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS_NS                        { CMC0_BASE_NS }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS_NS                         { CMC0_NS }
#else
  /** Peripheral CMC0 base address */
  #define CMC0_BASE                                (0x40048000u)
  /** Peripheral CMC0 base pointer */
  #define CMC0                                     ((CMC_Type *)CMC0_BASE)
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS                           { CMC0_BASE }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS                            { CMC0 }
#endif
/* Backward compatibility for CMC */
#define CMC_SRAMDIS_DIS_MASK                     (0xFFFFFFFFU)
#define CMC_SRAMDIS_DIS_SHIFT                    (0U)
/*! DIS - SRAM Disable */
#define CMC_SRAMDIS_DIS(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS_SHIFT)) & CMC_SRAMDIS_DIS_MASK)

#define CMC_SRAMRET_RET_MASK                     (0xFFFFFFFFU)
#define CMC_SRAMRET_RET_SHIFT                    (0U)
/*! RET - SRAM Retention */
#define CMC_SRAMRET_RET(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET_SHIFT)) & CMC_SRAMRET_RET_MASK)


/*!
 * @}
 */ /* end of group CMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint8_t DATALL;                             /**< CRC_DATALL register, offset: 0x0 */
      __IO uint8_t DATALU;                             /**< CRC_DATALU register, offset: 0x1 */
      __IO uint8_t DATAHL;                             /**< CRC_DATAHL register, offset: 0x2 */
      __IO uint8_t DATAHU;                             /**< CRC_DATAHU register, offset: 0x3 */
    } ACCESS8BIT;
    struct {                                         /* offset: 0x0 */
      __IO uint16_t DATAL;                             /**< CRC_DATAL register, offset: 0x0 */
      __IO uint16_t DATAH;                             /**< CRC_DATAH register, offset: 0x2 */
    } ACCESS16BIT;
    __IO uint32_t DATA;                              /**< CRC Data, offset: 0x0 */
  };
  union {                                          /* offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint8_t GPOLYLL;                            /**< CRC_GPOLYLL register, offset: 0x4 */
      __IO uint8_t GPOLYLU;                            /**< CRC_GPOLYLU register, offset: 0x5 */
      __IO uint8_t GPOLYHL;                            /**< CRC_GPOLYHL register, offset: 0x6 */
      __IO uint8_t GPOLYHU;                            /**< CRC_GPOLYHU register, offset: 0x7 */
    } GPOLY_ACCESS8BIT;
    struct {                                         /* offset: 0x4 */
      __IO uint16_t GPOLYL;                            /**< CRC_GPOLYL register, offset: 0x4 */
      __IO uint16_t GPOLYH;                            /**< CRC_GPOLYH register, offset: 0x6 */
    } GPOLY_ACCESS16BIT;
    __IO uint32_t GPOLY;                             /**< CRC Polynomial, offset: 0x4 */
  };
  union {                                          /* offset: 0x8 */
    struct {                                         /* offset: 0x8 */
           uint8_t RESERVED_0[3];
      __IO uint8_t CTRLHU;                             /**< CRC_CTRLHU register, offset: 0xB */
    } CTRL_ACCESS8BIT;
    __IO uint32_t CTRL;                              /**< CRC Control, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name DATALL - CRC_DATALL register */
/*! @{ */

#define CRC_DATALL_DATALL_MASK                   (0xFFU)
#define CRC_DATALL_DATALL_SHIFT                  (0U)
#define CRC_DATALL_DATALL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALL_DATALL_SHIFT)) & CRC_DATALL_DATALL_MASK)
/*! @} */

/*! @name DATALU - CRC_DATALU register */
/*! @{ */

#define CRC_DATALU_DATALU_MASK                   (0xFFU)
#define CRC_DATALU_DATALU_SHIFT                  (0U)
#define CRC_DATALU_DATALU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALU_DATALU_SHIFT)) & CRC_DATALU_DATALU_MASK)
/*! @} */

/*! @name DATAHL - CRC_DATAHL register */
/*! @{ */

#define CRC_DATAHL_DATAHL_MASK                   (0xFFU)
#define CRC_DATAHL_DATAHL_SHIFT                  (0U)
#define CRC_DATAHL_DATAHL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHL_DATAHL_SHIFT)) & CRC_DATAHL_DATAHL_MASK)
/*! @} */

/*! @name DATAHU - CRC_DATAHU register */
/*! @{ */

#define CRC_DATAHU_DATAHU_MASK                   (0xFFU)
#define CRC_DATAHU_DATAHU_SHIFT                  (0U)
#define CRC_DATAHU_DATAHU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHU_DATAHU_SHIFT)) & CRC_DATAHU_DATAHU_MASK)
/*! @} */

/*! @name DATAL - CRC_DATAL register */
/*! @{ */

#define CRC_DATAL_DATAL_MASK                     (0xFFFFU)
#define CRC_DATAL_DATAL_SHIFT                    (0U)
#define CRC_DATAL_DATAL(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAL_DATAL_SHIFT)) & CRC_DATAL_DATAL_MASK)
/*! @} */

/*! @name DATAH - CRC_DATAH register */
/*! @{ */

#define CRC_DATAH_DATAH_MASK                     (0xFFFFU)
#define CRC_DATAH_DATAH_SHIFT                    (0U)
#define CRC_DATAH_DATAH(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAH_DATAH_SHIFT)) & CRC_DATAH_DATAH_MASK)
/*! @} */

/*! @name DATA - CRC Data */
/*! @{ */

#define CRC_DATA_LL_MASK                         (0xFFU)
#define CRC_DATA_LL_SHIFT                        (0U)
/*! LL - CRC Low Lower Byte */
#define CRC_DATA_LL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LL_SHIFT)) & CRC_DATA_LL_MASK)

#define CRC_DATA_LU_MASK                         (0xFF00U)
#define CRC_DATA_LU_SHIFT                        (8U)
/*! LU - CRC Low Upper Byte */
#define CRC_DATA_LU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LU_SHIFT)) & CRC_DATA_LU_MASK)

#define CRC_DATA_HL_MASK                         (0xFF0000U)
#define CRC_DATA_HL_SHIFT                        (16U)
/*! HL - CRC High Lower Byte */
#define CRC_DATA_HL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HL_SHIFT)) & CRC_DATA_HL_MASK)

#define CRC_DATA_HU_MASK                         (0xFF000000U)
#define CRC_DATA_HU_SHIFT                        (24U)
/*! HU - CRC High Upper Byte */
#define CRC_DATA_HU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HU_SHIFT)) & CRC_DATA_HU_MASK)
/*! @} */

/*! @name GPOLYLL - CRC_GPOLYLL register */
/*! @{ */

#define CRC_GPOLYLL_GPOLYLL_MASK                 (0xFFU)
#define CRC_GPOLYLL_GPOLYLL_SHIFT                (0U)
#define CRC_GPOLYLL_GPOLYLL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLL_GPOLYLL_SHIFT)) & CRC_GPOLYLL_GPOLYLL_MASK)
/*! @} */

/*! @name GPOLYLU - CRC_GPOLYLU register */
/*! @{ */

#define CRC_GPOLYLU_GPOLYLU_MASK                 (0xFFU)
#define CRC_GPOLYLU_GPOLYLU_SHIFT                (0U)
#define CRC_GPOLYLU_GPOLYLU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLU_GPOLYLU_SHIFT)) & CRC_GPOLYLU_GPOLYLU_MASK)
/*! @} */

/*! @name GPOLYHL - CRC_GPOLYHL register */
/*! @{ */

#define CRC_GPOLYHL_GPOLYHL_MASK                 (0xFFU)
#define CRC_GPOLYHL_GPOLYHL_SHIFT                (0U)
#define CRC_GPOLYHL_GPOLYHL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHL_GPOLYHL_SHIFT)) & CRC_GPOLYHL_GPOLYHL_MASK)
/*! @} */

/*! @name GPOLYHU - CRC_GPOLYHU register */
/*! @{ */

#define CRC_GPOLYHU_GPOLYHU_MASK                 (0xFFU)
#define CRC_GPOLYHU_GPOLYHU_SHIFT                (0U)
#define CRC_GPOLYHU_GPOLYHU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHU_GPOLYHU_SHIFT)) & CRC_GPOLYHU_GPOLYHU_MASK)
/*! @} */

/*! @name GPOLYL - CRC_GPOLYL register */
/*! @{ */

#define CRC_GPOLYL_GPOLYL_MASK                   (0xFFFFU)
#define CRC_GPOLYL_GPOLYL_SHIFT                  (0U)
#define CRC_GPOLYL_GPOLYL(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYL_GPOLYL_SHIFT)) & CRC_GPOLYL_GPOLYL_MASK)
/*! @} */

/*! @name GPOLYH - CRC_GPOLYH register */
/*! @{ */

#define CRC_GPOLYH_GPOLYH_MASK                   (0xFFFFU)
#define CRC_GPOLYH_GPOLYH_SHIFT                  (0U)
#define CRC_GPOLYH_GPOLYH(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYH_GPOLYH_SHIFT)) & CRC_GPOLYH_GPOLYH_MASK)
/*! @} */

/*! @name GPOLY - CRC Polynomial */
/*! @{ */

#define CRC_GPOLY_LOW_MASK                       (0xFFFFU)
#define CRC_GPOLY_LOW_SHIFT                      (0U)
/*! LOW - Low Polynomial Half-Word */
#define CRC_GPOLY_LOW(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_LOW_SHIFT)) & CRC_GPOLY_LOW_MASK)

#define CRC_GPOLY_HIGH_MASK                      (0xFFFF0000U)
#define CRC_GPOLY_HIGH_SHIFT                     (16U)
/*! HIGH - High Polynomial Half-Word */
#define CRC_GPOLY_HIGH(x)                        (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_HIGH_SHIFT)) & CRC_GPOLY_HIGH_MASK)
/*! @} */

/*! @name CTRLHU - CRC_CTRLHU register */
/*! @{ */

#define CRC_CTRLHU_TCRC_MASK                     (0x1U)
#define CRC_CTRLHU_TCRC_SHIFT                    (0U)
/*! TCRC - TCRC
 *  0b0..16-bit
 *  0b1..32-bit
 */
#define CRC_CTRLHU_TCRC(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TCRC_SHIFT)) & CRC_CTRLHU_TCRC_MASK)

#define CRC_CTRLHU_WAS_MASK                      (0x2U)
#define CRC_CTRLHU_WAS_SHIFT                     (1U)
/*! WAS - Write as Seed
 *  0b0..Data values
 *  0b1..Seed values
 */
#define CRC_CTRLHU_WAS(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_WAS_SHIFT)) & CRC_CTRLHU_WAS_MASK)

#define CRC_CTRLHU_FXOR_MASK                     (0x4U)
#define CRC_CTRLHU_FXOR_SHIFT                    (2U)
/*! FXOR - Complement Read of CRC Data Register
 *  0b0..No XOR on reading
 *  0b1..Inverts or complements the read value of the CRC Data
 */
#define CRC_CTRLHU_FXOR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_FXOR_SHIFT)) & CRC_CTRLHU_FXOR_MASK)

#define CRC_CTRLHU_TOTR_MASK                     (0x30U)
#define CRC_CTRLHU_TOTR_SHIFT                    (4U)
/*! TOTR - Transpose Type for Read
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed; bytes are not transposed
 *  0b10..Both bits in bytes and bytes are transposed
 *  0b11..Only bytes are transposed; no bits in a byte are transposed
 */
#define CRC_CTRLHU_TOTR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOTR_SHIFT)) & CRC_CTRLHU_TOTR_MASK)

#define CRC_CTRLHU_TOT_MASK                      (0xC0U)
#define CRC_CTRLHU_TOT_SHIFT                     (6U)
/*! TOT - Transpose Type for Writes
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed; bytes are not transposed
 *  0b10..Both bits in bytes and bytes are transposed
 *  0b11..Only bytes are transposed; no bits in a byte are transposed
 */
#define CRC_CTRLHU_TOT(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOT_SHIFT)) & CRC_CTRLHU_TOT_MASK)
/*! @} */

/*! @name CTRL - CRC Control */
/*! @{ */

#define CRC_CTRL_TCRC_MASK                       (0x1000000U)
#define CRC_CTRL_TCRC_SHIFT                      (24U)
/*! TCRC - TCRC
 *  0b0..16-bit
 *  0b1..32-bit
 */
#define CRC_CTRL_TCRC(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TCRC_SHIFT)) & CRC_CTRL_TCRC_MASK)

#define CRC_CTRL_WAS_MASK                        (0x2000000U)
#define CRC_CTRL_WAS_SHIFT                       (25U)
/*! WAS - Write as Seed
 *  0b0..Data values
 *  0b1..Seed values
 */
#define CRC_CTRL_WAS(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_WAS_SHIFT)) & CRC_CTRL_WAS_MASK)

#define CRC_CTRL_FXOR_MASK                       (0x4000000U)
#define CRC_CTRL_FXOR_SHIFT                      (26U)
/*! FXOR - Complement Read of CRC Data Register
 *  0b0..No XOR on reading
 *  0b1..Inverts or complements the read value of the CRC Data
 */
#define CRC_CTRL_FXOR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_FXOR_SHIFT)) & CRC_CTRL_FXOR_MASK)

#define CRC_CTRL_TOTR_MASK                       (0x30000000U)
#define CRC_CTRL_TOTR_SHIFT                      (28U)
/*! TOTR - Transpose Type for Read
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed; bytes are not transposed
 *  0b10..Both bits in bytes and bytes are transposed
 *  0b11..Only bytes are transposed; no bits in a byte are transposed
 */
#define CRC_CTRL_TOTR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOTR_SHIFT)) & CRC_CTRL_TOTR_MASK)

#define CRC_CTRL_TOT_MASK                        (0xC0000000U)
#define CRC_CTRL_TOT_SHIFT                       (30U)
/*! TOT - Transpose Type for Writes
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed; bytes are not transposed
 *  0b10..Both bits in bytes and bytes are transposed
 *  0b11..Only bytes are transposed; no bits in a byte are transposed
 */
#define CRC_CTRL_TOT(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOT_SHIFT)) & CRC_CTRL_TOT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CRC0 base address */
  #define CRC0_BASE                                (0x500CB000u)
  /** Peripheral CRC0 base address */
  #define CRC0_BASE_NS                             (0x400CB000u)
  /** Peripheral CRC0 base pointer */
  #define CRC0                                     ((CRC_Type *)CRC0_BASE)
  /** Peripheral CRC0 base pointer */
  #define CRC0_NS                                  ((CRC_Type *)CRC0_BASE_NS)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC0_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC0 }
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS_NS                        { CRC0_BASE_NS }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS_NS                         { CRC0_NS }
#else
  /** Peripheral CRC0 base address */
  #define CRC0_BASE                                (0x400CB000u)
  /** Peripheral CRC0 base pointer */
  #define CRC0                                     ((CRC_Type *)CRC0_BASE)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC0_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC0 }
#endif

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct {
  __IO uint32_t IR;                                /**< Interrupt, offset: 0x0 */
  __IO uint32_t TCR;                               /**< Timer Control, offset: 0x4 */
  __IO uint32_t TC;                                /**< Timer Counter, offset: 0x8 */
  __IO uint32_t PR;                                /**< Prescale, offset: 0xC */
  __IO uint32_t PC;                                /**< Prescale Counter, offset: 0x10 */
  __IO uint32_t MCR;                               /**< Match Control, offset: 0x14 */
  __IO uint32_t MR[4];                             /**< Match, array offset: 0x18, array step: 0x4 */
  __IO uint32_t CCR;                               /**< Capture Control, offset: 0x28 */
  __I  uint32_t CR[4];                             /**< Capture, array offset: 0x2C, array step: 0x4 */
  __IO uint32_t EMR;                               /**< External Match, offset: 0x3C */
       uint8_t RESERVED_0[48];
  __IO uint32_t CTCR;                              /**< Count Control, offset: 0x70 */
  __IO uint32_t PWMC;                              /**< PWM Control, offset: 0x74 */
  __IO uint32_t MSR[4];                            /**< Match Shadow, array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt */
/*! @{ */

#define CTIMER_IR_MR0INT_MASK                    (0x1U)
#define CTIMER_IR_MR0INT_SHIFT                   (0U)
/*! MR0INT - Interrupt Flag for Match Channel 0 Event */
#define CTIMER_IR_MR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)

#define CTIMER_IR_MR1INT_MASK                    (0x2U)
#define CTIMER_IR_MR1INT_SHIFT                   (1U)
/*! MR1INT - Interrupt Flag for Match Channel 1 Event */
#define CTIMER_IR_MR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)

#define CTIMER_IR_MR2INT_MASK                    (0x4U)
#define CTIMER_IR_MR2INT_SHIFT                   (2U)
/*! MR2INT - Interrupt Flag for Match Channel 2 Event */
#define CTIMER_IR_MR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)

#define CTIMER_IR_MR3INT_MASK                    (0x8U)
#define CTIMER_IR_MR3INT_SHIFT                   (3U)
/*! MR3INT - Interrupt Flag for Match Channel 3 Event */
#define CTIMER_IR_MR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)

#define CTIMER_IR_CR0INT_MASK                    (0x10U)
#define CTIMER_IR_CR0INT_SHIFT                   (4U)
/*! CR0INT - Interrupt Flag for Capture Channel 0 Event */
#define CTIMER_IR_CR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)

#define CTIMER_IR_CR1INT_MASK                    (0x20U)
#define CTIMER_IR_CR1INT_SHIFT                   (5U)
/*! CR1INT - Interrupt Flag for Capture Channel 1 Event */
#define CTIMER_IR_CR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)

#define CTIMER_IR_CR2INT_MASK                    (0x40U)
#define CTIMER_IR_CR2INT_SHIFT                   (6U)
/*! CR2INT - Interrupt Flag for Capture Channel 2 Event */
#define CTIMER_IR_CR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)

#define CTIMER_IR_CR3INT_MASK                    (0x80U)
#define CTIMER_IR_CR3INT_SHIFT                   (7U)
/*! CR3INT - Interrupt Flag for Capture Channel 3 Event */
#define CTIMER_IR_CR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control */
/*! @{ */

#define CTIMER_TCR_CEN_MASK                      (0x1U)
#define CTIMER_TCR_CEN_SHIFT                     (0U)
/*! CEN - Counter Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_CEN(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)

#define CTIMER_TCR_CRST_MASK                     (0x2U)
#define CTIMER_TCR_CRST_SHIFT                    (1U)
/*! CRST - Counter Reset Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_CRST(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)

#define CTIMER_TCR_AGCEN_MASK                    (0x10U)
#define CTIMER_TCR_AGCEN_SHIFT                   (4U)
/*! AGCEN - Allow Global Count Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_AGCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_AGCEN_SHIFT)) & CTIMER_TCR_AGCEN_MASK)

#define CTIMER_TCR_ATCEN_MASK                    (0x20U)
#define CTIMER_TCR_ATCEN_SHIFT                   (5U)
/*! ATCEN - Allow Trigger Count Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_ATCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_ATCEN_SHIFT)) & CTIMER_TCR_ATCEN_MASK)
/*! @} */

/*! @name TC - Timer Counter */
/*! @{ */

#define CTIMER_TC_TCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT                    (0U)
/*! TCVAL - Timer Counter Value */
#define CTIMER_TC_TCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale */
/*! @{ */

#define CTIMER_PR_PRVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT                    (0U)
/*! PRVAL - Prescale Reload Value */
#define CTIMER_PR_PRVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter */
/*! @{ */

#define CTIMER_PC_PCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT                    (0U)
/*! PCVAL - Prescale Counter Value */
#define CTIMER_PC_PCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control */
/*! @{ */

#define CTIMER_MCR_MR0I_MASK                     (0x1U)
#define CTIMER_MCR_MR0I_SHIFT                    (0U)
/*! MR0I - Interrupt on MR0
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR0I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)

#define CTIMER_MCR_MR0R_MASK                     (0x2U)
#define CTIMER_MCR_MR0R_SHIFT                    (1U)
/*! MR0R - Reset on MR0
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR0R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)

#define CTIMER_MCR_MR0S_MASK                     (0x4U)
#define CTIMER_MCR_MR0S_SHIFT                    (2U)
/*! MR0S - Stop on MR0
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR0S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)

#define CTIMER_MCR_MR1I_MASK                     (0x8U)
#define CTIMER_MCR_MR1I_SHIFT                    (3U)
/*! MR1I - Interrupt on MR1
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR1I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)

#define CTIMER_MCR_MR1R_MASK                     (0x10U)
#define CTIMER_MCR_MR1R_SHIFT                    (4U)
/*! MR1R - Reset on MR1
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR1R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)

#define CTIMER_MCR_MR1S_MASK                     (0x20U)
#define CTIMER_MCR_MR1S_SHIFT                    (5U)
/*! MR1S - Stop on MR1
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR1S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)

#define CTIMER_MCR_MR2I_MASK                     (0x40U)
#define CTIMER_MCR_MR2I_SHIFT                    (6U)
/*! MR2I - Interrupt on MR2
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR2I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)

#define CTIMER_MCR_MR2R_MASK                     (0x80U)
#define CTIMER_MCR_MR2R_SHIFT                    (7U)
/*! MR2R - Reset on MR2
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR2R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)

#define CTIMER_MCR_MR2S_MASK                     (0x100U)
#define CTIMER_MCR_MR2S_SHIFT                    (8U)
/*! MR2S - Stop on MR2
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR2S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)

#define CTIMER_MCR_MR3I_MASK                     (0x200U)
#define CTIMER_MCR_MR3I_SHIFT                    (9U)
/*! MR3I - Interrupt on MR3
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR3I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)

#define CTIMER_MCR_MR3R_MASK                     (0x400U)
#define CTIMER_MCR_MR3R_SHIFT                    (10U)
/*! MR3R - Reset on MR3
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR3R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)

#define CTIMER_MCR_MR3S_MASK                     (0x800U)
#define CTIMER_MCR_MR3S_SHIFT                    (11U)
/*! MR3S - Stop on MR3
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR3S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)

#define CTIMER_MCR_MR0RL_MASK                    (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT                   (24U)
/*! MR0RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR0RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)

#define CTIMER_MCR_MR1RL_MASK                    (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT                   (25U)
/*! MR1RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR1RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)

#define CTIMER_MCR_MR2RL_MASK                    (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT                   (26U)
/*! MR2RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR2RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)

#define CTIMER_MCR_MR3RL_MASK                    (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT                   (27U)
/*! MR3RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR3RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match */
/*! @{ */

#define CTIMER_MR_MATCH_MASK                     (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT                    (0U)
/*! MATCH - Timer Counter Match Value */
#define CTIMER_MR_MATCH(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT                          (4U)

/*! @name CCR - Capture Control */
/*! @{ */

#define CTIMER_CCR_CAP0RE_MASK                   (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT                  (0U)
/*! CAP0RE - Rising Edge of Capture Channel 0
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP0RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)

#define CTIMER_CCR_CAP0FE_MASK                   (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT                  (1U)
/*! CAP0FE - Falling Edge of Capture Channel 0
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP0FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)

#define CTIMER_CCR_CAP0I_MASK                    (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT                   (2U)
/*! CAP0I - Generate Interrupt on Channel 0 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP0I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)

#define CTIMER_CCR_CAP1RE_MASK                   (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT                  (3U)
/*! CAP1RE - Rising Edge of Capture Channel 1
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP1RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)

#define CTIMER_CCR_CAP1FE_MASK                   (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT                  (4U)
/*! CAP1FE - Falling Edge of Capture Channel 1
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP1FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)

#define CTIMER_CCR_CAP1I_MASK                    (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT                   (5U)
/*! CAP1I - Generate Interrupt on Channel 1 Capture Event
 *  0b0..Does not generates
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP1I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)

#define CTIMER_CCR_CAP2RE_MASK                   (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT                  (6U)
/*! CAP2RE - Rising Edge of Capture Channel 2
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP2RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)

#define CTIMER_CCR_CAP2FE_MASK                   (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT                  (7U)
/*! CAP2FE - Falling Edge of Capture Channel 2
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP2FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)

#define CTIMER_CCR_CAP2I_MASK                    (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT                   (8U)
/*! CAP2I - Generate Interrupt on Channel 2 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP2I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)

#define CTIMER_CCR_CAP3RE_MASK                   (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT                  (9U)
/*! CAP3RE - Rising Edge of Capture Channel 3
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP3RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)

#define CTIMER_CCR_CAP3FE_MASK                   (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT                  (10U)
/*! CAP3FE - Falling Edge of Capture Channel 3
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP3FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)

#define CTIMER_CCR_CAP3I_MASK                    (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT                   (11U)
/*! CAP3I - Generate Interrupt on Channel 3 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP3I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture */
/*! @{ */

#define CTIMER_CR_CAP_MASK                       (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT                      (0U)
/*! CAP - Timer Counter Capture Value */
#define CTIMER_CR_CAP(x)                         (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT                          (4U)

/*! @name EMR - External Match */
/*! @{ */

#define CTIMER_EMR_EM0_MASK                      (0x1U)
#define CTIMER_EMR_EM0_SHIFT                     (0U)
/*! EM0 - External Match 0
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM0(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)

#define CTIMER_EMR_EM1_MASK                      (0x2U)
#define CTIMER_EMR_EM1_SHIFT                     (1U)
/*! EM1 - External Match 1
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM1(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)

#define CTIMER_EMR_EM2_MASK                      (0x4U)
#define CTIMER_EMR_EM2_SHIFT                     (2U)
/*! EM2 - External Match 2
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM2(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)

#define CTIMER_EMR_EM3_MASK                      (0x8U)
#define CTIMER_EMR_EM3_SHIFT                     (3U)
/*! EM3 - External Match 3
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM3(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)

#define CTIMER_EMR_EMC0_MASK                     (0x30U)
#define CTIMER_EMR_EMC0_SHIFT                    (4U)
/*! EMC0 - External Match Control 0
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC0(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)

#define CTIMER_EMR_EMC1_MASK                     (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT                    (6U)
/*! EMC1 - External Match Control 1
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC1(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)

#define CTIMER_EMR_EMC2_MASK                     (0x300U)
#define CTIMER_EMR_EMC2_SHIFT                    (8U)
/*! EMC2 - External Match Control 2
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC2(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)

#define CTIMER_EMR_EMC3_MASK                     (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT                    (10U)
/*! EMC3 - External Match Control 3
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC3(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control */
/*! @{ */

#define CTIMER_CTCR_CTMODE_MASK                  (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT                 (0U)
/*! CTMODE - Counter Timer Mode
 *  0b00..Timer mode
 *  0b01..Counter mode rising edge
 *  0b10..Counter mode falling edge
 *  0b11..Counter mode dual edge
 */
#define CTIMER_CTCR_CTMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)

#define CTIMER_CTCR_CINSEL_MASK                  (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT                 (2U)
/*! CINSEL - Count Input Select
 *  0b00..Channel 0, CAPn[0] for CTIMERn
 *  0b01..Channel 1, CAPn[1] for CTIMERn
 *  0b10..Channel 2, CAPn[2] for CTIMERn
 *  0b11..Channel 3, CAPn[3] for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)

#define CTIMER_CTCR_ENCC_MASK                    (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT                   (4U)
/*! ENCC - Capture Channel Enable */
#define CTIMER_CTCR_ENCC(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)

#define CTIMER_CTCR_SELCC_MASK                   (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT                  (5U)
/*! SELCC - Edge Select
 *  0b000..Capture channel 0 rising edge
 *  0b001..Capture channel 0 falling edge
 *  0b010..Capture channel 1 rising edge
 *  0b011..Capture channel 1 falling edge
 *  0b100..Capture channel 2 rising edge
 *  0b101..Capture channel 2 falling edge
 */
#define CTIMER_CTCR_SELCC(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control */
/*! @{ */

#define CTIMER_PWMC_PWMEN0_MASK                  (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT                 (0U)
/*! PWMEN0 - PWM Mode Enable for Channel 0
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN0(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)

#define CTIMER_PWMC_PWMEN1_MASK                  (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT                 (1U)
/*! PWMEN1 - PWM Mode Enable for Channel 1
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN1(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)

#define CTIMER_PWMC_PWMEN2_MASK                  (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT                 (2U)
/*! PWMEN2 - PWM Mode Enable for Channel 2
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN2(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)

#define CTIMER_PWMC_PWMEN3_MASK                  (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT                 (3U)
/*! PWMEN3 - PWM Mode Enable for Channel 3
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN3(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow */
/*! @{ */

#define CTIMER_MSR_MATCH_SHADOW_MASK             (0xFFFFFFFFU)
#define CTIMER_MSR_MATCH_SHADOW_SHIFT            (0U)
/*! MATCH_SHADOW - Timer Counter Match Shadow Value */
#define CTIMER_MSR_MATCH_SHADOW(x)               (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_MATCH_SHADOW_SHIFT)) & CTIMER_MSR_MATCH_SHADOW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT                         (4U)


/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */


/* CTIMER - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE                             (0x5000C000u)
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE_NS                          (0x4000C000u)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0_NS                               ((CTIMER_Type *)CTIMER0_BASE_NS)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE                             (0x5000D000u)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE_NS                          (0x4000D000u)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1_NS                               ((CTIMER_Type *)CTIMER1_BASE_NS)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE                             (0x5000E000u)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE_NS                          (0x4000E000u)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2_NS                               ((CTIMER_Type *)CTIMER2_BASE_NS)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE                             (0x5000F000u)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE_NS                          (0x4000F000u)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3_NS                               ((CTIMER_Type *)CTIMER3_BASE_NS)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE                             (0x50010000u)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE_NS                          (0x40010000u)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4_NS                               ((CTIMER_Type *)CTIMER4_BASE_NS)
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS_NS                     { CTIMER0_BASE_NS, CTIMER1_BASE_NS, CTIMER2_BASE_NS, CTIMER3_BASE_NS, CTIMER4_BASE_NS }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS_NS                      { CTIMER0_NS, CTIMER1_NS, CTIMER2_NS, CTIMER3_NS, CTIMER4_NS }
#else
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE                             (0x4000C000u)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE                             (0x4000D000u)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE                             (0x4000E000u)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE                             (0x4000F000u)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE                             (0x40010000u)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
#endif
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                              { CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DIGTMP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DIGTMP_Peripheral_Access_Layer DIGTMP Peripheral Access Layer
 * @{
 */

/** DIGTMP - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t CR;                                /**< Control, offset: 0x10 */
  __IO uint32_t SR;                                /**< Status, offset: 0x14 */
  __IO uint32_t LR;                                /**< Lock, offset: 0x18 */
  __IO uint32_t IER;                               /**< Interrupt Enable, offset: 0x1C */
  __IO uint32_t TSR;                               /**< Tamper Seconds, offset: 0x20 */
  __IO uint32_t TER;                               /**< Tamper Enable, offset: 0x24 */
  __IO uint32_t PDR;                               /**< Pin Direction, offset: 0x28 */
  __IO uint32_t PPR;                               /**< Pin Polarity, offset: 0x2C */
  __IO uint32_t ATR[2];                            /**< Active Tamper, array offset: 0x30, array step: 0x4 */
       uint8_t RESERVED_1[8];
  __IO uint32_t PGFR[8];                           /**< Pin Glitch Filter, array offset: 0x40, array step: 0x4 */
} DIGTMP_Type;

/* ----------------------------------------------------------------------------
   -- DIGTMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DIGTMP_Register_Masks DIGTMP Register Masks
 * @{
 */

/*! @name CR - Control */
/*! @{ */

#define DIGTMP_CR_SWR_MASK                       (0x1U)
#define DIGTMP_CR_SWR_SHIFT                      (0U)
/*! SWR - Software Reset
 *  0b0..No effect
 *  0b1..Perform a software reset
 */
#define DIGTMP_CR_SWR(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_SWR_SHIFT)) & DIGTMP_CR_SWR_MASK)

#define DIGTMP_CR_DEN_MASK                       (0x2U)
#define DIGTMP_CR_DEN_SHIFT                      (1U)
/*! DEN - Digital Tamper Enable
 *  0b0..Disables TDET clock and prescaler
 *  0b1..Enables TDET clock and prescaler
 */
#define DIGTMP_CR_DEN(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_DEN_SHIFT)) & DIGTMP_CR_DEN_MASK)

#define DIGTMP_CR_TFSR_MASK                      (0x4U)
#define DIGTMP_CR_TFSR_SHIFT                     (2U)
/*! TFSR - Tamper Force System Reset
 *  0b0..Do not force chip reset
 *  0b1..Force chip reset
 */
#define DIGTMP_CR_TFSR(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_TFSR_SHIFT)) & DIGTMP_CR_TFSR_MASK)

#define DIGTMP_CR_UM_MASK                        (0x8U)
#define DIGTMP_CR_UM_SHIFT                       (3U)
/*! UM - Update Mode
 *  0b0..No effect
 *  0b1..Allows the clearing of interrupts
 */
#define DIGTMP_CR_UM(x)                          (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_UM_SHIFT)) & DIGTMP_CR_UM_MASK)

#define DIGTMP_CR_ATCS0_MASK                     (0x10U)
#define DIGTMP_CR_ATCS0_SHIFT                    (4U)
/*! ATCS0 - Active Tamper Clock Source
 *  0b0..1 Hz prescaler clock
 *  0b1..64 Hz prescaler clock
 */
#define DIGTMP_CR_ATCS0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_ATCS0_SHIFT)) & DIGTMP_CR_ATCS0_MASK)

#define DIGTMP_CR_ATCS1_MASK                     (0x20U)
#define DIGTMP_CR_ATCS1_SHIFT                    (5U)
/*! ATCS1 - Active Tamper Clock Source
 *  0b0..1 Hz prescaler clock
 *  0b1..64 Hz prescaler clock
 */
#define DIGTMP_CR_ATCS1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_ATCS1_SHIFT)) & DIGTMP_CR_ATCS1_MASK)

#define DIGTMP_CR_DISTAM_MASK                    (0x100U)
#define DIGTMP_CR_DISTAM_SHIFT                   (8U)
/*! DISTAM - Disable Prescaler On Tamper
 *  0b0..No effect
 *  0b1..Automatically disables the prescaler after tamper detection
 */
#define DIGTMP_CR_DISTAM(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_DISTAM_SHIFT)) & DIGTMP_CR_DISTAM_MASK)

#define DIGTMP_CR_DPR_MASK                       (0xFFFE0000U)
#define DIGTMP_CR_DPR_SHIFT                      (17U)
/*! DPR - Digital Tamper Prescaler */
#define DIGTMP_CR_DPR(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_DPR_SHIFT)) & DIGTMP_CR_DPR_MASK)
/*! @} */

/*! @name SR - Status */
/*! @{ */

#define DIGTMP_SR_DTF_MASK                       (0x1U)
#define DIGTMP_SR_DTF_SHIFT                      (0U)
/*! DTF - Digital Tamper Flag
 *  0b0..TDET tampering not detected
 *  0b1..TDET tampering detected
 */
#define DIGTMP_SR_DTF(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_DTF_SHIFT)) & DIGTMP_SR_DTF_MASK)

#define DIGTMP_SR_TAF_MASK                       (0x2U)
#define DIGTMP_SR_TAF_SHIFT                      (1U)
/*! TAF - Tamper Acknowledge Flag
 *  0b0..Digital Tamper Flag (SR[DTF]) is clear or chip reset has not occurred after Digital Tamper Flag (SR[DTF]) was set.
 *  0b1..Chip reset has occurred after Digital Tamper Flag (SR[DTF]) was set.
 */
#define DIGTMP_SR_TAF(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TAF_SHIFT)) & DIGTMP_SR_TAF_MASK)

#define DIGTMP_SR_TIF0_MASK                      (0x4U)
#define DIGTMP_SR_TIF0_SHIFT                     (2U)
/*! TIF0 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF0(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF0_SHIFT)) & DIGTMP_SR_TIF0_MASK)

#define DIGTMP_SR_TIF1_MASK                      (0x8U)
#define DIGTMP_SR_TIF1_SHIFT                     (3U)
/*! TIF1 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF1(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF1_SHIFT)) & DIGTMP_SR_TIF1_MASK)

#define DIGTMP_SR_TIF2_MASK                      (0x10U)
#define DIGTMP_SR_TIF2_SHIFT                     (4U)
/*! TIF2 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF2(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF2_SHIFT)) & DIGTMP_SR_TIF2_MASK)

#define DIGTMP_SR_TIF3_MASK                      (0x20U)
#define DIGTMP_SR_TIF3_SHIFT                     (5U)
/*! TIF3 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF3(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF3_SHIFT)) & DIGTMP_SR_TIF3_MASK)

#define DIGTMP_SR_TIF4_MASK                      (0x40U)
#define DIGTMP_SR_TIF4_SHIFT                     (6U)
/*! TIF4 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF4(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF4_SHIFT)) & DIGTMP_SR_TIF4_MASK)

#define DIGTMP_SR_TIF5_MASK                      (0x80U)
#define DIGTMP_SR_TIF5_SHIFT                     (7U)
/*! TIF5 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF5(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF5_SHIFT)) & DIGTMP_SR_TIF5_MASK)

#define DIGTMP_SR_TIF6_MASK                      (0x100U)
#define DIGTMP_SR_TIF6_SHIFT                     (8U)
/*! TIF6 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF6(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF6_SHIFT)) & DIGTMP_SR_TIF6_MASK)

#define DIGTMP_SR_TIF7_MASK                      (0x200U)
#define DIGTMP_SR_TIF7_SHIFT                     (9U)
/*! TIF7 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF7(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF7_SHIFT)) & DIGTMP_SR_TIF7_MASK)

#define DIGTMP_SR_TIF8_MASK                      (0x400U)
#define DIGTMP_SR_TIF8_SHIFT                     (10U)
/*! TIF8 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF8(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF8_SHIFT)) & DIGTMP_SR_TIF8_MASK)

#define DIGTMP_SR_TIF9_MASK                      (0x800U)
#define DIGTMP_SR_TIF9_SHIFT                     (11U)
/*! TIF9 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF9(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF9_SHIFT)) & DIGTMP_SR_TIF9_MASK)

#define DIGTMP_SR_TPF0_MASK                      (0x10000U)
#define DIGTMP_SR_TPF0_SHIFT                     (16U)
/*! TPF0 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF0(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF0_SHIFT)) & DIGTMP_SR_TPF0_MASK)

#define DIGTMP_SR_TPF1_MASK                      (0x20000U)
#define DIGTMP_SR_TPF1_SHIFT                     (17U)
/*! TPF1 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF1(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF1_SHIFT)) & DIGTMP_SR_TPF1_MASK)

#define DIGTMP_SR_TPF2_MASK                      (0x40000U)
#define DIGTMP_SR_TPF2_SHIFT                     (18U)
/*! TPF2 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF2(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF2_SHIFT)) & DIGTMP_SR_TPF2_MASK)

#define DIGTMP_SR_TPF3_MASK                      (0x80000U)
#define DIGTMP_SR_TPF3_SHIFT                     (19U)
/*! TPF3 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF3(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF3_SHIFT)) & DIGTMP_SR_TPF3_MASK)

#define DIGTMP_SR_TPF4_MASK                      (0x100000U)
#define DIGTMP_SR_TPF4_SHIFT                     (20U)
/*! TPF4 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF4(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF4_SHIFT)) & DIGTMP_SR_TPF4_MASK)

#define DIGTMP_SR_TPF5_MASK                      (0x200000U)
#define DIGTMP_SR_TPF5_SHIFT                     (21U)
/*! TPF5 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF5(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF5_SHIFT)) & DIGTMP_SR_TPF5_MASK)

#define DIGTMP_SR_TPF6_MASK                      (0x400000U)
#define DIGTMP_SR_TPF6_SHIFT                     (22U)
/*! TPF6 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF6(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF6_SHIFT)) & DIGTMP_SR_TPF6_MASK)

#define DIGTMP_SR_TPF7_MASK                      (0x800000U)
#define DIGTMP_SR_TPF7_SHIFT                     (23U)
/*! TPF7 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF7(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF7_SHIFT)) & DIGTMP_SR_TPF7_MASK)
/*! @} */

/*! @name LR - Lock */
/*! @{ */

#define DIGTMP_LR_CRL_MASK                       (0x10U)
#define DIGTMP_LR_CRL_SHIFT                      (4U)
/*! CRL - Control Register Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_CRL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_CRL_SHIFT)) & DIGTMP_LR_CRL_MASK)

#define DIGTMP_LR_SRL_MASK                       (0x20U)
#define DIGTMP_LR_SRL_SHIFT                      (5U)
/*! SRL - Status Register Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_SRL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_SRL_SHIFT)) & DIGTMP_LR_SRL_MASK)

#define DIGTMP_LR_LRL_MASK                       (0x40U)
#define DIGTMP_LR_LRL_SHIFT                      (6U)
/*! LRL - Lock Register Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_LRL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_LRL_SHIFT)) & DIGTMP_LR_LRL_MASK)

#define DIGTMP_LR_IEL_MASK                       (0x80U)
#define DIGTMP_LR_IEL_SHIFT                      (7U)
/*! IEL - Interrupt Enable Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_IEL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_IEL_SHIFT)) & DIGTMP_LR_IEL_MASK)

#define DIGTMP_LR_TSL_MASK                       (0x100U)
#define DIGTMP_LR_TSL_SHIFT                      (8U)
/*! TSL - Tamper Seconds Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_TSL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_TSL_SHIFT)) & DIGTMP_LR_TSL_MASK)

#define DIGTMP_LR_TEL_MASK                       (0x200U)
#define DIGTMP_LR_TEL_SHIFT                      (9U)
/*! TEL - Tamper Enable Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_TEL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_TEL_SHIFT)) & DIGTMP_LR_TEL_MASK)

#define DIGTMP_LR_PDL_MASK                       (0x400U)
#define DIGTMP_LR_PDL_SHIFT                      (10U)
/*! PDL - Pin Direction Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_PDL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_PDL_SHIFT)) & DIGTMP_LR_PDL_MASK)

#define DIGTMP_LR_PPL_MASK                       (0x800U)
#define DIGTMP_LR_PPL_SHIFT                      (11U)
/*! PPL - Pin Polarity Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_PPL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_PPL_SHIFT)) & DIGTMP_LR_PPL_MASK)

#define DIGTMP_LR_ATL0_MASK                      (0x1000U)
#define DIGTMP_LR_ATL0_SHIFT                     (12U)
/*! ATL0 - Active Tamper Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_ATL0(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_ATL0_SHIFT)) & DIGTMP_LR_ATL0_MASK)

#define DIGTMP_LR_ATL1_MASK                      (0x2000U)
#define DIGTMP_LR_ATL1_SHIFT                     (13U)
/*! ATL1 - Active Tamper Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_ATL1(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_ATL1_SHIFT)) & DIGTMP_LR_ATL1_MASK)

#define DIGTMP_LR_GFL0_MASK                      (0x10000U)
#define DIGTMP_LR_GFL0_SHIFT                     (16U)
/*! GFL0 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL0(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL0_SHIFT)) & DIGTMP_LR_GFL0_MASK)

#define DIGTMP_LR_GFL1_MASK                      (0x20000U)
#define DIGTMP_LR_GFL1_SHIFT                     (17U)
/*! GFL1 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL1(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL1_SHIFT)) & DIGTMP_LR_GFL1_MASK)

#define DIGTMP_LR_GFL2_MASK                      (0x40000U)
#define DIGTMP_LR_GFL2_SHIFT                     (18U)
/*! GFL2 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL2(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL2_SHIFT)) & DIGTMP_LR_GFL2_MASK)

#define DIGTMP_LR_GFL3_MASK                      (0x80000U)
#define DIGTMP_LR_GFL3_SHIFT                     (19U)
/*! GFL3 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL3(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL3_SHIFT)) & DIGTMP_LR_GFL3_MASK)

#define DIGTMP_LR_GFL4_MASK                      (0x100000U)
#define DIGTMP_LR_GFL4_SHIFT                     (20U)
/*! GFL4 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL4(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL4_SHIFT)) & DIGTMP_LR_GFL4_MASK)

#define DIGTMP_LR_GFL5_MASK                      (0x200000U)
#define DIGTMP_LR_GFL5_SHIFT                     (21U)
/*! GFL5 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL5(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL5_SHIFT)) & DIGTMP_LR_GFL5_MASK)

#define DIGTMP_LR_GFL6_MASK                      (0x400000U)
#define DIGTMP_LR_GFL6_SHIFT                     (22U)
/*! GFL6 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL6(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL6_SHIFT)) & DIGTMP_LR_GFL6_MASK)

#define DIGTMP_LR_GFL7_MASK                      (0x800000U)
#define DIGTMP_LR_GFL7_SHIFT                     (23U)
/*! GFL7 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL7(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL7_SHIFT)) & DIGTMP_LR_GFL7_MASK)
/*! @} */

/*! @name IER - Interrupt Enable */
/*! @{ */

#define DIGTMP_IER_DTIE_MASK                     (0x1U)
#define DIGTMP_IER_DTIE_SHIFT                    (0U)
/*! DTIE - Digital Tamper Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_DTIE(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_DTIE_SHIFT)) & DIGTMP_IER_DTIE_MASK)

#define DIGTMP_IER_TIIE0_MASK                    (0x4U)
#define DIGTMP_IER_TIIE0_SHIFT                   (2U)
/*! TIIE0 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE0(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE0_SHIFT)) & DIGTMP_IER_TIIE0_MASK)

#define DIGTMP_IER_TIIE1_MASK                    (0x8U)
#define DIGTMP_IER_TIIE1_SHIFT                   (3U)
/*! TIIE1 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE1(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE1_SHIFT)) & DIGTMP_IER_TIIE1_MASK)

#define DIGTMP_IER_TIIE2_MASK                    (0x10U)
#define DIGTMP_IER_TIIE2_SHIFT                   (4U)
/*! TIIE2 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE2(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE2_SHIFT)) & DIGTMP_IER_TIIE2_MASK)

#define DIGTMP_IER_TIIE3_MASK                    (0x20U)
#define DIGTMP_IER_TIIE3_SHIFT                   (5U)
/*! TIIE3 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE3(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE3_SHIFT)) & DIGTMP_IER_TIIE3_MASK)

#define DIGTMP_IER_TIIE4_MASK                    (0x40U)
#define DIGTMP_IER_TIIE4_SHIFT                   (6U)
/*! TIIE4 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE4(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE4_SHIFT)) & DIGTMP_IER_TIIE4_MASK)

#define DIGTMP_IER_TIIE5_MASK                    (0x80U)
#define DIGTMP_IER_TIIE5_SHIFT                   (7U)
/*! TIIE5 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE5(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE5_SHIFT)) & DIGTMP_IER_TIIE5_MASK)

#define DIGTMP_IER_TIIE6_MASK                    (0x100U)
#define DIGTMP_IER_TIIE6_SHIFT                   (8U)
/*! TIIE6 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE6(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE6_SHIFT)) & DIGTMP_IER_TIIE6_MASK)

#define DIGTMP_IER_TIIE7_MASK                    (0x200U)
#define DIGTMP_IER_TIIE7_SHIFT                   (9U)
/*! TIIE7 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE7(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE7_SHIFT)) & DIGTMP_IER_TIIE7_MASK)

#define DIGTMP_IER_TIIE8_MASK                    (0x400U)
#define DIGTMP_IER_TIIE8_SHIFT                   (10U)
/*! TIIE8 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE8(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE8_SHIFT)) & DIGTMP_IER_TIIE8_MASK)

#define DIGTMP_IER_TIIE9_MASK                    (0x800U)
#define DIGTMP_IER_TIIE9_SHIFT                   (11U)
/*! TIIE9 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE9(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE9_SHIFT)) & DIGTMP_IER_TIIE9_MASK)

#define DIGTMP_IER_TPIE0_MASK                    (0x10000U)
#define DIGTMP_IER_TPIE0_SHIFT                   (16U)
/*! TPIE0 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE0(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE0_SHIFT)) & DIGTMP_IER_TPIE0_MASK)

#define DIGTMP_IER_TPIE1_MASK                    (0x20000U)
#define DIGTMP_IER_TPIE1_SHIFT                   (17U)
/*! TPIE1 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE1(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE1_SHIFT)) & DIGTMP_IER_TPIE1_MASK)

#define DIGTMP_IER_TPIE2_MASK                    (0x40000U)
#define DIGTMP_IER_TPIE2_SHIFT                   (18U)
/*! TPIE2 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE2(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE2_SHIFT)) & DIGTMP_IER_TPIE2_MASK)

#define DIGTMP_IER_TPIE3_MASK                    (0x80000U)
#define DIGTMP_IER_TPIE3_SHIFT                   (19U)
/*! TPIE3 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE3(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE3_SHIFT)) & DIGTMP_IER_TPIE3_MASK)

#define DIGTMP_IER_TPIE4_MASK                    (0x100000U)
#define DIGTMP_IER_TPIE4_SHIFT                   (20U)
/*! TPIE4 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE4(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE4_SHIFT)) & DIGTMP_IER_TPIE4_MASK)

#define DIGTMP_IER_TPIE5_MASK                    (0x200000U)
#define DIGTMP_IER_TPIE5_SHIFT                   (21U)
/*! TPIE5 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE5(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE5_SHIFT)) & DIGTMP_IER_TPIE5_MASK)

#define DIGTMP_IER_TPIE6_MASK                    (0x400000U)
#define DIGTMP_IER_TPIE6_SHIFT                   (22U)
/*! TPIE6 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE6(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE6_SHIFT)) & DIGTMP_IER_TPIE6_MASK)

#define DIGTMP_IER_TPIE7_MASK                    (0x800000U)
#define DIGTMP_IER_TPIE7_SHIFT                   (23U)
/*! TPIE7 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE7(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE7_SHIFT)) & DIGTMP_IER_TPIE7_MASK)
/*! @} */

/*! @name TSR - Tamper Seconds */
/*! @{ */

#define DIGTMP_TSR_TTS_MASK                      (0xFFFFFFFFU)
#define DIGTMP_TSR_TTS_SHIFT                     (0U)
/*! TTS - Tamper Time Seconds */
#define DIGTMP_TSR_TTS(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_TSR_TTS_SHIFT)) & DIGTMP_TSR_TTS_MASK)
/*! @} */

/*! @name TER - Tamper Enable */
/*! @{ */

#define DIGTMP_TER_TIE0_MASK                     (0x4U)
#define DIGTMP_TER_TIE0_SHIFT                    (2U)
/*! TIE0 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE0_SHIFT)) & DIGTMP_TER_TIE0_MASK)

#define DIGTMP_TER_TIE1_MASK                     (0x8U)
#define DIGTMP_TER_TIE1_SHIFT                    (3U)
/*! TIE1 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE1_SHIFT)) & DIGTMP_TER_TIE1_MASK)

#define DIGTMP_TER_TIE2_MASK                     (0x10U)
#define DIGTMP_TER_TIE2_SHIFT                    (4U)
/*! TIE2 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE2(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE2_SHIFT)) & DIGTMP_TER_TIE2_MASK)

#define DIGTMP_TER_TIE3_MASK                     (0x20U)
#define DIGTMP_TER_TIE3_SHIFT                    (5U)
/*! TIE3 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE3(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE3_SHIFT)) & DIGTMP_TER_TIE3_MASK)

#define DIGTMP_TER_TIE4_MASK                     (0x40U)
#define DIGTMP_TER_TIE4_SHIFT                    (6U)
/*! TIE4 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE4(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE4_SHIFT)) & DIGTMP_TER_TIE4_MASK)

#define DIGTMP_TER_TIE5_MASK                     (0x80U)
#define DIGTMP_TER_TIE5_SHIFT                    (7U)
/*! TIE5 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE5(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE5_SHIFT)) & DIGTMP_TER_TIE5_MASK)

#define DIGTMP_TER_TIE6_MASK                     (0x100U)
#define DIGTMP_TER_TIE6_SHIFT                    (8U)
/*! TIE6 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE6(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE6_SHIFT)) & DIGTMP_TER_TIE6_MASK)

#define DIGTMP_TER_TIE7_MASK                     (0x200U)
#define DIGTMP_TER_TIE7_SHIFT                    (9U)
/*! TIE7 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE7(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE7_SHIFT)) & DIGTMP_TER_TIE7_MASK)

#define DIGTMP_TER_TIE8_MASK                     (0x400U)
#define DIGTMP_TER_TIE8_SHIFT                    (10U)
/*! TIE8 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE8(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE8_SHIFT)) & DIGTMP_TER_TIE8_MASK)

#define DIGTMP_TER_TIE9_MASK                     (0x800U)
#define DIGTMP_TER_TIE9_SHIFT                    (11U)
/*! TIE9 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE9(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE9_SHIFT)) & DIGTMP_TER_TIE9_MASK)

#define DIGTMP_TER_TPE0_MASK                     (0x10000U)
#define DIGTMP_TER_TPE0_SHIFT                    (16U)
/*! TPE0 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE0_SHIFT)) & DIGTMP_TER_TPE0_MASK)

#define DIGTMP_TER_TPE1_MASK                     (0x20000U)
#define DIGTMP_TER_TPE1_SHIFT                    (17U)
/*! TPE1 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE1_SHIFT)) & DIGTMP_TER_TPE1_MASK)

#define DIGTMP_TER_TPE2_MASK                     (0x40000U)
#define DIGTMP_TER_TPE2_SHIFT                    (18U)
/*! TPE2 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE2(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE2_SHIFT)) & DIGTMP_TER_TPE2_MASK)

#define DIGTMP_TER_TPE3_MASK                     (0x80000U)
#define DIGTMP_TER_TPE3_SHIFT                    (19U)
/*! TPE3 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE3(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE3_SHIFT)) & DIGTMP_TER_TPE3_MASK)

#define DIGTMP_TER_TPE4_MASK                     (0x100000U)
#define DIGTMP_TER_TPE4_SHIFT                    (20U)
/*! TPE4 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE4(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE4_SHIFT)) & DIGTMP_TER_TPE4_MASK)

#define DIGTMP_TER_TPE5_MASK                     (0x200000U)
#define DIGTMP_TER_TPE5_SHIFT                    (21U)
/*! TPE5 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE5(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE5_SHIFT)) & DIGTMP_TER_TPE5_MASK)

#define DIGTMP_TER_TPE6_MASK                     (0x400000U)
#define DIGTMP_TER_TPE6_SHIFT                    (22U)
/*! TPE6 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE6(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE6_SHIFT)) & DIGTMP_TER_TPE6_MASK)

#define DIGTMP_TER_TPE7_MASK                     (0x800000U)
#define DIGTMP_TER_TPE7_SHIFT                    (23U)
/*! TPE7 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE7(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE7_SHIFT)) & DIGTMP_TER_TPE7_MASK)
/*! @} */

/*! @name PDR - Pin Direction */
/*! @{ */

#define DIGTMP_PDR_TPD0_MASK                     (0x1U)
#define DIGTMP_PDR_TPD0_SHIFT                    (0U)
/*! TPD0 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD0_SHIFT)) & DIGTMP_PDR_TPD0_MASK)

#define DIGTMP_PDR_TPD1_MASK                     (0x2U)
#define DIGTMP_PDR_TPD1_SHIFT                    (1U)
/*! TPD1 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD1_SHIFT)) & DIGTMP_PDR_TPD1_MASK)

#define DIGTMP_PDR_TPD2_MASK                     (0x4U)
#define DIGTMP_PDR_TPD2_SHIFT                    (2U)
/*! TPD2 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD2(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD2_SHIFT)) & DIGTMP_PDR_TPD2_MASK)

#define DIGTMP_PDR_TPD3_MASK                     (0x8U)
#define DIGTMP_PDR_TPD3_SHIFT                    (3U)
/*! TPD3 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD3(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD3_SHIFT)) & DIGTMP_PDR_TPD3_MASK)

#define DIGTMP_PDR_TPD4_MASK                     (0x10U)
#define DIGTMP_PDR_TPD4_SHIFT                    (4U)
/*! TPD4 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD4(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD4_SHIFT)) & DIGTMP_PDR_TPD4_MASK)

#define DIGTMP_PDR_TPD5_MASK                     (0x20U)
#define DIGTMP_PDR_TPD5_SHIFT                    (5U)
/*! TPD5 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD5(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD5_SHIFT)) & DIGTMP_PDR_TPD5_MASK)

#define DIGTMP_PDR_TPD6_MASK                     (0x40U)
#define DIGTMP_PDR_TPD6_SHIFT                    (6U)
/*! TPD6 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD6(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD6_SHIFT)) & DIGTMP_PDR_TPD6_MASK)

#define DIGTMP_PDR_TPD7_MASK                     (0x80U)
#define DIGTMP_PDR_TPD7_SHIFT                    (7U)
/*! TPD7 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD7(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD7_SHIFT)) & DIGTMP_PDR_TPD7_MASK)

#define DIGTMP_PDR_TPOD0_MASK                    (0x10000U)
#define DIGTMP_PDR_TPOD0_SHIFT                   (16U)
/*! TPOD0 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD0(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD0_SHIFT)) & DIGTMP_PDR_TPOD0_MASK)

#define DIGTMP_PDR_TPOD1_MASK                    (0x20000U)
#define DIGTMP_PDR_TPOD1_SHIFT                   (17U)
/*! TPOD1 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD1(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD1_SHIFT)) & DIGTMP_PDR_TPOD1_MASK)

#define DIGTMP_PDR_TPOD2_MASK                    (0x40000U)
#define DIGTMP_PDR_TPOD2_SHIFT                   (18U)
/*! TPOD2 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD2(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD2_SHIFT)) & DIGTMP_PDR_TPOD2_MASK)

#define DIGTMP_PDR_TPOD3_MASK                    (0x80000U)
#define DIGTMP_PDR_TPOD3_SHIFT                   (19U)
/*! TPOD3 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD3(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD3_SHIFT)) & DIGTMP_PDR_TPOD3_MASK)

#define DIGTMP_PDR_TPOD4_MASK                    (0x100000U)
#define DIGTMP_PDR_TPOD4_SHIFT                   (20U)
/*! TPOD4 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD4(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD4_SHIFT)) & DIGTMP_PDR_TPOD4_MASK)

#define DIGTMP_PDR_TPOD5_MASK                    (0x200000U)
#define DIGTMP_PDR_TPOD5_SHIFT                   (21U)
/*! TPOD5 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD5(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD5_SHIFT)) & DIGTMP_PDR_TPOD5_MASK)

#define DIGTMP_PDR_TPOD6_MASK                    (0x400000U)
#define DIGTMP_PDR_TPOD6_SHIFT                   (22U)
/*! TPOD6 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD6(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD6_SHIFT)) & DIGTMP_PDR_TPOD6_MASK)

#define DIGTMP_PDR_TPOD7_MASK                    (0x800000U)
#define DIGTMP_PDR_TPOD7_SHIFT                   (23U)
/*! TPOD7 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD7(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD7_SHIFT)) & DIGTMP_PDR_TPOD7_MASK)
/*! @} */

/*! @name PPR - Pin Polarity */
/*! @{ */

#define DIGTMP_PPR_TPP0_MASK                     (0x1U)
#define DIGTMP_PPR_TPP0_SHIFT                    (0U)
/*! TPP0 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP0_SHIFT)) & DIGTMP_PPR_TPP0_MASK)

#define DIGTMP_PPR_TPP1_MASK                     (0x2U)
#define DIGTMP_PPR_TPP1_SHIFT                    (1U)
/*! TPP1 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP1_SHIFT)) & DIGTMP_PPR_TPP1_MASK)

#define DIGTMP_PPR_TPP2_MASK                     (0x4U)
#define DIGTMP_PPR_TPP2_SHIFT                    (2U)
/*! TPP2 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP2(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP2_SHIFT)) & DIGTMP_PPR_TPP2_MASK)

#define DIGTMP_PPR_TPP3_MASK                     (0x8U)
#define DIGTMP_PPR_TPP3_SHIFT                    (3U)
/*! TPP3 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP3(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP3_SHIFT)) & DIGTMP_PPR_TPP3_MASK)

#define DIGTMP_PPR_TPP4_MASK                     (0x10U)
#define DIGTMP_PPR_TPP4_SHIFT                    (4U)
/*! TPP4 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP4(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP4_SHIFT)) & DIGTMP_PPR_TPP4_MASK)

#define DIGTMP_PPR_TPP5_MASK                     (0x20U)
#define DIGTMP_PPR_TPP5_SHIFT                    (5U)
/*! TPP5 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP5(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP5_SHIFT)) & DIGTMP_PPR_TPP5_MASK)

#define DIGTMP_PPR_TPP6_MASK                     (0x40U)
#define DIGTMP_PPR_TPP6_SHIFT                    (6U)
/*! TPP6 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP6(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP6_SHIFT)) & DIGTMP_PPR_TPP6_MASK)

#define DIGTMP_PPR_TPP7_MASK                     (0x80U)
#define DIGTMP_PPR_TPP7_SHIFT                    (7U)
/*! TPP7 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP7(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP7_SHIFT)) & DIGTMP_PPR_TPP7_MASK)

#define DIGTMP_PPR_TPID0_MASK                    (0x10000U)
#define DIGTMP_PPR_TPID0_SHIFT                   (16U)
/*! TPID0 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID0(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID0_SHIFT)) & DIGTMP_PPR_TPID0_MASK)

#define DIGTMP_PPR_TPID1_MASK                    (0x20000U)
#define DIGTMP_PPR_TPID1_SHIFT                   (17U)
/*! TPID1 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID1(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID1_SHIFT)) & DIGTMP_PPR_TPID1_MASK)

#define DIGTMP_PPR_TPID2_MASK                    (0x40000U)
#define DIGTMP_PPR_TPID2_SHIFT                   (18U)
/*! TPID2 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID2(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID2_SHIFT)) & DIGTMP_PPR_TPID2_MASK)

#define DIGTMP_PPR_TPID3_MASK                    (0x80000U)
#define DIGTMP_PPR_TPID3_SHIFT                   (19U)
/*! TPID3 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID3(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID3_SHIFT)) & DIGTMP_PPR_TPID3_MASK)

#define DIGTMP_PPR_TPID4_MASK                    (0x100000U)
#define DIGTMP_PPR_TPID4_SHIFT                   (20U)
/*! TPID4 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID4(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID4_SHIFT)) & DIGTMP_PPR_TPID4_MASK)

#define DIGTMP_PPR_TPID5_MASK                    (0x200000U)
#define DIGTMP_PPR_TPID5_SHIFT                   (21U)
/*! TPID5 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID5(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID5_SHIFT)) & DIGTMP_PPR_TPID5_MASK)

#define DIGTMP_PPR_TPID6_MASK                    (0x400000U)
#define DIGTMP_PPR_TPID6_SHIFT                   (22U)
/*! TPID6 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID6(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID6_SHIFT)) & DIGTMP_PPR_TPID6_MASK)

#define DIGTMP_PPR_TPID7_MASK                    (0x800000U)
#define DIGTMP_PPR_TPID7_SHIFT                   (23U)
/*! TPID7 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID7(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID7_SHIFT)) & DIGTMP_PPR_TPID7_MASK)
/*! @} */

/*! @name ATR - Active Tamper */
/*! @{ */

#define DIGTMP_ATR_ATSR_MASK                     (0xFFFFU)
#define DIGTMP_ATR_ATSR_SHIFT                    (0U)
/*! ATSR - Active Tamper Shift Register */
#define DIGTMP_ATR_ATSR(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_ATR_ATSR_SHIFT)) & DIGTMP_ATR_ATSR_MASK)

#define DIGTMP_ATR_ATP_MASK                      (0xFFFF0000U)
#define DIGTMP_ATR_ATP_SHIFT                     (16U)
/*! ATP - Active Tamper Polynomial */
#define DIGTMP_ATR_ATP(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_ATR_ATP_SHIFT)) & DIGTMP_ATR_ATP_MASK)
/*! @} */

/* The count of DIGTMP_ATR */
#define DIGTMP_ATR_COUNT                         (2U)

/*! @name PGFR - Pin Glitch Filter */
/*! @{ */

#define DIGTMP_PGFR_GFW_MASK                     (0x3FU)
#define DIGTMP_PGFR_GFW_SHIFT                    (0U)
/*! GFW - Glitch Filter Width */
#define DIGTMP_PGFR_GFW(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_GFW_SHIFT)) & DIGTMP_PGFR_GFW_MASK)

#define DIGTMP_PGFR_GFP_MASK                     (0x40U)
#define DIGTMP_PGFR_GFP_SHIFT                    (6U)
/*! GFP - Glitch Filter Prescaler
 *  0b0..512 Hz prescaler clock
 *  0b1..32.768 kHz clock
 */
#define DIGTMP_PGFR_GFP(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_GFP_SHIFT)) & DIGTMP_PGFR_GFP_MASK)

#define DIGTMP_PGFR_GFE_MASK                     (0x80U)
#define DIGTMP_PGFR_GFE_SHIFT                    (7U)
/*! GFE - Glitch Filter Enable
 *  0b0..Bypasses
 *  0b1..Enables
 */
#define DIGTMP_PGFR_GFE(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_GFE_SHIFT)) & DIGTMP_PGFR_GFE_MASK)

#define DIGTMP_PGFR_TPSW_MASK                    (0x300U)
#define DIGTMP_PGFR_TPSW_SHIFT                   (8U)
/*! TPSW - Tamper Pin Sample Width
 *  0b00..Continuous monitoring, pin sampling disabled
 *  0b01..2 cycles for pull enable and 1 cycle for input buffer enable
 *  0b10..4 cycles for pull enable and 2 cycles for input buffer enable
 *  0b11..8 cycles for pull enable and 4 cycles for input buffer enable
 */
#define DIGTMP_PGFR_TPSW(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPSW_SHIFT)) & DIGTMP_PGFR_TPSW_MASK)

#define DIGTMP_PGFR_TPSF_MASK                    (0xC00U)
#define DIGTMP_PGFR_TPSF_SHIFT                   (10U)
/*! TPSF - Tamper Pin Sample Frequency
 *  0b00..Every 8 cycles
 *  0b01..Every 32 cycles
 *  0b10..Every 128 cycles
 *  0b11..Every 512 cycles
 */
#define DIGTMP_PGFR_TPSF(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPSF_SHIFT)) & DIGTMP_PGFR_TPSF_MASK)

#define DIGTMP_PGFR_TPEX_MASK                    (0x30000U)
#define DIGTMP_PGFR_TPEX_SHIFT                   (16U)
/*! TPEX - Tamper Pin Expected
 *  0b00..Zero/passive tamper
 *  0b01..Active Tamper 0 output
 *  0b10..Active Tamper 1 output
 *  0b11..Active Tamper 0 output XORed with Active Tamper 1 output
 */
#define DIGTMP_PGFR_TPEX(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPEX_SHIFT)) & DIGTMP_PGFR_TPEX_MASK)

#define DIGTMP_PGFR_TPE_MASK                     (0x1000000U)
#define DIGTMP_PGFR_TPE_SHIFT                    (24U)
/*! TPE - Tamper Pull Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_PGFR_TPE(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPE_SHIFT)) & DIGTMP_PGFR_TPE_MASK)

#define DIGTMP_PGFR_TPS_MASK                     (0x2000000U)
#define DIGTMP_PGFR_TPS_SHIFT                    (25U)
/*! TPS - Tamper Pull Select
 *  0b0..Asserts
 *  0b1..Negates
 */
#define DIGTMP_PGFR_TPS(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPS_SHIFT)) & DIGTMP_PGFR_TPS_MASK)
/*! @} */

/* The count of DIGTMP_PGFR */
#define DIGTMP_PGFR_COUNT                        (8U)


/*!
 * @}
 */ /* end of group DIGTMP_Register_Masks */


/* DIGTMP - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral TDET0 base address */
  #define TDET0_BASE                               (0x50058000u)
  /** Peripheral TDET0 base address */
  #define TDET0_BASE_NS                            (0x40058000u)
  /** Peripheral TDET0 base pointer */
  #define TDET0                                    ((DIGTMP_Type *)TDET0_BASE)
  /** Peripheral TDET0 base pointer */
  #define TDET0_NS                                 ((DIGTMP_Type *)TDET0_BASE_NS)
  /** Array initializer of DIGTMP peripheral base addresses */
  #define DIGTMP_BASE_ADDRS                        { TDET0_BASE }
  /** Array initializer of DIGTMP peripheral base pointers */
  #define DIGTMP_BASE_PTRS                         { TDET0 }
  /** Array initializer of DIGTMP peripheral base addresses */
  #define DIGTMP_BASE_ADDRS_NS                     { TDET0_BASE_NS }
  /** Array initializer of DIGTMP peripheral base pointers */
  #define DIGTMP_BASE_PTRS_NS                      { TDET0_NS }
#else
  /** Peripheral TDET0 base address */
  #define TDET0_BASE                               (0x40058000u)
  /** Peripheral TDET0 base pointer */
  #define TDET0                                    ((DIGTMP_Type *)TDET0_BASE)
  /** Array initializer of DIGTMP peripheral base addresses */
  #define DIGTMP_BASE_ADDRS                        { TDET0_BASE }
  /** Array initializer of DIGTMP peripheral base pointers */
  #define DIGTMP_BASE_PTRS                         { TDET0 }
#endif

/*!
 * @}
 */ /* end of group DIGTMP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DM_Peripheral_Access_Layer DM Peripheral Access Layer
 * @{
 */

/** DM - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSW;                               /**< Command and Status Word, offset: 0x0 */
  __IO uint32_t REQUEST;                           /**< Request Value, offset: 0x4 */
  __IO uint32_t RETURN;                            /**< Return Value, offset: 0x8 */
       uint8_t RESERVED_0[240];
  __I  uint32_t ID;                                /**< Identification, offset: 0xFC */
} DM_Type;

/* ----------------------------------------------------------------------------
   -- DM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DM_Register_Masks DM Register Masks
 * @{
 */

/*! @name CSW - Command and Status Word */
/*! @{ */

#define DM_CSW_RESYNCH_REQ_MASK                  (0x1U)
#define DM_CSW_RESYNCH_REQ_SHIFT                 (0U)
/*! RESYNCH_REQ - Resynchronization Request
 *  0b0..No request
 *  0b1..Request for resynchronization
 */
#define DM_CSW_RESYNCH_REQ(x)                    (((uint32_t)(((uint32_t)(x)) << DM_CSW_RESYNCH_REQ_SHIFT)) & DM_CSW_RESYNCH_REQ_MASK)

#define DM_CSW_REQ_PENDING_MASK                  (0x2U)
#define DM_CSW_REQ_PENDING_SHIFT                 (1U)
/*! REQ_PENDING - Request Pending
 *  0b0..No request pending
 *  0b1..Request for resynchronization pending
 */
#define DM_CSW_REQ_PENDING(x)                    (((uint32_t)(((uint32_t)(x)) << DM_CSW_REQ_PENDING_SHIFT)) & DM_CSW_REQ_PENDING_MASK)

#define DM_CSW_DBG_OR_ERR_MASK                   (0x4U)
#define DM_CSW_DBG_OR_ERR_SHIFT                  (2U)
/*! DBG_OR_ERR - DBGMB Overrun Error
 *  0b0..No DBGMB Overrun error
 *  0b1..DBGMB overrun error. A DBGMB overrun occurred.
 */
#define DM_CSW_DBG_OR_ERR(x)                     (((uint32_t)(((uint32_t)(x)) << DM_CSW_DBG_OR_ERR_SHIFT)) & DM_CSW_DBG_OR_ERR_MASK)

#define DM_CSW_AHB_OR_ERR_MASK                   (0x8U)
#define DM_CSW_AHB_OR_ERR_SHIFT                  (3U)
/*! AHB_OR_ERR - AHB Overrun Error
 *  0b0..No AHB Overrun Error
 *  0b1..AHB Overrun Error. An AHB overrun occurred.
 */
#define DM_CSW_AHB_OR_ERR(x)                     (((uint32_t)(((uint32_t)(x)) << DM_CSW_AHB_OR_ERR_SHIFT)) & DM_CSW_AHB_OR_ERR_MASK)

#define DM_CSW_SOFT_RESET_MASK                   (0x10U)
#define DM_CSW_SOFT_RESET_SHIFT                  (4U)
/*! SOFT_RESET - Soft Reset */
#define DM_CSW_SOFT_RESET(x)                     (((uint32_t)(((uint32_t)(x)) << DM_CSW_SOFT_RESET_SHIFT)) & DM_CSW_SOFT_RESET_MASK)

#define DM_CSW_CHIP_RESET_REQ_MASK               (0x20U)
#define DM_CSW_CHIP_RESET_REQ_SHIFT              (5U)
/*! CHIP_RESET_REQ - Chip Reset Request */
#define DM_CSW_CHIP_RESET_REQ(x)                 (((uint32_t)(((uint32_t)(x)) << DM_CSW_CHIP_RESET_REQ_SHIFT)) & DM_CSW_CHIP_RESET_REQ_MASK)
/*! @} */

/*! @name REQUEST - Request Value */
/*! @{ */

#define DM_REQUEST_REQUEST_MASK                  (0xFFFFFFFFU)
#define DM_REQUEST_REQUEST_SHIFT                 (0U)
/*! REQUEST - Request Value */
#define DM_REQUEST_REQUEST(x)                    (((uint32_t)(((uint32_t)(x)) << DM_REQUEST_REQUEST_SHIFT)) & DM_REQUEST_REQUEST_MASK)
/*! @} */

/*! @name RETURN - Return Value */
/*! @{ */

#define DM_RETURN_RET_MASK                       (0xFFFFFFFFU)
#define DM_RETURN_RET_SHIFT                      (0U)
/*! RET - Return Value */
#define DM_RETURN_RET(x)                         (((uint32_t)(((uint32_t)(x)) << DM_RETURN_RET_SHIFT)) & DM_RETURN_RET_MASK)
/*! @} */

/*! @name ID - Identification */
/*! @{ */

#define DM_ID_ID_MASK                            (0xFFFFFFFFU)
#define DM_ID_ID_SHIFT                           (0U)
/*! ID - Identification Value */
#define DM_ID_ID(x)                              (((uint32_t)(((uint32_t)(x)) << DM_ID_ID_SHIFT)) & DM_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DM_Register_Masks */


/* DM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DM0 base address */
  #define DM0_BASE                                 (0x500BD000u)
  /** Peripheral DM0 base address */
  #define DM0_BASE_NS                              (0x400BD000u)
  /** Peripheral DM0 base pointer */
  #define DM0                                      ((DM_Type *)DM0_BASE)
  /** Peripheral DM0 base pointer */
  #define DM0_NS                                   ((DM_Type *)DM0_BASE_NS)
  /** Array initializer of DM peripheral base addresses */
  #define DM_BASE_ADDRS                            { DM0_BASE }
  /** Array initializer of DM peripheral base pointers */
  #define DM_BASE_PTRS                             { DM0 }
  /** Array initializer of DM peripheral base addresses */
  #define DM_BASE_ADDRS_NS                         { DM0_BASE_NS }
  /** Array initializer of DM peripheral base pointers */
  #define DM_BASE_PTRS_NS                          { DM0_NS }
#else
  /** Peripheral DM0 base address */
  #define DM0_BASE                                 (0x400BD000u)
  /** Peripheral DM0 base pointer */
  #define DM0                                      ((DM_Type *)DM0_BASE)
  /** Array initializer of DM peripheral base addresses */
  #define DM_BASE_ADDRS                            { DM0_BASE }
  /** Array initializer of DM peripheral base pointers */
  #define DM_BASE_PTRS                             { DM0 }
#endif

/*!
 * @}
 */ /* end of group DM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t MP_CSR;                            /**< Management Page Control, offset: 0x0 */
  __I  uint32_t MP_ES;                             /**< Management Page Error Status, offset: 0x4 */
  __I  uint32_t MP_INT;                            /**< Management Page Interrupt Request Status, offset: 0x8 */
  __I  uint32_t MP_HRS;                            /**< Management Page Hardware Request Status, offset: 0xC */
       uint8_t RESERVED_0[240];
  __IO uint32_t CH_GRPRI[16];                      /**< Channel Arbitration Group, array offset: 0x100, array step: 0x4, irregular array, not all indices are valid */
       uint8_t RESERVED_1[3776];
  struct {                                         /* offset: 0x1000, array step: 0x1000 */
    __IO uint32_t CH_CSR;                            /**< Channel Control and Status, array offset: 0x1000, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint32_t CH_ES;                             /**< Channel Error Status, array offset: 0x1004, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint32_t CH_INT;                            /**< Channel Interrupt Status, array offset: 0x1008, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint32_t CH_SBR;                            /**< Channel System Bus, array offset: 0x100C, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint32_t CH_PRI;                            /**< Channel Priority, array offset: 0x1010, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint32_t CH_MUX;                            /**< Channel Multiplexor Configuration, array offset: 0x1014, array step: 0x1000, irregular array, not all indices are valid */
         uint8_t RESERVED_0[8];
    __IO uint32_t TCD_SADDR;                         /**< TCD Source Address, array offset: 0x1020, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint16_t TCD_SOFF;                          /**< TCD Signed Source Address Offset, array offset: 0x1024, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint16_t TCD_ATTR;                          /**< TCD Transfer Attributes, array offset: 0x1026, array step: 0x1000, irregular array, not all indices are valid */
    union {                                          /* offset: 0x1028, array step: 0x1000 */
      __IO uint32_t TCD_NBYTES_MLOFFNO;                /**< TCD Transfer Size Without Minor Loop Offsets, array offset: 0x1028, array step: 0x1000, irregular array, not all indices are valid */
      __IO uint32_t TCD_NBYTES_MLOFFYES;               /**< TCD Transfer Size with Minor Loop Offsets, array offset: 0x1028, array step: 0x1000, irregular array, not all indices are valid */
    };
    __IO uint32_t TCD_SLAST_SDA;                     /**< TCD Last Source Address Adjustment / Store DADDR Address, array offset: 0x102C, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint32_t TCD_DADDR;                         /**< TCD Destination Address, array offset: 0x1030, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint16_t TCD_DOFF;                          /**< TCD Signed Destination Address Offset, array offset: 0x1034, array step: 0x1000, irregular array, not all indices are valid */
    union {                                          /* offset: 0x1036, array step: 0x1000 */
      __IO uint16_t TCD_CITER_ELINKNO;                 /**< TCD Current Major Loop Count (Minor Loop Channel Linking Disabled), array offset: 0x1036, array step: 0x1000, irregular array, not all indices are valid */
      __IO uint16_t TCD_CITER_ELINKYES;                /**< TCD Current Major Loop Count (Minor Loop Channel Linking Enabled), array offset: 0x1036, array step: 0x1000, irregular array, not all indices are valid */
    };
    __IO uint32_t TCD_DLAST_SGA;                     /**< TCD Last Destination Address Adjustment / Scatter Gather Address, array offset: 0x1038, array step: 0x1000, irregular array, not all indices are valid */
    __IO uint16_t TCD_CSR;                           /**< TCD Control and Status, array offset: 0x103C, array step: 0x1000, irregular array, not all indices are valid */
    union {                                          /* offset: 0x103E, array step: 0x1000 */
      __IO uint16_t TCD_BITER_ELINKNO;                 /**< TCD Beginning Major Loop Count (Minor Loop Channel Linking Disabled), array offset: 0x103E, array step: 0x1000, irregular array, not all indices are valid */
      __IO uint16_t TCD_BITER_ELINKYES;                /**< TCD Beginning Major Loop Count (Minor Loop Channel Linking Enabled), array offset: 0x103E, array step: 0x1000, irregular array, not all indices are valid */
    };
         uint8_t RESERVED_1[4032];
  } CH[16];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name MP_CSR - Management Page Control */
/*! @{ */

#define DMA_MP_CSR_EDBG_MASK                     (0x2U)
#define DMA_MP_CSR_EDBG_SHIFT                    (1U)
/*! EDBG - Enable Debug
 *  0b0..Debug mode disabled
 *  0b1..Debug mode is enabled.
 */
#define DMA_MP_CSR_EDBG(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_EDBG_SHIFT)) & DMA_MP_CSR_EDBG_MASK)

#define DMA_MP_CSR_ERCA_MASK                     (0x4U)
#define DMA_MP_CSR_ERCA_SHIFT                    (2U)
/*! ERCA - Enable Round Robin Channel Arbitration
 *  0b0..Round-robin channel arbitration disabled
 *  0b1..Round-robin channel arbitration enabled
 */
#define DMA_MP_CSR_ERCA(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ERCA_SHIFT)) & DMA_MP_CSR_ERCA_MASK)

#define DMA_MP_CSR_HAE_MASK                      (0x10U)
#define DMA_MP_CSR_HAE_SHIFT                     (4U)
/*! HAE - Halt After Error
 *  0b0..Normal operation
 *  0b1..Any error causes the HALT field to be set to 1
 */
#define DMA_MP_CSR_HAE(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_HAE_SHIFT)) & DMA_MP_CSR_HAE_MASK)

#define DMA_MP_CSR_HALT_MASK                     (0x20U)
#define DMA_MP_CSR_HALT_SHIFT                    (5U)
/*! HALT - Halt DMA Operations
 *  0b0..Normal operation
 *  0b1..Stall the start of any new channels
 */
#define DMA_MP_CSR_HALT(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_HALT_SHIFT)) & DMA_MP_CSR_HALT_MASK)

#define DMA_MP_CSR_GCLC_MASK                     (0x40U)
#define DMA_MP_CSR_GCLC_SHIFT                    (6U)
/*! GCLC - Global Channel Linking Control
 *  0b0..Channel linking disabled for all channels
 *  0b1..Channel linking available and controlled by each channel's link settings
 */
#define DMA_MP_CSR_GCLC(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_GCLC_SHIFT)) & DMA_MP_CSR_GCLC_MASK)

#define DMA_MP_CSR_GMRC_MASK                     (0x80U)
#define DMA_MP_CSR_GMRC_SHIFT                    (7U)
/*! GMRC - Global Master ID Replication Control
 *  0b0..Master ID replication disabled for all channels
 *  0b1..Master ID replication available and controlled by each channel's CHn_SBR[EMI] setting
 */
#define DMA_MP_CSR_GMRC(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_GMRC_SHIFT)) & DMA_MP_CSR_GMRC_MASK)

#define DMA_MP_CSR_ECX_MASK                      (0x100U)
#define DMA_MP_CSR_ECX_SHIFT                     (8U)
/*! ECX - Cancel Transfer With Error
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_MP_CSR_ECX(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ECX_SHIFT)) & DMA_MP_CSR_ECX_MASK)

#define DMA_MP_CSR_CX_MASK                       (0x200U)
#define DMA_MP_CSR_CX_SHIFT                      (9U)
/*! CX - Cancel Transfer
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_MP_CSR_CX(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_CX_SHIFT)) & DMA_MP_CSR_CX_MASK)

#define DMA_MP_CSR_ACTIVE_ID_MASK                (0xF000000U)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */
#define DMA_MP_CSR_ACTIVE_ID_SHIFT               (24U)
/*! ACTIVE_ID - Active Channel ID */
#define DMA_MP_CSR_ACTIVE_ID(x)                  (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ACTIVE_ID_SHIFT)) & DMA_MP_CSR_ACTIVE_ID_MASK)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */

#define DMA_MP_CSR_ACTIVE_MASK                   (0x80000000U)
#define DMA_MP_CSR_ACTIVE_SHIFT                  (31U)
/*! ACTIVE - DMA Active Status
 *  0b0..eDMA is idle
 *  0b1..eDMA is executing a channel
 */
#define DMA_MP_CSR_ACTIVE(x)                     (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ACTIVE_SHIFT)) & DMA_MP_CSR_ACTIVE_MASK)
/*! @} */

/*! @name MP_ES - Management Page Error Status */
/*! @{ */

#define DMA_MP_ES_DBE_MASK                       (0x1U)
#define DMA_MP_ES_DBE_SHIFT                      (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..Last recorded error was a bus error on a destination write
 */
#define DMA_MP_ES_DBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DBE_SHIFT)) & DMA_MP_ES_DBE_MASK)

#define DMA_MP_ES_SBE_MASK                       (0x2U)
#define DMA_MP_ES_SBE_SHIFT                      (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error
 *  0b1..Last recorded error was a bus error on a source read
 */
#define DMA_MP_ES_SBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SBE_SHIFT)) & DMA_MP_ES_SBE_MASK)

#define DMA_MP_ES_SGE_MASK                       (0x4U)
#define DMA_MP_ES_SGE_SHIFT                      (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DLAST_SGA field
 */
#define DMA_MP_ES_SGE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SGE_SHIFT)) & DMA_MP_ES_SGE_MASK)

#define DMA_MP_ES_NCE_MASK                       (0x8U)
#define DMA_MP_ES_NCE_SHIFT                      (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error
 *  0b1..The last recorded error was NBYTES equal to zero or a CITER not equal to BITER error
 */
#define DMA_MP_ES_NCE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_NCE_SHIFT)) & DMA_MP_ES_NCE_MASK)

#define DMA_MP_ES_DOE_MASK                       (0x10U)
#define DMA_MP_ES_DOE_SHIFT                      (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DOFF field
 */
#define DMA_MP_ES_DOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DOE_SHIFT)) & DMA_MP_ES_DOE_MASK)

#define DMA_MP_ES_DAE_MASK                       (0x20U)
#define DMA_MP_ES_DAE_SHIFT                      (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DADDR field
 */
#define DMA_MP_ES_DAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DAE_SHIFT)) & DMA_MP_ES_DAE_MASK)

#define DMA_MP_ES_SOE_MASK                       (0x40U)
#define DMA_MP_ES_SOE_SHIFT                      (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SOFF field
 */
#define DMA_MP_ES_SOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SOE_SHIFT)) & DMA_MP_ES_SOE_MASK)

#define DMA_MP_ES_SAE_MASK                       (0x80U)
#define DMA_MP_ES_SAE_SHIFT                      (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SADDR field
 */
#define DMA_MP_ES_SAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SAE_SHIFT)) & DMA_MP_ES_SAE_MASK)

#define DMA_MP_ES_ECX_MASK                       (0x100U)
#define DMA_MP_ES_ECX_SHIFT                      (8U)
/*! ECX - Transfer Canceled
 *  0b0..No canceled transfers
 *  0b1..Last recorded entry was a canceled transfer by the error cancel transfer input
 */
#define DMA_MP_ES_ECX(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_ECX_SHIFT)) & DMA_MP_ES_ECX_MASK)

#define DMA_MP_ES_ERRCHN_MASK                    (0xF000000U)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */
#define DMA_MP_ES_ERRCHN_SHIFT                   (24U)
/*! ERRCHN - Error Channel Number or Canceled Channel Number */
#define DMA_MP_ES_ERRCHN(x)                      (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_ERRCHN_SHIFT)) & DMA_MP_ES_ERRCHN_MASK)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */

#define DMA_MP_ES_VLD_MASK                       (0x80000000U)
#define DMA_MP_ES_VLD_SHIFT                      (31U)
/*! VLD - Valid
 *  0b0..No CHn_ES[ERR] fields are set to 1
 *  0b1..At least one CHn_ES[ERR] field is set to 1, indicating a valid error exists that software has not cleared
 */
#define DMA_MP_ES_VLD(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_VLD_SHIFT)) & DMA_MP_ES_VLD_MASK)
/*! @} */

/*! @name MP_INT - Management Page Interrupt Request Status */
/*! @{ */

#define DMA_MP_INT_INT_MASK                      (0xFFFFU)  /* Merged from fields with different position or width, of widths (8, 16), largest definition used */
#define DMA_MP_INT_INT_SHIFT                     (0U)
/*! INT - Interrupt Request Status */
#define DMA_MP_INT_INT(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_INT_INT_SHIFT)) & DMA_MP_INT_INT_MASK)  /* Merged from fields with different position or width, of widths (8, 16), largest definition used */
/*! @} */

/*! @name MP_HRS - Management Page Hardware Request Status */
/*! @{ */

#define DMA_MP_HRS_HRS_MASK                      (0xFFFFFFFFU)
#define DMA_MP_HRS_HRS_SHIFT                     (0U)
/*! HRS - Hardware Request Status */
#define DMA_MP_HRS_HRS(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_HRS_HRS_SHIFT)) & DMA_MP_HRS_HRS_MASK)
/*! @} */

/*! @name CH_GRPRI - Channel Arbitration Group */
/*! @{ */

#define DMA_CH_GRPRI_GRPRI_MASK                  (0x1FU)
#define DMA_CH_GRPRI_GRPRI_SHIFT                 (0U)
/*! GRPRI - Arbitration Group For Channel n */
#define DMA_CH_GRPRI_GRPRI(x)                    (((uint32_t)(((uint32_t)(x)) << DMA_CH_GRPRI_GRPRI_SHIFT)) & DMA_CH_GRPRI_GRPRI_MASK)
/*! @} */

/* The count of DMA_CH_GRPRI */
#define DMA_CH_GRPRI_COUNT                       (16U)

/*! @name CH_CSR - Channel Control and Status */
/*! @{ */

#define DMA_CH_CSR_ERQ_MASK                      (0x1U)
#define DMA_CH_CSR_ERQ_SHIFT                     (0U)
/*! ERQ - Enable DMA Request
 *  0b0..DMA hardware request signal for corresponding channel disabled
 *  0b1..DMA hardware request signal for corresponding channel enabled
 */
#define DMA_CH_CSR_ERQ(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_ERQ_SHIFT)) & DMA_CH_CSR_ERQ_MASK)

#define DMA_CH_CSR_EARQ_MASK                     (0x2U)
#define DMA_CH_CSR_EARQ_SHIFT                    (1U)
/*! EARQ - Enable Asynchronous DMA Request
 *  0b0..Disable asynchronous DMA request for the channel
 *  0b1..Enable asynchronous DMA request for the channel
 */
#define DMA_CH_CSR_EARQ(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EARQ_SHIFT)) & DMA_CH_CSR_EARQ_MASK)

#define DMA_CH_CSR_EEI_MASK                      (0x4U)
#define DMA_CH_CSR_EEI_SHIFT                     (2U)
/*! EEI - Enable Error Interrupt
 *  0b0..Error signal for corresponding channel does not generate error interrupt
 *  0b1..Assertion of error signal for corresponding channel generates error interrupt request
 */
#define DMA_CH_CSR_EEI(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EEI_SHIFT)) & DMA_CH_CSR_EEI_MASK)

#define DMA_CH_CSR_EBW_MASK                      (0x8U)
#define DMA_CH_CSR_EBW_SHIFT                     (3U)
/*! EBW - Enable Buffered Writes
 *  0b0..Buffered writes on system bus disabled
 *  0b1..Buffered writes on system bus enabled
 */
#define DMA_CH_CSR_EBW(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EBW_SHIFT)) & DMA_CH_CSR_EBW_MASK)

#define DMA_CH_CSR_DONE_MASK                     (0x40000000U)
#define DMA_CH_CSR_DONE_SHIFT                    (30U)
/*! DONE - Channel Done */
#define DMA_CH_CSR_DONE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_DONE_SHIFT)) & DMA_CH_CSR_DONE_MASK)

#define DMA_CH_CSR_ACTIVE_MASK                   (0x80000000U)
#define DMA_CH_CSR_ACTIVE_SHIFT                  (31U)
/*! ACTIVE - Channel Active */
#define DMA_CH_CSR_ACTIVE(x)                     (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_ACTIVE_SHIFT)) & DMA_CH_CSR_ACTIVE_MASK)
/*! @} */

/* The count of DMA_CH_CSR */
#define DMA_CH_CSR_COUNT                         (16U)

/*! @name CH_ES - Channel Error Status */
/*! @{ */

#define DMA_CH_ES_DBE_MASK                       (0x1U)
#define DMA_CH_ES_DBE_SHIFT                      (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..Last recorded error was bus error on destination write
 */
#define DMA_CH_ES_DBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DBE_SHIFT)) & DMA_CH_ES_DBE_MASK)

#define DMA_CH_ES_SBE_MASK                       (0x2U)
#define DMA_CH_ES_SBE_SHIFT                      (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error
 *  0b1..Last recorded error was bus error on source read
 */
#define DMA_CH_ES_SBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SBE_SHIFT)) & DMA_CH_ES_SBE_MASK)

#define DMA_CH_ES_SGE_MASK                       (0x4U)
#define DMA_CH_ES_SGE_SHIFT                      (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DLAST_SGA field
 */
#define DMA_CH_ES_SGE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SGE_SHIFT)) & DMA_CH_ES_SGE_MASK)

#define DMA_CH_ES_NCE_MASK                       (0x8U)
#define DMA_CH_ES_NCE_SHIFT                      (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_NBYTES or TCDn_CITER fields
 */
#define DMA_CH_ES_NCE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_NCE_SHIFT)) & DMA_CH_ES_NCE_MASK)

#define DMA_CH_ES_DOE_MASK                       (0x10U)
#define DMA_CH_ES_DOE_SHIFT                      (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DOFF field
 */
#define DMA_CH_ES_DOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DOE_SHIFT)) & DMA_CH_ES_DOE_MASK)

#define DMA_CH_ES_DAE_MASK                       (0x20U)
#define DMA_CH_ES_DAE_SHIFT                      (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DADDR field
 */
#define DMA_CH_ES_DAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DAE_SHIFT)) & DMA_CH_ES_DAE_MASK)

#define DMA_CH_ES_SOE_MASK                       (0x40U)
#define DMA_CH_ES_SOE_SHIFT                      (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SOFF field
 */
#define DMA_CH_ES_SOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SOE_SHIFT)) & DMA_CH_ES_SOE_MASK)

#define DMA_CH_ES_SAE_MASK                       (0x80U)
#define DMA_CH_ES_SAE_SHIFT                      (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SADDR field
 */
#define DMA_CH_ES_SAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SAE_SHIFT)) & DMA_CH_ES_SAE_MASK)

#define DMA_CH_ES_ERR_MASK                       (0x80000000U)
#define DMA_CH_ES_ERR_SHIFT                      (31U)
/*! ERR - Error In Channel
 *  0b0..An error in this channel has not occurred
 *  0b1..An error in this channel has occurred
 */
#define DMA_CH_ES_ERR(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_ERR_SHIFT)) & DMA_CH_ES_ERR_MASK)
/*! @} */

/* The count of DMA_CH_ES */
#define DMA_CH_ES_COUNT                          (16U)

/*! @name CH_INT - Channel Interrupt Status */
/*! @{ */

#define DMA_CH_INT_INT_MASK                      (0x1U)
#define DMA_CH_INT_INT_SHIFT                     (0U)
/*! INT - Interrupt Request
 *  0b0..Interrupt request for corresponding channel cleared
 *  0b1..Interrupt request for corresponding channel active
 */
#define DMA_CH_INT_INT(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_INT_INT_SHIFT)) & DMA_CH_INT_INT_MASK)
/*! @} */

/* The count of DMA_CH_INT */
#define DMA_CH_INT_COUNT                         (16U)

/*! @name CH_SBR - Channel System Bus */
/*! @{ */

#define DMA_CH_SBR_MID_MASK                      (0x1FU)
#define DMA_CH_SBR_MID_SHIFT                     (0U)
/*! MID - Master ID */
#define DMA_CH_SBR_MID(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_MID_SHIFT)) & DMA_CH_SBR_MID_MASK)

#define DMA_CH_SBR_SEC_MASK                      (0x4000U)
#define DMA_CH_SBR_SEC_SHIFT                     (14U)
/*! SEC - Security Level
 *  0b0..Nonsecure protection level for DMA transfers
 *  0b1..Secure protection level for DMA transfers
 */
#define DMA_CH_SBR_SEC(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_SEC_SHIFT)) & DMA_CH_SBR_SEC_MASK)

#define DMA_CH_SBR_PAL_MASK                      (0x8000U)
#define DMA_CH_SBR_PAL_SHIFT                     (15U)
/*! PAL - Privileged Access Level
 *  0b0..User protection level for DMA transfers
 *  0b1..Privileged protection level for DMA transfers
 */
#define DMA_CH_SBR_PAL(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_PAL_SHIFT)) & DMA_CH_SBR_PAL_MASK)

#define DMA_CH_SBR_EMI_MASK                      (0x10000U)
#define DMA_CH_SBR_EMI_SHIFT                     (16U)
/*! EMI - Enable Master ID Replication
 *  0b0..Master ID replication is disabled
 *  0b1..Master ID replication is enabled
 */
#define DMA_CH_SBR_EMI(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_EMI_SHIFT)) & DMA_CH_SBR_EMI_MASK)
/*! @} */

/* The count of DMA_CH_SBR */
#define DMA_CH_SBR_COUNT                         (16U)

/*! @name CH_PRI - Channel Priority */
/*! @{ */

#define DMA_CH_PRI_APL_MASK                      (0x7U)
#define DMA_CH_PRI_APL_SHIFT                     (0U)
/*! APL - Arbitration Priority Level */
#define DMA_CH_PRI_APL(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_APL_SHIFT)) & DMA_CH_PRI_APL_MASK)

#define DMA_CH_PRI_DPA_MASK                      (0x40000000U)
#define DMA_CH_PRI_DPA_SHIFT                     (30U)
/*! DPA - Disable Preempt Ability
 *  0b0..Channel can suspend a lower-priority channel
 *  0b1..Channel cannot suspend any other channel, regardless of channel priority
 */
#define DMA_CH_PRI_DPA(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_DPA_SHIFT)) & DMA_CH_PRI_DPA_MASK)

#define DMA_CH_PRI_ECP_MASK                      (0x80000000U)
#define DMA_CH_PRI_ECP_SHIFT                     (31U)
/*! ECP - Enable Channel Preemption
 *  0b0..Channel cannot be suspended by a higher-priority channel's service request
 *  0b1..Channel can be temporarily suspended by a higher-priority channel's service request
 */
#define DMA_CH_PRI_ECP(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_ECP_SHIFT)) & DMA_CH_PRI_ECP_MASK)
/*! @} */

/* The count of DMA_CH_PRI */
#define DMA_CH_PRI_COUNT                         (16U)

/*! @name CH_MUX - Channel Multiplexor Configuration */
/*! @{ */

#define DMA_CH_MUX_SRC_MASK                      (0x7FU)
#define DMA_CH_MUX_SRC_SHIFT                     (0U)
/*! SRC - Service Request Source */
#define DMA_CH_MUX_SRC(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_MUX_SRC_SHIFT)) & DMA_CH_MUX_SRC_MASK)
/*! @} */

/* The count of DMA_CH_MUX */
#define DMA_CH_MUX_COUNT                         (16U)

/*! @name TCD_SADDR - TCD Source Address */
/*! @{ */

#define DMA_TCD_SADDR_SADDR_MASK                 (0xFFFFFFFFU)
#define DMA_TCD_SADDR_SADDR_SHIFT                (0U)
/*! SADDR - Source Address */
#define DMA_TCD_SADDR_SADDR(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_TCD_SADDR_SADDR_SHIFT)) & DMA_TCD_SADDR_SADDR_MASK)
/*! @} */

/* The count of DMA_TCD_SADDR */
#define DMA_TCD_SADDR_COUNT                      (16U)

/*! @name TCD_SOFF - TCD Signed Source Address Offset */
/*! @{ */

#define DMA_TCD_SOFF_SOFF_MASK                   (0xFFFFU)
#define DMA_TCD_SOFF_SOFF_SHIFT                  (0U)
/*! SOFF - Source Address Signed Offset */
#define DMA_TCD_SOFF_SOFF(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_SOFF_SOFF_SHIFT)) & DMA_TCD_SOFF_SOFF_MASK)
/*! @} */

/* The count of DMA_TCD_SOFF */
#define DMA_TCD_SOFF_COUNT                       (16U)

/*! @name TCD_ATTR - TCD Transfer Attributes */
/*! @{ */

#define DMA_TCD_ATTR_DSIZE_MASK                  (0x7U)
#define DMA_TCD_ATTR_DSIZE_SHIFT                 (0U)
/*! DSIZE - Destination Data Transfer Size */
#define DMA_TCD_ATTR_DSIZE(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_DSIZE_SHIFT)) & DMA_TCD_ATTR_DSIZE_MASK)

#define DMA_TCD_ATTR_DMOD_MASK                   (0xF8U)
#define DMA_TCD_ATTR_DMOD_SHIFT                  (3U)
/*! DMOD - Destination Address Modulo */
#define DMA_TCD_ATTR_DMOD(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_DMOD_SHIFT)) & DMA_TCD_ATTR_DMOD_MASK)

#define DMA_TCD_ATTR_SSIZE_MASK                  (0x700U)
#define DMA_TCD_ATTR_SSIZE_SHIFT                 (8U)
/*! SSIZE - Source Data Transfer Size
 *  0b000..8-bit
 *  0b001..16-bit
 *  0b010..32-bit
 *  0b011..64-bit
 *  0b100..16-byte
 *  0b101..32-byte
 *  0b110..
 *  0b111..
 */
#define DMA_TCD_ATTR_SSIZE(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_SSIZE_SHIFT)) & DMA_TCD_ATTR_SSIZE_MASK)

#define DMA_TCD_ATTR_SMOD_MASK                   (0xF800U)
#define DMA_TCD_ATTR_SMOD_SHIFT                  (11U)
/*! SMOD - Source Address Modulo
 *  0b00000..Source address modulo feature disabled
 *  0b00001..Source address modulo feature enabled for any non-zero value [1-31]
 */
#define DMA_TCD_ATTR_SMOD(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_SMOD_SHIFT)) & DMA_TCD_ATTR_SMOD_MASK)
/*! @} */

/* The count of DMA_TCD_ATTR */
#define DMA_TCD_ATTR_COUNT                       (16U)

/*! @name TCD_NBYTES_MLOFFNO - TCD Transfer Size Without Minor Loop Offsets */
/*! @{ */

#define DMA_TCD_NBYTES_MLOFFNO_NBYTES_MASK       (0x3FFFFFFFU)
#define DMA_TCD_NBYTES_MLOFFNO_NBYTES_SHIFT      (0U)
/*! NBYTES - Number of Bytes To Transfer Per Service Request */
#define DMA_TCD_NBYTES_MLOFFNO_NBYTES(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_NBYTES_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_NBYTES_MASK)

#define DMA_TCD_NBYTES_MLOFFNO_DMLOE_MASK        (0x40000000U)
#define DMA_TCD_NBYTES_MLOFFNO_DMLOE_SHIFT       (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to DADDR
 *  0b1..Minor loop offset applied to DADDR
 */
#define DMA_TCD_NBYTES_MLOFFNO_DMLOE(x)          (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_DMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_DMLOE_MASK)

#define DMA_TCD_NBYTES_MLOFFNO_SMLOE_MASK        (0x80000000U)
#define DMA_TCD_NBYTES_MLOFFNO_SMLOE_SHIFT       (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to SADDR
 *  0b1..Minor loop offset applied to SADDR
 */
#define DMA_TCD_NBYTES_MLOFFNO_SMLOE(x)          (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_SMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_SMLOE_MASK)
/*! @} */

/* The count of DMA_TCD_NBYTES_MLOFFNO */
#define DMA_TCD_NBYTES_MLOFFNO_COUNT             (16U)

/*! @name TCD_NBYTES_MLOFFYES - TCD Transfer Size with Minor Loop Offsets */
/*! @{ */

#define DMA_TCD_NBYTES_MLOFFYES_NBYTES_MASK      (0x3FFU)
#define DMA_TCD_NBYTES_MLOFFYES_NBYTES_SHIFT     (0U)
/*! NBYTES - Number of Bytes To Transfer Per Service Request */
#define DMA_TCD_NBYTES_MLOFFYES_NBYTES(x)        (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_NBYTES_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_NBYTES_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_MLOFF_MASK       (0x3FFFFC00U)
#define DMA_TCD_NBYTES_MLOFFYES_MLOFF_SHIFT      (10U)
/*! MLOFF - Minor Loop Offset */
#define DMA_TCD_NBYTES_MLOFFYES_MLOFF(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_MLOFF_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_MLOFF_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_DMLOE_MASK       (0x40000000U)
#define DMA_TCD_NBYTES_MLOFFYES_DMLOE_SHIFT      (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to DADDR
 *  0b1..Minor loop offset applied to DADDR
 */
#define DMA_TCD_NBYTES_MLOFFYES_DMLOE(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_DMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_DMLOE_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_SMLOE_MASK       (0x80000000U)
#define DMA_TCD_NBYTES_MLOFFYES_SMLOE_SHIFT      (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to SADDR
 *  0b1..Minor loop offset applied to SADDR
 */
#define DMA_TCD_NBYTES_MLOFFYES_SMLOE(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_SMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_SMLOE_MASK)
/*! @} */

/* The count of DMA_TCD_NBYTES_MLOFFYES */
#define DMA_TCD_NBYTES_MLOFFYES_COUNT            (16U)

/*! @name TCD_SLAST_SDA - TCD Last Source Address Adjustment / Store DADDR Address */
/*! @{ */

#define DMA_TCD_SLAST_SDA_SLAST_SDA_MASK         (0xFFFFFFFFU)
#define DMA_TCD_SLAST_SDA_SLAST_SDA_SHIFT        (0U)
/*! SLAST_SDA - Last Source Address Adjustment / Store DADDR Address */
#define DMA_TCD_SLAST_SDA_SLAST_SDA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_TCD_SLAST_SDA_SLAST_SDA_SHIFT)) & DMA_TCD_SLAST_SDA_SLAST_SDA_MASK)
/*! @} */

/* The count of DMA_TCD_SLAST_SDA */
#define DMA_TCD_SLAST_SDA_COUNT                  (16U)

/*! @name TCD_DADDR - TCD Destination Address */
/*! @{ */

#define DMA_TCD_DADDR_DADDR_MASK                 (0xFFFFFFFFU)
#define DMA_TCD_DADDR_DADDR_SHIFT                (0U)
/*! DADDR - Destination Address */
#define DMA_TCD_DADDR_DADDR(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_TCD_DADDR_DADDR_SHIFT)) & DMA_TCD_DADDR_DADDR_MASK)
/*! @} */

/* The count of DMA_TCD_DADDR */
#define DMA_TCD_DADDR_COUNT                      (16U)

/*! @name TCD_DOFF - TCD Signed Destination Address Offset */
/*! @{ */

#define DMA_TCD_DOFF_DOFF_MASK                   (0xFFFFU)
#define DMA_TCD_DOFF_DOFF_SHIFT                  (0U)
/*! DOFF - Destination Address Signed Offset */
#define DMA_TCD_DOFF_DOFF(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_DOFF_DOFF_SHIFT)) & DMA_TCD_DOFF_DOFF_MASK)
/*! @} */

/* The count of DMA_TCD_DOFF */
#define DMA_TCD_DOFF_COUNT                       (16U)

/*! @name TCD_CITER_ELINKNO - TCD Current Major Loop Count (Minor Loop Channel Linking Disabled) */
/*! @{ */

#define DMA_TCD_CITER_ELINKNO_CITER_MASK         (0x7FFFU)
#define DMA_TCD_CITER_ELINKNO_CITER_SHIFT        (0U)
/*! CITER - Current Major Iteration Count */
#define DMA_TCD_CITER_ELINKNO_CITER(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKNO_CITER_SHIFT)) & DMA_TCD_CITER_ELINKNO_CITER_MASK)

#define DMA_TCD_CITER_ELINKNO_ELINK_MASK         (0x8000U)
#define DMA_TCD_CITER_ELINKNO_ELINK_SHIFT        (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CITER_ELINKNO_ELINK(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKNO_ELINK_SHIFT)) & DMA_TCD_CITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_CITER_ELINKNO */
#define DMA_TCD_CITER_ELINKNO_COUNT              (16U)

/*! @name TCD_CITER_ELINKYES - TCD Current Major Loop Count (Minor Loop Channel Linking Enabled) */
/*! @{ */

#define DMA_TCD_CITER_ELINKYES_CITER_MASK        (0x1FFU)
#define DMA_TCD_CITER_ELINKYES_CITER_SHIFT       (0U)
/*! CITER - Current Major Iteration Count */
#define DMA_TCD_CITER_ELINKYES_CITER(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_CITER_SHIFT)) & DMA_TCD_CITER_ELINKYES_CITER_MASK)

#define DMA_TCD_CITER_ELINKYES_LINKCH_MASK       (0x1E00U)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */
#define DMA_TCD_CITER_ELINKYES_LINKCH_SHIFT      (9U)
/*! LINKCH - Minor Loop Link Channel Number */
#define DMA_TCD_CITER_ELINKYES_LINKCH(x)         (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_LINKCH_SHIFT)) & DMA_TCD_CITER_ELINKYES_LINKCH_MASK)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */

#define DMA_TCD_CITER_ELINKYES_ELINK_MASK        (0x8000U)
#define DMA_TCD_CITER_ELINKYES_ELINK_SHIFT       (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CITER_ELINKYES_ELINK(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_ELINK_SHIFT)) & DMA_TCD_CITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_CITER_ELINKYES */
#define DMA_TCD_CITER_ELINKYES_COUNT             (16U)

/*! @name TCD_DLAST_SGA - TCD Last Destination Address Adjustment / Scatter Gather Address */
/*! @{ */

#define DMA_TCD_DLAST_SGA_DLAST_SGA_MASK         (0xFFFFFFFFU)
#define DMA_TCD_DLAST_SGA_DLAST_SGA_SHIFT        (0U)
/*! DLAST_SGA - Last Destination Address Adjustment / Scatter Gather Address */
#define DMA_TCD_DLAST_SGA_DLAST_SGA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_TCD_DLAST_SGA_DLAST_SGA_SHIFT)) & DMA_TCD_DLAST_SGA_DLAST_SGA_MASK)
/*! @} */

/* The count of DMA_TCD_DLAST_SGA */
#define DMA_TCD_DLAST_SGA_COUNT                  (16U)

/*! @name TCD_CSR - TCD Control and Status */
/*! @{ */

#define DMA_TCD_CSR_START_MASK                   (0x1U)
#define DMA_TCD_CSR_START_SHIFT                  (0U)
/*! START - Channel Start
 *  0b0..Channel not explicitly started
 *  0b1..Channel explicitly started via a software-initiated service request
 */
#define DMA_TCD_CSR_START(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_START_SHIFT)) & DMA_TCD_CSR_START_MASK)

#define DMA_TCD_CSR_INTMAJOR_MASK                (0x2U)
#define DMA_TCD_CSR_INTMAJOR_SHIFT               (1U)
/*! INTMAJOR - Enable Interrupt If Major count complete
 *  0b0..End-of-major loop interrupt disabled
 *  0b1..End-of-major loop interrupt enabled
 */
#define DMA_TCD_CSR_INTMAJOR(x)                  (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_INTMAJOR_SHIFT)) & DMA_TCD_CSR_INTMAJOR_MASK)

#define DMA_TCD_CSR_INTHALF_MASK                 (0x4U)
#define DMA_TCD_CSR_INTHALF_SHIFT                (2U)
/*! INTHALF - Enable Interrupt If Major Counter Half-complete
 *  0b0..Halfway point interrupt disabled
 *  0b1..Halfway point interrupt enabled
 */
#define DMA_TCD_CSR_INTHALF(x)                   (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_INTHALF_SHIFT)) & DMA_TCD_CSR_INTHALF_MASK)

#define DMA_TCD_CSR_DREQ_MASK                    (0x8U)
#define DMA_TCD_CSR_DREQ_SHIFT                   (3U)
/*! DREQ - Disable Request
 *  0b0..No operation
 *  0b1..Clear the ERQ field to 0 upon major loop completion, thus disabling hardware service requests
 */
#define DMA_TCD_CSR_DREQ(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_DREQ_SHIFT)) & DMA_TCD_CSR_DREQ_MASK)

#define DMA_TCD_CSR_ESG_MASK                     (0x10U)
#define DMA_TCD_CSR_ESG_SHIFT                    (4U)
/*! ESG - Enable Scatter/Gather Processing
 *  0b0..Current channel's TCD is normal format
 *  0b1..Current channel's TCD specifies scatter/gather format.
 */
#define DMA_TCD_CSR_ESG(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_ESG_SHIFT)) & DMA_TCD_CSR_ESG_MASK)

#define DMA_TCD_CSR_MAJORELINK_MASK              (0x20U)
#define DMA_TCD_CSR_MAJORELINK_SHIFT             (5U)
/*! MAJORELINK - Enable Link When Major Loop Complete
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CSR_MAJORELINK(x)                (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_MAJORELINK_SHIFT)) & DMA_TCD_CSR_MAJORELINK_MASK)

#define DMA_TCD_CSR_EEOP_MASK                    (0x40U)
#define DMA_TCD_CSR_EEOP_SHIFT                   (6U)
/*! EEOP - Enable End-Of-Packet Processing
 *  0b0..End-of-packet operation disabled
 *  0b1..End-of-packet hardware input signal enabled
 */
#define DMA_TCD_CSR_EEOP(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_EEOP_SHIFT)) & DMA_TCD_CSR_EEOP_MASK)

#define DMA_TCD_CSR_ESDA_MASK                    (0x80U)
#define DMA_TCD_CSR_ESDA_SHIFT                   (7U)
/*! ESDA - Enable Store Destination Address
 *  0b0..Ability to store destination address to system memory disabled
 *  0b1..Ability to store destination address to system memory enabled
 */
#define DMA_TCD_CSR_ESDA(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_ESDA_SHIFT)) & DMA_TCD_CSR_ESDA_MASK)

#define DMA_TCD_CSR_MAJORLINKCH_MASK             (0xF00U)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */
#define DMA_TCD_CSR_MAJORLINKCH_SHIFT            (8U)
/*! MAJORLINKCH - Major Loop Link Channel Number */
#define DMA_TCD_CSR_MAJORLINKCH(x)               (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_MAJORLINKCH_SHIFT)) & DMA_TCD_CSR_MAJORLINKCH_MASK)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */

#define DMA_TCD_CSR_BWC_MASK                     (0xC000U)
#define DMA_TCD_CSR_BWC_SHIFT                    (14U)
/*! BWC - Bandwidth Control
 *  0b00..No eDMA engine stalls
 *  0b01..
 *  0b10..eDMA engine stalls for 4 cycles after each R/W
 *  0b11..eDMA engine stalls for 8 cycles after each R/W
 */
#define DMA_TCD_CSR_BWC(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_BWC_SHIFT)) & DMA_TCD_CSR_BWC_MASK)
/*! @} */

/* The count of DMA_TCD_CSR */
#define DMA_TCD_CSR_COUNT                        (16U)

/*! @name TCD_BITER_ELINKNO - TCD Beginning Major Loop Count (Minor Loop Channel Linking Disabled) */
/*! @{ */

#define DMA_TCD_BITER_ELINKNO_BITER_MASK         (0x7FFFU)
#define DMA_TCD_BITER_ELINKNO_BITER_SHIFT        (0U)
/*! BITER - Starting Major Iteration Count */
#define DMA_TCD_BITER_ELINKNO_BITER(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKNO_BITER_SHIFT)) & DMA_TCD_BITER_ELINKNO_BITER_MASK)

#define DMA_TCD_BITER_ELINKNO_ELINK_MASK         (0x8000U)
#define DMA_TCD_BITER_ELINKNO_ELINK_SHIFT        (15U)
/*! ELINK - Enables Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_BITER_ELINKNO_ELINK(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKNO_ELINK_SHIFT)) & DMA_TCD_BITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_BITER_ELINKNO */
#define DMA_TCD_BITER_ELINKNO_COUNT              (16U)

/*! @name TCD_BITER_ELINKYES - TCD Beginning Major Loop Count (Minor Loop Channel Linking Enabled) */
/*! @{ */

#define DMA_TCD_BITER_ELINKYES_BITER_MASK        (0x1FFU)
#define DMA_TCD_BITER_ELINKYES_BITER_SHIFT       (0U)
/*! BITER - Starting Major Iteration Count */
#define DMA_TCD_BITER_ELINKYES_BITER(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_BITER_SHIFT)) & DMA_TCD_BITER_ELINKYES_BITER_MASK)

#define DMA_TCD_BITER_ELINKYES_LINKCH_MASK       (0x1E00U)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */
#define DMA_TCD_BITER_ELINKYES_LINKCH_SHIFT      (9U)
/*! LINKCH - Link Channel Number */
#define DMA_TCD_BITER_ELINKYES_LINKCH(x)         (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_LINKCH_SHIFT)) & DMA_TCD_BITER_ELINKYES_LINKCH_MASK)  /* Merged from fields with different position or width, of widths (3, 4), largest definition used */

#define DMA_TCD_BITER_ELINKYES_ELINK_MASK        (0x8000U)
#define DMA_TCD_BITER_ELINKYES_ELINK_SHIFT       (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_BITER_ELINKYES_ELINK(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_ELINK_SHIFT)) & DMA_TCD_BITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_BITER_ELINKYES */
#define DMA_TCD_BITER_ELINKYES_COUNT             (16U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x50080000u)
  /** Peripheral DMA0 base address */
  #define DMA0_BASE_NS                             (0x40080000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA0 base pointer */
  #define DMA0_NS                                  ((DMA_Type *)DMA0_BASE_NS)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE                                (0x500A0000u)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE_NS                             (0x400A0000u)
  /** Peripheral DMA1 base pointer */
  #define DMA1                                     ((DMA_Type *)DMA1_BASE)
  /** Peripheral DMA1 base pointer */
  #define DMA1_NS                                  ((DMA_Type *)DMA1_BASE_NS)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0, DMA1 }
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS_NS                        { DMA0_BASE_NS, DMA1_BASE_NS }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS_NS                         { DMA0_NS, DMA1_NS }
#else
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x40080000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE                                (0x400A0000u)
  /** Peripheral DMA1 base pointer */
  #define DMA1                                     ((DMA_Type *)DMA1_BASE)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0, DMA1 }
#endif
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS                                 { { EDMA_0_CH0_IRQn, EDMA_0_CH1_IRQn, EDMA_0_CH2_IRQn, EDMA_0_CH3_IRQn, EDMA_0_CH4_IRQn, EDMA_0_CH5_IRQn, EDMA_0_CH6_IRQn, EDMA_0_CH7_IRQn, EDMA_0_CH8_IRQn, EDMA_0_CH9_IRQn, EDMA_0_CH10_IRQn, EDMA_0_CH11_IRQn, EDMA_0_CH12_IRQn, EDMA_0_CH13_IRQn, EDMA_0_CH14_IRQn, EDMA_0_CH15_IRQn }, \
                                                   { EDMA_1_CH0_IRQn, EDMA_1_CH1_IRQn, EDMA_1_CH2_IRQn, EDMA_1_CH3_IRQn, EDMA_1_CH4_IRQn, EDMA_1_CH5_IRQn, EDMA_1_CH6_IRQn, EDMA_1_CH7_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn } }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA0_TEE_ALIAS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA0_TEE_ALIAS_Peripheral_Access_Layer DMA0_TEE_ALIAS Peripheral Access Layer
 * @{
 */

/** DMA0_TEE_ALIAS - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4092];
       uint32_t RESERVED;                          /**< Reserved., offset: 0xFFC */
} DMA0_TEE_ALIAS_Type;

/* ----------------------------------------------------------------------------
   -- DMA0_TEE_ALIAS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA0_TEE_ALIAS_Register_Masks DMA0_TEE_ALIAS Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group DMA0_TEE_ALIAS_Register_Masks */


/* DMA0_TEE_ALIAS - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DMA0_TEE_ALIAS0 base address */
  #define DMA0_TEE_ALIAS0_BASE                     (0x50080000u)
  /** Peripheral DMA0_TEE_ALIAS0 base address */
  #define DMA0_TEE_ALIAS0_BASE_NS                  (0x40080000u)
  /** Peripheral DMA0_TEE_ALIAS0 base pointer */
  #define DMA0_TEE_ALIAS0                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS0_BASE)
  /** Peripheral DMA0_TEE_ALIAS0 base pointer */
  #define DMA0_TEE_ALIAS0_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS0_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS1 base address */
  #define DMA0_TEE_ALIAS1_BASE                     (0x50081000u)
  /** Peripheral DMA0_TEE_ALIAS1 base address */
  #define DMA0_TEE_ALIAS1_BASE_NS                  (0x40081000u)
  /** Peripheral DMA0_TEE_ALIAS1 base pointer */
  #define DMA0_TEE_ALIAS1                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS1_BASE)
  /** Peripheral DMA0_TEE_ALIAS1 base pointer */
  #define DMA0_TEE_ALIAS1_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS1_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS2 base address */
  #define DMA0_TEE_ALIAS2_BASE                     (0x50082000u)
  /** Peripheral DMA0_TEE_ALIAS2 base address */
  #define DMA0_TEE_ALIAS2_BASE_NS                  (0x40082000u)
  /** Peripheral DMA0_TEE_ALIAS2 base pointer */
  #define DMA0_TEE_ALIAS2                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS2_BASE)
  /** Peripheral DMA0_TEE_ALIAS2 base pointer */
  #define DMA0_TEE_ALIAS2_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS2_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS3 base address */
  #define DMA0_TEE_ALIAS3_BASE                     (0x50083000u)
  /** Peripheral DMA0_TEE_ALIAS3 base address */
  #define DMA0_TEE_ALIAS3_BASE_NS                  (0x40083000u)
  /** Peripheral DMA0_TEE_ALIAS3 base pointer */
  #define DMA0_TEE_ALIAS3                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS3_BASE)
  /** Peripheral DMA0_TEE_ALIAS3 base pointer */
  #define DMA0_TEE_ALIAS3_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS3_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS4 base address */
  #define DMA0_TEE_ALIAS4_BASE                     (0x50084000u)
  /** Peripheral DMA0_TEE_ALIAS4 base address */
  #define DMA0_TEE_ALIAS4_BASE_NS                  (0x40084000u)
  /** Peripheral DMA0_TEE_ALIAS4 base pointer */
  #define DMA0_TEE_ALIAS4                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS4_BASE)
  /** Peripheral DMA0_TEE_ALIAS4 base pointer */
  #define DMA0_TEE_ALIAS4_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS4_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS5 base address */
  #define DMA0_TEE_ALIAS5_BASE                     (0x50085000u)
  /** Peripheral DMA0_TEE_ALIAS5 base address */
  #define DMA0_TEE_ALIAS5_BASE_NS                  (0x40085000u)
  /** Peripheral DMA0_TEE_ALIAS5 base pointer */
  #define DMA0_TEE_ALIAS5                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS5_BASE)
  /** Peripheral DMA0_TEE_ALIAS5 base pointer */
  #define DMA0_TEE_ALIAS5_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS5_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS6 base address */
  #define DMA0_TEE_ALIAS6_BASE                     (0x50086000u)
  /** Peripheral DMA0_TEE_ALIAS6 base address */
  #define DMA0_TEE_ALIAS6_BASE_NS                  (0x40086000u)
  /** Peripheral DMA0_TEE_ALIAS6 base pointer */
  #define DMA0_TEE_ALIAS6                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS6_BASE)
  /** Peripheral DMA0_TEE_ALIAS6 base pointer */
  #define DMA0_TEE_ALIAS6_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS6_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS7 base address */
  #define DMA0_TEE_ALIAS7_BASE                     (0x50087000u)
  /** Peripheral DMA0_TEE_ALIAS7 base address */
  #define DMA0_TEE_ALIAS7_BASE_NS                  (0x40087000u)
  /** Peripheral DMA0_TEE_ALIAS7 base pointer */
  #define DMA0_TEE_ALIAS7                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS7_BASE)
  /** Peripheral DMA0_TEE_ALIAS7 base pointer */
  #define DMA0_TEE_ALIAS7_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS7_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS8 base address */
  #define DMA0_TEE_ALIAS8_BASE                     (0x50088000u)
  /** Peripheral DMA0_TEE_ALIAS8 base address */
  #define DMA0_TEE_ALIAS8_BASE_NS                  (0x40088000u)
  /** Peripheral DMA0_TEE_ALIAS8 base pointer */
  #define DMA0_TEE_ALIAS8                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS8_BASE)
  /** Peripheral DMA0_TEE_ALIAS8 base pointer */
  #define DMA0_TEE_ALIAS8_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS8_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS9 base address */
  #define DMA0_TEE_ALIAS9_BASE                     (0x50089000u)
  /** Peripheral DMA0_TEE_ALIAS9 base address */
  #define DMA0_TEE_ALIAS9_BASE_NS                  (0x40089000u)
  /** Peripheral DMA0_TEE_ALIAS9 base pointer */
  #define DMA0_TEE_ALIAS9                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS9_BASE)
  /** Peripheral DMA0_TEE_ALIAS9 base pointer */
  #define DMA0_TEE_ALIAS9_NS                       ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS9_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS10 base address */
  #define DMA0_TEE_ALIAS10_BASE                    (0x5008A000u)
  /** Peripheral DMA0_TEE_ALIAS10 base address */
  #define DMA0_TEE_ALIAS10_BASE_NS                 (0x4008A000u)
  /** Peripheral DMA0_TEE_ALIAS10 base pointer */
  #define DMA0_TEE_ALIAS10                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS10_BASE)
  /** Peripheral DMA0_TEE_ALIAS10 base pointer */
  #define DMA0_TEE_ALIAS10_NS                      ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS10_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS11 base address */
  #define DMA0_TEE_ALIAS11_BASE                    (0x5008B000u)
  /** Peripheral DMA0_TEE_ALIAS11 base address */
  #define DMA0_TEE_ALIAS11_BASE_NS                 (0x4008B000u)
  /** Peripheral DMA0_TEE_ALIAS11 base pointer */
  #define DMA0_TEE_ALIAS11                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS11_BASE)
  /** Peripheral DMA0_TEE_ALIAS11 base pointer */
  #define DMA0_TEE_ALIAS11_NS                      ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS11_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS12 base address */
  #define DMA0_TEE_ALIAS12_BASE                    (0x5008C000u)
  /** Peripheral DMA0_TEE_ALIAS12 base address */
  #define DMA0_TEE_ALIAS12_BASE_NS                 (0x4008C000u)
  /** Peripheral DMA0_TEE_ALIAS12 base pointer */
  #define DMA0_TEE_ALIAS12                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS12_BASE)
  /** Peripheral DMA0_TEE_ALIAS12 base pointer */
  #define DMA0_TEE_ALIAS12_NS                      ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS12_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS13 base address */
  #define DMA0_TEE_ALIAS13_BASE                    (0x5008D000u)
  /** Peripheral DMA0_TEE_ALIAS13 base address */
  #define DMA0_TEE_ALIAS13_BASE_NS                 (0x4008D000u)
  /** Peripheral DMA0_TEE_ALIAS13 base pointer */
  #define DMA0_TEE_ALIAS13                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS13_BASE)
  /** Peripheral DMA0_TEE_ALIAS13 base pointer */
  #define DMA0_TEE_ALIAS13_NS                      ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS13_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS14 base address */
  #define DMA0_TEE_ALIAS14_BASE                    (0x5008E000u)
  /** Peripheral DMA0_TEE_ALIAS14 base address */
  #define DMA0_TEE_ALIAS14_BASE_NS                 (0x4008E000u)
  /** Peripheral DMA0_TEE_ALIAS14 base pointer */
  #define DMA0_TEE_ALIAS14                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS14_BASE)
  /** Peripheral DMA0_TEE_ALIAS14 base pointer */
  #define DMA0_TEE_ALIAS14_NS                      ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS14_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS15 base address */
  #define DMA0_TEE_ALIAS15_BASE                    (0x5008F000u)
  /** Peripheral DMA0_TEE_ALIAS15 base address */
  #define DMA0_TEE_ALIAS15_BASE_NS                 (0x4008F000u)
  /** Peripheral DMA0_TEE_ALIAS15 base pointer */
  #define DMA0_TEE_ALIAS15                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS15_BASE)
  /** Peripheral DMA0_TEE_ALIAS15 base pointer */
  #define DMA0_TEE_ALIAS15_NS                      ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS15_BASE_NS)
  /** Peripheral DMA0_TEE_ALIAS16 base address */
  #define DMA0_TEE_ALIAS16_BASE                    (0x50090000u)
  /** Peripheral DMA0_TEE_ALIAS16 base address */
  #define DMA0_TEE_ALIAS16_BASE_NS                 (0x40090000u)
  /** Peripheral DMA0_TEE_ALIAS16 base pointer */
  #define DMA0_TEE_ALIAS16                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS16_BASE)
  /** Peripheral DMA0_TEE_ALIAS16 base pointer */
  #define DMA0_TEE_ALIAS16_NS                      ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS16_BASE_NS)
  /** Array initializer of DMA0_TEE_ALIAS peripheral base addresses */
  #define DMA0_TEE_ALIAS_BASE_ADDRS                { DMA0_TEE_ALIAS0_BASE, DMA0_TEE_ALIAS1_BASE, DMA0_TEE_ALIAS2_BASE, DMA0_TEE_ALIAS3_BASE, DMA0_TEE_ALIAS4_BASE, DMA0_TEE_ALIAS5_BASE, DMA0_TEE_ALIAS6_BASE, DMA0_TEE_ALIAS7_BASE, DMA0_TEE_ALIAS8_BASE, DMA0_TEE_ALIAS9_BASE, DMA0_TEE_ALIAS10_BASE, DMA0_TEE_ALIAS11_BASE, DMA0_TEE_ALIAS12_BASE, DMA0_TEE_ALIAS13_BASE, DMA0_TEE_ALIAS14_BASE, DMA0_TEE_ALIAS15_BASE, DMA0_TEE_ALIAS16_BASE }
  /** Array initializer of DMA0_TEE_ALIAS peripheral base pointers */
  #define DMA0_TEE_ALIAS_BASE_PTRS                 { DMA0_TEE_ALIAS0, DMA0_TEE_ALIAS1, DMA0_TEE_ALIAS2, DMA0_TEE_ALIAS3, DMA0_TEE_ALIAS4, DMA0_TEE_ALIAS5, DMA0_TEE_ALIAS6, DMA0_TEE_ALIAS7, DMA0_TEE_ALIAS8, DMA0_TEE_ALIAS9, DMA0_TEE_ALIAS10, DMA0_TEE_ALIAS11, DMA0_TEE_ALIAS12, DMA0_TEE_ALIAS13, DMA0_TEE_ALIAS14, DMA0_TEE_ALIAS15, DMA0_TEE_ALIAS16 }
  /** Array initializer of DMA0_TEE_ALIAS peripheral base addresses */
  #define DMA0_TEE_ALIAS_BASE_ADDRS_NS             { DMA0_TEE_ALIAS0_BASE_NS, DMA0_TEE_ALIAS1_BASE_NS, DMA0_TEE_ALIAS2_BASE_NS, DMA0_TEE_ALIAS3_BASE_NS, DMA0_TEE_ALIAS4_BASE_NS, DMA0_TEE_ALIAS5_BASE_NS, DMA0_TEE_ALIAS6_BASE_NS, DMA0_TEE_ALIAS7_BASE_NS, DMA0_TEE_ALIAS8_BASE_NS, DMA0_TEE_ALIAS9_BASE_NS, DMA0_TEE_ALIAS10_BASE_NS, DMA0_TEE_ALIAS11_BASE_NS, DMA0_TEE_ALIAS12_BASE_NS, DMA0_TEE_ALIAS13_BASE_NS, DMA0_TEE_ALIAS14_BASE_NS, DMA0_TEE_ALIAS15_BASE_NS, DMA0_TEE_ALIAS16_BASE_NS }
  /** Array initializer of DMA0_TEE_ALIAS peripheral base pointers */
  #define DMA0_TEE_ALIAS_BASE_PTRS_NS              { DMA0_TEE_ALIAS0_NS, DMA0_TEE_ALIAS1_NS, DMA0_TEE_ALIAS2_NS, DMA0_TEE_ALIAS3_NS, DMA0_TEE_ALIAS4_NS, DMA0_TEE_ALIAS5_NS, DMA0_TEE_ALIAS6_NS, DMA0_TEE_ALIAS7_NS, DMA0_TEE_ALIAS8_NS, DMA0_TEE_ALIAS9_NS, DMA0_TEE_ALIAS10_NS, DMA0_TEE_ALIAS11_NS, DMA0_TEE_ALIAS12_NS, DMA0_TEE_ALIAS13_NS, DMA0_TEE_ALIAS14_NS, DMA0_TEE_ALIAS15_NS, DMA0_TEE_ALIAS16_NS }
#else
  /** Peripheral DMA0_TEE_ALIAS0 base address */
  #define DMA0_TEE_ALIAS0_BASE                     (0x40080000u)
  /** Peripheral DMA0_TEE_ALIAS0 base pointer */
  #define DMA0_TEE_ALIAS0                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS0_BASE)
  /** Peripheral DMA0_TEE_ALIAS1 base address */
  #define DMA0_TEE_ALIAS1_BASE                     (0x40081000u)
  /** Peripheral DMA0_TEE_ALIAS1 base pointer */
  #define DMA0_TEE_ALIAS1                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS1_BASE)
  /** Peripheral DMA0_TEE_ALIAS2 base address */
  #define DMA0_TEE_ALIAS2_BASE                     (0x40082000u)
  /** Peripheral DMA0_TEE_ALIAS2 base pointer */
  #define DMA0_TEE_ALIAS2                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS2_BASE)
  /** Peripheral DMA0_TEE_ALIAS3 base address */
  #define DMA0_TEE_ALIAS3_BASE                     (0x40083000u)
  /** Peripheral DMA0_TEE_ALIAS3 base pointer */
  #define DMA0_TEE_ALIAS3                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS3_BASE)
  /** Peripheral DMA0_TEE_ALIAS4 base address */
  #define DMA0_TEE_ALIAS4_BASE                     (0x40084000u)
  /** Peripheral DMA0_TEE_ALIAS4 base pointer */
  #define DMA0_TEE_ALIAS4                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS4_BASE)
  /** Peripheral DMA0_TEE_ALIAS5 base address */
  #define DMA0_TEE_ALIAS5_BASE                     (0x40085000u)
  /** Peripheral DMA0_TEE_ALIAS5 base pointer */
  #define DMA0_TEE_ALIAS5                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS5_BASE)
  /** Peripheral DMA0_TEE_ALIAS6 base address */
  #define DMA0_TEE_ALIAS6_BASE                     (0x40086000u)
  /** Peripheral DMA0_TEE_ALIAS6 base pointer */
  #define DMA0_TEE_ALIAS6                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS6_BASE)
  /** Peripheral DMA0_TEE_ALIAS7 base address */
  #define DMA0_TEE_ALIAS7_BASE                     (0x40087000u)
  /** Peripheral DMA0_TEE_ALIAS7 base pointer */
  #define DMA0_TEE_ALIAS7                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS7_BASE)
  /** Peripheral DMA0_TEE_ALIAS8 base address */
  #define DMA0_TEE_ALIAS8_BASE                     (0x40088000u)
  /** Peripheral DMA0_TEE_ALIAS8 base pointer */
  #define DMA0_TEE_ALIAS8                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS8_BASE)
  /** Peripheral DMA0_TEE_ALIAS9 base address */
  #define DMA0_TEE_ALIAS9_BASE                     (0x40089000u)
  /** Peripheral DMA0_TEE_ALIAS9 base pointer */
  #define DMA0_TEE_ALIAS9                          ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS9_BASE)
  /** Peripheral DMA0_TEE_ALIAS10 base address */
  #define DMA0_TEE_ALIAS10_BASE                    (0x4008A000u)
  /** Peripheral DMA0_TEE_ALIAS10 base pointer */
  #define DMA0_TEE_ALIAS10                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS10_BASE)
  /** Peripheral DMA0_TEE_ALIAS11 base address */
  #define DMA0_TEE_ALIAS11_BASE                    (0x4008B000u)
  /** Peripheral DMA0_TEE_ALIAS11 base pointer */
  #define DMA0_TEE_ALIAS11                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS11_BASE)
  /** Peripheral DMA0_TEE_ALIAS12 base address */
  #define DMA0_TEE_ALIAS12_BASE                    (0x4008C000u)
  /** Peripheral DMA0_TEE_ALIAS12 base pointer */
  #define DMA0_TEE_ALIAS12                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS12_BASE)
  /** Peripheral DMA0_TEE_ALIAS13 base address */
  #define DMA0_TEE_ALIAS13_BASE                    (0x4008D000u)
  /** Peripheral DMA0_TEE_ALIAS13 base pointer */
  #define DMA0_TEE_ALIAS13                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS13_BASE)
  /** Peripheral DMA0_TEE_ALIAS14 base address */
  #define DMA0_TEE_ALIAS14_BASE                    (0x4008E000u)
  /** Peripheral DMA0_TEE_ALIAS14 base pointer */
  #define DMA0_TEE_ALIAS14                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS14_BASE)
  /** Peripheral DMA0_TEE_ALIAS15 base address */
  #define DMA0_TEE_ALIAS15_BASE                    (0x4008F000u)
  /** Peripheral DMA0_TEE_ALIAS15 base pointer */
  #define DMA0_TEE_ALIAS15                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS15_BASE)
  /** Peripheral DMA0_TEE_ALIAS16 base address */
  #define DMA0_TEE_ALIAS16_BASE                    (0x40090000u)
  /** Peripheral DMA0_TEE_ALIAS16 base pointer */
  #define DMA0_TEE_ALIAS16                         ((DMA0_TEE_ALIAS_Type *)DMA0_TEE_ALIAS16_BASE)
  /** Array initializer of DMA0_TEE_ALIAS peripheral base addresses */
  #define DMA0_TEE_ALIAS_BASE_ADDRS                { DMA0_TEE_ALIAS0_BASE, DMA0_TEE_ALIAS1_BASE, DMA0_TEE_ALIAS2_BASE, DMA0_TEE_ALIAS3_BASE, DMA0_TEE_ALIAS4_BASE, DMA0_TEE_ALIAS5_BASE, DMA0_TEE_ALIAS6_BASE, DMA0_TEE_ALIAS7_BASE, DMA0_TEE_ALIAS8_BASE, DMA0_TEE_ALIAS9_BASE, DMA0_TEE_ALIAS10_BASE, DMA0_TEE_ALIAS11_BASE, DMA0_TEE_ALIAS12_BASE, DMA0_TEE_ALIAS13_BASE, DMA0_TEE_ALIAS14_BASE, DMA0_TEE_ALIAS15_BASE, DMA0_TEE_ALIAS16_BASE }
  /** Array initializer of DMA0_TEE_ALIAS peripheral base pointers */
  #define DMA0_TEE_ALIAS_BASE_PTRS                 { DMA0_TEE_ALIAS0, DMA0_TEE_ALIAS1, DMA0_TEE_ALIAS2, DMA0_TEE_ALIAS3, DMA0_TEE_ALIAS4, DMA0_TEE_ALIAS5, DMA0_TEE_ALIAS6, DMA0_TEE_ALIAS7, DMA0_TEE_ALIAS8, DMA0_TEE_ALIAS9, DMA0_TEE_ALIAS10, DMA0_TEE_ALIAS11, DMA0_TEE_ALIAS12, DMA0_TEE_ALIAS13, DMA0_TEE_ALIAS14, DMA0_TEE_ALIAS15, DMA0_TEE_ALIAS16 }
#endif

/*!
 * @}
 */ /* end of group DMA0_TEE_ALIAS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA1_TEE_ALIAS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA1_TEE_ALIAS_Peripheral_Access_Layer DMA1_TEE_ALIAS Peripheral Access Layer
 * @{
 */

/** DMA1_TEE_ALIAS - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4092];
       uint32_t RESERVED;                          /**< Reserved., offset: 0xFFC */
} DMA1_TEE_ALIAS_Type;

/* ----------------------------------------------------------------------------
   -- DMA1_TEE_ALIAS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA1_TEE_ALIAS_Register_Masks DMA1_TEE_ALIAS Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group DMA1_TEE_ALIAS_Register_Masks */


/* DMA1_TEE_ALIAS - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DMA1_TEE_ALIAS0 base address */
  #define DMA1_TEE_ALIAS0_BASE                     (0x500A0000u)
  /** Peripheral DMA1_TEE_ALIAS0 base address */
  #define DMA1_TEE_ALIAS0_BASE_NS                  (0x400A0000u)
  /** Peripheral DMA1_TEE_ALIAS0 base pointer */
  #define DMA1_TEE_ALIAS0                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS0_BASE)
  /** Peripheral DMA1_TEE_ALIAS0 base pointer */
  #define DMA1_TEE_ALIAS0_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS0_BASE_NS)
  /** Peripheral DMA1_TEE_ALIAS1 base address */
  #define DMA1_TEE_ALIAS1_BASE                     (0x500A1000u)
  /** Peripheral DMA1_TEE_ALIAS1 base address */
  #define DMA1_TEE_ALIAS1_BASE_NS                  (0x400A1000u)
  /** Peripheral DMA1_TEE_ALIAS1 base pointer */
  #define DMA1_TEE_ALIAS1                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS1_BASE)
  /** Peripheral DMA1_TEE_ALIAS1 base pointer */
  #define DMA1_TEE_ALIAS1_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS1_BASE_NS)
  /** Peripheral DMA1_TEE_ALIAS2 base address */
  #define DMA1_TEE_ALIAS2_BASE                     (0x500A2000u)
  /** Peripheral DMA1_TEE_ALIAS2 base address */
  #define DMA1_TEE_ALIAS2_BASE_NS                  (0x400A2000u)
  /** Peripheral DMA1_TEE_ALIAS2 base pointer */
  #define DMA1_TEE_ALIAS2                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS2_BASE)
  /** Peripheral DMA1_TEE_ALIAS2 base pointer */
  #define DMA1_TEE_ALIAS2_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS2_BASE_NS)
  /** Peripheral DMA1_TEE_ALIAS3 base address */
  #define DMA1_TEE_ALIAS3_BASE                     (0x500A3000u)
  /** Peripheral DMA1_TEE_ALIAS3 base address */
  #define DMA1_TEE_ALIAS3_BASE_NS                  (0x400A3000u)
  /** Peripheral DMA1_TEE_ALIAS3 base pointer */
  #define DMA1_TEE_ALIAS3                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS3_BASE)
  /** Peripheral DMA1_TEE_ALIAS3 base pointer */
  #define DMA1_TEE_ALIAS3_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS3_BASE_NS)
  /** Peripheral DMA1_TEE_ALIAS4 base address */
  #define DMA1_TEE_ALIAS4_BASE                     (0x500A4000u)
  /** Peripheral DMA1_TEE_ALIAS4 base address */
  #define DMA1_TEE_ALIAS4_BASE_NS                  (0x400A4000u)
  /** Peripheral DMA1_TEE_ALIAS4 base pointer */
  #define DMA1_TEE_ALIAS4                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS4_BASE)
  /** Peripheral DMA1_TEE_ALIAS4 base pointer */
  #define DMA1_TEE_ALIAS4_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS4_BASE_NS)
  /** Peripheral DMA1_TEE_ALIAS5 base address */
  #define DMA1_TEE_ALIAS5_BASE                     (0x500A5000u)
  /** Peripheral DMA1_TEE_ALIAS5 base address */
  #define DMA1_TEE_ALIAS5_BASE_NS                  (0x400A5000u)
  /** Peripheral DMA1_TEE_ALIAS5 base pointer */
  #define DMA1_TEE_ALIAS5                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS5_BASE)
  /** Peripheral DMA1_TEE_ALIAS5 base pointer */
  #define DMA1_TEE_ALIAS5_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS5_BASE_NS)
  /** Peripheral DMA1_TEE_ALIAS6 base address */
  #define DMA1_TEE_ALIAS6_BASE                     (0x500A6000u)
  /** Peripheral DMA1_TEE_ALIAS6 base address */
  #define DMA1_TEE_ALIAS6_BASE_NS                  (0x400A6000u)
  /** Peripheral DMA1_TEE_ALIAS6 base pointer */
  #define DMA1_TEE_ALIAS6                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS6_BASE)
  /** Peripheral DMA1_TEE_ALIAS6 base pointer */
  #define DMA1_TEE_ALIAS6_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS6_BASE_NS)
  /** Peripheral DMA1_TEE_ALIAS7 base address */
  #define DMA1_TEE_ALIAS7_BASE                     (0x500A7000u)
  /** Peripheral DMA1_TEE_ALIAS7 base address */
  #define DMA1_TEE_ALIAS7_BASE_NS                  (0x400A7000u)
  /** Peripheral DMA1_TEE_ALIAS7 base pointer */
  #define DMA1_TEE_ALIAS7                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS7_BASE)
  /** Peripheral DMA1_TEE_ALIAS7 base pointer */
  #define DMA1_TEE_ALIAS7_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS7_BASE_NS)
  /** Peripheral DMA1_TEE_ALIAS8 base address */
  #define DMA1_TEE_ALIAS8_BASE                     (0x500A8000u)
  /** Peripheral DMA1_TEE_ALIAS8 base address */
  #define DMA1_TEE_ALIAS8_BASE_NS                  (0x400A8000u)
  /** Peripheral DMA1_TEE_ALIAS8 base pointer */
  #define DMA1_TEE_ALIAS8                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS8_BASE)
  /** Peripheral DMA1_TEE_ALIAS8 base pointer */
  #define DMA1_TEE_ALIAS8_NS                       ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS8_BASE_NS)
  /** Array initializer of DMA1_TEE_ALIAS peripheral base addresses */
  #define DMA1_TEE_ALIAS_BASE_ADDRS                { DMA1_TEE_ALIAS0_BASE, DMA1_TEE_ALIAS1_BASE, DMA1_TEE_ALIAS2_BASE, DMA1_TEE_ALIAS3_BASE, DMA1_TEE_ALIAS4_BASE, DMA1_TEE_ALIAS5_BASE, DMA1_TEE_ALIAS6_BASE, DMA1_TEE_ALIAS7_BASE, DMA1_TEE_ALIAS8_BASE }
  /** Array initializer of DMA1_TEE_ALIAS peripheral base pointers */
  #define DMA1_TEE_ALIAS_BASE_PTRS                 { DMA1_TEE_ALIAS0, DMA1_TEE_ALIAS1, DMA1_TEE_ALIAS2, DMA1_TEE_ALIAS3, DMA1_TEE_ALIAS4, DMA1_TEE_ALIAS5, DMA1_TEE_ALIAS6, DMA1_TEE_ALIAS7, DMA1_TEE_ALIAS8 }
  /** Array initializer of DMA1_TEE_ALIAS peripheral base addresses */
  #define DMA1_TEE_ALIAS_BASE_ADDRS_NS             { DMA1_TEE_ALIAS0_BASE_NS, DMA1_TEE_ALIAS1_BASE_NS, DMA1_TEE_ALIAS2_BASE_NS, DMA1_TEE_ALIAS3_BASE_NS, DMA1_TEE_ALIAS4_BASE_NS, DMA1_TEE_ALIAS5_BASE_NS, DMA1_TEE_ALIAS6_BASE_NS, DMA1_TEE_ALIAS7_BASE_NS, DMA1_TEE_ALIAS8_BASE_NS }
  /** Array initializer of DMA1_TEE_ALIAS peripheral base pointers */
  #define DMA1_TEE_ALIAS_BASE_PTRS_NS              { DMA1_TEE_ALIAS0_NS, DMA1_TEE_ALIAS1_NS, DMA1_TEE_ALIAS2_NS, DMA1_TEE_ALIAS3_NS, DMA1_TEE_ALIAS4_NS, DMA1_TEE_ALIAS5_NS, DMA1_TEE_ALIAS6_NS, DMA1_TEE_ALIAS7_NS, DMA1_TEE_ALIAS8_NS }
#else
  /** Peripheral DMA1_TEE_ALIAS0 base address */
  #define DMA1_TEE_ALIAS0_BASE                     (0x400A0000u)
  /** Peripheral DMA1_TEE_ALIAS0 base pointer */
  #define DMA1_TEE_ALIAS0                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS0_BASE)
  /** Peripheral DMA1_TEE_ALIAS1 base address */
  #define DMA1_TEE_ALIAS1_BASE                     (0x400A1000u)
  /** Peripheral DMA1_TEE_ALIAS1 base pointer */
  #define DMA1_TEE_ALIAS1                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS1_BASE)
  /** Peripheral DMA1_TEE_ALIAS2 base address */
  #define DMA1_TEE_ALIAS2_BASE                     (0x400A2000u)
  /** Peripheral DMA1_TEE_ALIAS2 base pointer */
  #define DMA1_TEE_ALIAS2                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS2_BASE)
  /** Peripheral DMA1_TEE_ALIAS3 base address */
  #define DMA1_TEE_ALIAS3_BASE                     (0x400A3000u)
  /** Peripheral DMA1_TEE_ALIAS3 base pointer */
  #define DMA1_TEE_ALIAS3                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS3_BASE)
  /** Peripheral DMA1_TEE_ALIAS4 base address */
  #define DMA1_TEE_ALIAS4_BASE                     (0x400A4000u)
  /** Peripheral DMA1_TEE_ALIAS4 base pointer */
  #define DMA1_TEE_ALIAS4                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS4_BASE)
  /** Peripheral DMA1_TEE_ALIAS5 base address */
  #define DMA1_TEE_ALIAS5_BASE                     (0x400A5000u)
  /** Peripheral DMA1_TEE_ALIAS5 base pointer */
  #define DMA1_TEE_ALIAS5                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS5_BASE)
  /** Peripheral DMA1_TEE_ALIAS6 base address */
  #define DMA1_TEE_ALIAS6_BASE                     (0x400A6000u)
  /** Peripheral DMA1_TEE_ALIAS6 base pointer */
  #define DMA1_TEE_ALIAS6                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS6_BASE)
  /** Peripheral DMA1_TEE_ALIAS7 base address */
  #define DMA1_TEE_ALIAS7_BASE                     (0x400A7000u)
  /** Peripheral DMA1_TEE_ALIAS7 base pointer */
  #define DMA1_TEE_ALIAS7                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS7_BASE)
  /** Peripheral DMA1_TEE_ALIAS8 base address */
  #define DMA1_TEE_ALIAS8_BASE                     (0x400A8000u)
  /** Peripheral DMA1_TEE_ALIAS8 base pointer */
  #define DMA1_TEE_ALIAS8                          ((DMA1_TEE_ALIAS_Type *)DMA1_TEE_ALIAS8_BASE)
  /** Array initializer of DMA1_TEE_ALIAS peripheral base addresses */
  #define DMA1_TEE_ALIAS_BASE_ADDRS                { DMA1_TEE_ALIAS0_BASE, DMA1_TEE_ALIAS1_BASE, DMA1_TEE_ALIAS2_BASE, DMA1_TEE_ALIAS3_BASE, DMA1_TEE_ALIAS4_BASE, DMA1_TEE_ALIAS5_BASE, DMA1_TEE_ALIAS6_BASE, DMA1_TEE_ALIAS7_BASE, DMA1_TEE_ALIAS8_BASE }
  /** Array initializer of DMA1_TEE_ALIAS peripheral base pointers */
  #define DMA1_TEE_ALIAS_BASE_PTRS                 { DMA1_TEE_ALIAS0, DMA1_TEE_ALIAS1, DMA1_TEE_ALIAS2, DMA1_TEE_ALIAS3, DMA1_TEE_ALIAS4, DMA1_TEE_ALIAS5, DMA1_TEE_ALIAS6, DMA1_TEE_ALIAS7, DMA1_TEE_ALIAS8 }
#endif

/*!
 * @}
 */ /* end of group DMA1_TEE_ALIAS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Peripheral_Access_Layer EIM Peripheral Access Layer
 * @{
 */

/** EIM - Register Layout Typedef */
typedef struct {
  __IO uint32_t EIMCR;                             /**< Error Injection Module Configuration Register, offset: 0x0 */
  __IO uint32_t EICHEN;                            /**< Error Injection Channel Enable register, offset: 0x4 */
       uint8_t RESERVED_0[248];
  __IO uint32_t EICHD0_WORD0;                      /**< Error Injection Channel Descriptor 0, Word0, offset: 0x100 */
  __IO uint32_t EICHD0_WORD1;                      /**< Error Injection Channel Descriptor 0, Word1, offset: 0x104 */
       uint8_t RESERVED_1[56];
  __IO uint32_t EICHD1_WORD0;                      /**< Error Injection Channel Descriptor 1, Word0, offset: 0x140 */
  __IO uint32_t EICHD1_WORD1;                      /**< Error Injection Channel Descriptor 1, Word1, offset: 0x144 */
       uint8_t RESERVED_2[56];
  __IO uint32_t EICHD2_WORD0;                      /**< Error Injection Channel Descriptor 2, Word0, offset: 0x180 */
  __IO uint32_t EICHD2_WORD1;                      /**< Error Injection Channel Descriptor 2, Word1, offset: 0x184 */
       uint8_t RESERVED_3[56];
  __IO uint32_t EICHD3_WORD0;                      /**< Error Injection Channel Descriptor 3, Word0, offset: 0x1C0 */
  __IO uint32_t EICHD3_WORD1;                      /**< Error Injection Channel Descriptor 3, Word1, offset: 0x1C4 */
       uint8_t RESERVED_4[56];
  __IO uint32_t EICHD4_WORD0;                      /**< Error Injection Channel Descriptor 4, Word0, offset: 0x200 */
  __IO uint32_t EICHD4_WORD1;                      /**< Error Injection Channel Descriptor 4, Word1, offset: 0x204 */
       uint8_t RESERVED_5[56];
  __IO uint32_t EICHD5_WORD0;                      /**< Error Injection Channel Descriptor 5, Word0, offset: 0x240 */
  __IO uint32_t EICHD5_WORD1;                      /**< Error Injection Channel Descriptor 5, Word1, offset: 0x244 */
       uint8_t RESERVED_6[56];
  __IO uint32_t EICHD6_WORD0;                      /**< Error Injection Channel Descriptor 6, Word0, offset: 0x280 */
  __IO uint32_t EICHD6_WORD1;                      /**< Error Injection Channel Descriptor 6, Word1, offset: 0x284 */
       uint8_t RESERVED_7[56];
  __IO uint32_t EICHD7_WORD0;                      /**< Error Injection Channel Descriptor 7, Word0, offset: 0x2C0 */
  __IO uint32_t EICHD7_WORD1;                      /**< Error Injection Channel Descriptor 7, Word1, offset: 0x2C4 */
       uint8_t RESERVED_8[56];
  __IO uint32_t EICHD8_WORD0;                      /**< Error Injection Channel Descriptor 8, Word0, offset: 0x300 */
  __IO uint32_t EICHD8_WORD1;                      /**< Error Injection Channel Descriptor 8, Word1, offset: 0x304 */
} EIM_Type;

/* ----------------------------------------------------------------------------
   -- EIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Register_Masks EIM Register Masks
 * @{
 */

/*! @name EIMCR - Error Injection Module Configuration Register */
/*! @{ */

#define EIM_EIMCR_GEIEN_MASK                     (0x1U)
#define EIM_EIMCR_GEIEN_SHIFT                    (0U)
/*! GEIEN - Global Error Injection Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EIM_EIMCR_GEIEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_EIMCR_GEIEN_SHIFT)) & EIM_EIMCR_GEIEN_MASK)
/*! @} */

/*! @name EICHEN - Error Injection Channel Enable register */
/*! @{ */

#define EIM_EICHEN_EICH8EN_MASK                  (0x800000U)
#define EIM_EICHEN_EICH8EN_SHIFT                 (23U)
/*! EICH8EN - Error Injection Channel 8 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 8
 *  0b1..Error injection is enabled on Error Injection Channel 8
 */
#define EIM_EICHEN_EICH8EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH8EN_SHIFT)) & EIM_EICHEN_EICH8EN_MASK)

#define EIM_EICHEN_EICH7EN_MASK                  (0x1000000U)
#define EIM_EICHEN_EICH7EN_SHIFT                 (24U)
/*! EICH7EN - Error Injection Channel 7 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 7
 *  0b1..Error injection is enabled on Error Injection Channel 7
 */
#define EIM_EICHEN_EICH7EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH7EN_SHIFT)) & EIM_EICHEN_EICH7EN_MASK)

#define EIM_EICHEN_EICH6EN_MASK                  (0x2000000U)
#define EIM_EICHEN_EICH6EN_SHIFT                 (25U)
/*! EICH6EN - Error Injection Channel 6 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 6
 *  0b1..Error injection is enabled on Error Injection Channel 6
 */
#define EIM_EICHEN_EICH6EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH6EN_SHIFT)) & EIM_EICHEN_EICH6EN_MASK)

#define EIM_EICHEN_EICH5EN_MASK                  (0x4000000U)
#define EIM_EICHEN_EICH5EN_SHIFT                 (26U)
/*! EICH5EN - Error Injection Channel 5 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 5
 *  0b1..Error injection is enabled on Error Injection Channel 5
 */
#define EIM_EICHEN_EICH5EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH5EN_SHIFT)) & EIM_EICHEN_EICH5EN_MASK)

#define EIM_EICHEN_EICH4EN_MASK                  (0x8000000U)
#define EIM_EICHEN_EICH4EN_SHIFT                 (27U)
/*! EICH4EN - Error Injection Channel 4 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 4
 *  0b1..Error injection is enabled on Error Injection Channel 4
 */
#define EIM_EICHEN_EICH4EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH4EN_SHIFT)) & EIM_EICHEN_EICH4EN_MASK)

#define EIM_EICHEN_EICH3EN_MASK                  (0x10000000U)
#define EIM_EICHEN_EICH3EN_SHIFT                 (28U)
/*! EICH3EN - Error Injection Channel 3 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 3
 *  0b1..Error injection is enabled on Error Injection Channel 3
 */
#define EIM_EICHEN_EICH3EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH3EN_SHIFT)) & EIM_EICHEN_EICH3EN_MASK)

#define EIM_EICHEN_EICH2EN_MASK                  (0x20000000U)
#define EIM_EICHEN_EICH2EN_SHIFT                 (29U)
/*! EICH2EN - Error Injection Channel 2 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 2
 *  0b1..Error injection is enabled on Error Injection Channel 2
 */
#define EIM_EICHEN_EICH2EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH2EN_SHIFT)) & EIM_EICHEN_EICH2EN_MASK)

#define EIM_EICHEN_EICH1EN_MASK                  (0x40000000U)
#define EIM_EICHEN_EICH1EN_SHIFT                 (30U)
/*! EICH1EN - Error Injection Channel 1 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 1
 *  0b1..Error injection is enabled on Error Injection Channel 1
 */
#define EIM_EICHEN_EICH1EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH1EN_SHIFT)) & EIM_EICHEN_EICH1EN_MASK)

#define EIM_EICHEN_EICH0EN_MASK                  (0x80000000U)
#define EIM_EICHEN_EICH0EN_SHIFT                 (31U)
/*! EICH0EN - Error Injection Channel 0 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 0
 *  0b1..Error injection is enabled on Error Injection Channel 0
 */
#define EIM_EICHEN_EICH0EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH0EN_SHIFT)) & EIM_EICHEN_EICH0EN_MASK)
/*! @} */

/*! @name EICHD0_WORD0 - Error Injection Channel Descriptor 0, Word0 */
/*! @{ */

#define EIM_EICHD0_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD0_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD0_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD0_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD0_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD0_WORD1 - Error Injection Channel Descriptor 0, Word1 */
/*! @{ */

#define EIM_EICHD0_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD0_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD0_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD0_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD0_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD1_WORD0 - Error Injection Channel Descriptor 1, Word0 */
/*! @{ */

#define EIM_EICHD1_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD1_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD1_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD1_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD1_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD1_WORD1 - Error Injection Channel Descriptor 1, Word1 */
/*! @{ */

#define EIM_EICHD1_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD1_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD1_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD1_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD1_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD2_WORD0 - Error Injection Channel Descriptor 2, Word0 */
/*! @{ */

#define EIM_EICHD2_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD2_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD2_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD2_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD2_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD2_WORD1 - Error Injection Channel Descriptor 2, Word1 */
/*! @{ */

#define EIM_EICHD2_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD2_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD2_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD2_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD2_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD3_WORD0 - Error Injection Channel Descriptor 3, Word0 */
/*! @{ */

#define EIM_EICHD3_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD3_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD3_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD3_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD3_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD3_WORD1 - Error Injection Channel Descriptor 3, Word1 */
/*! @{ */

#define EIM_EICHD3_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD3_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD3_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD3_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD3_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD4_WORD0 - Error Injection Channel Descriptor 4, Word0 */
/*! @{ */

#define EIM_EICHD4_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD4_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD4_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD4_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD4_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD4_WORD1 - Error Injection Channel Descriptor 4, Word1 */
/*! @{ */

#define EIM_EICHD4_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD4_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD4_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD4_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD4_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD5_WORD0 - Error Injection Channel Descriptor 5, Word0 */
/*! @{ */

#define EIM_EICHD5_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD5_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD5_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD5_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD5_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD5_WORD1 - Error Injection Channel Descriptor 5, Word1 */
/*! @{ */

#define EIM_EICHD5_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD5_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD5_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD5_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD5_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD6_WORD0 - Error Injection Channel Descriptor 6, Word0 */
/*! @{ */

#define EIM_EICHD6_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD6_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD6_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD6_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD6_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD6_WORD1 - Error Injection Channel Descriptor 6, Word1 */
/*! @{ */

#define EIM_EICHD6_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD6_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD6_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD6_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD6_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD7_WORD0 - Error Injection Channel Descriptor 7, Word0 */
/*! @{ */

#define EIM_EICHD7_WORD0_CHKBIT_MASK_MASK        (0x80000000U)
#define EIM_EICHD7_WORD0_CHKBIT_MASK_SHIFT       (31U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD7_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD7_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD7_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD7_WORD1 - Error Injection Channel Descriptor 7, Word1 */
/*! @{ */

#define EIM_EICHD7_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD7_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD7_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD7_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD7_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD8_WORD0 - Error Injection Channel Descriptor 8, Word0 */
/*! @{ */

#define EIM_EICHD8_WORD0_CHKBIT_MASK_MASK        (0xF0000000U)
#define EIM_EICHD8_WORD0_CHKBIT_MASK_SHIFT       (28U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD8_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD8_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD8_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD8_WORD1 - Error Injection Channel Descriptor 8, Word1 */
/*! @{ */

#define EIM_EICHD8_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD8_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD8_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD8_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD8_WORD1_B0_3DATA_MASK_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group EIM_Register_Masks */


/* EIM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral EIM0 base address */
  #define EIM0_BASE                                (0x5005B000u)
  /** Peripheral EIM0 base address */
  #define EIM0_BASE_NS                             (0x4005B000u)
  /** Peripheral EIM0 base pointer */
  #define EIM0                                     ((EIM_Type *)EIM0_BASE)
  /** Peripheral EIM0 base pointer */
  #define EIM0_NS                                  ((EIM_Type *)EIM0_BASE_NS)
  /** Array initializer of EIM peripheral base addresses */
  #define EIM_BASE_ADDRS                           { EIM0_BASE }
  /** Array initializer of EIM peripheral base pointers */
  #define EIM_BASE_PTRS                            { EIM0 }
  /** Array initializer of EIM peripheral base addresses */
  #define EIM_BASE_ADDRS_NS                        { EIM0_BASE_NS }
  /** Array initializer of EIM peripheral base pointers */
  #define EIM_BASE_PTRS_NS                         { EIM0_NS }
#else
  /** Peripheral EIM0 base address */
  #define EIM0_BASE                                (0x4005B000u)
  /** Peripheral EIM0 base pointer */
  #define EIM0                                     ((EIM_Type *)EIM0_BASE)
  /** Array initializer of EIM peripheral base addresses */
  #define EIM_BASE_ADDRS                           { EIM0_BASE }
  /** Array initializer of EIM peripheral base pointers */
  #define EIM_BASE_PTRS                            { EIM0 }
#endif

/*!
 * @}
 */ /* end of group EIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ENC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Peripheral_Access_Layer ENC Peripheral Access Layer
 * @{
 */

/** ENC - Register Layout Typedef */
typedef struct {
  __IO uint16_t CTRL;                              /**< Control, offset: 0x0 */
  __IO uint16_t FILT;                              /**< Input Filter, offset: 0x2 */
  __IO uint16_t WTR;                               /**< Watchdog Timeout, offset: 0x4 */
  __IO uint16_t POSD;                              /**< Position Difference Counter, offset: 0x6 */
  __I  uint16_t POSDH;                             /**< Position Difference Hold, offset: 0x8 */
  __IO uint16_t REV;                               /**< Revolution Counter, offset: 0xA */
  __I  uint16_t REVH;                              /**< Revolution Hold, offset: 0xC */
  __IO uint16_t UPOS;                              /**< Upper Position Counter, offset: 0xE */
  __IO uint16_t LPOS;                              /**< Lower Position Counter, offset: 0x10 */
  __I  uint16_t UPOSH;                             /**< Upper Position Hold, offset: 0x12 */
  __I  uint16_t LPOSH;                             /**< Lower Position Hold, offset: 0x14 */
  __IO uint16_t UINIT;                             /**< Upper Initialization, offset: 0x16 */
  __IO uint16_t LINIT;                             /**< Lower Initialization, offset: 0x18 */
  __I  uint16_t IMR;                               /**< Input Monitor, offset: 0x1A */
  __IO uint16_t TST;                               /**< Test, offset: 0x1C */
  __IO uint16_t CTRL2;                             /**< Control 2, offset: 0x1E */
  __IO uint16_t UMOD;                              /**< Upper Modulus, offset: 0x20 */
  __IO uint16_t LMOD;                              /**< Lower Modulus, offset: 0x22 */
  __IO uint16_t UCOMP;                             /**< Upper Position Compare, offset: 0x24 */
  __IO uint16_t LCOMP;                             /**< Lower Position Compare, offset: 0x26 */
  __I  uint16_t LASTEDGE;                          /**< Last Edge Time, offset: 0x28 */
  __I  uint16_t LASTEDGEH;                         /**< Last Edge Time Hold, offset: 0x2A */
  __I  uint16_t POSDPER;                           /**< Position Difference Period Counter, offset: 0x2C */
  __I  uint16_t POSDPERBFR;                        /**< Position Difference Period Buffer, offset: 0x2E */
  __I  uint16_t POSDPERH;                          /**< Position Difference Period Hold, offset: 0x30 */
  __IO uint16_t CTRL3;                             /**< Control 3, offset: 0x32 */
} ENC_Type;

/* ----------------------------------------------------------------------------
   -- ENC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Register_Masks ENC Register Masks
 * @{
 */

/*! @name CTRL - Control */
/*! @{ */

#define ENC_CTRL_CMPIE_MASK                      (0x1U)
#define ENC_CTRL_CMPIE_SHIFT                     (0U)
/*! CMPIE - Compare Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_CMPIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_CMPIE_SHIFT)) & ENC_CTRL_CMPIE_MASK)

#define ENC_CTRL_CMPIRQ_MASK                     (0x2U)
#define ENC_CTRL_CMPIRQ_SHIFT                    (1U)
/*! CMPIRQ - Compare Interrupt Request
 *  0b0..No match has occurred
 *  0b1..COMP match has occurred
 */
#define ENC_CTRL_CMPIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_CMPIRQ_SHIFT)) & ENC_CTRL_CMPIRQ_MASK)

#define ENC_CTRL_WDE_MASK                        (0x4U)
#define ENC_CTRL_WDE_SHIFT                       (2U)
/*! WDE - Watchdog Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_WDE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_WDE_SHIFT)) & ENC_CTRL_WDE_MASK)

#define ENC_CTRL_DIE_MASK                        (0x8U)
#define ENC_CTRL_DIE_SHIFT                       (3U)
/*! DIE - Watchdog Timeout Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_DIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_DIE_SHIFT)) & ENC_CTRL_DIE_MASK)

#define ENC_CTRL_DIRQ_MASK                       (0x10U)
#define ENC_CTRL_DIRQ_SHIFT                      (4U)
/*! DIRQ - Watchdog Timeout Interrupt Request
 *  0b0..Not occurred
 *  0b1..Occurred
 */
#define ENC_CTRL_DIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_DIRQ_SHIFT)) & ENC_CTRL_DIRQ_MASK)

#define ENC_CTRL_XNE_MASK                        (0x20U)
#define ENC_CTRL_XNE_SHIFT                       (5U)
/*! XNE - Select Positive and Negative Edge of INDEX Pulse
 *  0b0..Use positive edge
 *  0b1..Use negative edge
 */
#define ENC_CTRL_XNE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XNE_SHIFT)) & ENC_CTRL_XNE_MASK)

#define ENC_CTRL_XIP_MASK                        (0x40U)
#define ENC_CTRL_XIP_SHIFT                       (6U)
/*! XIP - INDEX Triggered Initialization of Position Counters UPOS and LPOS
 *  0b0..Does not initialize
 *  0b1..Initializes
 */
#define ENC_CTRL_XIP(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIP_SHIFT)) & ENC_CTRL_XIP_MASK)

#define ENC_CTRL_XIE_MASK                        (0x80U)
#define ENC_CTRL_XIE_SHIFT                       (7U)
/*! XIE - INDEX Pulse Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_XIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIE_SHIFT)) & ENC_CTRL_XIE_MASK)

#define ENC_CTRL_XIRQ_MASK                       (0x100U)
#define ENC_CTRL_XIRQ_SHIFT                      (8U)
/*! XIRQ - INDEX Pulse Interrupt Request
 *  0b0..Not occurred
 *  0b1..Occurred
 */
#define ENC_CTRL_XIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIRQ_SHIFT)) & ENC_CTRL_XIRQ_MASK)

#define ENC_CTRL_PH1_MASK                        (0x200U)
#define ENC_CTRL_PH1_SHIFT                       (9U)
/*! PH1 - Enable Signal Phase Count Mode
 *  0b0..Uses the standard quadrature decoder, where PHASEA and PHASEB represent a two-phase quadrature signal.
 *  0b1..Bypasses the quadrature decoder. A positive transition of the PHASEA input generates a count signal.
 *       PHASEB input and CTRL[REV] controls the counter direction. If the value of CTRL[REV] and PHASEB are identical;
 *       then count is up. If the value of CTRL[REV] and PHASEB is different, then count is down.
 */
#define ENC_CTRL_PH1(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_PH1_SHIFT)) & ENC_CTRL_PH1_MASK)

#define ENC_CTRL_REV_MASK                        (0x400U)
#define ENC_CTRL_REV_SHIFT                       (10U)
/*! REV - Enable Reverse Direction Counting
 *  0b0..Counts normally
 *  0b1..Counts in the reverse direction
 */
#define ENC_CTRL_REV(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_REV_SHIFT)) & ENC_CTRL_REV_MASK)

#define ENC_CTRL_SWIP_MASK                       (0x800U)
#define ENC_CTRL_SWIP_SHIFT                      (11U)
/*! SWIP - Software-Triggered Initialization of Position Counters UPOS and LPOS
 *  0b0..No action
 *  0b1..Initialize position counter
 */
#define ENC_CTRL_SWIP(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_SWIP_SHIFT)) & ENC_CTRL_SWIP_MASK)

#define ENC_CTRL_HNE_MASK                        (0x1000U)
#define ENC_CTRL_HNE_SHIFT                       (12U)
/*! HNE - Use Negative Edge of HOME Input
 *  0b0..Use positive-going edge-to-trigger initialization of position counters UPOS and LPOS
 *  0b1..Use negative-going edge-to-trigger initialization of position counters UPOS and LPOS
 */
#define ENC_CTRL_HNE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HNE_SHIFT)) & ENC_CTRL_HNE_MASK)

#define ENC_CTRL_HIP_MASK                        (0x2000U)
#define ENC_CTRL_HIP_SHIFT                       (13U)
/*! HIP - Enable HOME to Initialize Position Counters UPOS and LPOS
 *  0b0..No action
 *  0b1..HOME signal initializes the position counter
 */
#define ENC_CTRL_HIP(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIP_SHIFT)) & ENC_CTRL_HIP_MASK)

#define ENC_CTRL_HIE_MASK                        (0x4000U)
#define ENC_CTRL_HIE_SHIFT                       (14U)
/*! HIE - HOME Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_HIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIE_SHIFT)) & ENC_CTRL_HIE_MASK)

#define ENC_CTRL_HIRQ_MASK                       (0x8000U)
#define ENC_CTRL_HIRQ_SHIFT                      (15U)
/*! HIRQ - HOME Signal Transition Interrupt Request
 *  0b0..Not occurred
 *  0b1..Occurred
 */
#define ENC_CTRL_HIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIRQ_SHIFT)) & ENC_CTRL_HIRQ_MASK)
/*! @} */

/*! @name FILT - Input Filter */
/*! @{ */

#define ENC_FILT_FILT_PER_MASK                   (0xFFU)
#define ENC_FILT_FILT_PER_SHIFT                  (0U)
/*! FILT_PER - Input Filter Sample Period */
#define ENC_FILT_FILT_PER(x)                     (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_PER_SHIFT)) & ENC_FILT_FILT_PER_MASK)

#define ENC_FILT_FILT_CNT_MASK                   (0x700U)
#define ENC_FILT_FILT_CNT_SHIFT                  (8U)
/*! FILT_CNT - Input Filter Sample Count */
#define ENC_FILT_FILT_CNT(x)                     (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_CNT_SHIFT)) & ENC_FILT_FILT_CNT_MASK)

#define ENC_FILT_FILT_PRSC_MASK                  (0xE000U)
#define ENC_FILT_FILT_PRSC_SHIFT                 (13U)
/*! FILT_PRSC - Prescaler Divide IPBus Clock to FILT Clock */
#define ENC_FILT_FILT_PRSC(x)                    (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_PRSC_SHIFT)) & ENC_FILT_FILT_PRSC_MASK)
/*! @} */

/*! @name WTR - Watchdog Timeout */
/*! @{ */

#define ENC_WTR_WDOG_MASK                        (0xFFFFU)
#define ENC_WTR_WDOG_SHIFT                       (0U)
/*! WDOG - WDOG */
#define ENC_WTR_WDOG(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_WTR_WDOG_SHIFT)) & ENC_WTR_WDOG_MASK)
/*! @} */

/*! @name POSD - Position Difference Counter */
/*! @{ */

#define ENC_POSD_POSD_MASK                       (0xFFFFU)
#define ENC_POSD_POSD_SHIFT                      (0U)
/*! POSD - POSD */
#define ENC_POSD_POSD(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_POSD_POSD_SHIFT)) & ENC_POSD_POSD_MASK)
/*! @} */

/*! @name POSDH - Position Difference Hold */
/*! @{ */

#define ENC_POSDH_POSDH_MASK                     (0xFFFFU)
#define ENC_POSDH_POSDH_SHIFT                    (0U)
/*! POSDH - POSDH */
#define ENC_POSDH_POSDH(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_POSDH_POSDH_SHIFT)) & ENC_POSDH_POSDH_MASK)
/*! @} */

/*! @name REV - Revolution Counter */
/*! @{ */

#define ENC_REV_REV_MASK                         (0xFFFFU)
#define ENC_REV_REV_SHIFT                        (0U)
/*! REV - REV */
#define ENC_REV_REV(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_REV_REV_SHIFT)) & ENC_REV_REV_MASK)
/*! @} */

/*! @name REVH - Revolution Hold */
/*! @{ */

#define ENC_REVH_REVH_MASK                       (0xFFFFU)
#define ENC_REVH_REVH_SHIFT                      (0U)
/*! REVH - REVH */
#define ENC_REVH_REVH(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_REVH_REVH_SHIFT)) & ENC_REVH_REVH_MASK)
/*! @} */

/*! @name UPOS - Upper Position Counter */
/*! @{ */

#define ENC_UPOS_POS_MASK                        (0xFFFFU)
#define ENC_UPOS_POS_SHIFT                       (0U)
/*! POS - POS */
#define ENC_UPOS_POS(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_UPOS_POS_SHIFT)) & ENC_UPOS_POS_MASK)
/*! @} */

/*! @name LPOS - Lower Position Counter */
/*! @{ */

#define ENC_LPOS_POS_MASK                        (0xFFFFU)
#define ENC_LPOS_POS_SHIFT                       (0U)
/*! POS - POS */
#define ENC_LPOS_POS(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_LPOS_POS_SHIFT)) & ENC_LPOS_POS_MASK)
/*! @} */

/*! @name UPOSH - Upper Position Hold */
/*! @{ */

#define ENC_UPOSH_POSH_MASK                      (0xFFFFU)
#define ENC_UPOSH_POSH_SHIFT                     (0U)
/*! POSH - POSH */
#define ENC_UPOSH_POSH(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UPOSH_POSH_SHIFT)) & ENC_UPOSH_POSH_MASK)
/*! @} */

/*! @name LPOSH - Lower Position Hold */
/*! @{ */

#define ENC_LPOSH_POSH_MASK                      (0xFFFFU)
#define ENC_LPOSH_POSH_SHIFT                     (0U)
/*! POSH - POSH */
#define ENC_LPOSH_POSH(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LPOSH_POSH_SHIFT)) & ENC_LPOSH_POSH_MASK)
/*! @} */

/*! @name UINIT - Upper Initialization */
/*! @{ */

#define ENC_UINIT_INIT_MASK                      (0xFFFFU)
#define ENC_UINIT_INIT_SHIFT                     (0U)
/*! INIT - INIT */
#define ENC_UINIT_INIT(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UINIT_INIT_SHIFT)) & ENC_UINIT_INIT_MASK)
/*! @} */

/*! @name LINIT - Lower Initialization */
/*! @{ */

#define ENC_LINIT_INIT_MASK                      (0xFFFFU)
#define ENC_LINIT_INIT_SHIFT                     (0U)
/*! INIT - INIT */
#define ENC_LINIT_INIT(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LINIT_INIT_SHIFT)) & ENC_LINIT_INIT_MASK)
/*! @} */

/*! @name IMR - Input Monitor */
/*! @{ */

#define ENC_IMR_HOME_MASK                        (0x1U)
#define ENC_IMR_HOME_SHIFT                       (0U)
/*! HOME - HOME */
#define ENC_IMR_HOME(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_HOME_SHIFT)) & ENC_IMR_HOME_MASK)

#define ENC_IMR_INDEX_MASK                       (0x2U)
#define ENC_IMR_INDEX_SHIFT                      (1U)
/*! INDEX - INDEX */
#define ENC_IMR_INDEX(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_IMR_INDEX_SHIFT)) & ENC_IMR_INDEX_MASK)

#define ENC_IMR_PHB_MASK                         (0x4U)
#define ENC_IMR_PHB_SHIFT                        (2U)
/*! PHB - PHB */
#define ENC_IMR_PHB(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_IMR_PHB_SHIFT)) & ENC_IMR_PHB_MASK)

#define ENC_IMR_PHA_MASK                         (0x8U)
#define ENC_IMR_PHA_SHIFT                        (3U)
/*! PHA - PHA */
#define ENC_IMR_PHA(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_IMR_PHA_SHIFT)) & ENC_IMR_PHA_MASK)

#define ENC_IMR_FHOM_MASK                        (0x10U)
#define ENC_IMR_FHOM_SHIFT                       (4U)
/*! FHOM - FHOM */
#define ENC_IMR_FHOM(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FHOM_SHIFT)) & ENC_IMR_FHOM_MASK)

#define ENC_IMR_FIND_MASK                        (0x20U)
#define ENC_IMR_FIND_SHIFT                       (5U)
/*! FIND - FIND */
#define ENC_IMR_FIND(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FIND_SHIFT)) & ENC_IMR_FIND_MASK)

#define ENC_IMR_FPHB_MASK                        (0x40U)
#define ENC_IMR_FPHB_SHIFT                       (6U)
/*! FPHB - FPHB */
#define ENC_IMR_FPHB(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FPHB_SHIFT)) & ENC_IMR_FPHB_MASK)

#define ENC_IMR_FPHA_MASK                        (0x80U)
#define ENC_IMR_FPHA_SHIFT                       (7U)
/*! FPHA - FPHA */
#define ENC_IMR_FPHA(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FPHA_SHIFT)) & ENC_IMR_FPHA_MASK)
/*! @} */

/*! @name TST - Test */
/*! @{ */

#define ENC_TST_TEST_COUNT_MASK                  (0xFFU)
#define ENC_TST_TEST_COUNT_SHIFT                 (0U)
/*! TEST_COUNT - TEST_COUNT */
#define ENC_TST_TEST_COUNT(x)                    (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEST_COUNT_SHIFT)) & ENC_TST_TEST_COUNT_MASK)

#define ENC_TST_TEST_PERIOD_MASK                 (0x1F00U)
#define ENC_TST_TEST_PERIOD_SHIFT                (8U)
/*! TEST_PERIOD - TEST_PERIOD */
#define ENC_TST_TEST_PERIOD(x)                   (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEST_PERIOD_SHIFT)) & ENC_TST_TEST_PERIOD_MASK)

#define ENC_TST_QDN_MASK                         (0x2000U)
#define ENC_TST_QDN_SHIFT                        (13U)
/*! QDN - Quadrature Decoder Negative Signal
 *  0b0..Positive quadrature decoder signal
 *  0b1..Negative quadrature decoder signal
 */
#define ENC_TST_QDN(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_QDN_SHIFT)) & ENC_TST_QDN_MASK)

#define ENC_TST_TCE_MASK                         (0x4000U)
#define ENC_TST_TCE_SHIFT                        (14U)
/*! TCE - Test Counter Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_TST_TCE(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_TCE_SHIFT)) & ENC_TST_TCE_MASK)

#define ENC_TST_TEN_MASK                         (0x8000U)
#define ENC_TST_TEN_SHIFT                        (15U)
/*! TEN - Test Mode Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_TST_TEN(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEN_SHIFT)) & ENC_TST_TEN_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 */
/*! @{ */

#define ENC_CTRL2_UPDHLD_MASK                    (0x1U)
#define ENC_CTRL2_UPDHLD_SHIFT                   (0U)
/*! UPDHLD - Update Hold Registers
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_UPDHLD(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_UPDHLD_SHIFT)) & ENC_CTRL2_UPDHLD_MASK)

#define ENC_CTRL2_UPDPOS_MASK                    (0x2U)
#define ENC_CTRL2_UPDPOS_SHIFT                   (1U)
/*! UPDPOS - Update Position Registers
 *  0b0..No action
 *  0b1..Clear
 */
#define ENC_CTRL2_UPDPOS(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_UPDPOS_SHIFT)) & ENC_CTRL2_UPDPOS_MASK)

#define ENC_CTRL2_MOD_MASK                       (0x4U)
#define ENC_CTRL2_MOD_SHIFT                      (2U)
/*! MOD - Enable Modulo Counting
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_MOD(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_MOD_SHIFT)) & ENC_CTRL2_MOD_MASK)

#define ENC_CTRL2_DIR_MASK                       (0x8U)
#define ENC_CTRL2_DIR_SHIFT                      (3U)
/*! DIR - Count Direction Flag
 *  0b0..Down direction
 *  0b1..Up direction
 */
#define ENC_CTRL2_DIR(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_DIR_SHIFT)) & ENC_CTRL2_DIR_MASK)

#define ENC_CTRL2_RUIE_MASK                      (0x10U)
#define ENC_CTRL2_RUIE_SHIFT                     (4U)
/*! RUIE - Roll-under Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_RUIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_RUIE_SHIFT)) & ENC_CTRL2_RUIE_MASK)

#define ENC_CTRL2_RUIRQ_MASK                     (0x20U)
#define ENC_CTRL2_RUIRQ_SHIFT                    (5U)
/*! RUIRQ - Roll-under Interrupt Request
 *  0b0..No roll-under has occurred
 *  0b1..Roll-under has occurred
 */
#define ENC_CTRL2_RUIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_RUIRQ_SHIFT)) & ENC_CTRL2_RUIRQ_MASK)

#define ENC_CTRL2_ROIE_MASK                      (0x40U)
#define ENC_CTRL2_ROIE_SHIFT                     (6U)
/*! ROIE - Roll-over Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_ROIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_ROIE_SHIFT)) & ENC_CTRL2_ROIE_MASK)

#define ENC_CTRL2_ROIRQ_MASK                     (0x80U)
#define ENC_CTRL2_ROIRQ_SHIFT                    (7U)
/*! ROIRQ - Roll-over Interrupt Request
 *  0b0..Did not occur
 *  0b1..Occurred
 */
#define ENC_CTRL2_ROIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_ROIRQ_SHIFT)) & ENC_CTRL2_ROIRQ_MASK)

#define ENC_CTRL2_REVMOD_MASK                    (0x100U)
#define ENC_CTRL2_REVMOD_SHIFT                   (8U)
/*! REVMOD - Revolution Counter Modulus Enable
 *  0b0..Use INDEX pulse
 *  0b1..Use modulus counting roll-over or roll-under
 */
#define ENC_CTRL2_REVMOD(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_REVMOD_SHIFT)) & ENC_CTRL2_REVMOD_MASK)

#define ENC_CTRL2_OUTCTL_MASK                    (0x200U)
#define ENC_CTRL2_OUTCTL_SHIFT                   (9U)
/*! OUTCTL - Output Control
 *  0b0..POSMATCH pulses when a match occurs between the position counters (POS) and the corresponding compare value (COMP )
 *  0b1..POSMATCH pulses when the UPOS, LPOS, REV, or POSD registers are read
 */
#define ENC_CTRL2_OUTCTL(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_OUTCTL_SHIFT)) & ENC_CTRL2_OUTCTL_MASK)

#define ENC_CTRL2_SABIE_MASK                     (0x400U)
#define ENC_CTRL2_SABIE_SHIFT                    (10U)
/*! SABIE - Simultaneous PHASEA and PHASEB Change Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_SABIE(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_SABIE_SHIFT)) & ENC_CTRL2_SABIE_MASK)

#define ENC_CTRL2_SABIRQ_MASK                    (0x800U)
#define ENC_CTRL2_SABIRQ_SHIFT                   (11U)
/*! SABIRQ - Simultaneous PHASEA and PHASEB Change Interrupt Request
 *  0b0..No simultaneous change has occurred
 *  0b1..A simultaneous change has occurred
 */
#define ENC_CTRL2_SABIRQ(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_SABIRQ_SHIFT)) & ENC_CTRL2_SABIRQ_MASK)

#define ENC_CTRL2_INITPOS_MASK                   (0x1000U)
#define ENC_CTRL2_INITPOS_SHIFT                  (12U)
/*! INITPOS - Initialize Position Registers
 *  0b0..Don't initialize position counter
 *  0b1..Initialize position counter
 */
#define ENC_CTRL2_INITPOS(x)                     (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_INITPOS_SHIFT)) & ENC_CTRL2_INITPOS_MASK)
/*! @} */

/*! @name UMOD - Upper Modulus */
/*! @{ */

#define ENC_UMOD_MOD_MASK                        (0xFFFFU)
#define ENC_UMOD_MOD_SHIFT                       (0U)
/*! MOD - MOD */
#define ENC_UMOD_MOD(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_UMOD_MOD_SHIFT)) & ENC_UMOD_MOD_MASK)
/*! @} */

/*! @name LMOD - Lower Modulus */
/*! @{ */

#define ENC_LMOD_MOD_MASK                        (0xFFFFU)
#define ENC_LMOD_MOD_SHIFT                       (0U)
/*! MOD - MOD */
#define ENC_LMOD_MOD(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_LMOD_MOD_SHIFT)) & ENC_LMOD_MOD_MASK)
/*! @} */

/*! @name UCOMP - Upper Position Compare */
/*! @{ */

#define ENC_UCOMP_COMP_MASK                      (0xFFFFU)
#define ENC_UCOMP_COMP_SHIFT                     (0U)
/*! COMP - COMP */
#define ENC_UCOMP_COMP(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UCOMP_COMP_SHIFT)) & ENC_UCOMP_COMP_MASK)
/*! @} */

/*! @name LCOMP - Lower Position Compare */
/*! @{ */

#define ENC_LCOMP_COMP_MASK                      (0xFFFFU)
#define ENC_LCOMP_COMP_SHIFT                     (0U)
/*! COMP - COMP */
#define ENC_LCOMP_COMP(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LCOMP_COMP_SHIFT)) & ENC_LCOMP_COMP_MASK)
/*! @} */

/*! @name LASTEDGE - Last Edge Time */
/*! @{ */

#define ENC_LASTEDGE_LASTEDGE_MASK               (0xFFFFU)
#define ENC_LASTEDGE_LASTEDGE_SHIFT              (0U)
/*! LASTEDGE - Last Edge Time Counter */
#define ENC_LASTEDGE_LASTEDGE(x)                 (((uint16_t)(((uint16_t)(x)) << ENC_LASTEDGE_LASTEDGE_SHIFT)) & ENC_LASTEDGE_LASTEDGE_MASK)
/*! @} */

/*! @name LASTEDGEH - Last Edge Time Hold */
/*! @{ */

#define ENC_LASTEDGEH_LASTEDGEH_MASK             (0xFFFFU)
#define ENC_LASTEDGEH_LASTEDGEH_SHIFT            (0U)
/*! LASTEDGEH - Last Edge Time Hold */
#define ENC_LASTEDGEH_LASTEDGEH(x)               (((uint16_t)(((uint16_t)(x)) << ENC_LASTEDGEH_LASTEDGEH_SHIFT)) & ENC_LASTEDGEH_LASTEDGEH_MASK)
/*! @} */

/*! @name POSDPER - Position Difference Period Counter */
/*! @{ */

#define ENC_POSDPER_POSDPER_MASK                 (0xFFFFU)
#define ENC_POSDPER_POSDPER_SHIFT                (0U)
/*! POSDPER - Position difference period */
#define ENC_POSDPER_POSDPER(x)                   (((uint16_t)(((uint16_t)(x)) << ENC_POSDPER_POSDPER_SHIFT)) & ENC_POSDPER_POSDPER_MASK)
/*! @} */

/*! @name POSDPERBFR - Position Difference Period Buffer */
/*! @{ */

#define ENC_POSDPERBFR_POSDPERBFR_MASK           (0xFFFFU)
#define ENC_POSDPERBFR_POSDPERBFR_SHIFT          (0U)
/*! POSDPERBFR - Position difference period buffer */
#define ENC_POSDPERBFR_POSDPERBFR(x)             (((uint16_t)(((uint16_t)(x)) << ENC_POSDPERBFR_POSDPERBFR_SHIFT)) & ENC_POSDPERBFR_POSDPERBFR_MASK)
/*! @} */

/*! @name POSDPERH - Position Difference Period Hold */
/*! @{ */

#define ENC_POSDPERH_POSDPERH_MASK               (0xFFFFU)
#define ENC_POSDPERH_POSDPERH_SHIFT              (0U)
/*! POSDPERH - Position difference period hold */
#define ENC_POSDPERH_POSDPERH(x)                 (((uint16_t)(((uint16_t)(x)) << ENC_POSDPERH_POSDPERH_SHIFT)) & ENC_POSDPERH_POSDPERH_MASK)
/*! @} */

/*! @name CTRL3 - Control 3 */
/*! @{ */

#define ENC_CTRL3_PMEN_MASK                      (0x1U)
#define ENC_CTRL3_PMEN_SHIFT                     (0U)
/*! PMEN - Period Measurement Function Enable
 *  0b0..Not used
 *  0b1..Used
 */
#define ENC_CTRL3_PMEN(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL3_PMEN_SHIFT)) & ENC_CTRL3_PMEN_MASK)

#define ENC_CTRL3_PRSC_MASK                      (0xF0U)
#define ENC_CTRL3_PRSC_SHIFT                     (4U)
/*! PRSC - Prescaler */
#define ENC_CTRL3_PRSC(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL3_PRSC_SHIFT)) & ENC_CTRL3_PRSC_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ENC_Register_Masks */


/* ENC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ENC0 base address */
  #define ENC0_BASE                                (0x500CF000u)
  /** Peripheral ENC0 base address */
  #define ENC0_BASE_NS                             (0x400CF000u)
  /** Peripheral ENC0 base pointer */
  #define ENC0                                     ((ENC_Type *)ENC0_BASE)
  /** Peripheral ENC0 base pointer */
  #define ENC0_NS                                  ((ENC_Type *)ENC0_BASE_NS)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE                                (0x500D1000u)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE_NS                             (0x400D1000u)
  /** Peripheral ENC1 base pointer */
  #define ENC1                                     ((ENC_Type *)ENC1_BASE)
  /** Peripheral ENC1 base pointer */
  #define ENC1_NS                                  ((ENC_Type *)ENC1_BASE_NS)
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS                           { ENC0_BASE, ENC1_BASE }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS                            { ENC0, ENC1 }
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS_NS                        { ENC0_BASE_NS, ENC1_BASE_NS }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS_NS                         { ENC0_NS, ENC1_NS }
#else
  /** Peripheral ENC0 base address */
  #define ENC0_BASE                                (0x400CF000u)
  /** Peripheral ENC0 base pointer */
  #define ENC0                                     ((ENC_Type *)ENC0_BASE)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE                                (0x400D1000u)
  /** Peripheral ENC1 base pointer */
  #define ENC1                                     ((ENC_Type *)ENC1_BASE)
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS                           { ENC0_BASE, ENC1_BASE }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS                            { ENC0, ENC1 }
#endif
/** Interrupt vectors for the ENC peripheral type */
#define ENC_COMPARE_IRQS                         { ENC0_COMPARE_IRQn, ENC1_COMPARE_IRQn }
#define ENC_HOME_IRQS                            { ENC0_HOME_IRQn, ENC1_HOME_IRQn }
#define ENC_WDOG_IRQS                            { ENC0_WDG_SAB_IRQn, ENC1_WDG_SAB_IRQn }
#define ENC_INDEX_IRQS                           { ENC0_IDX_IRQn, ENC1_IDX_IRQn }

/*!
 * @}
 */ /* end of group ENC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ERM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ERM_Peripheral_Access_Layer ERM Peripheral Access Layer
 * @{
 */

/** ERM - Register Layout Typedef */
typedef struct {
  __IO uint32_t CR0;                               /**< ERM Configuration Register 0, offset: 0x0 */
  __IO uint32_t CR1;                               /**< ERM Configuration Register 1, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t SR0;                               /**< ERM Status Register 0, offset: 0x10 */
  __IO uint32_t SR1;                               /**< ERM Status Register 1, offset: 0x14 */
       uint8_t RESERVED_1[232];
  __I  uint32_t EAR0;                              /**< ERM Memory 0 Error Address Register, offset: 0x100 */
  __I  uint32_t SYN0;                              /**< ERM Memory 0 Syndrome Register, offset: 0x104 */
  __IO uint32_t CORR_ERR_CNT0;                     /**< ERM Memory 0 Correctable Error Count Register, offset: 0x108 */
       uint8_t RESERVED_2[4];
  __I  uint32_t EAR1;                              /**< ERM Memory 1 Error Address Register, offset: 0x110 */
  __I  uint32_t SYN1;                              /**< ERM Memory 1 Syndrome Register, offset: 0x114 */
  __IO uint32_t CORR_ERR_CNT1;                     /**< ERM Memory 1 Correctable Error Count Register, offset: 0x118 */
       uint8_t RESERVED_3[4];
  __I  uint32_t EAR2;                              /**< ERM Memory 2 Error Address Register, offset: 0x120 */
  __I  uint32_t SYN2;                              /**< ERM Memory 2 Syndrome Register, offset: 0x124 */
  __IO uint32_t CORR_ERR_CNT2;                     /**< ERM Memory 2 Correctable Error Count Register, offset: 0x128 */
       uint8_t RESERVED_4[4];
  __I  uint32_t EAR3;                              /**< ERM Memory 3 Error Address Register, offset: 0x130 */
  __I  uint32_t SYN3;                              /**< ERM Memory 3 Syndrome Register, offset: 0x134 */
  __IO uint32_t CORR_ERR_CNT3;                     /**< ERM Memory 3 Correctable Error Count Register, offset: 0x138 */
       uint8_t RESERVED_5[4];
  __I  uint32_t EAR4;                              /**< ERM Memory 4 Error Address Register, offset: 0x140 */
  __I  uint32_t SYN4;                              /**< ERM Memory 4 Syndrome Register, offset: 0x144 */
  __IO uint32_t CORR_ERR_CNT4;                     /**< ERM Memory 4 Correctable Error Count Register, offset: 0x148 */
       uint8_t RESERVED_6[12];
  __IO uint32_t CORR_ERR_CNT5;                     /**< ERM Memory 5 Correctable Error Count Register, offset: 0x158 */
       uint8_t RESERVED_7[12];
  __IO uint32_t CORR_ERR_CNT6;                     /**< ERM Memory 6 Correctable Error Count Register, offset: 0x168 */
       uint8_t RESERVED_8[12];
  __IO uint32_t CORR_ERR_CNT7;                     /**< ERM Memory 7 Correctable Error Count Register, offset: 0x178 */
       uint8_t RESERVED_9[8];
  __I  uint32_t SYN8;                              /**< ERM Memory 8 Syndrome Register, offset: 0x184 */
  __IO uint32_t CORR_ERR_CNT8;                     /**< ERM Memory 8 Correctable Error Count Register, offset: 0x188 */
       uint8_t RESERVED_10[12];
  __IO uint32_t CORR_ERR_CNT9;                     /**< ERM Memory 9 Correctable Error Count Register, offset: 0x198 */
} ERM_Type;

/* ----------------------------------------------------------------------------
   -- ERM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ERM_Register_Masks ERM Register Masks
 * @{
 */

/*! @name CR0 - ERM Configuration Register 0 */
/*! @{ */

#define ERM_CR0_ENCIE7_MASK                      (0x4U)
#define ERM_CR0_ENCIE7_SHIFT                     (2U)
/*! ENCIE7 - ENCIE7
 *  0b0..Interrupt notification of Memory 7 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 7 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE7(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE7_SHIFT)) & ERM_CR0_ENCIE7_MASK)

#define ERM_CR0_ESCIE7_MASK                      (0x8U)
#define ERM_CR0_ESCIE7_SHIFT                     (3U)
/*! ESCIE7 - ESCIE7
 *  0b0..Interrupt notification of Memory 7 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 7 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE7(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE7_SHIFT)) & ERM_CR0_ESCIE7_MASK)

#define ERM_CR0_ENCIE6_MASK                      (0x40U)
#define ERM_CR0_ENCIE6_SHIFT                     (6U)
/*! ENCIE6 - ENCIE6
 *  0b0..Interrupt notification of Memory 6 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 6 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE6(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE6_SHIFT)) & ERM_CR0_ENCIE6_MASK)

#define ERM_CR0_ESCIE6_MASK                      (0x80U)
#define ERM_CR0_ESCIE6_SHIFT                     (7U)
/*! ESCIE6 - ESCIE6
 *  0b0..Interrupt notification of Memory 6 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 6 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE6(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE6_SHIFT)) & ERM_CR0_ESCIE6_MASK)

#define ERM_CR0_ENCIE5_MASK                      (0x400U)
#define ERM_CR0_ENCIE5_SHIFT                     (10U)
/*! ENCIE5 - ENCIE5
 *  0b0..Interrupt notification of Memory 5 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 5 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE5(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE5_SHIFT)) & ERM_CR0_ENCIE5_MASK)

#define ERM_CR0_ESCIE5_MASK                      (0x800U)
#define ERM_CR0_ESCIE5_SHIFT                     (11U)
/*! ESCIE5 - ESCIE5
 *  0b0..Interrupt notification of Memory 5 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 5 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE5(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE5_SHIFT)) & ERM_CR0_ESCIE5_MASK)

#define ERM_CR0_ENCIE4_MASK                      (0x4000U)
#define ERM_CR0_ENCIE4_SHIFT                     (14U)
/*! ENCIE4 - ENCIE4
 *  0b0..Interrupt notification of Memory 4 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 4 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE4(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE4_SHIFT)) & ERM_CR0_ENCIE4_MASK)

#define ERM_CR0_ESCIE4_MASK                      (0x8000U)
#define ERM_CR0_ESCIE4_SHIFT                     (15U)
/*! ESCIE4 - ESCIE4
 *  0b0..Interrupt notification of Memory 4 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 4 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE4(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE4_SHIFT)) & ERM_CR0_ESCIE4_MASK)

#define ERM_CR0_ENCIE3_MASK                      (0x40000U)
#define ERM_CR0_ENCIE3_SHIFT                     (18U)
/*! ENCIE3 - ENCIE3
 *  0b0..Interrupt notification of Memory 3 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 3 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE3(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE3_SHIFT)) & ERM_CR0_ENCIE3_MASK)

#define ERM_CR0_ESCIE3_MASK                      (0x80000U)
#define ERM_CR0_ESCIE3_SHIFT                     (19U)
/*! ESCIE3 - ESCIE3
 *  0b0..Interrupt notification of Memory 3 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 3 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE3(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE3_SHIFT)) & ERM_CR0_ESCIE3_MASK)

#define ERM_CR0_ENCIE2_MASK                      (0x400000U)
#define ERM_CR0_ENCIE2_SHIFT                     (22U)
/*! ENCIE2 - ENCIE2
 *  0b0..Interrupt notification of Memory 2 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 2 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE2(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE2_SHIFT)) & ERM_CR0_ENCIE2_MASK)

#define ERM_CR0_ESCIE2_MASK                      (0x800000U)
#define ERM_CR0_ESCIE2_SHIFT                     (23U)
/*! ESCIE2 - ESCIE2
 *  0b0..Interrupt notification of Memory 2 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 2 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE2(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE2_SHIFT)) & ERM_CR0_ESCIE2_MASK)

#define ERM_CR0_ENCIE1_MASK                      (0x4000000U)
#define ERM_CR0_ENCIE1_SHIFT                     (26U)
/*! ENCIE1 - ENCIE1
 *  0b0..Interrupt notification of Memory 1 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 1 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE1(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE1_SHIFT)) & ERM_CR0_ENCIE1_MASK)

#define ERM_CR0_ESCIE1_MASK                      (0x8000000U)
#define ERM_CR0_ESCIE1_SHIFT                     (27U)
/*! ESCIE1 - ESCIE1
 *  0b0..Interrupt notification of Memory 1 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 1 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE1(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE1_SHIFT)) & ERM_CR0_ESCIE1_MASK)

#define ERM_CR0_ENCIE0_MASK                      (0x40000000U)
#define ERM_CR0_ENCIE0_SHIFT                     (30U)
/*! ENCIE0 - ENCIE0
 *  0b0..Interrupt notification of Memory 0 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 0 non-correctable error events is enabled.
 */
#define ERM_CR0_ENCIE0(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ENCIE0_SHIFT)) & ERM_CR0_ENCIE0_MASK)

#define ERM_CR0_ESCIE0_MASK                      (0x80000000U)
#define ERM_CR0_ESCIE0_SHIFT                     (31U)
/*! ESCIE0 - ESCIE0
 *  0b0..Interrupt notification of Memory 0 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 0 single-bit correction events is enabled.
 */
#define ERM_CR0_ESCIE0(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR0_ESCIE0_SHIFT)) & ERM_CR0_ESCIE0_MASK)
/*! @} */

/*! @name CR1 - ERM Configuration Register 1 */
/*! @{ */

#define ERM_CR1_ENCIE9_MASK                      (0x4000000U)
#define ERM_CR1_ENCIE9_SHIFT                     (26U)
/*! ENCIE9 - ENCIE9
 *  0b0..Interrupt notification of Memory 9 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 9 non-correctable error events is enabled.
 */
#define ERM_CR1_ENCIE9(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR1_ENCIE9_SHIFT)) & ERM_CR1_ENCIE9_MASK)

#define ERM_CR1_ESCIE9_MASK                      (0x8000000U)
#define ERM_CR1_ESCIE9_SHIFT                     (27U)
/*! ESCIE9 - ESCIE9
 *  0b0..Interrupt notification of Memory 9 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 9 single-bit correction events is enabled.
 */
#define ERM_CR1_ESCIE9(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR1_ESCIE9_SHIFT)) & ERM_CR1_ESCIE9_MASK)

#define ERM_CR1_ENCIE8_MASK                      (0x40000000U)
#define ERM_CR1_ENCIE8_SHIFT                     (30U)
/*! ENCIE8 - ENCIE8
 *  0b0..Interrupt notification of Memory 8 non-correctable error events is disabled.
 *  0b1..Interrupt notification of Memory 8 non-correctable error events is enabled.
 */
#define ERM_CR1_ENCIE8(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR1_ENCIE8_SHIFT)) & ERM_CR1_ENCIE8_MASK)

#define ERM_CR1_ESCIE8_MASK                      (0x80000000U)
#define ERM_CR1_ESCIE8_SHIFT                     (31U)
/*! ESCIE8 - ESCIE8
 *  0b0..Interrupt notification of Memory 8 single-bit correction events is disabled.
 *  0b1..Interrupt notification of Memory 8 single-bit correction events is enabled.
 */
#define ERM_CR1_ESCIE8(x)                        (((uint32_t)(((uint32_t)(x)) << ERM_CR1_ESCIE8_SHIFT)) & ERM_CR1_ESCIE8_MASK)
/*! @} */

/*! @name SR0 - ERM Status Register 0 */
/*! @{ */

#define ERM_SR0_NCE7_MASK                        (0x4U)
#define ERM_SR0_NCE7_SHIFT                       (2U)
/*! NCE7 - NCE7
 *  0b0..No non-correctable error event on Memory 7 detected.
 *  0b1..Non-correctable error event on Memory 7 detected.
 */
#define ERM_SR0_NCE7(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE7_SHIFT)) & ERM_SR0_NCE7_MASK)

#define ERM_SR0_SBC7_MASK                        (0x8U)
#define ERM_SR0_SBC7_SHIFT                       (3U)
/*! SBC7 - SBC7
 *  0b0..No single-bit correction event on Memory 7 detected.
 *  0b1..Single-bit correction event on Memory 7 detected.
 */
#define ERM_SR0_SBC7(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC7_SHIFT)) & ERM_SR0_SBC7_MASK)

#define ERM_SR0_NCE6_MASK                        (0x40U)
#define ERM_SR0_NCE6_SHIFT                       (6U)
/*! NCE6 - NCE6
 *  0b0..No non-correctable error event on Memory 6 detected.
 *  0b1..Non-correctable error event on Memory 6 detected.
 */
#define ERM_SR0_NCE6(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE6_SHIFT)) & ERM_SR0_NCE6_MASK)

#define ERM_SR0_SBC6_MASK                        (0x80U)
#define ERM_SR0_SBC6_SHIFT                       (7U)
/*! SBC6 - SBC6
 *  0b0..No single-bit correction event on Memory 6 detected.
 *  0b1..Single-bit correction event on Memory 6 detected.
 */
#define ERM_SR0_SBC6(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC6_SHIFT)) & ERM_SR0_SBC6_MASK)

#define ERM_SR0_NCE5_MASK                        (0x400U)
#define ERM_SR0_NCE5_SHIFT                       (10U)
/*! NCE5 - NCE5
 *  0b0..No non-correctable error event on Memory 5 detected.
 *  0b1..Non-correctable error event on Memory 5 detected.
 */
#define ERM_SR0_NCE5(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE5_SHIFT)) & ERM_SR0_NCE5_MASK)

#define ERM_SR0_SBC5_MASK                        (0x800U)
#define ERM_SR0_SBC5_SHIFT                       (11U)
/*! SBC5 - SBC5
 *  0b0..No single-bit correction event on Memory 5 detected.
 *  0b1..Single-bit correction event on Memory 5 detected.
 */
#define ERM_SR0_SBC5(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC5_SHIFT)) & ERM_SR0_SBC5_MASK)

#define ERM_SR0_NCE4_MASK                        (0x4000U)
#define ERM_SR0_NCE4_SHIFT                       (14U)
/*! NCE4 - NCE4
 *  0b0..No non-correctable error event on Memory 4 detected.
 *  0b1..Non-correctable error event on Memory 4 detected.
 */
#define ERM_SR0_NCE4(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE4_SHIFT)) & ERM_SR0_NCE4_MASK)

#define ERM_SR0_SBC4_MASK                        (0x8000U)
#define ERM_SR0_SBC4_SHIFT                       (15U)
/*! SBC4 - SBC4
 *  0b0..No single-bit correction event on Memory 4 detected.
 *  0b1..Single-bit correction event on Memory 4 detected.
 */
#define ERM_SR0_SBC4(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC4_SHIFT)) & ERM_SR0_SBC4_MASK)

#define ERM_SR0_NCE3_MASK                        (0x40000U)
#define ERM_SR0_NCE3_SHIFT                       (18U)
/*! NCE3 - NCE3
 *  0b0..No non-correctable error event on Memory 3 detected.
 *  0b1..Non-correctable error event on Memory 3 detected.
 */
#define ERM_SR0_NCE3(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE3_SHIFT)) & ERM_SR0_NCE3_MASK)

#define ERM_SR0_SBC3_MASK                        (0x80000U)
#define ERM_SR0_SBC3_SHIFT                       (19U)
/*! SBC3 - SBC3
 *  0b0..No single-bit correction event on Memory 3 detected.
 *  0b1..Single-bit correction event on Memory 3 detected.
 */
#define ERM_SR0_SBC3(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC3_SHIFT)) & ERM_SR0_SBC3_MASK)

#define ERM_SR0_NCE2_MASK                        (0x400000U)
#define ERM_SR0_NCE2_SHIFT                       (22U)
/*! NCE2 - NCE2
 *  0b0..No non-correctable error event on Memory 2 detected.
 *  0b1..Non-correctable error event on Memory 2 detected.
 */
#define ERM_SR0_NCE2(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE2_SHIFT)) & ERM_SR0_NCE2_MASK)

#define ERM_SR0_SBC2_MASK                        (0x800000U)
#define ERM_SR0_SBC2_SHIFT                       (23U)
/*! SBC2 - SBC2
 *  0b0..No single-bit correction event on Memory 2 detected.
 *  0b1..Single-bit correction event on Memory 2 detected.
 */
#define ERM_SR0_SBC2(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC2_SHIFT)) & ERM_SR0_SBC2_MASK)

#define ERM_SR0_NCE1_MASK                        (0x4000000U)
#define ERM_SR0_NCE1_SHIFT                       (26U)
/*! NCE1 - NCE1
 *  0b0..No non-correctable error event on Memory 1 detected.
 *  0b1..Non-correctable error event on Memory 1 detected.
 */
#define ERM_SR0_NCE1(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE1_SHIFT)) & ERM_SR0_NCE1_MASK)

#define ERM_SR0_SBC1_MASK                        (0x8000000U)
#define ERM_SR0_SBC1_SHIFT                       (27U)
/*! SBC1 - SBC1
 *  0b0..No single-bit correction event on Memory 1 detected.
 *  0b1..Single-bit correction event on Memory 1 detected.
 */
#define ERM_SR0_SBC1(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC1_SHIFT)) & ERM_SR0_SBC1_MASK)

#define ERM_SR0_NCE0_MASK                        (0x40000000U)
#define ERM_SR0_NCE0_SHIFT                       (30U)
/*! NCE0 - NCE0
 *  0b0..No non-correctable error event on Memory 0 detected.
 *  0b1..Non-correctable error event on Memory 0 detected.
 */
#define ERM_SR0_NCE0(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_NCE0_SHIFT)) & ERM_SR0_NCE0_MASK)

#define ERM_SR0_SBC0_MASK                        (0x80000000U)
#define ERM_SR0_SBC0_SHIFT                       (31U)
/*! SBC0 - SBC0
 *  0b0..No single-bit correction event on Memory 0 detected.
 *  0b1..Single-bit correction event on Memory 0 detected.
 */
#define ERM_SR0_SBC0(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR0_SBC0_SHIFT)) & ERM_SR0_SBC0_MASK)
/*! @} */

/*! @name SR1 - ERM Status Register 1 */
/*! @{ */

#define ERM_SR1_NCE9_MASK                        (0x4000000U)
#define ERM_SR1_NCE9_SHIFT                       (26U)
/*! NCE9 - NCE9
 *  0b0..No non-correctable error event on Memory 9 detected.
 *  0b1..Non-correctable error event on Memory 9 detected.
 */
#define ERM_SR1_NCE9(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR1_NCE9_SHIFT)) & ERM_SR1_NCE9_MASK)

#define ERM_SR1_SBC9_MASK                        (0x8000000U)
#define ERM_SR1_SBC9_SHIFT                       (27U)
/*! SBC9 - SBC9
 *  0b0..No single-bit correction event on Memory 9 detected.
 *  0b1..Single-bit correction event on Memory 9 detected.
 */
#define ERM_SR1_SBC9(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR1_SBC9_SHIFT)) & ERM_SR1_SBC9_MASK)

#define ERM_SR1_NCE8_MASK                        (0x40000000U)
#define ERM_SR1_NCE8_SHIFT                       (30U)
/*! NCE8 - NCE8
 *  0b0..No non-correctable error event on Memory 8 detected.
 *  0b1..Non-correctable error event on Memory 8 detected.
 */
#define ERM_SR1_NCE8(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR1_NCE8_SHIFT)) & ERM_SR1_NCE8_MASK)

#define ERM_SR1_SBC8_MASK                        (0x80000000U)
#define ERM_SR1_SBC8_SHIFT                       (31U)
/*! SBC8 - SBC8
 *  0b0..No single-bit correction event on Memory 8 detected.
 *  0b1..Single-bit correction event on Memory 8 detected.
 */
#define ERM_SR1_SBC8(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_SR1_SBC8_SHIFT)) & ERM_SR1_SBC8_MASK)
/*! @} */

/*! @name EAR0 - ERM Memory 0 Error Address Register */
/*! @{ */

#define ERM_EAR0_EAR_MASK                        (0xFFFFFFFFU)
#define ERM_EAR0_EAR_SHIFT                       (0U)
/*! EAR - EAR */
#define ERM_EAR0_EAR(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_EAR0_EAR_SHIFT)) & ERM_EAR0_EAR_MASK)
/*! @} */

/*! @name SYN0 - ERM Memory 0 Syndrome Register */
/*! @{ */

#define ERM_SYN0_SYNDROME_MASK                   (0xFF000000U)
#define ERM_SYN0_SYNDROME_SHIFT                  (24U)
/*! SYNDROME - SYNDROME */
#define ERM_SYN0_SYNDROME(x)                     (((uint32_t)(((uint32_t)(x)) << ERM_SYN0_SYNDROME_SHIFT)) & ERM_SYN0_SYNDROME_MASK)
/*! @} */

/*! @name CORR_ERR_CNT0 - ERM Memory 0 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT0_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT0_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT0_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT0_COUNT_SHIFT)) & ERM_CORR_ERR_CNT0_COUNT_MASK)
/*! @} */

/*! @name EAR1 - ERM Memory 1 Error Address Register */
/*! @{ */

#define ERM_EAR1_EAR_MASK                        (0xFFFFFFFFU)
#define ERM_EAR1_EAR_SHIFT                       (0U)
/*! EAR - EAR */
#define ERM_EAR1_EAR(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_EAR1_EAR_SHIFT)) & ERM_EAR1_EAR_MASK)
/*! @} */

/*! @name SYN1 - ERM Memory 1 Syndrome Register */
/*! @{ */

#define ERM_SYN1_SYNDROME_MASK                   (0xFF000000U)
#define ERM_SYN1_SYNDROME_SHIFT                  (24U)
/*! SYNDROME - SYNDROME */
#define ERM_SYN1_SYNDROME(x)                     (((uint32_t)(((uint32_t)(x)) << ERM_SYN1_SYNDROME_SHIFT)) & ERM_SYN1_SYNDROME_MASK)
/*! @} */

/*! @name CORR_ERR_CNT1 - ERM Memory 1 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT1_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT1_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT1_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT1_COUNT_SHIFT)) & ERM_CORR_ERR_CNT1_COUNT_MASK)
/*! @} */

/*! @name EAR2 - ERM Memory 2 Error Address Register */
/*! @{ */

#define ERM_EAR2_EAR_MASK                        (0xFFFFFFFFU)
#define ERM_EAR2_EAR_SHIFT                       (0U)
/*! EAR - EAR */
#define ERM_EAR2_EAR(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_EAR2_EAR_SHIFT)) & ERM_EAR2_EAR_MASK)
/*! @} */

/*! @name SYN2 - ERM Memory 2 Syndrome Register */
/*! @{ */

#define ERM_SYN2_SYNDROME_MASK                   (0xFF000000U)
#define ERM_SYN2_SYNDROME_SHIFT                  (24U)
/*! SYNDROME - SYNDROME */
#define ERM_SYN2_SYNDROME(x)                     (((uint32_t)(((uint32_t)(x)) << ERM_SYN2_SYNDROME_SHIFT)) & ERM_SYN2_SYNDROME_MASK)
/*! @} */

/*! @name CORR_ERR_CNT2 - ERM Memory 2 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT2_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT2_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT2_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT2_COUNT_SHIFT)) & ERM_CORR_ERR_CNT2_COUNT_MASK)
/*! @} */

/*! @name EAR3 - ERM Memory 3 Error Address Register */
/*! @{ */

#define ERM_EAR3_EAR_MASK                        (0xFFFFFFFFU)
#define ERM_EAR3_EAR_SHIFT                       (0U)
/*! EAR - EAR */
#define ERM_EAR3_EAR(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_EAR3_EAR_SHIFT)) & ERM_EAR3_EAR_MASK)
/*! @} */

/*! @name SYN3 - ERM Memory 3 Syndrome Register */
/*! @{ */

#define ERM_SYN3_SYNDROME_MASK                   (0xFF000000U)
#define ERM_SYN3_SYNDROME_SHIFT                  (24U)
/*! SYNDROME - SYNDROME */
#define ERM_SYN3_SYNDROME(x)                     (((uint32_t)(((uint32_t)(x)) << ERM_SYN3_SYNDROME_SHIFT)) & ERM_SYN3_SYNDROME_MASK)
/*! @} */

/*! @name CORR_ERR_CNT3 - ERM Memory 3 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT3_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT3_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT3_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT3_COUNT_SHIFT)) & ERM_CORR_ERR_CNT3_COUNT_MASK)
/*! @} */

/*! @name EAR4 - ERM Memory 4 Error Address Register */
/*! @{ */

#define ERM_EAR4_EAR_MASK                        (0xFFFFFFFFU)
#define ERM_EAR4_EAR_SHIFT                       (0U)
/*! EAR - EAR */
#define ERM_EAR4_EAR(x)                          (((uint32_t)(((uint32_t)(x)) << ERM_EAR4_EAR_SHIFT)) & ERM_EAR4_EAR_MASK)
/*! @} */

/*! @name SYN4 - ERM Memory 4 Syndrome Register */
/*! @{ */

#define ERM_SYN4_SYNDROME_MASK                   (0xFF000000U)
#define ERM_SYN4_SYNDROME_SHIFT                  (24U)
/*! SYNDROME - SYNDROME */
#define ERM_SYN4_SYNDROME(x)                     (((uint32_t)(((uint32_t)(x)) << ERM_SYN4_SYNDROME_SHIFT)) & ERM_SYN4_SYNDROME_MASK)
/*! @} */

/*! @name CORR_ERR_CNT4 - ERM Memory 4 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT4_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT4_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT4_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT4_COUNT_SHIFT)) & ERM_CORR_ERR_CNT4_COUNT_MASK)
/*! @} */

/*! @name CORR_ERR_CNT5 - ERM Memory 5 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT5_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT5_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT5_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT5_COUNT_SHIFT)) & ERM_CORR_ERR_CNT5_COUNT_MASK)
/*! @} */

/*! @name CORR_ERR_CNT6 - ERM Memory 6 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT6_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT6_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT6_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT6_COUNT_SHIFT)) & ERM_CORR_ERR_CNT6_COUNT_MASK)
/*! @} */

/*! @name CORR_ERR_CNT7 - ERM Memory 7 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT7_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT7_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT7_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT7_COUNT_SHIFT)) & ERM_CORR_ERR_CNT7_COUNT_MASK)
/*! @} */

/*! @name SYN8 - ERM Memory 8 Syndrome Register */
/*! @{ */

#define ERM_SYN8_SYNDROME_MASK                   (0xFF000000U)
#define ERM_SYN8_SYNDROME_SHIFT                  (24U)
/*! SYNDROME - SYNDROME */
#define ERM_SYN8_SYNDROME(x)                     (((uint32_t)(((uint32_t)(x)) << ERM_SYN8_SYNDROME_SHIFT)) & ERM_SYN8_SYNDROME_MASK)
/*! @} */

/*! @name CORR_ERR_CNT8 - ERM Memory 8 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT8_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT8_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT8_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT8_COUNT_SHIFT)) & ERM_CORR_ERR_CNT8_COUNT_MASK)
/*! @} */

/*! @name CORR_ERR_CNT9 - ERM Memory 9 Correctable Error Count Register */
/*! @{ */

#define ERM_CORR_ERR_CNT9_COUNT_MASK             (0xFFU)
#define ERM_CORR_ERR_CNT9_COUNT_SHIFT            (0U)
/*! COUNT - Memory n Correctable Error Count */
#define ERM_CORR_ERR_CNT9_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << ERM_CORR_ERR_CNT9_COUNT_SHIFT)) & ERM_CORR_ERR_CNT9_COUNT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ERM_Register_Masks */


/* ERM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ERM0 base address */
  #define ERM0_BASE                                (0x5005C000u)
  /** Peripheral ERM0 base address */
  #define ERM0_BASE_NS                             (0x4005C000u)
  /** Peripheral ERM0 base pointer */
  #define ERM0                                     ((ERM_Type *)ERM0_BASE)
  /** Peripheral ERM0 base pointer */
  #define ERM0_NS                                  ((ERM_Type *)ERM0_BASE_NS)
  /** Array initializer of ERM peripheral base addresses */
  #define ERM_BASE_ADDRS                           { ERM0_BASE }
  /** Array initializer of ERM peripheral base pointers */
  #define ERM_BASE_PTRS                            { ERM0 }
  /** Array initializer of ERM peripheral base addresses */
  #define ERM_BASE_ADDRS_NS                        { ERM0_BASE_NS }
  /** Array initializer of ERM peripheral base pointers */
  #define ERM_BASE_PTRS_NS                         { ERM0_NS }
#else
  /** Peripheral ERM0 base address */
  #define ERM0_BASE                                (0x4005C000u)
  /** Peripheral ERM0 base pointer */
  #define ERM0                                     ((ERM_Type *)ERM0_BASE)
  /** Array initializer of ERM peripheral base addresses */
  #define ERM_BASE_ADDRS                           { ERM0_BASE }
  /** Array initializer of ERM peripheral base pointers */
  #define ERM_BASE_PTRS                            { ERM0 }
#endif

/*!
 * @}
 */ /* end of group ERM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EVTG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EVTG_Peripheral_Access_Layer EVTG Peripheral Access Layer
 * @{
 */

/** EVTG - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x10 */
    __IO uint16_t EVTG_AOI0_BFT01;                   /**< AOI0 Boolean Function Term 0 and 1 Configuration, array offset: 0x0, array step: 0x10 */
    __IO uint16_t EVTG_AOI0_BFT23;                   /**< AOI0 Boolean Function Term 2 and 3 Configuration, array offset: 0x2, array step: 0x10 */
    __IO uint16_t EVTG_AOI1_BFT01;                   /**< AOI1 Boolean Function Term 0 and 1 Configuration, array offset: 0x4, array step: 0x10 */
    __IO uint16_t EVTG_AOI1_BFT23;                   /**< AOI1 Boolean Function Term 2 and 3 Configuration, array offset: 0x6, array step: 0x10 */
         uint8_t RESERVED_0[2];
    __IO uint16_t EVTG_CTRL;                         /**< Control and Status, array offset: 0xA, array step: 0x10 */
    __IO uint16_t EVTG_AOI0_FILT;                    /**< AOI0 Output Filter, array offset: 0xC, array step: 0x10 */
    __IO uint16_t EVTG_AOI1_FILT;                    /**< AOI1 Output Filter, array offset: 0xE, array step: 0x10 */
  } EVTG_INST[4];
} EVTG_Type;

/* ----------------------------------------------------------------------------
   -- EVTG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EVTG_Register_Masks EVTG Register Masks
 * @{
 */

/*! @name EVTG_INST_EVTG_AOI0_BFT01 - AOI0 Boolean Function Term 0 and 1 Configuration */
/*! @{ */

#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_DC_MASK (0x3U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_DC_SHIFT (0U)
/*! PT1_DC - Product Term 1, D Input Configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_DC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_DC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_DC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_CC_MASK (0xCU)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_CC_SHIFT (2U)
/*! PT1_CC - Product Term 1, C Input Configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_CC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_CC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_CC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_BC_MASK (0x30U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_BC_SHIFT (4U)
/*! PT1_BC - Product Term 1, B Input Configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_BC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_BC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_BC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_AC_MASK (0xC0U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_AC_SHIFT (6U)
/*! PT1_AC - Product Term 1, A Input Configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_AC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_AC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT1_AC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_DC_MASK (0x300U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_DC_SHIFT (8U)
/*! PT0_DC - Product Term 0, D Input Configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_DC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_DC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_DC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_CC_MASK (0xC00U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_CC_SHIFT (10U)
/*! PT0_CC - Product Term 0, C Input Configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_CC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_CC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_CC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_BC_MASK (0x3000U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_BC_SHIFT (12U)
/*! PT0_BC - Product Term 0, B Input Configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_BC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_BC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_BC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_AC_MASK (0xC000U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_AC_SHIFT (14U)
/*! PT0_AC - Product Term 0, A Input Configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_AC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_AC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT01_PT0_AC_MASK)
/*! @} */

/* The count of EVTG_EVTG_INST_EVTG_AOI0_BFT01 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT01_COUNT     (4U)

/*! @name EVTG_INST_EVTG_AOI0_BFT23 - AOI0 Boolean Function Term 2 and 3 Configuration */
/*! @{ */

#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_DC_MASK (0x3U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_DC_SHIFT (0U)
/*! PT3_DC - Product Term 3, D Input Configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_DC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_DC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_DC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_CC_MASK (0xCU)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_CC_SHIFT (2U)
/*! PT3_CC - Product Term 3, C Input Configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_CC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_CC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_CC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_BC_MASK (0x30U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_BC_SHIFT (4U)
/*! PT3_BC - Product Term 3, B Input Configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_BC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_BC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_BC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_AC_MASK (0xC0U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_AC_SHIFT (6U)
/*! PT3_AC - Product Term 3, A Input Configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_AC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_AC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT3_AC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_DC_MASK (0x300U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_DC_SHIFT (8U)
/*! PT2_DC - Product Term 2, D Input Configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_DC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_DC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_DC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_CC_MASK (0xC00U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_CC_SHIFT (10U)
/*! PT2_CC - Product Term 2, C Input Configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_CC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_CC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_CC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_BC_MASK (0x3000U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_BC_SHIFT (12U)
/*! PT2_BC - Product Term 2, B Input Configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_BC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_BC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_BC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_AC_MASK (0xC000U)
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_AC_SHIFT (14U)
/*! PT2_AC - Product Term 2, A Input Configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_AC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_AC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_BFT23_PT2_AC_MASK)
/*! @} */

/* The count of EVTG_EVTG_INST_EVTG_AOI0_BFT23 */
#define EVTG_EVTG_INST_EVTG_AOI0_BFT23_COUNT     (4U)

/*! @name EVTG_INST_EVTG_AOI1_BFT01 - AOI1 Boolean Function Term 0 and 1 Configuration */
/*! @{ */

#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_DC_MASK (0x3U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_DC_SHIFT (0U)
/*! PT1_DC - Product Term 1, D Input Configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_DC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_DC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_DC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_CC_MASK (0xCU)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_CC_SHIFT (2U)
/*! PT1_CC - Product Term 1, C Input Configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_CC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_CC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_CC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_BC_MASK (0x30U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_BC_SHIFT (4U)
/*! PT1_BC - Product Term 1, B Input Configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_BC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_BC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_BC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_AC_MASK (0xC0U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_AC_SHIFT (6U)
/*! PT1_AC - Product Term 1, A Input Configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_AC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_AC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT1_AC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_DC_MASK (0x300U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_DC_SHIFT (8U)
/*! PT0_DC - Product Term 0, D Input Configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_DC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_DC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_DC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_CC_MASK (0xC00U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_CC_SHIFT (10U)
/*! PT0_CC - Product Term 0, C Input Configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_CC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_CC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_CC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_BC_MASK (0x3000U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_BC_SHIFT (12U)
/*! PT0_BC - Product Term 0, B Input Configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_BC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_BC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_BC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_AC_MASK (0xC000U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_AC_SHIFT (14U)
/*! PT0_AC - Product Term 0, A Input Configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_AC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_AC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT01_PT0_AC_MASK)
/*! @} */

/* The count of EVTG_EVTG_INST_EVTG_AOI1_BFT01 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT01_COUNT     (4U)

/*! @name EVTG_INST_EVTG_AOI1_BFT23 - AOI1 Boolean Function Term 2 and 3 Configuration */
/*! @{ */

#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_DC_MASK (0x3U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_DC_SHIFT (0U)
/*! PT3_DC - Product Term 3, D Input Configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_DC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_DC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_DC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_CC_MASK (0xCU)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_CC_SHIFT (2U)
/*! PT3_CC - Product Term 3, C Input Configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_CC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_CC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_CC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_BC_MASK (0x30U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_BC_SHIFT (4U)
/*! PT3_BC - Product Term 3, B Input Configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_BC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_BC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_BC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_AC_MASK (0xC0U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_AC_SHIFT (6U)
/*! PT3_AC - Product Term 3, A Input Configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_AC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_AC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT3_AC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_DC_MASK (0x300U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_DC_SHIFT (8U)
/*! PT2_DC - Product Term 2, D Input Configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_DC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_DC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_DC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_CC_MASK (0xC00U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_CC_SHIFT (10U)
/*! PT2_CC - Product Term 2, C Input Configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_CC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_CC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_CC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_BC_MASK (0x3000U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_BC_SHIFT (12U)
/*! PT2_BC - Product Term 2, B Input Configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_BC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_BC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_BC_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_AC_MASK (0xC000U)
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_AC_SHIFT (14U)
/*! PT2_AC - Product Term 2, A Input Configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_AC(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_AC_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_BFT23_PT2_AC_MASK)
/*! @} */

/* The count of EVTG_EVTG_INST_EVTG_AOI1_BFT23 */
#define EVTG_EVTG_INST_EVTG_AOI1_BFT23_COUNT     (4U)

/*! @name EVTG_INST_EVTG_CTRL - Control and Status */
/*! @{ */

#define EVTG_EVTG_INST_EVTG_CTRL_FF_INIT_MASK    (0x1U)
#define EVTG_EVTG_INST_EVTG_CTRL_FF_INIT_SHIFT   (0U)
/*! FF_INIT - Flip flop Initial Value Configuration
 *  0b0..0
 *  0b1..1
 */
#define EVTG_EVTG_INST_EVTG_CTRL_FF_INIT(x)      (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_CTRL_FF_INIT_SHIFT)) & EVTG_EVTG_INST_EVTG_CTRL_FF_INIT_MASK)

#define EVTG_EVTG_INST_EVTG_CTRL_INIT_EN_MASK    (0x2U)
#define EVTG_EVTG_INST_EVTG_CTRL_INIT_EN_SHIFT   (1U)
/*! INIT_EN - Flip-Flop Initial Output Enable Control
 *  0b0..Write 0 does not generate enable pulse
 *  0b1..Write 1 generates enable pulse
 */
#define EVTG_EVTG_INST_EVTG_CTRL_INIT_EN(x)      (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_CTRL_INIT_EN_SHIFT)) & EVTG_EVTG_INST_EVTG_CTRL_INIT_EN_MASK)

#define EVTG_EVTG_INST_EVTG_CTRL_MODE_SEL_MASK   (0x1CU)
#define EVTG_EVTG_INST_EVTG_CTRL_MODE_SEL_SHIFT  (2U)
/*! MODE_SEL - Flip-Flop Mode Selection
 *  0b000..Bypass mode
 *  0b001..RS Trigger mode
 *  0b010..T-FF mode
 *  0b011..D-FF mode
 *  0b100..JK-FF mode
 *  0b101..Latch mode
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define EVTG_EVTG_INST_EVTG_CTRL_MODE_SEL(x)     (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_CTRL_MODE_SEL_SHIFT)) & EVTG_EVTG_INST_EVTG_CTRL_MODE_SEL_MASK)

#define EVTG_EVTG_INST_EVTG_CTRL_FB_OVRD_MASK    (0xC0U)
#define EVTG_EVTG_INST_EVTG_CTRL_FB_OVRD_SHIFT   (6U)
/*! FB_OVRD - EVTG Output Feedback Override Control
 *  0b00..Replace An
 *  0b01..Replace Bn
 *  0b10..Replace Cn
 *  0b11..Replace Dn
 */
#define EVTG_EVTG_INST_EVTG_CTRL_FB_OVRD(x)      (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_CTRL_FB_OVRD_SHIFT)) & EVTG_EVTG_INST_EVTG_CTRL_FB_OVRD_MASK)

#define EVTG_EVTG_INST_EVTG_CTRL_SYNC_CTRL_MASK  (0xF00U)
#define EVTG_EVTG_INST_EVTG_CTRL_SYNC_CTRL_SHIFT (8U)
/*! SYNC_CTRL - Synchronize Control
 *  0bxxx1..EVTG input "An" will be synced by two bus clk cycles
 *  0bxxx0..EVTG input "An" will not be synced
 *  0bxx1x..EVTG input "Bn" will be synced by two bus clk cycles
 *  0bxx0x..EVTG input "Bn" will not be synced
 *  0bx1xx..EVTG input "Cn" will be synced by two bus clk cycles
 *  0bx0xx..EVTG input "Cn" will not be synced
 *  0b1xxx..EVTG input "Dn" will be synced by two bus clk cycles
 *  0b0xxx..EVTG input "Dn" will not be synced
 */
#define EVTG_EVTG_INST_EVTG_CTRL_SYNC_CTRL(x)    (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_CTRL_SYNC_CTRL_SHIFT)) & EVTG_EVTG_INST_EVTG_CTRL_SYNC_CTRL_MASK)

#define EVTG_EVTG_INST_EVTG_CTRL_FORCE_BYPASS_MASK (0x3000U)
#define EVTG_EVTG_INST_EVTG_CTRL_FORCE_BYPASS_SHIFT (12U)
/*! FORCE_BYPASS - Force Bypass Control
 *  0bx1..Whatever MODE_SEL is, will force bypass flip-flop and route the AOI_0(Filter_0) value directly to EVTG_OUTA
 *  0bx0..Will not force the bypass
 *  0b1x..Whatever MODE_SEL is, will force bypass flip-flop and route the AOI_1(Filter_1) value directly to EVTG_OUTB
 *  0b0x..Will not force the bypass
 */
#define EVTG_EVTG_INST_EVTG_CTRL_FORCE_BYPASS(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_CTRL_FORCE_BYPASS_SHIFT)) & EVTG_EVTG_INST_EVTG_CTRL_FORCE_BYPASS_MASK)
/*! @} */

/* The count of EVTG_EVTG_INST_EVTG_CTRL */
#define EVTG_EVTG_INST_EVTG_CTRL_COUNT           (4U)

/*! @name EVTG_INST_EVTG_AOI0_FILT - AOI0 Output Filter */
/*! @{ */

#define EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_PER_MASK (0xFFU)
#define EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_PER_SHIFT (0U)
/*! FILT_PER - Output Filter Sample Period */
#define EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_PER(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_PER_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_PER_MASK)

#define EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_CNT_MASK (0x700U)
#define EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_CNT_SHIFT (8U)
/*! FILT_CNT - Output Filter Sample Count */
#define EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_CNT(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_CNT_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI0_FILT_FILT_CNT_MASK)
/*! @} */

/* The count of EVTG_EVTG_INST_EVTG_AOI0_FILT */
#define EVTG_EVTG_INST_EVTG_AOI0_FILT_COUNT      (4U)

/*! @name EVTG_INST_EVTG_AOI1_FILT - AOI1 Output Filter */
/*! @{ */

#define EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_PER_MASK (0xFFU)
#define EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_PER_SHIFT (0U)
/*! FILT_PER - Output Filter Sample Period */
#define EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_PER(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_PER_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_PER_MASK)

#define EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_CNT_MASK (0x700U)
#define EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_CNT_SHIFT (8U)
/*! FILT_CNT - Output Filter Sample Count */
#define EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_CNT(x) (((uint16_t)(((uint16_t)(x)) << EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_CNT_SHIFT)) & EVTG_EVTG_INST_EVTG_AOI1_FILT_FILT_CNT_MASK)
/*! @} */

/* The count of EVTG_EVTG_INST_EVTG_AOI1_FILT */
#define EVTG_EVTG_INST_EVTG_AOI1_FILT_COUNT      (4U)


/*!
 * @}
 */ /* end of group EVTG_Register_Masks */


/* EVTG - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral EVTG0 base address */
  #define EVTG0_BASE                               (0x500D2000u)
  /** Peripheral EVTG0 base address */
  #define EVTG0_BASE_NS                            (0x400D2000u)
  /** Peripheral EVTG0 base pointer */
  #define EVTG0                                    ((EVTG_Type *)EVTG0_BASE)
  /** Peripheral EVTG0 base pointer */
  #define EVTG0_NS                                 ((EVTG_Type *)EVTG0_BASE_NS)
  /** Array initializer of EVTG peripheral base addresses */
  #define EVTG_BASE_ADDRS                          { EVTG0_BASE }
  /** Array initializer of EVTG peripheral base pointers */
  #define EVTG_BASE_PTRS                           { EVTG0 }
  /** Array initializer of EVTG peripheral base addresses */
  #define EVTG_BASE_ADDRS_NS                       { EVTG0_BASE_NS }
  /** Array initializer of EVTG peripheral base pointers */
  #define EVTG_BASE_PTRS_NS                        { EVTG0_NS }
#else
  /** Peripheral EVTG0 base address */
  #define EVTG0_BASE                               (0x400D2000u)
  /** Peripheral EVTG0 base pointer */
  #define EVTG0                                    ((EVTG_Type *)EVTG0_BASE)
  /** Array initializer of EVTG peripheral base addresses */
  #define EVTG_BASE_ADDRS                          { EVTG0_BASE }
  /** Array initializer of EVTG peripheral base pointers */
  #define EVTG_BASE_PTRS                           { EVTG0 }
#endif

/*!
 * @}
 */ /* end of group EVTG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EWM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Peripheral_Access_Layer EWM Peripheral Access Layer
 * @{
 */

/** EWM - Register Layout Typedef */
typedef struct {
  __IO uint8_t CTRL;                               /**< Control, offset: 0x0 */
  __O  uint8_t SERV;                               /**< Service, offset: 0x1 */
  __IO uint8_t CMPL;                               /**< Compare Low, offset: 0x2 */
  __IO uint8_t CMPH;                               /**< Compare High, offset: 0x3 */
  __IO uint8_t CLKCTRL;                            /**< Clock Control, offset: 0x4 */
  __IO uint8_t CLKPRESCALER;                       /**< Clock Prescaler, offset: 0x5 */
} EWM_Type;

/* ----------------------------------------------------------------------------
   -- EWM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Register_Masks EWM Register Masks
 * @{
 */

/*! @name CTRL - Control */
/*! @{ */

#define EWM_CTRL_EWMEN_MASK                      (0x1U)
#define EWM_CTRL_EWMEN_SHIFT                     (0U)
/*! EWMEN - EWM Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define EWM_CTRL_EWMEN(x)                        (((uint8_t)(((uint8_t)(x)) << EWM_CTRL_EWMEN_SHIFT)) & EWM_CTRL_EWMEN_MASK)

#define EWM_CTRL_ASSIN_MASK                      (0x2U)
#define EWM_CTRL_ASSIN_SHIFT                     (1U)
/*! ASSIN - Assertion State Select
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define EWM_CTRL_ASSIN(x)                        (((uint8_t)(((uint8_t)(x)) << EWM_CTRL_ASSIN_SHIFT)) & EWM_CTRL_ASSIN_MASK)

#define EWM_CTRL_INEN_MASK                       (0x4U)
#define EWM_CTRL_INEN_SHIFT                      (2U)
/*! INEN - Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define EWM_CTRL_INEN(x)                         (((uint8_t)(((uint8_t)(x)) << EWM_CTRL_INEN_SHIFT)) & EWM_CTRL_INEN_MASK)

#define EWM_CTRL_INTEN_MASK                      (0x8U)
#define EWM_CTRL_INTEN_SHIFT                     (3U)
/*! INTEN - Interrupt Enable
 *  0b1..Generates interrupt requests
 *  0b0..Deasserts interrupt requests
 */
#define EWM_CTRL_INTEN(x)                        (((uint8_t)(((uint8_t)(x)) << EWM_CTRL_INTEN_SHIFT)) & EWM_CTRL_INTEN_MASK)
/*! @} */

/*! @name SERV - Service */
/*! @{ */

#define EWM_SERV_SERVICE_MASK                    (0xFFU)
#define EWM_SERV_SERVICE_SHIFT                   (0U)
/*! SERVICE - Service */
#define EWM_SERV_SERVICE(x)                      (((uint8_t)(((uint8_t)(x)) << EWM_SERV_SERVICE_SHIFT)) & EWM_SERV_SERVICE_MASK)
/*! @} */

/*! @name CMPL - Compare Low */
/*! @{ */

#define EWM_CMPL_COMPAREL_MASK                   (0xFFU)
#define EWM_CMPL_COMPAREL_SHIFT                  (0U)
/*! COMPAREL - Compare Low */
#define EWM_CMPL_COMPAREL(x)                     (((uint8_t)(((uint8_t)(x)) << EWM_CMPL_COMPAREL_SHIFT)) & EWM_CMPL_COMPAREL_MASK)
/*! @} */

/*! @name CMPH - Compare High */
/*! @{ */

#define EWM_CMPH_COMPAREH_MASK                   (0xFFU)
#define EWM_CMPH_COMPAREH_SHIFT                  (0U)
/*! COMPAREH - Compare High */
#define EWM_CMPH_COMPAREH(x)                     (((uint8_t)(((uint8_t)(x)) << EWM_CMPH_COMPAREH_SHIFT)) & EWM_CMPH_COMPAREH_MASK)
/*! @} */

/*! @name CLKCTRL - Clock Control */
/*! @{ */

#define EWM_CLKCTRL_CLKSEL_MASK                  (0x3U)
#define EWM_CLKCTRL_CLKSEL_SHIFT                 (0U)
/*! CLKSEL - Clock Select */
#define EWM_CLKCTRL_CLKSEL(x)                    (((uint8_t)(((uint8_t)(x)) << EWM_CLKCTRL_CLKSEL_SHIFT)) & EWM_CLKCTRL_CLKSEL_MASK)
/*! @} */

/*! @name CLKPRESCALER - Clock Prescaler */
/*! @{ */

#define EWM_CLKPRESCALER_CLK_DIV_MASK            (0xFFU)
#define EWM_CLKPRESCALER_CLK_DIV_SHIFT           (0U)
/*! CLK_DIV - Clock Divider */
#define EWM_CLKPRESCALER_CLK_DIV(x)              (((uint8_t)(((uint8_t)(x)) << EWM_CLKPRESCALER_CLK_DIV_SHIFT)) & EWM_CLKPRESCALER_CLK_DIV_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group EWM_Register_Masks */


/* EWM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral EWM0 base address */
  #define EWM0_BASE                                (0x500C0000u)
  /** Peripheral EWM0 base address */
  #define EWM0_BASE_NS                             (0x400C0000u)
  /** Peripheral EWM0 base pointer */
  #define EWM0                                     ((EWM_Type *)EWM0_BASE)
  /** Peripheral EWM0 base pointer */
  #define EWM0_NS                                  ((EWM_Type *)EWM0_BASE_NS)
  /** Array initializer of EWM peripheral base addresses */
  #define EWM_BASE_ADDRS                           { EWM0_BASE }
  /** Array initializer of EWM peripheral base pointers */
  #define EWM_BASE_PTRS                            { EWM0 }
  /** Array initializer of EWM peripheral base addresses */
  #define EWM_BASE_ADDRS_NS                        { EWM0_BASE_NS }
  /** Array initializer of EWM peripheral base pointers */
  #define EWM_BASE_PTRS_NS                         { EWM0_NS }
#else
  /** Peripheral EWM0 base address */
  #define EWM0_BASE                                (0x400C0000u)
  /** Peripheral EWM0 base pointer */
  #define EWM0                                     ((EWM_Type *)EWM0_BASE)
  /** Array initializer of EWM peripheral base addresses */
  #define EWM_BASE_ADDRS                           { EWM0_BASE }
  /** Array initializer of EWM peripheral base pointers */
  #define EWM_BASE_PTRS                            { EWM0 }
#endif

/*!
 * @}
 */ /* end of group EWM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Peripheral_Access_Layer FLEXIO Peripheral Access Layer
 * @{
 */

/** FLEXIO - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< FLEXIO Control, offset: 0x8 */
  __I  uint32_t PIN;                               /**< Pin State, offset: 0xC */
  __IO uint32_t SHIFTSTAT;                         /**< Shifter Status, offset: 0x10 */
  __IO uint32_t SHIFTERR;                          /**< Shifter Error, offset: 0x14 */
  __IO uint32_t TIMSTAT;                           /**< Timer Status, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t SHIFTSIEN;                         /**< Shifter Status Interrupt Enable, offset: 0x20 */
  __IO uint32_t SHIFTEIEN;                         /**< Shifter Error Interrupt Enable, offset: 0x24 */
  __IO uint32_t TIMIEN;                            /**< Timer Interrupt Enable, offset: 0x28 */
       uint8_t RESERVED_1[4];
  __IO uint32_t SHIFTSDEN;                         /**< Shifter Status DMA Enable, offset: 0x30 */
       uint8_t RESERVED_2[4];
  __IO uint32_t TIMERSDEN;                         /**< Timer Status DMA Enable, offset: 0x38 */
       uint8_t RESERVED_3[4];
  __IO uint32_t SHIFTSTATE;                        /**< Shifter State, offset: 0x40 */
       uint8_t RESERVED_4[4];
  __IO uint32_t TRGSTAT;                           /**< Trigger Status, offset: 0x48 */
  __IO uint32_t TRIGIEN;                           /**< External Trigger Interrupt Enable, offset: 0x4C */
  __IO uint32_t PINSTAT;                           /**< Pin Status, offset: 0x50 */
  __IO uint32_t PINIEN;                            /**< Pin Interrupt Enable, offset: 0x54 */
  __IO uint32_t PINREN;                            /**< Pin Rising Edge Enable, offset: 0x58 */
  __IO uint32_t PINFEN;                            /**< Pin Falling Edge Enable, offset: 0x5C */
  __IO uint32_t PINOUTD;                           /**< Pin Output Data, offset: 0x60 */
  __IO uint32_t PINOUTE;                           /**< Pin Output Enable, offset: 0x64 */
  __O  uint32_t PINOUTDIS;                         /**< Pin Output Disable, offset: 0x68 */
  __O  uint32_t PINOUTCLR;                         /**< Pin Output Clear, offset: 0x6C */
  __O  uint32_t PINOUTSET;                         /**< Pin Output Set, offset: 0x70 */
  __O  uint32_t PINOUTTOG;                         /**< Pin Output Toggle, offset: 0x74 */
       uint8_t RESERVED_5[8];
  __IO uint32_t SHIFTCTL[8];                       /**< Shifter Control N, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_6[96];
  __IO uint32_t SHIFTCFG[8];                       /**< Shifter Configuration N, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_7[224];
  __IO uint32_t SHIFTBUF[8];                       /**< Shifter Buffer N, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_8[96];
  __IO uint32_t SHIFTBUFBIS[8];                    /**< Shifter Buffer N Bit Swapped, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_9[96];
  __IO uint32_t SHIFTBUFBYS[8];                    /**< Shifter Buffer N Byte Swapped, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_10[96];
  __IO uint32_t SHIFTBUFBBS[8];                    /**< Shifter Buffer N Bit Byte Swapped, array offset: 0x380, array step: 0x4 */
       uint8_t RESERVED_11[96];
  __IO uint32_t TIMCTL[8];                         /**< Timer Control N, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_12[96];
  __IO uint32_t TIMCFG[8];                         /**< Timer Configuration N, array offset: 0x480, array step: 0x4 */
       uint8_t RESERVED_13[96];
  __IO uint32_t TIMCMP[8];                         /**< Timer Compare N, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_14[352];
  __IO uint32_t SHIFTBUFNBS[8];                    /**< Shifter Buffer N Nibble Byte Swapped, array offset: 0x680, array step: 0x4 */
       uint8_t RESERVED_15[96];
  __IO uint32_t SHIFTBUFHWS[8];                    /**< Shifter Buffer N Halfword Swapped, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_16[96];
  __IO uint32_t SHIFTBUFNIS[8];                    /**< Shifter Buffer N Nibble Swapped, array offset: 0x780, array step: 0x4 */
       uint8_t RESERVED_17[96];
  __IO uint32_t SHIFTBUFOES[8];                    /**< Shifter Buffer N Odd Even Swapped, array offset: 0x800, array step: 0x4 */
       uint8_t RESERVED_18[96];
  __IO uint32_t SHIFTBUFEOS[8];                    /**< Shifter Buffer N Even Odd Swapped, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_19[96];
  __IO uint32_t SHIFTBUFHBS[8];                    /**< Shifter Buffer N Halfword Byte Swapped, array offset: 0x900, array step: 0x4 */
} FLEXIO_Type;

/* ----------------------------------------------------------------------------
   -- FLEXIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Register_Masks FLEXIO Register Masks
 * @{
 */

/*! @name VERID - Version ID */
/*! @{ */

#define FLEXIO_VERID_FEATURE_MASK                (0xFFFFU)
#define FLEXIO_VERID_FEATURE_SHIFT               (0U)
/*! FEATURE - Feature Specification Number
 *  0b0000000000000000..Standard features implemented.
 *  0b0000000000000001..Supports state, logic, and parallel modes.
 *  0b0000000000000010..Supports pin control registers.
 *  0b0000000000000011..Supports state, logic, and parallel modes, plus pin control registers.
 */
#define FLEXIO_VERID_FEATURE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_FEATURE_SHIFT)) & FLEXIO_VERID_FEATURE_MASK)

#define FLEXIO_VERID_MINOR_MASK                  (0xFF0000U)
#define FLEXIO_VERID_MINOR_SHIFT                 (16U)
/*! MINOR - Minor Version Number */
#define FLEXIO_VERID_MINOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MINOR_SHIFT)) & FLEXIO_VERID_MINOR_MASK)

#define FLEXIO_VERID_MAJOR_MASK                  (0xFF000000U)
#define FLEXIO_VERID_MAJOR_SHIFT                 (24U)
/*! MAJOR - Major Version Number */
#define FLEXIO_VERID_MAJOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MAJOR_SHIFT)) & FLEXIO_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter */
/*! @{ */

#define FLEXIO_PARAM_SHIFTER_MASK                (0xFFU)
#define FLEXIO_PARAM_SHIFTER_SHIFT               (0U)
/*! SHIFTER - Shifter Number */
#define FLEXIO_PARAM_SHIFTER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_SHIFTER_SHIFT)) & FLEXIO_PARAM_SHIFTER_MASK)

#define FLEXIO_PARAM_TIMER_MASK                  (0xFF00U)
#define FLEXIO_PARAM_TIMER_SHIFT                 (8U)
/*! TIMER - Timer Number */
#define FLEXIO_PARAM_TIMER(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TIMER_SHIFT)) & FLEXIO_PARAM_TIMER_MASK)

#define FLEXIO_PARAM_PIN_MASK                    (0xFF0000U)
#define FLEXIO_PARAM_PIN_SHIFT                   (16U)
/*! PIN - Pin Number */
#define FLEXIO_PARAM_PIN(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_PIN_SHIFT)) & FLEXIO_PARAM_PIN_MASK)

#define FLEXIO_PARAM_TRIGGER_MASK                (0xFF000000U)
#define FLEXIO_PARAM_TRIGGER_SHIFT               (24U)
/*! TRIGGER - Trigger Number */
#define FLEXIO_PARAM_TRIGGER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TRIGGER_SHIFT)) & FLEXIO_PARAM_TRIGGER_MASK)
/*! @} */

/*! @name CTRL - FLEXIO Control */
/*! @{ */

#define FLEXIO_CTRL_FLEXEN_MASK                  (0x1U)
#define FLEXIO_CTRL_FLEXEN_SHIFT                 (0U)
/*! FLEXEN - FLEXIO Enable
 *  0b0..FLEXIO module is disabled.
 *  0b1..FLEXIO module is enabled.
 */
#define FLEXIO_CTRL_FLEXEN(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FLEXEN_SHIFT)) & FLEXIO_CTRL_FLEXEN_MASK)

#define FLEXIO_CTRL_SWRST_MASK                   (0x2U)
#define FLEXIO_CTRL_SWRST_SHIFT                  (1U)
/*! SWRST - Software Reset
 *  0b0..Software reset is disabled
 *  0b1..Software reset is enabled. All FLEXIO registers except the Control Register are reset.
 */
#define FLEXIO_CTRL_SWRST(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_SWRST_SHIFT)) & FLEXIO_CTRL_SWRST_MASK)

#define FLEXIO_CTRL_FASTACC_MASK                 (0x4U)
#define FLEXIO_CTRL_FASTACC_SHIFT                (2U)
/*! FASTACC - Fast Access
 *  0b0..Configures for normal register accesses to FLEXIO
 *  0b1..Configures for fast register accesses to FLEXIO
 */
#define FLEXIO_CTRL_FASTACC(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FASTACC_SHIFT)) & FLEXIO_CTRL_FASTACC_MASK)

#define FLEXIO_CTRL_DBGE_MASK                    (0x40000000U)
#define FLEXIO_CTRL_DBGE_SHIFT                   (30U)
/*! DBGE - Debug Enable
 *  0b0..FLEXIO is disabled in Debug modes.
 *  0b1..FLEXIO is enabled in Debug modes.
 */
#define FLEXIO_CTRL_DBGE(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DBGE_SHIFT)) & FLEXIO_CTRL_DBGE_MASK)

#define FLEXIO_CTRL_DOZEN_MASK                   (0x80000000U)
#define FLEXIO_CTRL_DOZEN_SHIFT                  (31U)
/*! DOZEN - Doze Enable
 *  0b0..FLEXIO enabled in Doze modes.
 *  0b1..FLEXIO disabled in Doze modes.
 */
#define FLEXIO_CTRL_DOZEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DOZEN_SHIFT)) & FLEXIO_CTRL_DOZEN_MASK)
/*! @} */

/*! @name PIN - Pin State */
/*! @{ */

#define FLEXIO_PIN_PDI_MASK                      (0xFFFFFFFFU)
#define FLEXIO_PIN_PDI_SHIFT                     (0U)
/*! PDI - Pin Data Input */
#define FLEXIO_PIN_PDI(x)                        (((uint32_t)(((uint32_t)(x)) << FLEXIO_PIN_PDI_SHIFT)) & FLEXIO_PIN_PDI_MASK)
/*! @} */

/*! @name SHIFTSTAT - Shifter Status */
/*! @{ */

#define FLEXIO_SHIFTSTAT_SSF_MASK                (0xFFU)
#define FLEXIO_SHIFTSTAT_SSF_SHIFT               (0U)
/*! SSF - Shifter Status Flag */
#define FLEXIO_SHIFTSTAT_SSF(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTAT_SSF_SHIFT)) & FLEXIO_SHIFTSTAT_SSF_MASK)
/*! @} */

/*! @name SHIFTERR - Shifter Error */
/*! @{ */

#define FLEXIO_SHIFTERR_SEF_MASK                 (0xFFU)
#define FLEXIO_SHIFTERR_SEF_SHIFT                (0U)
/*! SEF - Shifter Error Flags */
#define FLEXIO_SHIFTERR_SEF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTERR_SEF_SHIFT)) & FLEXIO_SHIFTERR_SEF_MASK)
/*! @} */

/*! @name TIMSTAT - Timer Status */
/*! @{ */

#define FLEXIO_TIMSTAT_TSF_MASK                  (0xFFU)
#define FLEXIO_TIMSTAT_TSF_SHIFT                 (0U)
/*! TSF - Timer Status Flags */
#define FLEXIO_TIMSTAT_TSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMSTAT_TSF_SHIFT)) & FLEXIO_TIMSTAT_TSF_MASK)
/*! @} */

/*! @name SHIFTSIEN - Shifter Status Interrupt Enable */
/*! @{ */

#define FLEXIO_SHIFTSIEN_SSIE_MASK               (0xFFU)
#define FLEXIO_SHIFTSIEN_SSIE_SHIFT              (0U)
/*! SSIE - Shifter Status Interrupt Enable */
#define FLEXIO_SHIFTSIEN_SSIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSIEN_SSIE_SHIFT)) & FLEXIO_SHIFTSIEN_SSIE_MASK)
/*! @} */

/*! @name SHIFTEIEN - Shifter Error Interrupt Enable */
/*! @{ */

#define FLEXIO_SHIFTEIEN_SEIE_MASK               (0xFFU)
#define FLEXIO_SHIFTEIEN_SEIE_SHIFT              (0U)
/*! SEIE - Shifter Error Interrupt Enable */
#define FLEXIO_SHIFTEIEN_SEIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTEIEN_SEIE_SHIFT)) & FLEXIO_SHIFTEIEN_SEIE_MASK)
/*! @} */

/*! @name TIMIEN - Timer Interrupt Enable */
/*! @{ */

#define FLEXIO_TIMIEN_TEIE_MASK                  (0xFFU)
#define FLEXIO_TIMIEN_TEIE_SHIFT                 (0U)
/*! TEIE - Timer Status Interrupt Enable */
#define FLEXIO_TIMIEN_TEIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMIEN_TEIE_SHIFT)) & FLEXIO_TIMIEN_TEIE_MASK)
/*! @} */

/*! @name SHIFTSDEN - Shifter Status DMA Enable */
/*! @{ */

#define FLEXIO_SHIFTSDEN_SSDE_MASK               (0xFFU)
#define FLEXIO_SHIFTSDEN_SSDE_SHIFT              (0U)
/*! SSDE - Shifter Status DMA Enable */
#define FLEXIO_SHIFTSDEN_SSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSDEN_SSDE_SHIFT)) & FLEXIO_SHIFTSDEN_SSDE_MASK)
/*! @} */

/*! @name TIMERSDEN - Timer Status DMA Enable */
/*! @{ */

#define FLEXIO_TIMERSDEN_TSDE_MASK               (0xFFU)
#define FLEXIO_TIMERSDEN_TSDE_SHIFT              (0U)
/*! TSDE - Timer Status DMA Enable */
#define FLEXIO_TIMERSDEN_TSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMERSDEN_TSDE_SHIFT)) & FLEXIO_TIMERSDEN_TSDE_MASK)
/*! @} */

/*! @name SHIFTSTATE - Shifter State */
/*! @{ */

#define FLEXIO_SHIFTSTATE_STATE_MASK             (0x7U)
#define FLEXIO_SHIFTSTATE_STATE_SHIFT            (0U)
/*! STATE - Current State Pointer */
#define FLEXIO_SHIFTSTATE_STATE(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTATE_STATE_SHIFT)) & FLEXIO_SHIFTSTATE_STATE_MASK)
/*! @} */

/*! @name TRGSTAT - Trigger Status */
/*! @{ */

#define FLEXIO_TRGSTAT_ETSF_MASK                 (0xFFU)
#define FLEXIO_TRGSTAT_ETSF_SHIFT                (0U)
/*! ETSF - External Trigger Status Flags */
#define FLEXIO_TRGSTAT_ETSF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRGSTAT_ETSF_SHIFT)) & FLEXIO_TRGSTAT_ETSF_MASK)
/*! @} */

/*! @name TRIGIEN - External Trigger Interrupt Enable */
/*! @{ */

#define FLEXIO_TRIGIEN_TRIE_MASK                 (0xFFU)
#define FLEXIO_TRIGIEN_TRIE_SHIFT                (0U)
/*! TRIE - External Trigger Interrupt Enable */
#define FLEXIO_TRIGIEN_TRIE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRIGIEN_TRIE_SHIFT)) & FLEXIO_TRIGIEN_TRIE_MASK)
/*! @} */

/*! @name PINSTAT - Pin Status */
/*! @{ */

#define FLEXIO_PINSTAT_PSF_MASK                  (0xFFFFFFFFU)
#define FLEXIO_PINSTAT_PSF_SHIFT                 (0U)
/*! PSF - Pin Status Flags */
#define FLEXIO_PINSTAT_PSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINSTAT_PSF_SHIFT)) & FLEXIO_PINSTAT_PSF_MASK)
/*! @} */

/*! @name PINIEN - Pin Interrupt Enable */
/*! @{ */

#define FLEXIO_PINIEN_PSIE_MASK                  (0xFFFFFFFFU)
#define FLEXIO_PINIEN_PSIE_SHIFT                 (0U)
/*! PSIE - Pin Status Interrupt Enable */
#define FLEXIO_PINIEN_PSIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINIEN_PSIE_SHIFT)) & FLEXIO_PINIEN_PSIE_MASK)
/*! @} */

/*! @name PINREN - Pin Rising Edge Enable */
/*! @{ */

#define FLEXIO_PINREN_PRE_MASK                   (0xFFFFFFFFU)
#define FLEXIO_PINREN_PRE_SHIFT                  (0U)
/*! PRE - Pin Rising Edge */
#define FLEXIO_PINREN_PRE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINREN_PRE_SHIFT)) & FLEXIO_PINREN_PRE_MASK)
/*! @} */

/*! @name PINFEN - Pin Falling Edge Enable */
/*! @{ */

#define FLEXIO_PINFEN_PFE_MASK                   (0xFFFFFFFFU)
#define FLEXIO_PINFEN_PFE_SHIFT                  (0U)
/*! PFE - Pin Falling Edge */
#define FLEXIO_PINFEN_PFE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINFEN_PFE_SHIFT)) & FLEXIO_PINFEN_PFE_MASK)
/*! @} */

/*! @name PINOUTD - Pin Output Data */
/*! @{ */

#define FLEXIO_PINOUTD_OUTD_MASK                 (0xFFFFFFFFU)
#define FLEXIO_PINOUTD_OUTD_SHIFT                (0U)
/*! OUTD - Output Data */
#define FLEXIO_PINOUTD_OUTD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTD_OUTD_SHIFT)) & FLEXIO_PINOUTD_OUTD_MASK)
/*! @} */

/*! @name PINOUTE - Pin Output Enable */
/*! @{ */

#define FLEXIO_PINOUTE_OUTE_MASK                 (0xFFFFFFFFU)
#define FLEXIO_PINOUTE_OUTE_SHIFT                (0U)
/*! OUTE - Output Enable */
#define FLEXIO_PINOUTE_OUTE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTE_OUTE_SHIFT)) & FLEXIO_PINOUTE_OUTE_MASK)
/*! @} */

/*! @name PINOUTDIS - Pin Output Disable */
/*! @{ */

#define FLEXIO_PINOUTDIS_OUTDIS_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTDIS_OUTDIS_SHIFT            (0U)
/*! OUTDIS - Output Disable */
#define FLEXIO_PINOUTDIS_OUTDIS(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTDIS_OUTDIS_SHIFT)) & FLEXIO_PINOUTDIS_OUTDIS_MASK)
/*! @} */

/*! @name PINOUTCLR - Pin Output Clear */
/*! @{ */

#define FLEXIO_PINOUTCLR_OUTCLR_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTCLR_OUTCLR_SHIFT            (0U)
/*! OUTCLR - Output Clear */
#define FLEXIO_PINOUTCLR_OUTCLR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTCLR_OUTCLR_SHIFT)) & FLEXIO_PINOUTCLR_OUTCLR_MASK)
/*! @} */

/*! @name PINOUTSET - Pin Output Set */
/*! @{ */

#define FLEXIO_PINOUTSET_OUTSET_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTSET_OUTSET_SHIFT            (0U)
/*! OUTSET - Output Set */
#define FLEXIO_PINOUTSET_OUTSET(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTSET_OUTSET_SHIFT)) & FLEXIO_PINOUTSET_OUTSET_MASK)
/*! @} */

/*! @name PINOUTTOG - Pin Output Toggle */
/*! @{ */

#define FLEXIO_PINOUTTOG_OUTTOG_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTTOG_OUTTOG_SHIFT            (0U)
/*! OUTTOG - Output Toggle */
#define FLEXIO_PINOUTTOG_OUTTOG(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTTOG_OUTTOG_SHIFT)) & FLEXIO_PINOUTTOG_OUTTOG_MASK)
/*! @} */

/*! @name SHIFTCTL - Shifter Control N */
/*! @{ */

#define FLEXIO_SHIFTCTL_SMOD_MASK                (0x7U)
#define FLEXIO_SHIFTCTL_SMOD_SHIFT               (0U)
/*! SMOD - Shifter Mode
 *  0b000..Disabled.
 *  0b001..Receive mode. Captures the current shifter content into the SHIFTBUF on expiration of the timer.
 *  0b010..Transmit mode. Load SHIFTBUF contents into the shifter on expiration of the timer.
 *  0b011..Reserved.
 *  0b100..Match Store mode. Shifter data is compared to SHIFTBUF content on expiration of the timer.
 *  0b101..Match Continuous mode. Shifter data is continuously compared to SHIFTBUF contents.
 *  0b110..State mode. SHIFTBUF contents are used for storing programmable state attributes.
 *  0b111..Logic mode. SHIFTBUF contents are used for implementing programmable logic lookup table.
 */
#define FLEXIO_SHIFTCTL_SMOD(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_SMOD_SHIFT)) & FLEXIO_SHIFTCTL_SMOD_MASK)

#define FLEXIO_SHIFTCTL_PINPOL_MASK              (0x80U)
#define FLEXIO_SHIFTCTL_PINPOL_SHIFT             (7U)
/*! PINPOL - Shifter Pin Polarity
 *  0b0..Pin is active high
 *  0b1..Pin is active low
 */
#define FLEXIO_SHIFTCTL_PINPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINPOL_SHIFT)) & FLEXIO_SHIFTCTL_PINPOL_MASK)

#define FLEXIO_SHIFTCTL_PINSEL_MASK              (0x1F00U)
#define FLEXIO_SHIFTCTL_PINSEL_SHIFT             (8U)
/*! PINSEL - Shifter Pin Select */
#define FLEXIO_SHIFTCTL_PINSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINSEL_SHIFT)) & FLEXIO_SHIFTCTL_PINSEL_MASK)

#define FLEXIO_SHIFTCTL_PINCFG_MASK              (0x30000U)
#define FLEXIO_SHIFTCTL_PINCFG_SHIFT             (16U)
/*! PINCFG - Shifter Pin Configuration
 *  0b00..Shifter pin output disabled
 *  0b01..Shifter pin open-drain or bidirectional output enable
 *  0b10..Shifter pin bidirectional output data
 *  0b11..Shifter pin output
 */
#define FLEXIO_SHIFTCTL_PINCFG(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINCFG_SHIFT)) & FLEXIO_SHIFTCTL_PINCFG_MASK)

#define FLEXIO_SHIFTCTL_TIMPOL_MASK              (0x800000U)
#define FLEXIO_SHIFTCTL_TIMPOL_SHIFT             (23U)
/*! TIMPOL - Timer Polarity
 *  0b0..Shift on posedge of shift clock
 *  0b1..Shift on negedge of shift clock
 */
#define FLEXIO_SHIFTCTL_TIMPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMPOL_SHIFT)) & FLEXIO_SHIFTCTL_TIMPOL_MASK)

#define FLEXIO_SHIFTCTL_TIMSEL_MASK              (0x7000000U)
#define FLEXIO_SHIFTCTL_TIMSEL_SHIFT             (24U)
/*! TIMSEL - Timer Select */
#define FLEXIO_SHIFTCTL_TIMSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMSEL_SHIFT)) & FLEXIO_SHIFTCTL_TIMSEL_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCTL */
#define FLEXIO_SHIFTCTL_COUNT                    (8U)

/*! @name SHIFTCFG - Shifter Configuration N */
/*! @{ */

#define FLEXIO_SHIFTCFG_SSTART_MASK              (0x3U)
#define FLEXIO_SHIFTCFG_SSTART_SHIFT             (0U)
/*! SSTART - Shifter Start Bit
 *  0b00..Start bit disabled for transmitter/receiver/match store. Transmitter loads data on enable.
 *  0b01..Start bit disabled for transmitter/receiver/match store. Transmitter loads data on first shift.
 *  0b10..Transmitter outputs start bit value 0 before loading data on first shift. If start bit is not 0, receiver/match store sets error flag.
 *  0b11..Transmitter outputs start bit value 1 before loading data on first shift. If start bit is not 1, receiver/match store sets error flag.
 */
#define FLEXIO_SHIFTCFG_SSTART(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTART_SHIFT)) & FLEXIO_SHIFTCFG_SSTART_MASK)

#define FLEXIO_SHIFTCFG_SSTOP_MASK               (0x30U)
#define FLEXIO_SHIFTCFG_SSTOP_SHIFT              (4U)
/*! SSTOP - Shifter Stop bit
 *  0b00..Stop bit disabled for transmitter/receiver/match store
 *  0b01..Stop bit disabled for transmitter/receiver/match store. When timer is in stop condition, receiver/match
 *        store stores receive data on the configured shift edge.
 *  0b10..Transmitter outputs stop bit value 0 on store. If stop bit is not 0, receiver/match store sets error
 *        flag. When timer is in stop condition, receiver/match stores also store receive data on the configured shift
 *        edge.
 *  0b11..Transmitter outputs stop bit value 1 on store. If stop bit is not 1, receiver/match store sets error
 *        flag. When timer is in stop condition, receiver/match store also stores receive data on the configured shift
 *        edge.
 */
#define FLEXIO_SHIFTCFG_SSTOP(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTOP_SHIFT)) & FLEXIO_SHIFTCFG_SSTOP_MASK)

#define FLEXIO_SHIFTCFG_INSRC_MASK               (0x100U)
#define FLEXIO_SHIFTCFG_INSRC_SHIFT              (8U)
/*! INSRC - Input Source
 *  0b0..Pin
 *  0b1..Shifter N+1 Output
 */
#define FLEXIO_SHIFTCFG_INSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_INSRC_SHIFT)) & FLEXIO_SHIFTCFG_INSRC_MASK)

#define FLEXIO_SHIFTCFG_LATST_MASK               (0x200U)
#define FLEXIO_SHIFTCFG_LATST_SHIFT              (9U)
/*! LATST - Late Store
 *  0b0..Shift register stores the pre-shift register state.
 *  0b1..Shift register stores the post-shift register state.
 */
#define FLEXIO_SHIFTCFG_LATST(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_LATST_SHIFT)) & FLEXIO_SHIFTCFG_LATST_MASK)

#define FLEXIO_SHIFTCFG_SSIZE_MASK               (0x1000U)
#define FLEXIO_SHIFTCFG_SSIZE_SHIFT              (12U)
/*! SSIZE - Shifter Size
 *  0b0..Shift register is 32-bit.
 *  0b1..Shift register is 24-bit.
 */
#define FLEXIO_SHIFTCFG_SSIZE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSIZE_SHIFT)) & FLEXIO_SHIFTCFG_SSIZE_MASK)

#define FLEXIO_SHIFTCFG_PWIDTH_MASK              (0x1F0000U)
#define FLEXIO_SHIFTCFG_PWIDTH_SHIFT             (16U)
/*! PWIDTH - Parallel Width */
#define FLEXIO_SHIFTCFG_PWIDTH(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_PWIDTH_SHIFT)) & FLEXIO_SHIFTCFG_PWIDTH_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCFG */
#define FLEXIO_SHIFTCFG_COUNT                    (8U)

/*! @name SHIFTBUF - Shifter Buffer N */
/*! @{ */

#define FLEXIO_SHIFTBUF_SHIFTBUF_MASK            (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT           (0U)
/*! SHIFTBUF - Shift Buffer */
#define FLEXIO_SHIFTBUF_SHIFTBUF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT)) & FLEXIO_SHIFTBUF_SHIFTBUF_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUF */
#define FLEXIO_SHIFTBUF_COUNT                    (8U)

/*! @name SHIFTBUFBIS - Shifter Buffer N Bit Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT     (0U)
/*! SHIFTBUFBIS - Shift Buffer */
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT)) & FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBIS */
#define FLEXIO_SHIFTBUFBIS_COUNT                 (8U)

/*! @name SHIFTBUFBYS - Shifter Buffer N Byte Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT     (0U)
/*! SHIFTBUFBYS - Shift Buffer */
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT)) & FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBYS */
#define FLEXIO_SHIFTBUFBYS_COUNT                 (8U)

/*! @name SHIFTBUFBBS - Shifter Buffer N Bit Byte Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT     (0U)
/*! SHIFTBUFBBS - Shift Buffer */
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT)) & FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBBS */
#define FLEXIO_SHIFTBUFBBS_COUNT                 (8U)

/*! @name TIMCTL - Timer Control N */
/*! @{ */

#define FLEXIO_TIMCTL_TIMOD_MASK                 (0x7U)
#define FLEXIO_TIMCTL_TIMOD_SHIFT                (0U)
/*! TIMOD - Timer Mode
 *  0b000..Timer disabled.
 *  0b001..Dual 8-bit counters baud mode.
 *  0b010..Dual 8-bit counters PWM high mode.
 *  0b011..Single 16-bit counter mode.
 *  0b100..Single 16-bit counter disable mode.
 *  0b101..Dual 8-bit counters word mode.
 *  0b110..Dual 8-bit counters PWM low mode.
 *  0b111..Single 16-bit input capture mode.
 */
#define FLEXIO_TIMCTL_TIMOD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TIMOD_SHIFT)) & FLEXIO_TIMCTL_TIMOD_MASK)

#define FLEXIO_TIMCTL_ONETIM_MASK                (0x20U)
#define FLEXIO_TIMCTL_ONETIM_SHIFT               (5U)
/*! ONETIM - Timer One Time Operation
 *  0b0..The timer enable event is generated as normal.
 *  0b1..The timer enable event is blocked unless timer status flag is clear.
 */
#define FLEXIO_TIMCTL_ONETIM(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_ONETIM_SHIFT)) & FLEXIO_TIMCTL_ONETIM_MASK)

#define FLEXIO_TIMCTL_PININS_MASK                (0x40U)
#define FLEXIO_TIMCTL_PININS_SHIFT               (6U)
/*! PININS - Timer Pin Input Select
 *  0b0..Timer pin input and output are selected by PINSEL.
 *  0b1..Timer pin input is selected by PINSEL+1. Timer pin output remains selected by PINSEL.
 */
#define FLEXIO_TIMCTL_PININS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PININS_SHIFT)) & FLEXIO_TIMCTL_PININS_MASK)

#define FLEXIO_TIMCTL_PINPOL_MASK                (0x80U)
#define FLEXIO_TIMCTL_PINPOL_SHIFT               (7U)
/*! PINPOL - Timer Pin Polarity
 *  0b0..Pin is active high
 *  0b1..Pin is active low
 */
#define FLEXIO_TIMCTL_PINPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINPOL_SHIFT)) & FLEXIO_TIMCTL_PINPOL_MASK)

#define FLEXIO_TIMCTL_PINSEL_MASK                (0x1F00U)
#define FLEXIO_TIMCTL_PINSEL_SHIFT               (8U)
/*! PINSEL - Timer Pin Select */
#define FLEXIO_TIMCTL_PINSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINSEL_SHIFT)) & FLEXIO_TIMCTL_PINSEL_MASK)

#define FLEXIO_TIMCTL_PINCFG_MASK                (0x30000U)
#define FLEXIO_TIMCTL_PINCFG_SHIFT               (16U)
/*! PINCFG - Timer Pin Configuration
 *  0b00..Timer pin output disabled
 *  0b01..Timer pin open-drain or bidirectional output enable
 *  0b10..Timer pin bidirectional output data
 *  0b11..Timer pin output
 */
#define FLEXIO_TIMCTL_PINCFG(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINCFG_SHIFT)) & FLEXIO_TIMCTL_PINCFG_MASK)

#define FLEXIO_TIMCTL_TRGSRC_MASK                (0x400000U)
#define FLEXIO_TIMCTL_TRGSRC_SHIFT               (22U)
/*! TRGSRC - Trigger Source
 *  0b0..External trigger selected
 *  0b1..Internal trigger selected
 */
#define FLEXIO_TIMCTL_TRGSRC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSRC_SHIFT)) & FLEXIO_TIMCTL_TRGSRC_MASK)

#define FLEXIO_TIMCTL_TRGPOL_MASK                (0x800000U)
#define FLEXIO_TIMCTL_TRGPOL_SHIFT               (23U)
/*! TRGPOL - Trigger Polarity
 *  0b0..Trigger active high
 *  0b1..Trigger active low
 */
#define FLEXIO_TIMCTL_TRGPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGPOL_SHIFT)) & FLEXIO_TIMCTL_TRGPOL_MASK)

#define FLEXIO_TIMCTL_TRGSEL_MASK                (0x3F000000U)
#define FLEXIO_TIMCTL_TRGSEL_SHIFT               (24U)
/*! TRGSEL - Trigger Select */
#define FLEXIO_TIMCTL_TRGSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSEL_SHIFT)) & FLEXIO_TIMCTL_TRGSEL_MASK)
/*! @} */

/* The count of FLEXIO_TIMCTL */
#define FLEXIO_TIMCTL_COUNT                      (8U)

/*! @name TIMCFG - Timer Configuration N */
/*! @{ */

#define FLEXIO_TIMCFG_TSTART_MASK                (0x2U)
#define FLEXIO_TIMCFG_TSTART_SHIFT               (1U)
/*! TSTART - Timer Start Bit
 *  0b0..Start bit disabled
 *  0b1..Start bit enabled
 */
#define FLEXIO_TIMCFG_TSTART(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTART_SHIFT)) & FLEXIO_TIMCFG_TSTART_MASK)

#define FLEXIO_TIMCFG_TSTOP_MASK                 (0x30U)
#define FLEXIO_TIMCFG_TSTOP_SHIFT                (4U)
/*! TSTOP - Timer Stop Bit
 *  0b00..Stop bit disabled
 *  0b01..Stop bit is enabled on timer compare
 *  0b10..Stop bit is enabled on timer disable
 *  0b11..Stop bit is enabled on timer compare and timer disable
 */
#define FLEXIO_TIMCFG_TSTOP(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTOP_SHIFT)) & FLEXIO_TIMCFG_TSTOP_MASK)

#define FLEXIO_TIMCFG_TIMENA_MASK                (0x700U)
#define FLEXIO_TIMCFG_TIMENA_SHIFT               (8U)
/*! TIMENA - Timer Enable
 *  0b000..Timer always enabled
 *  0b001..Timer enabled on Timer N-1 enable
 *  0b010..Timer enabled on Trigger high
 *  0b011..Timer enabled on Trigger high and Pin high
 *  0b100..Timer enabled on Pin rising edge
 *  0b101..Timer enabled on Pin rising edge and Trigger high
 *  0b110..Timer enabled on Trigger rising edge
 *  0b111..Timer enabled on Trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMENA(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMENA_SHIFT)) & FLEXIO_TIMCFG_TIMENA_MASK)

#define FLEXIO_TIMCFG_TIMDIS_MASK                (0x7000U)
#define FLEXIO_TIMCFG_TIMDIS_SHIFT               (12U)
/*! TIMDIS - Timer Disable
 *  0b000..Timer never disabled
 *  0b001..Timer disabled on Timer N-1 disable
 *  0b010..Timer disabled on timer compare (upper 8-bits match and decrement)
 *  0b011..Timer disabled on timer compare (upper 8-bits match and decrement) and trigger low
 *  0b100..Timer disabled on pin rising or falling edge
 *  0b101..Timer disabled on pin rising or falling edge provided trigger is high
 *  0b110..Timer disabled on trigger falling edge
 *  0b111..Reserved
 */
#define FLEXIO_TIMCFG_TIMDIS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDIS_SHIFT)) & FLEXIO_TIMCFG_TIMDIS_MASK)

#define FLEXIO_TIMCFG_TIMRST_MASK                (0x70000U)
#define FLEXIO_TIMCFG_TIMRST_SHIFT               (16U)
/*! TIMRST - Timer Reset
 *  0b000..Timer never reset
 *  0b001..Timer reset on timer output high.
 *  0b010..Timer reset on timer pin equal to timer output
 *  0b011..Timer reset on timer trigger equal to timer output
 *  0b100..Timer reset on timer pin rising edge
 *  0b101..Reserved
 *  0b110..Timer reset on trigger rising edge
 *  0b111..Timer reset on trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMRST(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMRST_SHIFT)) & FLEXIO_TIMCFG_TIMRST_MASK)

#define FLEXIO_TIMCFG_TIMDEC_MASK                (0x700000U)
#define FLEXIO_TIMCFG_TIMDEC_SHIFT               (20U)
/*! TIMDEC - Timer Decrement
 *  0b000..Decrement counter on FLEXIO clock. Shift clock equals timer output.
 *  0b001..Decrement counter on trigger input (both edges). Shift clock equals timer output.
 *  0b010..Decrement counter on pin input (both edges). Shift clock equals pin input.
 *  0b011..Decrement counter on trigger input (both edges). Shift clock equals trigger input.
 *  0b100..Decrement counter on FLEXIO clock divided by 16. Shift clock equals timer output.
 *  0b101..Decrement counter on FLEXIO clock divided by 256. Shift clock equals timer output.
 *  0b110..Decrement counter on pin input (rising edge). Shift clock equals pin input.
 *  0b111..Decrement counter on trigger input (rising edge). Shift clock equals trigger input.
 */
#define FLEXIO_TIMCFG_TIMDEC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDEC_SHIFT)) & FLEXIO_TIMCFG_TIMDEC_MASK)

#define FLEXIO_TIMCFG_TIMOUT_MASK                (0x3000000U)
#define FLEXIO_TIMCFG_TIMOUT_SHIFT               (24U)
/*! TIMOUT - Timer Output
 *  0b00..Timer output is logic one when enabled and is not affected by timer reset
 *  0b01..Timer output is logic zero when enabled and is not affected by timer reset
 *  0b10..Timer output is logic one when enabled and on timer reset
 *  0b11..Timer output is logic zero when enabled and on timer reset
 */
#define FLEXIO_TIMCFG_TIMOUT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMOUT_SHIFT)) & FLEXIO_TIMCFG_TIMOUT_MASK)
/*! @} */

/* The count of FLEXIO_TIMCFG */
#define FLEXIO_TIMCFG_COUNT                      (8U)

/*! @name TIMCMP - Timer Compare N */
/*! @{ */

#define FLEXIO_TIMCMP_CMP_MASK                   (0xFFFFU)
#define FLEXIO_TIMCMP_CMP_SHIFT                  (0U)
/*! CMP - Timer Compare Value */
#define FLEXIO_TIMCMP_CMP(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCMP_CMP_SHIFT)) & FLEXIO_TIMCMP_CMP_MASK)
/*! @} */

/* The count of FLEXIO_TIMCMP */
#define FLEXIO_TIMCMP_COUNT                      (8U)

/*! @name SHIFTBUFNBS - Shifter Buffer N Nibble Byte Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT     (0U)
/*! SHIFTBUFNBS - Shift Buffer */
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT)) & FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNBS */
#define FLEXIO_SHIFTBUFNBS_COUNT                 (8U)

/*! @name SHIFTBUFHWS - Shifter Buffer N Halfword Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT     (0U)
/*! SHIFTBUFHWS - Shift Buffer */
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT)) & FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHWS */
#define FLEXIO_SHIFTBUFHWS_COUNT                 (8U)

/*! @name SHIFTBUFNIS - Shifter Buffer N Nibble Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT     (0U)
/*! SHIFTBUFNIS - Shift Buffer */
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT)) & FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNIS */
#define FLEXIO_SHIFTBUFNIS_COUNT                 (8U)

/*! @name SHIFTBUFOES - Shifter Buffer N Odd Even Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT     (0U)
/*! SHIFTBUFOES - Shift Buffer */
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT)) & FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFOES */
#define FLEXIO_SHIFTBUFOES_COUNT                 (8U)

/*! @name SHIFTBUFEOS - Shifter Buffer N Even Odd Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT     (0U)
/*! SHIFTBUFEOS - Shift Buffer */
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT)) & FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFEOS */
#define FLEXIO_SHIFTBUFEOS_COUNT                 (8U)

/*! @name SHIFTBUFHBS - Shifter Buffer N Halfword Byte Swapped */
/*! @{ */

#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_SHIFT     (0U)
/*! SHIFTBUFHBS - Shift Buffer */
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_SHIFT)) & FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHBS */
#define FLEXIO_SHIFTBUFHBS_COUNT                 (8U)


/*!
 * @}
 */ /* end of group FLEXIO_Register_Masks */


/* FLEXIO - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE                             (0x50105000u)
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE_NS                          (0x40105000u)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0_NS                               ((FLEXIO_Type *)FLEXIO0_BASE_NS)
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS                         { FLEXIO0 }
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS_NS                     { FLEXIO0_BASE_NS }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS_NS                      { FLEXIO0_NS }
#else
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE                             (0x40105000u)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS                         { FLEXIO0 }
#endif
/** Interrupt vectors for the FLEXIO peripheral type */
#define FLEXIO_IRQS                              { FLEXIO_IRQn }

/*!
 * @}
 */ /* end of group FLEXIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FMU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMU_Peripheral_Access_Layer FMU Peripheral Access Layer
 * @{
 */

/** FMU - Register Layout Typedef */
typedef struct {
  __IO uint32_t FSTAT;                             /**< Flash Status Register, offset: 0x0 */
  __IO uint32_t FCNFG;                             /**< Flash Configuration Register, offset: 0x4 */
  __IO uint32_t FCTRL;                             /**< Flash Control Register, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t FCCOB[8];                          /**< Flash Common Command Object Registers, array offset: 0x10, array step: 0x4 */
} FMU_Type;

/* ----------------------------------------------------------------------------
   -- FMU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMU_Register_Masks FMU Register Masks
 * @{
 */

/*! @name FSTAT - Flash Status Register */
/*! @{ */

#define FMU_FSTAT_FAIL_MASK                      (0x1U)
#define FMU_FSTAT_FAIL_SHIFT                     (0U)
/*! FAIL - Command Fail Flag
 *  0b0..Error not detected
 *  0b1..Error detected
 */
#define FMU_FSTAT_FAIL(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_FAIL_SHIFT)) & FMU_FSTAT_FAIL_MASK)

#define FMU_FSTAT_CMDABT_MASK                    (0x4U)
#define FMU_FSTAT_CMDABT_SHIFT                   (2U)
/*! CMDABT - Command Abort Flag
 *  0b0..No command abort detected
 *  0b1..Command abort detected
 */
#define FMU_FSTAT_CMDABT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDABT_SHIFT)) & FMU_FSTAT_CMDABT_MASK)

#define FMU_FSTAT_PVIOL_MASK                     (0x10U)
#define FMU_FSTAT_PVIOL_SHIFT                    (4U)
/*! PVIOL - Command Protection Violation Flag
 *  0b0..No protection violation detected
 *  0b1..Protection violation detected
 */
#define FMU_FSTAT_PVIOL(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PVIOL_SHIFT)) & FMU_FSTAT_PVIOL_MASK)

#define FMU_FSTAT_ACCERR_MASK                    (0x20U)
#define FMU_FSTAT_ACCERR_SHIFT                   (5U)
/*! ACCERR - Command Access Error Flag
 *  0b0..No access error detected
 *  0b1..Access error detected
 */
#define FMU_FSTAT_ACCERR(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_ACCERR_SHIFT)) & FMU_FSTAT_ACCERR_MASK)

#define FMU_FSTAT_CWSABT_MASK                    (0x40U)
#define FMU_FSTAT_CWSABT_SHIFT                   (6U)
/*! CWSABT - Command Write Sequence Abort Flag
 *  0b0..Command write sequence not aborted
 *  0b1..Command write sequence aborted
 */
#define FMU_FSTAT_CWSABT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CWSABT_SHIFT)) & FMU_FSTAT_CWSABT_MASK)

#define FMU_FSTAT_CCIF_MASK                      (0x80U)
#define FMU_FSTAT_CCIF_SHIFT                     (7U)
/*! CCIF - Command Complete Interrupt Flag
 *  0b0..Flash command, initialization, or power mode recovery in progress
 *  0b1..Flash command, initialization, or power mode recovery has completed
 */
#define FMU_FSTAT_CCIF(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CCIF_SHIFT)) & FMU_FSTAT_CCIF_MASK)

#define FMU_FSTAT_CMDPRT_MASK                    (0x300U)
#define FMU_FSTAT_CMDPRT_SHIFT                   (8U)
/*! CMDPRT - Command protection level
 *  0b00..Secure, normal access
 *  0b01..Secure, privileged access
 *  0b10..Nonsecure, normal access
 *  0b11..Nonsecure, privileged access
 */
#define FMU_FSTAT_CMDPRT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDPRT_SHIFT)) & FMU_FSTAT_CMDPRT_MASK)

#define FMU_FSTAT_CMDP_MASK                      (0x800U)
#define FMU_FSTAT_CMDP_SHIFT                     (11U)
/*! CMDP - Command protection status flag
 *  0b0..Command protection level and domain ID are stale
 *  0b1..Command protection level (CMDPRT) and domain ID (CMDDID) are set
 */
#define FMU_FSTAT_CMDP(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDP_SHIFT)) & FMU_FSTAT_CMDP_MASK)

#define FMU_FSTAT_CMDDID_MASK                    (0xF000U)
#define FMU_FSTAT_CMDDID_SHIFT                   (12U)
/*! CMDDID - Command domain ID */
#define FMU_FSTAT_CMDDID(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDDID_SHIFT)) & FMU_FSTAT_CMDDID_MASK)

#define FMU_FSTAT_DFDIF_MASK                     (0x10000U)
#define FMU_FSTAT_DFDIF_SHIFT                    (16U)
/*! DFDIF - Double Bit Fault Detect Interrupt Flag
 *  0b0..Double bit fault not detected during a valid flash read access
 *  0b1..Double bit fault detected (or FCTRL[FDFD] is set) during a valid flash read access
 */
#define FMU_FSTAT_DFDIF(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_DFDIF_SHIFT)) & FMU_FSTAT_DFDIF_MASK)

#define FMU_FSTAT_SALV_USED_MASK                 (0x20000U)
#define FMU_FSTAT_SALV_USED_SHIFT                (17U)
/*! SALV_USED - Salvage Used for Erase operation
 *  0b0..Salvage not used during last operation
 *  0b1..Salvage used during the last erase operation
 */
#define FMU_FSTAT_SALV_USED(x)                   (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_SALV_USED_SHIFT)) & FMU_FSTAT_SALV_USED_MASK)

#define FMU_FSTAT_PEWEN_MASK                     (0x3000000U)
#define FMU_FSTAT_PEWEN_SHIFT                    (24U)
/*! PEWEN - Program-Erase Write Enable Control
 *  0b00..Writes are not enabled
 *  0b01..Writes are enabled for one flash or IFR phrase (phrase programming, sector erase)
 *  0b10..Writes are enabled for one flash or IFR page (page programming)
 *  0b11..Reserved
 */
#define FMU_FSTAT_PEWEN(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PEWEN_SHIFT)) & FMU_FSTAT_PEWEN_MASK)

#define FMU_FSTAT_PERDY_MASK                     (0x80000000U)
#define FMU_FSTAT_PERDY_SHIFT                    (31U)
/*! PERDY - Program-Erase Ready Control/Status Flag
 *  0b0..Program or sector erase command operation not stalled
 *  0b1..Program or sector erase command operation ready to execute
 */
#define FMU_FSTAT_PERDY(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PERDY_SHIFT)) & FMU_FSTAT_PERDY_MASK)
/*! @} */

/*! @name FCNFG - Flash Configuration Register */
/*! @{ */

#define FMU_FCNFG_CCIE_MASK                      (0x80U)
#define FMU_FCNFG_CCIE_SHIFT                     (7U)
/*! CCIE - Command Complete Interrupt Enable
 *  0b0..Command complete interrupt disabled
 *  0b1..Command complete interrupt enabled
 */
#define FMU_FCNFG_CCIE(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_CCIE_SHIFT)) & FMU_FCNFG_CCIE_MASK)

#define FMU_FCNFG_ERSREQ_MASK                    (0x100U)
#define FMU_FCNFG_ERSREQ_SHIFT                   (8U)
/*! ERSREQ - Mass Erase Request
 *  0b0..No request or request complete
 *  0b1..Request to run the Mass Erase operation
 */
#define FMU_FCNFG_ERSREQ(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSREQ_SHIFT)) & FMU_FCNFG_ERSREQ_MASK)

#define FMU_FCNFG_DFDIE_MASK                     (0x10000U)
#define FMU_FCNFG_DFDIE_SHIFT                    (16U)
/*! DFDIE - Double Bit Fault Detect Interrupt Enable
 *  0b0..Double bit fault detect interrupt disabled
 *  0b1..Double bit fault detect interrupt enabled
 */
#define FMU_FCNFG_DFDIE(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_DFDIE_SHIFT)) & FMU_FCNFG_DFDIE_MASK)

#define FMU_FCNFG_ERSIEN0_MASK                   (0xF000000U)
#define FMU_FCNFG_ERSIEN0_SHIFT                  (24U)
/*! ERSIEN0 - Erase IFR Sector Enable - Block 0
 *  0b0000..Block 0 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 0 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMU_FCNFG_ERSIEN0(x)                     (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSIEN0_SHIFT)) & FMU_FCNFG_ERSIEN0_MASK)

#define FMU_FCNFG_ERSIEN1_MASK                   (0xF0000000U)
#define FMU_FCNFG_ERSIEN1_SHIFT                  (28U)
/*! ERSIEN1 - Erase IFR Sector Enable - Block 1 (for dual block configs)
 *  0b0000..Block 1 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 1 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMU_FCNFG_ERSIEN1(x)                     (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSIEN1_SHIFT)) & FMU_FCNFG_ERSIEN1_MASK)
/*! @} */

/*! @name FCTRL - Flash Control Register */
/*! @{ */

#define FMU_FCTRL_RWSC_MASK                      (0xFU)
#define FMU_FCTRL_RWSC_SHIFT                     (0U)
/*! RWSC - Read Wait-State Control */
#define FMU_FCTRL_RWSC(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_RWSC_SHIFT)) & FMU_FCTRL_RWSC_MASK)

#define FMU_FCTRL_FDFD_MASK                      (0x10000U)
#define FMU_FCTRL_FDFD_SHIFT                     (16U)
/*! FDFD - Force Double Bit Fault Detect
 *  0b0..FSTAT[DFDIF] sets only if a double bit fault is detected during a valid flash read access from the platform flash controller
 *  0b1..FSTAT[DFDIF] sets during any valid flash read access from the platform flash controller. An interrupt
 *       request is generated if the DFDIE bit is set.
 */
#define FMU_FCTRL_FDFD(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_FDFD_SHIFT)) & FMU_FCTRL_FDFD_MASK)

#define FMU_FCTRL_ABTREQ_MASK                    (0x1000000U)
#define FMU_FCTRL_ABTREQ_SHIFT                   (24U)
/*! ABTREQ - Abort Request
 *  0b0..No request to abort a command write sequence
 *  0b1..Request to abort a command write sequence
 */
#define FMU_FCTRL_ABTREQ(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_ABTREQ_SHIFT)) & FMU_FCTRL_ABTREQ_MASK)
/*! @} */

/*! @name FCCOB - Flash Common Command Object Registers */
/*! @{ */

#define FMU_FCCOB_CCOBn_MASK                     (0xFFFFFFFFU)
#define FMU_FCCOB_CCOBn_SHIFT                    (0U)
/*! CCOBn - CCOBn */
#define FMU_FCCOB_CCOBn(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FCCOB_CCOBn_SHIFT)) & FMU_FCCOB_CCOBn_MASK)
/*! @} */

/* The count of FMU_FCCOB */
#define FMU_FCCOB_COUNT                          (8U)


/*!
 * @}
 */ /* end of group FMU_Register_Masks */


/* FMU - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FMU0 base address */
  #define FMU0_BASE                                (0x50043000u)
  /** Peripheral FMU0 base address */
  #define FMU0_BASE_NS                             (0x40043000u)
  /** Peripheral FMU0 base pointer */
  #define FMU0                                     ((FMU_Type *)FMU0_BASE)
  /** Peripheral FMU0 base pointer */
  #define FMU0_NS                                  ((FMU_Type *)FMU0_BASE_NS)
  /** Array initializer of FMU peripheral base addresses */
  #define FMU_BASE_ADDRS                           { FMU0_BASE }
  /** Array initializer of FMU peripheral base pointers */
  #define FMU_BASE_PTRS                            { FMU0 }
  /** Array initializer of FMU peripheral base addresses */
  #define FMU_BASE_ADDRS_NS                        { FMU0_BASE_NS }
  /** Array initializer of FMU peripheral base pointers */
  #define FMU_BASE_PTRS_NS                         { FMU0_NS }
#else
  /** Peripheral FMU0 base address */
  #define FMU0_BASE                                (0x40043000u)
  /** Peripheral FMU0 base pointer */
  #define FMU0                                     ((FMU_Type *)FMU0_BASE)
  /** Array initializer of FMU peripheral base addresses */
  #define FMU_BASE_ADDRS                           { FMU0_BASE }
  /** Array initializer of FMU peripheral base pointers */
  #define FMU_BASE_PTRS                            { FMU0 }
#endif

/*!
 * @}
 */ /* end of group FMU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FMUTEST Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMUTEST_Peripheral_Access_Layer FMUTEST Peripheral Access Layer
 * @{
 */

/** FMUTEST - Register Layout Typedef */
typedef struct {
  __IO uint32_t FSTAT;                             /**< Flash Status Register, offset: 0x0 */
  __IO uint32_t FCNFG;                             /**< Flash Configuration Register, offset: 0x4 */
  __IO uint32_t FCTRL;                             /**< Flash Control Register, offset: 0x8 */
  __I  uint32_t FTEST;                             /**< Flash Test Register, offset: 0xC */
  __IO uint32_t FCCOB0;                            /**< Flash Command Control 0 Register, offset: 0x10 */
  __IO uint32_t FCCOB1;                            /**< Flash Command Control 1 Register, offset: 0x14 */
  __IO uint32_t FCCOB2;                            /**< Flash Command Control 2 Register, offset: 0x18 */
  __IO uint32_t FCCOB3;                            /**< Flash Command Control 3 Register, offset: 0x1C */
  __IO uint32_t FCCOB4;                            /**< Flash Command Control 4 Register, offset: 0x20 */
  __IO uint32_t FCCOB5;                            /**< Flash Command Control 5 Register, offset: 0x24 */
  __IO uint32_t FCCOB6;                            /**< Flash Command Control 6 Register, offset: 0x28 */
  __IO uint32_t FCCOB7;                            /**< Flash Command Control 7 Register, offset: 0x2C */
       uint8_t RESERVED_0[208];
  __IO uint32_t RESET_STATUS;                      /**< FMU Initialization Tracking Register, offset: 0x100 */
  __IO uint32_t MCTL;                              /**< FMU Control Register, offset: 0x104 */
  __I  uint32_t BSEL_GEN;                          /**< FMU Block Select Generation Register, offset: 0x108 */
  __IO uint32_t PWR_OPT;                           /**< Power Mode Options Register, offset: 0x10C */
  __I  uint32_t CMD_CHECK;                         /**< FMU Command Check Register, offset: 0x110 */
       uint8_t RESERVED_1[12];
  __IO uint32_t BSEL;                              /**< FMU Block Select Register, offset: 0x120 */
  __IO uint32_t MSIZE;                             /**< FMU Memory Size Register, offset: 0x124 */
  __IO uint32_t FLASH_RD_ADD;                      /**< Flash Read Address Register, offset: 0x128 */
       uint8_t RESERVED_2[4];
  __IO uint32_t FLASH_STOP_ADD;                    /**< Flash Stop Address Register, offset: 0x130 */
  __IO uint32_t FLASH_RD_CTRL;                     /**< Flash Read Control Register, offset: 0x134 */
  __IO uint32_t MM_ADDR;                           /**< Memory Map Address Register, offset: 0x138 */
       uint8_t RESERVED_3[4];
  __IO uint32_t MM_WDATA;                          /**< Memory Map Write Data Register, offset: 0x140 */
  __IO uint32_t MM_CTL;                            /**< Memory Map Control Register, offset: 0x144 */
  __IO uint32_t UINT_CTL;                          /**< User Interface Control Register, offset: 0x148 */
  __IO uint32_t RD_DATA0;                          /**< Read Data 0 Register, offset: 0x14C */
  __IO uint32_t RD_DATA1;                          /**< Read Data 1 Register, offset: 0x150 */
  __IO uint32_t RD_DATA2;                          /**< Read Data 2 Register, offset: 0x154 */
  __IO uint32_t RD_DATA3;                          /**< Read Data 3 Register, offset: 0x158 */
  __IO uint32_t PARITY;                            /**< Parity Register, offset: 0x15C */
  __IO uint32_t RD_PATH_CTRL_STATUS;               /**< Read Path Control and Status Register, offset: 0x160 */
  __IO uint32_t SMW_DIN0;                          /**< SMW DIN 0 Register, offset: 0x164 */
  __IO uint32_t SMW_DIN1;                          /**< SMW DIN 1 Register, offset: 0x168 */
  __IO uint32_t SMW_DIN2;                          /**< SMW DIN 2 Register, offset: 0x16C */
  __IO uint32_t SMW_DIN3;                          /**< SMW DIN 3 Register, offset: 0x170 */
  __IO uint32_t SMW_ADDR;                          /**< SMW Address Register, offset: 0x174 */
  __IO uint32_t SMW_CMD_WAIT;                      /**< SMW Command and Wait Register, offset: 0x178 */
  __I  uint32_t SMW_STATUS;                        /**< SMW Status Register, offset: 0x17C */
  __IO uint32_t SOCTRIM0_0;                        /**< SoC Trim Phrase 0 Word 0 Register, offset: 0x180 */
  __IO uint32_t SOCTRIM0_1;                        /**< SoC Trim Phrase 0 Word 1 Register, offset: 0x184 */
  __IO uint32_t SOCTRIM0_2;                        /**< SoC Trim Phrase 0 Word 2 Register, offset: 0x188 */
  __IO uint32_t SOCTRIM0_3;                        /**< SoC Trim Phrase 0 Word 3 Register, offset: 0x18C */
  __IO uint32_t SOCTRIM1_0;                        /**< SoC Trim Phrase 1 Word 0 Register, offset: 0x190 */
  __IO uint32_t SOCTRIM1_1;                        /**< SoC Trim Phrase 1 Word 1 Register, offset: 0x194 */
  __IO uint32_t SOCTRIM1_2;                        /**< SoC Trim Phrase 1 Word 2 Register, offset: 0x198 */
  __IO uint32_t SOCTRIM1_3;                        /**< SoC Trim Phrase 1 Word 3 Register, offset: 0x19C */
  __IO uint32_t SOCTRIM2_0;                        /**< SoC Trim Phrase 2 Word 0 Register, offset: 0x1A0 */
  __IO uint32_t SOCTRIM2_1;                        /**< SoC Trim Phrase 2 Word 1 Register, offset: 0x1A4 */
  __IO uint32_t SOCTRIM2_2;                        /**< SoC Trim Phrase 2 Word 2 Register, offset: 0x1A8 */
  __IO uint32_t SOCTRIM2_3;                        /**< SoC Trim Phrase 2 Word 3 Register, offset: 0x1AC */
  __IO uint32_t SOCTRIM3_0;                        /**< SoC Trim Phrase 3 Word 0 Register, offset: 0x1B0 */
  __IO uint32_t SOCTRIM3_1;                        /**< SoC Trim Phrase 3 Word 1 Register, offset: 0x1B4 */
  __IO uint32_t SOCTRIM3_2;                        /**< SoC Trim Phrase 3 Word 2 Register, offset: 0x1B8 */
  __IO uint32_t SOCTRIM3_3;                        /**< SoC Trim Phrase 3 Word 3 Register, offset: 0x1BC */
  __IO uint32_t SOCTRIM4_0;                        /**< SoC Trim Phrase 4 Word 0 Register, offset: 0x1C0 */
  __IO uint32_t SOCTRIM4_1;                        /**< SoC Trim Phrase 4 Word 1 Register, offset: 0x1C4 */
  __IO uint32_t SOCTRIM4_2;                        /**< SoC Trim Phrase 4 Word 2 Register, offset: 0x1C8 */
  __IO uint32_t SOCTRIM4_3;                        /**< SoC Trim Phrase 4 Word 3 Register, offset: 0x1CC */
  __IO uint32_t SOCTRIM5_0;                        /**< SoC Trim Phrase 5 Word 0 Register, offset: 0x1D0 */
  __IO uint32_t SOCTRIM5_1;                        /**< SoC Trim Phrase 5 Word 1 Register, offset: 0x1D4 */
  __IO uint32_t SOCTRIM5_2;                        /**< SoC Trim Phrase 5 Word 2 Register, offset: 0x1D8 */
  __IO uint32_t SOCTRIM5_3;                        /**< SoC Trim Phrase 5 Word 3 Register, offset: 0x1DC */
  __IO uint32_t SOCTRIM6_0;                        /**< SoC Trim Phrase 6 Word 0 Register, offset: 0x1E0 */
  __IO uint32_t SOCTRIM6_1;                        /**< SoC Trim Phrase 6 Word 1 Register, offset: 0x1E4 */
  __IO uint32_t SOCTRIM6_2;                        /**< SoC Trim Phrase 6 Word 2 Register, offset: 0x1E8 */
  __IO uint32_t SOCTRIM6_3;                        /**< SoC Trim Phrase 6 Word 3 Register, offset: 0x1EC */
  __IO uint32_t SOCTRIM7_0;                        /**< SoC Trim Phrase 7 Word 0 Register, offset: 0x1F0 */
  __IO uint32_t SOCTRIM7_1;                        /**< SoC Trim Phrase 7 Word 1 Register, offset: 0x1F4 */
  __IO uint32_t SOCTRIM7_2;                        /**< SoC Trim Phrase 7 Word 2 Register, offset: 0x1F8 */
  __IO uint32_t SOCTRIM7_3;                        /**< SoC Trim Phrase 7 Word 3 Register, offset: 0x1FC */
       uint8_t RESERVED_4[4];
  __IO uint32_t R_IP_CONFIG;                       /**< BIST Configuration Register, offset: 0x204 */
  __IO uint32_t R_TESTCODE;                        /**< BIST Test Code Register, offset: 0x208 */
  __IO uint32_t R_DFT_CTRL;                        /**< BIST DFT Control Register, offset: 0x20C */
  __IO uint32_t R_ADR_CTRL;                        /**< BIST Address Control Register, offset: 0x210 */
  __IO uint32_t R_DATA_CTRL0;                      /**< BIST Data Control 0 Register, offset: 0x214 */
  __IO uint32_t R_PIN_CTRL;                        /**< BIST Pin Control Register, offset: 0x218 */
  __IO uint32_t R_CNT_LOOP_CTRL;                   /**< BIST Loop Count Control Register, offset: 0x21C */
  __IO uint32_t R_TIMER_CTRL;                      /**< BIST Timer Control Register, offset: 0x220 */
  __IO uint32_t R_TEST_CTRL;                       /**< BIST Test Control Register, offset: 0x224 */
  __O  uint32_t R_ABORT_LOOP;                      /**< BIST Abort Loop Register, offset: 0x228 */
  __I  uint32_t R_ADR_QUERY;                       /**< BIST Address Query Register, offset: 0x22C */
  __I  uint32_t R_DOUT_QUERY0;                     /**< BIST DOUT Query 0 Register, offset: 0x230 */
       uint8_t RESERVED_5[8];
  __I  uint32_t R_SMW_QUERY;                       /**< BIST SMW Query Register, offset: 0x23C */
  __IO uint32_t R_SMW_SETTING0;                    /**< BIST SMW Setting 0 Register, offset: 0x240 */
  __IO uint32_t R_SMW_SETTING1;                    /**< BIST SMW Setting 1 Register, offset: 0x244 */
  __IO uint32_t R_SMP_WHV0;                        /**< BIST SMP WHV Setting 0 Register, offset: 0x248 */
  __IO uint32_t R_SMP_WHV1;                        /**< BIST SMP WHV Setting 1 Register, offset: 0x24C */
  __IO uint32_t R_SME_WHV0;                        /**< BIST SME WHV Setting 0 Register, offset: 0x250 */
  __IO uint32_t R_SME_WHV1;                        /**< BIST SME WHV Setting 1 Register, offset: 0x254 */
  __IO uint32_t R_SMW_SETTING2;                    /**< BIST SMW Setting 2 Register, offset: 0x258 */
  __I  uint32_t R_D_MISR0;                         /**< BIST DIN MISR 0 Register, offset: 0x25C */
  __I  uint32_t R_A_MISR0;                         /**< BIST Address MISR 0 Register, offset: 0x260 */
  __I  uint32_t R_C_MISR0;                         /**< BIST Control MISR 0 Register, offset: 0x264 */
  __IO uint32_t R_SMW_SETTING3;                    /**< BIST SMW Setting 3 Register, offset: 0x268 */
  __IO uint32_t R_DATA_CTRL1;                      /**< BIST Data Control 1 Register, offset: 0x26C */
  __IO uint32_t R_DATA_CTRL2;                      /**< BIST Data Control 2 Register, offset: 0x270 */
  __IO uint32_t R_DATA_CTRL3;                      /**< BIST Data Control 3 Register, offset: 0x274 */
       uint8_t RESERVED_6[8];
  __I  uint32_t R_REPAIR0_0;                       /**< BIST Repair 0 for Block 0 Register, offset: 0x280 */
  __I  uint32_t R_REPAIR0_1;                       /**< BIST Repair 1 Block 0 Register, offset: 0x284 */
  __I  uint32_t R_REPAIR1_0;                       /**< BIST Repair 0 Block 1 Register, offset: 0x288 */
  __I  uint32_t R_REPAIR1_1;                       /**< BIST Repair 1 Block 1 Register, offset: 0x28C */
       uint8_t RESERVED_7[132];
  __IO uint32_t R_DATA_CTRL0_EX;                   /**< BIST Data Control 0 Extension Register, offset: 0x314 */
       uint8_t RESERVED_8[8];
  __IO uint32_t R_TIMER_CTRL_EX;                   /**< BIST Timer Control Extension Register, offset: 0x320 */
       uint8_t RESERVED_9[12];
  __I  uint32_t R_DOUT_QUERY1;                     /**< BIST DOUT Query 1 Register, offset: 0x330 */
       uint8_t RESERVED_10[40];
  __I  uint32_t R_D_MISR1;                         /**< BIST DIN MISR 1 Register, offset: 0x35C */
  __I  uint32_t R_A_MISR1;                         /**< BIST Address MISR 1 Register, offset: 0x360 */
  __I  uint32_t R_C_MISR1;                         /**< BIST Control MISR 1 Register, offset: 0x364 */
       uint8_t RESERVED_11[4];
  __IO uint32_t R_DATA_CTRL1_EX;                   /**< BIST Data Control 1 Extension Register, offset: 0x36C */
  __IO uint32_t R_DATA_CTRL2_EX;                   /**< BIST Data Control 2 Extension Register, offset: 0x370 */
  __IO uint32_t R_DATA_CTRL3_EX;                   /**< BIST Data Control 3 Extension Register, offset: 0x374 */
       uint8_t RESERVED_12[136];
  __IO uint32_t SMW_TIMER_OPTION;                  /**< SMW Timer Option Register, offset: 0x400 */
  __IO uint32_t SMW_SETTING_OPTION0;               /**< SMW Setting Option 0 Register, offset: 0x404 */
  __IO uint32_t SMW_SETTING_OPTION2;               /**< SMW Setting Option 2 Register, offset: 0x408 */
  __IO uint32_t SMW_SETTING_OPTION3;               /**< SMW Setting Option 3 Register, offset: 0x40C */
  __IO uint32_t SMW_SMP_WHV_OPTION0;               /**< SMW SMP WHV Option 0 Register, offset: 0x410 */
  __IO uint32_t SMW_SME_WHV_OPTION0;               /**< SMW SME WHV Option 0 Register, offset: 0x414 */
  __IO uint32_t SMW_SETTING_OPTION1;               /**< SMW Setting Option 1 Register, offset: 0x418 */
  __IO uint32_t SMW_SMP_WHV_OPTION1;               /**< SMW SMP WHV Option 1 Register, offset: 0x41C */
  __IO uint32_t SMW_SME_WHV_OPTION1;               /**< SMW SME WHV Option 1 Register, offset: 0x420 */
       uint8_t RESERVED_13[220];
  __IO uint32_t REPAIR0_0;                         /**< FMU Repair 0 Block 0 Register, offset: 0x500 */
  __IO uint32_t REPAIR0_1;                         /**< FMU Repair 1 Block 0 Register, offset: 0x504 */
  __IO uint32_t REPAIR1_0;                         /**< FMU Repair 0 Block 1 Register, offset: 0x508 */
  __IO uint32_t REPAIR1_1;                         /**< FMU Repair 1 Block 1 Register, offset: 0x50C */
       uint8_t RESERVED_14[240];
  __IO uint32_t SMW_HB_SIGNALS;                    /**< SMW HB Signals Register, offset: 0x600 */
  __IO uint32_t BIST_DUMP_CTRL;                    /**< BIST Datadump Control Register, offset: 0x604 */
       uint8_t RESERVED_15[4];
  __IO uint32_t ATX_PIN_CTRL;                      /**< ATX Pin Control Register, offset: 0x60C */
  __IO uint32_t FAILCNT;                           /**< Fail Count Register, offset: 0x610 */
  __IO uint32_t PGM_PULSE_CNT0;                    /**< Block 0 Program Pulse Count Register, offset: 0x614 */
  __IO uint32_t PGM_PULSE_CNT1;                    /**< Block 1 Program Pulse Count Register, offset: 0x618 */
  __IO uint32_t ERS_PULSE_CNT;                     /**< Erase Pulse Count Register, offset: 0x61C */
  __IO uint32_t MAX_PULSE_CNT;                     /**< Maximum Pulse Count Register, offset: 0x620 */
  __IO uint32_t PORT_CTRL;                         /**< Port Control Register, offset: 0x624 */
} FMUTEST_Type;

/* ----------------------------------------------------------------------------
   -- FMUTEST Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMUTEST_Register_Masks FMUTEST Register Masks
 * @{
 */

/*! @name FSTAT - Flash Status Register */
/*! @{ */

#define FMUTEST_FSTAT_FAIL_MASK                  (0x1U)
#define FMUTEST_FSTAT_FAIL_SHIFT                 (0U)
/*! FAIL - Command Fail Flag
 *  0b0..Error not detected
 *  0b1..Error detected
 */
#define FMUTEST_FSTAT_FAIL(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_FAIL_SHIFT)) & FMUTEST_FSTAT_FAIL_MASK)

#define FMUTEST_FSTAT_CMDABT_MASK                (0x4U)
#define FMUTEST_FSTAT_CMDABT_SHIFT               (2U)
/*! CMDABT - Command Abort Flag
 *  0b0..No command abort detected
 *  0b1..Command abort detected
 */
#define FMUTEST_FSTAT_CMDABT(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CMDABT_SHIFT)) & FMUTEST_FSTAT_CMDABT_MASK)

#define FMUTEST_FSTAT_PVIOL_MASK                 (0x10U)
#define FMUTEST_FSTAT_PVIOL_SHIFT                (4U)
/*! PVIOL - Command Protection Violation Flag
 *  0b0..No protection violation detected
 *  0b1..Protection violation detected
 */
#define FMUTEST_FSTAT_PVIOL(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_PVIOL_SHIFT)) & FMUTEST_FSTAT_PVIOL_MASK)

#define FMUTEST_FSTAT_ACCERR_MASK                (0x20U)
#define FMUTEST_FSTAT_ACCERR_SHIFT               (5U)
/*! ACCERR - Command Access Error Flag
 *  0b0..No access error detected
 *  0b1..Access error detected
 */
#define FMUTEST_FSTAT_ACCERR(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_ACCERR_SHIFT)) & FMUTEST_FSTAT_ACCERR_MASK)

#define FMUTEST_FSTAT_CWSABT_MASK                (0x40U)
#define FMUTEST_FSTAT_CWSABT_SHIFT               (6U)
/*! CWSABT - Command Write Sequence Abort Flag
 *  0b0..Command write sequence not aborted
 *  0b1..Command write sequence aborted
 */
#define FMUTEST_FSTAT_CWSABT(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CWSABT_SHIFT)) & FMUTEST_FSTAT_CWSABT_MASK)

#define FMUTEST_FSTAT_CCIF_MASK                  (0x80U)
#define FMUTEST_FSTAT_CCIF_SHIFT                 (7U)
/*! CCIF - Command Complete Interrupt Flag
 *  0b0..Flash command or initialization in progress
 *  0b1..Flash command or initialization has completed
 */
#define FMUTEST_FSTAT_CCIF(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CCIF_SHIFT)) & FMUTEST_FSTAT_CCIF_MASK)

#define FMUTEST_FSTAT_CMDPRT_MASK                (0x300U)
#define FMUTEST_FSTAT_CMDPRT_SHIFT               (8U)
/*! CMDPRT - Command Protection Level
 *  0b00..Secure, normal access
 *  0b01..Secure, privileged access
 *  0b10..Nonsecure, normal access
 *  0b11..Nonsecure, privileged access
 */
#define FMUTEST_FSTAT_CMDPRT(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CMDPRT_SHIFT)) & FMUTEST_FSTAT_CMDPRT_MASK)

#define FMUTEST_FSTAT_CMDP_MASK                  (0x800U)
#define FMUTEST_FSTAT_CMDP_SHIFT                 (11U)
/*! CMDP - Command Protection Status Flag
 *  0b0..Command protection level and domain ID are stale
 *  0b1..Command protection level (CMDPRT) and domain ID (CMDDID) are set
 */
#define FMUTEST_FSTAT_CMDP(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CMDP_SHIFT)) & FMUTEST_FSTAT_CMDP_MASK)

#define FMUTEST_FSTAT_CMDDID_MASK                (0xF000U)
#define FMUTEST_FSTAT_CMDDID_SHIFT               (12U)
/*! CMDDID - Command Domain ID */
#define FMUTEST_FSTAT_CMDDID(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_CMDDID_SHIFT)) & FMUTEST_FSTAT_CMDDID_MASK)

#define FMUTEST_FSTAT_DFDIF_MASK                 (0x10000U)
#define FMUTEST_FSTAT_DFDIF_SHIFT                (16U)
/*! DFDIF - Double Bit Fault Detect Interrupt Flag
 *  0b0..Double bit fault not detected during a valid flash read access from the FMC
 *  0b1..Double bit fault detected (or FCTRL[FDFD] is set) during a valid flash read access from the FMC
 */
#define FMUTEST_FSTAT_DFDIF(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_DFDIF_SHIFT)) & FMUTEST_FSTAT_DFDIF_MASK)

#define FMUTEST_FSTAT_SALV_USED_MASK             (0x20000U)
#define FMUTEST_FSTAT_SALV_USED_SHIFT            (17U)
/*! SALV_USED - Salvage Used for Erase operation
 *  0b0..Salvage not used during the last operation
 *  0b1..Salvage used during the last erase operation
 */
#define FMUTEST_FSTAT_SALV_USED(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_SALV_USED_SHIFT)) & FMUTEST_FSTAT_SALV_USED_MASK)

#define FMUTEST_FSTAT_PEWEN_MASK                 (0x3000000U)
#define FMUTEST_FSTAT_PEWEN_SHIFT                (24U)
/*! PEWEN - Program-Erase Write Enable Control
 *  0b00..Writes are not enabled
 *  0b01..Writes are enabled for one flash or IFR phrase (phrase programming, sector erase)
 *  0b10..Writes are enabled for one flash or IFR page (page programming)
 *  0b11..Reserved
 */
#define FMUTEST_FSTAT_PEWEN(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_PEWEN_SHIFT)) & FMUTEST_FSTAT_PEWEN_MASK)

#define FMUTEST_FSTAT_PERDY_MASK                 (0x80000000U)
#define FMUTEST_FSTAT_PERDY_SHIFT                (31U)
/*! PERDY - Program/Erase Ready Control/Status Flag
 *  0b0..Program or sector erase command operation is not stalled
 *  0b1..Program or sector erase command operation is stalled
 */
#define FMUTEST_FSTAT_PERDY(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FSTAT_PERDY_SHIFT)) & FMUTEST_FSTAT_PERDY_MASK)
/*! @} */

/*! @name FCNFG - Flash Configuration Register */
/*! @{ */

#define FMUTEST_FCNFG_CCIE_MASK                  (0x80U)
#define FMUTEST_FCNFG_CCIE_SHIFT                 (7U)
/*! CCIE - Command Complete Interrupt Enable
 *  0b0..Command complete interrupt disabled
 *  0b1..Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.
 */
#define FMUTEST_FCNFG_CCIE(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_CCIE_SHIFT)) & FMUTEST_FCNFG_CCIE_MASK)

#define FMUTEST_FCNFG_ERSREQ_MASK                (0x100U)
#define FMUTEST_FCNFG_ERSREQ_SHIFT               (8U)
/*! ERSREQ - Mass Erase (Erase All) Request
 *  0b0..No request or request complete
 *  0b1..Request to run the Mass Erase operation
 */
#define FMUTEST_FCNFG_ERSREQ(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_ERSREQ_SHIFT)) & FMUTEST_FCNFG_ERSREQ_MASK)

#define FMUTEST_FCNFG_DFDIE_MASK                 (0x10000U)
#define FMUTEST_FCNFG_DFDIE_SHIFT                (16U)
/*! DFDIE - Double Bit Fault Detect Interrupt Enable
 *  0b0..Double bit fault detect interrupt disabled
 *  0b1..Double bit fault detect interrupt enabled; an interrupt request is generated whenever the FSTAT[DFDIF] flag is set
 */
#define FMUTEST_FCNFG_DFDIE(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_DFDIE_SHIFT)) & FMUTEST_FCNFG_DFDIE_MASK)

#define FMUTEST_FCNFG_ERSIEN0_MASK               (0xF000000U)
#define FMUTEST_FCNFG_ERSIEN0_SHIFT              (24U)
/*! ERSIEN0 - Erase IFR Sector Enable - Block 0
 *  0b0000..Block 0 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 0 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMUTEST_FCNFG_ERSIEN0(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_ERSIEN0_SHIFT)) & FMUTEST_FCNFG_ERSIEN0_MASK)

#define FMUTEST_FCNFG_ERSIEN1_MASK               (0xF0000000U)
#define FMUTEST_FCNFG_ERSIEN1_SHIFT              (28U)
/*! ERSIEN1 - Erase IFR Sector Enable - Block 1 (for dual block configs)
 *  0b0000..Block 1 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 1 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMUTEST_FCNFG_ERSIEN1(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCNFG_ERSIEN1_SHIFT)) & FMUTEST_FCNFG_ERSIEN1_MASK)
/*! @} */

/*! @name FCTRL - Flash Control Register */
/*! @{ */

#define FMUTEST_FCTRL_RWSC_MASK                  (0xFU)
#define FMUTEST_FCTRL_RWSC_SHIFT                 (0U)
/*! RWSC - Read Wait-State Control
 *  0b0000..no additional wait-states are added (single cycle access)
 *  0b0001..1 additional wait-state is added
 *  0b0010..2 additional wait-states are added
 *  0b0011..3 additional wait-states are added
 *  0b0100..4 additional wait-states are added
 *  0b0101..5 additional wait-states are added
 *  0b0110..6 additional wait-states are added
 *  0b0111..7 additional wait-states are added
 *  0b1000..8 additional wait-states are added
 *  0b1001..9 additional wait-states are added
 *  0b1010..10 additional wait-states are added
 *  0b1011..11 additional wait-states are added
 *  0b1100..12 additional wait-states are added
 *  0b1101..13 additional wait-states are added
 *  0b1110..14 additional wait-states are added
 *  0b1111..15 additional wait-states are added
 */
#define FMUTEST_FCTRL_RWSC(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCTRL_RWSC_SHIFT)) & FMUTEST_FCTRL_RWSC_MASK)

#define FMUTEST_FCTRL_LSACTIVE_MASK              (0x100U)
#define FMUTEST_FCTRL_LSACTIVE_SHIFT             (8U)
/*! LSACTIVE - Low Speed Active Mode
 *  0b0..Full speed active mode requested
 *  0b1..Low speed active mode requested
 */
#define FMUTEST_FCTRL_LSACTIVE(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCTRL_LSACTIVE_SHIFT)) & FMUTEST_FCTRL_LSACTIVE_MASK)

#define FMUTEST_FCTRL_FDFD_MASK                  (0x10000U)
#define FMUTEST_FCTRL_FDFD_SHIFT                 (16U)
/*! FDFD - Force Double Bit Fault Detect
 *  0b0..FSTAT[DFDIF] sets only if a double bit fault is detected during a valid flash read access from the FMC
 *  0b1..FSTAT[DFDIF] sets during any valid flash read access from the FMC; an interrupt request is generated if the DFDIE bit is set
 */
#define FMUTEST_FCTRL_FDFD(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCTRL_FDFD_SHIFT)) & FMUTEST_FCTRL_FDFD_MASK)

#define FMUTEST_FCTRL_ABTREQ_MASK                (0x1000000U)
#define FMUTEST_FCTRL_ABTREQ_SHIFT               (24U)
/*! ABTREQ - Abort Request
 *  0b0..No request to abort a command write sequence
 *  0b1..Request to abort a command write sequence
 */
#define FMUTEST_FCTRL_ABTREQ(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCTRL_ABTREQ_SHIFT)) & FMUTEST_FCTRL_ABTREQ_MASK)
/*! @} */

/*! @name FTEST - Flash Test Register */
/*! @{ */

#define FMUTEST_FTEST_TMECTL_MASK                (0x1U)
#define FMUTEST_FTEST_TMECTL_SHIFT               (0U)
/*! TMECTL - Test Mode Entry Control
 *  0b0..FTEST register always reads 0 and writes to FTEST are ignored
 *  0b1..FTEST register is readable and can be written to enable writability of TME
 */
#define FMUTEST_FTEST_TMECTL(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TMECTL_SHIFT)) & FMUTEST_FTEST_TMECTL_MASK)

#define FMUTEST_FTEST_TMEWR_MASK                 (0x2U)
#define FMUTEST_FTEST_TMEWR_SHIFT                (1U)
/*! TMEWR - Test Mode Entry Writable
 *  0b0..TME bit is not writable
 *  0b1..TME bit is writable
 */
#define FMUTEST_FTEST_TMEWR(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TMEWR_SHIFT)) & FMUTEST_FTEST_TMEWR_MASK)

#define FMUTEST_FTEST_TME_MASK                   (0x4U)
#define FMUTEST_FTEST_TME_SHIFT                  (2U)
/*! TME - Test Mode Entry
 *  0b0..Test mode entry not requested
 *  0b1..Test mode entry requested
 */
#define FMUTEST_FTEST_TME(x)                     (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TME_SHIFT)) & FMUTEST_FTEST_TME_MASK)

#define FMUTEST_FTEST_TMODE_MASK                 (0x8U)
#define FMUTEST_FTEST_TMODE_SHIFT                (3U)
/*! TMODE - Test Mode Status
 *  0b0..Test mode not active
 *  0b1..Test mode active
 */
#define FMUTEST_FTEST_TMODE(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TMODE_SHIFT)) & FMUTEST_FTEST_TMODE_MASK)

#define FMUTEST_FTEST_TMELOCK_MASK               (0x10U)
#define FMUTEST_FTEST_TMELOCK_SHIFT              (4U)
/*! TMELOCK - Test Mode Entry Lock
 *  0b0..FTEST register not locked from accepting writes
 *  0b1..FTEST register locked from accepting writes
 */
#define FMUTEST_FTEST_TMELOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_FTEST_TMELOCK_SHIFT)) & FMUTEST_FTEST_TMELOCK_MASK)
/*! @} */

/*! @name FCCOB0 - Flash Command Control 0 Register */
/*! @{ */

#define FMUTEST_FCCOB0_CMDCODE_MASK              (0xFFU)
#define FMUTEST_FCCOB0_CMDCODE_SHIFT             (0U)
/*! CMDCODE - Command code */
#define FMUTEST_FCCOB0_CMDCODE(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB0_CMDCODE_SHIFT)) & FMUTEST_FCCOB0_CMDCODE_MASK)
/*! @} */

/*! @name FCCOB1 - Flash Command Control 1 Register */
/*! @{ */

#define FMUTEST_FCCOB1_CMDOPT_MASK               (0xFFU)
#define FMUTEST_FCCOB1_CMDOPT_SHIFT              (0U)
/*! CMDOPT - Command options */
#define FMUTEST_FCCOB1_CMDOPT(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB1_CMDOPT_SHIFT)) & FMUTEST_FCCOB1_CMDOPT_MASK)
/*! @} */

/*! @name FCCOB2 - Flash Command Control 2 Register */
/*! @{ */

#define FMUTEST_FCCOB2_CMDADDR_MASK              (0xFFFFFFFFU)
#define FMUTEST_FCCOB2_CMDADDR_SHIFT             (0U)
/*! CMDADDR - Command starting address */
#define FMUTEST_FCCOB2_CMDADDR(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB2_CMDADDR_SHIFT)) & FMUTEST_FCCOB2_CMDADDR_MASK)
/*! @} */

/*! @name FCCOB3 - Flash Command Control 3 Register */
/*! @{ */

#define FMUTEST_FCCOB3_CMDADDRE_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB3_CMDADDRE_SHIFT            (0U)
/*! CMDADDRE - Command ending address */
#define FMUTEST_FCCOB3_CMDADDRE(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB3_CMDADDRE_SHIFT)) & FMUTEST_FCCOB3_CMDADDRE_MASK)
/*! @} */

/*! @name FCCOB4 - Flash Command Control 4 Register */
/*! @{ */

#define FMUTEST_FCCOB4_CMDDATA0_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB4_CMDDATA0_SHIFT            (0U)
/*! CMDDATA0 - Command data word 0 */
#define FMUTEST_FCCOB4_CMDDATA0(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB4_CMDDATA0_SHIFT)) & FMUTEST_FCCOB4_CMDDATA0_MASK)
/*! @} */

/*! @name FCCOB5 - Flash Command Control 5 Register */
/*! @{ */

#define FMUTEST_FCCOB5_CMDDATA1_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB5_CMDDATA1_SHIFT            (0U)
/*! CMDDATA1 - Command data word 1 */
#define FMUTEST_FCCOB5_CMDDATA1(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB5_CMDDATA1_SHIFT)) & FMUTEST_FCCOB5_CMDDATA1_MASK)
/*! @} */

/*! @name FCCOB6 - Flash Command Control 6 Register */
/*! @{ */

#define FMUTEST_FCCOB6_CMDDATA2_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB6_CMDDATA2_SHIFT            (0U)
/*! CMDDATA2 - Command data word 2 */
#define FMUTEST_FCCOB6_CMDDATA2(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB6_CMDDATA2_SHIFT)) & FMUTEST_FCCOB6_CMDDATA2_MASK)
/*! @} */

/*! @name FCCOB7 - Flash Command Control 7 Register */
/*! @{ */

#define FMUTEST_FCCOB7_CMDDATA3_MASK             (0xFFFFFFFFU)
#define FMUTEST_FCCOB7_CMDDATA3_SHIFT            (0U)
/*! CMDDATA3 - Command data word 3 */
#define FMUTEST_FCCOB7_CMDDATA3(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FCCOB7_CMDDATA3_SHIFT)) & FMUTEST_FCCOB7_CMDDATA3_MASK)
/*! @} */

/*! @name RESET_STATUS - FMU Initialization Tracking Register */
/*! @{ */

#define FMUTEST_RESET_STATUS_ARY_TRIM_DONE_MASK  (0x1U)
#define FMUTEST_RESET_STATUS_ARY_TRIM_DONE_SHIFT (0U)
/*! ARY_TRIM_DONE - Array Trim Complete
 *  0b0..Recall register load operation has not been completed
 *  0b1..Recall register load operation has completed
 */
#define FMUTEST_RESET_STATUS_ARY_TRIM_DONE(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_ARY_TRIM_DONE_SHIFT)) & FMUTEST_RESET_STATUS_ARY_TRIM_DONE_MASK)

#define FMUTEST_RESET_STATUS_FMU_PARM_EN_MASK    (0x2U)
#define FMUTEST_RESET_STATUS_FMU_PARM_EN_SHIFT   (1U)
/*! FMU_PARM_EN - Status of the C0DE_C0DEh check to enable loading of the FMU parameters
 *  0b0..C0DE_C0DEh check not attempted
 *  0b1..C0DE_C0DEh check completed
 */
#define FMUTEST_RESET_STATUS_FMU_PARM_EN(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_FMU_PARM_EN_SHIFT)) & FMUTEST_RESET_STATUS_FMU_PARM_EN_MASK)

#define FMUTEST_RESET_STATUS_FMU_PARM_DONE_MASK  (0x4U)
#define FMUTEST_RESET_STATUS_FMU_PARM_DONE_SHIFT (2U)
/*! FMU_PARM_DONE - FMU Register Load Complete
 *  0b0..FMU registers have not been loaded
 *  0b1..FMU registers have been loaded
 */
#define FMUTEST_RESET_STATUS_FMU_PARM_DONE(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_FMU_PARM_DONE_SHIFT)) & FMUTEST_RESET_STATUS_FMU_PARM_DONE_MASK)

#define FMUTEST_RESET_STATUS_SOC_TRIM_EN_MASK    (0x8U)
#define FMUTEST_RESET_STATUS_SOC_TRIM_EN_SHIFT   (3U)
/*! SOC_TRIM_EN - Status of the C0DE_C0DEh check to enable loading of the SoC trim settings
 *  0b0..C0DE_C0DEh check not attempted
 *  0b1..C0DE_C0DEh check completed
 */
#define FMUTEST_RESET_STATUS_SOC_TRIM_EN(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_SOC_TRIM_EN_SHIFT)) & FMUTEST_RESET_STATUS_SOC_TRIM_EN_MASK)

#define FMUTEST_RESET_STATUS_SOC_TRIM_ECC_MASK   (0x10U)
#define FMUTEST_RESET_STATUS_SOC_TRIM_ECC_SHIFT  (4U)
/*! SOC_TRIM_ECC - Status of the C0DE_C0DEh check for enabling ECC decoder during reads of SoC trim settings
 *  0b0..C0DE_C0DEh check failed
 *  0b1..C0DE_C0DEh check passed
 */
#define FMUTEST_RESET_STATUS_SOC_TRIM_ECC(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_SOC_TRIM_ECC_SHIFT)) & FMUTEST_RESET_STATUS_SOC_TRIM_ECC_MASK)

#define FMUTEST_RESET_STATUS_SOC_TRIM_DONE_MASK  (0x20U)
#define FMUTEST_RESET_STATUS_SOC_TRIM_DONE_SHIFT (5U)
/*! SOC_TRIM_DONE - SoC Trim Complete
 *  0b0..SoC Trim registers have not been updated
 *  0b1..All SoC Trim registers have been updated
 */
#define FMUTEST_RESET_STATUS_SOC_TRIM_DONE(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_SOC_TRIM_DONE_SHIFT)) & FMUTEST_RESET_STATUS_SOC_TRIM_DONE_MASK)

#define FMUTEST_RESET_STATUS_RPR_DONE_MASK       (0x40U)
#define FMUTEST_RESET_STATUS_RPR_DONE_SHIFT      (6U)
/*! RPR_DONE - Array Repair Complete
 *  0b0..Repair registers have not been loaded
 *  0b1..Repair registers have been loaded
 */
#define FMUTEST_RESET_STATUS_RPR_DONE(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RPR_DONE_SHIFT)) & FMUTEST_RESET_STATUS_RPR_DONE_MASK)

#define FMUTEST_RESET_STATUS_INIT_DONE_MASK      (0x80U)
#define FMUTEST_RESET_STATUS_INIT_DONE_SHIFT     (7U)
/*! INIT_DONE - Initialization Done
 *  0b0..All initialization steps did not complete
 *  0b1..All initialization steps completed
 */
#define FMUTEST_RESET_STATUS_INIT_DONE(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_INIT_DONE_SHIFT)) & FMUTEST_RESET_STATUS_INIT_DONE_MASK)

#define FMUTEST_RESET_STATUS_RST_SF_ERR_MASK     (0x100U)
#define FMUTEST_RESET_STATUS_RST_SF_ERR_SHIFT    (8U)
/*! RST_SF_ERR - ECC Single Fault during Reset Recovery
 *  0b0..No single-bit faults detected during initialization
 *  0b1..At least one single ECC fault was detected during initialization
 */
#define FMUTEST_RESET_STATUS_RST_SF_ERR(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RST_SF_ERR_SHIFT)) & FMUTEST_RESET_STATUS_RST_SF_ERR_MASK)

#define FMUTEST_RESET_STATUS_RST_DF_ERR_MASK     (0x200U)
#define FMUTEST_RESET_STATUS_RST_DF_ERR_SHIFT    (9U)
/*! RST_DF_ERR - ECC Double Fault during Reset Recovery
 *  0b0..No double-bit faults detected during initialization
 *  0b1..Double-bit ECC fault was detected during initialization
 */
#define FMUTEST_RESET_STATUS_RST_DF_ERR(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RST_DF_ERR_SHIFT)) & FMUTEST_RESET_STATUS_RST_DF_ERR_MASK)

#define FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR_MASK (0x3FC00U)
#define FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR_SHIFT (10U)
/*! SOC_TRIM_DF_ERR - ECC Double Fault during load of SoC Trim phrases */
#define FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR_SHIFT)) & FMUTEST_RESET_STATUS_SOC_TRIM_DF_ERR_MASK)

#define FMUTEST_RESET_STATUS_RST_PATCH_LD_MASK   (0x40000U)
#define FMUTEST_RESET_STATUS_RST_PATCH_LD_SHIFT  (18U)
/*! RST_PATCH_LD - Reset Patch Required
 *  0b0..No patch required to be loaded during reset
 *  0b1..Patch loaded during reset
 */
#define FMUTEST_RESET_STATUS_RST_PATCH_LD(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RST_PATCH_LD_SHIFT)) & FMUTEST_RESET_STATUS_RST_PATCH_LD_MASK)

#define FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH_MASK (0x80000U)
#define FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH_SHIFT (19U)
/*! RECALL_DATA_MISMATCH - Recall Data Mismatch
 *  0b0..Data read towards end of reset matched data read for Recall
 *  0b1..Data read towards end of reset did not match data read for recall
 */
#define FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH_SHIFT)) & FMUTEST_RESET_STATUS_RECALL_DATA_MISMATCH_MASK)
/*! @} */

/*! @name MCTL - FMU Control Register */
/*! @{ */

#define FMUTEST_MCTL_COREHLD_MASK                (0x1U)
#define FMUTEST_MCTL_COREHLD_SHIFT               (0U)
/*! COREHLD - Core Hold
 *  0b0..CPU access is allowed
 *  0b1..CPU access must be blocked
 */
#define FMUTEST_MCTL_COREHLD(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_COREHLD_SHIFT)) & FMUTEST_MCTL_COREHLD_MASK)

#define FMUTEST_MCTL_LSACT_EN_MASK               (0x4U)
#define FMUTEST_MCTL_LSACT_EN_SHIFT              (2U)
/*! LSACT_EN - LSACTIVE Feature Enable
 *  0b0..LSACTIVE feature disabled completely: FCTRL[LSACTIVE] is forced low and no longer writable, LVE cannot assert at the TSMC array interface.
 *  0b1..LSACTIVE feature fully enabled and controllable by SoC and internal UINT SM.
 */
#define FMUTEST_MCTL_LSACT_EN(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_LSACT_EN_SHIFT)) & FMUTEST_MCTL_LSACT_EN_MASK)

#define FMUTEST_MCTL_LSACTWREN_MASK              (0x8U)
#define FMUTEST_MCTL_LSACTWREN_SHIFT             (3U)
/*! LSACTWREN - LSACTIVE Write Enable
 *  0b0..Unrestricted write access allowed
 *  0b1..Write access while CMP set must match CMDDID and CMDPRT
 */
#define FMUTEST_MCTL_LSACTWREN(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_LSACTWREN_SHIFT)) & FMUTEST_MCTL_LSACTWREN_MASK)

#define FMUTEST_MCTL_MASTER_REPAIR_EN_MASK       (0x10U)
#define FMUTEST_MCTL_MASTER_REPAIR_EN_SHIFT      (4U)
/*! MASTER_REPAIR_EN - Master Repair Enable
 *  0b0..Repair disabled
 *  0b1..Repair enable determined by bit 0 of each REPAIR register
 */
#define FMUTEST_MCTL_MASTER_REPAIR_EN(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_MASTER_REPAIR_EN_SHIFT)) & FMUTEST_MCTL_MASTER_REPAIR_EN_MASK)

#define FMUTEST_MCTL_RFCMDEN_MASK                (0x20U)
#define FMUTEST_MCTL_RFCMDEN_SHIFT               (5U)
/*! RFCMDEN - RF Active Command Enable Control
 *  0b0..Flash commands blocked (CCIF not writable)
 *  0b1..Flash commands allowed
 */
#define FMUTEST_MCTL_RFCMDEN(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_RFCMDEN_SHIFT)) & FMUTEST_MCTL_RFCMDEN_MASK)

#define FMUTEST_MCTL_CWSABTEN_MASK               (0x40U)
#define FMUTEST_MCTL_CWSABTEN_SHIFT              (6U)
/*! CWSABTEN - Command Write Sequence Abort Enable
 *  0b0..CWS abort feature is disabled
 *  0b1..CWS abort feature is enabled
 */
#define FMUTEST_MCTL_CWSABTEN(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_CWSABTEN_SHIFT)) & FMUTEST_MCTL_CWSABTEN_MASK)

#define FMUTEST_MCTL_MRGRDDIS_MASK               (0x80U)
#define FMUTEST_MCTL_MRGRDDIS_SHIFT              (7U)
/*! MRGRDDIS - Margin Read Disable
 *  0b0..Margin Read Settings are enabled
 *  0b1..Margin Read Settings are disabled
 */
#define FMUTEST_MCTL_MRGRDDIS(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_MRGRDDIS_SHIFT)) & FMUTEST_MCTL_MRGRDDIS_MASK)

#define FMUTEST_MCTL_MRGRD0_MASK                 (0xF00U)
#define FMUTEST_MCTL_MRGRD0_SHIFT                (8U)
/*! MRGRD0 - Margin Read Setting for Program */
#define FMUTEST_MCTL_MRGRD0(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_MRGRD0_SHIFT)) & FMUTEST_MCTL_MRGRD0_MASK)

#define FMUTEST_MCTL_MRGRD1_MASK                 (0xF000U)
#define FMUTEST_MCTL_MRGRD1_SHIFT                (12U)
/*! MRGRD1 - Margin Read Setting for Erase */
#define FMUTEST_MCTL_MRGRD1(x)                   (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_MRGRD1_SHIFT)) & FMUTEST_MCTL_MRGRD1_MASK)

#define FMUTEST_MCTL_ERSAACK_MASK                (0x10000U)
#define FMUTEST_MCTL_ERSAACK_SHIFT               (16U)
/*! ERSAACK - Mass Erase (Erase All) Acknowledge
 *  0b0..Mass Erase operation is not active (operation has completed or has not started)
 *  0b1..Mass Erase operation is active (controller acknowledges that the soc_ersall_req input is asserted and will continue with the operation)
 */
#define FMUTEST_MCTL_ERSAACK(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_ERSAACK_SHIFT)) & FMUTEST_MCTL_ERSAACK_MASK)

#define FMUTEST_MCTL_SCAN_OBS_MASK               (0x80000U)
#define FMUTEST_MCTL_SCAN_OBS_SHIFT              (19U)
/*! SCAN_OBS - Scan Observability Control
 *  0b0..Normal functional behavior
 *  0b1..Enables observation of signals that may otherwise be ATPG untestable
 */
#define FMUTEST_MCTL_SCAN_OBS(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_SCAN_OBS_SHIFT)) & FMUTEST_MCTL_SCAN_OBS_MASK)

#define FMUTEST_MCTL_BIST_CTL_MASK               (0x100000U)
#define FMUTEST_MCTL_BIST_CTL_SHIFT              (20U)
/*! BIST_CTL - BIST IP Control
 *  0b0..BIST IP disabled
 *  0b1..BIST IP enabled
 */
#define FMUTEST_MCTL_BIST_CTL(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_BIST_CTL_SHIFT)) & FMUTEST_MCTL_BIST_CTL_MASK)

#define FMUTEST_MCTL_SMWR_CTL_MASK               (0x200000U)
#define FMUTEST_MCTL_SMWR_CTL_SHIFT              (21U)
/*! SMWR_CTL - SMWR IP Control
 *  0b0..SMWR IP disabled
 *  0b1..SMWR IP enabled
 */
#define FMUTEST_MCTL_SMWR_CTL(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_SMWR_CTL_SHIFT)) & FMUTEST_MCTL_SMWR_CTL_MASK)

#define FMUTEST_MCTL_SALV_DIS_MASK               (0x1000000U)
#define FMUTEST_MCTL_SALV_DIS_SHIFT              (24U)
/*! SALV_DIS - Salvage Disable
 *  0b0..Salvage enabled (ECC used during erase verify)
 *  0b1..Salvage disabled (ECC not used during erase verify)
 */
#define FMUTEST_MCTL_SALV_DIS(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_SALV_DIS_SHIFT)) & FMUTEST_MCTL_SALV_DIS_MASK)

#define FMUTEST_MCTL_SOC_ECC_CTL_MASK            (0x2000000U)
#define FMUTEST_MCTL_SOC_ECC_CTL_SHIFT           (25U)
/*! SOC_ECC_CTL - SOC ECC Control
 *  0b0..ECC is enabled for SOC read access
 *  0b1..ECC is disabled for SOC read access
 */
#define FMUTEST_MCTL_SOC_ECC_CTL(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_SOC_ECC_CTL_SHIFT)) & FMUTEST_MCTL_SOC_ECC_CTL_MASK)

#define FMUTEST_MCTL_FMU_ECC_CTL_MASK            (0x4000000U)
#define FMUTEST_MCTL_FMU_ECC_CTL_SHIFT           (26U)
/*! FMU_ECC_CTL - FMU ECC Control
 *  0b0..ECC is enabled for FMU program operations
 *  0b1..ECC is disabled for FMU program operations
 */
#define FMUTEST_MCTL_FMU_ECC_CTL(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_FMU_ECC_CTL_SHIFT)) & FMUTEST_MCTL_FMU_ECC_CTL_MASK)

#define FMUTEST_MCTL_BIST_PWR_DIS_MASK           (0x20000000U)
#define FMUTEST_MCTL_BIST_PWR_DIS_SHIFT          (29U)
/*! BIST_PWR_DIS - BIST Power Mode Disable
 *  0b0..BIST DFT logic has full control of SLM and LVE when BIST is enabled (including during commands)
 *  0b1..BIST DFT logic has no control of SLM and LVE; power mode RTL is in complete control of SLM and LVE values
 */
#define FMUTEST_MCTL_BIST_PWR_DIS(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_BIST_PWR_DIS_SHIFT)) & FMUTEST_MCTL_BIST_PWR_DIS_MASK)

#define FMUTEST_MCTL_OSC_H_MASK                  (0x80000000U)
#define FMUTEST_MCTL_OSC_H_SHIFT                 (31U)
/*! OSC_H - Oscillator control
 *  0b0..Use APB clock
 *  0b1..Use a known fixed-frequency clock, e.g. 12 MHz
 */
#define FMUTEST_MCTL_OSC_H(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_MCTL_OSC_H_SHIFT)) & FMUTEST_MCTL_OSC_H_MASK)
/*! @} */

/*! @name BSEL_GEN - FMU Block Select Generation Register */
/*! @{ */

#define FMUTEST_BSEL_GEN_SBSEL_GEN_MASK          (0x3U)
#define FMUTEST_BSEL_GEN_SBSEL_GEN_SHIFT         (0U)
/*! SBSEL_GEN - Generated SBSEL */
#define FMUTEST_BSEL_GEN_SBSEL_GEN(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_BSEL_GEN_SBSEL_GEN_SHIFT)) & FMUTEST_BSEL_GEN_SBSEL_GEN_MASK)

#define FMUTEST_BSEL_GEN_MBSEL_GEN_MASK          (0x300U)
#define FMUTEST_BSEL_GEN_MBSEL_GEN_SHIFT         (8U)
/*! MBSEL_GEN - Generated MBSEL */
#define FMUTEST_BSEL_GEN_MBSEL_GEN(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_BSEL_GEN_MBSEL_GEN_SHIFT)) & FMUTEST_BSEL_GEN_MBSEL_GEN_MASK)
/*! @} */

/*! @name PWR_OPT - Power Mode Options Register */
/*! @{ */

#define FMUTEST_PWR_OPT_PD_CDIV_MASK             (0xFFU)
#define FMUTEST_PWR_OPT_PD_CDIV_SHIFT            (0U)
/*! PD_CDIV - Power Down Clock Divider Setting */
#define FMUTEST_PWR_OPT_PD_CDIV(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_PWR_OPT_PD_CDIV_SHIFT)) & FMUTEST_PWR_OPT_PD_CDIV_MASK)

#define FMUTEST_PWR_OPT_SLM_COUNT_MASK           (0x3FF0000U)
#define FMUTEST_PWR_OPT_SLM_COUNT_SHIFT          (16U)
/*! SLM_COUNT - Sleep Recovery Timer Count */
#define FMUTEST_PWR_OPT_SLM_COUNT(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_PWR_OPT_SLM_COUNT_SHIFT)) & FMUTEST_PWR_OPT_SLM_COUNT_MASK)

#define FMUTEST_PWR_OPT_PD_TIMER_EN_MASK         (0x80000000U)
#define FMUTEST_PWR_OPT_PD_TIMER_EN_SHIFT        (31U)
/*! PD_TIMER_EN - Power Down BIST Timer Enable
 *  0b0..BIST timer is not triggered during Power Down recovery
 *  0b1..BIST timer is triggered during Power Down recovery (default behavior)
 */
#define FMUTEST_PWR_OPT_PD_TIMER_EN(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_PWR_OPT_PD_TIMER_EN_SHIFT)) & FMUTEST_PWR_OPT_PD_TIMER_EN_MASK)
/*! @} */

/*! @name CMD_CHECK - FMU Command Check Register */
/*! @{ */

#define FMUTEST_CMD_CHECK_ALIGNFAIL_PHR_MASK     (0x1U)
#define FMUTEST_CMD_CHECK_ALIGNFAIL_PHR_SHIFT    (0U)
/*! ALIGNFAIL_PHR - Phrase Alignment Fail
 *  0b0..The address is phrase-aligned
 *  0b1..The address is not phrase-aligned
 */
#define FMUTEST_CMD_CHECK_ALIGNFAIL_PHR(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALIGNFAIL_PHR_SHIFT)) & FMUTEST_CMD_CHECK_ALIGNFAIL_PHR_MASK)

#define FMUTEST_CMD_CHECK_ALIGNFAIL_PG_MASK      (0x2U)
#define FMUTEST_CMD_CHECK_ALIGNFAIL_PG_SHIFT     (1U)
/*! ALIGNFAIL_PG - Page Alignment Fail
 *  0b0..The address is page-aligned
 *  0b1..The address is not page-aligned
 */
#define FMUTEST_CMD_CHECK_ALIGNFAIL_PG(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALIGNFAIL_PG_SHIFT)) & FMUTEST_CMD_CHECK_ALIGNFAIL_PG_MASK)

#define FMUTEST_CMD_CHECK_ALIGNFAIL_SCR_MASK     (0x4U)
#define FMUTEST_CMD_CHECK_ALIGNFAIL_SCR_SHIFT    (2U)
/*! ALIGNFAIL_SCR - Sector Alignment Fail
 *  0b0..The address is sector-aligned
 *  0b1..The address is not sector-aligned
 */
#define FMUTEST_CMD_CHECK_ALIGNFAIL_SCR(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALIGNFAIL_SCR_SHIFT)) & FMUTEST_CMD_CHECK_ALIGNFAIL_SCR_MASK)

#define FMUTEST_CMD_CHECK_ALIGNFAIL_BLK_MASK     (0x8U)
#define FMUTEST_CMD_CHECK_ALIGNFAIL_BLK_SHIFT    (3U)
/*! ALIGNFAIL_BLK - Block Alignment Fail
 *  0b0..The address is block-aligned
 *  0b1..The address is not block-aligned
 */
#define FMUTEST_CMD_CHECK_ALIGNFAIL_BLK(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALIGNFAIL_BLK_SHIFT)) & FMUTEST_CMD_CHECK_ALIGNFAIL_BLK_MASK)

#define FMUTEST_CMD_CHECK_ADDR_FAIL_MASK         (0x10U)
#define FMUTEST_CMD_CHECK_ADDR_FAIL_SHIFT        (4U)
/*! ADDR_FAIL - Address Fail
 *  0b0..The address is within the flash or IFR address space
 *  0b1..The address is outside the flash or IFR address space
 */
#define FMUTEST_CMD_CHECK_ADDR_FAIL(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ADDR_FAIL_SHIFT)) & FMUTEST_CMD_CHECK_ADDR_FAIL_MASK)

#define FMUTEST_CMD_CHECK_IFR_CMD_MASK           (0x20U)
#define FMUTEST_CMD_CHECK_IFR_CMD_SHIFT          (5U)
/*! IFR_CMD - IFR Command
 *  0b0..The command operates on a main flash address
 *  0b1..The command operates on an IFR address
 */
#define FMUTEST_CMD_CHECK_IFR_CMD(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_IFR_CMD_SHIFT)) & FMUTEST_CMD_CHECK_IFR_CMD_MASK)

#define FMUTEST_CMD_CHECK_ALL_CMD_MASK           (0x40U)
#define FMUTEST_CMD_CHECK_ALL_CMD_SHIFT          (6U)
/*! ALL_CMD - All Blocks Command
 *  0b0..The command operates on a single flash block
 *  0b1..The command operates on all flash blocks
 */
#define FMUTEST_CMD_CHECK_ALL_CMD(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ALL_CMD_SHIFT)) & FMUTEST_CMD_CHECK_ALL_CMD_MASK)

#define FMUTEST_CMD_CHECK_RANGE_FAIL_MASK        (0x80U)
#define FMUTEST_CMD_CHECK_RANGE_FAIL_SHIFT       (7U)
/*! RANGE_FAIL - Address Range Fail
 *  0b0..The address range is valid
 *  0b1..The address range is invalid
 */
#define FMUTEST_CMD_CHECK_RANGE_FAIL(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_RANGE_FAIL_SHIFT)) & FMUTEST_CMD_CHECK_RANGE_FAIL_MASK)

#define FMUTEST_CMD_CHECK_SCR_ALIGN_CHK_MASK     (0x100U)
#define FMUTEST_CMD_CHECK_SCR_ALIGN_CHK_SHIFT    (8U)
/*! SCR_ALIGN_CHK - Sector Alignment Check
 *  0b0..No sector alignment check
 *  0b1..Sector alignment check
 */
#define FMUTEST_CMD_CHECK_SCR_ALIGN_CHK(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_SCR_ALIGN_CHK_SHIFT)) & FMUTEST_CMD_CHECK_SCR_ALIGN_CHK_MASK)

#define FMUTEST_CMD_CHECK_OPTION_FAIL_MASK       (0x200U)
#define FMUTEST_CMD_CHECK_OPTION_FAIL_SHIFT      (9U)
/*! OPTION_FAIL - Option Check Fail
 *  0b0..Option check passes for read command or command is not a read command
 *  0b1..Option check fails for read command
 */
#define FMUTEST_CMD_CHECK_OPTION_FAIL(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_OPTION_FAIL_SHIFT)) & FMUTEST_CMD_CHECK_OPTION_FAIL_MASK)

#define FMUTEST_CMD_CHECK_ILLEGAL_CMD_MASK       (0x400U)
#define FMUTEST_CMD_CHECK_ILLEGAL_CMD_SHIFT      (10U)
/*! ILLEGAL_CMD - Illegal Command
 *  0b0..Command is legal
 *  0b1..Command is illegal
 */
#define FMUTEST_CMD_CHECK_ILLEGAL_CMD(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_CMD_CHECK_ILLEGAL_CMD_SHIFT)) & FMUTEST_CMD_CHECK_ILLEGAL_CMD_MASK)
/*! @} */

/*! @name BSEL - FMU Block Select Register */
/*! @{ */

#define FMUTEST_BSEL_SBSEL_MASK                  (0x3U)
#define FMUTEST_BSEL_SBSEL_SHIFT                 (0U)
/*! SBSEL - Slave Block Select */
#define FMUTEST_BSEL_SBSEL(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_BSEL_SBSEL_SHIFT)) & FMUTEST_BSEL_SBSEL_MASK)

#define FMUTEST_BSEL_MBSEL_MASK                  (0x300U)
#define FMUTEST_BSEL_MBSEL_SHIFT                 (8U)
/*! MBSEL - Master Block Select */
#define FMUTEST_BSEL_MBSEL(x)                    (((uint32_t)(((uint32_t)(x)) << FMUTEST_BSEL_MBSEL_SHIFT)) & FMUTEST_BSEL_MBSEL_MASK)
/*! @} */

/*! @name MSIZE - FMU Memory Size Register */
/*! @{ */

#define FMUTEST_MSIZE_MAXADDR0_MASK              (0xFFU)
#define FMUTEST_MSIZE_MAXADDR0_SHIFT             (0U)
/*! MAXADDR0 - Size of Flash Block 0 */
#define FMUTEST_MSIZE_MAXADDR0(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_MSIZE_MAXADDR0_SHIFT)) & FMUTEST_MSIZE_MAXADDR0_MASK)

#define FMUTEST_MSIZE_MAXADDR1_MASK              (0xFF00U)
#define FMUTEST_MSIZE_MAXADDR1_SHIFT             (8U)
/*! MAXADDR1 - Size of Flash Block 1 */
#define FMUTEST_MSIZE_MAXADDR1(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_MSIZE_MAXADDR1_SHIFT)) & FMUTEST_MSIZE_MAXADDR1_MASK)
/*! @} */

/*! @name FLASH_RD_ADD - Flash Read Address Register */
/*! @{ */

#define FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD_MASK   (0xFFFFFFFFU)
#define FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD_SHIFT  (0U)
/*! FLASH_RD_ADD - Flash Read Address */
#define FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD_SHIFT)) & FMUTEST_FLASH_RD_ADD_FLASH_RD_ADD_MASK)
/*! @} */

/*! @name FLASH_STOP_ADD - Flash Stop Address Register */
/*! @{ */

#define FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD_MASK (0xFFFFFFFFU)
#define FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD_SHIFT (0U)
/*! FLASH_STOP_ADD - Flash Stop Address */
#define FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD_SHIFT)) & FMUTEST_FLASH_STOP_ADD_FLASH_STOP_ADD_MASK)
/*! @} */

/*! @name FLASH_RD_CTRL - Flash Read Control Register */
/*! @{ */

#define FMUTEST_FLASH_RD_CTRL_FLASH_RD_MASK      (0x1U)
#define FMUTEST_FLASH_RD_CTRL_FLASH_RD_SHIFT     (0U)
/*! FLASH_RD - Flash Read Enable
 *  0b0..Manual flash read not enabled.(default)
 *  0b1..Manual flash read enabled
 */
#define FMUTEST_FLASH_RD_CTRL_FLASH_RD(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_RD_CTRL_FLASH_RD_SHIFT)) & FMUTEST_FLASH_RD_CTRL_FLASH_RD_MASK)

#define FMUTEST_FLASH_RD_CTRL_WIDE_LOAD_MASK     (0x2U)
#define FMUTEST_FLASH_RD_CTRL_WIDE_LOAD_SHIFT    (1U)
/*! WIDE_LOAD - Wide Load Enable
 *  0b0..Wide load mode disabled (default)
 *  0b1..Wide load mode enabled
 */
#define FMUTEST_FLASH_RD_CTRL_WIDE_LOAD(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_RD_CTRL_WIDE_LOAD_SHIFT)) & FMUTEST_FLASH_RD_CTRL_WIDE_LOAD_MASK)

#define FMUTEST_FLASH_RD_CTRL_SINGLE_RD_MASK     (0x4U)
#define FMUTEST_FLASH_RD_CTRL_SINGLE_RD_SHIFT    (2U)
/*! SINGLE_RD - Single Flash Read
 *  0b0..Normal UINT operation
 *  0b1..UINT configured for single cycle reads
 */
#define FMUTEST_FLASH_RD_CTRL_SINGLE_RD(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_FLASH_RD_CTRL_SINGLE_RD_SHIFT)) & FMUTEST_FLASH_RD_CTRL_SINGLE_RD_MASK)
/*! @} */

/*! @name MM_ADDR - Memory Map Address Register */
/*! @{ */

#define FMUTEST_MM_ADDR_MM_ADDR_MASK             (0xFFFFFFFFU)
#define FMUTEST_MM_ADDR_MM_ADDR_SHIFT            (0U)
/*! MM_ADDR - Memory Map Address */
#define FMUTEST_MM_ADDR_MM_ADDR(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_ADDR_MM_ADDR_SHIFT)) & FMUTEST_MM_ADDR_MM_ADDR_MASK)
/*! @} */

/*! @name MM_WDATA - Memory Map Write Data Register */
/*! @{ */

#define FMUTEST_MM_WDATA_MM_WDATA_MASK           (0xFFFFFFFFU)
#define FMUTEST_MM_WDATA_MM_WDATA_SHIFT          (0U)
/*! MM_WDATA - Memory Map Write Data */
#define FMUTEST_MM_WDATA_MM_WDATA(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_WDATA_MM_WDATA_SHIFT)) & FMUTEST_MM_WDATA_MM_WDATA_MASK)
/*! @} */

/*! @name MM_CTL - Memory Map Control Register */
/*! @{ */

#define FMUTEST_MM_CTL_MM_SEL_MASK               (0x1U)
#define FMUTEST_MM_CTL_MM_SEL_SHIFT              (0U)
/*! MM_SEL - Register Access Enable */
#define FMUTEST_MM_CTL_MM_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_CTL_MM_SEL_SHIFT)) & FMUTEST_MM_CTL_MM_SEL_MASK)

#define FMUTEST_MM_CTL_MM_RD_MASK                (0x2U)
#define FMUTEST_MM_CTL_MM_RD_SHIFT               (1U)
/*! MM_RD - Register R/W Control
 *  0b0..Write to register
 *  0b1..Read register
 */
#define FMUTEST_MM_CTL_MM_RD(x)                  (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_CTL_MM_RD_SHIFT)) & FMUTEST_MM_CTL_MM_RD_MASK)

#define FMUTEST_MM_CTL_BIST_ON_MASK              (0x4U)
#define FMUTEST_MM_CTL_BIST_ON_SHIFT             (2U)
/*! BIST_ON - BIST on
 *  0b0..BIST enable not forced by user interface
 *  0b1..BIST enable control by user interface
 */
#define FMUTEST_MM_CTL_BIST_ON(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_CTL_BIST_ON_SHIFT)) & FMUTEST_MM_CTL_BIST_ON_MASK)

#define FMUTEST_MM_CTL_FORCE_SW_CLK_MASK         (0x8U)
#define FMUTEST_MM_CTL_FORCE_SW_CLK_SHIFT        (3U)
/*! FORCE_SW_CLK - Force Switch Clock
 *  0b0..Switch clock not forced on (gated normally)
 *  0b1..Switch clock forced on
 */
#define FMUTEST_MM_CTL_FORCE_SW_CLK(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_MM_CTL_FORCE_SW_CLK_SHIFT)) & FMUTEST_MM_CTL_FORCE_SW_CLK_MASK)
/*! @} */

/*! @name UINT_CTL - User Interface Control Register */
/*! @{ */

#define FMUTEST_UINT_CTL_SET_FAIL_MASK           (0x1U)
#define FMUTEST_UINT_CTL_SET_FAIL_SHIFT          (0U)
/*! SET_FAIL - Set Fail On Exit
 *  0b0..FAIL flag should not be set on command exit (no failure detected)
 *  0b1..FAIL flag should be set on command exit
 */
#define FMUTEST_UINT_CTL_SET_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_UINT_CTL_SET_FAIL_SHIFT)) & FMUTEST_UINT_CTL_SET_FAIL_MASK)

#define FMUTEST_UINT_CTL_DBERR_MASK              (0x2U)
#define FMUTEST_UINT_CTL_DBERR_SHIFT             (1U)
/*! DBERR - Double-Bit ECC Fault Detect
 *  0b0..No double-bit fault detected during UINT-driven read sequence
 *  0b1..Double-bit fault detected during UINT-driven read sequence
 */
#define FMUTEST_UINT_CTL_DBERR(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_UINT_CTL_DBERR_SHIFT)) & FMUTEST_UINT_CTL_DBERR_MASK)
/*! @} */

/*! @name RD_DATA0 - Read Data 0 Register */
/*! @{ */

#define FMUTEST_RD_DATA0_RD_DATA0_MASK           (0xFFFFFFFFU)
#define FMUTEST_RD_DATA0_RD_DATA0_SHIFT          (0U)
/*! RD_DATA0 - Read Data 0 */
#define FMUTEST_RD_DATA0_RD_DATA0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_DATA0_RD_DATA0_SHIFT)) & FMUTEST_RD_DATA0_RD_DATA0_MASK)
/*! @} */

/*! @name RD_DATA1 - Read Data 1 Register */
/*! @{ */

#define FMUTEST_RD_DATA1_RD_DATA1_MASK           (0xFFFFFFFFU)
#define FMUTEST_RD_DATA1_RD_DATA1_SHIFT          (0U)
/*! RD_DATA1 - Read Data 1 */
#define FMUTEST_RD_DATA1_RD_DATA1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_DATA1_RD_DATA1_SHIFT)) & FMUTEST_RD_DATA1_RD_DATA1_MASK)
/*! @} */

/*! @name RD_DATA2 - Read Data 2 Register */
/*! @{ */

#define FMUTEST_RD_DATA2_RD_DATA2_MASK           (0xFFFFFFFFU)
#define FMUTEST_RD_DATA2_RD_DATA2_SHIFT          (0U)
/*! RD_DATA2 - Read Data 2 */
#define FMUTEST_RD_DATA2_RD_DATA2(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_DATA2_RD_DATA2_SHIFT)) & FMUTEST_RD_DATA2_RD_DATA2_MASK)
/*! @} */

/*! @name RD_DATA3 - Read Data 3 Register */
/*! @{ */

#define FMUTEST_RD_DATA3_RD_DATA3_MASK           (0xFFFFFFFFU)
#define FMUTEST_RD_DATA3_RD_DATA3_SHIFT          (0U)
/*! RD_DATA3 - Read Data 3 */
#define FMUTEST_RD_DATA3_RD_DATA3(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_DATA3_RD_DATA3_SHIFT)) & FMUTEST_RD_DATA3_RD_DATA3_MASK)
/*! @} */

/*! @name PARITY - Parity Register */
/*! @{ */

#define FMUTEST_PARITY_PARITY_MASK               (0x1FFU)
#define FMUTEST_PARITY_PARITY_SHIFT              (0U)
/*! PARITY - Read data [136:128] */
#define FMUTEST_PARITY_PARITY(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_PARITY_PARITY_SHIFT)) & FMUTEST_PARITY_PARITY_MASK)
/*! @} */

/*! @name RD_PATH_CTRL_STATUS - Read Path Control and Status Register */
/*! @{ */

#define FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT_MASK (0xFFU)
#define FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT_SHIFT (0U)
/*! RD_CAPT - Read Capture Clock Periods */
#define FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_RD_CAPT_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE_MASK (0xFF00U)
#define FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE_SHIFT (8U)
/*! SE_SIZE - SE Clock Periods */
#define FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_SE_SIZE_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB_MASK (0x10000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB_SHIFT (16U)
/*! ECC_ENABLEB - ECC Decoder Control
 *  0b0..ECC decoder enabled (default)
 *  0b1..ECC decoder disabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_ECC_ENABLEB_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN_MASK (0x20000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN_SHIFT (17U)
/*! MISR_EN - MISR Enable
 *  0b0..MISR option disabled (default)
 *  0b1..MISR option enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_MISR_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN_MASK (0x40000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN_SHIFT (18U)
/*! CPY_PAR_EN - Copy Parity Enable
 *  0b0..Copy parity disabled
 *  0b1..Copy parity enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_CPY_PAR_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW_MASK (0x80000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW_SHIFT (19U)
/*! BIST_MUX_TO_SMW - BIST Mux to SMW
 *  0b0..BIST drives fields
 *  0b1..SMW registers drive fields
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_BIST_MUX_TO_SMW_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_AD_SET_MASK  (0xF00000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_AD_SET_SHIFT (20U)
/*! AD_SET - Multi-Cycle Address Setup Time */
#define FMUTEST_RD_PATH_CTRL_STATUS_AD_SET(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_AD_SET_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_AD_SET_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN_MASK (0x1000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN_SHIFT (24U)
/*! WR_PATH_EN - Write Path Enable
 *  0b0..Writes to BIST setting registers driven by MM_WDATA
 *  0b1..Writes to BIST setting registers driven by SMW_DIN
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN_MASK (0x2000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN_SHIFT (25U)
/*! WR_PATH_ECC_EN - Write Path ECC Enable
 *  0b0..ECC encoding disabled
 *  0b1..ECC encoding enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_WR_PATH_ECC_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG_MASK (0x4000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG_SHIFT (26U)
/*! DBERR_REG - Double-Bit Error
 *  0b0..Double-bit fault not detected
 *  0b1..Double-bit fault detected on previous UINT flash read
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_DBERR_REG_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG_MASK (0x8000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG_SHIFT (27U)
/*! SBERR_REG - Single-Bit Error
 *  0b0..Single-bit fault not detected
 *  0b1..Single-bit fault detected on previous UINT flash read
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_SBERR_REG_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN_MASK (0x10000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN_SHIFT (28U)
/*! CPY_PHRASE_EN - Copy Phrase Enable
 *  0b0..Copy Flash read data disabled
 *  0b1..Copy Flash read data enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_CPY_PHRASE_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL_MASK (0x20000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL_SHIFT (29U)
/*! SMW_ARRAY1_SMW0_SEL - SMW_ARRAY1_SMW0_SEL
 *  0b0..Select block 0
 *  0b1..Select block 1
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_SMW_ARRAY1_SMW0_SEL_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN_MASK (0x40000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN_SHIFT (30U)
/*! BIST_ECC_EN - BIST ECC Enable
 *  0b0..ECC correction disabled
 *  0b1..ECC correction enabled
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_BIST_ECC_EN_MASK)

#define FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ_MASK (0x80000000U)
#define FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ_SHIFT (31U)
/*! LAST_READ - Last Read
 *  0b0..Latest read not last in multi-address operation
 *  0b1..Latest read last in multi-address operation
 */
#define FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ_SHIFT)) & FMUTEST_RD_PATH_CTRL_STATUS_LAST_READ_MASK)
/*! @} */

/*! @name SMW_DIN0 - SMW DIN 0 Register */
/*! @{ */

#define FMUTEST_SMW_DIN0_SMW_DIN0_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_DIN0_SMW_DIN0_SHIFT          (0U)
/*! SMW_DIN0 - SMW DIN 0 */
#define FMUTEST_SMW_DIN0_SMW_DIN0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_DIN0_SMW_DIN0_SHIFT)) & FMUTEST_SMW_DIN0_SMW_DIN0_MASK)
/*! @} */

/*! @name SMW_DIN1 - SMW DIN 1 Register */
/*! @{ */

#define FMUTEST_SMW_DIN1_SMW_DIN1_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_DIN1_SMW_DIN1_SHIFT          (0U)
/*! SMW_DIN1 - SMW DIN 1 */
#define FMUTEST_SMW_DIN1_SMW_DIN1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_DIN1_SMW_DIN1_SHIFT)) & FMUTEST_SMW_DIN1_SMW_DIN1_MASK)
/*! @} */

/*! @name SMW_DIN2 - SMW DIN 2 Register */
/*! @{ */

#define FMUTEST_SMW_DIN2_SMW_DIN2_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_DIN2_SMW_DIN2_SHIFT          (0U)
/*! SMW_DIN2 - SMW DIN 2 */
#define FMUTEST_SMW_DIN2_SMW_DIN2(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_DIN2_SMW_DIN2_SHIFT)) & FMUTEST_SMW_DIN2_SMW_DIN2_MASK)
/*! @} */

/*! @name SMW_DIN3 - SMW DIN 3 Register */
/*! @{ */

#define FMUTEST_SMW_DIN3_SMW_DIN3_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_DIN3_SMW_DIN3_SHIFT          (0U)
/*! SMW_DIN3 - SMW DIN 3 */
#define FMUTEST_SMW_DIN3_SMW_DIN3(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_DIN3_SMW_DIN3_SHIFT)) & FMUTEST_SMW_DIN3_SMW_DIN3_MASK)
/*! @} */

/*! @name SMW_ADDR - SMW Address Register */
/*! @{ */

#define FMUTEST_SMW_ADDR_SMW_ADDR_MASK           (0xFFFFFFFFU)
#define FMUTEST_SMW_ADDR_SMW_ADDR_SHIFT          (0U)
/*! SMW_ADDR - SMW Address */
#define FMUTEST_SMW_ADDR_SMW_ADDR(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_ADDR_SMW_ADDR_SHIFT)) & FMUTEST_SMW_ADDR_SMW_ADDR_MASK)
/*! @} */

/*! @name SMW_CMD_WAIT - SMW Command and Wait Register */
/*! @{ */

#define FMUTEST_SMW_CMD_WAIT_CMD_MASK            (0x7U)
#define FMUTEST_SMW_CMD_WAIT_CMD_SHIFT           (0U)
/*! CMD - SMW Command
 *  0b000..IDLE
 *  0b001..ABORT
 *  0b010..SME2 to one-shot mass erase
 *  0b011..SME3 to sector erase on selected array
 *  0b100..SMP1 to program phrase or page on selected array with shot disabled on previously programmed bit
 *  0b101..Reserved for SME4 (multi-sector erase)
 *  0b110..SMP2 to program phrase or page on selected array to repair cells of weak program after power loss
 *  0b111..Reserved
 */
#define FMUTEST_SMW_CMD_WAIT_CMD(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_CMD_WAIT_CMD_SHIFT)) & FMUTEST_SMW_CMD_WAIT_CMD_MASK)

#define FMUTEST_SMW_CMD_WAIT_WAIT_EN_MASK        (0x8U)
#define FMUTEST_SMW_CMD_WAIT_WAIT_EN_SHIFT       (3U)
/*! WAIT_EN - SMW Wait Enable
 *  0b0..Wait feature disabled
 *  0b1..Wait feature enabled
 */
#define FMUTEST_SMW_CMD_WAIT_WAIT_EN(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_CMD_WAIT_WAIT_EN_SHIFT)) & FMUTEST_SMW_CMD_WAIT_WAIT_EN_MASK)

#define FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET_MASK  (0x10U)
#define FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET_SHIFT (4U)
/*! WAIT_AUTO_SET - SMW Wait Auto Set */
#define FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET_SHIFT)) & FMUTEST_SMW_CMD_WAIT_WAIT_AUTO_SET_MASK)
/*! @} */

/*! @name SMW_STATUS - SMW Status Register */
/*! @{ */

#define FMUTEST_SMW_STATUS_SMW_ERR_MASK          (0x1U)
#define FMUTEST_SMW_STATUS_SMW_ERR_SHIFT         (0U)
/*! SMW_ERR - SMW Error
 *  0b0..Error not detected
 *  0b1..Error detected
 */
#define FMUTEST_SMW_STATUS_SMW_ERR(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_STATUS_SMW_ERR_SHIFT)) & FMUTEST_SMW_STATUS_SMW_ERR_MASK)

#define FMUTEST_SMW_STATUS_SMW_BUSY_MASK         (0x2U)
#define FMUTEST_SMW_STATUS_SMW_BUSY_SHIFT        (1U)
/*! SMW_BUSY - SMW Busy
 *  0b0..SMW command not active
 *  0b1..SMW command is active
 */
#define FMUTEST_SMW_STATUS_SMW_BUSY(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_STATUS_SMW_BUSY_SHIFT)) & FMUTEST_SMW_STATUS_SMW_BUSY_MASK)

#define FMUTEST_SMW_STATUS_BIST_BUSY_MASK        (0x4U)
#define FMUTEST_SMW_STATUS_BIST_BUSY_SHIFT       (2U)
/*! BIST_BUSY - BIST Busy
 *  0b0..BIST Command not active
 *  0b1..BIST Command is active
 */
#define FMUTEST_SMW_STATUS_BIST_BUSY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_STATUS_BIST_BUSY_SHIFT)) & FMUTEST_SMW_STATUS_BIST_BUSY_MASK)
/*! @} */

/*! @name SOCTRIM0_0 - SoC Trim Phrase 0 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM0_0_TRIM0_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM0_0_TRIM0_0_SHIFT         (0U)
/*! TRIM0_0 - TRIM0_0 */
#define FMUTEST_SOCTRIM0_0_TRIM0_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM0_0_TRIM0_0_SHIFT)) & FMUTEST_SOCTRIM0_0_TRIM0_0_MASK)
/*! @} */

/*! @name SOCTRIM0_1 - SoC Trim Phrase 0 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM0_1_TRIM0_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM0_1_TRIM0_1_SHIFT         (0U)
/*! TRIM0_1 - TRIM0_1 */
#define FMUTEST_SOCTRIM0_1_TRIM0_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM0_1_TRIM0_1_SHIFT)) & FMUTEST_SOCTRIM0_1_TRIM0_1_MASK)
/*! @} */

/*! @name SOCTRIM0_2 - SoC Trim Phrase 0 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM0_2_TRIM0_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM0_2_TRIM0_2_SHIFT         (0U)
/*! TRIM0_2 - TRIM0_2 */
#define FMUTEST_SOCTRIM0_2_TRIM0_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM0_2_TRIM0_2_SHIFT)) & FMUTEST_SOCTRIM0_2_TRIM0_2_MASK)
/*! @} */

/*! @name SOCTRIM0_3 - SoC Trim Phrase 0 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM0_3_TRIM0_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM0_3_TRIM0_3_SHIFT         (0U)
/*! TRIM0_3 - TRIM0_3 */
#define FMUTEST_SOCTRIM0_3_TRIM0_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM0_3_TRIM0_3_SHIFT)) & FMUTEST_SOCTRIM0_3_TRIM0_3_MASK)
/*! @} */

/*! @name SOCTRIM1_0 - SoC Trim Phrase 1 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM1_0_TRIM1_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM1_0_TRIM1_0_SHIFT         (0U)
/*! TRIM1_0 - TRIM1_0 */
#define FMUTEST_SOCTRIM1_0_TRIM1_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM1_0_TRIM1_0_SHIFT)) & FMUTEST_SOCTRIM1_0_TRIM1_0_MASK)
/*! @} */

/*! @name SOCTRIM1_1 - SoC Trim Phrase 1 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM1_1_TRIM1_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM1_1_TRIM1_1_SHIFT         (0U)
/*! TRIM1_1 - TRIM1_1 */
#define FMUTEST_SOCTRIM1_1_TRIM1_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM1_1_TRIM1_1_SHIFT)) & FMUTEST_SOCTRIM1_1_TRIM1_1_MASK)
/*! @} */

/*! @name SOCTRIM1_2 - SoC Trim Phrase 1 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM1_2_TRIM1_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM1_2_TRIM1_2_SHIFT         (0U)
/*! TRIM1_2 - TRIM1_2 */
#define FMUTEST_SOCTRIM1_2_TRIM1_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM1_2_TRIM1_2_SHIFT)) & FMUTEST_SOCTRIM1_2_TRIM1_2_MASK)
/*! @} */

/*! @name SOCTRIM1_3 - SoC Trim Phrase 1 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM1_3_TRIM1_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM1_3_TRIM1_3_SHIFT         (0U)
/*! TRIM1_3 - TRIM1_3 */
#define FMUTEST_SOCTRIM1_3_TRIM1_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM1_3_TRIM1_3_SHIFT)) & FMUTEST_SOCTRIM1_3_TRIM1_3_MASK)
/*! @} */

/*! @name SOCTRIM2_0 - SoC Trim Phrase 2 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM2_0_TRIM2_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM2_0_TRIM2_0_SHIFT         (0U)
/*! TRIM2_0 - TRIM2_0 */
#define FMUTEST_SOCTRIM2_0_TRIM2_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM2_0_TRIM2_0_SHIFT)) & FMUTEST_SOCTRIM2_0_TRIM2_0_MASK)
/*! @} */

/*! @name SOCTRIM2_1 - SoC Trim Phrase 2 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM2_1_TRIM2_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM2_1_TRIM2_1_SHIFT         (0U)
/*! TRIM2_1 - TRIM2_1 */
#define FMUTEST_SOCTRIM2_1_TRIM2_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM2_1_TRIM2_1_SHIFT)) & FMUTEST_SOCTRIM2_1_TRIM2_1_MASK)
/*! @} */

/*! @name SOCTRIM2_2 - SoC Trim Phrase 2 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM2_2_TRIM2_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM2_2_TRIM2_2_SHIFT         (0U)
/*! TRIM2_2 - TRIM2_2 */
#define FMUTEST_SOCTRIM2_2_TRIM2_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM2_2_TRIM2_2_SHIFT)) & FMUTEST_SOCTRIM2_2_TRIM2_2_MASK)
/*! @} */

/*! @name SOCTRIM2_3 - SoC Trim Phrase 2 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM2_3_TRIM2_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM2_3_TRIM2_3_SHIFT         (0U)
/*! TRIM2_3 - TRIM2_3 */
#define FMUTEST_SOCTRIM2_3_TRIM2_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM2_3_TRIM2_3_SHIFT)) & FMUTEST_SOCTRIM2_3_TRIM2_3_MASK)
/*! @} */

/*! @name SOCTRIM3_0 - SoC Trim Phrase 3 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM3_0_TRIM3_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM3_0_TRIM3_0_SHIFT         (0U)
/*! TRIM3_0 - TRIM3_0 */
#define FMUTEST_SOCTRIM3_0_TRIM3_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM3_0_TRIM3_0_SHIFT)) & FMUTEST_SOCTRIM3_0_TRIM3_0_MASK)
/*! @} */

/*! @name SOCTRIM3_1 - SoC Trim Phrase 3 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM3_1_TRIM3_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM3_1_TRIM3_1_SHIFT         (0U)
/*! TRIM3_1 - TRIM3_1 */
#define FMUTEST_SOCTRIM3_1_TRIM3_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM3_1_TRIM3_1_SHIFT)) & FMUTEST_SOCTRIM3_1_TRIM3_1_MASK)
/*! @} */

/*! @name SOCTRIM3_2 - SoC Trim Phrase 3 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM3_2_TRIM3_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM3_2_TRIM3_2_SHIFT         (0U)
/*! TRIM3_2 - TRIM3_2 */
#define FMUTEST_SOCTRIM3_2_TRIM3_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM3_2_TRIM3_2_SHIFT)) & FMUTEST_SOCTRIM3_2_TRIM3_2_MASK)
/*! @} */

/*! @name SOCTRIM3_3 - SoC Trim Phrase 3 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM3_3_TRIM3_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM3_3_TRIM3_3_SHIFT         (0U)
/*! TRIM3_3 - TRIM3_3 */
#define FMUTEST_SOCTRIM3_3_TRIM3_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM3_3_TRIM3_3_SHIFT)) & FMUTEST_SOCTRIM3_3_TRIM3_3_MASK)
/*! @} */

/*! @name SOCTRIM4_0 - SoC Trim Phrase 4 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM4_0_TRIM4_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM4_0_TRIM4_0_SHIFT         (0U)
/*! TRIM4_0 - TRIM4_0 */
#define FMUTEST_SOCTRIM4_0_TRIM4_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM4_0_TRIM4_0_SHIFT)) & FMUTEST_SOCTRIM4_0_TRIM4_0_MASK)
/*! @} */

/*! @name SOCTRIM4_1 - SoC Trim Phrase 4 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM4_1_TRIM4_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM4_1_TRIM4_1_SHIFT         (0U)
/*! TRIM4_1 - TRIM4_1 */
#define FMUTEST_SOCTRIM4_1_TRIM4_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM4_1_TRIM4_1_SHIFT)) & FMUTEST_SOCTRIM4_1_TRIM4_1_MASK)
/*! @} */

/*! @name SOCTRIM4_2 - SoC Trim Phrase 4 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM4_2_TRIM4_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM4_2_TRIM4_2_SHIFT         (0U)
/*! TRIM4_2 - TRIM4_2 */
#define FMUTEST_SOCTRIM4_2_TRIM4_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM4_2_TRIM4_2_SHIFT)) & FMUTEST_SOCTRIM4_2_TRIM4_2_MASK)
/*! @} */

/*! @name SOCTRIM4_3 - SoC Trim Phrase 4 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM4_3_TRIM4_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM4_3_TRIM4_3_SHIFT         (0U)
/*! TRIM4_3 - TRIM4_3 */
#define FMUTEST_SOCTRIM4_3_TRIM4_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM4_3_TRIM4_3_SHIFT)) & FMUTEST_SOCTRIM4_3_TRIM4_3_MASK)
/*! @} */

/*! @name SOCTRIM5_0 - SoC Trim Phrase 5 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM5_0_TRIM5_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM5_0_TRIM5_0_SHIFT         (0U)
/*! TRIM5_0 - TRIM5_0 */
#define FMUTEST_SOCTRIM5_0_TRIM5_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM5_0_TRIM5_0_SHIFT)) & FMUTEST_SOCTRIM5_0_TRIM5_0_MASK)
/*! @} */

/*! @name SOCTRIM5_1 - SoC Trim Phrase 5 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM5_1_TRIM5_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM5_1_TRIM5_1_SHIFT         (0U)
/*! TRIM5_1 - TRIM5_1 */
#define FMUTEST_SOCTRIM5_1_TRIM5_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM5_1_TRIM5_1_SHIFT)) & FMUTEST_SOCTRIM5_1_TRIM5_1_MASK)
/*! @} */

/*! @name SOCTRIM5_2 - SoC Trim Phrase 5 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM5_2_TRIM5_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM5_2_TRIM5_2_SHIFT         (0U)
/*! TRIM5_2 - TRIM5_2 */
#define FMUTEST_SOCTRIM5_2_TRIM5_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM5_2_TRIM5_2_SHIFT)) & FMUTEST_SOCTRIM5_2_TRIM5_2_MASK)
/*! @} */

/*! @name SOCTRIM5_3 - SoC Trim Phrase 5 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM5_3_TRIM5_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM5_3_TRIM5_3_SHIFT         (0U)
/*! TRIM5_3 - TRIM5_3 */
#define FMUTEST_SOCTRIM5_3_TRIM5_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM5_3_TRIM5_3_SHIFT)) & FMUTEST_SOCTRIM5_3_TRIM5_3_MASK)
/*! @} */

/*! @name SOCTRIM6_0 - SoC Trim Phrase 6 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM6_0_TRIM6_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM6_0_TRIM6_0_SHIFT         (0U)
/*! TRIM6_0 - TRIM6_0 */
#define FMUTEST_SOCTRIM6_0_TRIM6_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM6_0_TRIM6_0_SHIFT)) & FMUTEST_SOCTRIM6_0_TRIM6_0_MASK)
/*! @} */

/*! @name SOCTRIM6_1 - SoC Trim Phrase 6 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM6_1_TRIM6_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM6_1_TRIM6_1_SHIFT         (0U)
/*! TRIM6_1 - TRIM6_1 */
#define FMUTEST_SOCTRIM6_1_TRIM6_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM6_1_TRIM6_1_SHIFT)) & FMUTEST_SOCTRIM6_1_TRIM6_1_MASK)
/*! @} */

/*! @name SOCTRIM6_2 - SoC Trim Phrase 6 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM6_2_TRIM6_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM6_2_TRIM6_2_SHIFT         (0U)
/*! TRIM6_2 - TRIM6_2 */
#define FMUTEST_SOCTRIM6_2_TRIM6_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM6_2_TRIM6_2_SHIFT)) & FMUTEST_SOCTRIM6_2_TRIM6_2_MASK)
/*! @} */

/*! @name SOCTRIM6_3 - SoC Trim Phrase 6 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM6_3_TRIM6_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM6_3_TRIM6_3_SHIFT         (0U)
/*! TRIM6_3 - TRIM6_3 */
#define FMUTEST_SOCTRIM6_3_TRIM6_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM6_3_TRIM6_3_SHIFT)) & FMUTEST_SOCTRIM6_3_TRIM6_3_MASK)
/*! @} */

/*! @name SOCTRIM7_0 - SoC Trim Phrase 7 Word 0 Register */
/*! @{ */

#define FMUTEST_SOCTRIM7_0_TRIM7_0_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM7_0_TRIM7_0_SHIFT         (0U)
/*! TRIM7_0 - TRIM7_0 */
#define FMUTEST_SOCTRIM7_0_TRIM7_0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM7_0_TRIM7_0_SHIFT)) & FMUTEST_SOCTRIM7_0_TRIM7_0_MASK)
/*! @} */

/*! @name SOCTRIM7_1 - SoC Trim Phrase 7 Word 1 Register */
/*! @{ */

#define FMUTEST_SOCTRIM7_1_TRIM7_1_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM7_1_TRIM7_1_SHIFT         (0U)
/*! TRIM7_1 - TRIM7_1 */
#define FMUTEST_SOCTRIM7_1_TRIM7_1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM7_1_TRIM7_1_SHIFT)) & FMUTEST_SOCTRIM7_1_TRIM7_1_MASK)
/*! @} */

/*! @name SOCTRIM7_2 - SoC Trim Phrase 7 Word 2 Register */
/*! @{ */

#define FMUTEST_SOCTRIM7_2_TRIM7_2_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM7_2_TRIM7_2_SHIFT         (0U)
/*! TRIM7_2 - TRIM7_2 */
#define FMUTEST_SOCTRIM7_2_TRIM7_2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM7_2_TRIM7_2_SHIFT)) & FMUTEST_SOCTRIM7_2_TRIM7_2_MASK)
/*! @} */

/*! @name SOCTRIM7_3 - SoC Trim Phrase 7 Word 3 Register */
/*! @{ */

#define FMUTEST_SOCTRIM7_3_TRIM7_3_MASK          (0xFFFFFFFFU)
#define FMUTEST_SOCTRIM7_3_TRIM7_3_SHIFT         (0U)
/*! TRIM7_3 - TRIM7_3 */
#define FMUTEST_SOCTRIM7_3_TRIM7_3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_SOCTRIM7_3_TRIM7_3_SHIFT)) & FMUTEST_SOCTRIM7_3_TRIM7_3_MASK)
/*! @} */

/*! @name R_IP_CONFIG - BIST Configuration Register */
/*! @{ */

#define FMUTEST_R_IP_CONFIG_IPSEL0_MASK          (0x3U)
#define FMUTEST_R_IP_CONFIG_IPSEL0_SHIFT         (0U)
/*! IPSEL0 - Block 0 Select Control
 *  0b00..Unselect block 0
 *  0b01..not used, reserved
 *  0b10..Enable block 0 test, repair off (default)
 *  0b11..Enable block 0 test, repair on
 */
#define FMUTEST_R_IP_CONFIG_IPSEL0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_IPSEL0_SHIFT)) & FMUTEST_R_IP_CONFIG_IPSEL0_MASK)

#define FMUTEST_R_IP_CONFIG_IPSEL1_MASK          (0xCU)
#define FMUTEST_R_IP_CONFIG_IPSEL1_SHIFT         (2U)
/*! IPSEL1 - Block 1 Select Control
 *  0b00..Unselect block 1
 *  0b01..not used, reserved
 *  0b10..Enable block 1 test, repair off (default)
 *  0b11..Enable block 1 test, repair on
 */
#define FMUTEST_R_IP_CONFIG_IPSEL1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_IPSEL1_SHIFT)) & FMUTEST_R_IP_CONFIG_IPSEL1_MASK)

#define FMUTEST_R_IP_CONFIG_BIST_CDIVL_MASK      (0xFF0U)
#define FMUTEST_R_IP_CONFIG_BIST_CDIVL_SHIFT     (4U)
/*! BIST_CDIVL - Clock Divide Scalar for Long Pulse */
#define FMUTEST_R_IP_CONFIG_BIST_CDIVL(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_BIST_CDIVL_SHIFT)) & FMUTEST_R_IP_CONFIG_BIST_CDIVL_MASK)

#define FMUTEST_R_IP_CONFIG_CDIVS_MASK           (0x7000U)
#define FMUTEST_R_IP_CONFIG_CDIVS_SHIFT          (12U)
/*! CDIVS - Number of clock cycles to generate short pulse */
#define FMUTEST_R_IP_CONFIG_CDIVS(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_CDIVS_SHIFT)) & FMUTEST_R_IP_CONFIG_CDIVS_MASK)

#define FMUTEST_R_IP_CONFIG_BIST_TVFY_MASK       (0xF8000U)
#define FMUTEST_R_IP_CONFIG_BIST_TVFY_SHIFT      (15U)
/*! BIST_TVFY - Timer adjust for verify */
#define FMUTEST_R_IP_CONFIG_BIST_TVFY(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_BIST_TVFY_SHIFT)) & FMUTEST_R_IP_CONFIG_BIST_TVFY_MASK)

#define FMUTEST_R_IP_CONFIG_TSTCTL_MASK          (0x300000U)
#define FMUTEST_R_IP_CONFIG_TSTCTL_SHIFT         (20U)
/*! TSTCTL - BIST self-test control
 *  0b00..Default, disable both BIST self-test and MISR
 *  0b01..Enable BIST self-test mode DOUT from macro will be forced to '0', and disable MISR.
 *  0b10..Enable MISR
 *  0b11..Enable both BIST self-test mode and MISR
 */
#define FMUTEST_R_IP_CONFIG_TSTCTL(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_TSTCTL_SHIFT)) & FMUTEST_R_IP_CONFIG_TSTCTL_MASK)

#define FMUTEST_R_IP_CONFIG_DBGCTL_MASK          (0x400000U)
#define FMUTEST_R_IP_CONFIG_DBGCTL_SHIFT         (22U)
/*! DBGCTL - Debug feature control
 *  0b0..Default
 *  0b1..Enable debug feature to collect failure address and data.
 */
#define FMUTEST_R_IP_CONFIG_DBGCTL(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_DBGCTL_SHIFT)) & FMUTEST_R_IP_CONFIG_DBGCTL_MASK)

#define FMUTEST_R_IP_CONFIG_BIST_CLK_SEL_MASK    (0x800000U)
#define FMUTEST_R_IP_CONFIG_BIST_CLK_SEL_SHIFT   (23U)
/*! BIST_CLK_SEL - BIST Clock Select */
#define FMUTEST_R_IP_CONFIG_BIST_CLK_SEL(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_BIST_CLK_SEL_SHIFT)) & FMUTEST_R_IP_CONFIG_BIST_CLK_SEL_MASK)

#define FMUTEST_R_IP_CONFIG_SMWTST_MASK          (0x3000000U)
#define FMUTEST_R_IP_CONFIG_SMWTST_SHIFT         (24U)
/*! SMWTST - SMWR DOUT Function Control
 *  0b00..Default
 *  0b01..Enable SMWR self-test mode, DOUT from macro will be forced to all 0
 *  0b10..Enable SMWR self-test mode, DOUT from macro will be forced to all 1
 *  0b11..Reserved (unused)
 */
#define FMUTEST_R_IP_CONFIG_SMWTST(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_SMWTST_SHIFT)) & FMUTEST_R_IP_CONFIG_SMWTST_MASK)

#define FMUTEST_R_IP_CONFIG_ECCEN_MASK           (0x4000000U)
#define FMUTEST_R_IP_CONFIG_ECCEN_SHIFT          (26U)
/*! ECCEN - BIST ECC Control
 *  0b0..Default mode (no ECC encode or decode)
 *  0b1..Enable ECC encode/decode
 */
#define FMUTEST_R_IP_CONFIG_ECCEN(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_IP_CONFIG_ECCEN_SHIFT)) & FMUTEST_R_IP_CONFIG_ECCEN_MASK)
/*! @} */

/*! @name R_TESTCODE - BIST Test Code Register */
/*! @{ */

#define FMUTEST_R_TESTCODE_TESTCODE_MASK         (0x3FU)
#define FMUTEST_R_TESTCODE_TESTCODE_SHIFT        (0U)
/*! TESTCODE - Used to store test code information before running TMR-RST/TMRSET BIST command */
#define FMUTEST_R_TESTCODE_TESTCODE(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TESTCODE_TESTCODE_SHIFT)) & FMUTEST_R_TESTCODE_TESTCODE_MASK)
/*! @} */

/*! @name R_DFT_CTRL - BIST DFT Control Register */
/*! @{ */

#define FMUTEST_R_DFT_CTRL_DFT_XADR_MASK         (0xFU)
#define FMUTEST_R_DFT_CTRL_DFT_XADR_SHIFT        (0U)
/*! DFT_XADR - DFT XADR Pattern
 *  0b0000..XADR fixed, no change at all
 *  0b0001..XADR increased by 1 after row. For READ operation, XADR increases by 1 after reading the last word of
 *          row. For PROG operation, XADR increases by 1 after NVSTR falls.
 *  0b0010..XADR increased for diagonal. For PROG-DIAGONAL operation, XADR is increased to create diagonal pattern.
 *  0b0011..XADR increased by sector. During ERASE operation, XADR increased by number of rows in a sector when NVSTR falls.
 *  0b0100..XADR inversed. XADR is inversed after reading one word or after programming one row when NVSTR falls.
 *  0b0101..XADR increased by 2 after row. For READ operation, XADR is increased by 2 after reading the last word
 *          of a row. For PROG operation, XADR is increased by 2 when NVSTR falls.
 *  0b0110..XADR[0] inversed. XADR[0] is inversed after reading one word or after programming one row when NVSTR falls.
 *  0b0111..XADR increased by 1. For READ operations only, XADR increased by 1 after each read cycle.
 *  0b1000..XADR decreased by 1 after row. For READ operations only, XADR is decreased by 1 after YADR decreases to 0.
 *  0b1001..XADR decreased by 1. For READ operations only, XADR is decreased by 1 after each read cycle.
 */
#define FMUTEST_R_DFT_CTRL_DFT_XADR(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_DFT_XADR_SHIFT)) & FMUTEST_R_DFT_CTRL_DFT_XADR_MASK)

#define FMUTEST_R_DFT_CTRL_DFT_YADR_MASK         (0xF0U)
#define FMUTEST_R_DFT_CTRL_DFT_YADR_SHIFT        (4U)
/*! DFT_YADR - DFT YADR Pattern
 *  0b0000..YADR fixed, no change at all
 *  0b0001..YADR for ICKBD. For PROG and READ operations, YADR changed to generate inverse checkerboard pattern.
 *  0b0010..YADR for CKBD. For PROG and READ operations, YADR changed to generate checkerboard pattern.
 *  0b0011..YADR increased by 1. For READ operations, YADR increased by 1 after each read cycle. For PROG
 *          operations, YADR increased by 1 after YE falls.
 *  0b0100..YADR increased for diagonal. For PROG-DIAGONAL operation, YADR is increased to create diagonal pattern.
 *  0b0101..YADR inversed. YADR is inversed after reading one word or after programming one word when YE falls.
 *  0b0110..YADR[0] inversed. YADR[0] is inversed after reading one word or after programming one word when YE falls.
 *  0b0111..YADR increased by 1 after last row. For READ operations only, YADR is increased by 1 after XADR reaches last row.
 *  0b1000..YADR decreased by 1. For READ operations only, YADR is decreased by 1 after each read cycle.
 *  0b1001..YADR decreased by 1 after first row. For READ operations only, YADR is decreased by 1 after XADR decreases to 0.
 */
#define FMUTEST_R_DFT_CTRL_DFT_YADR(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_DFT_YADR_SHIFT)) & FMUTEST_R_DFT_CTRL_DFT_YADR_MASK)

#define FMUTEST_R_DFT_CTRL_DFT_DATA_MASK         (0xF00U)
#define FMUTEST_R_DFT_CTRL_DFT_DATA_SHIFT        (8U)
/*! DFT_DATA - DFT Data Pattern
 *  0b0000..CKBD pattern. For READ operations only, compare DOUT with checkerboard data pattern for each read cycle.
 *  0b0001..ICKBD pattern. For READ operations only, compare DOUT with inverse checkerboard data pattern for each read cycle.
 *  0b0010..Diagonal pattern. Used for READ operations only, compare DOUT to diagonal pattern.
 *  0b0011..Fixed data pattern. For READ operations, comparison to DOUT for selected groups; refer to
 *          R_ADR_CTRL[GRPSEL] for modules with multiple groups.
 *  0b0100..Random data pattern which will be generated based on the initial seed set in R_DATA; for READ
 *          operations, used for DOUT comparison of selected groups. For PROG operations, used to control DIN of selected
 *          groups.
 *  0b0101..DOUT based pattern. For READ operations only, DOUT of selected group will be latched in R_DATA. If
 *          more than one group is selected in R_ADR_CTRL[GRPSEL], the group with the lower index will be latched.
 *  0b0110..R_DATA based pattern. For READ operations, expected DOUT value of selected groups equals to R_DATA
 *          when XADR[0]==YADR[0] or ~R_DATA when XADR[0]!=YADR[0]. For PROG operations, DIN of selected groups equals
 *          R_DATA when XADR[0]==YADR[0] or ~R_DATA when XADR[0]!=YADR[0].
 *  0b0111..SCAN-IO pattern. For READ operations, control expected DOUT value of selected groups to SCAN-IO data
 *          pattern. For PROG operations, control DIN of selected groups to SCAN-IO data pattern.
 *  0b1000..REPAIR set. For PROG operation to IFR1(7,1) and IFR1(7,2), R_REPAIR0_0 and R_REPAIR0_1 or R_REPAIR1_0
 *          and R_REPAIR1_1 will control DIN. For READ operation on IFR1(7,1) and IFR1(7,2), DOUT will be compared
 *          against R_REPAIR0_0 and R_REPAIR0_1 or R_REPAIR1_0 andR_REPAIR1_1. When this option is selected, only
 *          one flash block can be selected.
 *  0b1001..REPAIR load. For READ operation only, DOUT from IFR1(7,1) and IFR1(7,2) is loaded to R_REPAIR0 and R_REPAIR1.
 */
#define FMUTEST_R_DFT_CTRL_DFT_DATA(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_DFT_DATA_SHIFT)) & FMUTEST_R_DFT_CTRL_DFT_DATA_MASK)

#define FMUTEST_R_DFT_CTRL_CMP_MASK_MASK         (0x3000U)
#define FMUTEST_R_DFT_CTRL_CMP_MASK_SHIFT        (12U)
/*! CMP_MASK - Data Compare Mask
 *  0b00..Expected data is compared to DOUT
 *  0b01..Expected data (only 0s are considered) are compared to DOUT
 *  0b10..Expected data (only 1s are considered) are compared to DOUT
 */
#define FMUTEST_R_DFT_CTRL_CMP_MASK(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_CMP_MASK_SHIFT)) & FMUTEST_R_DFT_CTRL_CMP_MASK_MASK)

#define FMUTEST_R_DFT_CTRL_DFT_DATA_SRC_MASK     (0x4000U)
#define FMUTEST_R_DFT_CTRL_DFT_DATA_SRC_SHIFT    (14U)
/*! DFT_DATA_SRC - DFT Data Source
 *  0b0..{R_DATA_CTRL0,R_DATA_CTRL_EX[2:0],R_DATA_CTRL0,R_DATA_CTRL_EX[2:0],R_DATA_CTRL0,R_DATA_CTRL_EX[2:0],R_DATA_CTRL0} is used
 *  0b1..{R_DATA_CTRL3,R_DATA_CTRL2_EX[2:0],R_DATA_CTRL2,R_DATA_CTRL1_EX[2:0],R_DATA_CTRL1,R_DATA_CTRL_EX[2:0],R_DATA_CTRL0} is used
 */
#define FMUTEST_R_DFT_CTRL_DFT_DATA_SRC(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DFT_CTRL_DFT_DATA_SRC_SHIFT)) & FMUTEST_R_DFT_CTRL_DFT_DATA_SRC_MASK)
/*! @} */

/*! @name R_ADR_CTRL - BIST Address Control Register */
/*! @{ */

#define FMUTEST_R_ADR_CTRL_GRPSEL_MASK           (0xFU)
#define FMUTEST_R_ADR_CTRL_GRPSEL_SHIFT          (0U)
/*! GRPSEL - Data Group Select
 *  0b0000..Select no data
 *  0b0001..Select data slice [34:0]
 *  0b0010..Select data slice [69:35]
 *  0b0100..Select data slice [104:70]
 *  0b1000..Select data slice [136:105]
 *  0b1111..Select data [136:0]
 */
#define FMUTEST_R_ADR_CTRL_GRPSEL(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_CTRL_GRPSEL_SHIFT)) & FMUTEST_R_ADR_CTRL_GRPSEL_MASK)

#define FMUTEST_R_ADR_CTRL_XADR_MASK             (0xFFF0U)
#define FMUTEST_R_ADR_CTRL_XADR_SHIFT            (4U)
/*! XADR - BIST XADR */
#define FMUTEST_R_ADR_CTRL_XADR(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_CTRL_XADR_SHIFT)) & FMUTEST_R_ADR_CTRL_XADR_MASK)

#define FMUTEST_R_ADR_CTRL_YADR_MASK             (0x1F0000U)
#define FMUTEST_R_ADR_CTRL_YADR_SHIFT            (16U)
/*! YADR - BIST YADR */
#define FMUTEST_R_ADR_CTRL_YADR(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_CTRL_YADR_SHIFT)) & FMUTEST_R_ADR_CTRL_YADR_MASK)

#define FMUTEST_R_ADR_CTRL_PROG_ATTR_MASK        (0xE00000U)
#define FMUTEST_R_ADR_CTRL_PROG_ATTR_SHIFT       (21U)
/*! PROG_ATTR - Program Attribute
 *  0b000..One YE pulse will program one data slice group
 *  0b001..One YE pulse will program two data slice groups
 *  0b010..One YE pulse will program three data slice groups (reserved)
 *  0b011..One YE pulse will program four data slice groups
 *  0b100..One YE pulse will program five data slice groups (reserved)
 *  0b101..One YE pulse will program six data slice groups (reserved)
 *  0b110..One YE pulse will program seven data slice groups (reserved)
 *  0b111..One YE pulse will program eight data slice groups (reserved)
 */
#define FMUTEST_R_ADR_CTRL_PROG_ATTR(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_CTRL_PROG_ATTR_SHIFT)) & FMUTEST_R_ADR_CTRL_PROG_ATTR_MASK)
/*! @} */

/*! @name R_DATA_CTRL0 - BIST Data Control 0 Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL0_DATA0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_DATA_CTRL0_DATA0_SHIFT         (0U)
/*! DATA0 - BIST Data 0 Low */
#define FMUTEST_R_DATA_CTRL0_DATA0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL0_DATA0_SHIFT)) & FMUTEST_R_DATA_CTRL0_DATA0_MASK)
/*! @} */

/*! @name R_PIN_CTRL - BIST Pin Control Register */
/*! @{ */

#define FMUTEST_R_PIN_CTRL_MAS1_MASK             (0x1U)
#define FMUTEST_R_PIN_CTRL_MAS1_SHIFT            (0U)
/*! MAS1 - Mass Erase */
#define FMUTEST_R_PIN_CTRL_MAS1(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_MAS1_SHIFT)) & FMUTEST_R_PIN_CTRL_MAS1_MASK)

#define FMUTEST_R_PIN_CTRL_IFREN_MASK            (0x2U)
#define FMUTEST_R_PIN_CTRL_IFREN_SHIFT           (1U)
/*! IFREN - IFR Enable */
#define FMUTEST_R_PIN_CTRL_IFREN(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_IFREN_SHIFT)) & FMUTEST_R_PIN_CTRL_IFREN_MASK)

#define FMUTEST_R_PIN_CTRL_IFREN1_MASK           (0x4U)
#define FMUTEST_R_PIN_CTRL_IFREN1_SHIFT          (2U)
/*! IFREN1 - IFR1 Enable */
#define FMUTEST_R_PIN_CTRL_IFREN1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_IFREN1_SHIFT)) & FMUTEST_R_PIN_CTRL_IFREN1_MASK)

#define FMUTEST_R_PIN_CTRL_REDEN_MASK            (0x8U)
#define FMUTEST_R_PIN_CTRL_REDEN_SHIFT           (3U)
/*! REDEN - Redundancy Block Enable */
#define FMUTEST_R_PIN_CTRL_REDEN(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_REDEN_SHIFT)) & FMUTEST_R_PIN_CTRL_REDEN_MASK)

#define FMUTEST_R_PIN_CTRL_LVE_MASK              (0x10U)
#define FMUTEST_R_PIN_CTRL_LVE_SHIFT             (4U)
/*! LVE - Low Voltage Enable */
#define FMUTEST_R_PIN_CTRL_LVE(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_LVE_SHIFT)) & FMUTEST_R_PIN_CTRL_LVE_MASK)

#define FMUTEST_R_PIN_CTRL_PV_MASK               (0x20U)
#define FMUTEST_R_PIN_CTRL_PV_SHIFT              (5U)
/*! PV - Program Verify Enable */
#define FMUTEST_R_PIN_CTRL_PV(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_PV_SHIFT)) & FMUTEST_R_PIN_CTRL_PV_MASK)

#define FMUTEST_R_PIN_CTRL_EV_MASK               (0x40U)
#define FMUTEST_R_PIN_CTRL_EV_SHIFT              (6U)
/*! EV - Erase Verify Enable */
#define FMUTEST_R_PIN_CTRL_EV(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_EV_SHIFT)) & FMUTEST_R_PIN_CTRL_EV_MASK)

#define FMUTEST_R_PIN_CTRL_WIPGM_MASK            (0x180U)
#define FMUTEST_R_PIN_CTRL_WIPGM_SHIFT           (7U)
/*! WIPGM - Program Current */
#define FMUTEST_R_PIN_CTRL_WIPGM(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_WIPGM_SHIFT)) & FMUTEST_R_PIN_CTRL_WIPGM_MASK)

#define FMUTEST_R_PIN_CTRL_WHV_MASK              (0x1E00U)
#define FMUTEST_R_PIN_CTRL_WHV_SHIFT             (9U)
/*! WHV - High Voltage Level */
#define FMUTEST_R_PIN_CTRL_WHV(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_WHV_SHIFT)) & FMUTEST_R_PIN_CTRL_WHV_MASK)

#define FMUTEST_R_PIN_CTRL_WMV_MASK              (0xE000U)
#define FMUTEST_R_PIN_CTRL_WMV_SHIFT             (13U)
/*! WMV - Medium Voltage Level */
#define FMUTEST_R_PIN_CTRL_WMV(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_WMV_SHIFT)) & FMUTEST_R_PIN_CTRL_WMV_MASK)

#define FMUTEST_R_PIN_CTRL_XE_MASK               (0x10000U)
#define FMUTEST_R_PIN_CTRL_XE_SHIFT              (16U)
/*! XE - X Address Enable */
#define FMUTEST_R_PIN_CTRL_XE(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_XE_SHIFT)) & FMUTEST_R_PIN_CTRL_XE_MASK)

#define FMUTEST_R_PIN_CTRL_YE_MASK               (0x20000U)
#define FMUTEST_R_PIN_CTRL_YE_SHIFT              (17U)
/*! YE - Y Address Enable */
#define FMUTEST_R_PIN_CTRL_YE(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_YE_SHIFT)) & FMUTEST_R_PIN_CTRL_YE_MASK)

#define FMUTEST_R_PIN_CTRL_SE_MASK               (0x40000U)
#define FMUTEST_R_PIN_CTRL_SE_SHIFT              (18U)
/*! SE - Sense Amp Enable */
#define FMUTEST_R_PIN_CTRL_SE(x)                 (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_SE_SHIFT)) & FMUTEST_R_PIN_CTRL_SE_MASK)

#define FMUTEST_R_PIN_CTRL_ERASE_MASK            (0x80000U)
#define FMUTEST_R_PIN_CTRL_ERASE_SHIFT           (19U)
/*! ERASE - Erase Mode */
#define FMUTEST_R_PIN_CTRL_ERASE(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_ERASE_SHIFT)) & FMUTEST_R_PIN_CTRL_ERASE_MASK)

#define FMUTEST_R_PIN_CTRL_PROG_MASK             (0x100000U)
#define FMUTEST_R_PIN_CTRL_PROG_SHIFT            (20U)
/*! PROG - Program Mode */
#define FMUTEST_R_PIN_CTRL_PROG(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_PROG_SHIFT)) & FMUTEST_R_PIN_CTRL_PROG_MASK)

#define FMUTEST_R_PIN_CTRL_NVSTR_MASK            (0x200000U)
#define FMUTEST_R_PIN_CTRL_NVSTR_SHIFT           (21U)
/*! NVSTR - NVM Store */
#define FMUTEST_R_PIN_CTRL_NVSTR(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_NVSTR_SHIFT)) & FMUTEST_R_PIN_CTRL_NVSTR_MASK)

#define FMUTEST_R_PIN_CTRL_SLM_MASK              (0x400000U)
#define FMUTEST_R_PIN_CTRL_SLM_SHIFT             (22U)
/*! SLM - Sleep Mode Enable */
#define FMUTEST_R_PIN_CTRL_SLM(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_SLM_SHIFT)) & FMUTEST_R_PIN_CTRL_SLM_MASK)

#define FMUTEST_R_PIN_CTRL_RECALL_MASK           (0x800000U)
#define FMUTEST_R_PIN_CTRL_RECALL_SHIFT          (23U)
/*! RECALL - Recall Trim Code */
#define FMUTEST_R_PIN_CTRL_RECALL(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_RECALL_SHIFT)) & FMUTEST_R_PIN_CTRL_RECALL_MASK)

#define FMUTEST_R_PIN_CTRL_HEM_MASK              (0x1000000U)
#define FMUTEST_R_PIN_CTRL_HEM_SHIFT             (24U)
/*! HEM - HEM Control */
#define FMUTEST_R_PIN_CTRL_HEM(x)                (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_PIN_CTRL_HEM_SHIFT)) & FMUTEST_R_PIN_CTRL_HEM_MASK)
/*! @} */

/*! @name R_CNT_LOOP_CTRL - BIST Loop Count Control Register */
/*! @{ */

#define FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT_MASK     (0xFFFU)
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT_SHIFT    (0U)
/*! LOOPCNT - Loop Count Control */
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT_SHIFT)) & FMUTEST_R_CNT_LOOP_CTRL_LOOPCNT_MASK)

#define FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT_MASK     (0x7000U)
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT_SHIFT    (12U)
/*! LOOPOPT - Loop Option
 *  0b000..Loop is disabled; selected BIST operation is run once
 *  0b001..Loop is enabled; XADR increments by 1 XADR increments by 1 for each new loop. Stops when total loop count meets LOOPCNT+1.
 *  0b010..Loop is enabled; YADR increments by 1 YADR increments by 1 for each new loop. Stops when total loop count meets LOOPCNT+1.
 *  0b011..Loop is enabled; XADR increments by 2 XADR increments by 2 for each new loop. Stops when total loop count meets LOOPCNT+1.
 *  0b100..Loop is enabled; XADR increments by sector XADR increments by 16 for each new loop. Stops when total loop count meets LOOPCNT+1.
 */
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT_SHIFT)) & FMUTEST_R_CNT_LOOP_CTRL_LOOPOPT_MASK)

#define FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT_MASK    (0x38000U)
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT_SHIFT   (15U)
/*! LOOPUNIT - Loop Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT_SHIFT)) & FMUTEST_R_CNT_LOOP_CTRL_LOOPUNIT_MASK)

#define FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY_MASK     (0x1FC0000U)
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY_SHIFT    (18U)
/*! LOOPDLY - Loop Time Delay Scalar */
#define FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY_SHIFT)) & FMUTEST_R_CNT_LOOP_CTRL_LOOPDLY_MASK)
/*! @} */

/*! @name R_TIMER_CTRL - BIST Timer Control Register */
/*! @{ */

#define FMUTEST_R_TIMER_CTRL_TNVSUNIT_MASK       (0x7U)
#define FMUTEST_R_TIMER_CTRL_TNVSUNIT_SHIFT      (0U)
/*! TNVSUNIT - Tnvs Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TNVSUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TNVSUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TNVSUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TNVSDLY_MASK        (0x78U)
#define FMUTEST_R_TIMER_CTRL_TNVSDLY_SHIFT       (3U)
/*! TNVSDLY - Tnvs Time Delay Scalar */
#define FMUTEST_R_TIMER_CTRL_TNVSDLY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TNVSDLY_SHIFT)) & FMUTEST_R_TIMER_CTRL_TNVSDLY_MASK)

#define FMUTEST_R_TIMER_CTRL_TNVHUNIT_MASK       (0x380U)
#define FMUTEST_R_TIMER_CTRL_TNVHUNIT_SHIFT      (7U)
/*! TNVHUNIT - Tnvh Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TNVHUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TNVHUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TNVHUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TNVHDLY_MASK        (0x3C00U)
#define FMUTEST_R_TIMER_CTRL_TNVHDLY_SHIFT       (10U)
/*! TNVHDLY - Tnvh Time Delay Scalar */
#define FMUTEST_R_TIMER_CTRL_TNVHDLY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TNVHDLY_SHIFT)) & FMUTEST_R_TIMER_CTRL_TNVHDLY_MASK)

#define FMUTEST_R_TIMER_CTRL_TPGSUNIT_MASK       (0x1C000U)
#define FMUTEST_R_TIMER_CTRL_TPGSUNIT_SHIFT      (14U)
/*! TPGSUNIT - Tpgs Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TPGSUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TPGSUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TPGSUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TPGSDLY_MASK        (0x1E0000U)
#define FMUTEST_R_TIMER_CTRL_TPGSDLY_SHIFT       (17U)
/*! TPGSDLY - Tpgs Time Delay Scalar */
#define FMUTEST_R_TIMER_CTRL_TPGSDLY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TPGSDLY_SHIFT)) & FMUTEST_R_TIMER_CTRL_TPGSDLY_MASK)

#define FMUTEST_R_TIMER_CTRL_TRCVUNIT_MASK       (0xE00000U)
#define FMUTEST_R_TIMER_CTRL_TRCVUNIT_SHIFT      (21U)
/*! TRCVUNIT - Trcv Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TRCVUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TRCVUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TRCVUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TRCVDLY_MASK        (0xF000000U)
#define FMUTEST_R_TIMER_CTRL_TRCVDLY_SHIFT       (24U)
/*! TRCVDLY - Trcv Time Delay Scalar */
#define FMUTEST_R_TIMER_CTRL_TRCVDLY(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TRCVDLY_SHIFT)) & FMUTEST_R_TIMER_CTRL_TRCVDLY_MASK)

#define FMUTEST_R_TIMER_CTRL_TLVSUNIT_MASK       (0x70000000U)
#define FMUTEST_R_TIMER_CTRL_TLVSUNIT_SHIFT      (28U)
/*! TLVSUNIT - Tlvs Time Unit
 *  0b000..Clock cycles
 *  0b001..0.5 usec
 *  0b010..1 usec
 *  0b011..10 usec
 *  0b100..100 usec
 *  0b101..1 msec
 *  0b110..10 msec
 *  0b111..100 msec
 */
#define FMUTEST_R_TIMER_CTRL_TLVSUNIT(x)         (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TLVSUNIT_SHIFT)) & FMUTEST_R_TIMER_CTRL_TLVSUNIT_MASK)

#define FMUTEST_R_TIMER_CTRL_TLVSDLY_L_MASK      (0x80000000U)
#define FMUTEST_R_TIMER_CTRL_TLVSDLY_L_SHIFT     (31U)
/*! TLVSDLY_L - Tlvs Time Delay Scalar Low */
#define FMUTEST_R_TIMER_CTRL_TLVSDLY_L(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_TLVSDLY_L_SHIFT)) & FMUTEST_R_TIMER_CTRL_TLVSDLY_L_MASK)
/*! @} */

/*! @name R_TEST_CTRL - BIST Test Control Register */
/*! @{ */

#define FMUTEST_R_TEST_CTRL_BUSY_MASK            (0x1U)
#define FMUTEST_R_TEST_CTRL_BUSY_SHIFT           (0U)
/*! BUSY - BIST Busy Status
 *  0b0..BIST is idle
 *  0b1..BIST is busy
 */
#define FMUTEST_R_TEST_CTRL_BUSY(x)              (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_BUSY_SHIFT)) & FMUTEST_R_TEST_CTRL_BUSY_MASK)

#define FMUTEST_R_TEST_CTRL_DEBUG_MASK           (0x2U)
#define FMUTEST_R_TEST_CTRL_DEBUG_SHIFT          (1U)
/*! DEBUG - BIST Debug Status */
#define FMUTEST_R_TEST_CTRL_DEBUG(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_DEBUG_SHIFT)) & FMUTEST_R_TEST_CTRL_DEBUG_MASK)

#define FMUTEST_R_TEST_CTRL_STATUS0_MASK         (0x4U)
#define FMUTEST_R_TEST_CTRL_STATUS0_SHIFT        (2U)
/*! STATUS0 - BIST Status 0
 *  0b0..BIST test passed on flash block 0
 *  0b1..BIST test failed on flash block 0
 */
#define FMUTEST_R_TEST_CTRL_STATUS0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_STATUS0_SHIFT)) & FMUTEST_R_TEST_CTRL_STATUS0_MASK)

#define FMUTEST_R_TEST_CTRL_STATUS1_MASK         (0x8U)
#define FMUTEST_R_TEST_CTRL_STATUS1_SHIFT        (3U)
/*! STATUS1 - BIST status 1
 *  0b0..BIST test passed on flash block 1
 *  0b1..BIST test failed on flash block 1
 */
#define FMUTEST_R_TEST_CTRL_STATUS1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_STATUS1_SHIFT)) & FMUTEST_R_TEST_CTRL_STATUS1_MASK)

#define FMUTEST_R_TEST_CTRL_DEBUGRUN_MASK        (0x10U)
#define FMUTEST_R_TEST_CTRL_DEBUGRUN_SHIFT       (4U)
/*! DEBUGRUN - BIST Continue Debug Run */
#define FMUTEST_R_TEST_CTRL_DEBUGRUN(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_DEBUGRUN_SHIFT)) & FMUTEST_R_TEST_CTRL_DEBUGRUN_MASK)

#define FMUTEST_R_TEST_CTRL_STARTRUN_MASK        (0x20U)
#define FMUTEST_R_TEST_CTRL_STARTRUN_SHIFT       (5U)
/*! STARTRUN - Run New BIST Operation */
#define FMUTEST_R_TEST_CTRL_STARTRUN(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_STARTRUN_SHIFT)) & FMUTEST_R_TEST_CTRL_STARTRUN_MASK)

#define FMUTEST_R_TEST_CTRL_CMDINDEX_MASK        (0xFFC0U)
#define FMUTEST_R_TEST_CTRL_CMDINDEX_SHIFT       (6U)
/*! CMDINDEX - BIST Command Index (code) */
#define FMUTEST_R_TEST_CTRL_CMDINDEX(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_CMDINDEX_SHIFT)) & FMUTEST_R_TEST_CTRL_CMDINDEX_MASK)

#define FMUTEST_R_TEST_CTRL_DISABLE_IP1_MASK     (0x10000U)
#define FMUTEST_R_TEST_CTRL_DISABLE_IP1_SHIFT    (16U)
/*! DISABLE_IP1 - BIST Disable IP1 */
#define FMUTEST_R_TEST_CTRL_DISABLE_IP1(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TEST_CTRL_DISABLE_IP1_SHIFT)) & FMUTEST_R_TEST_CTRL_DISABLE_IP1_MASK)
/*! @} */

/*! @name R_ABORT_LOOP - BIST Abort Loop Register */
/*! @{ */

#define FMUTEST_R_ABORT_LOOP_ABORT_LOOP_MASK     (0x1U)
#define FMUTEST_R_ABORT_LOOP_ABORT_LOOP_SHIFT    (0U)
/*! ABORT_LOOP - Abort Loop
 *  0b0..No effect
 *  0b1..Abort BIST loop commands and force the loop counter to return to 0x0
 */
#define FMUTEST_R_ABORT_LOOP_ABORT_LOOP(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ABORT_LOOP_ABORT_LOOP_SHIFT)) & FMUTEST_R_ABORT_LOOP_ABORT_LOOP_MASK)
/*! @} */

/*! @name R_ADR_QUERY - BIST Address Query Register */
/*! @{ */

#define FMUTEST_R_ADR_QUERY_YADRFAIL_MASK        (0x1FU)
#define FMUTEST_R_ADR_QUERY_YADRFAIL_SHIFT       (0U)
/*! YADRFAIL - Failing YADR */
#define FMUTEST_R_ADR_QUERY_YADRFAIL(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_QUERY_YADRFAIL_SHIFT)) & FMUTEST_R_ADR_QUERY_YADRFAIL_MASK)

#define FMUTEST_R_ADR_QUERY_XADRFAIL_MASK        (0x1FFE0U)
#define FMUTEST_R_ADR_QUERY_XADRFAIL_SHIFT       (5U)
/*! XADRFAIL - Failing XADR */
#define FMUTEST_R_ADR_QUERY_XADRFAIL(x)          (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_ADR_QUERY_XADRFAIL_SHIFT)) & FMUTEST_R_ADR_QUERY_XADRFAIL_MASK)
/*! @} */

/*! @name R_DOUT_QUERY0 - BIST DOUT Query 0 Register */
/*! @{ */

#define FMUTEST_R_DOUT_QUERY0_DOUTFAIL_MASK      (0xFFFFFFFFU)
#define FMUTEST_R_DOUT_QUERY0_DOUTFAIL_SHIFT     (0U)
/*! DOUTFAIL - Failing DOUT Low */
#define FMUTEST_R_DOUT_QUERY0_DOUTFAIL(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DOUT_QUERY0_DOUTFAIL_SHIFT)) & FMUTEST_R_DOUT_QUERY0_DOUTFAIL_MASK)
/*! @} */

/*! @name R_SMW_QUERY - BIST SMW Query Register */
/*! @{ */

#define FMUTEST_R_SMW_QUERY_SMWLOOP_MASK         (0x3FFU)
#define FMUTEST_R_SMW_QUERY_SMWLOOP_SHIFT        (0U)
/*! SMWLOOP - SMW Total Loop Count */
#define FMUTEST_R_SMW_QUERY_SMWLOOP(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_QUERY_SMWLOOP_SHIFT)) & FMUTEST_R_SMW_QUERY_SMWLOOP_MASK)

#define FMUTEST_R_SMW_QUERY_SMWLAST_MASK         (0x7FC00U)
#define FMUTEST_R_SMW_QUERY_SMWLAST_SHIFT        (10U)
/*! SMWLAST - SMW Last Voltage Setting */
#define FMUTEST_R_SMW_QUERY_SMWLAST(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_QUERY_SMWLAST_SHIFT)) & FMUTEST_R_SMW_QUERY_SMWLAST_MASK)
/*! @} */

/*! @name R_SMW_SETTING0 - BIST SMW Setting 0 Register */
/*! @{ */

#define FMUTEST_R_SMW_SETTING0_SMWPARM0_MASK     (0x7FFFFFFFU)
#define FMUTEST_R_SMW_SETTING0_SMWPARM0_SHIFT    (0U)
/*! SMWPARM0 - SMW Parameter Set 0 */
#define FMUTEST_R_SMW_SETTING0_SMWPARM0(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_SETTING0_SMWPARM0_SHIFT)) & FMUTEST_R_SMW_SETTING0_SMWPARM0_MASK)
/*! @} */

/*! @name R_SMW_SETTING1 - BIST SMW Setting 1 Register */
/*! @{ */

#define FMUTEST_R_SMW_SETTING1_SMWPARM1_MASK     (0xFFFFFFFU)
#define FMUTEST_R_SMW_SETTING1_SMWPARM1_SHIFT    (0U)
/*! SMWPARM1 - SMW Parameter Set 1 */
#define FMUTEST_R_SMW_SETTING1_SMWPARM1(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_SETTING1_SMWPARM1_SHIFT)) & FMUTEST_R_SMW_SETTING1_SMWPARM1_MASK)
/*! @} */

/*! @name R_SMP_WHV0 - BIST SMP WHV Setting 0 Register */
/*! @{ */

#define FMUTEST_R_SMP_WHV0_SMPWHV0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_SMP_WHV0_SMPWHV0_SHIFT         (0U)
/*! SMPWHV0 - SMP WHV Parameter Set 0 */
#define FMUTEST_R_SMP_WHV0_SMPWHV0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMP_WHV0_SMPWHV0_SHIFT)) & FMUTEST_R_SMP_WHV0_SMPWHV0_MASK)
/*! @} */

/*! @name R_SMP_WHV1 - BIST SMP WHV Setting 1 Register */
/*! @{ */

#define FMUTEST_R_SMP_WHV1_SMPWHV1_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_SMP_WHV1_SMPWHV1_SHIFT         (0U)
/*! SMPWHV1 - SMP WHV Parameter Set 1 */
#define FMUTEST_R_SMP_WHV1_SMPWHV1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMP_WHV1_SMPWHV1_SHIFT)) & FMUTEST_R_SMP_WHV1_SMPWHV1_MASK)
/*! @} */

/*! @name R_SME_WHV0 - BIST SME WHV Setting 0 Register */
/*! @{ */

#define FMUTEST_R_SME_WHV0_SMEWHV0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_SME_WHV0_SMEWHV0_SHIFT         (0U)
/*! SMEWHV0 - SME WHV Parameter Set 0 */
#define FMUTEST_R_SME_WHV0_SMEWHV0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SME_WHV0_SMEWHV0_SHIFT)) & FMUTEST_R_SME_WHV0_SMEWHV0_MASK)
/*! @} */

/*! @name R_SME_WHV1 - BIST SME WHV Setting 1 Register */
/*! @{ */

#define FMUTEST_R_SME_WHV1_SMEWHV1_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_SME_WHV1_SMEWHV1_SHIFT         (0U)
/*! SMEWHV1 - SME WHV Parameter Set 1 */
#define FMUTEST_R_SME_WHV1_SMEWHV1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SME_WHV1_SMEWHV1_SHIFT)) & FMUTEST_R_SME_WHV1_SMEWHV1_MASK)
/*! @} */

/*! @name R_SMW_SETTING2 - BIST SMW Setting 2 Register */
/*! @{ */

#define FMUTEST_R_SMW_SETTING2_SMWPARM2_MASK     (0x1FFFFFFFU)
#define FMUTEST_R_SMW_SETTING2_SMWPARM2_SHIFT    (0U)
/*! SMWPARM2 - SMW Parameter Set 2 */
#define FMUTEST_R_SMW_SETTING2_SMWPARM2(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_SETTING2_SMWPARM2_SHIFT)) & FMUTEST_R_SMW_SETTING2_SMWPARM2_MASK)
/*! @} */

/*! @name R_D_MISR0 - BIST DIN MISR 0 Register */
/*! @{ */

#define FMUTEST_R_D_MISR0_DATASIG0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_D_MISR0_DATASIG0_SHIFT         (0U)
/*! DATASIG0 - Data Signature */
#define FMUTEST_R_D_MISR0_DATASIG0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_D_MISR0_DATASIG0_SHIFT)) & FMUTEST_R_D_MISR0_DATASIG0_MASK)
/*! @} */

/*! @name R_A_MISR0 - BIST Address MISR 0 Register */
/*! @{ */

#define FMUTEST_R_A_MISR0_ADRSIG0_MASK           (0xFFFFFFFFU)
#define FMUTEST_R_A_MISR0_ADRSIG0_SHIFT          (0U)
/*! ADRSIG0 - Address Signature */
#define FMUTEST_R_A_MISR0_ADRSIG0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_A_MISR0_ADRSIG0_SHIFT)) & FMUTEST_R_A_MISR0_ADRSIG0_MASK)
/*! @} */

/*! @name R_C_MISR0 - BIST Control MISR 0 Register */
/*! @{ */

#define FMUTEST_R_C_MISR0_CTRLSIG0_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_C_MISR0_CTRLSIG0_SHIFT         (0U)
/*! CTRLSIG0 - Control Signature */
#define FMUTEST_R_C_MISR0_CTRLSIG0(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_C_MISR0_CTRLSIG0_SHIFT)) & FMUTEST_R_C_MISR0_CTRLSIG0_MASK)
/*! @} */

/*! @name R_SMW_SETTING3 - BIST SMW Setting 3 Register */
/*! @{ */

#define FMUTEST_R_SMW_SETTING3_SMWPARM3_MASK     (0x1FFFFU)
#define FMUTEST_R_SMW_SETTING3_SMWPARM3_SHIFT    (0U)
/*! SMWPARM3 - SMW Parameter Set 3 */
#define FMUTEST_R_SMW_SETTING3_SMWPARM3(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_SMW_SETTING3_SMWPARM3_SHIFT)) & FMUTEST_R_SMW_SETTING3_SMWPARM3_MASK)
/*! @} */

/*! @name R_DATA_CTRL1 - BIST Data Control 1 Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL1_DATA1_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_DATA_CTRL1_DATA1_SHIFT         (0U)
/*! DATA1 - BIST Data 1 Low */
#define FMUTEST_R_DATA_CTRL1_DATA1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL1_DATA1_SHIFT)) & FMUTEST_R_DATA_CTRL1_DATA1_MASK)
/*! @} */

/*! @name R_DATA_CTRL2 - BIST Data Control 2 Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL2_DATA2_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_DATA_CTRL2_DATA2_SHIFT         (0U)
/*! DATA2 - BIST Data 2 Low */
#define FMUTEST_R_DATA_CTRL2_DATA2(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL2_DATA2_SHIFT)) & FMUTEST_R_DATA_CTRL2_DATA2_MASK)
/*! @} */

/*! @name R_DATA_CTRL3 - BIST Data Control 3 Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL3_DATA3_MASK          (0xFFFFFFFFU)
#define FMUTEST_R_DATA_CTRL3_DATA3_SHIFT         (0U)
/*! DATA3 - BIST Data 3 Low */
#define FMUTEST_R_DATA_CTRL3_DATA3(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL3_DATA3_SHIFT)) & FMUTEST_R_DATA_CTRL3_DATA3_MASK)
/*! @} */

/*! @name R_REPAIR0_0 - BIST Repair 0 for Block 0 Register */
/*! @{ */

#define FMUTEST_R_REPAIR0_0_RDIS0_0_MASK         (0x1U)
#define FMUTEST_R_REPAIR0_0_RDIS0_0_SHIFT        (0U)
/*! RDIS0_0 - Control Repair 0 in Block 0.
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_R_REPAIR0_0_RDIS0_0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR0_0_RDIS0_0_SHIFT)) & FMUTEST_R_REPAIR0_0_RDIS0_0_MASK)

#define FMUTEST_R_REPAIR0_0_RADR0_0_MASK         (0x1FEU)
#define FMUTEST_R_REPAIR0_0_RADR0_0_SHIFT        (1U)
/*! RADR0_0 - XADR for Repair 0 in Block 0 */
#define FMUTEST_R_REPAIR0_0_RADR0_0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR0_0_RADR0_0_SHIFT)) & FMUTEST_R_REPAIR0_0_RADR0_0_MASK)
/*! @} */

/*! @name R_REPAIR0_1 - BIST Repair 1 Block 0 Register */
/*! @{ */

#define FMUTEST_R_REPAIR0_1_RDIS0_1_MASK         (0x1U)
#define FMUTEST_R_REPAIR0_1_RDIS0_1_SHIFT        (0U)
/*! RDIS0_1 - Control Repair 1 in Block 0.
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_R_REPAIR0_1_RDIS0_1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR0_1_RDIS0_1_SHIFT)) & FMUTEST_R_REPAIR0_1_RDIS0_1_MASK)

#define FMUTEST_R_REPAIR0_1_RADR0_1_MASK         (0x1FEU)
#define FMUTEST_R_REPAIR0_1_RADR0_1_SHIFT        (1U)
/*! RADR0_1 - XADR for Repair 1 in Block 0. */
#define FMUTEST_R_REPAIR0_1_RADR0_1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR0_1_RADR0_1_SHIFT)) & FMUTEST_R_REPAIR0_1_RADR0_1_MASK)
/*! @} */

/*! @name R_REPAIR1_0 - BIST Repair 0 Block 1 Register */
/*! @{ */

#define FMUTEST_R_REPAIR1_0_RDIS1_0_MASK         (0x1U)
#define FMUTEST_R_REPAIR1_0_RDIS1_0_SHIFT        (0U)
/*! RDIS1_0 - Control Repair 0 in Block 1.
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_R_REPAIR1_0_RDIS1_0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR1_0_RDIS1_0_SHIFT)) & FMUTEST_R_REPAIR1_0_RDIS1_0_MASK)

#define FMUTEST_R_REPAIR1_0_RADR1_0_MASK         (0x1FEU)
#define FMUTEST_R_REPAIR1_0_RADR1_0_SHIFT        (1U)
/*! RADR1_0 - XADR for Repair 0 in Block 1. */
#define FMUTEST_R_REPAIR1_0_RADR1_0(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR1_0_RADR1_0_SHIFT)) & FMUTEST_R_REPAIR1_0_RADR1_0_MASK)
/*! @} */

/*! @name R_REPAIR1_1 - BIST Repair 1 Block 1 Register */
/*! @{ */

#define FMUTEST_R_REPAIR1_1_RDIS1_1_MASK         (0x1U)
#define FMUTEST_R_REPAIR1_1_RDIS1_1_SHIFT        (0U)
/*! RDIS1_1 - Control Repair 1 in Block 1.
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_R_REPAIR1_1_RDIS1_1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR1_1_RDIS1_1_SHIFT)) & FMUTEST_R_REPAIR1_1_RDIS1_1_MASK)

#define FMUTEST_R_REPAIR1_1_RADR1_1_MASK         (0x1FEU)
#define FMUTEST_R_REPAIR1_1_RADR1_1_SHIFT        (1U)
/*! RADR1_1 - XADR for Repair 1 in Block 1. */
#define FMUTEST_R_REPAIR1_1_RADR1_1(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_REPAIR1_1_RADR1_1_SHIFT)) & FMUTEST_R_REPAIR1_1_RADR1_1_MASK)
/*! @} */

/*! @name R_DATA_CTRL0_EX - BIST Data Control 0 Extension Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL0_EX_DATA0X_MASK      (0x7U)
#define FMUTEST_R_DATA_CTRL0_EX_DATA0X_SHIFT     (0U)
/*! DATA0X - BIST Data 0 High */
#define FMUTEST_R_DATA_CTRL0_EX_DATA0X(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL0_EX_DATA0X_SHIFT)) & FMUTEST_R_DATA_CTRL0_EX_DATA0X_MASK)
/*! @} */

/*! @name R_TIMER_CTRL_EX - BIST Timer Control Extension Register */
/*! @{ */

#define FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H_MASK   (0x7U)
#define FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H_SHIFT  (0U)
/*! TLVSDLY_H - Tlvs Time Delay Scalar High */
#define FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H_SHIFT)) & FMUTEST_R_TIMER_CTRL_EX_TLVSDLY_H_MASK)
/*! @} */

/*! @name R_DOUT_QUERY1 - BIST DOUT Query 1 Register */
/*! @{ */

#define FMUTEST_R_DOUT_QUERY1_DOUT_MASK          (0x7U)
#define FMUTEST_R_DOUT_QUERY1_DOUT_SHIFT         (0U)
/*! DOUT - Failing DOUT High */
#define FMUTEST_R_DOUT_QUERY1_DOUT(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DOUT_QUERY1_DOUT_SHIFT)) & FMUTEST_R_DOUT_QUERY1_DOUT_MASK)
/*! @} */

/*! @name R_D_MISR1 - BIST DIN MISR 1 Register */
/*! @{ */

#define FMUTEST_R_D_MISR1_DATASIG1_MASK          (0xFFU)
#define FMUTEST_R_D_MISR1_DATASIG1_SHIFT         (0U)
/*! DATASIG1 - MISR Data Signature High */
#define FMUTEST_R_D_MISR1_DATASIG1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_D_MISR1_DATASIG1_SHIFT)) & FMUTEST_R_D_MISR1_DATASIG1_MASK)
/*! @} */

/*! @name R_A_MISR1 - BIST Address MISR 1 Register */
/*! @{ */

#define FMUTEST_R_A_MISR1_ADRSIG1_MASK           (0xFFU)
#define FMUTEST_R_A_MISR1_ADRSIG1_SHIFT          (0U)
/*! ADRSIG1 - MISR Address Signature High */
#define FMUTEST_R_A_MISR1_ADRSIG1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_A_MISR1_ADRSIG1_SHIFT)) & FMUTEST_R_A_MISR1_ADRSIG1_MASK)
/*! @} */

/*! @name R_C_MISR1 - BIST Control MISR 1 Register */
/*! @{ */

#define FMUTEST_R_C_MISR1_CTRLSIG1_MASK          (0xFFU)
#define FMUTEST_R_C_MISR1_CTRLSIG1_SHIFT         (0U)
/*! CTRLSIG1 - MISR Control Signature High */
#define FMUTEST_R_C_MISR1_CTRLSIG1(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_C_MISR1_CTRLSIG1_SHIFT)) & FMUTEST_R_C_MISR1_CTRLSIG1_MASK)
/*! @} */

/*! @name R_DATA_CTRL1_EX - BIST Data Control 1 Extension Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL1_EX_DATA1X_MASK      (0x7U)
#define FMUTEST_R_DATA_CTRL1_EX_DATA1X_SHIFT     (0U)
/*! DATA1X - BIST Data 1 High */
#define FMUTEST_R_DATA_CTRL1_EX_DATA1X(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL1_EX_DATA1X_SHIFT)) & FMUTEST_R_DATA_CTRL1_EX_DATA1X_MASK)
/*! @} */

/*! @name R_DATA_CTRL2_EX - BIST Data Control 2 Extension Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL2_EX_DATA2X_MASK      (0x7U)
#define FMUTEST_R_DATA_CTRL2_EX_DATA2X_SHIFT     (0U)
/*! DATA2X - BIST Data 2 High */
#define FMUTEST_R_DATA_CTRL2_EX_DATA2X(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL2_EX_DATA2X_SHIFT)) & FMUTEST_R_DATA_CTRL2_EX_DATA2X_MASK)
/*! @} */

/*! @name R_DATA_CTRL3_EX - BIST Data Control 3 Extension Register */
/*! @{ */

#define FMUTEST_R_DATA_CTRL3_EX_DATA3X_MASK      (0x7U)
#define FMUTEST_R_DATA_CTRL3_EX_DATA3X_SHIFT     (0U)
/*! DATA3X - BIST Data 3 High */
#define FMUTEST_R_DATA_CTRL3_EX_DATA3X(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_R_DATA_CTRL3_EX_DATA3X_SHIFT)) & FMUTEST_R_DATA_CTRL3_EX_DATA3X_MASK)
/*! @} */

/*! @name SMW_TIMER_OPTION - SMW Timer Option Register */
/*! @{ */

#define FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL_MASK  (0xFFU)
#define FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL_SHIFT (0U)
/*! SMW_CDIVL - Clock Divide Scalar for Long Pulse */
#define FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL_SHIFT)) & FMUTEST_SMW_TIMER_OPTION_SMW_CDIVL_MASK)

#define FMUTEST_SMW_TIMER_OPTION_SMW_TVFY_MASK   (0x1F00U)
#define FMUTEST_SMW_TIMER_OPTION_SMW_TVFY_SHIFT  (8U)
/*! SMW_TVFY - Timer Adjust for Verify */
#define FMUTEST_SMW_TIMER_OPTION_SMW_TVFY(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_TIMER_OPTION_SMW_TVFY_SHIFT)) & FMUTEST_SMW_TIMER_OPTION_SMW_TVFY_MASK)
/*! @} */

/*! @name SMW_SETTING_OPTION0 - SMW Setting Option 0 Register */
/*! @{ */

#define FMUTEST_SMW_SETTING_OPTION0_MV_INIT_MASK (0x1C000U)
#define FMUTEST_SMW_SETTING_OPTION0_MV_INIT_SHIFT (14U)
/*! MV_INIT - Medium Voltage Level Select Initial */
#define FMUTEST_SMW_SETTING_OPTION0_MV_INIT(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_MV_INIT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_MV_INIT_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_MV_END_MASK  (0xE0000U)
#define FMUTEST_SMW_SETTING_OPTION0_MV_END_SHIFT (17U)
/*! MV_END - Medium Voltage Level Select Final */
#define FMUTEST_SMW_SETTING_OPTION0_MV_END(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_MV_END_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_MV_END_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_MV_MISC_MASK (0xF00000U)
#define FMUTEST_SMW_SETTING_OPTION0_MV_MISC_SHIFT (20U)
/*! MV_MISC - Medium Voltage Control Misc */
#define FMUTEST_SMW_SETTING_OPTION0_MV_MISC(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_MV_MISC_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_MV_MISC_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT_MASK (0x3000000U)
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT_SHIFT (24U)
/*! IPGM_INIT - Program Current Control Initial */
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_IPGM_INIT_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_IPGM_END_MASK (0xC000000U)
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_END_SHIFT (26U)
/*! IPGM_END - Program Current Control Final */
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_END(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_IPGM_END_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_IPGM_END_MASK)

#define FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC_MASK (0x70000000U)
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC_SHIFT (28U)
/*! IPGM_MISC - Program Current Control Misc */
#define FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC_SHIFT)) & FMUTEST_SMW_SETTING_OPTION0_IPGM_MISC_MASK)
/*! @} */

/*! @name SMW_SETTING_OPTION2 - SMW Setting Option 2 Register */
/*! @{ */

#define FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL_MASK (0x7U)
#define FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL_SHIFT (0U)
/*! THVS_CTRL - Thvs control */
#define FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_THVS_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL_MASK (0x38U)
#define FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL_SHIFT (3U)
/*! TRCV_CTRL - Trcv Control */
#define FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_TRCV_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS_MASK (0xC0U)
#define FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS_SHIFT (6U)
/*! XTRA_ERS - Number of Post Shots for SME */
#define FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_XTRA_ERS_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM_MASK (0x300U)
#define FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM_SHIFT (8U)
/*! XTRA_PGM - Number of Post Shots for SMP */
#define FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_XTRA_PGM_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR_MASK (0x3FC00U)
#define FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR_SHIFT (10U)
/*! WHV_CNTR - WHV Counter */
#define FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_WHV_CNTR_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_POST_TERS_MASK (0x1C0000U)
#define FMUTEST_SMW_SETTING_OPTION2_POST_TERS_SHIFT (18U)
/*! POST_TERS - Post Ters Time
 *  0b000..50 usec
 *  0b001..100 usec
 *  0b010..200 usec
 *  0b011..300 usec
 *  0b100..500 usec
 *  0b101..1 msec
 *  0b110..1.5 msec
 *  0b111..2 msec
 */
#define FMUTEST_SMW_SETTING_OPTION2_POST_TERS(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_POST_TERS_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_POST_TERS_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_POST_TPGM_MASK (0x600000U)
#define FMUTEST_SMW_SETTING_OPTION2_POST_TPGM_SHIFT (21U)
/*! POST_TPGM - Post Tpgm Time
 *  0b00..1 usec
 *  0b01..2 usec
 *  0b10..4 usec
 *  0b11..8 usec
 */
#define FMUTEST_SMW_SETTING_OPTION2_POST_TPGM(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_POST_TPGM_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_POST_TPGM_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_VFY_OPT_MASK (0x1800000U)
#define FMUTEST_SMW_SETTING_OPTION2_VFY_OPT_SHIFT (23U)
/*! VFY_OPT - Verify Option
 *  0b00..Skip verify for post shot only, verify for all other shots
 *  0b01..Skip verify for the 1st and post shots
 *  0b10..Skip the 1st, 2nd, and post shots
 *  0b11..Skip verify for all shots
 */
#define FMUTEST_SMW_SETTING_OPTION2_VFY_OPT(x)   (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_VFY_OPT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_VFY_OPT_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT_MASK (0x6000000U)
#define FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT_SHIFT (25U)
/*! TPGM_OPT - Tpgm Option
 *  0b00..Fixed Tpgm for all shots, except post shot
 *  0b01..Increase Tpgm option by 1 for each loop until Tpgm reaches 4 usec
 *  0b10..Increase Tpgm option by 1 for each loop until Tpgm reaches 8 usec
 *  0b11..Unused
 */
#define FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_TPGM_OPT_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT_MASK (0x8000000U)
#define FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT_SHIFT (27U)
/*! MASK0_OPT - MASK0_OPT
 *  0b0..Mask programmed bits passing PV until extra shot
 *  0b1..Always program bits even if they pass PV
 */
#define FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_MASK0_OPT_MASK)

#define FMUTEST_SMW_SETTING_OPTION2_DIS_PRER_MASK (0x10000000U)
#define FMUTEST_SMW_SETTING_OPTION2_DIS_PRER_SHIFT (28U)
/*! DIS_PRER - Disable pre-PV Read before First Program Shot
 *  0b0..Enable pre-PV read before first program shot
 *  0b1..Disable pre-PV read before first program shot
 */
#define FMUTEST_SMW_SETTING_OPTION2_DIS_PRER(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION2_DIS_PRER_SHIFT)) & FMUTEST_SMW_SETTING_OPTION2_DIS_PRER_MASK)
/*! @} */

/*! @name SMW_SETTING_OPTION3 - SMW Setting Option 3 Register */
/*! @{ */

#define FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR_MASK (0xFFU)
#define FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR_SHIFT (0U)
/*! HEM_WHV_CNTR - WHV_COUNTER for HEM-erase Cycle */
#define FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR_SHIFT)) & FMUTEST_SMW_SETTING_OPTION3_HEM_WHV_CNTR_MASK)

#define FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS_MASK (0x1FF00U)
#define FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS_SHIFT (8U)
/*! HEM_MAX_ERS - HEM Max Erase Shot Count */
#define FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS_SHIFT)) & FMUTEST_SMW_SETTING_OPTION3_HEM_MAX_ERS_MASK)
/*! @} */

/*! @name SMW_SMP_WHV_OPTION0 - SMW SMP WHV Option 0 Register */
/*! @{ */

#define FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0_MASK (0xFFFFFFFFU)
#define FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0_SHIFT (0U)
/*! SMP_WHV_OPT0 - Smart Program WHV Option Low */
#define FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0_SHIFT)) & FMUTEST_SMW_SMP_WHV_OPTION0_SMP_WHV_OPT0_MASK)
/*! @} */

/*! @name SMW_SME_WHV_OPTION0 - SMW SME WHV Option 0 Register */
/*! @{ */

#define FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0_MASK (0xFFFFFFFFU)
#define FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0_SHIFT (0U)
/*! SME_WHV_OPT0 - Smart Erase WHV Option Low */
#define FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0_SHIFT)) & FMUTEST_SMW_SME_WHV_OPTION0_SME_WHV_OPT0_MASK)
/*! @} */

/*! @name SMW_SETTING_OPTION1 - SMW Setting Option 1 Register */
/*! @{ */

#define FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0_MASK (0x7U)
#define FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0_SHIFT (0U)
/*! TERS_CTRL0 - Ters Control
 *  0b000..50 usec
 *  0b001..100 usec
 *  0b010..200 usec
 *  0b011..300 usec
 *  0b100..500 usec
 *  0b101..1 msec
 *  0b110..1.5 msec
 *  0b111..2 msec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TERS_CTRL0_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL_MASK (0x18U)
#define FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL_SHIFT (3U)
/*! TPGM_CTRL - Tpgm Control
 *  0b00..1 usec
 *  0b01..2 usec
 *  0b10..4 usec
 *  0b11..8 usec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TPGM_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL_MASK (0xE0U)
#define FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL_SHIFT (5U)
/*! TNVS_CTRL - Tnvs Control
 *  0b000..5 usec
 *  0b001..8 usec
 *  0b010..11 usec
 *  0b011..14 usec
 *  0b100..17 usec
 *  0b101..20 usec
 *  0b110..23 usec
 *  0b111..26 usec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TNVS_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL_MASK (0x700U)
#define FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL_SHIFT (8U)
/*! TNVH_CTRL - Tnvh Control
 *  0b000..2 usec
 *  0b001..2.5 usec
 *  0b010..3 usec
 *  0b011..3.5 usec
 *  0b100..4 usec
 *  0b101..4.5 usec
 *  0b110..5 usec
 *  0b111..5.5 usec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TNVH_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL_MASK (0x3800U)
#define FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL_SHIFT (11U)
/*! TPGS_CTRL - Tpgs Control
 *  0b000..1 usec
 *  0b001..2 usec
 *  0b010..3 usec
 *  0b011..4 usec
 *  0b100..5 usec
 *  0b101..6 usec
 *  0b110..7 usec
 *  0b111..8 usec
 */
#define FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_TPGS_CTRL_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE_MASK (0x7FC000U)
#define FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE_SHIFT (14U)
/*! MAX_ERASE - Number of Erase Shots */
#define FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_MAX_ERASE_MASK)

#define FMUTEST_SMW_SETTING_OPTION1_MAX_PROG_MASK (0xF800000U)
#define FMUTEST_SMW_SETTING_OPTION1_MAX_PROG_SHIFT (23U)
/*! MAX_PROG - Number of Program Shots */
#define FMUTEST_SMW_SETTING_OPTION1_MAX_PROG(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SETTING_OPTION1_MAX_PROG_SHIFT)) & FMUTEST_SMW_SETTING_OPTION1_MAX_PROG_MASK)
/*! @} */

/*! @name SMW_SMP_WHV_OPTION1 - SMW SMP WHV Option 1 Register */
/*! @{ */

#define FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1_MASK (0xFFFFFFFFU)
#define FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1_SHIFT (0U)
/*! SMP_WHV_OPT1 - Smart Program WHV Option High */
#define FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1_SHIFT)) & FMUTEST_SMW_SMP_WHV_OPTION1_SMP_WHV_OPT1_MASK)
/*! @} */

/*! @name SMW_SME_WHV_OPTION1 - SMW SME WHV Option 1 Register */
/*! @{ */

#define FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1_MASK (0xFFFFFFFFU)
#define FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1_SHIFT (0U)
/*! SME_WHV_OPT1 - Smart Erase WHV Option High */
#define FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1_SHIFT)) & FMUTEST_SMW_SME_WHV_OPTION1_SME_WHV_OPT1_MASK)
/*! @} */

/*! @name REPAIR0_0 - FMU Repair 0 Block 0 Register */
/*! @{ */

#define FMUTEST_REPAIR0_0_RDIS0_0_MASK           (0x1U)
#define FMUTEST_REPAIR0_0_RDIS0_0_SHIFT          (0U)
/*! RDIS0_0 - RDIS0_0
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_REPAIR0_0_RDIS0_0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR0_0_RDIS0_0_SHIFT)) & FMUTEST_REPAIR0_0_RDIS0_0_MASK)

#define FMUTEST_REPAIR0_0_RADR0_0_MASK           (0x1FEU)
#define FMUTEST_REPAIR0_0_RADR0_0_SHIFT          (1U)
/*! RADR0_0 - RADR0_0 */
#define FMUTEST_REPAIR0_0_RADR0_0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR0_0_RADR0_0_SHIFT)) & FMUTEST_REPAIR0_0_RADR0_0_MASK)
/*! @} */

/*! @name REPAIR0_1 - FMU Repair 1 Block 0 Register */
/*! @{ */

#define FMUTEST_REPAIR0_1_RDIS0_1_MASK           (0x1U)
#define FMUTEST_REPAIR0_1_RDIS0_1_SHIFT          (0U)
/*! RDIS0_1 - RDIS0_1
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_REPAIR0_1_RDIS0_1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR0_1_RDIS0_1_SHIFT)) & FMUTEST_REPAIR0_1_RDIS0_1_MASK)

#define FMUTEST_REPAIR0_1_RADR0_1_MASK           (0x1FEU)
#define FMUTEST_REPAIR0_1_RADR0_1_SHIFT          (1U)
/*! RADR0_1 - RADR0_1 */
#define FMUTEST_REPAIR0_1_RADR0_1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR0_1_RADR0_1_SHIFT)) & FMUTEST_REPAIR0_1_RADR0_1_MASK)
/*! @} */

/*! @name REPAIR1_0 - FMU Repair 0 Block 1 Register */
/*! @{ */

#define FMUTEST_REPAIR1_0_RDIS1_0_MASK           (0x1U)
#define FMUTEST_REPAIR1_0_RDIS1_0_SHIFT          (0U)
/*! RDIS1_0 - RDIS1_0
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_REPAIR1_0_RDIS1_0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR1_0_RDIS1_0_SHIFT)) & FMUTEST_REPAIR1_0_RDIS1_0_MASK)

#define FMUTEST_REPAIR1_0_RADR1_0_MASK           (0x1FEU)
#define FMUTEST_REPAIR1_0_RADR1_0_SHIFT          (1U)
/*! RADR1_0 - RADR1_0 */
#define FMUTEST_REPAIR1_0_RADR1_0(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR1_0_RADR1_0_SHIFT)) & FMUTEST_REPAIR1_0_RADR1_0_MASK)
/*! @} */

/*! @name REPAIR1_1 - FMU Repair 1 Block 1 Register */
/*! @{ */

#define FMUTEST_REPAIR1_1_RDIS1_1_MASK           (0x1U)
#define FMUTEST_REPAIR1_1_RDIS1_1_SHIFT          (0U)
/*! RDIS1_1 - RDIS1_1
 *  0b0..Repair address is valid
 *  0b1..Repair address is not valid
 */
#define FMUTEST_REPAIR1_1_RDIS1_1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR1_1_RDIS1_1_SHIFT)) & FMUTEST_REPAIR1_1_RDIS1_1_MASK)

#define FMUTEST_REPAIR1_1_RADR1_1_MASK           (0x1FEU)
#define FMUTEST_REPAIR1_1_RADR1_1_SHIFT          (1U)
/*! RADR1_1 - RADR1_1 */
#define FMUTEST_REPAIR1_1_RADR1_1(x)             (((uint32_t)(((uint32_t)(x)) << FMUTEST_REPAIR1_1_RADR1_1_SHIFT)) & FMUTEST_REPAIR1_1_RADR1_1_MASK)
/*! @} */

/*! @name SMW_HB_SIGNALS - SMW HB Signals Register */
/*! @{ */

#define FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY_MASK    (0x7U)
#define FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY_SHIFT   (0U)
/*! SMW_ARRAY - SMW Region Select
 *  0b000..Main array
 *  0b001..IFR space only or main (and REDEN space) with IFR space for mass erase
 *  0b010..IFR1 space
 *  0b100..REDEN space
 */
#define FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_SMW_ARRAY_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN1_MASK  (0x8U)
#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN1_SHIFT (3U)
/*! USER_IFREN1 - IFR1 Enable
 *  0b0..IFREN1 input to the flash array is driven LOW
 *  0b1..IFREN1 input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN1(x)    (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_IFREN1_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_IFREN1_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_PV_MASK      (0x10U)
#define FMUTEST_SMW_HB_SIGNALS_USER_PV_SHIFT     (4U)
/*! USER_PV - Program Verify
 *  0b0..PV input to the flash array is driven LOW
 *  0b1..PV input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_PV(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_PV_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_PV_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_EV_MASK      (0x20U)
#define FMUTEST_SMW_HB_SIGNALS_USER_EV_SHIFT     (5U)
/*! USER_EV - Erase Verify
 *  0b0..EV input to the flash array is driven LOW
 *  0b1..EV input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_EV(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_EV_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_EV_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN_MASK   (0x40U)
#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN_SHIFT  (6U)
/*! USER_IFREN - IFR Enable
 *  0b0..IFREN input to the flash array is driven LOW
 *  0b1..IFREN input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_IFREN(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_IFREN_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_IFREN_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_REDEN_MASK   (0x80U)
#define FMUTEST_SMW_HB_SIGNALS_USER_REDEN_SHIFT  (7U)
/*! USER_REDEN - Repair Read Enable
 *  0b0..REDEN input to the flash array is driven LOW
 *  0b1..REDEN input to the flash array is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_REDEN(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_REDEN_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_REDEN_MASK)

#define FMUTEST_SMW_HB_SIGNALS_USER_HEM_MASK     (0x100U)
#define FMUTEST_SMW_HB_SIGNALS_USER_HEM_SHIFT    (8U)
/*! USER_HEM - High Endurance Enable
 *  0b0..HEM input to SMW / BIST PIN_CTRL[24] is driven LOW
 *  0b1..HEM input to SMW / BIST PIN_CTRL[24] is driven HIGH
 */
#define FMUTEST_SMW_HB_SIGNALS_USER_HEM(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_SMW_HB_SIGNALS_USER_HEM_SHIFT)) & FMUTEST_SMW_HB_SIGNALS_USER_HEM_MASK)
/*! @} */

/*! @name BIST_DUMP_CTRL - BIST Datadump Control Register */
/*! @{ */

#define FMUTEST_BIST_DUMP_CTRL_BIST_DONE_MASK    (0x10000U)
#define FMUTEST_BIST_DUMP_CTRL_BIST_DONE_SHIFT   (16U)
/*! BIST_DONE - BIST Done
 *  0b0..The BIST (or data dump) is running
 *  0b1..The BIST (or data dump) has completed
 */
#define FMUTEST_BIST_DUMP_CTRL_BIST_DONE(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_BIST_DONE_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_BIST_DONE_MASK)

#define FMUTEST_BIST_DUMP_CTRL_BIST_FAIL_MASK    (0x20000U)
#define FMUTEST_BIST_DUMP_CTRL_BIST_FAIL_SHIFT   (17U)
/*! BIST_FAIL - BIST Fail
 *  0b0..The last BIST operation completed successfully (or could not fail)
 *  0b1..The last BIST operation failed
 */
#define FMUTEST_BIST_DUMP_CTRL_BIST_FAIL(x)      (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_BIST_FAIL_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_BIST_FAIL_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MASK     (0x40000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_SHIFT    (18U)
/*! DATADUMP - Data Dump Enable */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG_MASK (0x80000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG_SHIFT (19U)
/*! DATADUMP_TRIG - Data Dump Trigger */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_TRIG_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT_MASK (0x300000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT_SHIFT (20U)
/*! DATADUMP_PATT - Data Dump Pattern Select
 *  0b00..All ones
 *  0b01..All zeroes
 *  0b10..Checkerboard
 *  0b11..Inverse checkerboard
 */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT(x)  (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_PATT_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN_MASK (0x400000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN_SHIFT (22U)
/*! DATADUMP_MRGEN - Data Dump Margin Enable
 *  0b0..Normal read pulse shape
 *  0b1..Margin read pulse shape
 */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGEN_MASK)

#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE_MASK (0x800000U)
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE_SHIFT (23U)
/*! DATADUMP_MRGTYPE - Data Dump Margin Type
 *  0b0..DIN method used
 *  0b1..TM method used
 */
#define FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE(x) (((uint32_t)(((uint32_t)(x)) << FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE_SHIFT)) & FMUTEST_BIST_DUMP_CTRL_DATADUMP_MRGTYPE_MASK)
/*! @} */

/*! @name ATX_PIN_CTRL - ATX Pin Control Register */
/*! @{ */

#define FMUTEST_ATX_PIN_CTRL_TM_TO_ATX_MASK      (0xFFU)
#define FMUTEST_ATX_PIN_CTRL_TM_TO_ATX_SHIFT     (0U)
/*! TM_TO_ATX - TM to ATX
 *  0b00000001..TM[0] to ATX0
 *  0b00000010..TM[1] to ATX0
 *  0b00000100..TM[2] to ATX0
 *  0b00001000..TM[3] to ATX0
 *  0b00010000..TM[0] to ATX1
 *  0b00100000..TM[1] to ATX1
 *  0b01000000..TM[2] to ATX1
 *  0b10000000..TM[3] to ATX1
 */
#define FMUTEST_ATX_PIN_CTRL_TM_TO_ATX(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_ATX_PIN_CTRL_TM_TO_ATX_SHIFT)) & FMUTEST_ATX_PIN_CTRL_TM_TO_ATX_MASK)
/*! @} */

/*! @name FAILCNT - Fail Count Register */
/*! @{ */

#define FMUTEST_FAILCNT_FAILCNT_MASK             (0xFFFFFFFFU)
#define FMUTEST_FAILCNT_FAILCNT_SHIFT            (0U)
/*! FAILCNT - Fail Count */
#define FMUTEST_FAILCNT_FAILCNT(x)               (((uint32_t)(((uint32_t)(x)) << FMUTEST_FAILCNT_FAILCNT_SHIFT)) & FMUTEST_FAILCNT_FAILCNT_MASK)
/*! @} */

/*! @name PGM_PULSE_CNT0 - Block 0 Program Pulse Count Register */
/*! @{ */

#define FMUTEST_PGM_PULSE_CNT0_PGM_CNT0_MASK     (0xFFFFFFFFU)
#define FMUTEST_PGM_PULSE_CNT0_PGM_CNT0_SHIFT    (0U)
/*! PGM_CNT0 - Program Pulse Count */
#define FMUTEST_PGM_PULSE_CNT0_PGM_CNT0(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_PGM_PULSE_CNT0_PGM_CNT0_SHIFT)) & FMUTEST_PGM_PULSE_CNT0_PGM_CNT0_MASK)
/*! @} */

/*! @name PGM_PULSE_CNT1 - Block 1 Program Pulse Count Register */
/*! @{ */

#define FMUTEST_PGM_PULSE_CNT1_PGM_CNT1_MASK     (0xFFFFFFFFU)
#define FMUTEST_PGM_PULSE_CNT1_PGM_CNT1_SHIFT    (0U)
/*! PGM_CNT1 - Program Pulse Count */
#define FMUTEST_PGM_PULSE_CNT1_PGM_CNT1(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_PGM_PULSE_CNT1_PGM_CNT1_SHIFT)) & FMUTEST_PGM_PULSE_CNT1_PGM_CNT1_MASK)
/*! @} */

/*! @name ERS_PULSE_CNT - Erase Pulse Count Register */
/*! @{ */

#define FMUTEST_ERS_PULSE_CNT_ERS_CNT0_MASK      (0xFFFFU)
#define FMUTEST_ERS_PULSE_CNT_ERS_CNT0_SHIFT     (0U)
/*! ERS_CNT0 - Block 0 Erase Pulse Count */
#define FMUTEST_ERS_PULSE_CNT_ERS_CNT0(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_ERS_PULSE_CNT_ERS_CNT0_SHIFT)) & FMUTEST_ERS_PULSE_CNT_ERS_CNT0_MASK)

#define FMUTEST_ERS_PULSE_CNT_ERS_CNT1_MASK      (0xFFFF0000U)
#define FMUTEST_ERS_PULSE_CNT_ERS_CNT1_SHIFT     (16U)
/*! ERS_CNT1 - Block 1 Erase Pulse Count */
#define FMUTEST_ERS_PULSE_CNT_ERS_CNT1(x)        (((uint32_t)(((uint32_t)(x)) << FMUTEST_ERS_PULSE_CNT_ERS_CNT1_SHIFT)) & FMUTEST_ERS_PULSE_CNT_ERS_CNT1_MASK)
/*! @} */

/*! @name MAX_PULSE_CNT - Maximum Pulse Count Register */
/*! @{ */

#define FMUTEST_MAX_PULSE_CNT_LAST_PCNT_MASK     (0x1FFU)
#define FMUTEST_MAX_PULSE_CNT_LAST_PCNT_SHIFT    (0U)
/*! LAST_PCNT - Last SMW Operation's Pulse Count */
#define FMUTEST_MAX_PULSE_CNT_LAST_PCNT(x)       (((uint32_t)(((uint32_t)(x)) << FMUTEST_MAX_PULSE_CNT_LAST_PCNT_SHIFT)) & FMUTEST_MAX_PULSE_CNT_LAST_PCNT_MASK)

#define FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT_MASK   (0x1FF0000U)
#define FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT_SHIFT  (16U)
/*! MAX_ERS_CNT - Maximum Erase Pulse Count */
#define FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT_SHIFT)) & FMUTEST_MAX_PULSE_CNT_MAX_ERS_CNT_MASK)

#define FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT_MASK   (0xF8000000U)
#define FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT_SHIFT  (27U)
/*! MAX_PGM_CNT - Maximum Program Pulse Count */
#define FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT(x)     (((uint32_t)(((uint32_t)(x)) << FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT_SHIFT)) & FMUTEST_MAX_PULSE_CNT_MAX_PGM_CNT_MASK)
/*! @} */

/*! @name PORT_CTRL - Port Control Register */
/*! @{ */

#define FMUTEST_PORT_CTRL_BDONE_SEL_MASK         (0x3U)
#define FMUTEST_PORT_CTRL_BDONE_SEL_SHIFT        (0U)
/*! BDONE_SEL - BIST Done Select
 *  0b00..Select internal bist_done signal from current module instantiation
 *  0b01..Select ipt_bist_fail signal from current module instantiation
 *  0b10..Select ipt_bist_done signal from other module instantiation
 *  0b11..Select AND of internal bist_done signal from current module instantiation with ipt_bist_done signal from other module instantiation
 */
#define FMUTEST_PORT_CTRL_BDONE_SEL(x)           (((uint32_t)(((uint32_t)(x)) << FMUTEST_PORT_CTRL_BDONE_SEL_SHIFT)) & FMUTEST_PORT_CTRL_BDONE_SEL_MASK)

#define FMUTEST_PORT_CTRL_BSDO_SEL_MASK          (0xCU)
#define FMUTEST_PORT_CTRL_BSDO_SEL_SHIFT         (2U)
/*! BSDO_SEL - BIST Serial Data Output Select
 *  0b00..Select internal bist_sdo signal from current module instantiation
 *  0b01..Select ipt_bist_done signal from current module instantiation
 *  0b10..Select ipt_bist_sdo signal from other module instantiation
 *  0b11..Select ipt_bist_done signal from other module instantiation
 */
#define FMUTEST_PORT_CTRL_BSDO_SEL(x)            (((uint32_t)(((uint32_t)(x)) << FMUTEST_PORT_CTRL_BSDO_SEL_SHIFT)) & FMUTEST_PORT_CTRL_BSDO_SEL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FMUTEST_Register_Masks */


/* FMUTEST - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FMU0TEST base address */
  #define FMU0TEST_BASE                            (0x50043000u)
  /** Peripheral FMU0TEST base address */
  #define FMU0TEST_BASE_NS                         (0x40043000u)
  /** Peripheral FMU0TEST base pointer */
  #define FMU0TEST                                 ((FMUTEST_Type *)FMU0TEST_BASE)
  /** Peripheral FMU0TEST base pointer */
  #define FMU0TEST_NS                              ((FMUTEST_Type *)FMU0TEST_BASE_NS)
  /** Array initializer of FMUTEST peripheral base addresses */
  #define FMUTEST_BASE_ADDRS                       { FMU0TEST_BASE }
  /** Array initializer of FMUTEST peripheral base pointers */
  #define FMUTEST_BASE_PTRS                        { FMU0TEST }
  /** Array initializer of FMUTEST peripheral base addresses */
  #define FMUTEST_BASE_ADDRS_NS                    { FMU0TEST_BASE_NS }
  /** Array initializer of FMUTEST peripheral base pointers */
  #define FMUTEST_BASE_PTRS_NS                     { FMU0TEST_NS }
#else
  /** Peripheral FMU0TEST base address */
  #define FMU0TEST_BASE                            (0x40043000u)
  /** Peripheral FMU0TEST base pointer */
  #define FMU0TEST                                 ((FMUTEST_Type *)FMU0TEST_BASE)
  /** Array initializer of FMUTEST peripheral base addresses */
  #define FMUTEST_BASE_ADDRS                       { FMU0TEST_BASE }
  /** Array initializer of FMUTEST peripheral base pointers */
  #define FMUTEST_BASE_PTRS                        { FMU0TEST }
#endif

/*!
 * @}
 */ /* end of group FMUTEST_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FREQME Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Peripheral_Access_Layer FREQME Peripheral Access Layer
 * @{
 */

/** FREQME - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    __I  uint32_t CTRL_R;                            /**< Control (in Read mode), offset: 0x0 */
    __O  uint32_t CTRL_W;                            /**< Control (in Write mode), offset: 0x0 */
  };
  __IO uint32_t CTRLSTAT;                          /**< Control Status, offset: 0x4 */
  __IO uint32_t MIN;                               /**< Minimum, offset: 0x8 */
  __IO uint32_t MAX;                               /**< Maximum, offset: 0xC */
} FREQME_Type;

/* ----------------------------------------------------------------------------
   -- FREQME Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Register_Masks FREQME Register Masks
 * @{
 */

/*! @name CTRL_R - Control (in Read mode) */
/*! @{ */

#define FREQME_CTRL_R_RESULT_MASK                (0x7FFFFFFFU)
#define FREQME_CTRL_R_RESULT_SHIFT               (0U)
#define FREQME_CTRL_R_RESULT(x)                  (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_R_RESULT_SHIFT)) & FREQME_CTRL_R_RESULT_MASK)

#define FREQME_CTRL_R_MEASURE_IN_PROGRESS_MASK   (0x80000000U)
#define FREQME_CTRL_R_MEASURE_IN_PROGRESS_SHIFT  (31U)
/*! MEASURE_IN_PROGRESS - Measurement In Progress
 *  0b0..Complete
 *  0b1..In progress
 */
#define FREQME_CTRL_R_MEASURE_IN_PROGRESS(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_R_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_CTRL_R_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name CTRL_W - Control (in Write mode) */
/*! @{ */

#define FREQME_CTRL_W_REF_SCALE_MASK             (0x1FU)
#define FREQME_CTRL_W_REF_SCALE_SHIFT            (0U)
/*! REF_SCALE - Reference Clock Scaling Factor */
#define FREQME_CTRL_W_REF_SCALE(x)               (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_REF_SCALE_SHIFT)) & FREQME_CTRL_W_REF_SCALE_MASK)

#define FREQME_CTRL_W_PULSE_MODE_MASK            (0x100U)
#define FREQME_CTRL_W_PULSE_MODE_SHIFT           (8U)
/*! PULSE_MODE - Pulse Width Measurement Mode Select
 *  0b0..Frequency Measurement mode
 *  0b1..Pulse Width Measurement mode
 */
#define FREQME_CTRL_W_PULSE_MODE(x)              (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_PULSE_MODE_SHIFT)) & FREQME_CTRL_W_PULSE_MODE_MASK)

#define FREQME_CTRL_W_PULSE_POL_MASK             (0x200U)
#define FREQME_CTRL_W_PULSE_POL_SHIFT            (9U)
/*! PULSE_POL - Pulse Polarity
 *  0b0..High period
 *  0b1..Low period
 */
#define FREQME_CTRL_W_PULSE_POL(x)               (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_PULSE_POL_SHIFT)) & FREQME_CTRL_W_PULSE_POL_MASK)

#define FREQME_CTRL_W_LT_MIN_INT_EN_MASK         (0x1000U)
#define FREQME_CTRL_W_LT_MIN_INT_EN_SHIFT        (12U)
/*! LT_MIN_INT_EN - Less Than Minimum Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_CTRL_W_LT_MIN_INT_EN(x)           (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_LT_MIN_INT_EN_SHIFT)) & FREQME_CTRL_W_LT_MIN_INT_EN_MASK)

#define FREQME_CTRL_W_GT_MAX_INT_EN_MASK         (0x2000U)
#define FREQME_CTRL_W_GT_MAX_INT_EN_SHIFT        (13U)
/*! GT_MAX_INT_EN - Greater Than Maximum Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_CTRL_W_GT_MAX_INT_EN(x)           (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_GT_MAX_INT_EN_SHIFT)) & FREQME_CTRL_W_GT_MAX_INT_EN_MASK)

#define FREQME_CTRL_W_RESULT_READY_INT_EN_MASK   (0x4000U)
#define FREQME_CTRL_W_RESULT_READY_INT_EN_SHIFT  (14U)
/*! RESULT_READY_INT_EN - Result Ready Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_CTRL_W_RESULT_READY_INT_EN(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_RESULT_READY_INT_EN_SHIFT)) & FREQME_CTRL_W_RESULT_READY_INT_EN_MASK)

#define FREQME_CTRL_W_CONTINUOUS_MODE_EN_MASK    (0x40000000U)
#define FREQME_CTRL_W_CONTINUOUS_MODE_EN_SHIFT   (30U)
/*! CONTINUOUS_MODE_EN - Continuous Mode Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_CTRL_W_CONTINUOUS_MODE_EN(x)      (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_CONTINUOUS_MODE_EN_SHIFT)) & FREQME_CTRL_W_CONTINUOUS_MODE_EN_MASK)

#define FREQME_CTRL_W_MEASURE_IN_PROGRESS_MASK   (0x80000000U)
#define FREQME_CTRL_W_MEASURE_IN_PROGRESS_SHIFT  (31U)
/*! MEASURE_IN_PROGRESS - Measurement In Progress
 *  0b0..Terminates measurement
 *  0b1..Initiates measurement
 */
#define FREQME_CTRL_W_MEASURE_IN_PROGRESS(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_CTRL_W_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_CTRL_W_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name CTRLSTAT - Control Status */
/*! @{ */

#define FREQME_CTRLSTAT_REF_SCALE_MASK           (0x1FU)
#define FREQME_CTRLSTAT_REF_SCALE_SHIFT          (0U)
/*! REF_SCALE - Reference Scale */
#define FREQME_CTRLSTAT_REF_SCALE(x)             (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_REF_SCALE_SHIFT)) & FREQME_CTRLSTAT_REF_SCALE_MASK)

#define FREQME_CTRLSTAT_PULSE_MODE_MASK          (0x100U)
#define FREQME_CTRLSTAT_PULSE_MODE_SHIFT         (8U)
/*! PULSE_MODE - Pulse Mode
 *  0b0..Frequency Measurement mode
 *  0b1..Pulse Width Measurement mode
 */
#define FREQME_CTRLSTAT_PULSE_MODE(x)            (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_PULSE_MODE_SHIFT)) & FREQME_CTRLSTAT_PULSE_MODE_MASK)

#define FREQME_CTRLSTAT_PULSE_POL_MASK           (0x200U)
#define FREQME_CTRLSTAT_PULSE_POL_SHIFT          (9U)
/*! PULSE_POL - Pulse Polarity
 *  0b0..High period
 *  0b1..Low period
 */
#define FREQME_CTRLSTAT_PULSE_POL(x)             (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_PULSE_POL_SHIFT)) & FREQME_CTRLSTAT_PULSE_POL_MASK)

#define FREQME_CTRLSTAT_LT_MIN_INT_EN_MASK       (0x1000U)
#define FREQME_CTRLSTAT_LT_MIN_INT_EN_SHIFT      (12U)
/*! LT_MIN_INT_EN - Less Than Minimum Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FREQME_CTRLSTAT_LT_MIN_INT_EN(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_LT_MIN_INT_EN_SHIFT)) & FREQME_CTRLSTAT_LT_MIN_INT_EN_MASK)

#define FREQME_CTRLSTAT_GT_MAX_INT_EN_MASK       (0x2000U)
#define FREQME_CTRLSTAT_GT_MAX_INT_EN_SHIFT      (13U)
/*! GT_MAX_INT_EN - Greater Than Maximum Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FREQME_CTRLSTAT_GT_MAX_INT_EN(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_GT_MAX_INT_EN_SHIFT)) & FREQME_CTRLSTAT_GT_MAX_INT_EN_MASK)

#define FREQME_CTRLSTAT_RESULT_READY_INT_EN_MASK (0x4000U)
#define FREQME_CTRLSTAT_RESULT_READY_INT_EN_SHIFT (14U)
/*! RESULT_READY_INT_EN - Result Ready Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FREQME_CTRLSTAT_RESULT_READY_INT_EN(x)   (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_RESULT_READY_INT_EN_SHIFT)) & FREQME_CTRLSTAT_RESULT_READY_INT_EN_MASK)

#define FREQME_CTRLSTAT_LT_MIN_STAT_MASK         (0x1000000U)
#define FREQME_CTRLSTAT_LT_MIN_STAT_SHIFT        (24U)
/*! LT_MIN_STAT - Less Than Minimum Results Status
 *  0b0..Greater than MIN[MIN_VALUE]
 *  0b1..Less than MIN[MIN_VALUE]
 */
#define FREQME_CTRLSTAT_LT_MIN_STAT(x)           (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_LT_MIN_STAT_SHIFT)) & FREQME_CTRLSTAT_LT_MIN_STAT_MASK)

#define FREQME_CTRLSTAT_GT_MAX_STAT_MASK         (0x2000000U)
#define FREQME_CTRLSTAT_GT_MAX_STAT_SHIFT        (25U)
/*! GT_MAX_STAT - Greater Than Maximum Result Status
 *  0b0..Less than MAX[MAX_VALUE]
 *  0b1..Greater than MAX[MAX_VALUE]
 */
#define FREQME_CTRLSTAT_GT_MAX_STAT(x)           (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_GT_MAX_STAT_SHIFT)) & FREQME_CTRLSTAT_GT_MAX_STAT_MASK)

#define FREQME_CTRLSTAT_RESULT_READY_STAT_MASK   (0x4000000U)
#define FREQME_CTRLSTAT_RESULT_READY_STAT_SHIFT  (26U)
/*! RESULT_READY_STAT - Result Ready Status
 *  0b0..Not complete
 *  0b1..Complete
 */
#define FREQME_CTRLSTAT_RESULT_READY_STAT(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_RESULT_READY_STAT_SHIFT)) & FREQME_CTRLSTAT_RESULT_READY_STAT_MASK)

#define FREQME_CTRLSTAT_CONTINUOUS_MODE_EN_MASK  (0x40000000U)
#define FREQME_CTRLSTAT_CONTINUOUS_MODE_EN_SHIFT (30U)
/*! CONTINUOUS_MODE_EN - Continuous Mode Enable Status
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define FREQME_CTRLSTAT_CONTINUOUS_MODE_EN(x)    (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_CONTINUOUS_MODE_EN_SHIFT)) & FREQME_CTRLSTAT_CONTINUOUS_MODE_EN_MASK)

#define FREQME_CTRLSTAT_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_CTRLSTAT_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measurement in Progress Status
 *  0b0..Not in progress
 *  0b1..In progress
 */
#define FREQME_CTRLSTAT_MEASURE_IN_PROGRESS(x)   (((uint32_t)(((uint32_t)(x)) << FREQME_CTRLSTAT_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_CTRLSTAT_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name MIN - Minimum */
/*! @{ */

#define FREQME_MIN_MIN_VALUE_MASK                (0x7FFFFFFFU)
#define FREQME_MIN_MIN_VALUE_SHIFT               (0U)
/*! MIN_VALUE - Minimum Value */
#define FREQME_MIN_MIN_VALUE(x)                  (((uint32_t)(((uint32_t)(x)) << FREQME_MIN_MIN_VALUE_SHIFT)) & FREQME_MIN_MIN_VALUE_MASK)
/*! @} */

/*! @name MAX - Maximum */
/*! @{ */

#define FREQME_MAX_MAX_VALUE_MASK                (0x7FFFFFFFU)
#define FREQME_MAX_MAX_VALUE_SHIFT               (0U)
/*! MAX_VALUE - Maximum Value */
#define FREQME_MAX_MAX_VALUE(x)                  (((uint32_t)(((uint32_t)(x)) << FREQME_MAX_MAX_VALUE_SHIFT)) & FREQME_MAX_MAX_VALUE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FREQME_Register_Masks */


/* FREQME - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FREQME0 base address */
  #define FREQME0_BASE                             (0x50011000u)
  /** Peripheral FREQME0 base address */
  #define FREQME0_BASE_NS                          (0x40011000u)
  /** Peripheral FREQME0 base pointer */
  #define FREQME0                                  ((FREQME_Type *)FREQME0_BASE)
  /** Peripheral FREQME0 base pointer */
  #define FREQME0_NS                               ((FREQME_Type *)FREQME0_BASE_NS)
  /** Array initializer of FREQME peripheral base addresses */
  #define FREQME_BASE_ADDRS                        { FREQME0_BASE }
  /** Array initializer of FREQME peripheral base pointers */
  #define FREQME_BASE_PTRS                         { FREQME0 }
  /** Array initializer of FREQME peripheral base addresses */
  #define FREQME_BASE_ADDRS_NS                     { FREQME0_BASE_NS }
  /** Array initializer of FREQME peripheral base pointers */
  #define FREQME_BASE_PTRS_NS                      { FREQME0_NS }
#else
  /** Peripheral FREQME0 base address */
  #define FREQME0_BASE                             (0x40011000u)
  /** Peripheral FREQME0 base pointer */
  #define FREQME0                                  ((FREQME_Type *)FREQME0_BASE)
  /** Array initializer of FREQME peripheral base addresses */
  #define FREQME_BASE_ADDRS                        { FREQME0_BASE }
  /** Array initializer of FREQME peripheral base pointers */
  #define FREQME_BASE_PTRS                         { FREQME0 }
#endif
/** Interrupt vectors for the FREQME peripheral type */
#define FREQME_IRQS                              { Freqme_IRQn }

/*!
 * @}
 */ /* end of group FREQME_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GDET Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GDET_Peripheral_Access_Layer GDET Peripheral Access Layer
 * @{
 */

/** GDET - Register Layout Typedef */
typedef struct {
  __IO uint32_t GDET_CONF_0;                       /**< GDET Configuration 0 Register, offset: 0x0 */
  __IO uint32_t GDET_CONF_1;                       /**< GDET Configuration 1 Register, offset: 0x4 */
  __IO uint32_t GDET_ENABLE1;                      /**< GDET Enable Register, offset: 0x8 */
  __IO uint32_t GDET_CONF_2;                       /**< GDET Configuration 2 Register, offset: 0xC */
  __IO uint32_t GDET_CONF_3;                       /**< GDET Configuration 3 Register, offset: 0x10 */
  __IO uint32_t GDET_CONF_4;                       /**< GDET Configuration 4 Register, offset: 0x14 */
  __IO uint32_t GDET_CONF_5;                       /**< GDET Configuration 5 Register, offset: 0x18 */
       uint8_t RESERVED_0[4004];
  __IO uint32_t GDET_RESET;                        /**< GDET Reset Register, offset: 0xFC0 */
  __IO uint32_t GDET_TEST;                         /**< GDET Test Register, offset: 0xFC4 */
       uint8_t RESERVED_1[4];
  __IO uint32_t GDET_DLY_CTRL;                     /**< GDET Delay Control Register, offset: 0xFCC */
} GDET_Type;

/* ----------------------------------------------------------------------------
   -- GDET Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GDET_Register_Masks GDET Register Masks
 * @{
 */

/*! @name GDET_CONF_0 - GDET Configuration 0 Register */
/*! @{ */

#define GDET_GDET_CONF_0_FIELD_3_0_MASK          (0xFU)
#define GDET_GDET_CONF_0_FIELD_3_0_SHIFT         (0U)
/*! FIELD_3_0 - GDET Configuration 0 Field 3_0 */
#define GDET_GDET_CONF_0_FIELD_3_0(x)            (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_0_FIELD_3_0_SHIFT)) & GDET_GDET_CONF_0_FIELD_3_0_MASK)

#define GDET_GDET_CONF_0_SBZ_MASK                (0x10U)
#define GDET_GDET_CONF_0_SBZ_SHIFT               (4U)
/*! SBZ - Should Be Left to Zero */
#define GDET_GDET_CONF_0_SBZ(x)                  (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_0_SBZ_SHIFT)) & GDET_GDET_CONF_0_SBZ_MASK)

#define GDET_GDET_CONF_0_RFU_MASK                (0xFFFFFFE0U)
#define GDET_GDET_CONF_0_RFU_SHIFT               (5U)
/*! RFU - Reserved for Future Use */
#define GDET_GDET_CONF_0_RFU(x)                  (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_0_RFU_SHIFT)) & GDET_GDET_CONF_0_RFU_MASK)
/*! @} */

/*! @name GDET_CONF_1 - GDET Configuration 1 Register */
/*! @{ */

#define GDET_GDET_CONF_1_FIELD_1_0_MASK          (0x3U)
#define GDET_GDET_CONF_1_FIELD_1_0_SHIFT         (0U)
/*! FIELD_1_0 - GDET Configuration 1 Field 1_0 */
#define GDET_GDET_CONF_1_FIELD_1_0(x)            (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_FIELD_1_0_SHIFT)) & GDET_GDET_CONF_1_FIELD_1_0_MASK)

#define GDET_GDET_CONF_1_FIELD_3_2_MASK          (0xCU)
#define GDET_GDET_CONF_1_FIELD_3_2_SHIFT         (2U)
/*! FIELD_3_2 - GDET Configuration 1 Field 3_2 */
#define GDET_GDET_CONF_1_FIELD_3_2(x)            (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_FIELD_3_2_SHIFT)) & GDET_GDET_CONF_1_FIELD_3_2_MASK)

#define GDET_GDET_CONF_1_SBZ1_MASK               (0x10U)
#define GDET_GDET_CONF_1_SBZ1_SHIFT              (4U)
/*! SBZ1 - Should Be Left to Zero */
#define GDET_GDET_CONF_1_SBZ1(x)                 (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_SBZ1_SHIFT)) & GDET_GDET_CONF_1_SBZ1_MASK)

#define GDET_GDET_CONF_1_SBZ2_MASK               (0x20U)
#define GDET_GDET_CONF_1_SBZ2_SHIFT              (5U)
/*! SBZ2 - Should Be Left to Zero */
#define GDET_GDET_CONF_1_SBZ2(x)                 (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_SBZ2_SHIFT)) & GDET_GDET_CONF_1_SBZ2_MASK)

#define GDET_GDET_CONF_1_SBZ3_MASK               (0x40U)
#define GDET_GDET_CONF_1_SBZ3_SHIFT              (6U)
/*! SBZ3 - Should Be Left to Zero */
#define GDET_GDET_CONF_1_SBZ3(x)                 (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_SBZ3_SHIFT)) & GDET_GDET_CONF_1_SBZ3_MASK)

#define GDET_GDET_CONF_1_FIELD_7_MASK            (0x80U)
#define GDET_GDET_CONF_1_FIELD_7_SHIFT           (7U)
/*! FIELD_7 - GDET Configuration 1 Field 7 */
#define GDET_GDET_CONF_1_FIELD_7(x)              (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_FIELD_7_SHIFT)) & GDET_GDET_CONF_1_FIELD_7_MASK)

#define GDET_GDET_CONF_1_FIELD_8_MASK            (0x100U)
#define GDET_GDET_CONF_1_FIELD_8_SHIFT           (8U)
/*! FIELD_8 - GDET Configuration 1 Field 8 */
#define GDET_GDET_CONF_1_FIELD_8(x)              (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_FIELD_8_SHIFT)) & GDET_GDET_CONF_1_FIELD_8_MASK)

#define GDET_GDET_CONF_1_SBZ4_MASK               (0x200U)
#define GDET_GDET_CONF_1_SBZ4_SHIFT              (9U)
/*! SBZ4 - Should Be Left to Zero */
#define GDET_GDET_CONF_1_SBZ4(x)                 (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_SBZ4_SHIFT)) & GDET_GDET_CONF_1_SBZ4_MASK)

#define GDET_GDET_CONF_1_SBZ5_MASK               (0x400U)
#define GDET_GDET_CONF_1_SBZ5_SHIFT              (10U)
/*! SBZ5 - Should Be Left to Zero */
#define GDET_GDET_CONF_1_SBZ5(x)                 (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_SBZ5_SHIFT)) & GDET_GDET_CONF_1_SBZ5_MASK)

#define GDET_GDET_CONF_1_RFU_MASK                (0xFFFFF800U)
#define GDET_GDET_CONF_1_RFU_SHIFT               (11U)
/*! RFU - Reserved for Future Use */
#define GDET_GDET_CONF_1_RFU(x)                  (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_1_RFU_SHIFT)) & GDET_GDET_CONF_1_RFU_MASK)
/*! @} */

/*! @name GDET_ENABLE1 - GDET Enable Register */
/*! @{ */

#define GDET_GDET_ENABLE1_EN1_MASK               (0x1U)
#define GDET_GDET_ENABLE1_EN1_SHIFT              (0U)
/*! EN1 - If set, the detector will be clock gated */
#define GDET_GDET_ENABLE1_EN1(x)                 (((uint32_t)(((uint32_t)(x)) << GDET_GDET_ENABLE1_EN1_SHIFT)) & GDET_GDET_ENABLE1_EN1_MASK)

#define GDET_GDET_ENABLE1_RFU_MASK               (0xFFFFFFFEU)
#define GDET_GDET_ENABLE1_RFU_SHIFT              (1U)
/*! RFU - Reserved for Future Use */
#define GDET_GDET_ENABLE1_RFU(x)                 (((uint32_t)(((uint32_t)(x)) << GDET_GDET_ENABLE1_RFU_SHIFT)) & GDET_GDET_ENABLE1_RFU_MASK)
/*! @} */

/*! @name GDET_CONF_2 - GDET Configuration 2 Register */
/*! @{ */

#define GDET_GDET_CONF_2_FIELD_6_0_MASK          (0x7FU)
#define GDET_GDET_CONF_2_FIELD_6_0_SHIFT         (0U)
/*! FIELD_6_0 - GDET Configuration 2 Field 6_0 */
#define GDET_GDET_CONF_2_FIELD_6_0(x)            (((uint32_t)(((uint32_t)(x)) << GDET_GDET_CONF_2_FIELD_6_0_SHIFT)) & GDET_GDET_CONF_2_FIELD_6_0_MASK)

#define GDET_GDET_CONF_2_RFU1_MASK               (0xFF80U)
#define GDET_GDET_CONF_2_RFU1_SHIFT              (7U)
/*! RFU1 - Reserved for Future Use */
#define GDET_GDET_CONF_2_RFU1(x)                 (((uint32_t