/*
 * Copyright 2022 , NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _FSL_INPUTMUX_CONNECTIONS_
#define _FSL_INPUTMUX_CONNECTIONS_

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* Component ID definition, used by tools. */
#ifndef FSL_COMPONENT_ID
#define FSL_COMPONENT_ID "platform.drivers.inputmux_connections"
#endif

/*!
 * @addtogroup inputmux_driver
 * @{
 */

/*!
 * @name Input multiplexing connections
 * @{
 */

/*! @brief Periphinmux IDs */
#define SCT0_INMUX0              0x00U
#define TIMER0CAPTSEL0           0x20U
#define TIMER0TRIGIN             0x30U
#define TIMER1CAPTSEL0           0x40U
#define TIMER1TRIGIN             0x50U
#define TIMER2CAPTSEL0           0x60U
#define TIMER2TRIGIN             0x70U
#define SMARTDMAARCHB_INMUX0     0xA0U
#define PINTSEL0                 0xC0U
#define FREQMEAS_REF_REG         0x180U
#define FREQMEAS_TAR_REG         0x184U
#define TIMER3CAPTSEL0           0x1A0U
#define TIMER3TRIGIN             0x1B0U
#define TIMER4CAPTSEL0           0x1C0U
#define TIMER4TRIGIN             0x1D0U
#define CMP0_TRIG_REG            0x260U
#define ADC0_TRIG0               0x280U
#define ADC1_TRIG0               0x2C0U
#define DAC0_TRIG_REG            0x300U
#define DAC1_TRIG_REG            0x320U
#define DAC2_TRIG_REG            0x340U
#define ENC0_TRIG_REG            0x360U
#define ENC0_HOME_REG            0x364U
#define ENC0_INDEX_REG           0x368U
#define ENC0_PHASEB_REG          0x36CU
#define ENC0_PHASEA_REG          0x370U
#define ENC1_TRIG_REG            0x380U
#define ENC1_HOME_REG            0x384U
#define ENC1_INDEX_REG           0x388U
#define ENC1_PHASEB_REG          0x38CU
#define ENC1_PHASEA_REG          0x390U
#define FlexPWM0_SM0_EXTSYNC_REG 0x3A0U
#define FlexPWM0_SM1_EXTSYNC_REG 0x3A4U
#define FlexPWM0_SM2_EXTSYNC_REG 0x3A8U
#define FlexPWM0_SM3_EXTSYNC_REG 0x3ACU
#define FlexPWM0_SM0_EXTA_REG    0x3B0U
#define FlexPWM0_SM1_EXTA_REG    0x3B4U
#define FlexPWM0_SM2_EXTA_REG    0x3B8U
#define FlexPWM0_SM3_EXTA_REG    0x3BCU
#define FlexPWM0_EXTFORCE_REG    0x3C0U
#define FlexPWM0_FAULT0_REG      0x3C4U
#define FlexPWM0_FAULT1_REG      0x3C8U
#define FlexPWM0_FAULT2_REG      0x3CCU
#define FlexPWM0_FAULT3_REG      0x3D0U
#define FlexPWM1_SM0_EXTSYNC_REG 0x3E0U
#define FlexPWM1_SM1_EXTSYNC_REG 0x3E4U
#define FlexPWM1_SM2_EXTSYNC_REG 0x3E8U
#define FlexPWM1_SM3_EXTSYNC_REG 0x3ECU
#define FlexPWM1_SM0_EXTA_REG    0x3F0U
#define FlexPWM1_SM1_EXTA_REG    0x3F4U
#define FlexPWM1_SM2_EXTA_REG    0x3F8U
#define FlexPWM1_SM3_EXTA_REG    0x3FCU
#define FlexPWM1_EXTFORCE_REG    0x400U
#define FlexPWM1_FAULT0_REG      0x404U
#define FlexPWM1_FAULT1_REG      0x408U
#define FlexPWM1_FAULT2_REG      0x40CU
#define FlexPWM1_FAULT3_REG      0x410U
#define PWM0_EXT_CLK_REG         0x420U
#define PWM1_EXT_CLK_REG         0x424U
#define EVTG_TRIG0_REG           0x440U
#define USBFS_TRIG_REG           0x480U
#define TSI_TRIG_REG             0x4A0U
#define EXT_TRIG0_REG            0x4C0U
#define CMP1_TRIG_REG            0x4E0U
#define CMP2_TRIG_REG            0x500U
#define SINC_FILTER_CH0_REG      0x520U
#define OPAMP0_TRIG_REG          0x580U
#define OPAMP1_TRIG_REG          0x584U
#define OPAMP2_TRIG_REG          0x588U
#define FLEXCOMM0_TRIG_REG       0x5A0U
#define FLEXCOMM1_TRIG_REG       0x5C0U
#define FLEXCOMM2_TRIG_REG       0x5E0U
#define FLEXCOMM3_TRIG_REG       0x600U
#define FLEXCOMM4_TRIG_REG       0x620U
#define FLEXCOMM5_TRIG_REG       0x640U
#define FLEXCOMM6_TRIG_REG       0x660U
#define FLEXCOMM7_TRIG_REG       0x680U
#define FLEXCOMM8_TRIG_REG       0x6A0U
#define FLEXCOMM9_TRIG_REG       0x6C0U
#define FLEXIO_TRIG0_REG         0x6E0U

#define DMA0_REQ_ENABLE0_REG 0x700U
#define DMA0_REQ_ENABLE1_REG 0x710U
#define DMA0_REQ_ENABLE2_REG 0x720U
#define DMA0_REQ_ENABLE3_REG 0x730U
#define DMA1_REQ_ENABLE0_REG 0x780U
#define DMA1_REQ_ENABLE1_REG 0x790U
#define DMA1_REQ_ENABLE2_REG 0x7A0U
#define DMA1_REQ_ENABLE3_REG 0x7B0U

#define ENA_SHIFT  8U
#define PMUX_SHIFT 20U

/*! @brief INPUTMUX connections type */
typedef enum _inputmux_connection_t
{
    /*!< SCT0 INMUX. */
    kINPUTMUX_Sct0In0ToSct0                = 0U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0In1ToSct0                = 1U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0In2ToSct0                = 2U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0In3ToSct0                = 3U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0In4ToSct0                = 4U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0In5ToSct0                = 5U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0In6ToSct0                = 6U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sct0In7ToSct0                = 7U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToSct0              = 8U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToSct0              = 9U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToSct0              = 10U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToSct0              = 11U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToSct0              = 12U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToSct0                = 13U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatToSct0            = 14U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToggleToSct0 = 15U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToggleToSct0 = 16U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToSct0          = 17U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToSct0          = 18U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToSct0          = 19U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToSct0          = 20U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToSct0          = 21U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToSct0                = 22U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_DebugHaltedToSct0            = 23U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToSct0                = 24U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0tcomp0ToSct0             = 25U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0tcomp1ToSct0             = 26U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0tcomp2ToSct0             = 27U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0tcomp3ToSct0             = 28U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1tcomp0ToSct0             = 29U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1tcomp1ToSct0             = 30U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1tcomp2ToSct0             = 31U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1tcomp3ToSct0             = 32U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToSct0                = 33U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToSct0                = 34U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToSct0                = 35U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToSct0           = 36U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToSct0           = 37U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToSct0           = 38U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToSct0           = 39U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToSct0           = 40U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToSct0           = 41U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToSct0           = 42U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToSct0           = 43U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToSct0        = 44U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToSct0        = 45U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToSct0              = 46U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToSct0              = 47U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToSct0              = 48U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToSct0              = 49U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToSct0              = 50U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToSct0              = 51U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToSct0              = 52U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToSct0              = 53U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Fc3P0ToSct0                  = 54U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Fc3P1ToSct0                  = 55U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Fc3P2ToSct0                  = 56U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Fc3P3ToSct0                  = 57U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm0Trig0ToSct0       = 60U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm0Trig1ToSct0       = 61U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm0Trig2ToSct0       = 62U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm1Trig0ToSct0       = 63U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm1Trig1ToSct0       = 64U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm1Trig2ToSct0       = 65U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm2Trig0ToSct0       = 66U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm2Trig1ToSct0       = 67U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm2Trig2ToSct0       = 68U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig0ToSct0       = 69U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig1ToSct0       = 70U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig2ToSct0       = 71U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig3ToSct0       = 72U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sai0TxBclkToSct0             = 73U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sai0RxBclkToSct0             = 74U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sai1TxBclkToSct0             = 75U + (SCT0_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Sai1RxBclkToSct0             = 76U + (SCT0_INMUX0 << PMUX_SHIFT),

    /*!< TIMER0 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer0Captsel       = 0U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer0Captsel       = 1U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer0Captsel       = 2U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer0Captsel       = 3U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer0Captsel       = 4U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer0Captsel       = 5U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer0Captsel       = 6U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer0Captsel       = 7U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer0Captsel       = 8U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer0Captsel       = 9U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer0Captsel      = 10U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer0Captsel      = 11U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer0Captsel      = 12U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer0Captsel      = 13U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer0Captsel      = 14U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer0Captsel      = 15U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer0Captsel      = 16U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer0Captsel      = 17U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer0Captsel      = 18U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer0Captsel      = 19U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer0Captsel = 20U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer0Captsel = 21U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer0Captsel    = 23U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer0Captsel    = 24U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer0Captsel          = 25U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer0Captsel          = 26U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer0Captsel          = 27U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer0Captsel          = 28U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer0Captsel          = 29U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer0Captsel     = 30U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer0Captsel     = 31U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer0Captsel     = 32U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer0Captsel     = 33U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer0Captsel     = 34U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer0Captsel     = 35U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer0Captsel     = 36U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer0Captsel     = 37U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer0Captsel  = 38U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer0Captsel  = 39U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer0Captsel        = 40U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer0Captsel        = 41U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer0Captsel        = 42U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer0Captsel        = 43U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer0Captsel        = 44U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer0Captsel        = 45U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer0Captsel        = 46U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer0Captsel        = 47U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer0Captsel = 50U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer0Captsel = 51U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer0Captsel = 52U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer0Captsel = 53U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer0Captsel = 54U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer0Captsel = 55U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer0Captsel = 56U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer0Captsel = 57U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer0Captsel = 58U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer0Captsel = 59U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer0Captsel = 60U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer0Captsel = 61U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer0Captsel = 62U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer0Captsel    = 63U + (TIMER0CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer0Captsel    = 64U + (TIMER0CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER1 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer1Captsel       = 0U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer1Captsel       = 1U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer1Captsel       = 2U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer1Captsel       = 3U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer1Captsel       = 4U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer1Captsel       = 5U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer1Captsel       = 6U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer1Captsel       = 7U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer1Captsel       = 8U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer1Captsel       = 9U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer1Captsel      = 10U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer1Captsel      = 11U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer1Captsel      = 12U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer1Captsel      = 13U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer1Captsel      = 14U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer1Captsel      = 15U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer1Captsel      = 16U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer1Captsel      = 17U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer1Captsel      = 18U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer1Captsel      = 19U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer1Captsel = 20U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer1Captsel = 21U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer1Captsel    = 23U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer1Captsel    = 24U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer1Captsel          = 25U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer1Captsel          = 26U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer1Captsel          = 27U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer1Captsel          = 28U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer1Captsel          = 29U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer1Captsel     = 30U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer1Captsel     = 31U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer1Captsel     = 32U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer1Captsel     = 33U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer1Captsel     = 34U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer1Captsel     = 35U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer1Captsel     = 36U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer1Captsel     = 37U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer1Captsel  = 38U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer1Captsel  = 39U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer1Captsel        = 40U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer1Captsel        = 41U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer1Captsel        = 42U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer1Captsel        = 43U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer1Captsel        = 44U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer1Captsel        = 45U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer1Captsel        = 46U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer1Captsel        = 47U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer1Captsel = 50U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer1Captsel = 51U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer1Captsel = 52U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer1Captsel = 53U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer1Captsel = 54U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer1Captsel = 55U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer1Captsel = 56U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer1Captsel = 57U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer1Captsel = 58U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer1Captsel = 59U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer1Captsel = 60U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer1Captsel = 61U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer1Captsel = 62U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer1Captsel    = 63U + (TIMER1CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer1Captsel    = 64U + (TIMER1CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER2 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer2Captsel       = 0U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer2Captsel       = 1U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer2Captsel       = 2U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer2Captsel       = 3U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer2Captsel       = 4U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer2Captsel       = 5U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer2Captsel       = 6U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer2Captsel       = 7U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer2Captsel       = 8U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer2Captsel       = 9U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer2Captsel      = 10U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer2Captsel      = 11U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer2Captsel      = 12U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer2Captsel      = 13U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer2Captsel      = 14U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer2Captsel      = 15U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer2Captsel      = 16U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer2Captsel      = 17U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer2Captsel      = 18U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer2Captsel      = 19U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer2Captsel = 20U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer2Captsel = 21U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer2Captsel    = 23U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer2Captsel    = 24U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer2Captsel          = 25U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer2Captsel          = 26U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer2Captsel          = 27U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer2Captsel          = 28U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer2Captsel          = 29U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer2Captsel     = 30U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer2Captsel     = 31U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer2Captsel     = 32U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer2Captsel     = 33U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer2Captsel     = 34U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer2Captsel     = 35U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer2Captsel     = 36U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer2Captsel     = 37U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer2Captsel  = 38U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer2Captsel  = 39U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer2Captsel        = 40U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer2Captsel        = 41U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer2Captsel        = 42U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer2Captsel        = 43U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer2Captsel        = 44U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer2Captsel        = 45U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer2Captsel        = 46U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer2Captsel        = 47U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer2Captsel = 50U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer2Captsel = 51U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer2Captsel = 52U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer2Captsel = 53U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer2Captsel = 54U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer2Captsel = 55U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer2Captsel = 56U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer2Captsel = 57U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer2Captsel = 58U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer2Captsel = 59U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer2Captsel = 60U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer2Captsel = 61U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer2Captsel = 62U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer2Captsel    = 63U + (TIMER2CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer2Captsel    = 64U + (TIMER2CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER3 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer3Captsel       = 0U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer3Captsel       = 1U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer3Captsel       = 2U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer3Captsel       = 3U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer3Captsel       = 4U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer3Captsel       = 5U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer3Captsel       = 6U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer3Captsel       = 7U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer3Captsel       = 8U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer3Captsel       = 9U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer3Captsel      = 10U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer3Captsel      = 11U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer3Captsel      = 12U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer3Captsel      = 13U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer3Captsel      = 14U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer3Captsel      = 15U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer3Captsel      = 16U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer3Captsel      = 17U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer3Captsel      = 18U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer3Captsel      = 19U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer3Captsel = 20U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer3Captsel = 21U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer3Captsel    = 23U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer3Captsel    = 24U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer3Captsel          = 25U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer3Captsel          = 26U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer3Captsel          = 27U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer3Captsel          = 28U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer3Captsel          = 29U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer3Captsel     = 30U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer3Captsel     = 31U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer3Captsel     = 32U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer3Captsel     = 33U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer3Captsel     = 34U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer3Captsel     = 35U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer3Captsel     = 36U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer3Captsel     = 37U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer3Captsel  = 38U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer3Captsel  = 39U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer3Captsel        = 40U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer3Captsel        = 41U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer3Captsel        = 42U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer3Captsel        = 43U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer3Captsel        = 44U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer3Captsel        = 45U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer3Captsel        = 46U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer3Captsel        = 47U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer3Captsel = 50U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer3Captsel = 51U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer3Captsel = 52U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer3Captsel = 53U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer3Captsel = 54U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer3Captsel = 55U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer3Captsel = 56U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer3Captsel = 57U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer3Captsel = 58U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer3Captsel = 59U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer3Captsel = 60U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer3Captsel = 61U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer3Captsel = 62U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer3Captsel    = 63U + (TIMER3CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer3Captsel    = 64U + (TIMER3CAPTSEL0 << PMUX_SHIFT),

    /*!< Timer4 CAPTSEL. */
    kINPUTMUX_CtimerInp0ToTimer4Captsel       = 0U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer4Captsel       = 1U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer4Captsel       = 2U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer4Captsel       = 3U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer4Captsel       = 4U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer4Captsel       = 5U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer4Captsel       = 6U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer4Captsel       = 7U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer4Captsel       = 8U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer4Captsel       = 9U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer4Captsel      = 10U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer4Captsel      = 11U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer4Captsel      = 12U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer4Captsel      = 13U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer4Captsel      = 14U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer4Captsel      = 15U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer4Captsel      = 16U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer4Captsel      = 17U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer4Captsel      = 18U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer4Captsel      = 19U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer4Captsel = 20U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer4Captsel = 21U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer4Captsel    = 23U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer4Captsel    = 24U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer4Captsel          = 25U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer4Captsel          = 26U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer4Captsel          = 27U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer4Captsel          = 28U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer4Captsel          = 29U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer4Captsel     = 30U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer4Captsel     = 31U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer4Captsel     = 32U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer4Captsel     = 33U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer4Captsel     = 34U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer4Captsel     = 35U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer4Captsel     = 36U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer4Captsel     = 37U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer4Captsel  = 38U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer4Captsel  = 39U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer4Captsel        = 40U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer4Captsel        = 41U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer4Captsel        = 42U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer4Captsel        = 43U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer4Captsel        = 44U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer4Captsel        = 45U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer4Captsel        = 46U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer4Captsel        = 47U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer4Captsel = 50U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer4Captsel = 51U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer4Captsel = 52U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer4Captsel = 53U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer4Captsel = 54U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer4Captsel = 55U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer4Captsel = 56U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer4Captsel = 57U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer4Captsel = 58U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer4Captsel = 59U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer4Captsel = 60U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer4Captsel = 61U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer4Captsel = 62U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer4Captsel    = 63U + (TIMER4CAPTSEL0 << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer4Captsel    = 64U + (TIMER4CAPTSEL0 << PMUX_SHIFT),

    /*!< TIMER0 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer0Trigger       = 0U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer0Trigger       = 1U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer0Trigger       = 2U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer0Trigger       = 3U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer0Trigger       = 4U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer0Trigger       = 5U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer0Trigger       = 6U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer0Trigger       = 7U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer0Trigger       = 8U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer0Trigger       = 9U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer0Trigger      = 10U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer0Trigger      = 11U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer0Trigger      = 12U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer0Trigger      = 13U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer0Trigger      = 14U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer0Trigger      = 15U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer0Trigger      = 16U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer0Trigger      = 17U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer0Trigger      = 18U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer0Trigger      = 19U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer0Trigger = 20U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer0Trigger = 21U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer0Trigger    = 23U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer0Trigger    = 24U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer0Trigger          = 25U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer0Trigger          = 26U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer0Trigger          = 27U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer0Trigger          = 28U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer0Trigger          = 29U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer0Trigger     = 30U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer0Trigger     = 31U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer0Trigger     = 32U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer0Trigger     = 33U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer0Trigger     = 34U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer0Trigger     = 35U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer0Trigger     = 36U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer0Trigger     = 37U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer0Trigger  = 38U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer0Trigger  = 39U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer0Trigger        = 40U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer0Trigger        = 41U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer0Trigger        = 42U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer0Trigger        = 43U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer0Trigger        = 44U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer0Trigger        = 45U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer0Trigger        = 46U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer0Trigger        = 47U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer0Trigger = 50U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer0Trigger = 51U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer0Trigger = 52U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer0Trigger = 53U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer0Trigger = 54U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer0Trigger = 55U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer0Trigger = 56U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer0Trigger = 57U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer0Trigger = 58U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer0Trigger = 59U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer0Trigger = 60U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer0Trigger = 61U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer0Trigger = 62U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer0Trigger    = 63U + (TIMER0TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer0Trigger    = 64U + (TIMER0TRIGIN << PMUX_SHIFT),

    /*!< TIMER1 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer1Trigger       = 0U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer1Trigger       = 1U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer1Trigger       = 2U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer1Trigger       = 3U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer1Trigger       = 4U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer1Trigger       = 5U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer1Trigger       = 6U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer1Trigger       = 7U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer1Trigger       = 8U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer1Trigger       = 9U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer1Trigger      = 10U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer1Trigger      = 11U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer1Trigger      = 12U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer1Trigger      = 13U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer1Trigger      = 14U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer1Trigger      = 15U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer1Trigger      = 16U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer1Trigger      = 17U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer1Trigger      = 18U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer1Trigger      = 19U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer1Trigger = 20U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer1Trigger = 21U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer1Trigger    = 23U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer1Trigger    = 24U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer1Trigger          = 25U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer1Trigger          = 26U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer1Trigger          = 27U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer1Trigger          = 28U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer1Trigger          = 29U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer1Trigger     = 30U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer1Trigger     = 31U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer1Trigger     = 32U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer1Trigger     = 33U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer1Trigger     = 34U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer1Trigger     = 35U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer1Trigger     = 36U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer1Trigger     = 37U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer1Trigger  = 38U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer1Trigger  = 39U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer1Trigger        = 40U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer1Trigger        = 41U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer1Trigger        = 42U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer1Trigger        = 43U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer1Trigger        = 44U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer1Trigger        = 45U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer1Trigger        = 46U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer1Trigger        = 47U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer1Trigger = 50U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer1Trigger = 51U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer1Trigger = 52U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer1Trigger = 53U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer1Trigger = 54U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer1Trigger = 55U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer1Trigger = 56U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer1Trigger = 57U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer1Trigger = 58U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer1Trigger = 59U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer1Trigger = 60U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer1Trigger = 61U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer1Trigger = 62U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer1Trigger    = 63U + (TIMER1TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer1Trigger    = 64U + (TIMER1TRIGIN << PMUX_SHIFT),

    /*!< TIMER2 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer2Trigger       = 0U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer2Trigger       = 1U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer2Trigger       = 2U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer2Trigger       = 3U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer2Trigger       = 4U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer2Trigger       = 5U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer2Trigger       = 6U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer2Trigger       = 7U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer2Trigger       = 8U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer2Trigger       = 9U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer2Trigger      = 10U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer2Trigger      = 11U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer2Trigger      = 12U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer2Trigger      = 13U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer2Trigger      = 14U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer2Trigger      = 15U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer2Trigger      = 16U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer2Trigger      = 17U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer2Trigger      = 18U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer2Trigger      = 19U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer2Trigger = 20U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer2Trigger = 21U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer2Trigger    = 23U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer2Trigger    = 24U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer2Trigger          = 25U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer2Trigger          = 26U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer2Trigger          = 27U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer2Trigger          = 28U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer2Trigger          = 29U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer2Trigger     = 30U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer2Trigger     = 31U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer2Trigger     = 32U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer2Trigger     = 33U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer2Trigger     = 34U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer2Trigger     = 35U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer2Trigger     = 36U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer2Trigger     = 37U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer2Trigger  = 38U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer2Trigger  = 39U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer2Trigger        = 40U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer2Trigger        = 41U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer2Trigger        = 42U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer2Trigger        = 43U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer2Trigger        = 44U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer2Trigger        = 45U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer2Trigger        = 46U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer2Trigger        = 47U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer2Trigger = 50U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer2Trigger = 51U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer2Trigger = 52U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer2Trigger = 53U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer2Trigger = 54U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer2Trigger = 55U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer2Trigger = 56U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer2Trigger = 57U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer2Trigger = 58U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer2Trigger = 59U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer2Trigger = 60U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer2Trigger = 61U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer2Trigger = 62U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer2Trigger    = 63U + (TIMER2TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer2Trigger    = 64U + (TIMER2TRIGIN << PMUX_SHIFT),

    /*!< TIMER3 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer3Trigger       = 0U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer3Trigger       = 1U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer3Trigger       = 2U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer3Trigger       = 3U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer3Trigger       = 4U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer3Trigger       = 5U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer3Trigger       = 6U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer3Trigger       = 7U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer3Trigger       = 8U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer3Trigger       = 9U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer3Trigger      = 10U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer3Trigger      = 11U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer3Trigger      = 12U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer3Trigger      = 13U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer3Trigger      = 14U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer3Trigger      = 15U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer3Trigger      = 16U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer3Trigger      = 17U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer3Trigger      = 18U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer3Trigger      = 19U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer3Trigger = 20U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer3Trigger = 21U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer3Trigger    = 23U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer3Trigger    = 24U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer3Trigger          = 25U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer3Trigger          = 26U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer3Trigger          = 27U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer3Trigger          = 28U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer3Trigger          = 29U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer3Trigger     = 30U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer3Trigger     = 31U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer3Trigger     = 32U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer3Trigger     = 33U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer3Trigger     = 34U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer3Trigger     = 35U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer3Trigger     = 36U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer3Trigger     = 37U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer3Trigger  = 38U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer3Trigger  = 39U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer3Trigger        = 40U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer3Trigger        = 41U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer3Trigger        = 42U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer3Trigger        = 43U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer3Trigger        = 44U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer3Trigger        = 45U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer3Trigger        = 46U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer3Trigger        = 47U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer3Trigger = 50U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer3Trigger = 51U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer3Trigger = 52U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer3Trigger = 53U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer3Trigger = 54U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer3Trigger = 55U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer3Trigger = 56U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer3Trigger = 57U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer3Trigger = 58U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer3Trigger = 59U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer3Trigger = 60U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer3Trigger = 61U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer3Trigger = 62U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer3Trigger    = 63U + (TIMER3TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer3Trigger    = 64U + (TIMER3TRIGIN << PMUX_SHIFT),

    /*!< TIMER4 Trigger. */
    kINPUTMUX_CtimerInp0ToTimer4Trigger       = 0U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp1ToTimer4Trigger       = 1U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp2ToTimer4Trigger       = 2U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp3ToTimer4Trigger       = 3U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp4ToTimer4Trigger       = 4U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp5ToTimer4Trigger       = 5U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp6ToTimer4Trigger       = 6U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp7ToTimer4Trigger       = 7U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp8ToTimer4Trigger       = 8U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp9ToTimer4Trigger       = 9U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp10ToTimer4Trigger      = 10U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp11ToTimer4Trigger      = 11U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp12ToTimer4Trigger      = 12U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp13ToTimer4Trigger      = 13U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp14ToTimer4Trigger      = 14U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp15ToTimer4Trigger      = 15U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp16ToTimer4Trigger      = 16U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp17ToTimer4Trigger      = 17U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp18ToTimer4Trigger      = 18U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_CtimerInp19ToTimer4Trigger      = 19U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameToTimer4Trigger = 20U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameToTimer4Trigger = 21U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0TxSyncOutToTimer4Trigger    = 23U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai0RxSyncOutToTimer4Trigger    = 24U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToTimer4Trigger          = 25U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToTimer4Trigger          = 26U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToTimer4Trigger          = 27U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToTimer4Trigger          = 28U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToTimer4Trigger          = 29U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToTimer4Trigger     = 30U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToTimer4Trigger     = 31U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToTimer4Trigger     = 32U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToTimer4Trigger     = 33U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToTimer4Trigger     = 34U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToTimer4Trigger     = 35U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToTimer4Trigger     = 36U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToTimer4Trigger     = 37U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToTimer4Trigger  = 38U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToTimer4Trigger  = 39U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToTimer4Trigger        = 40U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToTimer4Trigger        = 41U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToTimer4Trigger        = 42U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToTimer4Trigger        = 43U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToTimer4Trigger        = 44U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToTimer4Trigger        = 45U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToTimer4Trigger        = 46U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToTimer4Trigger        = 47U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig0ToTimer4Trigger = 50U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig1ToTimer4Trigger = 51U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0Trig2ToTimer4Trigger = 52U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig0ToTimer4Trigger = 53U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig1ToTimer4Trigger = 54U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1Trig2ToTimer4Trigger = 55U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig0ToTimer4Trigger = 56U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig1ToTimer4Trigger = 57U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2Trig2ToTimer4Trigger = 58U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig0ToTimer4Trigger = 59U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig1ToTimer4Trigger = 60U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig2ToTimer4Trigger = 61U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3Trig3ToTimer4Trigger = 62U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1TxSyncOutToTimer4Trigger    = 63U + (TIMER4TRIGIN << PMUX_SHIFT),
    kINPUTMUX_Sai1RxSyncOutToTimer4Trigger    = 64U + (TIMER4TRIGIN << PMUX_SHIFT),

    /*!< SMARTDMA arch B inputs. */
    kINPUTMUX_GpioPort0Pin0ToSmartDma       = 0U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin1ToSmartDma       = 1U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin2ToSmartDma       = 2U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin3ToSmartDma       = 3U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin4ToSmartDma       = 4U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin5ToSmartDma       = 5U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin6ToSmartDma       = 6U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin7ToSmartDma       = 7U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin8ToSmartDma       = 8U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin9ToSmartDma       = 9U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin10ToSmartDma      = 10U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin11ToSmartDma      = 11U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin12ToSmartDma      = 12U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin13ToSmartDma      = 13U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin14ToSmartDma      = 14U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin15ToSmartDma      = 15U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToSmartDma             = 16U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SctOut9ToSmartDma             = 17U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_MrtCh0IrqToSmartDma           = 20U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_MrtCh1IrqToSmartDma           = 21U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToSmartDma           = 22U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M2ToSmartDma           = 23U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToSmartDma           = 24U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToSmartDma           = 25U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToSmartDma           = 26U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M2ToSmartDma           = 27U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_UtickIrqToSmartDma            = 28U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Wdt0IrqToSmartDma             = 29U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToSmartDma             = 30U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0IrqToSmartDma             = 31U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LspiHsIrqToSmartDma           = 32U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm7IrqToSmartDma      = 33U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm6IrqToSmartDma      = 34U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm5IrqToSmartDma      = 35U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm4IrqToSmartDma      = 36U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm3IrqToSmartDma      = 37U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm2IrqToSmartDma      = 38U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm1IrqToSmartDma      = 39U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_LpFlexcomm0IrqToSmartDma      = 40U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma0IrqToSmartDma             = 41U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dma1IrqToSmartDma             = 42U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_SysIrqToSmartDma              = 43U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_RtcComboIrqToSmartDma         = 44U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToSmartDma             = 45U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToSmartDma       = 46U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToSmartDma             = 49U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Usb0StartOfFrameIrqToSmartDma = 50U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Usb1StartOfFrameIrqToSmartDma = 51U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_OsEventTimerIrqToSmartDma     = 52U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToSmartDma             = 53U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Cmp012IrqToSmartDma           = 54U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dac0IrqToSmartDma             = 55U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Dac12IrqToSmartDma            = 56U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0IrqToSmartDma             = 57U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1IrqToSmartDma             = 58U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Enc0IrqToSmartDma             = 59U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Enc1IrqToSmartDma             = 60U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToSmartDma           = 61U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToSmartDma           = 62U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Gpio1PinEventTrig0ToSmartDma  = 65U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Gpio1PinEventTrig1ToSmartDma  = 66U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToSmartDma  = 67U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToSmartDma  = 68U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToSmartDma  = 69U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToSmartDma  = 70U + (SMARTDMAARCHB_INMUX0 << PMUX_SHIFT),

    /*!< Pin interrupt select. */
    kINPUTMUX_GpioPort0Pin0ToPintsel  = 0U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin1ToPintsel  = 1U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin2ToPintsel  = 2U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin3ToPintsel  = 3U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin4ToPintsel  = 4U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin5ToPintsel  = 5U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin6ToPintsel  = 6U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin7ToPintsel  = 7U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin8ToPintsel  = 8U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin9ToPintsel  = 9U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin10ToPintsel = 10U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin11ToPintsel = 11U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin12ToPintsel = 12U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin13ToPintsel = 13U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin14ToPintsel = 14U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin15ToPintsel = 15U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin16ToPintsel = 16U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin17ToPintsel = 17U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin18ToPintsel = 18U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin19ToPintsel = 19U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin20ToPintsel = 20U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin21ToPintsel = 21U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin22ToPintsel = 22U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin23ToPintsel = 23U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin24ToPintsel = 24U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin25ToPintsel = 25U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin26ToPintsel = 26U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin27ToPintsel = 27U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin28ToPintsel = 28U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin29ToPintsel = 29U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin30ToPintsel = 30U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin31ToPintsel = 31U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin0ToPintsel  = 32U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin1ToPintsel  = 33U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin2ToPintsel  = 34U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin3ToPintsel  = 35U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin4ToPintsel  = 36U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin5ToPintsel  = 37U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin6ToPintsel  = 38U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin7ToPintsel  = 39U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin8ToPintsel  = 40U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin9ToPintsel  = 41U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin10ToPintsel = 42U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin11ToPintsel = 43U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin12ToPintsel = 44U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin13ToPintsel = 45U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin14ToPintsel = 46U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin15ToPintsel = 47U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin16ToPintsel = 48U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin17ToPintsel = 49U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin18ToPintsel = 50U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin19ToPintsel = 51U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin20ToPintsel = 52U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin21ToPintsel = 53U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin22ToPintsel = 54U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin23ToPintsel = 55U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin30ToPintsel = 62U + (PINTSEL0 << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin31ToPintsel = 63U + (PINTSEL0 << PMUX_SHIFT),

    /*!< Selection for frequency measurement reference clock. */
    kINPUTMUX_ClkInToFreqmeasRef        = 0U + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_Fro12MToFreqmeasRef       = 1u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_Fro144MToFreqmeasRef      = 2u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_Osc32KToFreqmeasRef       = 4u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_CpuAhbClkToFreqmeasRef    = 5u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_FreqmeClkIn0ToFreqmeasRef = 6u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_FreqmeClkIn1ToFreqmeasRef = 7u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFreqmeasRef    = 8u + (FREQMEAS_REF_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFreqmeasRef    = 9u + (FREQMEAS_REF_REG << PMUX_SHIFT),

    /*!< Selection for frequency measurement target clock. */
    kINPUTMUX_ClkInToFreqmeasTar        = 0U + (FREQMEAS_TAR_REG << PMUX_SHIFT),
    kINPUTMUX_Fro12MToFreqmeasTar       = 1u + (FREQMEAS_TAR_REG << PMUX_SHIFT),
    kINPUTMUX_Fro144MToFreqmeasTar      = 2u + (FREQMEAS_TAR_REG << PMUX_SHIFT),
    kINPUTMUX_Osc32KToFreqmeasTar       = 4u + (FREQMEAS_TAR_REG << PMUX_SHIFT),
    kINPUTMUX_CpuAhbClkToFreqmeasTar    = 5u + (FREQMEAS_TAR_REG << PMUX_SHIFT),
    kINPUTMUX_FreqmeClkIn0ToFreqmeasTar = 6u + (FREQMEAS_TAR_REG << PMUX_SHIFT),
    kINPUTMUX_FreqmeClkIn1ToFreqmeasTar = 7u + (FREQMEAS_TAR_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFreqmeasTar    = 8u + (FREQMEAS_TAR_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFreqmeasTar    = 9u + (FREQMEAS_TAR_REG << PMUX_SHIFT),

    /*!< Cmp0 Trigger. */
    kINPUTMUX_PinInt0ToCmp0Trigger            = 0U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt6ToCmp0Trigger            = 1U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToCmp0Trigger            = 2U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToCmp0Trigger            = 3U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut6ToCmp0Trigger            = 4U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToCmp0Trigger          = 5U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToCmp0Trigger          = 6U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToCmp0Trigger          = 7U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToCmp0Trigger          = 8U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToCmp0Trigger          = 9U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToCmp0Trigger            = 11U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToCmp0Trigger      = 12U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToCmp0Trigger         = 13U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToCmp0Trigger         = 14U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToCmp0Trigger       = 17U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToCmp0Trigger       = 18U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToCmp0Trigger       = 19U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToCmp0Trigger       = 20U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToCmp0Trigger       = 21U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToCmp0Trigger       = 22U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToCmp0Trigger       = 23U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToCmp0Trigger       = 24U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToCmp0Trigger    = 25U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToCmp0Trigger    = 26U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToCmp0Trigger          = 27U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToCmp0Trigger          = 28U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToCmp0Trigger          = 29U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToCmp0Trigger          = 30U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToCmp0Trigger          = 31U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToCmp0Trigger          = 32U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToCmp0Trigger          = 33U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToCmp0Trigger          = 34U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToCmp0Trigger             = 35U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToCmp0Trigger             = 36U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToCmp0Trigger = 37U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToCmp0Trigger = 38U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToCmp0Trigger = 39U + (CMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToCmp0Trigger = 40U + (CMP0_TRIG_REG << PMUX_SHIFT),

    /*!< Cmp1 Trigger. */
    kINPUTMUX_PinInt0ToCmp1Trigger            = 0U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToCmp1Trigger            = 1U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToCmp1Trigger            = 2U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToCmp1Trigger            = 3U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToCmp1Trigger            = 4U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToCmp1Trigger          = 5U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToCmp1Trigger          = 6U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToCmp1Trigger          = 7U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToCmp1Trigger          = 8U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToCmp1Trigger          = 9U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToCmp1Trigger            = 11U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToCmp1Trigger      = 12U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToCmp1Trigger         = 13U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToCmp1Trigger         = 14U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToCmp1Trigger       = 17U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToCmp1Trigger       = 18U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToCmp1Trigger       = 19U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToCmp1Trigger       = 20U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToCmp1Trigger       = 21U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToCmp1Trigger       = 22U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToCmp1Trigger       = 23U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToCmp1Trigger       = 24U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToCmp1Trigger    = 25U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToCmp1Trigger    = 26U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToCmp1Trigger          = 27U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToCmp1Trigger          = 28U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToCmp1Trigger          = 29U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToCmp1Trigger          = 30U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToCmp1Trigger          = 31U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToCmp1Trigger          = 32U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToCmp1Trigger          = 33U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToCmp1Trigger          = 34U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToCmp1Trigger             = 35U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToCmp1Trigger             = 36U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToCmp1Trigger = 37U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToCmp1Trigger = 38U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToCmp1Trigger = 39U + (CMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToCmp1Trigger = 40U + (CMP1_TRIG_REG << PMUX_SHIFT),

    /*!< Cmp2 Trigger. */
    kINPUTMUX_PinInt0ToCmp2Trigger            = 0U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToCmp2Trigger            = 1U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToCmp2Trigger            = 2U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToCmp2Trigger            = 3U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToCmp2Trigger            = 4U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToCmp2Trigger          = 5U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToCmp2Trigger          = 6U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToCmp2Trigger          = 7U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToCmp2Trigger          = 8U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M2ToCmp2Trigger          = 9U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToCmp2Trigger            = 11U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToCmp2Trigger      = 12U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToCmp2Trigger         = 13U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToCmp2Trigger         = 14U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToCmp2Trigger       = 17U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToCmp2Trigger       = 18U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToCmp2Trigger       = 19U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToCmp2Trigger       = 20U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToCmp2Trigger       = 21U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToCmp2Trigger       = 22U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToCmp2Trigger       = 23U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToCmp2Trigger       = 24U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToCmp2Trigger    = 25U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToCmp2Trigger    = 26U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToCmp2Trigger          = 27U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToCmp2Trigger          = 28U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToCmp2Trigger          = 29U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToCmp2Trigger          = 30U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToCmp2Trigger          = 31U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToCmp2Trigger          = 32U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToCmp2Trigger          = 33U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToCmp2Trigger          = 34U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToCmp2Trigger             = 35U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToCmp2Trigger             = 36U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToCmp2Trigger = 37U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToCmp2Trigger = 38U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToCmp2Trigger = 39U + (CMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToCmp2Trigger = 40U + (CMP2_TRIG_REG << PMUX_SHIFT),

    /*!< Adc0 Trigger. */
    kINPUTMUX_PinInt0ToAdc0Trigger            = 0U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToAdc0Trigger            = 1U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToAdc0Trigger            = 2U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToAdc0Trigger            = 3U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut9ToAdc0Trigger            = 4U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToAdc0Trigger          = 5U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToAdc0Trigger          = 6U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToAdc0Trigger          = 7U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToAdc0Trigger          = 8U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToAdc0Trigger          = 9U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_DcdcBurstDoneTrigToAdc0Trigger  = 10U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToAdc0Trigger            = 11U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToAdc0Trigger      = 12U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToAdc0Trigger         = 13U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToAdc0Trigger         = 14U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToAdc0Trigger         = 15U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToAdc0Trigger         = 16U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToAdc0Trigger         = 17U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToAdc0Trigger         = 18U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToAdc0Trigger         = 19U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToAdc0Trigger         = 20U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToAdc0Trigger            = 21U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToAdc0Trigger            = 22U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToAdc0Trigger            = 23U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig0ToAdc0Trigger        = 24U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig1ToAdc0Trigger        = 25U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig0ToAdc0Trigger        = 26U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig1ToAdc0Trigger        = 27U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig0ToAdc0Trigger        = 28U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig1ToAdc0Trigger        = 29U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig0ToAdc0Trigger        = 30U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig1ToAdc0Trigger        = 31U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToAdc0Trigger        = 32U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToAdc0Trigger        = 33U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToAdc0Trigger        = 34U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToAdc0Trigger        = 35U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToAdc0Trigger        = 36U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToAdc0Trigger        = 37U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToAdc0Trigger        = 38U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToAdc0Trigger        = 39U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToAdc0Trigger    = 40U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToAdc0Trigger    = 41U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToAdc0Trigger          = 42U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToAdc0Trigger          = 43U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToAdc0Trigger          = 44U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToAdc0Trigger          = 45U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToAdc0Trigger          = 46U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToAdc0Trigger          = 47U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToAdc0Trigger          = 48U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToAdc0Trigger          = 49U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToAdc0Trigger             = 50U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToAdc0Trigger             = 51U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_FlexioCh0ToAdc0Trigger          = 52U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_FlexioCh1ToAdc0Trigger          = 53U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_FlexioCh2ToAdc0Trigger          = 54U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_FlexioCh3ToAdc0Trigger          = 55U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToAdc0Trigger      = 56U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToAdc0Trigger      = 57U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToAdc0Trigger      = 58U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToAdc0Trigger      = 59U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToAdc0Trigger      = 60U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToAdc0Trigger = 61U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToAdc0Trigger = 62U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToAdc0Trigger = 63U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToAdc0Trigger = 64U + (ADC0_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_WuuToAdc0Trigger                = 65U + (ADC0_TRIG0 << PMUX_SHIFT),

    /*!< Adc1 Trigger. */
    kINPUTMUX_PinInt0ToAdc1Trigger            = 0U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToAdc1Trigger            = 1U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToAdc1Trigger            = 2U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToAdc1Trigger            = 3U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToAdc1Trigger            = 4U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToAdc1Trigger          = 5U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToAdc1Trigger          = 6U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToAdc1Trigger          = 7U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToAdc1Trigger          = 8U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToAdc1Trigger          = 9U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_DcdcBurstDoneTrigToAdc1Trigger  = 10U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToAdc1Trigger            = 11U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToAdc1Trigger      = 12U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToAdc1Trigger         = 13U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToAdc1Trigger         = 14U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToAdc1Trigger         = 15U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToAdc1Trigger         = 16U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToAdc1Trigger         = 17U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToAdc1Trigger         = 18U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToAdc1Trigger         = 19U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToAdc1Trigger         = 20U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToAdc1Trigger            = 21U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToAdc1Trigger            = 22U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToAdc1Trigger            = 23U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig0ToAdc1Trigger        = 24U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig1ToAdc1Trigger        = 25U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig0ToAdc1Trigger        = 26U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig1ToAdc1Trigger        = 27U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig0ToAdc1Trigger        = 28U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig1ToAdc1Trigger        = 29U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig0ToAdc1Trigger        = 30U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig1ToAdc1Trigger        = 31U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToAdc1Trigger        = 32U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToAdc1Trigger        = 33U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToAdc1Trigger        = 34U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToAdc1Trigger        = 35U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToAdc1Trigger        = 36U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToAdc1Trigger        = 37U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToAdc1Trigger        = 38U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToAdc1Trigger        = 39U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToAdc1Trigger    = 40U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToAdc1Trigger    = 41U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToAdc1Trigger          = 42U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToAdc1Trigger          = 43U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToAdc1Trigger          = 44U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToAdc1Trigger          = 45U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToAdc1Trigger          = 46U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToAdc1Trigger          = 47U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToAdc1Trigger          = 48U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToAdc1Trigger          = 49U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToAdc1Trigger             = 50U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToAdc1Trigger             = 51U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_FlexioCh0ToAdc1Trigger          = 52U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_FlexioCh1ToAdc1Trigger          = 53U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_FlexioCh2ToAdc1Trigger          = 54U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_FlexioCh3ToAdc1Trigger          = 55U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToAdc1Trigger      = 56U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToAdc1Trigger      = 57U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToAdc1Trigger      = 58U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToAdc1Trigger      = 59U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToAdc1Trigger      = 60U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToAdc1Trigger = 61U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToAdc1Trigger = 62U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToAdc1Trigger = 63U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToAdc1Trigger = 64U + (ADC1_TRIG0 << PMUX_SHIFT),
    kINPUTMUX_WuuToAdc1Trigger                = 65U + (ADC1_TRIG0 << PMUX_SHIFT),

    /*!< Dac0 Trigger. */
    kINPUTMUX_PinInt0ToDac0Trigger            = 0U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt3ToDac0Trigger            = 1U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToDac0Trigger            = 2U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToDac0Trigger            = 3U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToDac0Trigger            = 4U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToDac0Trigger          = 5U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToDac0Trigger          = 6U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToDac0Trigger          = 7U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToDac0Trigger          = 8U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToDac0Trigger          = 9U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToDac0Trigger            = 11U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToDac0Trigger      = 12U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToDac0Trigger         = 13U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToDac0Trigger         = 14U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToDac0Trigger            = 15U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToDac0Trigger            = 16U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToDac0Trigger            = 17U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToDac0Trigger          = 18U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToDac0Trigger          = 19U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToDac0Trigger          = 20U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToDac0Trigger          = 21U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToDac0Trigger          = 22U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToDac0Trigger          = 23U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToDac0Trigger          = 24U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToDac0Trigger          = 25U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToDac0Trigger             = 26U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToDac0Trigger             = 27U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToDac0Trigger = 28U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToDac0Trigger = 29U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToDac0Trigger = 30U + (DAC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToDac0Trigger = 31U + (DAC0_TRIG_REG << PMUX_SHIFT),

    /*!< Dac1 Trigger. */
    kINPUTMUX_PinInt0ToDac1Trigger            = 0U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToDac1Trigger            = 1U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToDac1Trigger            = 2U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToDac1Trigger            = 3U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToDac1Trigger            = 4U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToDac1Trigger          = 5U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToDac1Trigger          = 6U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToDac1Trigger          = 7U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToDac1Trigger          = 8U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToDac1Trigger          = 9U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToDac1Trigger            = 11U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToDac1Trigger      = 12U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToDac1Trigger         = 13U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToDac1Trigger         = 14U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToDac1Trigger            = 15U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToDac1Trigger            = 16U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToDac1Trigger            = 17U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToDac1Trigger          = 18U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToDac1Trigger          = 19U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToDac1Trigger          = 20U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToDac1Trigger          = 21U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToDac1Trigger          = 22U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToDac1Trigger          = 23U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToDac1Trigger          = 24U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToDac1Trigger          = 25U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToDac1Trigger             = 26U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToDac1Trigger             = 27U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToDac1Trigger = 28U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToDac1Trigger = 29U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToDac1Trigger = 30U + (DAC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToDac1Trigger = 31U + (DAC1_TRIG_REG << PMUX_SHIFT),

    /*!< Dac2 Trigger. */
    kINPUTMUX_PinInt0ToDac2Trigger            = 0U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToDac2Trigger            = 1U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToDac2Trigger            = 2U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToDac2Trigger            = 3U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToDac2Trigger            = 4U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToDac2Trigger          = 5U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToDac2Trigger          = 6U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToDac2Trigger          = 7U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M2ToDac2Trigger          = 8U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToDac2Trigger          = 9U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToDac2Trigger            = 11U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToDac2Trigger      = 12U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToDac2Trigger         = 13U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToDac2Trigger         = 14U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToDac2Trigger            = 15U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToDac2Trigger            = 16U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToDac2Trigger            = 17U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToDac2Trigger          = 18U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToDac2Trigger          = 19U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToDac2Trigger          = 20U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToDac2Trigger          = 21U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToDac2Trigger          = 22U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToDac2Trigger          = 23U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToDac2Trigger          = 24U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToDac2Trigger          = 25U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToDac2Trigger             = 26U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToDac2Trigger             = 27U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToDac2Trigger = 28U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToDac2Trigger = 29U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToDac2Trigger = 30U + (DAC2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToDac2Trigger = 31U + (DAC2_TRIG_REG << PMUX_SHIFT),

    /*!< ENC0 Trigger Input Connections. */
    kINPUTMUX_PinInt0ToEnc0Trigger         = 0U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Trigger         = 1U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Trigger         = 2U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Trigger         = 3U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Trigger         = 4U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Trigger       = 5U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Trigger       = 6U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Trigger       = 7U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Trigger       = 8U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Trigger       = 9U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Trigger         = 11U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc0Trigger   = 12U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Trigger      = 13U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Trigger      = 14U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Trigger      = 15U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Trigger      = 16U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Trigger      = 17U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Trigger      = 18U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Trigger      = 19U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Trigger      = 20U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc0Trigger         = 21U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc0Trigger         = 22U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc0Trigger         = 23U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc0Trigger     = 24U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc0Trigger     = 25U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc0Trigger     = 26U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc0Trigger     = 27U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc0Trigger     = 28U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc0Trigger     = 29U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc0Trigger     = 30U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc0Trigger     = 31U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Trigger = 32U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Trigger = 33U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc0Trigger       = 34U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc0Trigger       = 35U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc0Trigger       = 36U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc0Trigger       = 37U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc0Trigger       = 38U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc0Trigger       = 39U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc0Trigger       = 40U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc0Trigger       = 41U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc0Trigger         = 42U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc0Trigger         = 43U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc0Trigger         = 44U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc0Trigger         = 45U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc0Trigger         = 46U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc0Trigger         = 47U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc0Trigger         = 48U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc0Trigger         = 49U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc0Trigger         = 50U + (ENC0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc0Trigger         = 51U + (ENC0_TRIG_REG << PMUX_SHIFT),

    /*!< ENC0 Home Input Connections. */
    kINPUTMUX_PinInt0ToEnc0Home         = 0U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Home         = 1U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Home         = 2U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Home         = 3U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Home         = 4U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Home       = 5U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Home       = 6U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Home       = 7U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Home       = 8U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Home       = 9U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Home         = 11U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc0Home   = 12U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Home      = 13U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Home      = 14U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Home      = 15U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Home      = 16U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Home      = 17U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Home      = 18U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Home      = 19U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Home      = 20U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc0Home         = 21U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc0Home         = 22U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc0Home         = 23U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc0Home     = 24U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc0Home     = 25U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc0Home     = 26U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc0Home     = 27U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc0Home     = 28U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc0Home     = 29U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc0Home     = 30U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc0Home     = 31U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Home = 32U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Home = 33U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc0Home       = 34U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc0Home       = 35U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc0Home       = 36U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc0Home       = 37U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc0Home       = 38U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc0Home       = 39U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc0Home       = 40U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc0Home       = 41U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc0Home         = 42U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc0Home         = 43U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc0Home         = 44U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc0Home         = 45U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc0Home         = 46U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc0Home         = 47U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc0Home         = 48U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc0Home         = 49U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc0Home         = 50U + (ENC0_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc0Home         = 51U + (ENC0_HOME_REG << PMUX_SHIFT),

    /*!< ENC0 Index Input Connections. */
    kINPUTMUX_PinInt0ToEnc0Index         = 0U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Index         = 1U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Index         = 2U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Index         = 3U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Index         = 4U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Index       = 5U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Index       = 6U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Index       = 7U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Index       = 8U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Index       = 9U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Index         = 11U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc0Index   = 12U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Index      = 13U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Index      = 14U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Index      = 15U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Index      = 16U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Index      = 17U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Index      = 18U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Index      = 19U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Index      = 20U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc0Index         = 21U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc0Index         = 22U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc0Index         = 23U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc0Index     = 24U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc0Index     = 25U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc0Index     = 26U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc0Index     = 27U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc0Index     = 28U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc0Index     = 29U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc0Index     = 30U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc0Index     = 31U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Index = 32U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Index = 33U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc0Index       = 34U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc0Index       = 35U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc0Index       = 36U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc0Index       = 37U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc0Index       = 38U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc0Index       = 39U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc0Index       = 40U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc0Index       = 41U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc0Index         = 42U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc0Index         = 43U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc0Index         = 44U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc0Index         = 45U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc0Index         = 46U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc0Index         = 47U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc0Index         = 48U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc0Index         = 49U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc0Index         = 50U + (ENC0_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc0Index         = 51U + (ENC0_INDEX_REG << PMUX_SHIFT),

    /*!< ENC0 Phaseb Input Connections. */
    kINPUTMUX_PinInt0ToEnc0Phaseb         = 0U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Phaseb         = 1U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Phaseb         = 2U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Phaseb         = 3U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Phaseb         = 4U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Phaseb       = 5U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Phaseb       = 6U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Phaseb       = 7U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Phaseb       = 8U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Phaseb       = 9U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Phaseb         = 11U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc0Phaseb   = 12U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Phaseb      = 13U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Phaseb      = 14U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Phaseb      = 15U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Phaseb      = 16U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Phaseb      = 17U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Phaseb      = 18U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Phaseb      = 19U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Phaseb      = 20U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc0Phaseb         = 21U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc0Phaseb         = 22U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc0Phaseb         = 23U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc0Phaseb     = 24U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc0Phaseb     = 25U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc0Phaseb     = 26U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc0Phaseb     = 27U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc0Phaseb     = 28U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc0Phaseb     = 29U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc0Phaseb     = 30U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc0Phaseb     = 31U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Phaseb = 32U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Phaseb = 33U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc0Phaseb       = 34U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc0Phaseb       = 35U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc0Phaseb       = 36U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc0Phaseb       = 37U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc0Phaseb       = 38U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc0Phaseb       = 39U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc0Phaseb       = 40U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc0Phaseb       = 41U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc0Phaseb         = 42U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc0Phaseb         = 43U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc0Phaseb         = 44U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc0Phaseb         = 45U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc0Phaseb         = 46U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc0Phaseb         = 47U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc0Phaseb         = 48U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc0Phaseb         = 49U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc0Phaseb         = 50U + (ENC0_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc0Phaseb         = 51U + (ENC0_PHASEB_REG << PMUX_SHIFT),

    /*!< ENC0 Phasea Input Connections. */
    kINPUTMUX_PinInt0ToEnc0Phasea         = 0U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt4ToEnc0Phasea         = 1U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc0Phasea         = 2U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc0Phasea         = 3U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc0Phasea         = 4U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc0Phasea       = 5U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc0Phasea       = 6U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc0Phasea       = 7U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToEnc0Phasea       = 8U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToEnc0Phasea       = 9U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc0Phasea         = 11U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc0Phasea   = 12U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc0Phasea      = 13U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc0Phasea      = 14U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc0Phasea      = 15U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc0Phasea      = 16U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc0Phasea      = 17U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc0Phasea      = 18U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc0Phasea      = 19U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc0Phasea      = 20U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc0Phasea         = 21U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc0Phasea         = 22U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc0Phasea         = 23U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc0Phasea     = 24U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc0Phasea     = 25U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc0Phasea     = 26U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc0Phasea     = 27U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc0Phasea     = 28U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc0Phasea     = 29U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc0Phasea     = 30U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc0Phasea     = 31U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc0Phasea = 32U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc0Phasea = 33U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc0Phasea       = 34U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc0Phasea       = 35U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc0Phasea       = 36U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc0Phasea       = 37U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc0Phasea       = 38U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc0Phasea       = 39U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc0Phasea       = 40U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc0Phasea       = 41U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc0Phasea         = 42U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc0Phasea         = 43U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc0Phasea         = 44U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc0Phasea         = 45U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc0Phasea         = 46U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc0Phasea         = 47U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc0Phasea         = 48U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc0Phasea         = 49U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc0Phasea         = 50U + (ENC0_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc0Phasea         = 51U + (ENC0_PHASEA_REG << PMUX_SHIFT),

    /*!< ENC1 Trigger Input Connections. */
    kINPUTMUX_PinInt0ToEnc1Trigger         = 0U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Trigger         = 1U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Trigger         = 2U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Trigger         = 3U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc1Trigger         = 4U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Trigger       = 5U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Trigger       = 6U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Trigger       = 7U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Trigger       = 8U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Trigger       = 9U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Trigger         = 11U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc1Trigger   = 12U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Trigger      = 13U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Trigger      = 14U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Trigger      = 15U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Trigger      = 16U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Trigger      = 17U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Trigger      = 18U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Trigger      = 19U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Trigger      = 20U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc1Trigger         = 21U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc1Trigger         = 22U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc1Trigger         = 23U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc1Trigger     = 24U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc1Trigger     = 25U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc1Trigger     = 26U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc1Trigger     = 27U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc1Trigger     = 28U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc1Trigger     = 29U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc1Trigger     = 30U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc1Trigger     = 31U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Trigger = 32U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Trigger = 33U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc1Trigger       = 34U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc1Trigger       = 35U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc1Trigger       = 36U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc1Trigger       = 37U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc1Trigger       = 38U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc1Trigger       = 39U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc1Trigger       = 40U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc1Trigger       = 41U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc1Trigger         = 42U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc1Trigger         = 43U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc1Trigger         = 44U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc1Trigger         = 45U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc1Trigger         = 46U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc1Trigger         = 47U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc1Trigger         = 48U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc1Trigger         = 49U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc1Trigger         = 50U + (ENC1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc1Trigger         = 51U + (ENC1_TRIG_REG << PMUX_SHIFT),

    /*!< ENC1 Home Input Connections. */
    kINPUTMUX_PinInt0ToEnc1Home         = 0U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Home         = 1U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Home         = 2U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Home         = 3U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc1Home         = 4U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Home       = 5U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Home       = 6U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Home       = 7U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Home       = 8U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Home       = 9U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Home         = 11U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc1Home   = 12U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Home      = 13U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Home      = 14U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Home      = 15U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Home      = 16U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Home      = 17U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Home      = 18U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Home      = 19U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Home      = 20U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc1Home         = 21U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc1Home         = 22U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc1Home         = 23U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc1Home     = 24U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc1Home     = 25U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc1Home     = 26U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc1Home     = 27U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc1Home     = 28U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc1Home     = 29U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc1Home     = 30U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc1Home     = 31U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Home = 32U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Home = 33U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc1Home       = 34U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc1Home       = 35U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc1Home       = 36U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc1Home       = 37U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc1Home       = 38U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc1Home       = 39U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc1Home       = 40U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc1Home       = 41U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc1Home         = 42U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc1Home         = 43U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc1Home         = 44U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc1Home         = 45U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc1Home         = 46U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc1Home         = 47U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc1Home         = 48U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc1Home         = 49U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc1Home         = 50U + (ENC1_HOME_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc1Home         = 51U + (ENC1_HOME_REG << PMUX_SHIFT),

    /*!< ENC1 Index Input Connections. */
    kINPUTMUX_PinInt0ToEnc1Index         = 0U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Index         = 1U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Index         = 2U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Index         = 3U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc1Index         = 4U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Index       = 5U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Index       = 6U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Index       = 7U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Index       = 8U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Index       = 9U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Index         = 11U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc1Index   = 12U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Index      = 13U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Index      = 14U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Index      = 15U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Index      = 16U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Index      = 17U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Index      = 18U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Index      = 19U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Index      = 20U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc1Index         = 21U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc1Index         = 22U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc1Index         = 23U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc1Index     = 24U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc1Index     = 25U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc1Index     = 26U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc1Index     = 27U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc1Index     = 28U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc1Index     = 29U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc1Index     = 30U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc1Index     = 31U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Index = 32U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Index = 33U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc1Index       = 34U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc1Index       = 35U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc1Index       = 36U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc1Index       = 37U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc1Index       = 38U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc1Index       = 39U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc1Index       = 40U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc1Index       = 41U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc1Index         = 42U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc1Index         = 43U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc1Index         = 44U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc1Index         = 45U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc1Index         = 46U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc1Index         = 47U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc1Index         = 48U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc1Index         = 49U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc1Index         = 50U + (ENC1_INDEX_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc1Index         = 51U + (ENC1_INDEX_REG << PMUX_SHIFT),

    /*!< ENC1 Phaseb Input Connections. */
    kINPUTMUX_PinInt0ToEnc1Phaseb         = 0U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Phaseb         = 1U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Phaseb         = 2U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Phaseb         = 3U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc1Phaseb         = 4U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Phaseb       = 5U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Phaseb       = 6U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Phaseb       = 7U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Phaseb       = 8U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Phaseb       = 9U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Phaseb         = 11U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc1Phaseb   = 12U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Phaseb      = 13U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Phaseb      = 14U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Phaseb      = 15U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Phaseb      = 16U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Phaseb      = 17U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Phaseb      = 18U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Phaseb      = 19U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Phaseb      = 20U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc1Phaseb         = 21U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc1Phaseb         = 22U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc1Phaseb         = 23U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc1Phaseb     = 24U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc1Phaseb     = 25U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc1Phaseb     = 26U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc1Phaseb     = 27U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc1Phaseb     = 28U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc1Phaseb     = 29U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc1Phaseb     = 30U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc1Phaseb     = 31U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Phaseb = 32U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Phaseb = 33U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc1Phaseb       = 34U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc1Phaseb       = 35U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc1Phaseb       = 36U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc1Phaseb       = 37U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc1Phaseb       = 38U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc1Phaseb       = 39U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc1Phaseb       = 40U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc1Phaseb       = 41U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc1Phaseb         = 42U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc1Phaseb         = 43U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc1Phaseb         = 44U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc1Phaseb         = 45U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc1Phaseb         = 46U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc1Phaseb         = 47U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc1Phaseb         = 48U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc1Phaseb         = 49U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc1Phaseb         = 50U + (ENC1_PHASEB_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc1Phaseb         = 51U + (ENC1_PHASEB_REG << PMUX_SHIFT),

    /*!< ENC1 Phasea Input Connections. */
    kINPUTMUX_PinInt0ToEnc1Phasea         = 0U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToEnc1Phasea         = 1U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToEnc1Phasea         = 2U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToEnc1Phasea         = 3U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEnc1Phasea         = 4U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEnc1Phasea       = 5U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEnc1Phasea       = 6U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEnc1Phasea       = 7U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToEnc1Phasea       = 8U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToEnc1Phasea       = 9U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToEnc1Phasea         = 11U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEnc1Phasea   = 12U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEnc1Phasea      = 13U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEnc1Phasea      = 14U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEnc1Phasea      = 15U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEnc1Phasea      = 16U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEnc1Phasea      = 17U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEnc1Phasea      = 18U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEnc1Phasea      = 19U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEnc1Phasea      = 20U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEnc1Phasea         = 21U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEnc1Phasea         = 22U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEnc1Phasea         = 23U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEnc1Phasea     = 24U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEnc1Phasea     = 25U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEnc1Phasea     = 26U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEnc1Phasea     = 27U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEnc1Phasea     = 28U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEnc1Phasea     = 29U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEnc1Phasea     = 30U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEnc1Phasea     = 31U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEnc1Phasea = 32U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEnc1Phasea = 33U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToEnc1Phasea       = 34U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToEnc1Phasea       = 35U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToEnc1Phasea       = 36U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToEnc1Phasea       = 37U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToEnc1Phasea       = 38U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToEnc1Phasea       = 39U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToEnc1Phasea       = 40U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToEnc1Phasea       = 41U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEnc1Phasea         = 42U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEnc1Phasea         = 43U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEnc1Phasea         = 44U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEnc1Phasea         = 45U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToEnc1Phasea         = 46U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToEnc1Phasea         = 47U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToEnc1Phasea         = 48U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToEnc1Phasea         = 49U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToEnc1Phasea         = 50U + (ENC1_PHASEA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToEnc1Phasea         = 51U + (ENC1_PHASEA_REG << PMUX_SHIFT),

    /*!< FlexPWM0_SM0_EXTSYNC input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Sm0ExtSync            = 0U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Sm0ExtSync            = 1U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Sm0ExtSync            = 2U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Sm0ExtSync            = 3U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Sm0ExtSync            = 4U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Sm0ExtSync          = 5U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Sm0ExtSync          = 6U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Sm0ExtSync          = 7U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Sm0ExtSync          = 8U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Sm0ExtSync          = 9U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Sm0ExtSync            = 11U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Sm0ExtSync      = 12U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Sm0ExtSync         = 13U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Sm0ExtSync         = 14U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Sm0ExtSync         = 15U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Sm0ExtSync         = 16U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Sm0ExtSync         = 17U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Sm0ExtSync         = 18U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Sm0ExtSync         = 19U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Sm0ExtSync         = 20U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Sm0ExtSync            = 21U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Sm0ExtSync            = 22U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Sm0ExtSync            = 23U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Sm0ExtSync        = 24U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Sm0ExtSync        = 25U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Sm0ExtSync        = 26U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Sm0ExtSync        = 27U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Sm0ExtSync        = 28U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Sm0ExtSync        = 29U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Sm0ExtSync        = 30U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Sm0ExtSync        = 31U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Sm0ExtSync    = 32U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Sm0ExtSync    = 33U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Sm0ExtSync          = 34U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Sm0ExtSync          = 35U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Sm0ExtSync          = 36U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Sm0ExtSync          = 37U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Sm0ExtSync          = 38U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Sm0ExtSync          = 39U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Sm0ExtSync          = 40U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Sm0ExtSync          = 41U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Sm0ExtSync            = 42U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Sm0ExtSync            = 43U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Sm0ExtSync            = 44U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Sm0ExtSync            = 45U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Sm0ExtSync            = 46U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Sm0ExtSync            = 47U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Sm0ExtSync            = 48U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Sm0ExtSync            = 49U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Sm0ExtSync            = 50U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Sm0ExtSync            = 51U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Sm0ExtSync      = 52U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Sm0ExtSync      = 53U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Sm0ExtSync      = 54U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Sm0ExtSync      = 55U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Sm0ExtSync      = 56U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Sm0ExtSync = 57U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Sm0ExtSync = 58U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Sm0ExtSync = 59U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Sm0ExtSync = 60U + (FlexPWM0_SM0_EXTSYNC_REG << PMUX_SHIFT),

    /*!< FlexPWM0_SM1_EXTSYNC input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Sm1ExtSync            = 0U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Sm1ExtSync            = 1U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Sm1ExtSync            = 2U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Sm1ExtSync            = 3U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Sm1ExtSync            = 4U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Sm1ExtSync          = 5U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Sm1ExtSync          = 6U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Sm1ExtSync          = 7U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Sm1ExtSync          = 8U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Sm1ExtSync          = 9U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Sm1ExtSync            = 11U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Sm1ExtSync      = 12U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Sm1ExtSync         = 13U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Sm1ExtSync         = 14U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Sm1ExtSync         = 15U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Sm1ExtSync         = 16U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Sm1ExtSync         = 17U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Sm1ExtSync         = 18U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Sm1ExtSync         = 19U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Sm1ExtSync         = 20U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Sm1ExtSync            = 21U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Sm1ExtSync            = 22U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Sm1ExtSync            = 23U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Sm1ExtSync        = 24U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Sm1ExtSync        = 25U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Sm1ExtSync        = 26U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Sm1ExtSync        = 27U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Sm1ExtSync        = 28U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Sm1ExtSync        = 29U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Sm1ExtSync        = 30U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Sm1ExtSync        = 31U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Sm1ExtSync    = 32U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Sm1ExtSync    = 33U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Sm1ExtSync          = 34U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Sm1ExtSync          = 35U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Sm1ExtSync          = 36U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Sm1ExtSync          = 37U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Sm1ExtSync          = 38U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Sm1ExtSync          = 39U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Sm1ExtSync          = 40U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Sm1ExtSync          = 41U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Sm1ExtSync            = 42U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Sm1ExtSync            = 43U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Sm1ExtSync            = 44U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Sm1ExtSync            = 45U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Sm1ExtSync            = 46U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Sm1ExtSync            = 47U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Sm1ExtSync            = 48U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Sm1ExtSync            = 49U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Sm1ExtSync            = 50U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Sm1ExtSync            = 51U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Sm1ExtSync      = 52U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Sm1ExtSync      = 53U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Sm1ExtSync      = 54U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Sm1ExtSync      = 55U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Sm1ExtSync      = 56U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Sm1ExtSync = 57U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Sm1ExtSync = 58U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Sm1ExtSync = 59U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Sm1ExtSync = 60U + (FlexPWM0_SM1_EXTSYNC_REG << PMUX_SHIFT),

    /*!< FlexPWM0_SM2_EXTSYNC2 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Sm2ExtSync            = 0U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Sm2ExtSync            = 1U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Sm2ExtSync            = 2U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Sm2ExtSync            = 3U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Sm2ExtSync            = 4U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Sm2ExtSync          = 5U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Sm2ExtSync          = 6U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Sm2ExtSync          = 7U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Sm2ExtSync          = 8U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Sm2ExtSync          = 9U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Sm2ExtSync            = 11U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Sm2ExtSync      = 12U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Sm2ExtSync         = 13U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Sm2ExtSync         = 14U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Sm2ExtSync         = 15U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Sm2ExtSync         = 16U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Sm2ExtSync         = 17U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Sm2ExtSync         = 18U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Sm2ExtSync         = 19U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Sm2ExtSync         = 20U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Sm2ExtSync            = 21U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Sm2ExtSync            = 22U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Sm2ExtSync            = 23U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Sm2ExtSync        = 24U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Sm2ExtSync        = 25U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Sm2ExtSync        = 26U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Sm2ExtSync        = 27U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Sm2ExtSync        = 28U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Sm2ExtSync        = 29U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Sm2ExtSync        = 30U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Sm2ExtSync        = 31U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Sm2ExtSync    = 32U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Sm2ExtSync    = 33U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Sm2ExtSync          = 34U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Sm2ExtSync          = 35U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Sm2ExtSync          = 36U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Sm2ExtSync          = 37U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Sm2ExtSync          = 38U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Sm2ExtSync          = 39U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Sm2ExtSync          = 40U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Sm2ExtSync          = 41U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Sm2ExtSync            = 42U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Sm2ExtSync            = 43U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Sm2ExtSync            = 44U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Sm2ExtSync            = 45U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Sm2ExtSync            = 46U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Sm2ExtSync            = 47U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Sm2ExtSync            = 48U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Sm2ExtSync            = 49U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Sm2ExtSync            = 50U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Sm2ExtSync            = 51U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Sm2ExtSync      = 52U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Sm2ExtSync      = 53U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Sm2ExtSync      = 54U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Sm2ExtSync      = 55U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Sm2ExtSync      = 56U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Sm2ExtSync = 57U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Sm2ExtSync = 58U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Sm2ExtSync = 59U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Sm2ExtSync = 60U + (FlexPWM0_SM2_EXTSYNC_REG << PMUX_SHIFT),

    /*!< FlexPWM0_SM3_EXTSYNC input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Sm3ExtSync            = 0U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Sm3ExtSync            = 1U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Sm3ExtSync            = 2U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Sm3ExtSync            = 3U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Sm3ExtSync            = 4U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Sm3ExtSync          = 5U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Sm3ExtSync          = 6U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Sm3ExtSync          = 7U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Sm3ExtSync          = 8U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Sm3ExtSync          = 9U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Sm3ExtSync            = 11U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Sm3ExtSync      = 12U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Sm3ExtSync         = 13U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Sm3ExtSync         = 14U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Sm3ExtSync         = 15U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Sm3ExtSync         = 16U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Sm3ExtSync         = 17U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Sm3ExtSync         = 18U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Sm3ExtSync         = 19U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Sm3ExtSync         = 20U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Sm3ExtSync            = 21U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Sm3ExtSync            = 22U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Sm3ExtSync            = 23U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Sm3ExtSync        = 24U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Sm3ExtSync        = 25U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Sm3ExtSync        = 26U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Sm3ExtSync        = 27U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Sm3ExtSync        = 28U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Sm3ExtSync        = 29U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Sm3ExtSync        = 30U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Sm3ExtSync        = 31U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Sm3ExtSync    = 32U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Sm3ExtSync    = 33U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Sm3ExtSync          = 34U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Sm3ExtSync          = 35U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Sm3ExtSync          = 36U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Sm3ExtSync          = 37U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Sm3ExtSync          = 38U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Sm3ExtSync          = 39U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Sm3ExtSync          = 40U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Sm3ExtSync          = 41U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Sm3ExtSync            = 42U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Sm3ExtSync            = 43U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Sm3ExtSync            = 44U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Sm3ExtSync            = 45U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Sm3ExtSync            = 46U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Sm3ExtSync            = 47U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Sm3ExtSync            = 48U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Sm3ExtSync            = 49U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Sm3ExtSync            = 50U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Sm3ExtSync            = 51U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Sm3ExtSync      = 52U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Sm3ExtSync      = 53U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Sm3ExtSync      = 54U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Sm3ExtSync      = 55U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Sm3ExtSync      = 56U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Sm3ExtSync = 57U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Sm3ExtSync = 58U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Sm3ExtSync = 59U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Sm3ExtSync = 60U + (FlexPWM0_SM3_EXTSYNC_REG << PMUX_SHIFT),

    /*!< FlexPWM0_SM0_EXTA input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Sm0Exta            = 0U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Sm0Exta            = 1U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Sm0Exta            = 2U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Sm0Exta            = 3U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Sm0Exta            = 4U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Sm0Exta          = 5U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Sm0Exta          = 6U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Sm0Exta          = 7U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Sm0Exta          = 8U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Sm0Exta          = 9U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Sm0Exta            = 11U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Sm0Exta      = 12U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Sm0Exta         = 13U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Sm0Exta         = 14U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Sm0Exta         = 15U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Sm0Exta         = 16U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Sm0Exta         = 17U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Sm0Exta         = 18U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Sm0Exta         = 19U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Sm0Exta         = 20U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Sm0Exta            = 21U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Sm0Exta            = 22U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Sm0Exta            = 23U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Sm0Exta        = 24U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Sm0Exta        = 25U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Sm0Exta        = 26U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Sm0Exta        = 27U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Sm0Exta        = 28U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Sm0Exta        = 29U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Sm0Exta        = 30U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Sm0Exta        = 31U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Sm0Exta    = 32U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Sm0Exta    = 33U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Sm0Exta          = 34U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Sm0Exta          = 35U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Sm0Exta          = 36U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Sm0Exta          = 37U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Sm0Exta          = 38U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Sm0Exta          = 39U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Sm0Exta          = 40U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Sm0Exta          = 41U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Sm0Exta            = 42U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Sm0Exta            = 43U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Sm0Exta            = 44U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Sm0Exta            = 45U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Sm0Exta            = 46U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Sm0Exta            = 47U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Sm0Exta            = 48U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Sm0Exta            = 49U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Sm0Exta            = 50U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Sm0Exta            = 51U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Sm0Exta      = 52U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Sm0Exta      = 53U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Sm0Exta      = 54U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Sm0Exta      = 55U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Sm0Exta      = 56U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Sm0Exta = 57U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Sm0Exta = 58U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Sm0Exta = 59U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Sm0Exta = 60U + (FlexPWM0_SM0_EXTA_REG << PMUX_SHIFT),

    /*!< FlexPWM0_SM1_EXTA input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Sm1Exta            = 0U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Sm1Exta            = 1U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Sm1Exta            = 2U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Sm1Exta            = 3U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Sm1Exta            = 4U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Sm1Exta          = 5U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Sm1Exta          = 6U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Sm1Exta          = 7U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Sm1Exta          = 8U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Sm1Exta          = 9U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Sm1Exta            = 11U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Sm1Exta      = 12U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Sm1Exta         = 13U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Sm1Exta         = 14U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Sm1Exta         = 15U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Sm1Exta         = 16U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Sm1Exta         = 17U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Sm1Exta         = 18U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Sm1Exta         = 19U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Sm1Exta         = 20U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Sm1Exta            = 21U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Sm1Exta            = 22U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Sm1Exta            = 23U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Sm1Exta        = 24U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Sm1Exta        = 25U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Sm1Exta        = 26U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Sm1Exta        = 27U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Sm1Exta        = 28U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Sm1Exta        = 29U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Sm1Exta        = 30U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Sm1Exta        = 31U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Sm1Exta    = 32U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Sm1Exta    = 33U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Sm1Exta          = 34U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Sm1Exta          = 35U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Sm1Exta          = 36U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Sm1Exta          = 37U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Sm1Exta          = 38U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Sm1Exta          = 39U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Sm1Exta          = 40U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Sm1Exta          = 41U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Sm1Exta            = 42U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Sm1Exta            = 43U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Sm1Exta            = 44U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Sm1Exta            = 45U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Sm1Exta            = 46U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Sm1Exta            = 47U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Sm1Exta            = 48U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Sm1Exta            = 49U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Sm1Exta            = 50U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Sm1Exta            = 51U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Sm1Exta      = 52U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Sm1Exta      = 53U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Sm1Exta      = 54U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Sm1Exta      = 55U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Sm1Exta      = 56U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Sm1Exta = 57U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Sm1Exta = 58U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Sm1Exta = 59U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Sm1Exta = 60U + (FlexPWM0_SM1_EXTA_REG << PMUX_SHIFT),

    /*!< FlexPWM0_SM2_EXTA input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Sm2Exta            = 0U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Sm2Exta            = 1U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Sm2Exta            = 2U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Sm2Exta            = 3U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Sm2Exta            = 4U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Sm2Exta          = 5U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Sm2Exta          = 6U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Sm2Exta          = 7U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Sm2Exta          = 8U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Sm2Exta          = 9U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Sm2Exta            = 11U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Sm2Exta      = 12U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Sm2Exta         = 13U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Sm2Exta         = 14U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Sm2Exta         = 15U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Sm2Exta         = 16U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Sm2Exta         = 17U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Sm2Exta         = 18U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Sm2Exta         = 19U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Sm2Exta         = 20U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Sm2Exta            = 21U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Sm2Exta            = 22U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Sm2Exta            = 23U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Sm2Exta        = 24U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Sm2Exta        = 25U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Sm2Exta        = 26U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Sm2Exta        = 27U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Sm2Exta        = 28U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Sm2Exta        = 29U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Sm2Exta        = 30U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Sm2Exta        = 31U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Sm2Exta    = 32U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Sm2Exta    = 33U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Sm2Exta          = 34U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Sm2Exta          = 35U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Sm2Exta          = 36U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Sm2Exta          = 37U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Sm2Exta          = 38U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Sm2Exta          = 39U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Sm2Exta          = 40U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Sm2Exta          = 41U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Sm2Exta            = 42U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Sm2Exta            = 43U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Sm2Exta            = 44U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Sm2Exta            = 45U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Sm2Exta            = 46U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Sm2Exta            = 47U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Sm2Exta            = 48U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Sm2Exta            = 49U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Sm2Exta            = 50U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Sm2Exta            = 51U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Sm2Exta      = 52U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Sm2Exta      = 53U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Sm2Exta      = 54U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Sm2Exta      = 55U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Sm2Exta      = 56U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Sm2Exta = 57U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Sm2Exta = 58U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Sm2Exta = 59U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Sm2Exta = 60U + (FlexPWM0_SM2_EXTA_REG << PMUX_SHIFT),

    /*!< FlexPWM0_SM3_EXTA input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Sm3Exta            = 0U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Sm3Exta            = 1U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Sm3Exta            = 2U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Sm3Exta            = 3U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Sm3Exta            = 4U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Sm3Exta          = 5U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Sm3Exta          = 6U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Sm3Exta          = 7U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Sm3Exta          = 8U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Sm3Exta          = 9U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Sm3Exta            = 11U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Sm3Exta      = 12U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Sm3Exta         = 13U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Sm3Exta         = 14U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Sm3Exta         = 15U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Sm3Exta         = 16U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Sm3Exta         = 17U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Sm3Exta         = 18U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Sm3Exta         = 19U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Sm3Exta         = 20U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Sm3Exta            = 21U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Sm3Exta            = 22U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Sm3Exta            = 23U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Sm3Exta        = 24U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Sm3Exta        = 25U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Sm3Exta        = 26U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Sm3Exta        = 27U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Sm3Exta        = 28U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Sm3Exta        = 29U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Sm3Exta        = 30U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Sm3Exta        = 31U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Sm3Exta    = 32U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Sm3Exta    = 33U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Sm3Exta          = 34U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Sm3Exta          = 35U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Sm3Exta          = 36U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Sm3Exta          = 37U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Sm3Exta          = 38U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Sm3Exta          = 39U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Sm3Exta          = 40U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Sm3Exta          = 41U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Sm3Exta            = 42U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Sm3Exta            = 43U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Sm3Exta            = 44U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Sm3Exta            = 45U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Sm3Exta            = 46U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Sm3Exta            = 47U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Sm3Exta            = 48U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Sm3Exta            = 49U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Sm3Exta            = 50U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Sm3Exta            = 51U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Sm3Exta      = 52U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Sm3Exta      = 53U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Sm3Exta      = 54U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Sm3Exta      = 55U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Sm3Exta      = 56U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Sm3Exta = 57U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Sm3Exta = 58U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Sm3Exta = 59U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Sm3Exta = 60U + (FlexPWM0_SM3_EXTA_REG << PMUX_SHIFT),

    /*!< FlexPWM0_EXTFORCE input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0ExtForce            = 0U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0ExtForce            = 1U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0ExtForce            = 2U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0ExtForce            = 3U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0ExtForce            = 4U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0ExtForce          = 5U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0ExtForce          = 6U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0ExtForce          = 7U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0ExtForce          = 8U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0ExtForce          = 9U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0ExtForce            = 11U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0ExtForce      = 12U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0ExtForce         = 13U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0ExtForce         = 14U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0ExtForce         = 15U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0ExtForce         = 16U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0ExtForce         = 17U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0ExtForce         = 18U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0ExtForce         = 19U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0ExtForce         = 20U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0ExtForce            = 21U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0ExtForce            = 22U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0ExtForce            = 23U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0ExtForce        = 24U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0ExtForce        = 25U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0ExtForce        = 26U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0ExtForce        = 27U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0ExtForce        = 28U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0ExtForce        = 29U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0ExtForce        = 30U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0ExtForce        = 31U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0ExtForce    = 32U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0ExtForce    = 33U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0ExtForce          = 34U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0ExtForce          = 35U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0ExtForce          = 36U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0ExtForce          = 37U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0ExtForce          = 38U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0ExtForce          = 39U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0ExtForce          = 40U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0ExtForce          = 41U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0ExtForce            = 42U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0ExtForce            = 43U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0ExtForce            = 44U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0ExtForce            = 45U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0ExtForce            = 46U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0ExtForce            = 47U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0ExtForce            = 48U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0ExtForce            = 49U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0ExtForce            = 50U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0ExtForce            = 51U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0ExtForce      = 52U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0ExtForce      = 53U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0ExtForce      = 54U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0ExtForce      = 55U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0ExtForce      = 56U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0ExtForce = 57U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0ExtForce = 58U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0ExtForce = 59U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0ExtForce = 60U + (FlexPWM0_EXTFORCE_REG << PMUX_SHIFT),

    /*!< FlexPWM0_FAULT0 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Fault0            = 0U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Fault0            = 1U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Fault0            = 2U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Fault0            = 3U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Fault0            = 4U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Fault0          = 5U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Fault0          = 6U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Fault0          = 7U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Fault0          = 8U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Fault0          = 9U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Fault0            = 11U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Fault0      = 12U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Fault0         = 13U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Fault0         = 14U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Fault0         = 15U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Fault0         = 16U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Fault0         = 17U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Fault0         = 18U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Fault0         = 19U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Fault0         = 20U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Fault0            = 21U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Fault0            = 22U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Fault0            = 23U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Fault0        = 24U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Fault0        = 25U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Fault0        = 26U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Fault0        = 27U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Fault0        = 28U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Fault0        = 29U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Fault0        = 30U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Fault0        = 31U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Fault0    = 32U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Fault0    = 33U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Fault0          = 34U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Fault0          = 35U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Fault0          = 36U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Fault0          = 37U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Fault0          = 38U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Fault0          = 39U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Fault0          = 40U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Fault0          = 41U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Fault0            = 42U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Fault0            = 43U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Fault0            = 44U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Fault0            = 45U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Fault0            = 46U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Fault0            = 47U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Fault0            = 48U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Fault0            = 49U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Fault0            = 50U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Fault0            = 51U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Fault0      = 52U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Fault0      = 53U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Fault0      = 54U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Fault0      = 55U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Fault0      = 56U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Fault0 = 57U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Fault0 = 58U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Fault0 = 59U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Fault0 = 60U + (FlexPWM0_FAULT0_REG << PMUX_SHIFT),

    /*!< FlexPWM0_FAULT1 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Fault1            = 0U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Fault1            = 1U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Fault1            = 2U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Fault1            = 3U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Fault1            = 4U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Fault1          = 5U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Fault1          = 6U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Fault1          = 7U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Fault1          = 8U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Fault1          = 9U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Fault1            = 11U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Fault1      = 12U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Fault1         = 13U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Fault1         = 14U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Fault1         = 15U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Fault1         = 16U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Fault1         = 17U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Fault1         = 18U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Fault1         = 19U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Fault1         = 20U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Fault1            = 21U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Fault1            = 22U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Fault1            = 23U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Fault1        = 24U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Fault1        = 25U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Fault1        = 26U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Fault1        = 27U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Fault1        = 28U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Fault1        = 29U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Fault1        = 30U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Fault1        = 31U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Fault1    = 32U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Fault1    = 33U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Fault1          = 34U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Fault1          = 35U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Fault1          = 36U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Fault1          = 37U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Fault1          = 38U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Fault1          = 39U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Fault1          = 40U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Fault1          = 41U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Fault1            = 42U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Fault1            = 43U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Fault1            = 44U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Fault1            = 45U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Fault1            = 46U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Fault1            = 47U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Fault1            = 48U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Fault1            = 49U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Fault1            = 50U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Fault1            = 51U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Fault1      = 52U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Fault1      = 53U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Fault1      = 54U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Fault1      = 55U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Fault1      = 56U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Fault1 = 57U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Fault1 = 58U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Fault1 = 59U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Fault1 = 60U + (FlexPWM0_FAULT1_REG << PMUX_SHIFT),

    /*!< FlexPWM0_FAULT2 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Fault2            = 0U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Fault2            = 1U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Fault2            = 2U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Fault2            = 3U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Fault2            = 4U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Fault2          = 5U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Fault2          = 6U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Fault2          = 7U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Fault2          = 8U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Fault2          = 9U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Fault2            = 11U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Fault2      = 12U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Fault2         = 13U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Fault2         = 14U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Fault2         = 15U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Fault2         = 16U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Fault2         = 17U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Fault2         = 18U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Fault2         = 19U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Fault2         = 20U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Fault2            = 21U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Fault2            = 22U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Fault2            = 23U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Fault2        = 24U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Fault2        = 25U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Fault2        = 26U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Fault2        = 27U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Fault2        = 28U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Fault2        = 29U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Fault2        = 30U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Fault2        = 31U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Fault2    = 32U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Fault2    = 33U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Fault2          = 34U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Fault2          = 35U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Fault2          = 36U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Fault2          = 37U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Fault2          = 38U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Fault2          = 39U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Fault2          = 40U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Fault2          = 41U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Fault2            = 42U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Fault2            = 43U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Fault2            = 44U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Fault2            = 45U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Fault2            = 46U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Fault2            = 47U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Fault2            = 48U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Fault2            = 49U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Fault2            = 50U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Fault2            = 51U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Fault2      = 52U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Fault2      = 53U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Fault2      = 54U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Fault2      = 55U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Fault2      = 56U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Fault2 = 57U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Fault2 = 58U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Fault2 = 59U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Fault2 = 60U + (FlexPWM0_FAULT2_REG << PMUX_SHIFT),

    /*!< FlexPWM0_FAULT3 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm0Fault3            = 0U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexPwm0Fault3            = 1U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm0Fault3            = 2U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm0Fault3            = 3U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm0Fault3            = 4U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm0Fault3          = 5U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm0Fault3          = 6U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm0Fault3          = 7U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexPwm0Fault3          = 8U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexPwm0Fault3          = 9U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm0Fault3            = 11U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm0Fault3      = 12U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm0Fault3         = 13U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm0Fault3         = 14U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm0Fault3         = 15U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm0Fault3         = 16U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm0Fault3         = 17U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm0Fault3         = 18U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm0Fault3         = 19U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm0Fault3         = 20U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm0Fault3            = 21U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm0Fault3            = 22U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm0Fault3            = 23U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm0Fault3        = 24U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm0Fault3        = 25U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm0Fault3        = 26U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm0Fault3        = 27U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm0Fault3        = 28U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm0Fault3        = 29U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm0Fault3        = 30U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm0Fault3        = 31U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm0Fault3    = 32U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm0Fault3    = 33U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm0Fault3          = 34U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm0Fault3          = 35U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm0Fault3          = 36U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm0Fault3          = 37U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm0Fault3          = 38U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm0Fault3          = 39U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm0Fault3          = 40U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm0Fault3          = 41U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm0Fault3            = 42U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm0Fault3            = 43U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm0Fault3            = 44U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm0Fault3            = 45U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm0Fault3            = 46U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm0Fault3            = 47U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm0Fault3            = 48U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm0Fault3            = 49U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm0Fault3            = 50U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm0Fault3            = 51U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm0Fault3      = 52U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm0Fault3      = 53U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm0Fault3      = 54U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm0Fault3      = 55U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm0Fault3      = 56U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm0Fault3 = 57U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm0Fault3 = 58U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm0Fault3 = 59U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm0Fault3 = 60U + (FlexPWM0_FAULT3_REG << PMUX_SHIFT),

    /*!< FlexPWM1_SM0_EXTSYNC input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Sm0ExtSync            = 0U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Sm0ExtSync            = 1U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Sm0ExtSync            = 2U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Sm0ExtSync            = 3U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Sm0ExtSync            = 4U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Sm0ExtSync          = 5U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Sm0ExtSync          = 6U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Sm0ExtSync          = 7U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Sm0ExtSync          = 8U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Sm0ExtSync          = 9U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Sm0ExtSync            = 11U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Sm0ExtSync      = 12U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Sm0ExtSync         = 13U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Sm0ExtSync         = 14U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Sm0ExtSync         = 15U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Sm0ExtSync         = 16U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Sm0ExtSync         = 17U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Sm0ExtSync         = 18U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Sm0ExtSync         = 19U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Sm0ExtSync         = 20U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Sm0ExtSync            = 21U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Sm0ExtSync            = 22U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Sm0ExtSync            = 23U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Sm0ExtSync        = 24U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Sm0ExtSync        = 25U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Sm0ExtSync        = 26U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Sm0ExtSync        = 27U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Sm0ExtSync        = 28U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Sm0ExtSync        = 29U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Sm0ExtSync        = 30U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Sm0ExtSync        = 31U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Sm0ExtSync    = 32U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Sm0ExtSync    = 33U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Sm0ExtSync          = 34U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Sm0ExtSync          = 35U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Sm0ExtSync          = 36U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Sm0ExtSync          = 37U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Sm0ExtSync          = 38U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Sm0ExtSync          = 39U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Sm0ExtSync          = 40U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Sm0ExtSync          = 41U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Sm0ExtSync            = 42U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Sm0ExtSync            = 43U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Sm0ExtSync            = 44U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Sm0ExtSync            = 45U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Sm0ExtSync            = 46U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Sm0ExtSync            = 47U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Sm0ExtSync            = 48U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Sm0ExtSync            = 49U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Sm0ExtSync            = 50U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Sm0ExtSync            = 51U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Sm0ExtSync      = 52U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Sm0ExtSync      = 53U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Sm0ExtSync      = 54U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Sm0ExtSync      = 55U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Sm0ExtSync      = 56U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Sm0ExtSync = 57U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Sm0ExtSync = 58U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Sm0ExtSync = 59U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Sm0ExtSync = 60U + (FlexPWM1_SM0_EXTSYNC_REG << PMUX_SHIFT),

    /*!< FlexPWM1_SM1_EXTSYNC input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Sm1ExtSync            = 0U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Sm1ExtSync            = 1U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Sm1ExtSync            = 2U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Sm1ExtSync            = 3U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Sm1ExtSync            = 4U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Sm1ExtSync          = 5U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Sm1ExtSync          = 6U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Sm1ExtSync          = 7U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Sm1ExtSync          = 8U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Sm1ExtSync          = 9U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Sm1ExtSync            = 11U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Sm1ExtSync      = 12U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Sm1ExtSync         = 13U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Sm1ExtSync         = 14U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Sm1ExtSync         = 15U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Sm1ExtSync         = 16U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Sm1ExtSync         = 17U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Sm1ExtSync         = 18U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Sm1ExtSync         = 19U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Sm1ExtSync         = 20U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Sm1ExtSync            = 21U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Sm1ExtSync            = 22U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Sm1ExtSync            = 23U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Sm1ExtSync        = 24U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Sm1ExtSync        = 25U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Sm1ExtSync        = 26U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Sm1ExtSync        = 27U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Sm1ExtSync        = 28U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Sm1ExtSync        = 29U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Sm1ExtSync        = 30U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Sm1ExtSync        = 31U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Sm1ExtSync    = 32U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Sm1ExtSync    = 33U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Sm1ExtSync          = 34U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Sm1ExtSync          = 35U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Sm1ExtSync          = 36U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Sm1ExtSync          = 37U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Sm1ExtSync          = 38U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Sm1ExtSync          = 39U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Sm1ExtSync          = 40U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Sm1ExtSync          = 41U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Sm1ExtSync            = 42U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Sm1ExtSync            = 43U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Sm1ExtSync            = 44U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Sm1ExtSync            = 45U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Sm1ExtSync            = 46U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Sm1ExtSync            = 47U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Sm1ExtSync            = 48U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Sm1ExtSync            = 49U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Sm1ExtSync            = 50U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Sm1ExtSync            = 51U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Sm1ExtSync      = 52U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Sm1ExtSync      = 53U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Sm1ExtSync      = 54U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Sm1ExtSync      = 55U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Sm1ExtSync      = 56U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Sm1ExtSync = 57U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Sm1ExtSync = 58U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Sm1ExtSync = 59U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Sm1ExtSync = 60U + (FlexPWM1_SM1_EXTSYNC_REG << PMUX_SHIFT),

    /*!< FlexPWM1_SM2_EXTSYNC2 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Sm2ExtSync            = 0U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Sm2ExtSync            = 1U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Sm2ExtSync            = 2U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Sm2ExtSync            = 3U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Sm2ExtSync            = 4U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Sm2ExtSync          = 5U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Sm2ExtSync          = 6U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Sm2ExtSync          = 7U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Sm2ExtSync          = 8U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Sm2ExtSync          = 9U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Sm2ExtSync            = 11U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Sm2ExtSync      = 12U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Sm2ExtSync         = 13U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Sm2ExtSync         = 14U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Sm2ExtSync         = 15U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Sm2ExtSync         = 16U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Sm2ExtSync         = 17U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Sm2ExtSync         = 18U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Sm2ExtSync         = 19U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Sm2ExtSync         = 20U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Sm2ExtSync            = 21U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Sm2ExtSync            = 22U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Sm2ExtSync            = 23U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Sm2ExtSync        = 24U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Sm2ExtSync        = 25U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Sm2ExtSync        = 26U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Sm2ExtSync        = 27U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Sm2ExtSync        = 28U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Sm2ExtSync        = 29U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Sm2ExtSync        = 30U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Sm2ExtSync        = 31U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Sm2ExtSync    = 32U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Sm2ExtSync    = 33U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Sm2ExtSync          = 34U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Sm2ExtSync          = 35U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Sm2ExtSync          = 36U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Sm2ExtSync          = 37U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Sm2ExtSync          = 38U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Sm2ExtSync          = 39U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Sm2ExtSync          = 40U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Sm2ExtSync          = 41U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Sm2ExtSync            = 42U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Sm2ExtSync            = 43U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Sm2ExtSync            = 44U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Sm2ExtSync            = 45U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Sm2ExtSync            = 46U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Sm2ExtSync            = 47U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Sm2ExtSync            = 48U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Sm2ExtSync            = 49U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Sm2ExtSync            = 50U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Sm2ExtSync            = 51U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Sm2ExtSync      = 52U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Sm2ExtSync      = 53U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Sm2ExtSync      = 54U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Sm2ExtSync      = 55U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Sm2ExtSync      = 56U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Sm2ExtSync = 57U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Sm2ExtSync = 58U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Sm2ExtSync = 59U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Sm2ExtSync = 60U + (FlexPWM1_SM2_EXTSYNC_REG << PMUX_SHIFT),

    /*!< FlexPWM1_SM3_EXTSYNC input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Sm3ExtSync            = 0U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Sm3ExtSync            = 1U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Sm3ExtSync            = 2U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Sm3ExtSync            = 3U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Sm3ExtSync            = 4U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Sm3ExtSync          = 5U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Sm3ExtSync          = 6U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Sm3ExtSync          = 7U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Sm3ExtSync          = 8U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Sm3ExtSync          = 9U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Sm3ExtSync            = 11U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Sm3ExtSync      = 12U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Sm3ExtSync         = 13U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Sm3ExtSync         = 14U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Sm3ExtSync         = 15U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Sm3ExtSync         = 16U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Sm3ExtSync         = 17U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Sm3ExtSync         = 18U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Sm3ExtSync         = 19U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Sm3ExtSync         = 20U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Sm3ExtSync            = 21U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Sm3ExtSync            = 22U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Sm3ExtSync            = 23U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Sm3ExtSync        = 24U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Sm3ExtSync        = 25U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Sm3ExtSync        = 26U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Sm3ExtSync        = 27U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Sm3ExtSync        = 28U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Sm3ExtSync        = 29U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Sm3ExtSync        = 30U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Sm3ExtSync        = 31U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Sm3ExtSync    = 32U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Sm3ExtSync    = 33U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Sm3ExtSync          = 34U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Sm3ExtSync          = 35U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Sm3ExtSync          = 36U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Sm3ExtSync          = 37U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Sm3ExtSync          = 38U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Sm3ExtSync          = 39U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Sm3ExtSync          = 40U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Sm3ExtSync          = 41U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Sm3ExtSync            = 42U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Sm3ExtSync            = 43U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Sm3ExtSync            = 44U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Sm3ExtSync            = 45U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Sm3ExtSync            = 46U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Sm3ExtSync            = 47U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Sm3ExtSync            = 48U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Sm3ExtSync            = 49U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Sm3ExtSync            = 50U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Sm3ExtSync            = 51U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Sm3ExtSync      = 52U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Sm3ExtSync      = 53U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Sm3ExtSync      = 54U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Sm3ExtSync      = 55U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Sm3ExtSync      = 56U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Sm3ExtSync = 57U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Sm3ExtSync = 58U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Sm3ExtSync = 59U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Sm3ExtSync = 60U + (FlexPWM1_SM3_EXTSYNC_REG << PMUX_SHIFT),

    /*!< FlexPWM1_SM0_EXTA input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Sm0Exta            = 0U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Sm0Exta            = 1U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Sm0Exta            = 2U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Sm0Exta            = 3U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Sm0Exta            = 4U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Sm0Exta          = 5U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Sm0Exta          = 6U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Sm0Exta          = 7U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Sm0Exta          = 8U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Sm0Exta          = 9U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Sm0Exta            = 11U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Sm0Exta      = 12U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Sm0Exta         = 13U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Sm0Exta         = 14U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Sm0Exta         = 15U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Sm0Exta         = 16U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Sm0Exta         = 17U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Sm0Exta         = 18U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Sm0Exta         = 19U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Sm0Exta         = 20U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Sm0Exta            = 21U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Sm0Exta            = 22U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Sm0Exta            = 23U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Sm0Exta        = 24U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Sm0Exta        = 25U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Sm0Exta        = 26U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Sm0Exta        = 27U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Sm0Exta        = 28U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Sm0Exta        = 29U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Sm0Exta        = 30U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Sm0Exta        = 31U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Sm0Exta    = 32U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Sm0Exta    = 33U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Sm0Exta          = 34U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Sm0Exta          = 35U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Sm0Exta          = 36U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Sm0Exta          = 37U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Sm0Exta          = 38U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Sm0Exta          = 39U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Sm0Exta          = 40U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Sm0Exta          = 41U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Sm0Exta            = 42U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Sm0Exta            = 43U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Sm0Exta            = 44U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Sm0Exta            = 45U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Sm0Exta            = 46U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Sm0Exta            = 47U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Sm0Exta            = 48U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Sm0Exta            = 49U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Sm0Exta            = 50U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Sm0Exta            = 51U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Sm0Exta      = 52U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Sm0Exta      = 53U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Sm0Exta      = 54U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Sm0Exta      = 55U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Sm0Exta      = 56U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Sm0Exta = 57U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Sm0Exta = 58U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Sm0Exta = 59U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Sm0Exta = 60U + (FlexPWM1_SM0_EXTA_REG << PMUX_SHIFT),

    /*!< FlexPWM1_SM1_EXTA input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Sm1Exta            = 0U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Sm1Exta            = 1U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Sm1Exta            = 2U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Sm1Exta            = 3U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Sm1Exta            = 4U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Sm1Exta          = 5U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Sm1Exta          = 6U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Sm1Exta          = 7U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Sm1Exta          = 8U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Sm1Exta          = 9U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Sm1Exta            = 11U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Sm1Exta      = 12U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Sm1Exta         = 13U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Sm1Exta         = 14U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Sm1Exta         = 15U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Sm1Exta         = 16U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Sm1Exta         = 17U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Sm1Exta         = 18U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Sm1Exta         = 19U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Sm1Exta         = 20U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Sm1Exta            = 21U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Sm1Exta            = 22U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Sm1Exta            = 23U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Sm1Exta        = 24U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Sm1Exta        = 25U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Sm1Exta        = 26U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Sm1Exta        = 27U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Sm1Exta        = 28U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Sm1Exta        = 29U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Sm1Exta        = 30U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Sm1Exta        = 31U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Sm1Exta    = 32U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Sm1Exta    = 33U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Sm1Exta          = 34U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Sm1Exta          = 35U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Sm1Exta          = 36U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Sm1Exta          = 37U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Sm1Exta          = 38U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Sm1Exta          = 39U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Sm1Exta          = 40U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Sm1Exta          = 41U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Sm1Exta            = 42U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Sm1Exta            = 43U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Sm1Exta            = 44U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Sm1Exta            = 45U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Sm1Exta            = 46U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Sm1Exta            = 47U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Sm1Exta            = 48U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Sm1Exta            = 49U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Sm1Exta            = 50U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Sm1Exta            = 51U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Sm1Exta      = 52U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Sm1Exta      = 53U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Sm1Exta      = 54U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Sm1Exta      = 55U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Sm1Exta      = 56U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Sm1Exta = 57U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Sm1Exta = 58U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Sm1Exta = 59U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Sm1Exta = 60U + (FlexPWM1_SM1_EXTA_REG << PMUX_SHIFT),

    /*!< FlexPWM1_SM2_EXTA input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Sm2Exta            = 0U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Sm2Exta            = 1U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Sm2Exta            = 2U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Sm2Exta            = 3U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Sm2Exta            = 4U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Sm2Exta          = 5U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Sm2Exta          = 6U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Sm2Exta          = 7U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Sm2Exta          = 8U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Sm2Exta          = 9U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Sm2Exta            = 11U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Sm2Exta      = 12U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Sm2Exta         = 13U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Sm2Exta         = 14U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Sm2Exta         = 15U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Sm2Exta         = 16U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Sm2Exta         = 17U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Sm2Exta         = 18U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Sm2Exta         = 19U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Sm2Exta         = 20U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Sm2Exta            = 21U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Sm2Exta            = 22U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Sm2Exta            = 23U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Sm2Exta        = 24U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Sm2Exta        = 25U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Sm2Exta        = 26U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Sm2Exta        = 27U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Sm2Exta        = 28U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Sm2Exta        = 29U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Sm2Exta        = 30U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Sm2Exta        = 31U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Sm2Exta    = 32U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Sm2Exta    = 33U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Sm2Exta          = 34U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Sm2Exta          = 35U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Sm2Exta          = 36U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Sm2Exta          = 37U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Sm2Exta          = 38U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Sm2Exta          = 39U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Sm2Exta          = 40U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Sm2Exta          = 41U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Sm2Exta            = 42U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Sm2Exta            = 43U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Sm2Exta            = 44U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Sm2Exta            = 45U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Sm2Exta            = 46U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Sm2Exta            = 47U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Sm2Exta            = 48U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Sm2Exta            = 49U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Sm2Exta            = 50U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Sm2Exta            = 51U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Sm2Exta      = 52U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Sm2Exta      = 53U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Sm2Exta      = 54U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Sm2Exta      = 55U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Sm2Exta      = 56U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Sm2Exta = 57U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Sm2Exta = 58U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Sm2Exta = 59U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Sm2Exta = 60U + (FlexPWM1_SM2_EXTA_REG << PMUX_SHIFT),

    /*!< FlexPWM1_SM3_EXTA input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Sm3Exta            = 0U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Sm3Exta            = 1U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Sm3Exta            = 2U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Sm3Exta            = 3U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Sm3Exta            = 4U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Sm3Exta          = 5U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Sm3Exta          = 6U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Sm3Exta          = 7U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Sm3Exta          = 8U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Sm3Exta          = 9U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Sm3Exta            = 11U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Sm3Exta      = 12U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Sm3Exta         = 13U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Sm3Exta         = 14U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Sm3Exta         = 15U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Sm3Exta         = 16U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Sm3Exta         = 17U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Sm3Exta         = 18U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Sm3Exta         = 19U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Sm3Exta         = 20U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Sm3Exta            = 21U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Sm3Exta            = 22U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Sm3Exta            = 23U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Sm3Exta        = 24U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Sm3Exta        = 25U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Sm3Exta        = 26U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Sm3Exta        = 27U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Sm3Exta        = 28U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Sm3Exta        = 29U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Sm3Exta        = 30U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Sm3Exta        = 31U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Sm3Exta    = 32U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Sm3Exta    = 33U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Sm3Exta          = 34U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Sm3Exta          = 35U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Sm3Exta          = 36U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Sm3Exta          = 37U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Sm3Exta          = 38U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Sm3Exta          = 39U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Sm3Exta          = 40U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Sm3Exta          = 41U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Sm3Exta            = 42U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Sm3Exta            = 43U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Sm3Exta            = 44U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Sm3Exta            = 45U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Sm3Exta            = 46U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Sm3Exta            = 47U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Sm3Exta            = 48U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Sm3Exta            = 49U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Sm3Exta            = 50U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Sm3Exta            = 51U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Sm3Exta      = 52U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Sm3Exta      = 53U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Sm3Exta      = 54U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Sm3Exta      = 55U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Sm3Exta      = 56U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Sm3Exta = 57U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Sm3Exta = 58U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Sm3Exta = 59U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Sm3Exta = 60U + (FlexPWM1_SM3_EXTA_REG << PMUX_SHIFT),

    /*!< FlexPWM1_EXTFORCE input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1ExtForce            = 0U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1ExtForce            = 1U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1ExtForce            = 2U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1ExtForce            = 3U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1ExtForce            = 4U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1ExtForce          = 5U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1ExtForce          = 6U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1ExtForce          = 7U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1ExtForce          = 8U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1ExtForce          = 9U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1ExtForce            = 11U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1ExtForce      = 12U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1ExtForce         = 13U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1ExtForce         = 14U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1ExtForce         = 15U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1ExtForce         = 16U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1ExtForce         = 17U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1ExtForce         = 18U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1ExtForce         = 19U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1ExtForce         = 20U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1ExtForce            = 21U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1ExtForce            = 22U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1ExtForce            = 23U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1ExtForce        = 24U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1ExtForce        = 25U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1ExtForce        = 26U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1ExtForce        = 27U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1ExtForce        = 28U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1ExtForce        = 29U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1ExtForce        = 30U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1ExtForce        = 31U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1ExtForce    = 32U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1ExtForce    = 33U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1ExtForce          = 34U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1ExtForce          = 35U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1ExtForce          = 36U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1ExtForce          = 37U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1ExtForce          = 38U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1ExtForce          = 39U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1ExtForce          = 40U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1ExtForce          = 41U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1ExtForce            = 42U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1ExtForce            = 43U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1ExtForce            = 44U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1ExtForce            = 45U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1ExtForce            = 46U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1ExtForce            = 47U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1ExtForce            = 48U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1ExtForce            = 49U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1ExtForce            = 50U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1ExtForce            = 51U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1ExtForce      = 52U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1ExtForce      = 53U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1ExtForce      = 54U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1ExtForce      = 55U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1ExtForce      = 56U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1ExtForce = 57U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1ExtForce = 58U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1ExtForce = 59U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1ExtForce = 60U + (FlexPWM1_EXTFORCE_REG << PMUX_SHIFT),

    /*!< FlexPWM1_FAULT0 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Fault0            = 0U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Fault0            = 1U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Fault0            = 2U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Fault0            = 3U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Fault0            = 4U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Fault0          = 5U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Fault0          = 6U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Fault0          = 7U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Fault0          = 8U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Fault0          = 9U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Fault0            = 11U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Fault0      = 12U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Fault0         = 13U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Fault0         = 14U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Fault0         = 15U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Fault0         = 16U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Fault0         = 17U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Fault0         = 18U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Fault0         = 19U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Fault0         = 20U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Fault0            = 21U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Fault0            = 22U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Fault0            = 23U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Fault0        = 24U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Fault0        = 25U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Fault0        = 26U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Fault0        = 27U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Fault0        = 28U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Fault0        = 29U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Fault0        = 30U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Fault0        = 31U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Fault0    = 32U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Fault0    = 33U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Fault0          = 34U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Fault0          = 35U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Fault0          = 36U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Fault0          = 37U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Fault0          = 38U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Fault0          = 39U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Fault0          = 40U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Fault0          = 41U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Fault0            = 42U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Fault0            = 43U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Fault0            = 44U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Fault0            = 45U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Fault0            = 46U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Fault0            = 47U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Fault0            = 48U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Fault0            = 49U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Fault0            = 50U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Fault0            = 51U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Fault0      = 52U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Fault0      = 53U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Fault0      = 54U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Fault0      = 55U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Fault0      = 56U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Fault0 = 57U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Fault0 = 58U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Fault0 = 59U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Fault0 = 60U + (FlexPWM1_FAULT0_REG << PMUX_SHIFT),

    /*!< FlexPWM1_FAULT1 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Fault1            = 0U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Fault1            = 1U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Fault1            = 2U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Fault1            = 3U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Fault1            = 4U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Fault1          = 5U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Fault1          = 6U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Fault1          = 7U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Fault1          = 8U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Fault1          = 9U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Fault1            = 11U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Fault1      = 12U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Fault1         = 13U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Fault1         = 14U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Fault1         = 15U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Fault1         = 16U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Fault1         = 17U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Fault1         = 18U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Fault1         = 19U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Fault1         = 20U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Fault1            = 21U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Fault1            = 22U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Fault1            = 23U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Fault1        = 24U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Fault1        = 25U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Fault1        = 26U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Fault1        = 27U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Fault1        = 28U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Fault1        = 29U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Fault1        = 30U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Fault1        = 31U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Fault1    = 32U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Fault1    = 33U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Fault1          = 34U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Fault1          = 35U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Fault1          = 36U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Fault1          = 37U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Fault1          = 38U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Fault1          = 39U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Fault1          = 40U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Fault1          = 41U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Fault1            = 42U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Fault1            = 43U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Fault1            = 44U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Fault1            = 45U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Fault1            = 46U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Fault1            = 47U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Fault1            = 48U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Fault1            = 49U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Fault1            = 50U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Fault1            = 51U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Fault1      = 52U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Fault1      = 53U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Fault1      = 54U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Fault1      = 55U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Fault1      = 56U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Fault1 = 57U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Fault1 = 58U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Fault1 = 59U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Fault1 = 60U + (FlexPWM1_FAULT1_REG << PMUX_SHIFT),

    /*!< FlexPWM1_FAULT2 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Fault2            = 0U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Fault2            = 1U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Fault2            = 2U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Fault2            = 3U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Fault2            = 4U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Fault2          = 5U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Fault2          = 6U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Fault2          = 7U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Fault2          = 8U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Fault2          = 9U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Fault2            = 11U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Fault2      = 12U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Fault2         = 13U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Fault2         = 14U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Fault2         = 15U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Fault2         = 16U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Fault2         = 17U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Fault2         = 18U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Fault2         = 19U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Fault2         = 20U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Fault2            = 21U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Fault2            = 22U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Fault2            = 23U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Fault2        = 24U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Fault2        = 25U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Fault2        = 26U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Fault2        = 27U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Fault2        = 28U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Fault2        = 29U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Fault2        = 30U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Fault2        = 31U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Fault2    = 32U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Fault2    = 33U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Fault2          = 34U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Fault2          = 35U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Fault2          = 36U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Fault2          = 37U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Fault2          = 38U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Fault2          = 39U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Fault2          = 40U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Fault2          = 41U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Fault2            = 42U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Fault2            = 43U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Fault2            = 44U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Fault2            = 45U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Fault2            = 46U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Fault2            = 47U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Fault2            = 48U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Fault2            = 49U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Fault2            = 50U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Fault2            = 51U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Fault2      = 52U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Fault2      = 53U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Fault2      = 54U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Fault2      = 55U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Fault2      = 56U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Fault2 = 57U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Fault2 = 58U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Fault2 = 59U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Fault2 = 60U + (FlexPWM1_FAULT2_REG << PMUX_SHIFT),

    /*!< FlexPWM1_FAULT3 input trigger connections. */
    kINPUTMUX_PinInt0ToFlexPwm1Fault3            = 0U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToFlexPwm1Fault3            = 1U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexPwm1Fault3            = 2U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexPwm1Fault3            = 3U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexPwm1Fault3            = 4U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToFlexPwm1Fault3          = 5U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToFlexPwm1Fault3          = 6U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexPwm1Fault3          = 7U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexPwm1Fault3          = 8U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexPwm1Fault3          = 9U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexPwm1Fault3            = 11U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexPwm1Fault3      = 12U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexPwm1Fault3         = 13U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexPwm1Fault3         = 14U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexPwm1Fault3         = 15U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexPwm1Fault3         = 16U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexPwm1Fault3         = 17U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexPwm1Fault3         = 18U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexPwm1Fault3         = 19U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexPwm1Fault3         = 20U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexPwm1Fault3            = 21U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexPwm1Fault3            = 22U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexPwm1Fault3            = 23U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexPwm1Fault3        = 24U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexPwm1Fault3        = 25U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexPwm1Fault3        = 26U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexPwm1Fault3        = 27U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexPwm1Fault3        = 28U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexPwm1Fault3        = 29U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexPwm1Fault3        = 30U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexPwm1Fault3        = 31U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToFlexPwm1Fault3    = 32U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToFlexPwm1Fault3    = 33U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexPwm1Fault3          = 34U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexPwm1Fault3          = 35U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexPwm1Fault3          = 36U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexPwm1Fault3          = 37U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexPwm1Fault3          = 38U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexPwm1Fault3          = 39U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexPwm1Fault3          = 40U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexPwm1Fault3          = 41U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexPwm1Fault3            = 42U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexPwm1Fault3            = 43U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexPwm1Fault3            = 44U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexPwm1Fault3            = 45U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexPwm1Fault3            = 46U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn5ToFlexPwm1Fault3            = 47U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn6ToFlexPwm1Fault3            = 48U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn7ToFlexPwm1Fault3            = 49U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn8ToFlexPwm1Fault3            = 50U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn9ToFlexPwm1Fault3            = 51U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexPwm1Fault3      = 52U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexPwm1Fault3      = 53U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexPwm1Fault3      = 54U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexPwm1Fault3      = 55U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexPwm1Fault3      = 56U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexPwm1Fault3 = 57U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexPwm1Fault3 = 58U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexPwm1Fault3 = 59U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexPwm1Fault3 = 60U + (FlexPWM1_FAULT3_REG << PMUX_SHIFT),

    /*!< PWM0 external clock trigger. */
    kINPUTMUX_Fro16KToPwm0ExtClk     = 0U + (PWM0_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_Osc32KToPwm0ExtClk     = 1U + (PWM0_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToPwm0ExtClk  = 2U + (PWM0_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToPwm0ExtClk  = 3U + (PWM0_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_ExttrigIn0ToPwm0ExtClk = 4U + (PWM0_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_ExttrigIn1ToPwm0ExtClk = 5U + (PWM0_EXT_CLK_REG << PMUX_SHIFT),

    /*!< PWM1 external clock trigger. */
    kINPUTMUX_Fro16KToPwm1ExtClk     = 0U + (PWM1_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_Osc32KToPwm1ExtClk     = 1U + (PWM1_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToPwm1ExtClk  = 2U + (PWM1_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToPwm1ExtClk  = 3U + (PWM1_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_ExttrigIn0ToPwm1ExtClk = 4U + (PWM1_EXT_CLK_REG << PMUX_SHIFT),
    kINPUTMUX_ExttrigIn1ToPwm1ExtClk = 5U + (PWM1_EXT_CLK_REG << PMUX_SHIFT),

    /*!< EVTG trigger input connections. */
    kINPUTMUX_PinInt0ToEvtgTrigger         = 0U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToEvtgTrigger         = 1U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToEvtgTrigger         = 2U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToEvtgTrigger         = 3U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToEvtgTrigger         = 4U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToEvtgTrigger         = 5U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToEvtgTrigger       = 6U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToEvtgTrigger       = 7U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToEvtgTrigger       = 8U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M2ToEvtgTrigger       = 9U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToEvtgTrigger       = 10U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M2ToEvtgTrigger       = 11U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToEvtgTrigger   = 13U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToEvtgTrigger         = 14U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToEvtgTrigger         = 15U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToEvtgTrigger      = 16U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToEvtgTrigger      = 17U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToEvtgTrigger      = 18U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToEvtgTrigger      = 19U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToEvtgTrigger      = 20U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToEvtgTrigger      = 21U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToEvtgTrigger      = 22U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToEvtgTrigger      = 23U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToEvtgTrigger         = 24U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToEvtgTrigger         = 25U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToEvtgTrigger         = 26U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig0ToEvtgTrigger     = 27U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig1ToEvtgTrigger     = 28U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig0ToEvtgTrigger     = 29U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig1ToEvtgTrigger     = 30U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig0ToEvtgTrigger     = 31U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig1ToEvtgTrigger     = 32U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig0ToEvtgTrigger     = 33U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig1ToEvtgTrigger     = 34U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToEvtgTrigger     = 35U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToEvtgTrigger     = 36U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToEvtgTrigger     = 37U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToEvtgTrigger     = 38U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToEvtgTrigger     = 39U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToEvtgTrigger     = 40U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToEvtgTrigger     = 41U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToEvtgTrigger     = 42U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToEvtgTrigger = 43U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToEvtgTrigger = 44U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToEvtgTrigger         = 45U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToEvtgTrigger         = 46U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToEvtgTrigger         = 47U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToEvtgTrigger         = 48U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToEvtgTrigger          = 49U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToEvtgTrigger          = 50U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToEvtgTrigger   = 51U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToEvtgTrigger   = 52U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToEvtgTrigger   = 53U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToEvtgTrigger   = 54U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToEvtgTrigger   = 55U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TmprOut0ToEvtgTrigger        = 56U + (EVTG_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TmprOut1ToEvtgTrigger        = 57U + (EVTG_TRIG0_REG << PMUX_SHIFT),

    /*!< USB-FS trigger input connections. */
    kINPUTMUX_Lpflexcomm0Trig3ToUsbfsTrigger = 0U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm1Trig3ToUsbfsTrigger = 1U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm2Trig3ToUsbfsTrigger = 2U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig3ToUsbfsTrigger = 3U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm4Trig3ToUsbfsTrigger = 4U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm5Trig3ToUsbfsTrigger = 5U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm6Trig3ToUsbfsTrigger = 6U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm7Trig3ToUsbfsTrigger = 7U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm8Trig3ToUsbfsTrigger = 8U + (USBFS_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm9Trig3ToUsbfsTrigger = 9U + (USBFS_TRIG_REG << PMUX_SHIFT),

    /*!< TSI trigger input connections. */
    kINPUTMUX_Lptmr0ToTsiTrigger = 0U + (TSI_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToTsiTrigger = 1U + (TSI_TRIG_REG << PMUX_SHIFT),

    /*!< EXT trigger connections. */
    kINPUTMUX_PinInt0ToExtTrigger          = 0U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToExtTrigger          = 1U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0IrqToExtTrigger          = 2U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1IrqToExtTrigger          = 3U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToExtTrigger       = 4U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToExtTrigger       = 5U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig01ToExtTrigger     = 6U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig01ToExtTrigger     = 7U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig01ToExtTrigger     = 8U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig01ToExtTrigger     = 9U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig01ToExtTrigger     = 10U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig01ToExtTrigger     = 11U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig01ToExtTrigger     = 12U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig01ToExtTrigger     = 13U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToExtTrigger  = 14U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToExtTrigger  = 15U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToExtTrigger        = 16U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToExtTrigger        = 17U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToExtTrigger        = 18U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToExtTrigger        = 19U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToExtTrigger        = 20U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToExtTrigger        = 21U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToExtTrigger        = 22U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToExtTrigger        = 23U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TmprOut0ToExtTrigger         = 24U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TmprOut1ToExtTrigger         = 25U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToExtTrigger           = 26U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToExtTrigger           = 27U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToExtTrigger          = 28U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToExtTrigger          = 29U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToExtTrigger          = 30U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToExtTrigger          = 31U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToExtTrigger          = 32U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToExtTrigger          = 33U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm0Trig3ToExtTrigger = 34U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm1Trig3ToExtTrigger = 35U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm2Trig3ToExtTrigger = 36U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig3ToExtTrigger = 37U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm4Trig3ToExtTrigger = 38U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm5Trig3ToExtTrigger = 39U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm6Trig3ToExtTrigger = 40U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm7Trig3ToExtTrigger = 41U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm8Trig3ToExtTrigger = 42U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm9Trig3ToExtTrigger = 43U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToExtTrigger          = 44U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToExtTrigger          = 45U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToExtTrigger          = 46U + (EXT_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EnetPpsOut0ToExtTrigger      = 47U + (EXT_TRIG0_REG << PMUX_SHIFT),

    /*!< SINC Filter channel trigger input connections. */
    kINPUTMUX_PinInt0ToSincFilterChTrigger         = 0U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToSincFilterChTrigger         = 1U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToSincFilterChTrigger         = 2U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToSincFilterChTrigger         = 3U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut9ToSincFilterChTrigger         = 4U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToSincFilterChTrigger       = 5U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToSincFilterChTrigger       = 6U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToSincFilterChTrigger       = 7U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToSincFilterChTrigger       = 8U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToSincFilterChTrigger       = 9U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToSincFilterChTrigger         = 11U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToSincFilterChTrigger   = 12U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToSincFilterChTrigger      = 13U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToSincFilterChTrigger      = 14U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToSincFilterChTrigger      = 15U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToSincFilterChTrigger      = 16U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToSincFilterChTrigger      = 17U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToSincFilterChTrigger      = 18U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToSincFilterChTrigger      = 19U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToSincFilterChTrigger      = 20U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToSincFilterChTrigger         = 21U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToSincFilterChTrigger         = 22U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToSincFilterChTrigger         = 23U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig0ToSincFilterChTrigger     = 24U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig1ToSincFilterChTrigger     = 25U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig0ToSincFilterChTrigger     = 26U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig1ToSincFilterChTrigger     = 27U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig0ToSincFilterChTrigger     = 28U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig1ToSincFilterChTrigger     = 29U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig0ToSincFilterChTrigger     = 30U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig1ToSincFilterChTrigger     = 31U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToSincFilterChTrigger     = 32U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToSincFilterChTrigger     = 33U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToSincFilterChTrigger     = 34U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToSincFilterChTrigger     = 35U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToSincFilterChTrigger     = 36U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToSincFilterChTrigger     = 37U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToSincFilterChTrigger     = 38U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToSincFilterChTrigger     = 39U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc0CmpPosMatchToSincFilterChTrigger = 40U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Enc1CmpPosMatchToSincFilterChTrigger = 41U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToSincFilterChTrigger       = 42U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToSincFilterChTrigger       = 43U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToSincFilterChTrigger       = 44U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToSincFilterChTrigger       = 45U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToSincFilterChTrigger       = 46U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToSincFilterChTrigger       = 47U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToSincFilterChTrigger       = 48U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToSincFilterChTrigger       = 49U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToSincFilterChTrigger          = 50U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToSincFilterChTrigger          = 51U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh0ToSincFilterChTrigger       = 52U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh1ToSincFilterChTrigger       = 53U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh2ToSincFilterChTrigger       = 54U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh3ToSincFilterChTrigger       = 55U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToSincFilterChTrigger             = 56U + (SINC_FILTER_CH0_REG << PMUX_SHIFT),

    /*!< OPAMP0 trigger input connections. */
    kINPUTMUX_PinInt0ToOpamp0Trigger       = 0U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToOpamp0Trigger       = 1U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToOpamp0Trigger       = 2U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt3ToOpamp0Trigger       = 3U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToOpamp0Trigger       = 4U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToOpamp0Trigger       = 5U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut6ToOpamp0Trigger       = 6U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToOpamp0Trigger       = 7U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToOpamp0Trigger       = 8U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToOpamp0Trigger     = 9U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToOpamp0Trigger     = 10U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToOpamp0Trigger     = 11U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToOpamp0Trigger     = 12U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToOpamp0Trigger     = 13U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToOpamp0Trigger = 14U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToOpamp0Trigger    = 15U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToOpamp0Trigger    = 16U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToOpamp0Trigger    = 17U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToOpamp0Trigger    = 18U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToOpamp0Trigger    = 19U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToOpamp0Trigger    = 20U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToOpamp0Trigger    = 21U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToOpamp0Trigger    = 22U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig0ToOpamp0Trigger   = 23U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig1ToOpamp0Trigger   = 24U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig0ToOpamp0Trigger   = 25U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig1ToOpamp0Trigger   = 26U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig0ToOpamp0Trigger   = 27U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig1ToOpamp0Trigger   = 28U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig0ToOpamp0Trigger   = 29U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig1ToOpamp0Trigger   = 30U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToOpamp0Trigger   = 31U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToOpamp0Trigger   = 32U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToOpamp0Trigger   = 33U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToOpamp0Trigger   = 34U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToOpamp0Trigger   = 35U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToOpamp0Trigger   = 36U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToOpamp0Trigger   = 37U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToOpamp0Trigger   = 38U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToOpamp0Trigger     = 39U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToOpamp0Trigger     = 40U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToOpamp0Trigger     = 41U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToOpamp0Trigger     = 42U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToOpamp0Trigger     = 43U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToOpamp0Trigger     = 44U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToOpamp0Trigger     = 45U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToOpamp0Trigger     = 46U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToOpamp0Trigger       = 47U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToOpamp0Trigger       = 48U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToOpamp0Trigger       = 49U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToOpamp0Trigger       = 50U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToOpamp0Trigger     = 51U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToOpamp0Trigger     = 52U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToOpamp0Trigger     = 53U + (OPAMP0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToOpamp0Trigger     = 54U + (OPAMP0_TRIG_REG << PMUX_SHIFT),

    /*!< OPAMP1 trigger input connections. */
    kINPUTMUX_PinInt0ToOpamp1Trigger       = 0U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToOpamp1Trigger       = 1U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToOpamp1Trigger       = 2U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt3ToOpamp1Trigger       = 3U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToOpamp1Trigger       = 4U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToOpamp1Trigger       = 5U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut6ToOpamp1Trigger       = 6U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToOpamp1Trigger       = 7U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToOpamp1Trigger       = 8U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToOpamp1Trigger     = 9U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToOpamp1Trigger     = 10U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToOpamp1Trigger     = 11U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToOpamp1Trigger     = 12U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToOpamp1Trigger     = 13U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToOpamp1Trigger = 14U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToOpamp1Trigger    = 15U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToOpamp1Trigger    = 16U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToOpamp1Trigger    = 17U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToOpamp1Trigger    = 18U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToOpamp1Trigger    = 19U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToOpamp1Trigger    = 20U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToOpamp1Trigger    = 21U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToOpamp1Trigger    = 22U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig0ToOpamp1Trigger   = 23U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig1ToOpamp1Trigger   = 24U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig0ToOpamp1Trigger   = 25U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig1ToOpamp1Trigger   = 26U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig0ToOpamp1Trigger   = 27U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig1ToOpamp1Trigger   = 28U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig0ToOpamp1Trigger   = 29U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig1ToOpamp1Trigger   = 30U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToOpamp1Trigger   = 31U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToOpamp1Trigger   = 32U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToOpamp1Trigger   = 33U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToOpamp1Trigger   = 34U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToOpamp1Trigger   = 35U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToOpamp1Trigger   = 36U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToOpamp1Trigger   = 37U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToOpamp1Trigger   = 38U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToOpamp1Trigger     = 39U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToOpamp1Trigger     = 40U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToOpamp1Trigger     = 41U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToOpamp1Trigger     = 42U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToOpamp1Trigger     = 43U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToOpamp1Trigger     = 44U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToOpamp1Trigger     = 45U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToOpamp1Trigger     = 46U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToOpamp1Trigger       = 47U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToOpamp1Trigger       = 48U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToOpamp1Trigger       = 49U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToOpamp1Trigger       = 50U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToOpamp1Trigger     = 51U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToOpamp1Trigger     = 52U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToOpamp1Trigger     = 53U + (OPAMP1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToOpamp1Trigger     = 54U + (OPAMP1_TRIG_REG << PMUX_SHIFT),

    /*!< OPAMP2 trigger input connections. */
    kINPUTMUX_PinInt0ToOpamp2Trigger       = 0U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt1ToOpamp2Trigger       = 1U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt2ToOpamp2Trigger       = 2U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt3ToOpamp2Trigger       = 3U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToOpamp2Trigger       = 4U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToOpamp2Trigger       = 5U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut6ToOpamp2Trigger       = 6U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToOpamp2Trigger       = 7U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToOpamp2Trigger       = 8U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M3ToOpamp2Trigger     = 9U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M3ToOpamp2Trigger     = 10U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToOpamp2Trigger     = 11U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToOpamp2Trigger     = 12U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToOpamp2Trigger     = 13U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToOpamp2Trigger = 14U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToOpamp2Trigger    = 15U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToOpamp2Trigger    = 16U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToOpamp2Trigger    = 17U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToOpamp2Trigger    = 18U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToOpamp2Trigger    = 19U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToOpamp2Trigger    = 20U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToOpamp2Trigger    = 21U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToOpamp2Trigger    = 22U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig0ToOpamp2Trigger   = 23U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig1ToOpamp2Trigger   = 24U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig0ToOpamp2Trigger   = 25U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig1ToOpamp2Trigger   = 26U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig0ToOpamp2Trigger   = 27U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig1ToOpamp2Trigger   = 28U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig0ToOpamp2Trigger   = 29U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig1ToOpamp2Trigger   = 30U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToOpamp2Trigger   = 31U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToOpamp2Trigger   = 32U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToOpamp2Trigger   = 33U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToOpamp2Trigger   = 34U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToOpamp2Trigger   = 35U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToOpamp2Trigger   = 36U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToOpamp2Trigger   = 37U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToOpamp2Trigger   = 38U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToOpamp2Trigger     = 39U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToOpamp2Trigger     = 40U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToOpamp2Trigger     = 41U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToOpamp2Trigger     = 42U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToOpamp2Trigger     = 43U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToOpamp2Trigger     = 44U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToOpamp2Trigger     = 45U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToOpamp2Trigger     = 46U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToOpamp2Trigger       = 47U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToOpamp2Trigger       = 48U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToOpamp2Trigger       = 49U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToOpamp2Trigger       = 50U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToOpamp2Trigger     = 51U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToOpamp2Trigger     = 52U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToOpamp2Trigger     = 53U + (OPAMP2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToOpamp2Trigger     = 54U + (OPAMP2_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM0 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm0Trigger                 = 0U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm0Trigger                 = 1U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt6ToFlexcomm0Trigger                 = 2U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexcomm0Trigger                 = 3U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut6ToFlexcomm0Trigger                 = 4U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToFlexcomm0Trigger                 = 5U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm0Trigger               = 6U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm0Trigger               = 7U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexcomm0Trigger               = 8U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToFlexcomm0Trigger               = 9U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexcomm0Trigger               = 10U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm0Trigger                  = 11U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm0Trigger                  = 12U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm0Trigger                 = 13U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm0Trigger           = 14U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm0Trigger                 = 15U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm0Trigger                 = 16U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm0Trigger                 = 17U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm0Trigger               = 18U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm0Trigger               = 19U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm0Trigger               = 20U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm0Trigger               = 21U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm0Trigger               = 22U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm0Trigger               = 23U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm0Trigger               = 24U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm0Trigger               = 25U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm0Trigger                 = 26U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm0Trigger                 = 27U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm0Trigger                 = 28U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm0Trigger                 = 29U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm0Trigger                 = 30U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm0Trigger                = 31U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm0Trigger                = 32U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm0Trigger               = 33U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm0Trigger               = 34U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm0Trigger               = 35U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm0Trigger               = 36U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm0Trigger = 37U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm0Trigger      = 38U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm0Trigger      = 39U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm0Trigger      = 40U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm0Trigger      = 41U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm0Trigger                     = 42U + (FLEXCOMM0_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM1 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm1Trigger                 = 0U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm1Trigger                 = 1U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt6ToFlexcomm1Trigger                 = 2U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexcomm1Trigger                 = 3U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut6ToFlexcomm1Trigger                 = 4U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToFlexcomm1Trigger                 = 5U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm1Trigger               = 6U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm1Trigger               = 7U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexcomm1Trigger               = 8U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToFlexcomm1Trigger               = 9U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexcomm1Trigger               = 10U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm1Trigger                  = 11U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm1Trigger                  = 12U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm1Trigger                 = 13U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm1Trigger           = 14U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm1Trigger                 = 15U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm1Trigger                 = 16U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm1Trigger                 = 17U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm1Trigger               = 18U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm1Trigger               = 19U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm1Trigger               = 20U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm1Trigger               = 21U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm1Trigger               = 22U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm1Trigger               = 23U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm1Trigger               = 24U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm1Trigger               = 25U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm1Trigger                 = 26U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm1Trigger                 = 27U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm1Trigger                 = 28U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm1Trigger                 = 29U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm1Trigger                 = 30U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm1Trigger                = 31U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm1Trigger                = 32U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm1Trigger               = 33U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm1Trigger               = 34U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm1Trigger               = 35U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm1Trigger               = 36U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm1Trigger = 37U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm1Trigger      = 38U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm1Trigger      = 39U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm1Trigger      = 40U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm1Trigger      = 41U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm1Trigger                     = 42U + (FLEXCOMM1_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM2 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm2Trigger                 = 0U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt6ToFlexcomm2Trigger                 = 1U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexcomm2Trigger                 = 2U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexcomm2Trigger                 = 3U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToFlexcomm2Trigger                 = 4U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut9ToFlexcomm2Trigger                 = 5U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm2Trigger               = 6U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm2Trigger               = 7U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexcomm2Trigger               = 8U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToFlexcomm2Trigger               = 9U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexcomm2Trigger               = 10U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm2Trigger                  = 11U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm2Trigger                  = 12U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm2Trigger                 = 13U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm2Trigger           = 14U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm2Trigger                 = 15U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm2Trigger                 = 16U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm2Trigger                 = 17U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm2Trigger               = 18U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm2Trigger               = 19U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm2Trigger               = 20U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm2Trigger               = 21U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm2Trigger               = 22U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm2Trigger               = 23U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm2Trigger               = 24U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm2Trigger               = 25U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm2Trigger                 = 26U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm2Trigger                 = 27U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm2Trigger                 = 28U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm2Trigger                 = 29U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm2Trigger                 = 30U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm2Trigger                = 31U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm2Trigger                = 32U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm2Trigger               = 33U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm2Trigger               = 34U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm2Trigger               = 35U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm2Trigger               = 36U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm2Trigger = 37U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm2Trigger      = 38U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm2Trigger      = 39U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm2Trigger      = 40U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm2Trigger      = 41U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm2Trigger                     = 42U + (FLEXCOMM2_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM3 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm3Trigger                 = 0U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm3Trigger                 = 1U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexcomm3Trigger                 = 2U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexcomm3Trigger                 = 3U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToFlexcomm3Trigger                 = 4U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut9ToFlexcomm3Trigger                 = 5U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm3Trigger               = 6U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm3Trigger               = 7U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexcomm3Trigger               = 8U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToFlexcomm3Trigger               = 9U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexcomm3Trigger               = 10U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm3Trigger                  = 11U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm3Trigger                  = 12U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm3Trigger                 = 13U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm3Trigger           = 14U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm3Trigger                 = 15U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm3Trigger                 = 16U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm3Trigger                 = 17U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm3Trigger               = 18U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm3Trigger               = 19U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm3Trigger               = 20U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm3Trigger               = 21U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm3Trigger               = 22U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm3Trigger               = 23U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm3Trigger               = 24U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm3Trigger               = 25U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm3Trigger                 = 26U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm3Trigger                 = 27U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm3Trigger                 = 28U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm3Trigger                 = 29U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm3Trigger                 = 30U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm3Trigger                = 31U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm3Trigger                = 32U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm3Trigger               = 33U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm3Trigger               = 34U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm3Trigger               = 35U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm3Trigger               = 36U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm3Trigger = 37U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm3Trigger      = 38U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm3Trigger      = 39U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm3Trigger      = 40U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm3Trigger      = 41U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm3Trigger                     = 42U + (FLEXCOMM3_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM4 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm4Trigger                 = 0U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm4Trigger                 = 1U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexcomm4Trigger                 = 2U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToFlexcomm4Trigger                 = 3U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToFlexcomm4Trigger                 = 4U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexcomm4Trigger                 = 5U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm4Trigger               = 6U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm4Trigger               = 7U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M2ToFlexcomm4Trigger               = 8U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToFlexcomm4Trigger               = 9U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M2ToFlexcomm4Trigger               = 10U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm4Trigger                  = 11U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm4Trigger                  = 12U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm4Trigger                 = 13U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm4Trigger           = 14U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm4Trigger                 = 15U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm4Trigger                 = 16U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm4Trigger                 = 17U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm4Trigger               = 18U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm4Trigger               = 19U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm4Trigger               = 20U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm4Trigger               = 21U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm4Trigger               = 22U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm4Trigger               = 23U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm4Trigger               = 24U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm4Trigger               = 25U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm4Trigger                 = 26U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm4Trigger                 = 27U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm4Trigger                 = 28U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm4Trigger                 = 29U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm4Trigger                 = 30U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm4Trigger                = 31U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm4Trigger                = 32U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm4Trigger               = 33U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm4Trigger               = 34U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm4Trigger               = 35U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm4Trigger               = 36U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm4Trigger = 37U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm4Trigger      = 38U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm4Trigger      = 39U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm4Trigger      = 40U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm4Trigger      = 41U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm4Trigger                     = 42U + (FLEXCOMM4_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM5 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm5Trigger                 = 0U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm5Trigger                 = 1U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexcomm5Trigger                 = 2U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToFlexcomm5Trigger                 = 3U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut1ToFlexcomm5Trigger                 = 4U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut2ToFlexcomm5Trigger                 = 5U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm5Trigger               = 6U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm5Trigger               = 7U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M2ToFlexcomm5Trigger               = 8U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M2ToFlexcomm5Trigger               = 9U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M2ToFlexcomm5Trigger               = 10U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm5Trigger                  = 11U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm5Trigger                  = 12U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm5Trigger                 = 13U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm5Trigger           = 14U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm5Trigger                 = 15U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm5Trigger                 = 16U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm5Trigger                 = 17U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm5Trigger               = 18U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm5Trigger               = 19U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm5Trigger               = 20U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm5Trigger               = 21U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm5Trigger               = 22U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm5Trigger               = 23U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm5Trigger               = 24U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm5Trigger               = 25U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm5Trigger                 = 26U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm5Trigger                 = 27U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm5Trigger                 = 28U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm5Trigger                 = 29U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm5Trigger                 = 30U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm5Trigger                = 31U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm5Trigger                = 32U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm5Trigger               = 33U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm5Trigger               = 34U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm5Trigger               = 35U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm5Trigger               = 36U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm5Trigger = 37U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm5Trigger      = 38U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm5Trigger      = 39U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm5Trigger      = 40U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm5Trigger      = 41U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm5Trigger                     = 42U + (FLEXCOMM5_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM6 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm6Trigger                 = 0U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm6Trigger                 = 1U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexcomm6Trigger                 = 2U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToFlexcomm6Trigger                 = 3U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToFlexcomm6Trigger                 = 4U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexcomm6Trigger                 = 5U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm6Trigger               = 6U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm6Trigger               = 7U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexcomm6Trigger               = 8U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToFlexcomm6Trigger               = 9U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToFlexcomm6Trigger               = 10U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm6Trigger                  = 11U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm6Trigger                  = 12U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm6Trigger                 = 13U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm6Trigger           = 14U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm6Trigger                 = 15U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm6Trigger                 = 16U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm6Trigger                 = 17U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm6Trigger               = 18U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm6Trigger               = 19U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm6Trigger               = 20U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm6Trigger               = 21U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm6Trigger               = 22U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm6Trigger               = 23U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm6Trigger               = 24U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm6Trigger               = 25U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm6Trigger                 = 26U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm6Trigger                 = 27U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm6Trigger                 = 28U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm6Trigger                 = 29U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm6Trigger                 = 30U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm6Trigger                = 31U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm6Trigger                = 32U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm6Trigger               = 33U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm6Trigger               = 34U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm6Trigger               = 35U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm6Trigger               = 36U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm6Trigger = 37U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm6Trigger      = 38U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm6Trigger      = 39U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm6Trigger      = 40U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm6Trigger      = 41U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm6Trigger                     = 42U + (FLEXCOMM6_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM7 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm7Trigger                 = 0U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm7Trigger                 = 1U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexcomm7Trigger                 = 2U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToFlexcomm7Trigger                 = 3U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToFlexcomm7Trigger                 = 4U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexcomm7Trigger                 = 5U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm7Trigger               = 6U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm7Trigger               = 7U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexcomm7Trigger               = 8U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToFlexcomm7Trigger               = 9U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToFlexcomm7Trigger               = 10U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm7Trigger                  = 11U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm7Trigger                  = 12U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm7Trigger                 = 13U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm7Trigger           = 14U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm7Trigger                 = 15U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm7Trigger                 = 16U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm7Trigger                 = 17U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm7Trigger               = 18U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm7Trigger               = 19U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm7Trigger               = 20U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm7Trigger               = 21U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm7Trigger               = 22U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm7Trigger               = 23U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm7Trigger               = 24U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm7Trigger               = 25U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm7Trigger                 = 26U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm7Trigger                 = 27U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm7Trigger                 = 28U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm7Trigger                 = 29U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm7Trigger                 = 30U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm7Trigger                = 31U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm7Trigger                = 32U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm7Trigger               = 33U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm7Trigger               = 34U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm7Trigger               = 35U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm7Trigger               = 36U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm7Trigger = 37U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm7Trigger      = 38U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm7Trigger      = 39U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm7Trigger      = 40U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm7Trigger      = 41U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm7Trigger                     = 42U + (FLEXCOMM7_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM8 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm8Trigger                 = 0U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm8Trigger                 = 1U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexcomm8Trigger                 = 2U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToFlexcomm8Trigger                 = 3U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToFlexcomm8Trigger                 = 4U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexcomm8Trigger                 = 5U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm8Trigger               = 6U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm8Trigger               = 7U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M3ToFlexcomm8Trigger               = 8U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M3ToFlexcomm8Trigger               = 9U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M3ToFlexcomm8Trigger               = 10U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm8Trigger                  = 11U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm8Trigger                  = 12U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm8Trigger                 = 13U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm8Trigger           = 14U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm8Trigger                 = 15U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm8Trigger                 = 16U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm8Trigger                 = 17U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm8Trigger               = 18U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm8Trigger               = 19U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm8Trigger               = 20U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm8Trigger               = 21U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm8Trigger               = 22U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm8Trigger               = 23U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm8Trigger               = 24U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm8Trigger               = 25U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm8Trigger                 = 26U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm8Trigger                 = 27U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm8Trigger                 = 28U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm8Trigger                 = 29U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm8Trigger                 = 30U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm8Trigger                = 31U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm8Trigger                = 32U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm8Trigger               = 33U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm8Trigger               = 34U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm8Trigger               = 35U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm8Trigger               = 36U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm8Trigger = 37U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm8Trigger      = 38U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm8Trigger      = 39U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm8Trigger      = 40U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm8Trigger      = 41U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm8Trigger                     = 42U + (FLEXCOMM8_TRIG_REG << PMUX_SHIFT),

    /*!< FLEXCOMM9 trigger input connections. */
    kINPUTMUX_PinInt4ToFlexcomm9Trigger                 = 0U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexcomm9Trigger                 = 1U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexcomm9Trigger                 = 2U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut0ToFlexcomm9Trigger                 = 3U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut3ToFlexcomm9Trigger                 = 4U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut4ToFlexcomm9Trigger                 = 5U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexcomm9Trigger               = 6U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexcomm9Trigger               = 7U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToFlexcomm9Trigger               = 8U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToFlexcomm9Trigger               = 9U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToFlexcomm9Trigger               = 10U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexcomm9Trigger                  = 11U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexcomm9Trigger                  = 12U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexcomm9Trigger                 = 13U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexcomm9Trigger           = 14U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexcomm9Trigger                 = 15U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexcomm9Trigger                 = 16U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexcomm9Trigger                 = 17U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexcomm9Trigger               = 18U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexcomm9Trigger               = 19U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexcomm9Trigger               = 20U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexcomm9Trigger               = 21U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexcomm9Trigger               = 22U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexcomm9Trigger               = 23U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexcomm9Trigger               = 24U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexcomm9Trigger               = 25U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexcomm9Trigger                 = 26U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexcomm9Trigger                 = 27U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexcomm9Trigger                 = 28U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexcomm9Trigger                 = 29U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexcomm9Trigger                 = 30U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn10ToFlexcomm9Trigger                = 31U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn11ToFlexcomm9Trigger                = 32U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh4ToFlexcomm9Trigger               = 33U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh5ToFlexcomm9Trigger               = 34U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh6ToFlexcomm9Trigger               = 35U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_FlexioCh7ToFlexcomm9Trigger               = 36U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Usb0IppIndUartRxdUsbmuxToFlexcomm9Trigger = 37U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig0ToFlexcomm9Trigger      = 38U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio2PinEventTrig1ToFlexcomm9Trigger      = 39U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig0ToFlexcomm9Trigger      = 40U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_Gpio3PinEventTrig1ToFlexcomm9Trigger      = 41U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexcomm9Trigger                     = 42U + (FLEXCOMM9_TRIG_REG << PMUX_SHIFT),

    /*!< FlexIO trigger input connections. */
    kINPUTMUX_PinInt4ToFlexioTrigger          = 0U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt5ToFlexioTrigger          = 1U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt6ToFlexioTrigger          = 2U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_PinInt7ToFlexioTrigger          = 3U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut5ToFlexioTrigger          = 4U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut6ToFlexioTrigger          = 5U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut7ToFlexioTrigger          = 6U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut8ToFlexioTrigger          = 7U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SctOut9ToFlexioTrigger          = 8U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToFlexioTrigger        = 9U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToFlexioTrigger        = 10U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToFlexioTrigger        = 11U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToFlexioTrigger        = 12U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToFlexioTrigger        = 13U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr0ToFlexioTrigger           = 14U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lptmr1ToFlexioTrigger           = 15U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToFlexioTrigger          = 16U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToFlexioTrigger    = 17U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp0ToFlexioTrigger       = 18U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp1ToFlexioTrigger       = 19U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp2ToFlexioTrigger       = 20U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc0Tcomp3ToFlexioTrigger       = 21U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp0ToFlexioTrigger       = 22U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp1ToFlexioTrigger       = 23U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp2ToFlexioTrigger       = 24U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Adc1Tcomp3ToFlexioTrigger       = 25U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToFlexioTrigger          = 26U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp1OutToFlexioTrigger          = 27U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Cmp2OutToFlexioTrigger          = 28U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig0ToFlexioTrigger      = 29U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A0Trig1ToFlexioTrigger      = 30U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig0ToFlexioTrigger      = 31U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A1Trig1ToFlexioTrigger      = 32U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig0ToFlexioTrigger      = 33U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A2Trig1ToFlexioTrigger      = 34U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig0ToFlexioTrigger      = 35U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm0A3Trig1ToFlexioTrigger      = 36U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig0ToFlexioTrigger      = 37U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A0Trig1ToFlexioTrigger      = 38U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig0ToFlexioTrigger      = 39U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A1Trig1ToFlexioTrigger      = 40U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig0ToFlexioTrigger      = 41U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A2Trig1ToFlexioTrigger      = 42U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig0ToFlexioTrigger      = 43U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Pwm1A3Trig1ToFlexioTrigger      = 44U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0AToFlexioTrigger        = 45U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut0BToFlexioTrigger        = 46U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1AToFlexioTrigger        = 47U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut1BToFlexioTrigger        = 48U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2AToFlexioTrigger        = 49U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut2BToFlexioTrigger        = 50U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3AToFlexioTrigger        = 51U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_EvtgOut3BToFlexioTrigger        = 52U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn0ToFlexioTrigger          = 53U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn1ToFlexioTrigger          = 54U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn2ToFlexioTrigger          = 55U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn3ToFlexioTrigger          = 56U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_TrigIn4ToFlexioTrigger          = 57U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh0ToFlexioTrigger    = 58U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh1ToFlexioTrigger    = 59U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh2ToFlexioTrigger    = 60U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh3ToFlexioTrigger    = 61U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_SincFilterCh4ToFlexioTrigger    = 62U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm0Trig0ToFlexioTrigger = 63U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm0Trig1ToFlexioTrigger = 64U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm0Trig2ToFlexioTrigger = 65U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm1Trig0ToFlexioTrigger = 66U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm1Trig1ToFlexioTrigger = 67U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm1Trig2ToFlexioTrigger = 68U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm2Trig0ToFlexioTrigger = 69U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm2Trig1ToFlexioTrigger = 70U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm2Trig2ToFlexioTrigger = 71U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig0ToFlexioTrigger = 72U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig1ToFlexioTrigger = 73U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig2ToFlexioTrigger = 74U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_Lpflexcomm3Trig3ToFlexioTrigger = 75U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
    kINPUTMUX_WuuToFlexioTrigger              = 76U + (FLEXIO_TRIG0_REG << PMUX_SHIFT),
} inputmux_connection_t;

/*! @brief INPUTMUX signal enable/disable type */
typedef enum _inputmux_signal_t
{
    /*!< DMA0 REQ ENABLE0 signal. */
    kINPUTMUX_FlexSpi0RxToDma0Ch1Ena          = 1U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_FlexSpi0TxToDma0Ch2Ena          = 2U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_PinInt0ToDma0Ch3Ena             = 3U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_PinInt1ToDma0Ch4Ena             = 4U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_PinInt2ToDma0Ch5Ena             = 5U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_PinInt3ToDma0Ch6Ena             = 6U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer0M0ToDma0Ch7Ena           = 7U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer0M1ToDma0Ch8Ena           = 8U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer1M0ToDma0Ch9Ena           = 9U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer1M1ToDma0Ch10Ena          = 10U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer2M0ToDma0Ch11Ena          = 11U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer2M1ToDma0Ch12Ena          = 12U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer3M0ToDma0Ch13Ena          = 13U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer3M1ToDma0Ch14Ena          = 14U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer4M0ToDma0Ch15Ena          = 15U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer4M1ToDma0Ch16Ena          = 16U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Wuu0ToDma0Ch17Ena               = 17U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Micfil0FifoRequestToDma0Ch18Ena = 18U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Sct0Dma0ToDma0Ch19Ena           = 19U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Sct0Dma1ToDma0Ch20Ena           = 20U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Adc0FifoARequestToDma0Ch21Ena   = 21U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Adc0FifoBRequestToDma0Ch22Ena   = 22U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Adc1FifoARequestToDma0Ch23Ena   = 23U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Adc1FifoBRequestoDma0Ch24Ena    = 24U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Dac0FifoRequestToDma0Ch25Ena    = 25U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Dac1FifoRequestToDma0Ch26Ena    = 26U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_HpDac0FifoRequestToDma0Ch27Ena  = 27U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_HsCmp0DmaRequestToDma0Ch28Ena   = 28U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_HsCmp1DmaRequestToDma0Ch29Ena   = 29U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_HsCmp2DmaRequestToDma0Ch30Ena   = 30U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out0AToDma0Ch31Ena         = 31U + (DMA0_REQ_ENABLE0_REG << ENA_SHIFT),

    /*!< DMA0 REQ ENABLE1 signal. */
    kINPUTMUX_Evtg0Out0BToDma0Ch32Ena                   = 0U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out1AToDma0Ch33Ena                   = 1U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out1BToDma0Ch34Ena                   = 2U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out2AToDma0Ch35Ena                   = 3U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out2BToDma0Ch36Ena                   = 4U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out3AToDma0Ch37Ena                   = 5U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out3BToDma0Ch38Ena                   = 6U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt0ToDma0Ch39Ena             = 7U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt1ToDma0Ch40Ena             = 8U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt2ToDma0Ch41Ena             = 9U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt3ToDma0Ch42Ena             = 10U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal0ToDma0Ch43Ena              = 11U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal1ToDma0Ch44Ena              = 12U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal2ToDma0Ch45Ena              = 13U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal3ToDma0Ch46Ena              = 14U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt0ToDma0Ch47Ena             = 15U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt1ToDma0Ch48Ena             = 16U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt2ToDma0Ch49Ena             = 17U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt3ToDma0Ch50Ena             = 18U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal0ToDma0Ch51Ena              = 19U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal1ToDma0Ch52Ena              = 20U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal2ToDma0Ch53Ena              = 21U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal3ToDma0Ch54Ena              = 22U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Itrc0TmprOut0ToDma0Ch55Ena                = 23U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Itrc0TmprOut1ToDma0Ch56Ena                = 24U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Lptmr0ToDma0Ch57Ena                       = 25U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Lptmr1ToDma0Ch58Ena                       = 26U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexCan0DmaRequestToDma0Ch59Ena           = 27U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexCan1DmaRequestToDma0Ch60Ena           = 28U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister0RequestToDma0Ch61Ena = 29U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister1RequestToDma0Ch62Ena = 30U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister2RequestToDma0Ch63Ena = 31U + (DMA0_REQ_ENABLE1_REG << ENA_SHIFT),

    /*!< DMA0 REQ ENABLE2 signal. */
    kINPUTMUX_FlexIO0ShiftRegister3RequestToDma0Ch64Ena = 0U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister4RequestToDma0Ch65Ena = 1U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister5RequestToDma0Ch66Ena = 2U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister6RequestToDma0Ch67Ena = 3U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister7RequestToDma0Ch68Ena = 4U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm0RxToDma0Ch69Ena                = 5U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm0TxToDma0Ch70Ena                = 6U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm1RxToDma0Ch71Ena                = 7U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm1TxToDma0Ch72Ena                = 8U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm2RxToDma0Ch73Ena                = 9U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm2TxToDma0Ch74Ena                = 10U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm3RxToDma0Ch75Ena                = 11U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm3TxToDma0Ch76Ena                = 12U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm4RxToDma0Ch77Ena                = 13U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm4TxToDma0Ch78Ena                = 14U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm5RxToDma0Ch79Ena                = 15U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm5TxToDma0Ch80Ena                = 16U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm6RxToDma0Ch81Ena                = 17U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm6TxToDma0Ch82Ena                = 18U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm7RxToDma0Ch83Ena                = 19U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm7TxToDma0Ch84Ena                = 20U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm8RxToDma0Ch85Ena                = 21U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm8TxToDma0Ch86Ena                = 22U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm9RxToDma0Ch87Ena                = 23U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm9TxToDma0Ch88Ena                = 24U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_ESpi0Ch0ToDma0Ch89Ena                     = 25U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_ESpi0Ch1ToDma0Ch90Ena                     = 26U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_EmvSim0RxToDma0Ch91Ena                    = 27U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_EmvSim0TxToDma0Ch92Ena                    = 28U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_EmvSim1RxToDma0Ch93Ena                    = 29U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_EmvSim1TxToDma0Ch94Ena                    = 30U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_I3c0RxToDma0Ch95Ena                       = 31U + (DMA0_REQ_ENABLE2_REG << ENA_SHIFT),

    /*!< DMA0 REQ ENABLE3 signal. */
    kINPUTMUX_I3c0TxToDma0Ch96Ena                 = 0U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_I3c1RxToDma0Ch97Ena                 = 1U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_I3c1TxToDma0Ch98Ena                 = 2U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sai0RxToDma0Ch99Ena                 = 3U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sai0TxToDma0Ch100Ena                = 4U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sai1RxToDma0Ch101Ena                = 5U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sai1TxToDma0Ch102Ena                = 6U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt0ToDma0Ch103Ena   = 7U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt1ToDma0Ch104Ena   = 8U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt2ToDma0Ch105Ena   = 9U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt3ToDma0Ch106Ena   = 10U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt4ToDma0Ch107Ena   = 11U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio0PinEventRequest0ToDma0Ch108Ena = 12U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio0PinEventRequest1ToDma0Ch109Ena = 13U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio1PinEventRequest0ToDma0Ch110Ena = 14U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio1PinEventRequest1ToDma0Ch111Ena = 15U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio2PinEventRequest0ToDma0Ch112Ena = 16U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio2PinEventRequest1ToDma0Ch113Ena = 17U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio3PinEventRequest0ToDma0Ch114Ena = 18U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio3PinEventRequest1ToDma0Ch115Ena = 19U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio4PinEventRequest0ToDma0Ch116Ena = 20U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio4PinEventRequest1ToDma0Ch117Ena = 21U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio5PinEventRequest0ToDma0Ch118Ena = 22U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio5PinEventRequest1ToDma0Ch119Ena = 23U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Tsi0EndOfScanToDma0Ch120Ena         = 24U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Tsi0OutOfRangeToDma0Ch121Ena        = 25U + (DMA0_REQ_ENABLE3_REG << ENA_SHIFT),

    /*!< DMA1 REQ ENABLE0 signal. */
    kINPUTMUX_FlexSpi0RxToDma1Ch1Ena          = 1U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_FlexSpi0TxToDma1Ch2Ena          = 2U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_PinInt0ToDma1Ch3Ena             = 3U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_PinInt1ToDma1Ch4Ena             = 4U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_PinInt2ToDma1Ch5Ena             = 5U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_PinInt3ToDma1Ch6Ena             = 6U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer0M0ToDma1Ch7Ena           = 7U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer0M1ToDma1Ch8Ena           = 8U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer1M0ToDma1Ch9Ena           = 9U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer1M1ToDma1Ch10Ena          = 10U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer2M0ToDma1Ch11Ena          = 11U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer2M1ToDma1Ch12Ena          = 12U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer3M0ToDma1Ch13Ena          = 13U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer3M1ToDma1Ch14Ena          = 14U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer4M0ToDma1Ch15Ena          = 15U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Ctimer4M1ToDma1Ch16Ena          = 16U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Wuu0ToDma1Ch17Ena               = 17U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Micfil0FifoRequestToDma1Ch18Ena = 18U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Sct0Dma0ToDma1Ch19Ena           = 19U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Sct0Dma1ToDma1Ch20Ena           = 20U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Adc0FifoARequestToDma1Ch21Ena   = 21U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Adc0FifoBRequestToDma1Ch22Ena   = 22U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Adc1FifoARequestToDma1Ch23Ena   = 23U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Adc1FifoBRequestToDma1Ch24Ena   = 24U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Dac0FifoRequestToDma1Ch25Ena    = 25U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Dac1FifoRequestToDma1Ch26Ena    = 26U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_HpDac0FifoRequestToDma1Ch27Ena  = 27U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_HsCmp0DmaRequestToDma1Ch28Ena   = 28U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_HsCmp1DmaRequestToDma1Ch29Ena   = 29U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_HsCmp2DmaRequestToDma1Ch30Ena   = 30U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out0AToDma1Ch31Ena         = 31U + (DMA1_REQ_ENABLE0_REG << ENA_SHIFT),

    /*!< DMA1 REQ ENABLE1 signal. */
    kINPUTMUX_Evtg0Out0BToDma1Ch32Ena                   = 0U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out1AToDma1Ch33Ena                   = 1U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out1BToDma1Ch34Ena                   = 2U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out2AToDma1Ch35Ena                   = 3U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out2BToDma1Ch36Ena                   = 4U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out3AToDma1Ch37Ena                   = 5U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Evtg0Out3BToDma1Ch38Ena                   = 6U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt0ToDma1Ch39Ena             = 7U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt1ToDma1Ch40Ena             = 8U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt2ToDma1Ch41Ena             = 9U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqCapt3ToDma1Ch42Ena             = 10U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal0ToDma1Ch43Ena              = 11U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal1ToDma1Ch44Ena              = 12U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal2ToDma1Ch45Ena              = 13U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm0ReqVal3ToDma1Ch46Ena              = 14U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt0ToDma1Ch47Ena             = 15U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt1ToDma1Ch48Ena             = 16U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt2ToDma1Ch49Ena             = 17U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqCapt3ToDma1Ch50Ena             = 18U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal0ToDma1Ch51Ena              = 19U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal1ToDma1Ch52Ena              = 20U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal2ToDma1Ch53Ena              = 21U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexPwm1ReqVal3ToDma1Ch54Ena              = 22U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Itrc0TmprOut0ToDma1Ch55Ena                = 23U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Itrc0TmprOut1ToDma1Ch56Ena                = 24U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Lptmr0ToDma1Ch57Ena                       = 25U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_Lptmr1ToDma1Ch58Ena                       = 26U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexCan0DmaRequestToDma1Ch59Ena           = 27U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexCan1DmaRequestToDma1Ch60Ena           = 28U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister0RequestToDma1Ch61Ena = 29U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister1RequestToDma1Ch62Ena = 30U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister2RequestToDma1Ch63Ena = 31U + (DMA1_REQ_ENABLE1_REG << ENA_SHIFT),

    /*!< DMA1 REQ ENABLE2 signal. */
    kINPUTMUX_FlexIO0ShiftRegister3RequestToDma1Ch64Ena = 0U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister4RequestToDma1Ch65Ena = 1U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister5RequestToDma1Ch66Ena = 2U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister6RequestToDma1Ch67Ena = 3U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_FlexIO0ShiftRegister7RequestToDma1Ch68Ena = 4U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm0RxToDma1Ch69Ena                = 5U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm0TxToDma1Ch70Ena                = 6U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm1RxToDma1Ch71Ena                = 7U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm1TxToDma1Ch72Ena                = 8U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm2RxToDma1Ch73Ena                = 9U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm2TxToDma1Ch74Ena                = 10U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm3RxToDma1Ch75Ena                = 11U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm3TxToDma1Ch76Ena                = 12U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm4RxToDma1Ch77Ena                = 13U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm4TxToDma1Ch78Ena                = 14U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm5RxToDma1Ch79Ena                = 15U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm5TxToDma1Ch80Ena                = 16U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm6RxToDma1Ch81Ena                = 17U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm6TxToDma1Ch82Ena                = 18U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm7RxToDma1Ch83Ena                = 19U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm7TxToDma1Ch84Ena                = 20U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm8RxToDma1Ch85Ena                = 21U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm8TxToDma1Ch86Ena                = 22U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm9RxToDma1Ch87Ena                = 23U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_LpFlexcomm9TxToDma1Ch88Ena                = 24U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_ESpi0Ch0ToDma1Ch89Ena                     = 25U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_ESpi0Ch1ToDma1Ch90Ena                     = 26U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_EmvSim0RxToDma1Ch91Ena                    = 27U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_EmvSim0TxToDma1Ch92Ena                    = 28U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_EmvSim1RxToDma1Ch93Ena                    = 29U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_EmvSim1TxToDma1Ch94Ena                    = 30U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),
    kINPUTMUX_I3c0RxToDma1Ch95Ena                       = 31U + (DMA1_REQ_ENABLE2_REG << ENA_SHIFT),

    /*!< DMA1 REQ ENABLE3 signal. */
    kINPUTMUX_I3c0TxToDma1Ch96Ena                 = 0U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_I3c1RxToDma1Ch97Ena                 = 1U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_I3c1TxToDma1Ch98Ena                 = 2U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sai0RxToDma1Ch99Ena                 = 3U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sai0TxToDma1Ch100Ena                = 4U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sai1RxToDma1Ch101Ena                = 5U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sai1TxToDma1Ch102Ena                = 6U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt0ToDma1Ch103Ena   = 7U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt1ToDma1Ch104Ena   = 8U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt2ToDma1Ch105Ena   = 9U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt3ToDma1Ch106Ena   = 10U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Sinc0IpdReqSincAlt4ToDma1Ch107Ena   = 11U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio0PinEventRequest0ToDma1Ch108Ena = 12U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio0PinEventRequest1ToDma1Ch109Ena = 13U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio1PinEventRequest0ToDma1Ch110Ena = 14U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio1PinEventRequest1ToDma1Ch111Ena = 15U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio2PinEventRequest0ToDma1Ch112Ena = 16U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio2PinEventRequest1ToDma1Ch113Ena = 17U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio3PinEventRequest0ToDma1Ch114Ena = 18U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio3PinEventRequest1ToDma1Ch115Ena = 19U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio4PinEventRequest0ToDma1Ch116Ena = 20U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio4PinEventRequest1ToDma1Ch117Ena = 21U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio5PinEventRequest0ToDma1Ch118Ena = 22U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Gpio5PinEventRequest1ToDma1Ch119Ena = 23U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Tsi0EndOfScanToDma1Ch120Ena         = 24U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
    kINPUTMUX_Tsi0OutOfRangeToDma1Ch121Ena        = 25U + (DMA1_REQ_ENABLE3_REG << ENA_SHIFT),
} inputmux_signal_t;

/*@}*/

/*@}*/

#endif /* _FSL_INPUTMUX_CONNECTIONS_ */
