/****************************************************************************
**
** Copyright 2024 NXP
**
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************/

#include "command_handler.h"

static event_sender_t Handler[VIT_WW_NUMBER][VIT_CMD_NUMBER+1];

void start_command_handler(void);
void* command_handler_thread(void* args);
void command_handler_link(voice_ww_t WW_Id, voice_cmd_t CMD, lv_obj_t** obj, lv_event_code_t event);

void start_command_handler(void)
{
    pthread_t thread;
    //Creating thread with the handler
    pthread_create(&thread, NULL, &command_handler_thread, NULL);
}

void* command_handler_thread(void* args)
{
    struct mq_attr attr;
    static mqd_t cmd_q;
    static mqd_t ww_q;
    static char cmd_buffer[BUFFER_SIZE];
    static char ww_buffer[BUFFER_SIZE];
    static char received_ww = 0;
    static char received_cmd = 0;
    static int ww;
    static int cmd;
    static lv_res_t event_error = LV_RES_INV;

    attr.mq_curmsgs = 0;
    attr.mq_flags = 0;
    attr.mq_maxmsg = MAX_MSG;
    attr.mq_msgsize = MAX_MSG_SIZE;

    ww_q = mq_open(WW_QUEUE_NAME, O_RDONLY | O_CREAT, S_IFIFO , &attr);
    if(ww_q < 0)
        printf("CMD_HANDLER: Error reading ww mq \n");
    cmd_q = mq_open(CMD_QUEUE_NAME, O_RDONLY | O_CREAT, S_IFIFO , &attr);
    if(cmd_q < 0)
        printf("CMD_HANDLER: Error reading cmd mq \n");
    while(1)
    {
        if(HANDLER_VERBOSE)
            printf("CMD_HANDLER: Waiting for message\n");
        //WAKEWORD
        received_ww = mq_receive(ww_q, ww_buffer, attr.mq_msgsize, 0);

        ww = atoi(ww_buffer); 
        if(HANDLER_VERBOSE)
            printf("CMD_HANDLER: WW arrived %s, Atoi: %d \n", ww_buffer, ww);

        //CMD
        received_cmd = mq_receive(cmd_q, cmd_buffer, attr.mq_msgsize, 0);
        cmd = atoi(cmd_buffer);

        if(HANDLER_VERBOSE)
            printf("CMD_HANDLER: CMD arrived %s, Aoti: %d \n", cmd_buffer, cmd);
        if(Handler[ww-1][cmd].cmd > 0)
        {
            if(HANDLER_VERBOSE)
                printf("CMD_HANDLER: Event_send %d\n", Handler[ww-1][cmd].cmd);
            if(NULL == Handler[ww-1][cmd].obj && HANDLER_VERBOSE)
                printf("CMD_HANDLER ERROR: Sending event to null object\n");
            //Simulating event trigger 
            event_error = lv_event_send(((lv_obj_t*)(*Handler[ww-1][cmd].obj)), Handler[ww-1][cmd].cmd, NULL);
        }

    }

}

void command_handler_link(voice_ww_t WW_Id, voice_cmd_t cmd, lv_obj_t** obj, lv_event_code_t event)
{   
    if(obj == NULL)
        printf("CMD_HANDLER ERROR: Null object linked to voice command %d \n", cmd);
    Handler[WW_Id-1][cmd].obj = obj;
    Handler[WW_Id-1][cmd].cmd = event;
}
