@rem Copyright 2024 NXP
@rem SPDX-License-Identifier: BSD-3-Clause
@echo off
@rem Environment variables - absolute paths simplifying re-use of the script on another machine
@rem  - Absolute path to SPT workspace (it is recommended to copy/move all user files in this workspace)
SETLOCAL ENABLEDELAYEDEXPANSION
if "%SPT_WORKSPACE%"=="" (
  SET "SPT_WORKSPACE=%~dp0"
  SET "SPT_WORKSPACE=!SPT_WORKSPACE:~0,-1!"
  FOR %%i in ("!SPT_WORKSPACE!") DO (
    SET "SPT_WORKSPACE=%%~dpi"
  )
  SET "SPT_WORKSPACE=!SPT_WORKSPACE:~0,-1!"
)
ENDLOCAL & SET "SPT_WORKSPACE=%SPT_WORKSPACE%"
if not exist "%SPT_WORKSPACE%\" (
  @echo FAILURE: Directory not found "%SPT_WORKSPACE%"
  exit 2
)
@rem  - Absolute path to SPT installation directory
if "%SPT_INSTALL_BIN%"=="" (
  SET "SPT_INSTALL_BIN=C:\Users\nxf47345\Desktop\securep_b240623\_internal"
)
if not exist "%SPT_INSTALL_BIN%\" (
  @echo FAILURE: Directory not found "%SPT_INSTALL_BIN%"
  exit 2
)

@echo Sign the application using imgtool
@set imgtool=%SPT_INSTALL_BIN%\tools\imgtool\imgtool.exe
@set nxpimage=%SPT_INSTALL_BIN%\tools_scripts\nxpimage_spsdk_win_wrapper.bat

@rem Convert image format
call "%nxpimage%" utils binary-image convert -i "C:\Users\nxf47345\OneDrive - NXP\work\MCX\MCX A10\software\a10_secure_boot\frdmmcxa153_ota_mcuboot_basic\Debug\frdmmcxa153_ota_mcuboot_basic.axf" -f BIN -o "%SPT_WORKSPACE%\bootable_images\frdmmcxa153_ota_mcuboot_basic_converted_mcuboot_app_image.bin"
if errorlevel 2 exit 2

@echo on
"%imgtool%" sign ^
  --version 1.0 ^
  --header-size 0x200 ^
  --pad-header ^
  --slot-size 0xC000 ^
  --align 16 ^
  --pad ^
  --confirm ^
  --key "C:\Users\nxf47345\OneDrive - NXP\work\MCX\MCX A10\software\a10_secure_boot\frdmmcxa153_mcuboot_opensource\keys\sign-ecdsa-p256-priv.pem" ^
  "%SPT_WORKSPACE%\bootable_images\frdmmcxa153_ota_mcuboot_basic_converted_mcuboot_app_image.bin" ^
  "%SPT_WORKSPACE%\bootable_images\frdmmcxa153_ota_mcuboot_basic_signed.bin"
if errorlevel 1 exit 2

@echo Successfuly signed the application using imgtool: %SPT_WORKSPACE%\bootable_images\frdmmcxa153_ota_mcuboot_basic_signed.bin