/* ---------------------------------------------------------------------------- */
/* Copyright 2020, 2024 NXP.                                                    */
/* SPDX-License-Identifier: BSD-3-Clause                                        */
/*                                                                              */
/* This software is owned or controlled by NXP and may only be used strictly    */
/* in accordance with the applicable license terms. By expressly accepting such */
/* terms or by downloading, installing, activating and/or otherwise using the   */
/* software, you are agreeing that you have read, and that you agree to comply  */
/* with and are bound by, such license terms. If you do not agree to be bound   */
/* by the applicable license terms, then you may not retain, install, activate  */
/* or otherwise use the software.                                               */
/* ---------------------------------------------------------------------------- */

#ifndef APP_DEFINES_H_
#define APP_DEFINES_H_

/* Enable/disable each USB-related feature */
#define USB_CHAT_SPEAKER_ENABLE    (1)
#define USB_GAME_SPEAKER_ENABLE    (1)
#define USB_RECORDER_ENABLE        (1)
#define USB_HID_ENABLE             (1)
#define USB_HCI_VCOM_ENABLE        (0)
/* TODO the other features: LOG_VCOM */
#define USB_SUSPEND_RESUME_ENABLE  (1)

/* Whether device is self power. 1U supported, 0U not supported */
#define USB_SELF_POWER  (0U)

/* USB service speaker count */
#define USB_SPEAKER_CNT  (USB_CHAT_SPEAKER_ENABLE + USB_GAME_SPEAKER_ENABLE)

/* Enable/disable voice prompt */
#define VOICE_PROMPT_ENABLE  (0)

/* Audio service speaker count */
#define AUDIO_SERVICE_SPEAKER_CNT   (USB_SPEAKER_CNT + VOICE_PROMPT_ENABLE)
/* Audio service recorder count */
#define AUDIO_SERVICE_RECORDER_CNT  (USB_RECORDER_ENABLE)

#endif /* APP_DEFINES_H_ */
