/*
 * Copyright 2019-2020, 2024 NXP
 * SPDX-License-Identifier: BSD-3-Clause
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef AUDIO_RX_H_
#define AUDIO_RX_H_

/* ---------------------------------------------------------------------------- */
/* Include files                                                                */
/* ---------------------------------------------------------------------------- */

#include <stdint.h>

/* -------------------------------------------------------------------------
 * Public functions
 * ------------------------------------------------------------------------- */

/**
 * Reads the data of the input ring buffer.
 * @note The Receiver starts itself as soon as enough samples were buffered.
 *
 * @param pOutBuffer buffer that is going to be read.
 * @param NbSamples Number of samples to read.
 */
void audio_ReadBuffer(uint8_t *pOutBuffer, uint16_t NbSamples);

/**
 * Returns the current available space in the rx buffer.
 *
 * @return rx available space.
 */
uint32_t audio_RxAvailableSpace(void);

/**
 * Returns the current rx buffer size.
 *
 * @return current buffer size.
 */
uint32_t audio_GetRxBufferSize(void);

/**
 * Initialization of Receiver part of audio
 *  Configures I2S, Inits I2S, Inits Audio Formats, Inits SAI,
 *  Inits DMA
 */
void audio_InitRx(void);

/**
 * Start receiving audio samples from I2S
 *  Starts DMA, Starts SAI
 */
void audio_StartRx(void);

/**
 * Stops the data reception.
 */
void audio_StopRx(void);

/**
 * Resets the receiver
 */
void audio_ResetRx(void);


#endif /* AUDIO_RX_H_ */
