/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: TEE v4.0
processor: MIMXRT595S
package_id: MIMXRT595SFFOC
mcu_data: ksdk2_0
processor_version: 0.10.11
board: MIMXRT595-EVK
toolOptions:
  _output_type_: c_code
  _legacy_source_names_: 'yes'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "fsl_common.h"
#if (__ARM_FEATURE_CMSE & 3)
#include "tzm_config.h"

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/* SAU for non-secure region definition */
#define RAM_SAU_REGION_0_BASE 0x00100000U
#define RAM_SAU_REGION_0_END  0x0017FFFFU

/* Secure - non-secure callable */
#define RAM_SAU_REGION_1_BASE 0x100BF000U
#define RAM_SAU_REGION_1_END  0x100BFFFFU

/* Secure Data SRAM */
#define RAM_SAU_REGION_2_BASE 0x00040000U
#define RAM_SAU_REGION_2_END  0x0007FFFFU

#define RAM_SAU_REGION_3_BASE 0x28000000U
#define RAM_SAU_REGION_3_END  0x29000000U

#define RAM_SAU_REGION_4_BASE 0x40000000U
#define RAM_SAU_REGION_4_END  0x4FFFFFFFU

#if defined(__ICCARM__)
#pragma optimize=none
#endif

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : RAM
 * Description   :
 *
 * END ****************************************************************************************************************/

/***********************************************************************************************************************
 * RAM_BOARD_InitTrustZone function
 **********************************************************************************************************************/
void RAM_BOARD_InitTrustZone()
{
    /* SAU configuration */

    /* Set SAU Control register: Disable SAU and All Secure */
    SAU->CTRL = 0;

    /* Set SAU region number */
    SAU->RNR = 0;
    /* Region base address */
    SAU->RBAR = RAM_SAU_REGION_0_BASE & SAU_RBAR_BADDR_Msk;
    /* Region end address */
    SAU->RLAR = (RAM_SAU_REGION_0_END & SAU_RLAR_LADDR_Msk) | ((0U << SAU_RLAR_NSC_Pos) & SAU_RLAR_NSC_Msk) |
                ((1U << SAU_RLAR_ENABLE_Pos) & SAU_RLAR_ENABLE_Msk);

    /* Set SAU region number */
    SAU->RNR = 1;
    /* Region base address */
    SAU->RBAR = RAM_SAU_REGION_1_BASE & SAU_RBAR_BADDR_Msk;
    /* Region end address */
    SAU->RLAR = (RAM_SAU_REGION_1_END & SAU_RLAR_LADDR_Msk) | ((1U << SAU_RLAR_NSC_Pos) & SAU_RLAR_NSC_Msk) |
                ((1U << SAU_RLAR_ENABLE_Pos) & SAU_RLAR_ENABLE_Msk);

    /* Set SAU region number */
    SAU->RNR = 2;
    /* Region base address */
    SAU->RBAR = RAM_SAU_REGION_2_BASE & SAU_RBAR_BADDR_Msk;
    /* Region end address */
    SAU->RLAR = (RAM_SAU_REGION_2_END & SAU_RLAR_LADDR_Msk) | ((0U << SAU_RLAR_NSC_Pos) & SAU_RLAR_NSC_Msk) |
                ((1U << SAU_RLAR_ENABLE_Pos) & SAU_RLAR_ENABLE_Msk);

    /* Set SAU region number */
    SAU->RNR = 3;
    /* Region base address */
    SAU->RBAR = RAM_SAU_REGION_3_BASE & SAU_RBAR_BADDR_Msk;
    /* Region end address */
    SAU->RLAR = (RAM_SAU_REGION_3_END & SAU_RLAR_LADDR_Msk) | ((0U << SAU_RLAR_NSC_Pos) & SAU_RLAR_NSC_Msk) |
                ((1U << SAU_RLAR_ENABLE_Pos) & SAU_RLAR_ENABLE_Msk);
#if 0
    /* Set SAU region number */
    SAU->RNR = 4;
    /* Region base address */
    SAU->RBAR = RAM_SAU_REGION_4_BASE & SAU_RBAR_BADDR_Msk;
    /* Region end address */
    SAU->RLAR = (RAM_SAU_REGION_4_END & SAU_RLAR_LADDR_Msk) | ((0U << SAU_RLAR_NSC_Pos) & SAU_RLAR_NSC_Msk) |
                ((1U << SAU_RLAR_ENABLE_Pos) & SAU_RLAR_ENABLE_Msk);
#endif
    /* Force memory writes before continuing */
    __DSB();
    /* Flush and refill pipeline with updated permissions */
    __ISB();

    /* Set SAU Control register: Enable SAU and All Secure (applied only if disabled) */
    SAU->CTRL = ((0U << SAU_CTRL_ALLNS_Pos) & SAU_CTRL_ALLNS_Msk) | ((1U << SAU_CTRL_ENABLE_Pos) & SAU_CTRL_ENABLE_Msk);
    
    /*--------------------------------------------------------------------
     - Interrupts: Interrupt security configuration
     -------------------------------------------------------------------*/
    /* Possible values for every interrupt:
     *  0b0    Secure
     *  0b1    Non-secure */
    NVIC->ITNS[0] = 0;
    NVIC->ITNS[1] = 0;
    NVIC->ITNS[2] = 0;

    /* Global Options */
    SCB->AIRCR = (SCB->AIRCR & 0x000009FF7U) | 0x005FA0000U; /* Only secure domain can reset CM33 */
    SCB->SCR &= 0x0FFFFFFF7U;                                 /* SLEEPDEEPS = 0 - deepsleep can be accessible for both state */
    SCB->SHCSR &= 0x0FFF7FFFFU;                               /* SECUREFAULTENA = 0, disable secure fault */
    SCB->NSACR                               = 0x00000C03U;   /* Allow non-secure access co-processor interface */
    SCnSCB->CPPWR                            = 0;              /* */
}

#endif

