/*
 * Copyright 2024-2025 NXP
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _SHARED_MEMORY_DEF_H_
#define _SHARED_MEMORY_DEF_H_

#define CPU1_EPT_ADDR (30U)
#define CPU0_EPT_ADDR (40U)
#define HIFI4_EPT_ADDR (50U)
#define HIFI1_EPT_ADDR (60U)
#define EZHV_EPT_ADDR  (70U)

#define CPU0_CPU1_RPMSG_LITE_BASE (0x20060000)
#define CPU0_CPU1_SH_MEM_TOTAL_SIZE (0x8000)

#define CPU0_EZHV_RPMSG_LITE_BASE (0x20068000)
#define CPU0_EZHV_SH_MEM_TOTAL_SIZE (0x8000)

#define CPU0_HIFI4_RPMSG_LITE_BASE (0x20070000)
#define CPU0_HIFI4_SH_MEM_TOTAL_SIZE (0x8000)

#define CPU1_HIFI1_RPMSG_LITE_BASE (0x205B0000)
#define CPU1_HIFI1_SH_MEM_TOTAL_SIZE (0x8000)


#define CPU0_HIFI4_PARCEL_DATA_SIZE (32)
typedef struct _cpu0_hifi4_parcel {
    uint8_t data[CPU0_HIFI4_PARCEL_DATA_SIZE];
} cpu0_hifi4_parcel_t;

#define HIFI4_CPU0_PARCEL_DATA_SIZE (32)
typedef struct _hifi4_cpu0_parcel {
    uint8_t data[HIFI4_CPU0_PARCEL_DATA_SIZE];
} hifi4_cpu0_parcel_t;

#define CPU0_CPU1_PARCEL_DATA_SIZE (32)
typedef struct _cpu0_cpu1_parcel {
    uint8_t data[CPU0_CPU1_PARCEL_DATA_SIZE];
} cpu0_cpu1_parcel_t;

#define CPU1_CPU0_PARCEL_DATA_SIZE (32)
typedef struct _cpu1_cpu0_parcel {
    uint8_t data[CPU1_CPU0_PARCEL_DATA_SIZE];
} cpu1_cpu0_parcel_t;

#define CPU1_HIFI1_PARCEL_DATA_SIZE (32)
typedef struct _cpu1_hifi1_parcel {
    uint8_t data[CPU1_HIFI1_PARCEL_DATA_SIZE];
} cpu1_hifi1_parcel_t;

#define HIFI1_CPU1_PARCEL_DATA_SIZE (32)
typedef struct _hifi1_cpu1_parcel {
    uint8_t data[HIFI1_CPU1_PARCEL_DATA_SIZE];
} hifi1_cpu1_parcel_t;

#define CPU0_EZHV_PARCEL_DATA_SIZE (32)
typedef struct _cpu0_ezhv_parcel {
    uint8_t data[CPU0_EZHV_PARCEL_DATA_SIZE];
} cpu0_ezhv_parcel_t;

#endif /* _SHARED_MEMORY_DEF_H_ */
