/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>

#include "fsl_gpio.h"
#include "fsl_debug_console.h"
#include "GlobalDef.h"
#include "AudioProcess.h"

#include "Sweep.h"


#if EnableAsrcLatencyTest==1
extern int AsrcLatencyTestCnt;
#endif

//should only have one var defined in section "NonCacheableShareWithMcu", so that the shared var block will have the same address as in the MCU prj
__attribute__((__section__("NonCacheableShareWithMcu")))
volatile T_CommonVarSharedByDspAndMcu VarBlockSharedByDspAndMcu;
//Note: the cir buffers in the above struct is to be initialized in MCU --- no need to init it in this DSP code

extern int AudioProcFrameCnt;

__attribute__((aligned(16))) __attribute__((__section__(".dram0.bss")))
float AudioSrcFltBuf1[AudioFrameSizeInSamplePerCh];
__attribute__((aligned(16))) __attribute__((__section__(".dram0.bss")))
float AudioSrcFltBuf2[AudioFrameSizeInSamplePerCh];

__attribute__((__section__(".iram.text")))
void AudioProcess_Test(void)
{

	int i;


	#if 0
		//signal processing to UsbAudioDnStreamingOneFrameBufL and UsbAudioDnStreamingOneFrameBufR
		//simple gain processing
		for (i = 0; i < AudioFrameSizeInSamplePerCh; i++)
		{
			VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufL[i]>>=1;
			VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufR[i]>>=1;
		}
	#endif

	//step1: I2S stream out the audio in UsbAudioDnStreamingOneFrameBufL, UsbAudioDnStreamingOneFrameBufR --- local audio jack playback
	#if 1	//folding
	volatile int * Ptr_I2sOutput23 = VarBlockSharedByDspAndMcu.I2SOtputCh23Ptr;
	for (i = 0; i < AudioFrameSizeInSamplePerCh; i++)
	{
		*Ptr_I2sOutput23++ = VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufL[i];
		*Ptr_I2sOutput23++ = VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufR[i];
	}
	#endif

	#if EnableAsrcLatencyTest==1
		if((AsrcLatencyTestCnt++%20000)<1000)
		{
			for(int i=0;i<AudioFrameSizeInSamplePerCh;i++)
				VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufL[i]>>=1;
		}
	#endif

	//step 2: fill the USB up-streaming buffer with UsbAudioDnStreamingOneFrameBufL and UsbAudioDnStreamingOneFrameBufR
	#if 1	//folding
	int *AudioToUsbUpstreamingPtr1;
	int *AudioToUsbUpstreamingPtr2;
	int *AudioToUsbUpstreamingPtr3;
	int *AudioToUsbUpstreamingPtr4;

	AudioToUsbUpstreamingPtr1=(int *)VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufL;
	AudioToUsbUpstreamingPtr2=(int *)VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufR;
	AudioToUsbUpstreamingPtr3=(int *)VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufL;
	AudioToUsbUpstreamingPtr4=(int *)VarBlockSharedByDspAndMcu.UsbAudioDnStreamingOneFrameBufR;

	if (CirAudioBuf_SpaceAvailableInSamples_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingL1) > (AudioFrameSizeInSamplePerCh))
	{
		CirAudioBuf_WriteSamples_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingL1, AudioFrameSizeInSamplePerCh, AudioToUsbUpstreamingPtr1);
	}

	if (CirAudioBuf_SpaceAvailableInSamples_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingR1) > (AudioFrameSizeInSamplePerCh))
	{
		CirAudioBuf_WriteSamples_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingR1, AudioFrameSizeInSamplePerCh, AudioToUsbUpstreamingPtr2);
	}

	if (CirAudioBuf_SpaceAvailableInSamples_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingL2) > (AudioFrameSizeInSamplePerCh))
	{
		CirAudioBuf_WriteSamples_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingL2, AudioFrameSizeInSamplePerCh, AudioToUsbUpstreamingPtr3);
	}

	if (CirAudioBuf_SpaceAvailableInSamples_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingR2) > (AudioFrameSizeInSamplePerCh))
	{
		CirAudioBuf_WriteSamples_S32(&VarBlockSharedByDspAndMcu.CirBufUsbAudioUpStreamingR2, AudioFrameSizeInSamplePerCh, AudioToUsbUpstreamingPtr4);
	}
	#endif

	//step 3: blink on-board red led
	#if 1	//folding
	if ((AudioProcFrameCnt % 12000) == 0)
		LedOn_R();
	if ((AudioProcFrameCnt % 12000) == 6000)
		LedOff_R();
	#endif

}
