/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v17.0
processor: MIMXRT685S
package_id: MIMXRT685SFVKB
mcu_data: ksdk2_0
processor_version: 24.12.10
board: MIMXRT685-EVK
pin_labels:
- {pin_num: H2, pin_signal: PIO0_3/FC0_CTS_SDA_SSEL0/CTIMER0_MAT3/FC1_SSEL2/SEC_PIO0_3, label: 'J1[3]/J36[4]/J45[58]', identifier: DbgPin1}
- {pin_num: J1, pin_signal: PIO0_4/FC0_RTS_SCL_SSEL1/CTIMER_INP0/FC1_SSEL3/CMP0_OUT/SEC_PIO0_4, label: 'J1[5]/J45[60]', identifier: DbgPin2}
- {pin_num: J2, pin_signal: PIO0_7/FC1_SCK/SCT0_GPI4/SCT0_OUT4/CTIMER1_MAT0/I2S_BRIDGE_CLK_OUT/SEC_PIO0_7, label: 'U34[3]/I2S_BCLK_CODEC', identifier: Fc1_Sck;Fc1_BICK}
- {pin_num: K4, pin_signal: PIO0_8/FC1_TXD_SCL_MISO_WS/SCT0_GPI5/SCT0_OUT5/CTIMER1_MAT1/I2S_BRIDGE_WS_OUT/SEC_PIO0_8, label: 'U34[2]/I2S_WS_CODEC', identifier: Fc1_LRCK}
- {pin_num: L3, pin_signal: PIO0_9/FC1_RXD_SDA_MOSI_DATA/SCT0_GPI6/SCT0_OUT6/CTIMER1_MAT2/I2S_BRIDGE_DATA_OUT/SEC_PIO0_9, label: 'JP8[2]/J47[3]/I2S_DAI_CODEC', identifier: Fc1_TxData}
- {pin_num: A3, pin_signal: PIO0_14/FC2_SCK/SCT0_GPI0/SCT0_OUT0/CTIMER2_MAT0/I2S_BRIDGE_CLK_IN/SEC_PIO0_14, label: 'Q4[5]', identifier: LED_GREEN;Fc2_BICK}
- {pin_num: A5, pin_signal: PIO0_15/FC2_TXD_SCL_MISO_WS/SCT0_GPI1/SCT0_OUT1/CTIMER2_MAT1/I2S_BRIDGE_WS_IN/SEC_PIO0_15, label: 'J36[6]/J47[6]', identifier: Fc2_LRCK}
- {pin_num: D6, pin_signal: PIO0_16/FC2_RXD_SDA_MOSI_DATA/SCT0_GPI2/SCT0_OUT2/CTIMER2_MAT2/I2S_BRIDGE_DATA_IN/SEC_PIO0_16, label: 'J36[8]/J47[7]', identifier: Fc2_RxData}
- {pin_num: A1, pin_signal: PIO0_19/FC2_SSEL2/SCT0_GPI4/SCT0_OUT4/CTIMER_INP5/UTICK_CAP0/SEC_PIO0_19/ADC0_2, label: 'J30[3]', identifier: DbgPin3}
- {pin_num: B2, pin_signal: PIO0_20/FC2_SSEL3/SCT0_GPI5/SCT0_OUT5/CTIMER0_MAT2/CTIMER_INP11/SEC_PIO0_20/ADC0_10, label: 'J30[4]', identifier: DbgPin4}
- {pin_num: C9, pin_signal: PIO0_23/FC3_RXD_SDA_MOSI_DATA/CTIMER3_MAT2/TRACEDATA(1)/SEC_PIO0_23, label: 'JP7[2]/J19[16]/J38[28]/I2S_DAO_CODEC', identifier: Fc3_TxData}
- {pin_num: D11, pin_signal: PIO0_28/FC4_SCK/CTIMER4_MAT0/I2S_BRIDGE_CLK_OUT/SEC_PIO0_28, label: 'J27[3]', identifier: FC4_BCLK}
- {pin_num: B10, pin_signal: PIO0_29/FC4_TXD_SCL_MISO_WS/CTIMER4_MAT1/I2S_BRIDGE_WS_OUT/SEC_PIO0_29, label: 'J27[2]', identifier: FC4_LRCLK}
- {pin_num: C11, pin_signal: PIO0_30/FC4_RXD_SDA_MOSI_DATA/CTIMER4_MAT2/I2S_BRIDGE_DATA_OUT/SEC_PIO0_30, label: 'J27[1]', identifier: FC4_DATAF;FC4_DATA}
- {pin_num: G16, pin_signal: PIO1_3/FC5_SCK, label: 'J28[6]', identifier: FC5_BCLK}
- {pin_num: G17, pin_signal: PIO1_4/FC5_TXD_SCL_MISO_WS, label: 'J28[5]/J45[32]', identifier: FC5_LRCLK}
- {pin_num: J16, pin_signal: PIO1_5/FC5_RXD_SDA_MOSI_DATA, label: 'J28[4]/JP30[1]/J45[22]', identifier: ACC_INT;FC5_DATA}
- {pin_num: B1, pin_signal: PIO1_9/FC5_SSEL3/SCT0_GPI7/UTICK_CAP1/CTIMER1_MAT3/ADC0_12, label: WL_REG_ON, identifier: BOARD_INITPINS_WL_REG_ON;WL_REG_ON}
- {pin_num: K16, pin_signal: PIO1_10/MCLK/FREQME_GPIO_CLK/CTIMER_INP10/CLKOUT, label: 'J27[6]/U35[8]/MCLK_CODEC', identifier: MCLK}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_gpio.h"
#include "fsl_iopctl.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: J2, peripheral: FLEXCOMM1, signal: SCK, pin_signal: PIO0_7/FC1_SCK/SCT0_GPI4/SCT0_OUT4/CTIMER1_MAT0/I2S_BRIDGE_CLK_OUT/SEC_PIO0_7, identifier: Fc1_BICK,
    direction: OUTPUT, pupdena: disabled, pupdsel: pullDown, ibena: enabled, slew_rate: normal, drive: normal, amena: disabled, odena: disabled, iiena: disabled}
  - {pin_num: K4, peripheral: FLEXCOMM1, signal: TXD_SCL_MISO_WS, pin_signal: PIO0_8/FC1_TXD_SCL_MISO_WS/SCT0_GPI5/SCT0_OUT5/CTIMER1_MAT1/I2S_BRIDGE_WS_OUT/SEC_PIO0_8,
    direction: OUTPUT, pupdena: disabled, pupdsel: pullDown, ibena: enabled, slew_rate: normal, drive: normal, amena: disabled, odena: disabled, iiena: disabled}
  - {pin_num: L3, peripheral: FLEXCOMM1, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_9/FC1_RXD_SDA_MOSI_DATA/SCT0_GPI6/SCT0_OUT6/CTIMER1_MAT2/I2S_BRIDGE_DATA_OUT/SEC_PIO0_9,
    direction: OUTPUT, pupdena: disabled, pupdsel: pullDown, ibena: disabled, slew_rate: normal, drive: normal, amena: disabled, odena: disabled, iiena: disabled}
  - {pin_num: C9, peripheral: FLEXCOMM3, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_23/FC3_RXD_SDA_MOSI_DATA/CTIMER3_MAT2/TRACEDATA(1)/SEC_PIO0_23, direction: OUTPUT,
    pupdena: disabled, pupdsel: pullDown, ibena: disabled, slew_rate: normal, drive: normal, amena: disabled, odena: disabled, iiena: disabled}
  - {pin_num: K16, peripheral: SYSCON, signal: MCLK, pin_signal: PIO1_10/MCLK/FREQME_GPIO_CLK/CTIMER_INP10/CLKOUT, direction: OUTPUT, pupdena: disabled, pupdsel: pullDown,
    ibena: disabled, slew_rate: normal, drive: full, amena: disabled, odena: disabled, iiena: disabled}
  - {pin_num: B6, peripheral: I3C, signal: PUR, pin_signal: PIO2_31/I3C0_PUR/SCT0_OUT7/UTICK_CAP3/CTIMER_INP15/SWO/CMP0_B}
  - {pin_num: N17, peripheral: I3C, signal: SCL, pin_signal: PIO2_29/I3C0_SCL/SCT0_OUT0/CLKOUT, pupdena: enabled, pupdsel: pullUp, ibena: enabled}
  - {pin_num: P16, peripheral: I3C, signal: SDA, pin_signal: PIO2_30/I3C0_SDA/SCT0_OUT3/CLKIN/CMP0_OUT, pupdena: enabled, pupdsel: pullUp, ibena: enabled}
  - {pin_num: G4, peripheral: FLEXCOMM0, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_2/FC0_RXD_SDA_MOSI_DATA/CTIMER0_MAT2/I2S_BRIDGE_DATA_IN/SEC_PIO0_2, ibena: enabled}
  - {pin_num: G2, peripheral: FLEXCOMM0, signal: TXD_SCL_MISO_WS, pin_signal: PIO0_1/FC0_TXD_SCL_MISO_WS/CTIMER0_MAT1/I2S_BRIDGE_WS_IN/SEC_PIO0_1}
  - {pin_num: D6, peripheral: FLEXCOMM2, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_16/FC2_RXD_SDA_MOSI_DATA/SCT0_GPI2/SCT0_OUT2/CTIMER2_MAT2/I2S_BRIDGE_DATA_IN/SEC_PIO0_16,
    direction: INPUT, ibena: enabled, drive: normal}
  - {pin_num: A3, peripheral: FLEXCOMM2, signal: SCK, pin_signal: PIO0_14/FC2_SCK/SCT0_GPI0/SCT0_OUT0/CTIMER2_MAT0/I2S_BRIDGE_CLK_IN/SEC_PIO0_14, identifier: Fc2_BICK,
    direction: INPUT, ibena: enabled}
  - {pin_num: A5, peripheral: FLEXCOMM2, signal: TXD_SCL_MISO_WS, pin_signal: PIO0_15/FC2_TXD_SCL_MISO_WS/SCT0_GPI1/SCT0_OUT1/CTIMER2_MAT1/I2S_BRIDGE_WS_IN/SEC_PIO0_15,
    direction: INPUT, ibena: enabled}
  - {pin_num: H2, peripheral: GPIO, signal: 'PIO0, 3', pin_signal: PIO0_3/FC0_CTS_SDA_SSEL0/CTIMER0_MAT3/FC1_SSEL2/SEC_PIO0_3, direction: OUTPUT}
  - {pin_num: J1, peripheral: GPIO, signal: 'PIO0, 4', pin_signal: PIO0_4/FC0_RTS_SCL_SSEL1/CTIMER_INP0/FC1_SSEL3/CMP0_OUT/SEC_PIO0_4, direction: OUTPUT}
  - {pin_num: A1, peripheral: GPIO, signal: 'PIO0, 19', pin_signal: PIO0_19/FC2_SSEL2/SCT0_GPI4/SCT0_OUT4/CTIMER_INP5/UTICK_CAP0/SEC_PIO0_19/ADC0_2, direction: OUTPUT}
  - {pin_num: B2, peripheral: GPIO, signal: 'PIO0, 20', pin_signal: PIO0_20/FC2_SSEL3/SCT0_GPI5/SCT0_OUT5/CTIMER0_MAT2/CTIMER_INP11/SEC_PIO0_20/ADC0_10, direction: OUTPUT}
  - {pin_num: A11, peripheral: GPIO, signal: 'PIO0, 31', pin_signal: PIO0_31/FC4_CTS_SDA_SSEL0/SCT0_GPI0/SCT0_OUT6/CTIMER4_MAT3/FC3_SSEL2/SEC_PIO0_31, direction: OUTPUT}
  - {pin_num: A2, peripheral: GPIO, signal: 'PIO0, 26', pin_signal: PIO0_26/FC3_SSEL2/SCT0_GPI6/SCT0_OUT6/CTIMER_INP7/SEC_PIO0_26/ADC0_3, direction: OUTPUT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitPins(void)
{
#if 1
	//this is necessary for config PMIC
	#define IOPCTL_PIO_PSEDRAIN_EN 0x0400u    /*!<@brief Pseudo Output Drain is enabled */


    const uint32_t fc15_i2c_scl_config = (/* Pin is configured as I2C_SCL */
                                          IOPCTL_PIO_FUNC0 |
                                          /* Enable pull-up / pull-down function */
                                          IOPCTL_PIO_PUPD_EN |
                                          /* Enable pull-up function */
                                          IOPCTL_PIO_PULLUP_EN |
                                          /* Enables input buffer function */
                                          IOPCTL_PIO_INBUF_EN |
                                          /* Normal mode */
                                          IOPCTL_PIO_SLEW_RATE_NORMAL |
                                          /* Normal drive */
                                          IOPCTL_PIO_FULLDRIVE_DI |
                                          /* Analog mux is disabled */
                                          IOPCTL_PIO_ANAMUX_DI |
                                          /* Pseudo Output Drain is enabled */
                                          IOPCTL_PIO_PSEDRAIN_EN |
                                          /* Input function is not inverted */
                                          IOPCTL_PIO_INV_DI);
    /* FC15_SCL PIN (coords: E16) is configured as I2C SCL */
    IOPCTL->FC15_I2C_SCL = fc15_i2c_scl_config;

    const uint32_t fc15_i2c_sda_config = (/* Pin is configured as I2C_SDA */
                                          IOPCTL_PIO_FUNC0 |
                                          /* Enable pull-up / pull-down function */
                                          IOPCTL_PIO_PUPD_EN |
                                          /* Enable pull-up function */
                                          IOPCTL_PIO_PULLUP_EN |
                                          /* Enables input buffer function */
                                          IOPCTL_PIO_INBUF_EN |
                                          /* Normal mode */
                                          IOPCTL_PIO_SLEW_RATE_NORMAL |
                                          /* Normal drive */
                                          IOPCTL_PIO_FULLDRIVE_DI |
                                          /* Analog mux is disabled */
                                          IOPCTL_PIO_ANAMUX_DI |
                                          /* Pseudo Output Drain is enabled */
                                          IOPCTL_PIO_PSEDRAIN_EN |
                                          /* Input function is not inverted */
                                          IOPCTL_PIO_INV_DI);
    /* FC15_SDA PIN (coords: F16) is configured as I2C SDA */
    IOPCTL->FC15_I2C_SDA = fc15_i2c_sda_config;
#endif

    /* Enables the clock for the GPIO0 module */
    CLOCK_EnableClock(kCLOCK_HsGpio0);

    gpio_pin_config_t DbgPin1_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_3 (pin H2)  */
    GPIO_PinInit(BOARD_INITPINS_DbgPin1_GPIO, BOARD_INITPINS_DbgPin1_PORT, BOARD_INITPINS_DbgPin1_PIN, &DbgPin1_config);

    gpio_pin_config_t DbgPin2_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_4 (pin J1)  */
    GPIO_PinInit(BOARD_INITPINS_DbgPin2_GPIO, BOARD_INITPINS_DbgPin2_PORT, BOARD_INITPINS_DbgPin2_PIN, &DbgPin2_config);

    gpio_pin_config_t DbgPin3_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_19 (pin A1)  */
    GPIO_PinInit(BOARD_INITPINS_DbgPin3_GPIO, BOARD_INITPINS_DbgPin3_PORT, BOARD_INITPINS_DbgPin3_PIN, &DbgPin3_config);

    gpio_pin_config_t DbgPin4_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_20 (pin B2)  */
    GPIO_PinInit(BOARD_INITPINS_DbgPin4_GPIO, BOARD_INITPINS_DbgPin4_PORT, BOARD_INITPINS_DbgPin4_PIN, &DbgPin4_config);

    gpio_pin_config_t LED_BLUE_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_26 (pin A2)  */
    GPIO_PinInit(BOARD_INITPINS_LED_BLUE_GPIO, BOARD_INITPINS_LED_BLUE_PORT, BOARD_INITPINS_LED_BLUE_PIN, &LED_BLUE_config);

    gpio_pin_config_t LED_RED_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_31 (pin A11)  */
    GPIO_PinInit(BOARD_INITPINS_LED_RED_GPIO, BOARD_INITPINS_LED_RED_PORT, BOARD_INITPINS_LED_RED_PIN, &LED_RED_config);

    const uint32_t DEBUG_UART_TXD = (/* Pin is configured as FC0_TXD_SCL_MISO_WS */
                                     IOPCTL_PIO_FUNC1 |
                                     /* Disable pull-up / pull-down function */
                                     IOPCTL_PIO_PUPD_DI |
                                     /* Enable pull-down function */
                                     IOPCTL_PIO_PULLDOWN_EN |
                                     /* Disable input buffer function */
                                     IOPCTL_PIO_INBUF_DI |
                                     /* Normal mode */
                                     IOPCTL_PIO_SLEW_RATE_NORMAL |
                                     /* Normal drive */
                                     IOPCTL_PIO_FULLDRIVE_DI |
                                     /* Analog mux is disabled */
                                     IOPCTL_PIO_ANAMUX_DI |
                                     /* Pseudo Output Drain is disabled */
                                     IOPCTL_PIO_PSEDRAIN_DI |
                                     /* Input function is not inverted */
                                     IOPCTL_PIO_INV_DI);
    /* PORT0 PIN1 (coords: G2) is configured as FC0_TXD_SCL_MISO_WS */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_DEBUG_UART_TXD_PORT, BOARD_INITPINS_DEBUG_UART_TXD_PIN, DEBUG_UART_TXD);

    const uint32_t Fc2_BICK = (/* Pin is configured as FC2_SCK */
                               IOPCTL_PIO_FUNC1 |
                               /* Disable pull-up / pull-down function */
                               IOPCTL_PIO_PUPD_DI |
                               /* Enable pull-down function */
                               IOPCTL_PIO_PULLDOWN_EN |
                               /* Enables input buffer function */
                               IOPCTL_PIO_INBUF_EN |
                               /* Normal mode */
                               IOPCTL_PIO_SLEW_RATE_NORMAL |
                               /* Normal drive */
                               IOPCTL_PIO_FULLDRIVE_DI |
                               /* Analog mux is disabled */
                               IOPCTL_PIO_ANAMUX_DI |
                               /* Pseudo Output Drain is disabled */
                               IOPCTL_PIO_PSEDRAIN_DI |
                               /* Input function is not inverted */
                               IOPCTL_PIO_INV_DI);
    /* PORT0 PIN14 (coords: A3) is configured as FC2_SCK */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_Fc2_BICK_PORT, BOARD_INITPINS_Fc2_BICK_PIN, Fc2_BICK);

    const uint32_t Fc2_LRCK = (/* Pin is configured as FC2_TXD_SCL_MISO_WS */
                               IOPCTL_PIO_FUNC1 |
                               /* Disable pull-up / pull-down function */
                               IOPCTL_PIO_PUPD_DI |
                               /* Enable pull-down function */
                               IOPCTL_PIO_PULLDOWN_EN |
                               /* Enables input buffer function */
                               IOPCTL_PIO_INBUF_EN |
                               /* Normal mode */
                               IOPCTL_PIO_SLEW_RATE_NORMAL |
                               /* Normal drive */
                               IOPCTL_PIO_FULLDRIVE_DI |
                               /* Analog mux is disabled */
                               IOPCTL_PIO_ANAMUX_DI |
                               /* Pseudo Output Drain is disabled */
                               IOPCTL_PIO_PSEDRAIN_DI |
                               /* Input function is not inverted */
                               IOPCTL_PIO_INV_DI);
    /* PORT0 PIN15 (coords: A5) is configured as FC2_TXD_SCL_MISO_WS */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_Fc2_LRCK_PORT, BOARD_INITPINS_Fc2_LRCK_PIN, Fc2_LRCK);

    const uint32_t Fc2_RxData = (/* Pin is configured as FC2_RXD_SDA_MOSI_DATA */
                                 IOPCTL_PIO_FUNC1 |
                                 /* Disable pull-up / pull-down function */
                                 IOPCTL_PIO_PUPD_DI |
                                 /* Enable pull-down function */
                                 IOPCTL_PIO_PULLDOWN_EN |
                                 /* Enables input buffer function */
                                 IOPCTL_PIO_INBUF_EN |
                                 /* Normal mode */
                                 IOPCTL_PIO_SLEW_RATE_NORMAL |
                                 /* Normal drive */
                                 IOPCTL_PIO_FULLDRIVE_DI |
                                 /* Analog mux is disabled */
                                 IOPCTL_PIO_ANAMUX_DI |
                                 /* Pseudo Output Drain is disabled */
                                 IOPCTL_PIO_PSEDRAIN_DI |
                                 /* Input function is not inverted */
                                 IOPCTL_PIO_INV_DI);
    /* PORT0 PIN16 (coords: D6) is configured as FC2_RXD_SDA_MOSI_DATA */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_Fc2_RxData_PORT, BOARD_INITPINS_Fc2_RxData_PIN, Fc2_RxData);

    const uint32_t DbgPin3 = (/* Pin is configured as PIO0_19 */
                              IOPCTL_PIO_FUNC0 |
                              /* Disable pull-up / pull-down function */
                              IOPCTL_PIO_PUPD_DI |
                              /* Enable pull-down function */
                              IOPCTL_PIO_PULLDOWN_EN |
                              /* Disable input buffer function */
                              IOPCTL_PIO_INBUF_DI |
                              /* Normal mode */
                              IOPCTL_PIO_SLEW_RATE_NORMAL |
                              /* Normal drive */
                              IOPCTL_PIO_FULLDRIVE_DI |
                              /* Analog mux is disabled */
                              IOPCTL_PIO_ANAMUX_DI |
                              /* Pseudo Output Drain is disabled */
                              IOPCTL_PIO_PSEDRAIN_DI |
                              /* Input function is not inverted */
                              IOPCTL_PIO_INV_DI);
    /* PORT0 PIN19 (coords: A1) is configured as PIO0_19 */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_DbgPin3_PORT, BOARD_INITPINS_DbgPin3_PIN, DbgPin3);

    const uint32_t DEBUG_UART_RXD = (/* Pin is configured as FC0_RXD_SDA_MOSI_DATA */
                                     IOPCTL_PIO_FUNC1 |
                                     /* Disable pull-up / pull-down function */
                                     IOPCTL_PIO_PUPD_DI |
                                     /* Enable pull-down function */
                                     IOPCTL_PIO_PULLDOWN_EN |
                                     /* Enables input buffer function */
                                     IOPCTL_PIO_INBUF_EN |
                                     /* Normal mode */
                                     IOPCTL_PIO_SLEW_RATE_NORMAL |
                                     /* Normal drive */
                                     IOPCTL_PIO_FULLDRIVE_DI |
                                     /* Analog mux is disabled */
                                     IOPCTL_PIO_ANAMUX_DI |
                                     /* Pseudo Output Drain is disabled */
                                     IOPCTL_PIO_PSEDRAIN_DI |
                                     /* Input function is not inverted */
                                     IOPCTL_PIO_INV_DI);
    /* PORT0 PIN2 (coords: G4) is configured as FC0_RXD_SDA_MOSI_DATA */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_DEBUG_UART_RXD_PORT, BOARD_INITPINS_DEBUG_UART_RXD_PIN, DEBUG_UART_RXD);

    const uint32_t DbgPin4 = (/* Pin is configured as PIO0_20 */
                              IOPCTL_PIO_FUNC0 |
                              /* Disable pull-up / pull-down function */
                              IOPCTL_PIO_PUPD_DI |
                              /* Enable pull-down function */
                              IOPCTL_PIO_PULLDOWN_EN |
                              /* Disable input buffer function */
                              IOPCTL_PIO_INBUF_DI |
                              /* Normal mode */
                              IOPCTL_PIO_SLEW_RATE_NORMAL |
                              /* Normal drive */
                              IOPCTL_PIO_FULLDRIVE_DI |
                              /* Analog mux is disabled */
                              IOPCTL_PIO_ANAMUX_DI |
                              /* Pseudo Output Drain is disabled */
                              IOPCTL_PIO_PSEDRAIN_DI |
                              /* Input function is not inverted */
                              IOPCTL_PIO_INV_DI);
    /* PORT0 PIN20 (coords: B2) is configured as PIO0_20 */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_DbgPin4_PORT, BOARD_INITPINS_DbgPin4_PIN, DbgPin4);

    const uint32_t Fc3_TxData = (/* Pin is configured as FC3_RXD_SDA_MOSI_DATA */
                                 IOPCTL_PIO_FUNC1 |
                                 /* Disable pull-up / pull-down function */
                                 IOPCTL_PIO_PUPD_DI |
                                 /* Enable pull-down function */
                                 IOPCTL_PIO_PULLDOWN_EN |
                                 /* Disable input buffer function */
                                 IOPCTL_PIO_INBUF_DI |
                                 /* Normal mode */
                                 IOPCTL_PIO_SLEW_RATE_NORMAL |
                                 /* Normal drive */
                                 IOPCTL_PIO_FULLDRIVE_DI |
                                 /* Analog mux is disabled */
                                 IOPCTL_PIO_ANAMUX_DI |
                                 /* Pseudo Output Drain is disabled */
                                 IOPCTL_PIO_PSEDRAIN_DI |
                                 /* Input function is not inverted */
                                 IOPCTL_PIO_INV_DI);
    /* PORT0 PIN23 (coords: C9) is configured as FC3_RXD_SDA_MOSI_DATA */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_Fc3_TxData_PORT, BOARD_INITPINS_Fc3_TxData_PIN, Fc3_TxData);

    const uint32_t LED_BLUE = (/* Pin is configured as PIO0_26 */
                               IOPCTL_PIO_FUNC0 |
                               /* Disable pull-up / pull-down function */
                               IOPCTL_PIO_PUPD_DI |
                               /* Enable pull-down function */
                               IOPCTL_PIO_PULLDOWN_EN |
                               /* Disable input buffer function */
                               IOPCTL_PIO_INBUF_DI |
                               /* Normal mode */
                               IOPCTL_PIO_SLEW_RATE_NORMAL |
                               /* Normal drive */
                               IOPCTL_PIO_FULLDRIVE_DI |
                               /* Analog mux is disabled */
                               IOPCTL_PIO_ANAMUX_DI |
                               /* Pseudo Output Drain is disabled */
                               IOPCTL_PIO_PSEDRAIN_DI |
                               /* Input function is not inverted */
                               IOPCTL_PIO_INV_DI);
    /* PORT0 PIN26 (coords: A2) is configured as PIO0_26 */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_LED_BLUE_PORT, BOARD_INITPINS_LED_BLUE_PIN, LED_BLUE);

    const uint32_t DbgPin1 = (/* Pin is configured as PIO0_3 */
                              IOPCTL_PIO_FUNC0 |
                              /* Disable pull-up / pull-down function */
                              IOPCTL_PIO_PUPD_DI |
                              /* Enable pull-down function */
                              IOPCTL_PIO_PULLDOWN_EN |
                              /* Disable input buffer function */
                              IOPCTL_PIO_INBUF_DI |
                              /* Normal mode */
                              IOPCTL_PIO_SLEW_RATE_NORMAL |
                              /* Normal drive */
                              IOPCTL_PIO_FULLDRIVE_DI |
                              /* Analog mux is disabled */
                              IOPCTL_PIO_ANAMUX_DI |
                              /* Pseudo Output Drain is disabled */
                              IOPCTL_PIO_PSEDRAIN_DI |
                              /* Input function is not inverted */
                              IOPCTL_PIO_INV_DI);
    /* PORT0 PIN3 (coords: H2) is configured as PIO0_3 */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_DbgPin1_PORT, BOARD_INITPINS_DbgPin1_PIN, DbgPin1);

    const uint32_t LED_RED = (/* Pin is configured as PIO0_31 */
                              IOPCTL_PIO_FUNC0 |
                              /* Disable pull-up / pull-down function */
                              IOPCTL_PIO_PUPD_DI |
                              /* Enable pull-down function */
                              IOPCTL_PIO_PULLDOWN_EN |
                              /* Disable input buffer function */
                              IOPCTL_PIO_INBUF_DI |
                              /* Normal mode */
                              IOPCTL_PIO_SLEW_RATE_NORMAL |
                              /* Normal drive */
                              IOPCTL_PIO_FULLDRIVE_DI |
                              /* Analog mux is disabled */
                              IOPCTL_PIO_ANAMUX_DI |
                              /* Pseudo Output Drain is disabled */
                              IOPCTL_PIO_PSEDRAIN_DI |
                              /* Input function is not inverted */
                              IOPCTL_PIO_INV_DI);
    /* PORT0 PIN31 (coords: A11) is configured as PIO0_31 */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_LED_RED_PORT, BOARD_INITPINS_LED_RED_PIN, LED_RED);

    const uint32_t DbgPin2 = (/* Pin is configured as PIO0_4 */
                              IOPCTL_PIO_FUNC0 |
                              /* Disable pull-up / pull-down function */
                              IOPCTL_PIO_PUPD_DI |
                              /* Enable pull-down function */
                              IOPCTL_PIO_PULLDOWN_EN |
                              /* Disable input buffer function */
                              IOPCTL_PIO_INBUF_DI |
                              /* Normal mode */
                              IOPCTL_PIO_SLEW_RATE_NORMAL |
                              /* Normal drive */
                              IOPCTL_PIO_FULLDRIVE_DI |
                              /* Analog mux is disabled */
                              IOPCTL_PIO_ANAMUX_DI |
                              /* Pseudo Output Drain is disabled */
                              IOPCTL_PIO_PSEDRAIN_DI |
                              /* Input function is not inverted */
                              IOPCTL_PIO_INV_DI);
    /* PORT0 PIN4 (coords: J1) is configured as PIO0_4 */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_DbgPin2_PORT, BOARD_INITPINS_DbgPin2_PIN, DbgPin2);

    const uint32_t Fc1_BICK = (/* Pin is configured as FC1_SCK */
                               IOPCTL_PIO_FUNC1 |
                               /* Disable pull-up / pull-down function */
                               IOPCTL_PIO_PUPD_DI |
                               /* Enable pull-down function */
                               IOPCTL_PIO_PULLDOWN_EN |
                               /* Enables input buffer function */
                               IOPCTL_PIO_INBUF_EN |
                               /* Normal mode */
                               IOPCTL_PIO_SLEW_RATE_NORMAL |
                               /* Normal drive */
                               IOPCTL_PIO_FULLDRIVE_DI |
                               /* Analog mux is disabled */
                               IOPCTL_PIO_ANAMUX_DI |
                               /* Pseudo Output Drain is disabled */
                               IOPCTL_PIO_PSEDRAIN_DI |
                               /* Input function is not inverted */
                               IOPCTL_PIO_INV_DI);
    /* PORT0 PIN7 (coords: J2) is configured as FC1_SCK */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_Fc1_BICK_PORT, BOARD_INITPINS_Fc1_BICK_PIN, Fc1_BICK);

    const uint32_t Fc1_LRCK = (/* Pin is configured as FC1_TXD_SCL_MISO_WS */
                               IOPCTL_PIO_FUNC1 |
                               /* Disable pull-up / pull-down function */
                               IOPCTL_PIO_PUPD_DI |
                               /* Enable pull-down function */
                               IOPCTL_PIO_PULLDOWN_EN |
                               /* Enables input buffer function */
                               IOPCTL_PIO_INBUF_EN |
                               /* Normal mode */
                               IOPCTL_PIO_SLEW_RATE_NORMAL |
                               /* Normal drive */
                               IOPCTL_PIO_FULLDRIVE_DI |
                               /* Analog mux is disabled */
                               IOPCTL_PIO_ANAMUX_DI |
                               /* Pseudo Output Drain is disabled */
                               IOPCTL_PIO_PSEDRAIN_DI |
                               /* Input function is not inverted */
                               IOPCTL_PIO_INV_DI);
    /* PORT0 PIN8 (coords: K4) is configured as FC1_TXD_SCL_MISO_WS */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_Fc1_LRCK_PORT, BOARD_INITPINS_Fc1_LRCK_PIN, Fc1_LRCK);

    const uint32_t Fc1_TxData = (/* Pin is configured as FC1_RXD_SDA_MOSI_DATA */
                                 IOPCTL_PIO_FUNC1 |
                                 /* Disable pull-up / pull-down function */
                                 IOPCTL_PIO_PUPD_DI |
                                 /* Enable pull-down function */
                                 IOPCTL_PIO_PULLDOWN_EN |
                                 /* Disable input buffer function */
                                 IOPCTL_PIO_INBUF_DI |
                                 /* Normal mode */
                                 IOPCTL_PIO_SLEW_RATE_NORMAL |
                                 /* Normal drive */
                                 IOPCTL_PIO_FULLDRIVE_DI |
                                 /* Analog mux is disabled */
                                 IOPCTL_PIO_ANAMUX_DI |
                                 /* Pseudo Output Drain is disabled */
                                 IOPCTL_PIO_PSEDRAIN_DI |
                                 /* Input function is not inverted */
                                 IOPCTL_PIO_INV_DI);
    /* PORT0 PIN9 (coords: L3) is configured as FC1_RXD_SDA_MOSI_DATA */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_Fc1_TxData_PORT, BOARD_INITPINS_Fc1_TxData_PIN, Fc1_TxData);

    const uint32_t MCLK = (/* Pin is configured as MCLK */
                           IOPCTL_PIO_FUNC1 |
                           /* Disable pull-up / pull-down function */
                           IOPCTL_PIO_PUPD_DI |
                           /* Enable pull-down function */
                           IOPCTL_PIO_PULLDOWN_EN |
                           /* Disable input buffer function */
                           IOPCTL_PIO_INBUF_DI |
                           /* Normal mode */
                           IOPCTL_PIO_SLEW_RATE_NORMAL |
                           /* Full drive enable */
                           IOPCTL_PIO_FULLDRIVE_EN |
                           /* Analog mux is disabled */
                           IOPCTL_PIO_ANAMUX_DI |
                           /* Pseudo Output Drain is disabled */
                           IOPCTL_PIO_PSEDRAIN_DI |
                           /* Input function is not inverted */
                           IOPCTL_PIO_INV_DI);
    /* PORT1 PIN10 (coords: K16) is configured as MCLK */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_MCLK_PORT, BOARD_INITPINS_MCLK_PIN, MCLK);

    const uint32_t I3C0_SCL = (/* Pin is configured as I3C0_SCL */
                               IOPCTL_PIO_FUNC1 |
                               /* Enable pull-up / pull-down function */
                               IOPCTL_PIO_PUPD_EN |
                               /* Enable pull-up function */
                               IOPCTL_PIO_PULLUP_EN |
                               /* Enables input buffer function */
                               IOPCTL_PIO_INBUF_EN |
                               /* Normal mode */
                               IOPCTL_PIO_SLEW_RATE_NORMAL |
                               /* Normal drive */
                               IOPCTL_PIO_FULLDRIVE_DI |
                               /* Analog mux is disabled */
                               IOPCTL_PIO_ANAMUX_DI |
                               /* Pseudo Output Drain is disabled */
                               IOPCTL_PIO_PSEDRAIN_DI |
                               /* Input function is not inverted */
                               IOPCTL_PIO_INV_DI);
    /* PORT2 PIN29 (coords: N17) is configured as I3C0_SCL */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_I3C0_SCL_PORT, BOARD_INITPINS_I3C0_SCL_PIN, I3C0_SCL);

    const uint32_t I3C0_SDA = (/* Pin is configured as I3C0_SDA */
                               IOPCTL_PIO_FUNC1 |
                               /* Enable pull-up / pull-down function */
                               IOPCTL_PIO_PUPD_EN |
                               /* Enable pull-up function */
                               IOPCTL_PIO_PULLUP_EN |
                               /* Enables input buffer function */
                               IOPCTL_PIO_INBUF_EN |
                               /* Normal mode */
                               IOPCTL_PIO_SLEW_RATE_NORMAL |
                               /* Normal drive */
                               IOPCTL_PIO_FULLDRIVE_DI |
                               /* Analog mux is disabled */
                               IOPCTL_PIO_ANAMUX_DI |
                               /* Pseudo Output Drain is disabled */
                               IOPCTL_PIO_PSEDRAIN_DI |
                               /* Input function is not inverted */
                               IOPCTL_PIO_INV_DI);
    /* PORT2 PIN30 (coords: P16) is configured as I3C0_SDA */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_I3C0_SDA_PORT, BOARD_INITPINS_I3C0_SDA_PIN, I3C0_SDA);

    const uint32_t I3C0_PUR = (/* Pin is configured as I3C0_PUR */
                               IOPCTL_PIO_FUNC1 |
                               /* Disable pull-up / pull-down function */
                               IOPCTL_PIO_PUPD_DI |
                               /* Enable pull-down function */
                               IOPCTL_PIO_PULLDOWN_EN |
                               /* Disable input buffer function */
                               IOPCTL_PIO_INBUF_DI |
                               /* Normal mode */
                               IOPCTL_PIO_SLEW_RATE_NORMAL |
                               /* Normal drive */
                               IOPCTL_PIO_FULLDRIVE_DI |
                               /* Analog mux is disabled */
                               IOPCTL_PIO_ANAMUX_DI |
                               /* Pseudo Output Drain is disabled */
                               IOPCTL_PIO_PSEDRAIN_DI |
                               /* Input function is not inverted */
                               IOPCTL_PIO_INV_DI);
    /* PORT2 PIN31 (coords: B6) is configured as I3C0_PUR */
    IOPCTL_PinMuxSet(IOPCTL, BOARD_INITPINS_I3C0_PUR_PORT, BOARD_INITPINS_I3C0_PUR_PIN, I3C0_PUR);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
