/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef __CirbufManagement___
#define __CirbufManagement___



#ifdef __cplusplus
extern "C" {
#endif


#define EnableLessUsedCirBufFunctions       0
#define EnableCirBufFunctionsForS16         0
#define EnableCirBufFunctionsForS32         1
#define EnableCirBufFunctionsForS64         0


#if defined(EnableCirBufFunctionsForS16)&&(EnableCirBufFunctionsForS16==1)
typedef struct
{
	unsigned int LengthInSamples;
	short int *PtrBufHead;
	short int *PtrRd;
	short int *PtrWr;
} T_CircularAudioBuf_S16;

    void InitCirAudioBuf_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr,short int *DataAreaHead,unsigned int BufLen);
    void CirAudioBuf_WriteSamples_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int SampleNumbersToBePut, short int *PtrAudioDataSrc);
    short int* CirAudioBuf_ReadSamples_GetRdPtr_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int SampleNumbersToBeGot);
    unsigned int CirAudioBuf_SpaceOccupiedInSamples_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr);
    unsigned int CirAudioBuf_SpaceAvailableInSamples_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr);
    void CirAudioBuf_ClearAllSamples_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr);
    void CirAudioBuf_ReadSamples_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int SampleNumbersToBeGot, short int *PtrAudioDataDst);
    #if defined(EnableLessUsedCirBufFunctions)&&(EnableLessUsedCirBufFunctions==1)
        unsigned char CirAudioBuf_GetUsagePercentage_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr);
        void CirAudioBuf_MoveRdPtrForwards_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        short int* CirAudioBuf_GetDdPtrForwards_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        void CirAudioBuf_MoveRdPtrBackwards_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        short int* CirAudioBuf_GetRdPtrBackwards_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        void CirAudioBuf_MoveWrPtrForwards_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        short int* CirAudioBuf_GetWrPtrForwards_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        void CirAudioBuf_MoveWrPtrBackwards_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        short int* CirAudioBuf_GetWrPtrBackwards_S16(volatile T_CircularAudioBuf_S16 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
    #endif      //EnableLessUsedCirBufFunctions
#endif      //EnableCirBufFunctionsForS16


#if defined(EnableCirBufFunctionsForS32)&&(EnableCirBufFunctionsForS32==1)
typedef struct
{
	unsigned int LengthInSamples;
	int *PtrBufHead;
	int *PtrRd;
	int *PtrWr;
} T_CircularAudioBuf_S32;

    void InitCirAudioBuf_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr,int *DataAreaHead,unsigned int BufLen);
    void CirAudioBuf_WriteSamples_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int SampleNumbersToBePut, int *PtrAudioDataSrc);
    int* CirAudioBuf_ReadSamples_GetRdPtr_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int SampleNumbersToBeGot);
    unsigned int CirAudioBuf_SpaceOccupiedInSamples_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr);
    unsigned int CirAudioBuf_SpaceAvailableInSamples_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr);
    void CirAudioBuf_ClearAllSamples_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr);
    void CirAudioBuf_ReadSamples_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int SampleNumbersToBeGot, int *PtrAudioDataDst);
    #if defined(EnableLessUsedCirBufFunctions)&&(EnableLessUsedCirBufFunctions==1)
        unsigned char CirAudioBuf_GetUsagePercentage_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr);
        void CirAudioBuf_MoveRdPtrForwards_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        int* CirAudioBuf_GetDdPtrForwards_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        void CirAudioBuf_MoveRdPtrBackwards_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        int* CirAudioBuf_GetRdPtrBackwards_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        void CirAudioBuf_MoveWrPtrForwards_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        int* CirAudioBuf_GetWrPtrForwards_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        void CirAudioBuf_MoveWrPtrBackwards_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        int* CirAudioBuf_GetWrPtrBackwards_S32(volatile T_CircularAudioBuf_S32 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
    #endif      //EnableLessUsedCirBufFunctions
#endif      //EnableCirBufFunctionsForS32


#if defined(EnableCirBufFunctionsForS64)&&(EnableCirBufFunctionsForS64==1)
typedef struct
{
	unsigned int LengthInSamples;
	S64 *PtrBufHead;
	S64 *PtrRd;
	S64 *PtrWr;
} T_CircularAudioBuf_S64;

    void InitCirAudioBuf_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr,S64 *DataAreaHead,unsigned int BufLen);
    void CirAudioBuf_WriteSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int SampleNumbersToBePut, S64 *PtrAudioDataSrc);
    S64* CirAudioBuf_ReadSamples_GetRdPtr_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int SampleNumbersToBeGot);
    unsigned int CirAudioBuf_SpaceOccupiedInSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr);
    unsigned int CirAudioBuf_SpaceAvailableInSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr);
    void CirAudioBuf_ClearAllSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr);
    #if defined(EnableLessUsedCirBufFunctions)&&(EnableLessUsedCirBufFunctions==1)
        void CirAudioBuf_ReadSamples_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int SampleNumbersToBeGot, S64 *PtrAudioDataDst);
        unsigned char CirAudioBuf_GetUsagePercentage_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr);
        void CirAudioBuf_MoveRdPtrForwards_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        S64* CirAudioBuf_GetDdPtrForwards_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        void CirAudioBuf_MoveRdPtrBackwards_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        S64* CirAudioBuf_GetRdPtrBackwards_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        void CirAudioBuf_MoveWrPtrForwards_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        S64* CirAudioBuf_GetWrPtrForwards_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int NumOfSamplesToGoForward);
        void CirAudioBuf_MoveWrPtrBackwards_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
        S64* CirAudioBuf_GetWrPtrBackwards_S64(volatile T_CircularAudioBuf_S64 *CirBufPtr, unsigned int NumOfSamplesToGoBack);
    #endif      //EnableLessUsedCirBufFunctions
#endif      //EnableCirBufFunctionsForS64


#ifdef __cplusplus
}
#endif

#endif

