/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __DefForBothMcuAndDsp_h__
#define __DefForBothMcuAndDsp_h__

#include "CircularBufManagement.h"



#define AudioFrameSizeInSamplePerCh 			(6)

#define USB_AUDIO_IN_SAMPLING_RATE_KHZ			48
#define CirBufUsbAudioUpStreaming_Len_InSamples			(USB_AUDIO_IN_SAMPLING_RATE_KHZ * 16)			//16ms --- when upstream data rate is stable, this buffer should be half full,so the delay here is 8 ms
#define CirBufUsbAudioUpStreaming_MaxReadLengthInSamples	(USB_AUDIO_IN_SAMPLING_RATE_KHZ * 1+1)			//USB audio event will read this buffer, and the read size is 1 ms + 1 sample size maximum

//#define AsrcBufLengthInSamples					60
#define AsrcBufLengthInSamples					360

//MCU program must has the exact same struct def as the following --- make sure you copy the following def from DSP code to MCU code
typedef struct
{

	//part 1 --- circular buf
	T_CircularAudioBuf_S32 CirBufUsbAudioUpStreamingL1;
	T_CircularAudioBuf_S32 CirBufUsbAudioUpStreamingR1;
	T_CircularAudioBuf_S32 CirBufUsbAudioUpStreamingL2;
	T_CircularAudioBuf_S32 CirBufUsbAudioUpStreamingR2;
	T_CircularAudioBuf_S32 CirBufUsbAudioDnStreamingL;
	T_CircularAudioBuf_S32 CirBufUsbAudioDnStreamingR;

	//part 2 --- circular buf main data area
	__attribute__((aligned(32))) int CirBufUsbAudioUpStreamingL1_DataArea [CirBufUsbAudioUpStreaming_Len_InSamples + CirBufUsbAudioUpStreaming_MaxReadLengthInSamples];
	__attribute__((aligned(32))) int CirBufUsbAudioUpStreamingR1_DataArea [CirBufUsbAudioUpStreaming_Len_InSamples + CirBufUsbAudioUpStreaming_MaxReadLengthInSamples];
	__attribute__((aligned(32))) int CirBufUsbAudioUpStreamingL2_DataArea [CirBufUsbAudioUpStreaming_Len_InSamples + CirBufUsbAudioUpStreaming_MaxReadLengthInSamples];
	__attribute__((aligned(32))) int CirBufUsbAudioUpStreamingR2_DataArea [CirBufUsbAudioUpStreaming_Len_InSamples + CirBufUsbAudioUpStreaming_MaxReadLengthInSamples];
	__attribute__((aligned(32))) int CirBufUsbAudioDnStreamingL_DataArea  [AsrcBufLengthInSamples + AudioFrameSizeInSamplePerCh];
	__attribute__((aligned(32))) int CirBufUsbAudioDnStreamingR_DataArea  [AsrcBufLengthInSamples + AudioFrameSizeInSamplePerCh];

	//part 3 --- other audio buffers
	__attribute__((aligned(32))) int UsbAudioDnStreamingOneFrameBufL[AudioFrameSizeInSamplePerCh];
	__attribute__((aligned(32))) int UsbAudioDnStreamingOneFrameBufR[AudioFrameSizeInSamplePerCh];
	__attribute__((aligned(32))) int AsrcInBuf [AudioFrameSizeInSamplePerCh*2  ];	//LR mixed buffer
	__attribute__((aligned(32))) int AsrcOutBuf[AudioFrameSizeInSamplePerCh*2*3];	//LR mixed buffer, and enlarge 3x space to fit the output from ASRC

	__attribute__((aligned(32))) int AudioBuf_S32[4][AudioFrameSizeInSamplePerCh];

	//part 4 --- others
	volatile int *I2SInputCh01Ptr;
	volatile int *I2SOtputCh01Ptr;
	volatile int *I2SOtputCh23Ptr;

	volatile unsigned short int UsbUpStreamingIsStarted;
	volatile unsigned short int UsbDnStreamingIsStarted;

	volatile unsigned int CycCnt[100];
	volatile unsigned int U32CycCntHistory[100];
	volatile unsigned int ControlPara[100];

} T_CommonVarSharedByDspAndMcu;


#endif
