/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdio.h>
#include <stdlib.h>

#include "fsl_device_registers.h"
#include "clock_config.h"
#include "board.h"
#include "fsl_debug_console.h"
#include "fsl_gpio.h"
#include "pin_mux.h"
#include "GlobalDef.h"

#include "SubFunc.h"



void delay_us(unsigned int d)
{
    volatile uint32_t i = 0;
	for (i = 0; i < 3*d; i++)
	{
		__NOP();
	}
}
void delay_ms(unsigned int d)
{
    volatile uint32_t i = 0;
    volatile uint32_t j = 0;
    for (j = 0; j < d; j++)
		for (i = 0; i < 30000; i++)
		{
			__NOP();
		}
}


void OpeningBlink(unsigned int l)
{
	int d;
	DbgPin1Dn;DbgPin2Dn;DbgPin3Dn;DbgPin4Dn;

	d=l;
	while(d--)
	{
		LedOn_R();
		delay_ms(20);
		LedOff_R();
		delay_ms(20);
	}

	d=l;
	while(d--)
	{
		LedOn_B();
		delay_ms(20);
		LedOff_B();
		delay_ms(20);
	}

	DbgPin1Up;delay_ms(1);DbgPin1Dn;delay_ms(1);
	DbgPin2Up;delay_ms(1);DbgPin2Dn;delay_ms(1);DbgPin2Up;delay_ms(1);DbgPin2Dn;delay_ms(1);
	DbgPin3Up;delay_ms(1);DbgPin3Dn;delay_ms(1);DbgPin3Up;delay_ms(1);DbgPin3Dn;delay_ms(1);DbgPin3Up;delay_ms(1);DbgPin3Dn;delay_ms(1);
	DbgPin4Up;delay_ms(1);DbgPin4Dn;delay_ms(1);DbgPin4Up;delay_ms(1);DbgPin4Dn;delay_ms(1);DbgPin4Up;delay_ms(1);DbgPin4Dn;delay_ms(1);DbgPin4Up;delay_ms(1);DbgPin4Dn;delay_ms(1);
}


gpio_pin_config_t GPIO_Output_config = {
    kGPIO_DigitalOutput,
    1,
};

void InitDbgPin(void)
{
    gpio_pin_config_t led_config = {
        kGPIO_DigitalOutput,
        0,
    };

    GPIO_PortInit(GPIO, 0);
    //GPIO_PinInit(GPIO, 0, PinLedG, &led_config);
    GPIO_PinInit(GPIO, 0, PinLedB, &led_config);
    GPIO_PinInit(GPIO, 0, PinLedR, &led_config);

    GPIO_PinInit(GPIO, 0, DbgPin1Idx, &led_config);
    GPIO_PinInit(GPIO, 0, DbgPin2Idx, &led_config);
    GPIO_PinInit(GPIO, 0, DbgPin3Idx, &led_config);
    GPIO_PinInit(GPIO, 0, DbgPin4Idx, &led_config);

}

