/*
 * Copyright 2024 - 2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef __ASRCProcess_H_INCLUDED__
#define __ASRCProcess_H_INCLUDED__


#ifdef __cplusplus
extern "C"{
#endif


#define UsbAudioDnSyncByFeedbackEP				0		//0:	USB audio in sync mode by Feedback end point
#define UsbAudioDnSyncByAsrc					1		//1:	USB audio in sync mode by NXP CM7 ASRC or Audio PLL adjusting

#define AudioDataRateMathing_NxpCM7Asrc					1
#define AudioDataRateMathing_AdjustingAudioPll			2

#define USB_AUDIO_ENTER_CRITICAL() 			\
				OSA_SR_ALLOC();            	\
				OSA_ENTER_CRITICAL()
#define USB_AUDIO_EXIT_CRITICAL() OSA_EXIT_CRITICAL()

extern float Kp;
extern float Ki;
extern float Kd;
extern int PI_Control_SampleAOD_ErrAccumulated;
extern int PI_ErrAccMaxValue;
extern int PreErr;

extern float KpValueAtFsIn48KHz;
extern float KiValueAtFsIn48KHz;
extern float KdValueAtFsIn48KHz;
extern float PI_ErrAccMaxValueAtFsIn48KHz;


extern int BufAmountOfData;

extern float AsrcDriftingValueCurrent;
extern float AsrcDriftingValueTarget;
extern int AsrcFsInCurrent;
extern int AsrcFsInTarget;

extern T_ASRCProcessor AsrcProcessor1;
extern T_ASRCProcessor AsrcProcessor2;

extern float AsrcInputAudioBuf[AudioFrameSizeInSamplePerCh*2];
extern void AsrcProcessAndSaveToCirBuf(float *SrcPtr);

#if EnableAsrcLatencyTest==1
extern int AsrcLatencyTestCnt;
#endif



#ifdef __cplusplus
}
#endif

#endif
