/*
 * Copyright 2020-2024 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __GlobalDef_h__
#define __GlobalDef_h__



#define LocalI2SFsIs48KHz		1
#define LocalI2SFsIs44p1KHz		0

#if (LocalI2SFsIs48KHz!=0)&&(LocalI2SFsIs44p1KHz!=0)
#error Please set correct local I2S frequency
#endif

#define EnableAsrcLatencyTest	0

#define SetToneGen2To1KHz		1
#define SetToneGen2To17KHz		0

#if (SetTonelGen2To1KHz!=0)&&(SetTonelGen2To17KHz!=0)
#error Please set correct Tone generator frequency
#endif



//----------------------------------------USB audio related----------------------------------
//---beg---

/*! @brief Whether USB Audio use syn mode or not. */
#define USB_DEVICE_AUDIO_USE_SYNC_MODE (0U)				//when syn mode is changed, PID is changed too

#if 1		//folding

//--------------- USB down stream ch format def--------------------
//---beg---
#define UsbAudioFormat_DnStreamChNumIsTwo
//#define UsbAudioFormat_DnStreamChNumIsFour

//#define UsbAudioFormat_DnStreamFsIs16K
//#define UsbAudioFormat_DnStreamFsIs32K
#define UsbAudioFormat_DnStreamFsIs48K
//#define UsbAudioFormat_DnStreamFsIs96K

//#define UsbAudioFormat_DnStreamSampleIs16Bit
#define UsbAudioFormat_DnStreamSampleIs32Bit

#ifdef UsbAudioFormat_DnStreamChNumIsTwo
#define AUDIO_OUT_FORMAT_CHANNELS (0x02)
#elif defined(UsbAudioFormat_DnStreamChNumIsFour)
#define AUDIO_OUT_FORMAT_CHANNELS (0x04)
#endif

#ifdef UsbAudioFormat_DnStreamFsIs16K
#define AUDIO_OUT_SAMPLING_RATE_KHZ (16)
#define AUDIO_OUT_SAMPLING_RATE_KHZ_Idx (0)
#elif defined(UsbAudioFormat_DnStreamFsIs32K)
#define AUDIO_OUT_SAMPLING_RATE_KHZ (32)
#define AUDIO_OUT_SAMPLING_RATE_KHZ_Idx (1)
#elif defined(UsbAudioFormat_DnStreamFsIs48K)
#define AUDIO_OUT_SAMPLING_RATE_KHZ (48)
#define AUDIO_OUT_SAMPLING_RATE_KHZ_Idx (2)
#elif defined(UsbAudioFormat_DnStreamFsIs96K)
#define AUDIO_OUT_SAMPLING_RATE_KHZ (96)
#define AUDIO_OUT_SAMPLING_RATE_KHZ_Idx (3)
#endif

#ifdef UsbAudioFormat_DnStreamSampleIs16Bit
#define AUDIO_OUT_FORMAT_BITS (16)
#define AUDIO_OUT_FORMAT_SIZE (2)
#define UsbAudioFormat_DnStreamSampleBitResolution_Idx (0)
#elif defined(UsbAudioFormat_DnStreamSampleIs32Bit)
#define AUDIO_OUT_FORMAT_BITS (32)
#define AUDIO_OUT_FORMAT_SIZE (4)
#define UsbAudioFormat_DnStreamSampleBitResolution_Idx (1)
#endif

#define AUDIO_SAMPLING_RATE_16KHZ (16)
#define AUDIO_SAMPLING_RATE (AUDIO_OUT_SAMPLING_RATE_KHZ * 1000)

//---end---
//--------------- USB down stream ch format def--------------------



//--------------- USB upstream ch format def--------------------
//---beg---

//#define UsbAudioFormat_UpStreamFsIs16K
//#define UsbAudioFormat_UpStreamFsIs32K
#define UsbAudioFormat_UpStreamFsIs48K

//#define UsbAudioFormat_UpStreamSampleIs16Bit
#define UsbAudioFormat_UpStreamSampleIs32Bit

#define UsbAudioFormat_NumUpStreamCh 4

#if UsbAudioFormat_NumUpStreamCh == 1
	#define AUDIO_IN_FORMAT_CHANNELS (0x01)
#elif UsbAudioFormat_NumUpStreamCh == 2
	#define AUDIO_IN_FORMAT_CHANNELS (0x02)
#elif UsbAudioFormat_NumUpStreamCh == 4
	#define AUDIO_IN_FORMAT_CHANNELS (0x04)
#elif UsbAudioFormat_NumUpStreamCh == 6
	#define AUDIO_IN_FORMAT_CHANNELS (0x06)
#else
	#error UsbAudioFormat_NumUpStreamCh is incorrect.
#endif

#ifdef UsbAudioFormat_UpStreamFsIs16K
	#define AUDIO_IN_SAMPLING_RATE_KHZ (16)
	#define AUDIO_IN_SAMPLING_RATE_KHZ_Idx (0)
#elif defined(UsbAudioFormat_UpStreamFsIs32K)
	#define AUDIO_IN_SAMPLING_RATE_KHZ (32)
	#define AUDIO_IN_SAMPLING_RATE_KHZ_Idx (1)
#elif defined(UsbAudioFormat_UpStreamFsIs48K)
	#define AUDIO_IN_SAMPLING_RATE_KHZ (48)
	#define AUDIO_IN_SAMPLING_RATE_KHZ_Idx (2)
#endif

#ifdef UsbAudioFormat_UpStreamSampleIs16Bit
#define AUDIO_IN_FORMAT_BITS (16)
#define AUDIO_IN_FORMAT_SIZE (2)
#define UsbAudioFormat_UpStreamSampleBitResolution_Idx (0)
#elif defined(UsbAudioFormat_UpStreamSampleIs32Bit)
#define AUDIO_IN_FORMAT_BITS (32)
#define AUDIO_IN_FORMAT_SIZE (4)
#define UsbAudioFormat_UpStreamSampleBitResolution_Idx (1)
#endif
//---end---
//--------------- USB upstream ch format def--------------------



//fixed values --- should never change
#define USB_DEVICE_VID (0x1FC9U)

#if defined(USB_DEVICE_AUDIO_USE_SYNC_MODE) && (USB_DEVICE_AUDIO_USE_SYNC_MODE > 0U)
	#define USB_DEVICE_PID (0x1650U)
#else
	#define USB_DEVICE_PID (0x1651U)
#endif


#endif		//folding
//---end---
//----------------------------------------USB audio related----------------------------------


#define GET_CYCLE_COUNTER(x)   x = DWT->CYCCNT;
#define DoAsrcInUsbIntr					0
#ifndef USB_DEVICE_CONFIG_AUDIO_CLASS_2_0
	#define USB_DEVICE_CONFIG_AUDIO_CLASS_2_0 (1U)
#endif

#define EnableCodec						1


#define AudioFrameSizeInSamplePerCh 							(6)
#define UsbUpStreamingCirBuf_Len_InSamples                     	(48 * 16)			//16ms
#define UsbUpStreamingCirBuf_MaxReadLengthInSamples				(48 * 1 + 1)		//USB audio event will read this buffer, and the read size is 1 ms time audio, 48 samples and 1 more

#define NUM_MIC							2






#endif	//define __GlobalDef_h__






