/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"
#include "app.h"
#include "dimage.h"
#include "memory.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define INCLUDE_NEWER_FIRMWARE

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

#ifdef INCLUDE_NEWER_FIRMWARE
extern const char _binary_frdmk32l2a4s_boot_loader_app_crc_bin_start[], _binary_frdmk32l2a4s_boot_loader_app_crc_bin_size[];
const uint8_t *APP_START = _binary_frdmk32l2a4s_boot_loader_app_crc_bin_start;
const size_t APP_SIZE = (size_t)_binary_frdmk32l2a4s_boot_loader_app_crc_bin_size;
#endif	

uint8_t buf[SPI_FLASH_SECTOR] = {0xFF}; /* 64KB */

uint32_t show_buf(uint8_t *buf, uint32_t len)
{
    for(uint32_t i = 0; i < len; i++)
    {
        if((i) % 16 == 0)
        {
            PRINTF("0x%04x: ", i);
        }
        PRINTF("%02x ", buf[i]);
        if((i+1) % 16 == 0)
        {
            PRINTF("\r\n");
        }
    }
    PRINTF("\r\n");
}
/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief Main function
 */
int main(void)
{
    ihdr_t *image_header = (ihdr_t *)DUAL_IMAGE_HDR;
	uint32_t baddr;
    char ch;
    int ret;

    /* Init board hardware. */
    BOARD_InitHardware();
	memory_init();

    PRINTF("Ver.%X booted.\r\n", image_header->version);

    while(true)
    {
        PRINTF("Press any key. (e: erase, p:program)\r\n");

        ch = GETCHAR();
        PRINTF("%c\r\n", ch);
        if(ch == 'p')
        {
#ifdef INCLUDE_NEWER_FIRMWARE
            baddr = image_program(APP_START, APP_SIZE);
            PRINTF("Programmed.\r\n");
            if(image_verify((uint32_t)APP_START, baddr, APP_SIZE) == 0)
            {
                PRINTF("Verified.\r\n");
            }
            else
            {
                PRINTF("Not verified.\r\n");
            }
#endif
        }
        else if(ch == 'e')
        {
            image_erase(0);
            image_erase(1);
            PRINTF("Erased.\r\n");
            memset(buf, 0xFF, SPI_FLASH_SECTOR);
            for(uint32_t addr = BACKUP_REGION_START; addr < BACKUP_REGION_START + BACKUP_IMAGE_CNT * BACKUP_REGION_LEN; addr += SPI_FLASH_SECTOR)
            {
                ret = image_verify((uint32_t)buf, addr, SPI_FLASH_SECTOR);
                if(ret)
                {
                    break;
                }
            }
            if(ret)
            {
                PRINTF("Not verified.\r\n");
            }
            else
            {
                PRINTF("Verified.\r\n");
            }
        }       
        memory_read(BACKUP_REGION_START, buf, 0x100);
        show_buf(buf, 0x100);
    }
}
