/*
 * Copyright 2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_common.h"
#include "model_config.h"
#include "math.h"

/*******************************************************************************
 * Variables
 ******************************************************************************/
// Convert unsigned 8-bit image data to model input format in-place.
static uint8_t conversion_lut[UINT8_MAX + 1] = {0};

/*******************************************************************************
 * Functions
 ******************************************************************************/
static void InitConversionLUT() {
	for (uint32_t i = 0; i < sizeof(conversion_lut); ++i) {
		conversion_lut[i] = (int8_t)round((i / MODEL_INPUT_MEAN) - MODEL_INPUT_STD);
	}
}

void MODEL_PreprocessInit()
{
	InitConversionLUT();
}

void MODEL_Preprocess(uint8_t* data)
{
	for (int i = 0; i < MODEL_INPUT_SIZE; ++i)
	{
		data[i] = conversion_lut[data[i]];
	}
}
