/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2024 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MULTICORE_COMS_H_
#define MULTICORE_COMS_H_

#include <stdint.h>

typedef struct _multicore_coms_msg_ptr
{
    uint32_t aImgYUV;
    uint32_t aImgRGB;
} multicore_coms_msg, *multicore_coms_msg_ptr;

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

void MCC_Init(void);
void MCC_Send(multicore_coms_msg_ptr msg, uint8_t block);
uint32_t MCC_Rcv(multicore_coms_msg_ptr msg, uint8_t block);
int32_t MCC_GetPendingRcvSize();

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* MULTICORE_COMS_H_ */
