/*
 * Copyright 2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __APP_H__
#define __APP_H__
#include "usb_host_config.h"
#include "usb_host.h"
#include "fsl_device_registers.h"
#include <utils.h>
#include "model_config.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/

/* @TEST_ANCHOR */

#if ((defined USB_HOST_CONFIG_KHCI) && (USB_HOST_CONFIG_KHCI))
#ifndef CONTROLLER_ID
#define CONTROLLER_ID kUSB_ControllerKhci0
#endif
#endif /* USB_HOST_CONFIG_KHCI */
#if ((defined USB_HOST_CONFIG_EHCI) && (USB_HOST_CONFIG_EHCI))
#ifndef CONTROLLER_ID
#define CONTROLLER_ID kUSB_ControllerEhci0
#endif
#endif /* USB_HOST_CONFIG_EHCI */
#if ((defined USB_HOST_CONFIG_OHCI) && (USB_HOST_CONFIG_OHCI))
#ifndef CONTROLLER_ID
#define CONTROLLER_ID kUSB_ControllerOhci0
#endif
#endif /* USB_HOST_CONFIG_OHCI */
#if ((defined USB_HOST_CONFIG_IP3516HS) && (USB_HOST_CONFIG_IP3516HS))
#ifndef CONTROLLER_ID
#define CONTROLLER_ID kUSB_ControllerIp3516Hs0
#endif
#endif /* USB_HOST_CONFIG_IP3516HS */

#if defined(__GIC_PRIO_BITS)
#define USB_HOST_INTERRUPT_PRIORITY (25U)
#else
#define USB_HOST_INTERRUPT_PRIORITY (6U)
#endif

/*! @brief host app device attach/detach status */
typedef enum _usb_host_app_state
{
    kStatus_DEV_Idle = 0, /*!< there is no device attach/detach */
    kStatus_DEV_Attached, /*!< device is attached */
    kStatus_DEV_Detached, /*!< device is detached */
} usb_host_app_state_t;

enum _camera_frame_rate {
	FPS5 = 2000000,
	FPS7 = 1333333,
	FPS10 = 1000000,
	FPS15 = 666666,
	FPS20 = 500000,
	FPS24 = 416666,
	FPS30 = 333333,
};

#define CAMERA_FRAME_RATE      FPS15
#define MATCH_RESOLUTION_FIXED 1
#define MATCH_RES_W            640 //1280 //640 //352
#define MATCH_RES_H            480 // 720 //480 //288
#define MAX_BOXES_TO_DRAW      10  // boxes to draw
#define DISPLAY_INFERENCE_FREQ 3   // How often to run inference. Use this to smooth out graphics
#define USE_PSRAM_JPG_BUFFERS  1
#endif /* __APP_H__ */
