::***************************************************************************
:: This file shows how to generate signed message and TLV blob.
::***************************************************************************
@echo off
:: User needs to update the path of spsdk
SET "PATH=C:\RT1180\HSM_TEST\venv_330\Scripts\;%PATH%"

::***************************************************************************
:: Convert the NXP production public key from a hexadecimal string to PEM format.
::***************************************************************************
::nxpimage utils convert hex2bin -i nxp_prod.txt -o nxp_prod.bin
::nxpcrypto key convert -e PEM -i nxp_prod.bin -o nxp_prod.pub

::***************************************************************************
:: Generate key pairs
::***************************************************************************
::nxpcrypto key generate -k secp256r1 --force -o app_ecc256.pem

::***************************************************************************
:: Convert ECC public key to raw data and binary file
::***************************************************************************
nxpcrypto key convert -e RAW -i app_ecc256.pub -o ecc256_pub_key.bin
nxpimage utils convert bin2carr -i ecc256_pub_key.bin -e little -c 8 -n ecc256_pub_key -o app_ecc256_pub.c

::***************************************************************************
:: Get the hash value of public key and user_fixed_info(if needed)
::***************************************************************************
nxpcrypto digest -h sha256 -i ecc256_pub_key.bin

::***************************************************************************
:: Generate the template config file for signed-msg key exchange command and TLV
::***************************************************************************
::nxpimage signed-msg get-template -f rt118x -m KEY_EXCHANGE_REQ -o config/signed_msg_template.yaml --force
::nxpimage signed-msg tlv get-template -f rt118x -o config/oem_import_key_template.yaml --force

::***************************************************************************
:: Generate the data for Key Exchange Procedure with real config file
::***************************************************************************
nxpimage signed-msg export -c config/signed_msg_config.yaml -w ecdh_derived_key
nxpimage utils convert bin2carr -i config/signed_message.bin -e little -c 8 -n signed_msg_bin -o signed_message.c

::***************************************************************************
:: Generate TLV Blob
::***************************************************************************
nxpimage signed-msg tlv export -c config/oem_import_key.yaml
nxpimage utils convert bin2carr -i config/tlv.bin -e little -c 8 -n oem_tlv_blob -o oem_tlv_blob.c
pause
