/*
** ###################################################################
**     Processors:          MIMXRT1181CVP2B
**                          MIMXRT1181CVP2C
**                          MIMXRT1181XVP2B
**                          MIMXRT1181XVP2C
**                          MIMXRT1182CVP2B
**                          MIMXRT1182CVP2C
**                          MIMXRT1182XVP2B
**                          MIMXRT1182XVP2C
**                          MIMXRT1186CVJ8C_cm33
**                          MIMXRT1186CVJ8C_cm7
**                          MIMXRT1186XVJ8C_cm33
**                          MIMXRT1186XVJ8C_cm7
**                          MIMXRT1187AVM8B_cm33
**                          MIMXRT1187AVM8B_cm7
**                          MIMXRT1187AVM8C_cm33
**                          MIMXRT1187AVM8C_cm7
**                          MIMXRT1187CVM8B_cm33
**                          MIMXRT1187CVM8B_cm7
**                          MIMXRT1187CVM8C_cm33
**                          MIMXRT1187CVM8C_cm7
**                          MIMXRT1187XVM8B_cm33
**                          MIMXRT1187XVM8B_cm7
**                          MIMXRT1187XVM8C_cm33
**                          MIMXRT1187XVM8C_cm7
**                          MIMXRT1189CVM8B_cm33
**                          MIMXRT1189CVM8B_cm7
**                          MIMXRT1189CVM8C_cm33
**                          MIMXRT1189CVM8C_cm7
**                          MIMXRT1189XVM8B_cm33
**                          MIMXRT1189XVM8B_cm7
**                          MIMXRT1189XVM8C_cm33
**                          MIMXRT1189XVM8C_cm7
**
**     Version:             rev. 2.0, 2024-01-18
**     Build:               b250331
**
**     Abstract:
**         CMSIS Peripheral Access Layer for CACHE_ECC_MCM
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2025 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2021-03-09)
**         Initial version.
**     - rev. 2.0 (2024-01-18)
**         Header RFP.
**
** ###################################################################
*/

/*!
 * @file PERI_CACHE_ECC_MCM.h
 * @version 2.0
 * @date 2024-01-18
 * @brief CMSIS Peripheral Access Layer for CACHE_ECC_MCM
 *
 * CMSIS Peripheral Access Layer for CACHE_ECC_MCM
 */

#if !defined(PERI_CACHE_ECC_MCM_H_)
#define PERI_CACHE_ECC_MCM_H_                    /**< Symbol preventing repeated inclusion */

#if (defined(CPU_MIMXRT1181CVP2B) || defined(CPU_MIMXRT1181CVP2C) || defined(CPU_MIMXRT1181XVP2B) || defined(CPU_MIMXRT1181XVP2C))
#include "MIMXRT1181_COMMON.h"
#elif (defined(CPU_MIMXRT1182CVP2B) || defined(CPU_MIMXRT1182CVP2C) || defined(CPU_MIMXRT1182XVP2B) || defined(CPU_MIMXRT1182XVP2C))
#include "MIMXRT1182_COMMON.h"
#elif (defined(CPU_MIMXRT1186CVJ8C_cm33) || defined(CPU_MIMXRT1186XVJ8C_cm33))
#include "MIMXRT1186_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1186CVJ8C_cm7) || defined(CPU_MIMXRT1186XVJ8C_cm7))
#include "MIMXRT1186_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT1187AVM8B_cm33) || defined(CPU_MIMXRT1187AVM8C_cm33) || defined(CPU_MIMXRT1187CVM8B_cm33) || defined(CPU_MIMXRT1187CVM8C_cm33) || defined(CPU_MIMXRT1187XVM8B_cm33) || defined(CPU_MIMXRT1187XVM8C_cm33))
#include "MIMXRT1187_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1187AVM8B_cm7) || defined(CPU_MIMXRT1187AVM8C_cm7) || defined(CPU_MIMXRT1187CVM8B_cm7) || defined(CPU_MIMXRT1187CVM8C_cm7) || defined(CPU_MIMXRT1187XVM8B_cm7) || defined(CPU_MIMXRT1187XVM8C_cm7))
#include "MIMXRT1187_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT1189CVM8B_cm33) || defined(CPU_MIMXRT1189CVM8C_cm33) || defined(CPU_MIMXRT1189XVM8B_cm33) || defined(CPU_MIMXRT1189XVM8C_cm33))
#include "MIMXRT1189_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1189CVM8B_cm7) || defined(CPU_MIMXRT1189CVM8C_cm7) || defined(CPU_MIMXRT1189XVM8B_cm7) || defined(CPU_MIMXRT1189XVM8C_cm7))
#include "MIMXRT1189_cm7_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- CACHE_ECC_MCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE_ECC_MCM_Peripheral_Access_Layer CACHE_ECC_MCM Peripheral Access Layer
 * @{
 */

/** CACHE_ECC_MCM - Register Layout Typedef */
typedef struct {
  __IO uint32_t CACHE_ECCR;                        /**< CACHE ECC Control, offset: 0x0 */
       uint8_t RESERVED_0[28];
  __IO uint32_t INT_STATUS;                        /**< Interrupt Status, offset: 0x20 */
  __IO uint32_t INT_STAT_EN;                       /**< Interrupt Status Enable, offset: 0x24 */
  __IO uint32_t INT_SIG_EN;                        /**< Interrupt Enable, offset: 0x28 */
       uint8_t RESERVED_1[48];
  __I  uint32_t CODE_CACHE_ECC_SINGLE_ERROR_INFO;  /**< Code Cache Single-Bit ECC Error Information, offset: 0x5C */
  __I  uint32_t CODE_CACHE_ECC_SINGLE_ERROR_ADDR;  /**< Code Cache Single-Bit ECC Error Address, offset: 0x60 */
       uint8_t RESERVED_2[4];
  __I  uint32_t CODE_CACHE_ECC_MULTI_ERROR_INFO;   /**< Code Cache Multibit ECC Error Information, offset: 0x68 */
       uint8_t RESERVED_3[8];
  __I  uint32_t SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO; /**< System Cache Single-Bit ECC Error Information, offset: 0x74 */
  __I  uint32_t SYSTEM_CACHE_ECC_SINGLE_ERROR_ADDR; /**< System Cache Single-Bit ECC Error Address, offset: 0x78 */
       uint8_t RESERVED_4[4];
  __I  uint32_t SYSTEM_CACHE_ECC_MULTI_ERROR_INFO; /**< System Cache Multibit ECC Error Information, offset: 0x80 */
  __I  uint32_t SYSTEM_CACHE_ECC_MULTI_ERROR_DATA; /**< System Cache Multibit ECC Error Data, offset: 0x84 */
       uint8_t RESERVED_5[4];
  __IO uint32_t CODE_CACHE_TAG0_ECC_ERROR_INJEC;   /**< Code Cache TAG0 ECC Error Injection, offset: 0x8C */
  __IO uint32_t CODE_CACHE_TAG1_ECC_ERROR_INJEC;   /**< Code Cache TAG1 ECC Error Injection, offset: 0x90 */
  __IO uint32_t CODE_CACHE_DATA0_ECC_ERROR_INJEC;  /**< Code Cache DATA0 ECC Error Injection, offset: 0x94 */
  __IO uint32_t CODE_CACHE_DATA1_ECC_ERROR_INJEC;  /**< Code Cache DATA1 ECC Error Injection, offset: 0x98 */
  __IO uint32_t SYTEM_CACHE_TAG0_ECC_ERROR_INJEC;  /**< System Cache TAG0 ECC Error Injection, offset: 0x9C */
  __IO uint32_t SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC; /**< System Cache TAG1 ECC Error Injection, offset: 0xA0 */
  __IO uint32_t SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC; /**< System Cache DATA0 ECC Error Injection, offset: 0xA4 */
  __IO uint32_t STSTEM_CACHE_DATA1_ECC_ERROR_INJEC; /**< System Cache DATA1 ECC Error Injection, offset: 0xA8 */
} CACHE_ECC_MCM_Type;

/* ----------------------------------------------------------------------------
   -- CACHE_ECC_MCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE_ECC_MCM_Register_Masks CACHE_ECC_MCM Register Masks
 * @{
 */

/*! @name CACHE_ECCR - CACHE ECC Control */
/*! @{ */

#define CACHE_ECC_MCM_CACHE_ECCR_WECC_DIS_MASK   (0x1U)
#define CACHE_ECC_MCM_CACHE_ECCR_WECC_DIS_SHIFT  (0U)
/*! WECC_DIS - Disable CACHE ECC Write Generation
 *  0b0..Enable
 *  0b1..Disable
 */
#define CACHE_ECC_MCM_CACHE_ECCR_WECC_DIS(x)     (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CACHE_ECCR_WECC_DIS_SHIFT)) & CACHE_ECC_MCM_CACHE_ECCR_WECC_DIS_MASK)

#define CACHE_ECC_MCM_CACHE_ECCR_RECC_DIS_MASK   (0x2U)
#define CACHE_ECC_MCM_CACHE_ECCR_RECC_DIS_SHIFT  (1U)
/*! RECC_DIS - Disable Cache ECC Read Check
 *  0b0..Enable
 *  0b1..Disable
 */
#define CACHE_ECC_MCM_CACHE_ECCR_RECC_DIS(x)     (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CACHE_ECCR_RECC_DIS_SHIFT)) & CACHE_ECC_MCM_CACHE_ECCR_RECC_DIS_MASK)
/*! @} */

/*! @name INT_STATUS - Interrupt Status */
/*! @{ */

#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_INT_MASK (0x100U)
#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_INT_SHIFT (8U)
/*! CODE_CACHE_ECC_ERRM_INT - Code Cache Access Multibit ECC Error Interrupt Status
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Error
 *  0b1..Clear the flag
 */
#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_INT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_INT_SHIFT)) & CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_INT_MASK)

#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_INT_MASK (0x200U)
#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_INT_SHIFT (9U)
/*! CODE_CACHE_ECC_ERRS_INT - Code Cache Access Single-Bit ECC Error Interrupt Status
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Error
 *  0b1..Clear the flag
 */
#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_INT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_INT_SHIFT)) & CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_INT_MASK)

#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_OVER_INT_MASK (0x400U)
#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_OVER_INT_SHIFT (10U)
/*! CODE_CACHE_ECC_ERRM_OVER_INT - Code Cache Access Multiple Multibit ECC Error Interrupt Status
 *  0b0..Not more than one error
 *  0b0..No effect
 *  0b1..Multiple errors
 *  0b1..Clear the flag
 */
#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_OVER_INT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_OVER_INT_SHIFT)) & CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRM_OVER_INT_MASK)

#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_OVER_INT_MASK (0x800U)
#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_OVER_INT_SHIFT (11U)
/*! CODE_CACHE_ECC_ERRS_OVER_INT - Code Cache Access Multiple Single-Bit ECC Error Interrupt Status
 *  0b0..Not more than one error
 *  0b0..No effect
 *  0b1..Multiple errors
 *  0b1..Clear the flag
 */
#define CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_OVER_INT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_OVER_INT_SHIFT)) & CACHE_ECC_MCM_INT_STATUS_CODE_CACHE_ECC_ERRS_OVER_INT_MASK)

#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_INT_MASK (0x1000U)
#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_INT_SHIFT (12U)
/*! SYSTEM_CACHE_ECC_ERRM_INT - System Cache Access Multibit ECC Error Interrupt Status
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Error
 *  0b1..Clear the flag
 */
#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_INT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_INT_SHIFT)) & CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_INT_MASK)

#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_INT_MASK (0x2000U)
#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_INT_SHIFT (13U)
/*! SYSTEM_CACHE_ECC_ERRS_INT - System Cache Access Single-Bit ECC Error Interrupt Status
 *  0b0..No error
 *  0b0..No effect
 *  0b1..Error
 *  0b1..Clear the flag
 */
#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_INT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_INT_SHIFT)) & CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_INT_MASK)

#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_OVER_INT_MASK (0x4000U)
#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_OVER_INT_SHIFT (14U)
/*! SYSTEM_CACHE_ECC_ERRM_OVER_INT - System Cache Access Multiple Multibit ECC Error Interrupt Status
 *  0b0..Not more than one error
 *  0b0..No effect
 *  0b1..Multiple errors
 *  0b1..Clear the flag
 */
#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_OVER_INT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_OVER_INT_SHIFT)) & CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRM_OVER_INT_MASK)

#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_OVER_INT_MASK (0x8000U)
#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_OVER_INT_SHIFT (15U)
/*! SYSTEM_CACHE_ECC_ERRS_OVER_INT - System Cache Access Multiple Single-Bit ECC Error Interrupt Status
 *  0b0..Not more than one error
 *  0b0..No effect
 *  0b1..Multiple errors
 *  0b1..Clear the flag
 */
#define CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_OVER_INT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_OVER_INT_SHIFT)) & CACHE_ECC_MCM_INT_STATUS_SYSTEM_CACHE_ECC_ERRS_OVER_INT_MASK)
/*! @} */

/*! @name INT_STAT_EN - Interrupt Status Enable */
/*! @{ */

#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_INT_EN_MASK (0x100U)
#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_INT_EN_SHIFT (8U)
/*! CODE_CACHE_ERRM_INT_EN - Code Cache Access Multibit ECC Error Interrupt Status Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_INT_EN_SHIFT)) & CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_INT_EN_MASK)

#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_INT_EN_MASK (0x200U)
#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_INT_EN_SHIFT (9U)
/*! CODE_CACHE_ERRS_INT_EN - Code Cache Access Single-Bit ECC Error Interrupt Status Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_INT_EN_SHIFT)) & CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_INT_EN_MASK)

#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_OVER_INT_EN_MASK (0x400U)
#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_OVER_INT_EN_SHIFT (10U)
/*! CODE_CACHE_ERRM_OVER_INT_EN - Code Cache Access Multiple Multibit ECC Error Interrupt Status Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_OVER_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_OVER_INT_EN_SHIFT)) & CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRM_OVER_INT_EN_MASK)

#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_OVER_INT_EN_MASK (0x800U)
#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_OVER_INT_EN_SHIFT (11U)
/*! CODE_CACHE_ERRS_OVER_INT_EN - Code Cache Access Multiple Single-Bit ECC Error Interrupt Status Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_OVER_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_OVER_INT_EN_SHIFT)) & CACHE_ECC_MCM_INT_STAT_EN_CODE_CACHE_ERRS_OVER_INT_EN_MASK)

#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_INT_EN_MASK (0x1000U)
#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_INT_EN_SHIFT (12U)
/*! SYSTEM_CACHE_ECC_ERRM_INT_EN - System Cache Access Multibit ECC Error Interrupt Status Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_INT_EN_SHIFT)) & CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_INT_EN_MASK)

#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_INT_EN_MASK (0x2000U)
#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_INT_EN_SHIFT (13U)
/*! SYSTEM_CACHE_ECC_ERRS_INT_EN - System Cache Access Single-Bit ECC Error Interrupt Status Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_INT_EN_SHIFT)) & CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_INT_EN_MASK)

#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_OVER_INT_EN_MASK (0x4000U)
#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_OVER_INT_EN_SHIFT (14U)
/*! SYSTEM_CACHE_ECC_ERRM_OVER_INT_EN - System Cache Access Multiple Multibit ECC Error Interrupt Status Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_OVER_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_OVER_INT_EN_SHIFT)) & CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRM_OVER_INT_EN_MASK)

#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_OVER_INT_EN_MASK (0x8000U)
#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_OVER_INT_EN_SHIFT (15U)
/*! SYSTEM_CACHE_ECC_ERRS_OVER_INT_EN - System Cache Access Multiple Single-Bit ECC Error Interrupt Status Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_OVER_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_OVER_INT_EN_SHIFT)) & CACHE_ECC_MCM_INT_STAT_EN_SYSTEM_CACHE_ECC_ERRS_OVER_INT_EN_MASK)
/*! @} */

/*! @name INT_SIG_EN - Interrupt Enable */
/*! @{ */

#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_INT_SIG_EN_MASK (0x100U)
#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_INT_SIG_EN_SHIFT (8U)
/*! CODE_CACHE_ERRM_INT_SIG_EN - Code Cache Access Multibit ECC Error Interrupt Signal Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_INT_SIG_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_INT_SIG_EN_SHIFT)) & CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_INT_SIG_EN_MASK)

#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_INT_SIG_EN_MASK (0x200U)
#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_INT_SIG_EN_SHIFT (9U)
/*! CODE_CACHE_ERRS_INT_SIG_EN - Code Cache Access Single-Bit ECC Error Interrupt Signal Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_INT_SIG_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_INT_SIG_EN_SHIFT)) & CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_INT_SIG_EN_MASK)

#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_OVER_INT_SIG_EN_MASK (0x400U)
#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_OVER_INT_SIG_EN_SHIFT (10U)
/*! CODE_CACHE_ERRM_OVER_INT_SIG_EN - Code Cache Access Multiple Multibit ECC Error Interrupt Signal Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_OVER_INT_SIG_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_OVER_INT_SIG_EN_SHIFT)) & CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRM_OVER_INT_SIG_EN_MASK)

#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_OVER_INT_SIG_EN_MASK (0x800U)
#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_OVER_INT_SIG_EN_SHIFT (11U)
/*! CODE_CACHE_ERRS_OVER_INT_SIG_EN - Code Cache Access Multiple Single-Bit ECC Error Interrupt Signal Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_OVER_INT_SIG_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_OVER_INT_SIG_EN_SHIFT)) & CACHE_ECC_MCM_INT_SIG_EN_CODE_CACHE_ERRS_OVER_INT_SIG_EN_MASK)

#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_INT_SIG_EN_MASK (0x1000U)
#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_INT_SIG_EN_SHIFT (12U)
/*! SYSTEM_CACHE_ERRM_INT_SIG_EN - System Cache Access Multibit ECC Error Interrupt Signal Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_INT_SIG_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_INT_SIG_EN_SHIFT)) & CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_INT_SIG_EN_MASK)

#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_INT_SIG_EN_MASK (0x2000U)
#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_INT_SIG_EN_SHIFT (13U)
/*! SYSTEM_CACHE_ERRS_INT_SIG_EN - System Cache Access Single-Bit ECC Error Interrupt Signal Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_INT_SIG_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_INT_SIG_EN_SHIFT)) & CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_INT_SIG_EN_MASK)

#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_OVER_INT_SIG_EN_MASK (0x4000U)
#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_OVER_INT_SIG_EN_SHIFT (14U)
/*! SYSTEM_CACHE_ERRM_OVER_INT_SIG_EN - System Cache Access Multiple Multibit ECC Error Interrupt Signal Enable
 *  0b0..Masked
 *  0b1..Enabled
 */
#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_OVER_INT_SIG_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_OVER_INT_SIG_EN_SHIFT)) & CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRM_OVER_INT_SIG_EN_MASK)

#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_OVER_INT_SIG_EN_MASK (0x8000U)
#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_OVER_INT_SIG_EN_SHIFT (15U)
/*! SYSTEM_CACHE_ERRS_OVER_INT_SIG_EN - System Cache Access Multiple Single-Bit ECC Error Interrupt Signal Enable
 *  0b0..Mask
 *  0b1..Enable
 */
#define CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_OVER_INT_SIG_EN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_OVER_INT_SIG_EN_SHIFT)) & CACHE_ECC_MCM_INT_SIG_EN_SYSTEM_CACHE_ERRS_OVER_INT_SIG_EN_MASK)
/*! @} */

/*! @name CODE_CACHE_ECC_SINGLE_ERROR_INFO - Code Cache Single-Bit ECC Error Information */
/*! @{ */

#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_TAG_MASK (0x1U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_TAG_SHIFT (0U)
/*! CODE_CACHE_ECCS_TAG - Code Cache Single-Bit ECC Error
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_TAG(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_TAG_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_TAG_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_CMD_MASK (0x2U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_CMD_SHIFT (1U)
/*! CODE_CACHE_ECCS_CMD - Code Cache Single-Bit ECC Error on Cache Command
 *  0b0..No error
 *  0b1..Error
 */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_CMD(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_CMD_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_CMD_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFMST_MASK (0xF0U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFMST_SHIFT (4U)
/*! CODE_CACHE_ECCS_EFMST - Code Cache Single-Bit ECC Error Master Number */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFMST(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFMST_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFMST_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFPRT_MASK (0x3F00U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFPRT_SHIFT (8U)
/*! CODE_CACHE_ECCS_EFPRT - Code Cache Single-Bit ECC Error Protection */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFPRT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFPRT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFPRT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFSYN_MASK (0x7F0000U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFSYN_SHIFT (16U)
/*! CODE_CACHE_ECCS_EFSYN - Code Cache Single-Bit ECC Error Corresponding Syndrome */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFSYN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFSYN_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_INFO_CODE_CACHE_ECCS_EFSYN_MASK)
/*! @} */

/*! @name CODE_CACHE_ECC_SINGLE_ERROR_ADDR - Code Cache Single-Bit ECC Error Address */
/*! @{ */

#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_ADDR_CODE_CACHE_ECCS_ERRED_ADDR_MASK (0xFFFFFFFFU)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_ADDR_CODE_CACHE_ECCS_ERRED_ADDR_SHIFT (0U)
/*! CODE_CACHE_ECCS_ERRED_ADDR - Code Cache Single-Bit ECC Error Address */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_ADDR_CODE_CACHE_ECCS_ERRED_ADDR(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_ADDR_CODE_CACHE_ECCS_ERRED_ADDR_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_SINGLE_ERROR_ADDR_CODE_CACHE_ECCS_ERRED_ADDR_MASK)
/*! @} */

/*! @name CODE_CACHE_ECC_MULTI_ERROR_INFO - Code Cache Multibit ECC Error Information */
/*! @{ */

#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_TAG_MASK (0x1U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_TAG_SHIFT (0U)
/*! CODE_CACHE_ECCM_TAG - Code Cache Multibit ECC Error
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_TAG(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_TAG_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_TAG_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_CMD_MASK (0x2U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_CMD_SHIFT (1U)
/*! CODE_CACHE_ECCM_CMD - Code Cache Multibit ECC Error on Code Cache Command
 *  0b0..No error
 *  0b1..Error
 */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_CMD(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_CMD_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_CMD_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFMST_MASK (0xF0U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFMST_SHIFT (4U)
/*! CODE_CACHE_ECCM_EFMST - Code Cache Multibit ECC Error Master Number */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFMST(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFMST_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFMST_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFPRT_MASK (0x3F00U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFPRT_SHIFT (8U)
/*! CODE_CACHE_ECCM_EFPRT - Code Cache Multibit ECC Error Protection */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFPRT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFPRT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFPRT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFSYN_MASK (0x7F0000U)
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFSYN_SHIFT (16U)
/*! CODE_CACHE_ECCM_EFSYN - Code Cache Multibit ECC Error Corresponding Syndrome */
#define CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFSYN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFSYN_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_ECC_MULTI_ERROR_INFO_CODE_CACHE_ECCM_EFSYN_MASK)
/*! @} */

/*! @name SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO - System Cache Single-Bit ECC Error Information */
/*! @{ */

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_TAG_MASK (0x1U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_TAG_SHIFT (0U)
/*! SYSTEM_CACHE_ECCS_TAG - System Cache Single-Bit ECC Error
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_TAG(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_TAG_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_TAG_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_CMD_MASK (0x2U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_CMD_SHIFT (1U)
/*! SYSTEM_CACHE_ECCS_CMD - System Cache Single-Bit ECC Error on Cache Command
 *  0b0..No error
 *  0b1..Error
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_CMD(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_CMD_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_CMD_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFMST_MASK (0xF0U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFMST_SHIFT (4U)
/*! SYSTEM_CACHE_ECCS_EFMST - System Cache Single-Bit ECC Error Master Number */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFMST(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFMST_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFMST_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFPRT_MASK (0x3F00U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFPRT_SHIFT (8U)
/*! SYSTEM_CACHE_ECCS_EFPRT - System Cache Single-Bit ECC Error Protection */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFPRT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFPRT_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFPRT_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFSYN_MASK (0x7F0000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFSYN_SHIFT (16U)
/*! SYSTEM_CACHE_ECCS_EFSYN - System Cache Single-Bit ECC Error Corresponding Syndrome */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFSYN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFSYN_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_INFO_SYSTEM_CACHE_ECCS_EFSYN_MASK)
/*! @} */

/*! @name SYSTEM_CACHE_ECC_SINGLE_ERROR_ADDR - System Cache Single-Bit ECC Error Address */
/*! @{ */

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_ADDR_SYSTEM_CACHE_ECCS_ERRED_ADDR_MASK (0xFFFFFFFFU)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_ADDR_SYSTEM_CACHE_ECCS_ERRED_ADDR_SHIFT (0U)
/*! SYSTEM_CACHE_ECCS_ERRED_ADDR - System Cache Single-Bit ECC Error Address */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_ADDR_SYSTEM_CACHE_ECCS_ERRED_ADDR(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_ADDR_SYSTEM_CACHE_ECCS_ERRED_ADDR_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_SINGLE_ERROR_ADDR_SYSTEM_CACHE_ECCS_ERRED_ADDR_MASK)
/*! @} */

/*! @name SYSTEM_CACHE_ECC_MULTI_ERROR_INFO - System Cache Multibit ECC Error Information */
/*! @{ */

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_TAG_MASK (0x1U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_TAG_SHIFT (0U)
/*! SYSTEM_CACHE_ECCM_TAG - System Cache Multibit ECC Error
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_TAG(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_TAG_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_TAG_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_CMD_MASK (0x2U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_CMD_SHIFT (1U)
/*! SYSTEM_CACHE_ECCM_CMD - System Cache Multibit ECC Error on System Cache Command
 *  0b0..No error
 *  0b1..Error
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_CMD(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_CMD_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_CMD_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFMST_MASK (0xF0U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFMST_SHIFT (4U)
/*! SYSTEM_CACHE_ECCM_EFMST - System Cache Multibit ECC Error Master Number */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFMST(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFMST_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFMST_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFPRT_MASK (0x3F00U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFPRT_SHIFT (8U)
/*! SYSTEM_CACHE_ECCM_EFPRT - System Cache Multibit ECC Error Protection */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFPRT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFPRT_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFPRT_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFSYN_MASK (0x7F0000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFSYN_SHIFT (16U)
/*! SYSTEM_CACHE_ECCM_EFSYN - System Cache Multibit ECC Error Corresponding Syndrome */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFSYN(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFSYN_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_INFO_SYSTEM_CACHE_ECCM_EFSYN_MASK)
/*! @} */

/*! @name SYSTEM_CACHE_ECC_MULTI_ERROR_DATA - System Cache Multibit ECC Error Data */
/*! @{ */

#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_DATA_SYSTEM_CACHE_ECCM_ERRED_DATA_MASK (0xFFFFFFFFU)
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_DATA_SYSTEM_CACHE_ECCM_ERRED_DATA_SHIFT (0U)
/*! SYSTEM_CACHE_ECCM_ERRED_DATA - System Cache Multibit ECC Error Data */
#define CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_DATA_SYSTEM_CACHE_ECCM_ERRED_DATA(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_DATA_SYSTEM_CACHE_ECCM_ERRED_DATA_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_ECC_MULTI_ERROR_DATA_SYSTEM_CACHE_ECCM_ERRED_DATA_MASK)
/*! @} */

/*! @name CODE_CACHE_TAG0_ECC_ERROR_INJEC - Code Cache TAG0 ECC Error Injection */
/*! @{ */

#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR1BIT_MASK (0x7FU)
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR1BIT_SHIFT (0U)
/*! CODE_CACHE_TAG0_ERR1BIT - Position of First Bit to Inject ECC Error */
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR1BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR1BIT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR1BIT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR2BIT_MASK (0x7F00U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR2BIT_SHIFT (8U)
/*! CODE_CACHE_TAG0_ERR2BIT - Position of Second Bit to Inject ECC Error */
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR2BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR2BIT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_ERR2BIT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR11BI_MASK (0x10000U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR11BI_SHIFT (16U)
/*! CODE_CACHE_TAG0_FR11BI - Force One 1-Bit Data Inversion on Code Cache TAG0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR11BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR11BI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR11BI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR1NCI_MASK (0x20000U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR1NCI_SHIFT (17U)
/*! CODE_CACHE_TAG0_FR1NCI - Force One Noncorrectable Data Inversion on Code Cache TAG0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR1NCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR1NCI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FR1NCI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRC1BI_MASK (0x40000U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRC1BI_SHIFT (18U)
/*! CODE_CACHE_TAG0_FRC1BI - Force Continuous 1-Bit Data Inversions on Code Cache TAG0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRC1BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRC1BI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRC1BI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRCNCI_MASK (0x80000U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRCNCI_SHIFT (19U)
/*! CODE_CACHE_TAG0_FRCNCI - Force Continuous Noncorrectable Data Inversions on Code Cache TAG0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRCNCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRCNCI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG0_ECC_ERROR_INJEC_CODE_CACHE_TAG0_FRCNCI_MASK)
/*! @} */

/*! @name CODE_CACHE_TAG1_ECC_ERROR_INJEC - Code Cache TAG1 ECC Error Injection */
/*! @{ */

#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR1BIT_MASK (0x7FU)
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR1BIT_SHIFT (0U)
/*! CODE_CACHE_TAG1_ERR1BIT - Position of First Bit to Inject ECC Error */
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR1BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR1BIT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR1BIT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR2BIT_MASK (0x7F00U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR2BIT_SHIFT (8U)
/*! CODE_CACHE_TAG1_ERR2BIT - Position of Second Bit to Inject ECC Error */
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR2BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR2BIT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_ERR2BIT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR11BI_MASK (0x10000U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR11BI_SHIFT (16U)
/*! CODE_CACHE_TAG1_FR11BI - Force One 1-Bit Data Inversion on Code Cache TAG1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR11BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR11BI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR11BI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR1NCI_MASK (0x20000U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR1NCI_SHIFT (17U)
/*! CODE_CACHE_TAG1_FR1NCI - Force One Noncorrectable Data Inversion on Code Cache TAG1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR1NCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR1NCI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FR1NCI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRC1BI_MASK (0x40000U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRC1BI_SHIFT (18U)
/*! CODE_CACHE_TAG1_FRC1BI - Force Continuous 1-Bit Data Inversions on Code Cache TAG1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRC1BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRC1BI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRC1BI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRCNCI_MASK (0x80000U)
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRCNCI_SHIFT (19U)
/*! CODE_CACHE_TAG1_FRCNCI - Force Continuous Noncorrectable Data Inversions on Code Cache TAG1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRCNCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRCNCI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_TAG1_ECC_ERROR_INJEC_CODE_CACHE_TAG1_FRCNCI_MASK)
/*! @} */

/*! @name CODE_CACHE_DATA0_ECC_ERROR_INJEC - Code Cache DATA0 ECC Error Injection */
/*! @{ */

#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR1BIT_MASK (0x7FU)
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR1BIT_SHIFT (0U)
/*! CODE_CACHE_DATA0_ERR1BIT - Position of First Bit to Inject ECC Error */
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR1BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR1BIT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR1BIT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR2BIT_MASK (0x7F00U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR2BIT_SHIFT (8U)
/*! CODE_CACHE_DATA0_ERR2BIT - Position of Second Bit to Inject ECC Error */
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR2BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR2BIT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_ERR2BIT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR11BI_MASK (0x10000U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR11BI_SHIFT (16U)
/*! CODE_CACHE_DATA0_FR11BI - Force One 1-Bit Data Inversion on Code Cache DATA0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR11BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR11BI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR11BI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR1NCI_MASK (0x20000U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR1NCI_SHIFT (17U)
/*! CODE_CACHE_DATA0_FR1NCI - Force One Noncorrectable Data Inversion on Code Cache DATA0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR1NCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR1NCI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FR1NCI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRC1BI_MASK (0x40000U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRC1BI_SHIFT (18U)
/*! CODE_CACHE_DATA0_FRC1BI - Force Continuous 1-Bit Data Inversions on Code Cache DATA0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRC1BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRC1BI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRC1BI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRCNCI_MASK (0x80000U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRCNCI_SHIFT (19U)
/*! CODE_CACHE_DATA0_FRCNCI - Force Continuous Noncorrectable Data Inversions on Code Cache DATA0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRCNCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRCNCI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA0_ECC_ERROR_INJEC_CODE_CACHE_DATA0_FRCNCI_MASK)
/*! @} */

/*! @name CODE_CACHE_DATA1_ECC_ERROR_INJEC - Code Cache DATA1 ECC Error Injection */
/*! @{ */

#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR1BIT_MASK (0x7FU)
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR1BIT_SHIFT (0U)
/*! CODE_CACHE_DATA1_ERR1BIT - Position of First Bit to Inject ECC Error */
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR1BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR1BIT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR1BIT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR2BIT_MASK (0x7F00U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR2BIT_SHIFT (8U)
/*! CODE_CACHE_DATA1_ERR2BIT - Position of Second Bit to Inject ECC Error */
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR2BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR2BIT_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_ERR2BIT_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR11BI_MASK (0x10000U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR11BI_SHIFT (16U)
/*! CODE_CACHE_DATA1_FR11BI - Force One 1-Bit Data Inversion on Code Cache DATA1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR11BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR11BI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR11BI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR1NCI_MASK (0x20000U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR1NCI_SHIFT (17U)
/*! CODE_CACHE_DATA1_FR1NCI - Force One Noncorrectable Data Inversion on Code Cache DATA1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR1NCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR1NCI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FR1NCI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRC1BI_MASK (0x40000U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRC1BI_SHIFT (18U)
/*! CODE_CACHE_DATA1_FRC1BI - Force Continuous 1-Bit Data Inversions on Code Cache DATA1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRC1BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRC1BI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRC1BI_MASK)

#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRCNCI_MASK (0x80000U)
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRCNCI_SHIFT (19U)
/*! CODE_CACHE_DATA1_FRCNCI - Force Continuous Noncorrectable Data Inversions on Code Cache DATA1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRCNCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRCNCI_SHIFT)) & CACHE_ECC_MCM_CODE_CACHE_DATA1_ECC_ERROR_INJEC_CODE_CACHE_DATA1_FRCNCI_MASK)
/*! @} */

/*! @name SYTEM_CACHE_TAG0_ECC_ERROR_INJEC - System Cache TAG0 ECC Error Injection */
/*! @{ */

#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR1BIT_MASK (0x7FU)
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR1BIT_SHIFT (0U)
/*! SYSTEM_CACHE_TAG0_ERR1BIT - Position of First Bit to Inject ECC Error */
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR1BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR1BIT_SHIFT)) & CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR1BIT_MASK)

#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR2BIT_MASK (0x7F00U)
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR2BIT_SHIFT (8U)
/*! SYSTEM_CACHE_TAG0_ERR2BIT - Position of Second Bit to Inject ECC Error */
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR2BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR2BIT_SHIFT)) & CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_ERR2BIT_MASK)

#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR11BI_MASK (0x10000U)
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR11BI_SHIFT (16U)
/*! SYSTEM_CACHE_TAG0_FR11BI - Force One 1-Bit Data Inversion on System Cache TAG0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR11BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR11BI_SHIFT)) & CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR11BI_MASK)

#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR1NCI_MASK (0x20000U)
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR1NCI_SHIFT (17U)
/*! SYSTEM_CACHE_TAG0_FR1NCI - Force One Noncorrectable Data Inversion on System Cache TAG0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR1NCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR1NCI_SHIFT)) & CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FR1NCI_MASK)

#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRC1BI_MASK (0x40000U)
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRC1BI_SHIFT (18U)
/*! SYSTEM_CACHE_TAG0_FRC1BI - Force Continuous 1-Bit Data Inversions on System Cache TAG0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRC1BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRC1BI_SHIFT)) & CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRC1BI_MASK)

#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRCNCI_MASK (0x80000U)
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRCNCI_SHIFT (19U)
/*! SYSTEM_CACHE_TAG0_FRCNCI - Force Continuous Noncorrectable Data Inversions on System Cache TAG0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRCNCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRCNCI_SHIFT)) & CACHE_ECC_MCM_SYTEM_CACHE_TAG0_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG0_FRCNCI_MASK)
/*! @} */

/*! @name SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC - System Cache TAG1 ECC Error Injection */
/*! @{ */

#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_ERR1BIT_MASK (0x7FU)
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_ERR1BIT_SHIFT (0U)
/*! SYSTEM_CACHE_TAG1_ERR1BIT - Position of First Bit to Inject ECC Error */
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_ERR1BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_ERR1BIT_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_ERR1BIT_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEMCACHE_TAG1_ERR2BIT_MASK (0x7F00U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEMCACHE_TAG1_ERR2BIT_SHIFT (8U)
/*! SYSTEMCACHE_TAG1_ERR2BIT - Position of Second Bit to Inject ECC Error */
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEMCACHE_TAG1_ERR2BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEMCACHE_TAG1_ERR2BIT_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEMCACHE_TAG1_ERR2BIT_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR11BI_MASK (0x10000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR11BI_SHIFT (16U)
/*! SYSTEM_CACHE_TAG1_FR11BI - Force One 1-Bit Data Inversion on System Cache TAG1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR11BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR11BI_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR11BI_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR1NCI_MASK (0x20000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR1NCI_SHIFT (17U)
/*! SYSTEM_CACHE_TAG1_FR1NCI - Force One Noncorrectable Data Inversion on System Cache TAG1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR1NCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR1NCI_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FR1NCI_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRC1BI_MASK (0x40000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRC1BI_SHIFT (18U)
/*! SYSTEM_CACHE_TAG1_FRC1BI - Force Continuous 1-Bit Data Inversions on System Cache TAG1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRC1BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRC1BI_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRC1BI_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRCNCI_MASK (0x80000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRCNCI_SHIFT (19U)
/*! SYSTEM_CACHE_TAG1_FRCNCI - Force Continuous Noncorrectable Data Inversions on System Cache TAG1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRCNCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRCNCI_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_TAG1_ECC_ERROR_INJEC_SYSTEM_CACHE_TAG1_FRCNCI_MASK)
/*! @} */

/*! @name SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC - System Cache DATA0 ECC Error Injection */
/*! @{ */

#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR1BIT_MASK (0x7FU)
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR1BIT_SHIFT (0U)
/*! SYSTEM_CACHE_DATA0_ERR1BIT - Position of First Bit to Inject ECC Error */
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR1BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR1BIT_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR1BIT_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR2BIT_MASK (0x7F00U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR2BIT_SHIFT (8U)
/*! SYSTEM_CACHE_DATA0_ERR2BIT - Position of Second Bit to Inject ECC Error */
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR2BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR2BIT_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_ERR2BIT_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR11BI_MASK (0x10000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR11BI_SHIFT (16U)
/*! SYSTEM_CACHE_DATA0_FR11BI - Force One 1-Bit Data Inversion on System Cache DATA0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR11BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR11BI_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR11BI_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR1NCI_MASK (0x20000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR1NCI_SHIFT (17U)
/*! SYSTEM_CACHE_DATA0_FR1NCI - Force One Noncorrectable Data Inversion on System Cache DATA0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR1NCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR1NCI_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FR1NCI_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRC1BI_MASK (0x40000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRC1BI_SHIFT (18U)
/*! SYSTEM_CACHE_DATA0_FRC1BI - Force Continuous 1-Bit Data Inversions on System Cache DATA0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRC1BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRC1BI_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRC1BI_MASK)

#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRCNCI_MASK (0x80000U)
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRCNCI_SHIFT (19U)
/*! SYSTEM_CACHE_DATA0_FRCNCI - Force Continuous Noncorrectable Data Inversions on System Cache DATA0 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRCNCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRCNCI_SHIFT)) & CACHE_ECC_MCM_SYSTEM_CACHE_DATA0_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA0_FRCNCI_MASK)
/*! @} */

/*! @name STSTEM_CACHE_DATA1_ECC_ERROR_INJEC - System Cache DATA1 ECC Error Injection */
/*! @{ */

#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR1BIT_MASK (0x7FU)
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR1BIT_SHIFT (0U)
/*! SYSTEM_CACHE_DATA1_ERR1BIT - Position of First Bit to Inject ECC Error */
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR1BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR1BIT_SHIFT)) & CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR1BIT_MASK)

#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR2BIT_MASK (0x7F00U)
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR2BIT_SHIFT (8U)
/*! SYSTEM_CACHE_DATA1_ERR2BIT - Position of Second Bit to Inject ECC Error */
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR2BIT(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR2BIT_SHIFT)) & CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_ERR2BIT_MASK)

#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR11BI_MASK (0x10000U)
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR11BI_SHIFT (16U)
/*! SYSTEM_CACHE_DATA1_FR11BI - Force One 1-Bit Data Inversion on System Cache DATA1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR11BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR11BI_SHIFT)) & CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR11BI_MASK)

#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR1NCI_MASK (0x20000U)
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR1NCI_SHIFT (17U)
/*! SYSTEM_CACHE_DATA1_FR1NCI - Force One Noncorrectable Data Inversion on System Cache DATA1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR1NCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR1NCI_SHIFT)) & CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FR1NCI_MASK)

#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRC1BI_MASK (0x40000U)
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRC1BI_SHIFT (18U)
/*! SYSTEM_CACHE_DATA1_FRC1BI - Force Continuous 1-Bit Data Inversions on System Cache DATA1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRC1BI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRC1BI_SHIFT)) & CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRC1BI_MASK)

#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRCNCI_MASK (0x80000U)
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRCNCI_SHIFT (19U)
/*! SYSTEM_CACHE_DATA1_FRCNCI - Force Continuous Noncorrectable Data Inversions on System Cache DATA1 Write Access
 *  0b0..Disable injection
 *  0b1..Enable injection
 */
#define CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRCNCI(x) (((uint32_t)(((uint32_t)(x)) << CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRCNCI_SHIFT)) & CACHE_ECC_MCM_STSTEM_CACHE_DATA1_ECC_ERROR_INJEC_SYSTEM_CACHE_DATA1_FRCNCI_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE_ECC_MCM_Register_Masks */


/*!
 * @}
 */ /* end of group CACHE_ECC_MCM_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* PERI_CACHE_ECC_MCM_H_ */

