/*
** ###################################################################
**     Processors:          MIMXRT1181CVP2B
**                          MIMXRT1181CVP2C
**                          MIMXRT1181XVP2B
**                          MIMXRT1181XVP2C
**                          MIMXRT1182CVP2B
**                          MIMXRT1182CVP2C
**                          MIMXRT1182XVP2B
**                          MIMXRT1182XVP2C
**                          MIMXRT1186CVJ8C_cm33
**                          MIMXRT1186CVJ8C_cm7
**                          MIMXRT1186XVJ8C_cm33
**                          MIMXRT1186XVJ8C_cm7
**                          MIMXRT1187AVM8B_cm33
**                          MIMXRT1187AVM8B_cm7
**                          MIMXRT1187AVM8C_cm33
**                          MIMXRT1187AVM8C_cm7
**                          MIMXRT1187CVM8B_cm33
**                          MIMXRT1187CVM8B_cm7
**                          MIMXRT1187CVM8C_cm33
**                          MIMXRT1187CVM8C_cm7
**                          MIMXRT1187XVM8B_cm33
**                          MIMXRT1187XVM8B_cm7
**                          MIMXRT1187XVM8C_cm33
**                          MIMXRT1187XVM8C_cm7
**                          MIMXRT1189CVM8B_cm33
**                          MIMXRT1189CVM8B_cm7
**                          MIMXRT1189CVM8C_cm33
**                          MIMXRT1189CVM8C_cm7
**                          MIMXRT1189XVM8B_cm33
**                          MIMXRT1189XVM8B_cm7
**                          MIMXRT1189XVM8C_cm33
**                          MIMXRT1189XVM8C_cm7
**
**     Version:             rev. 2.0, 2024-01-18
**     Build:               b250331
**
**     Abstract:
**         CMSIS Peripheral Access Layer for ENETC_VF_PCI_TYPE0
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2025 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2021-03-09)
**         Initial version.
**     - rev. 2.0 (2024-01-18)
**         Header RFP.
**
** ###################################################################
*/

/*!
 * @file PERI_ENETC_VF_PCI_TYPE0.h
 * @version 2.0
 * @date 2024-01-18
 * @brief CMSIS Peripheral Access Layer for ENETC_VF_PCI_TYPE0
 *
 * CMSIS Peripheral Access Layer for ENETC_VF_PCI_TYPE0
 */

#if !defined(PERI_ENETC_VF_PCI_TYPE0_H_)
#define PERI_ENETC_VF_PCI_TYPE0_H_               /**< Symbol preventing repeated inclusion */

#if (defined(CPU_MIMXRT1181CVP2B) || defined(CPU_MIMXRT1181CVP2C) || defined(CPU_MIMXRT1181XVP2B) || defined(CPU_MIMXRT1181XVP2C))
#include "MIMXRT1181_COMMON.h"
#elif (defined(CPU_MIMXRT1182CVP2B) || defined(CPU_MIMXRT1182CVP2C) || defined(CPU_MIMXRT1182XVP2B) || defined(CPU_MIMXRT1182XVP2C))
#include "MIMXRT1182_COMMON.h"
#elif (defined(CPU_MIMXRT1186CVJ8C_cm33) || defined(CPU_MIMXRT1186XVJ8C_cm33))
#include "MIMXRT1186_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1186CVJ8C_cm7) || defined(CPU_MIMXRT1186XVJ8C_cm7))
#include "MIMXRT1186_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT1187AVM8B_cm33) || defined(CPU_MIMXRT1187AVM8C_cm33) || defined(CPU_MIMXRT1187CVM8B_cm33) || defined(CPU_MIMXRT1187CVM8C_cm33) || defined(CPU_MIMXRT1187XVM8B_cm33) || defined(CPU_MIMXRT1187XVM8C_cm33))
#include "MIMXRT1187_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1187AVM8B_cm7) || defined(CPU_MIMXRT1187AVM8C_cm7) || defined(CPU_MIMXRT1187CVM8B_cm7) || defined(CPU_MIMXRT1187CVM8C_cm7) || defined(CPU_MIMXRT1187XVM8B_cm7) || defined(CPU_MIMXRT1187XVM8C_cm7))
#include "MIMXRT1187_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT1189CVM8B_cm33) || defined(CPU_MIMXRT1189CVM8C_cm33) || defined(CPU_MIMXRT1189XVM8B_cm33) || defined(CPU_MIMXRT1189XVM8C_cm33))
#include "MIMXRT1189_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT1189CVM8B_cm7) || defined(CPU_MIMXRT1189CVM8C_cm7) || defined(CPU_MIMXRT1189XVM8B_cm7) || defined(CPU_MIMXRT1189XVM8C_cm7))
#include "MIMXRT1189_cm7_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ENETC_VF_PCI_TYPE0 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENETC_VF_PCI_TYPE0_Peripheral_Access_Layer ENETC_VF_PCI_TYPE0 Peripheral Access Layer
 * @{
 */

/** ENETC_VF_PCI_TYPE0 - Register Layout Typedef */
typedef struct {
  __I  uint32_t PCI_CFH_DID_VID;                   /**< PCI device ID and vendor ID register, offset: 0x0 */
  __IO uint16_t PCI_CFH_CMD;                       /**< PCI command register, offset: 0x4 */
  __I  uint16_t PCI_CFH_STAT;                      /**< PCI status register, offset: 0x6 */
  __I  uint32_t PCI_CFH_REVID_CLASSCODE;           /**< PCI revision ID and classcode register, offset: 0x8 */
       uint8_t PCI_CFH_CL_SIZE;                    /**< PCI cache line size register, offset: 0xC */
       uint8_t PCI_CFH_LAT_TIMER;                  /**< PCI latency timer register, offset: 0xD */
  __I  uint8_t PCI_CFH_HDR_TYPE;                   /**< PCI header type register, offset: 0xE */
       uint8_t PCI_CFH_BIST;                       /**< PCI BIST register, offset: 0xF */
  __I  uint32_t PCI_CFH_BAR0;                      /**< PCI base address register 0, offset: 0x10 */
  __I  uint32_t PCI_CFH_BAR1;                      /**< PCI base address register 1, offset: 0x14 */
  __I  uint32_t PCI_CFH_BAR2;                      /**< PCI base address register 2, offset: 0x18 */
  __I  uint32_t PCI_CFH_BAR3;                      /**< PCI base address register 3, offset: 0x1C */
  __I  uint32_t PCI_CFH_BAR4;                      /**< PCI base address register 4, offset: 0x20 */
  __I  uint32_t PCI_CFH_BAR5;                      /**< PCI base address register 5, offset: 0x24 */
  __I  uint32_t PCI_CFH_CARDBUS_CIS;               /**< PCI cardbus CIS register, offset: 0x28 */
  __I  uint16_t PCI_CFH_SUBSYS_VID;                /**< PCI subsystem vendor ID register, offset: 0x2C */
  __I  uint16_t PCI_CFH_SUBSYS_ID;                 /**< PCI subsystem ID register, offset: 0x2E */
  __I  uint32_t PCI_CFH_EXP_ROM_BA;                /**< PCI expansion ROM base address register, offset: 0x30 */
  __I  uint8_t PCI_CFH_CAP_PTR;                    /**< PCI capabilities pointer register, offset: 0x34 */
       uint8_t RESERVED_0[11];
  __I  uint16_t PCI_CFC_PCIE_CAP_LIST;             /**< PCI PCIe capabilities list register, offset: 0x40 */
  __I  uint16_t PCI_CFC_PCIE_CAP;                  /**< PCI PCIe capabilities register, offset: 0x42 */
  __I  uint32_t PCI_CFC_PCIE_DEV_CAP;              /**< PCI PCIe device capabilities register, offset: 0x44 */
  __IO uint16_t PCI_CFC_PCIE_DEV_CTL;              /**< PCI PCIe device control register, offset: 0x48 */
  __I  uint16_t PCI_CFC_PCIE_DEV_STAT;             /**< PCI PCIe device status register, offset: 0x4A */
       uint8_t RESERVED_1[24];
  __I  uint32_t PCI_CFC_PCIE_DEV_CAP2;             /**< PCI PCIe device capabilities 2 register, offset: 0x64 */
  __I  uint16_t PCI_CFC_PCIE_DEV_CTL2;             /**< PCI PCIe device control 2 register, offset: 0x68 */
       uint8_t RESERVED_2[22];
  __I  uint16_t PCI_CFC_MSIX_CAP_LIST;             /**< PCI MSI-X capabilities list register, offset: 0x80 */
  __IO uint16_t PCI_CFC_MSIX_MSG_CTL;              /**< PCI MSI-X message control register, offset: 0x82 */
  __I  uint32_t PCI_CFC_MSIX_TABLE_OFF_BIR;        /**< PCI MSI-X table offset/BIR register, offset: 0x84 */
  __I  uint32_t PCI_CFC_MSIX_PBA_OFF_BIR;          /**< PCI MSI-X PBA offset/BIR register, offset: 0x88 */
       uint8_t RESERVED_3[116];
  __I  uint32_t PCIE_CFC_AER_EXT_CAP_HDR;          /**< PCIe AER extended capability header, offset: 0x100 */
  __IO uint32_t PCIE_CFC_AER_UCORR_ERR_STAT;       /**< PCIe AER uncorrectable error status register, offset: 0x104 */
  __IO uint32_t PCIE_CFC_AER_UCORR_ERR_MASK;       /**< PCIe AER uncorrectable error mask register, offset: 0x108 */
  __IO uint32_t PCIE_CFC_AER_UCORR_ERR_SEV;        /**< PCIe AER uncorrectable error severity register, offset: 0x10C */
  __IO uint32_t PCIE_CFC_AER_CORR_ERR_STAT;        /**< PCIe AER correctable error status register, offset: 0x110 */
  __IO uint32_t PCIE_CFC_AER_CORR_ERR_MASK;        /**< PCIe AER correctable error mask register, offset: 0x114 */
  __I  uint32_t PCIE_CFC_AER_CAP_CTL;              /**< PCIe AER capabilities and control register, offset: 0x118 */
       uint8_t RESERVED_4[20];
  __I  uint32_t PCIE_CFC_ACS_CAP_HDR;              /**< PCIe ACS capability header, offset: 0x130 */
  __I  uint16_t PCIE_CFC_ACS_CAP;                  /**< PCIe ACS capability register, offset: 0x134 */
  __I  uint16_t PCIE_CFC_ACS_CTL;                  /**< PCIe ACS control register, offset: 0x136 */
       uint8_t RESERVED_5[8];
  __I  uint32_t PCIE_CFC_RTR_CAP_HDR;              /**< PCIe readiness time reporting capability header, offset: 0x140 */
  __I  uint32_t PCIE_CFC_RTR_RTR1;                 /**< PCIe RTR readiness time reporting 1 register, offset: 0x144 */
  __I  uint32_t PCIE_CFC_RTR_RTR2;                 /**< PCIe RTR readiness time reporting 2 register, offset: 0x148 */
} ENETC_VF_PCI_TYPE0_Type;

/* ----------------------------------------------------------------------------
   -- ENETC_VF_PCI_TYPE0 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENETC_VF_PCI_TYPE0_Register_Masks ENETC_VF_PCI_TYPE0 Register Masks
 * @{
 */

/*! @name PCI_CFH_DID_VID - PCI device ID and vendor ID register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_VENDOR_ID_MASK (0xFFFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_VENDOR_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_VENDOR_ID(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_VENDOR_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_VENDOR_ID_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_DEVICE_ID_MASK (0xFFFF0000U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_DEVICE_ID_SHIFT (16U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_DEVICE_ID(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_DEVICE_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_DID_VID_DEVICE_ID_MASK)
/*! @} */

/*! @name PCI_CFH_CMD - PCI command register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_CMD_BUS_MASTER_EN_MASK (0x4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_CMD_BUS_MASTER_EN_SHIFT (2U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_CMD_BUS_MASTER_EN(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_CMD_BUS_MASTER_EN_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_CMD_BUS_MASTER_EN_MASK)
/*! @} */

/*! @name PCI_CFH_STAT - PCI status register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_STAT_CAP_LIST_MASK (0x10U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_STAT_CAP_LIST_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_STAT_CAP_LIST(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_STAT_CAP_LIST_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_STAT_CAP_LIST_MASK)
/*! @} */

/*! @name PCI_CFH_REVID_CLASSCODE - PCI revision ID and classcode register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_REV_ID_MASK (0xFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_REV_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_REV_ID(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_REV_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_REV_ID_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_CLASS_CODE_MASK (0xFFFFFF00U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_CLASS_CODE_SHIFT (8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_CLASS_CODE(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_CLASS_CODE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_REVID_CLASSCODE_CLASS_CODE_MASK)
/*! @} */

/*! @name PCI_CFH_CL_SIZE - PCI cache line size register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_CL_SIZE_CACHE_LINE_SIZE_MASK (0xFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_CL_SIZE_CACHE_LINE_SIZE_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_CL_SIZE_CACHE_LINE_SIZE(x) (((uint8_t)(((uint8_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_CL_SIZE_CACHE_LINE_SIZE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_CL_SIZE_CACHE_LINE_SIZE_MASK)
/*! @} */

/*! @name PCI_CFH_LAT_TIMER - PCI latency timer register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_LAT_TIMER_LATENCY_TIMER_MASK (0xFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_LAT_TIMER_LATENCY_TIMER_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_LAT_TIMER_LATENCY_TIMER(x) (((uint8_t)(((uint8_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_LAT_TIMER_LATENCY_TIMER_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_LAT_TIMER_LATENCY_TIMER_MASK)
/*! @} */

/*! @name PCI_CFH_HDR_TYPE - PCI header type register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_HDR_TYPE_MASK (0x7FU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_HDR_TYPE_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_HDR_TYPE(x) (((uint8_t)(((uint8_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_HDR_TYPE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_HDR_TYPE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_MULT_FUNC_DEV_MASK (0x80U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_MULT_FUNC_DEV_SHIFT (7U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_MULT_FUNC_DEV(x) (((uint8_t)(((uint8_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_MULT_FUNC_DEV_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_HDR_TYPE_MULT_FUNC_DEV_MASK)
/*! @} */

/*! @name PCI_CFH_BIST - PCI BIST register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BIST_BIST_MASK (0xFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BIST_BIST_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BIST_BIST(x)  (((uint8_t)(((uint8_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BIST_BIST_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BIST_BIST_MASK)
/*! @} */

/*! @name PCI_CFH_BAR0 - PCI base address register 0 */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_IO_IND_MASK (0x1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_IO_IND_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_IO_IND(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_IO_IND_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_IO_IND_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_TYPE_MASK (0x6U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_TYPE_SHIFT (1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_TYPE(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_TYPE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_MEM_TYPE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_PF_MEM_MASK (0x8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_PF_MEM_SHIFT (3U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_PF_MEM(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_PF_MEM_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_PF_MEM_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_ADDR_MASK (0xFFFFFFF0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_ADDR_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_ADDR(x)  (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_ADDR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR0_ADDR_MASK)
/*! @} */

/*! @name PCI_CFH_BAR1 - PCI base address register 1 */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_IO_IND_MASK (0x1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_IO_IND_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_IO_IND(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_IO_IND_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_IO_IND_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_TYPE_MASK (0x6U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_TYPE_SHIFT (1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_TYPE(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_TYPE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_MEM_TYPE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_PF_MEM_MASK (0x8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_PF_MEM_SHIFT (3U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_PF_MEM(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_PF_MEM_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_PF_MEM_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_ADDR_MASK (0xFFFFFFF0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_ADDR_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_ADDR(x)  (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_ADDR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR1_ADDR_MASK)
/*! @} */

/*! @name PCI_CFH_BAR2 - PCI base address register 2 */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_IO_IND_MASK (0x1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_IO_IND_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_IO_IND(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_IO_IND_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_IO_IND_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_TYPE_MASK (0x6U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_TYPE_SHIFT (1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_TYPE(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_TYPE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_MEM_TYPE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_PF_MEM_MASK (0x8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_PF_MEM_SHIFT (3U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_PF_MEM(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_PF_MEM_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_PF_MEM_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_ADDR_MASK (0xFFFFFFF0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_ADDR_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_ADDR(x)  (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_ADDR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR2_ADDR_MASK)
/*! @} */

/*! @name PCI_CFH_BAR3 - PCI base address register 3 */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_IO_IND_MASK (0x1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_IO_IND_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_IO_IND(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_IO_IND_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_IO_IND_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_TYPE_MASK (0x6U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_TYPE_SHIFT (1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_TYPE(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_TYPE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_MEM_TYPE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_PF_MEM_MASK (0x8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_PF_MEM_SHIFT (3U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_PF_MEM(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_PF_MEM_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_PF_MEM_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_ADDR_MASK (0xFFFFFFF0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_ADDR_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_ADDR(x)  (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_ADDR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR3_ADDR_MASK)
/*! @} */

/*! @name PCI_CFH_BAR4 - PCI base address register 4 */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_IO_IND_MASK (0x1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_IO_IND_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_IO_IND(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_IO_IND_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_IO_IND_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_TYPE_MASK (0x6U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_TYPE_SHIFT (1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_TYPE(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_TYPE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_MEM_TYPE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_PF_MEM_MASK (0x8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_PF_MEM_SHIFT (3U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_PF_MEM(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_PF_MEM_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_PF_MEM_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_ADDR_MASK (0xFFFFFFF0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_ADDR_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_ADDR(x)  (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_ADDR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR4_ADDR_MASK)
/*! @} */

/*! @name PCI_CFH_BAR5 - PCI base address register 5 */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_IO_IND_MASK (0x1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_IO_IND_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_IO_IND(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_IO_IND_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_IO_IND_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_TYPE_MASK (0x6U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_TYPE_SHIFT (1U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_TYPE(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_TYPE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_MEM_TYPE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_PF_MEM_MASK (0x8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_PF_MEM_SHIFT (3U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_PF_MEM(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_PF_MEM_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_PF_MEM_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_ADDR_MASK (0xFFFFFFF0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_ADDR_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_ADDR(x)  (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_ADDR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_BAR5_ADDR_MASK)
/*! @} */

/*! @name PCI_CFH_CARDBUS_CIS - PCI cardbus CIS register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_CARDBUS_CIS_CARDBUS_CIS_PTR_MASK (0xFFFFFFFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_CARDBUS_CIS_CARDBUS_CIS_PTR_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_CARDBUS_CIS_CARDBUS_CIS_PTR(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_CARDBUS_CIS_CARDBUS_CIS_PTR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_CARDBUS_CIS_CARDBUS_CIS_PTR_MASK)
/*! @} */

/*! @name PCI_CFH_SUBSYS_VID - PCI subsystem vendor ID register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_VID_SYBSYSTEM_VENDOR_ID_MASK (0xFFFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_VID_SYBSYSTEM_VENDOR_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_VID_SYBSYSTEM_VENDOR_ID(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_VID_SYBSYSTEM_VENDOR_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_VID_SYBSYSTEM_VENDOR_ID_MASK)
/*! @} */

/*! @name PCI_CFH_SUBSYS_ID - PCI subsystem ID register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_ID_SYBSYSTEM_ID_MASK (0xFFFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_ID_SYBSYSTEM_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_ID_SYBSYSTEM_ID(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_ID_SYBSYSTEM_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_SUBSYS_ID_SYBSYSTEM_ID_MASK)
/*! @} */

/*! @name PCI_CFH_EXP_ROM_BA - PCI expansion ROM base address register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_EXP_ROM_BA_EXP_ROM_BA_MASK (0xFFFFFFFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_EXP_ROM_BA_EXP_ROM_BA_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_EXP_ROM_BA_EXP_ROM_BA(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_EXP_ROM_BA_EXP_ROM_BA_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_EXP_ROM_BA_EXP_ROM_BA_MASK)
/*! @} */

/*! @name PCI_CFH_CAP_PTR - PCI capabilities pointer register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFH_CAP_PTR_CAP_PTR_MASK (0xFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_CAP_PTR_CAP_PTR_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFH_CAP_PTR_CAP_PTR(x) (((uint8_t)(((uint8_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFH_CAP_PTR_CAP_PTR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFH_CAP_PTR_CAP_PTR_MASK)
/*! @} */

/*! @name PCI_CFC_PCIE_CAP_LIST - PCI PCIe capabilities list register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_CAP_ID_MASK (0xFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_CAP_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_CAP_ID(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_CAP_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_CAP_ID_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_NEXT_CAP_PTR_MASK (0xFF00U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_NEXT_CAP_PTR_SHIFT (8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_NEXT_CAP_PTR(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_NEXT_CAP_PTR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_LIST_NEXT_CAP_PTR_MASK)
/*! @} */

/*! @name PCI_CFC_PCIE_CAP - PCI PCIe capabilities register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_CAP_VER_MASK (0xFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_CAP_VER_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_CAP_VER(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_CAP_VER_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_CAP_VER_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_DEV_PORT_TYPE_MASK (0xF0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_DEV_PORT_TYPE_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_DEV_PORT_TYPE(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_DEV_PORT_TYPE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_DEV_PORT_TYPE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_INT_MSG_NUM_MASK (0x3E00U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_INT_MSG_NUM_SHIFT (9U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_INT_MSG_NUM(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_INT_MSG_NUM_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_CAP_INT_MSG_NUM_MASK)
/*! @} */

/*! @name PCI_CFC_PCIE_DEV_CAP - PCI PCIe device capabilities register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP_FLR_CAP_MASK (0x10000000U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP_FLR_CAP_SHIFT (28U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP_FLR_CAP(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP_FLR_CAP_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP_FLR_CAP_MASK)
/*! @} */

/*! @name PCI_CFC_PCIE_DEV_CTL - PCI PCIe device control register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL_INIT_FLR_MASK (0x8000U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL_INIT_FLR_SHIFT (15U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL_INIT_FLR(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL_INIT_FLR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL_INIT_FLR_MASK)
/*! @} */

/*! @name PCI_CFC_PCIE_DEV_STAT - PCI PCIe device status register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_STAT_TRANS_PEND_MASK (0x20U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_STAT_TRANS_PEND_SHIFT (5U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_STAT_TRANS_PEND(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_STAT_TRANS_PEND_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_STAT_TRANS_PEND_MASK)
/*! @} */

/*! @name PCI_CFC_PCIE_DEV_CAP2 - PCI PCIe device capabilities 2 register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_RNG_SUPP_MASK (0xFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_RNG_SUPP_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_RNG_SUPP(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_RNG_SUPP_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_RNG_SUPP_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_DIS_SUPP_MASK (0x10U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_DIS_SUPP_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_DIS_SUPP(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_DIS_SUPP_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CAP2_CMPL_TO_DIS_SUPP_MASK)
/*! @} */

/*! @name PCI_CFC_PCIE_DEV_CTL2 - PCI PCIe device control 2 register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_VALUE_MASK (0xFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_VALUE_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_VALUE(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_VALUE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_VALUE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_EN_MASK (0x10U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_EN_SHIFT (4U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_EN(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_EN_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_PCIE_DEV_CTL2_CMPL_TO_EN_MASK)
/*! @} */

/*! @name PCI_CFC_MSIX_CAP_LIST - PCI MSI-X capabilities list register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_CAP_ID_MASK (0xFFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_CAP_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_CAP_ID(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_CAP_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_CAP_ID_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_NEXT_CAP_PTR_MASK (0xFF00U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_NEXT_CAP_PTR_SHIFT (8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_NEXT_CAP_PTR(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_NEXT_CAP_PTR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_CAP_LIST_NEXT_CAP_PTR_MASK)
/*! @} */

/*! @name PCI_CFC_MSIX_MSG_CTL - PCI MSI-X message control register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_TABLE_SIZE_MASK (0x7FFU)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_TABLE_SIZE_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_TABLE_SIZE(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_TABLE_SIZE_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_TABLE_SIZE_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_FUNC_MASK_MASK (0x4000U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_FUNC_MASK_SHIFT (14U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_FUNC_MASK(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_FUNC_MASK_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_FUNC_MASK_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_MSIX_EN_MASK (0x8000U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_MSIX_EN_SHIFT (15U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_MSIX_EN(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_MSIX_EN_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_MSG_CTL_MSIX_EN_MASK)
/*! @} */

/*! @name PCI_CFC_MSIX_TABLE_OFF_BIR - PCI MSI-X table offset/BIR register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_BIR_MASK (0x7U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_BIR_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_BIR(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_BIR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_BIR_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_OFFSET_MASK (0xFFFFFFF8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_OFFSET_SHIFT (3U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_OFFSET(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_OFFSET_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_TABLE_OFF_BIR_TABLE_OFFSET_MASK)
/*! @} */

/*! @name PCI_CFC_MSIX_PBA_OFF_BIR - PCI MSI-X PBA offset/BIR register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_BIR_MASK (0x7U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_BIR_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_BIR(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_BIR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_BIR_MASK)

#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_OFFSET_MASK (0xFFFFFFF8U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_OFFSET_SHIFT (3U)
#define ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_OFFSET(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_OFFSET_SHIFT)) & ENETC_VF_PCI_TYPE0_PCI_CFC_MSIX_PBA_OFF_BIR_PBA_OFFSET_MASK)
/*! @} */

/*! @name PCIE_CFC_AER_EXT_CAP_HDR - PCIe AER extended capability header */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_PCIE_EXT_CAP_ID_MASK (0xFFFFU)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_PCIE_EXT_CAP_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_PCIE_EXT_CAP_ID(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_PCIE_EXT_CAP_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_PCIE_EXT_CAP_ID_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_CAP_VER_MASK (0xF0000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_CAP_VER_SHIFT (16U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_CAP_VER(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_CAP_VER_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_CAP_VER_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_NEXT_CAP_OFF_MASK (0xFFF00000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_NEXT_CAP_OFF_SHIFT (20U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_NEXT_CAP_OFF(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_NEXT_CAP_OFF_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_EXT_CAP_HDR_NEXT_CAP_OFF_MASK)
/*! @} */

/*! @name PCIE_CFC_AER_UCORR_ERR_STAT - PCIe AER uncorrectable error status register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_STAT_UCORR_INT_ERR_MASK (0x400000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_STAT_UCORR_INT_ERR_SHIFT (22U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_STAT_UCORR_INT_ERR(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_STAT_UCORR_INT_ERR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_STAT_UCORR_INT_ERR_MASK)
/*! @} */

/*! @name PCIE_CFC_AER_UCORR_ERR_MASK - PCIe AER uncorrectable error mask register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_MASK_UCORR_INT_ERR_MASK_MASK (0x400000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_MASK_UCORR_INT_ERR_MASK_SHIFT (22U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_MASK_UCORR_INT_ERR_MASK(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_MASK_UCORR_INT_ERR_MASK_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_MASK_UCORR_INT_ERR_MASK_MASK)
/*! @} */

/*! @name PCIE_CFC_AER_UCORR_ERR_SEV - PCIe AER uncorrectable error severity register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_SEV_UCORR_INT_SEV_MASK (0x400000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_SEV_UCORR_INT_SEV_SHIFT (22U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_SEV_UCORR_INT_SEV(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_SEV_UCORR_INT_SEV_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_UCORR_ERR_SEV_UCORR_INT_SEV_MASK)
/*! @} */

/*! @name PCIE_CFC_AER_CORR_ERR_STAT - PCIe AER correctable error status register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_STAT_CORR_INT_ERR_MASK (0x4000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_STAT_CORR_INT_ERR_SHIFT (14U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_STAT_CORR_INT_ERR(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_STAT_CORR_INT_ERR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_STAT_CORR_INT_ERR_MASK)
/*! @} */

/*! @name PCIE_CFC_AER_CORR_ERR_MASK - PCIe AER correctable error mask register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_MASK_CORR_INT_MASK_MASK (0x4000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_MASK_CORR_INT_MASK_SHIFT (14U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_MASK_CORR_INT_MASK(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_MASK_CORR_INT_MASK_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CORR_ERR_MASK_CORR_INT_MASK_MASK)
/*! @} */

/*! @name PCIE_CFC_AER_CAP_CTL - PCIe AER capabilities and control register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CAP_CTL_FIRST_ERR_PTR_MASK (0x1FU)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CAP_CTL_FIRST_ERR_PTR_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CAP_CTL_FIRST_ERR_PTR(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CAP_CTL_FIRST_ERR_PTR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_AER_CAP_CTL_FIRST_ERR_PTR_MASK)
/*! @} */

/*! @name PCIE_CFC_ACS_CAP_HDR - PCIe ACS capability header */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_PCIE_EXT_CAP_ID_MASK (0xFFFFU)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_PCIE_EXT_CAP_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_PCIE_EXT_CAP_ID(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_PCIE_EXT_CAP_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_PCIE_EXT_CAP_ID_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_CAP_VER_MASK (0xF0000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_CAP_VER_SHIFT (16U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_CAP_VER(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_CAP_VER_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_CAP_VER_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_NEXT_CAP_OFF_MASK (0xFFF00000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_NEXT_CAP_OFF_SHIFT (20U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_NEXT_CAP_OFF(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_NEXT_CAP_OFF_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_HDR_NEXT_CAP_OFF_MASK)
/*! @} */

/*! @name PCIE_CFC_ACS_CAP - PCIe ACS capability register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_TRANS_BLOCK_MASK (0x2U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_TRANS_BLOCK_SHIFT (1U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_TRANS_BLOCK(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_TRANS_BLOCK_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_TRANS_BLOCK_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_P2P_REQ_REDIR_MASK (0x4U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_P2P_REQ_REDIR_SHIFT (2U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_P2P_REQ_REDIR(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_P2P_REQ_REDIR_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_P2P_REQ_REDIR_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_DIR_TRANS_P2P_MASK (0x40U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_DIR_TRANS_P2P_SHIFT (6U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_DIR_TRANS_P2P(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_DIR_TRANS_P2P_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CAP_ACS_DIR_TRANS_P2P_MASK)
/*! @} */

/*! @name PCIE_CFC_ACS_CTL - PCIe ACS control register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_TRANS_BLOCK_EN_MASK (0x2U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_TRANS_BLOCK_EN_SHIFT (1U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_TRANS_BLOCK_EN(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_TRANS_BLOCK_EN_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_TRANS_BLOCK_EN_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_P2P_REQ_REDIR_EN_MASK (0x4U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_P2P_REQ_REDIR_EN_SHIFT (2U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_P2P_REQ_REDIR_EN(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_P2P_REQ_REDIR_EN_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_P2P_REQ_REDIR_EN_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_DIR_TRANS_P2P_EN_MASK (0x40U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_DIR_TRANS_P2P_EN_SHIFT (6U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_DIR_TRANS_P2P_EN(x) (((uint16_t)(((uint16_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_DIR_TRANS_P2P_EN_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_ACS_CTL_ACS_DIR_TRANS_P2P_EN_MASK)
/*! @} */

/*! @name PCIE_CFC_RTR_CAP_HDR - PCIe readiness time reporting capability header */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_PCIE_EXT_CAP_ID_MASK (0xFFFFU)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_PCIE_EXT_CAP_ID_SHIFT (0U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_PCIE_EXT_CAP_ID(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_PCIE_EXT_CAP_ID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_PCIE_EXT_CAP_ID_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_CAP_VER_MASK (0xF0000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_CAP_VER_SHIFT (16U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_CAP_VER(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_CAP_VER_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_CAP_VER_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_NEXT_CAP_OFF_MASK (0xFFF00000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_NEXT_CAP_OFF_SHIFT (20U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_NEXT_CAP_OFF(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_NEXT_CAP_OFF_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_CAP_HDR_NEXT_CAP_OFF_MASK)
/*! @} */

/*! @name PCIE_CFC_RTR_RTR1 - PCIe RTR readiness time reporting 1 register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_RESET_TIME_MASK (0xFFFU)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_RESET_TIME_SHIFT (0U)
/*! RESET_TIME - Reset Time */
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_RESET_TIME(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_RESET_TIME_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_RESET_TIME_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_VALID_MASK (0x80000000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_VALID_SHIFT (31U)
/*! VALID - Valid */
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_VALID(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_VALID_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR1_VALID_MASK)
/*! @} */

/*! @name PCIE_CFC_RTR_RTR2 - PCIe RTR readiness time reporting 2 register */
/*! @{ */

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_FLR_TIME_MASK (0xFFFU)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_FLR_TIME_SHIFT (0U)
/*! FLR_TIME - FLR Time */
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_FLR_TIME(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_FLR_TIME_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_FLR_TIME_MASK)

#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_D3HOT_D0_TIME_MASK (0xFFF000U)
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_D3HOT_D0_TIME_SHIFT (12U)
/*! D3HOT_D0_TIME - D3 hot to D0 time */
#define ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_D3HOT_D0_TIME(x) (((uint32_t)(((uint32_t)(x)) << ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_D3HOT_D0_TIME_SHIFT)) & ENETC_VF_PCI_TYPE0_PCIE_CFC_RTR_RTR2_D3HOT_D0_TIME_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ENETC_VF_PCI_TYPE0_Register_Masks */


/*!
 * @}
 */ /* end of group ENETC_VF_PCI_TYPE0_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* PERI_ENETC_VF_PCI_TYPE0_H_ */

