# NXP Application Code Hub
[<img src="https://mcuxpresso.nxp.com/static/icon/nxp-logo-color.svg" width="100"/>](https://www.nxp.com)

## AN14908 how to implement 8K USB keyboard on MCXN236

This application note describes how to implement 8K USB keyboard on MCXN236. The system block diagram of the 8K USB keyboard implemented in this application note is shown below.
 
   ![block_diagram](images/block_diagram.png)

The following features are supported by this solution:
- Supports 8K USB HID report rate
- SmartDMA performs keyboard scanning
- Debouncing keys via software
- Using LPSPI to control WS2812 LED array, supporting 4 lighting effects

For implementation details, please refer to the AN14908 documentation.

#### Boards: FRDM-MCXN236
#### Categories: HMI
#### Peripherals: SPI, SmartDMA, USB
#### Toolchains: MCUXpresso IDE

## Table of Contents
1. [Software](#step1)
2. [Hardware](#step2)
3. [Setup](#step3)
4. [Results](#step4)
5. [FAQs](#step5) 
6. [Support](#step6)
7. [Release Notes](#step7)

## 1. Software<a name="step1"></a>
- [MCUXpresso IDE v24.12 [Build 148] [2025-01-10] or later](https://www.nxp.com/design/software/development-software/mcuxpresso-software-and-tools-/mcuxpresso-integrated-development-environment-ide:MCUXpresso-IDE)
- [SDK_25_06_00_FRDM-MCXN236](https://mcuxpresso.nxp.com/en/welcome)
- MCUXpresso for Visual Studio Code: This example supports MCUXpresso for Visual Studio Code, for more information about how to use Visual Studio Code please refer [here](https://www.nxp.com/design/training/getting-started-with-mcuxpresso-for-visual-studio-code:TIP-GETTING-STARTED-WITH-MCUXPRESSO-FOR-VS-CODE).
- Optional KiCAD 8.0

## 2. Hardware<a name="step2"></a>
- FRDM-MCXN236 board
- ESP-Keyboard
- keyboard adapter board
- Two Type-C USB cables.
- One 0.5mm FPC 30-pin connector cable

## 3. Setup<a name="step3"></a>

The keyboard adapter board is required to connect the ESP-Keyboard to the FRDM-MCXN236 board. The adapter board converts the FPC connector interface to Arduino interface.
The connection between FRDM-MCXN236 and ESP-Keyboard through the adapter board is as shown below.

  ![board_connection](images/board_connection.jpg)

### 3.1 Build Hardware

#### 3.1.1 Build ESP-Keyboard

ESP-Keyboard is an open-source custom keyboard based on the ESP32S3. It adopts a standard keyboard matrix layout, supports a 6x15 matrix of keys, and provides an 0.5mm FPC 30-pin connector to bring out the row and column interfaces of the key matrix for easy connection to the MCU main control board. This application note only uses the keyboard and does not use the ESP32-S3 main control board.
The FPC30 pin interface on the ESP-Keyboard is shown below.
 
  ![FPC_connecotr](images/FPC_connector.png)

The partial schematic of ESP-Keyboard is shown in below.

  ![schematic](images/ESP_keyboard_schematic.png)

This solution is open source on [GitHub](https://github.com/espressif/esp-iot-solution/tree/master/examples/keyboard). Therefore, you need to first build an ESP-Keyboard using open-source schematics and PCB files. For easier testing, you also need to install key switches and keycaps. 

ESP-Keyboard is shown below.

  ![ESP_keyboard](images/ESP_keyboard.jpg)


#### 3.1.2 Build keyboard adapter board

Since the FRDM-MCXN236 board does not have an FPC 30-pin connector, an adapter board is needed to connect the FRDM-MCXN236 board and the ESP-Keyboard. Therefore, I designed an keyboard adapter board to connect the FRDM-MCXN236 board and the ESP-Keyboard. It connects 22 GPIOs from the Arduino interface to the FPC 30-pin connector, including 21 GPIOs (6+15) and one LPSPI_SDO pin. The 21 GPIOs are used to control the 15 column signals and 6 row signals of the key matrix, and the LPSPI_SDO is used to control the WS2812 LED array. The schematic diagram of the board is shown below. 

  ![adapter_board_sch](images/adapter_board_sch.png)

You can find the schematic, PCB file and gerber files in hardware folder, they are developed using KiCAD 8.0, you can use the gerber to build the keyboard adapter board.

### 3.2 Hardware connection

After building the ESP-Keyboard and the keyboard adapter board, follow these steps to connect the hardware:
- Install the adapter board onto the Arduino interface (J1-J4) of the FRDM-MCXN236.
- Using 0.5mm FPC 30-pin cable to connect the FPC connector on the ESP-Keyboard to the FPC connector on the keyboard adapter board.
- Using one Type-C cable to connect the J10 (USB) port of the FRDM-MCXN236 board to a PC for firmware download.
- Using another Type-C cable to connect the J11 (USB) port of the FRDM-MCXN236 board to a PC for USB HID keyboard communication.

### 3.3 Software test

The software test steps are as follows:
- Import the example code into the MCUXpresso IDE or MCUXpresso VS code.
- Then compile the project.
- Download the compiled code to the FRDM-MCXN236 board using the onboard debugger.
- Pressing the reset button (SW1) on the FRDM-MCXN236 board to run the code.
- Press Fn+Home to turn the lighting effect on or off. 
- Press Fn+Page Up/Down to switch between 4 lighting effects.
- Open any text editor and press the number and letter keys on the keyboard to test the key functions.



## 4. Results<a name="step4"></a>

When you press Fn+Home, you'll see the lighting effects turn on and off.
When you press Fn+Page Up/Page Down, you'll see the lighting effects cycle through 4 different effects.
When you open a text editor and press a number or character key on the ESP-keyboard, the text editor will display the content of the currently pressed key.


## 5. FAQs<a name="step5"></a>


## 6. Support<a name="step6"></a>


#### Project Metadata

<!----- Boards ----->
[![Board badge](https://img.shields.io/badge/Board-FRDM&ndash;MCXN236-blue)]()

<!----- Categories ----->
[![Category badge](https://img.shields.io/badge/Category-HMI-yellowgreen)](https://mcuxpresso.nxp.com/appcodehub?category=hmi)

<!----- Peripherals ----->
[![Peripheral badge](https://img.shields.io/badge/Peripheral-SPI-yellow)](https://mcuxpresso.nxp.com/appcodehub?peripheral=spi)
[![Peripheral badge](https://img.shields.io/badge/Peripheral-SMARTDMA-yellow)](https://mcuxpresso.nxp.com/appcodehub?peripheral=smartdma)
[![Peripheral badge](https://img.shields.io/badge/Peripheral-USB-yellow)](https://mcuxpresso.nxp.com/appcodehub?peripheral=usb)

<!----- Toolchains ----->
[![Toolchain badge](https://img.shields.io/badge/Toolchain-MCUXPRESSO%20IDE-orange)](https://mcuxpresso.nxp.com/appcodehub?toolchain=mcux)

Questions regarding the content/correctness of this example can be entered as Issues within this GitHub repository.

>**Warning**: For more general technical questions regarding NXP Microcontrollers and the difference in expected functionality, enter your questions on the [NXP Community Forum](https://community.nxp.com/)

[![Follow us on Youtube](https://img.shields.io/badge/Youtube-Follow%20us%20on%20Youtube-red.svg)](https://www.youtube.com/NXP_Semiconductors)
[![Follow us on LinkedIn](https://img.shields.io/badge/LinkedIn-Follow%20us%20on%20LinkedIn-blue.svg)](https://www.linkedin.com/company/nxp-semiconductors)
[![Follow us on Facebook](https://img.shields.io/badge/Facebook-Follow%20us%20on%20Facebook-blue.svg)](https://www.facebook.com/nxpsemi/)
[![Follow us on Twitter](https://img.shields.io/badge/X-Follow%20us%20on%20X-black.svg)](https://x.com/NXP)

## 7. Release Notes<a name="step7"></a>
| Version | Description / Update                           | Date                        |
|:-------:|------------------------------------------------|----------------------------:|
| 1.0     | Initial release on Application Code Hub        | December 11<sup>th</sup> 2025 |

