/*
 * Copyright 2023 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v14.0
processor: MCXN947
package_id: MCXN947VDF
mcu_data: ksdk2_0
processor_version: 0.14.12
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "pin_mux.h"
#include "fsl_gpio.h"
#include "board.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
    BOARD_InitKeyboardPins();
    LPSPI3_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: A1, peripheral: LP_FLEXCOMM4, signal: LPFLEXCOMM_P0, pin_signal: PIO1_8/WUU0_IN10/LPTMR1_ALT3/TRACE_DATA0/FC4_P0/FC5_P4/CT_INP8/SCT0_OUT2/FLEXIO0_D16/PLU_OUT0/ENET0_TXD2/I3C1_SDA/TSI0_CH17/ADC1_A8,
    slew_rate: fast, open_drain: disable, drive_strength: low, pull_select: down, pull_enable: disable, passive_filter: disable, pull_value: low, input_buffer: enable,
    invert_input: normal}
  - {pin_num: B1, peripheral: LP_FLEXCOMM4, signal: LPFLEXCOMM_P1, pin_signal: PIO1_9/TRACE_DATA1/FC4_P1/FC5_P5/CT_INP9/SCT0_OUT3/FLEXIO0_D17/PLU_OUT1/ENET0_TXD3/I3C1_SCL/TSI0_CH18/ADC1_A9,
    slew_rate: fast, open_drain: disable, drive_strength: low, pull_select: down, pull_enable: disable, passive_filter: disable, input_buffer: enable, invert_input: normal}
  - {pin_num: B16, peripheral: SWD, signal: SWO, pin_signal: PIO0_2/TDO/SWO/FC1_P2/CT0_MAT0/UTICK_CAP0/I3C0_PUR, slew_rate: fast, open_drain: disable, drive_strength: high,
    pull_select: down, pull_enable: disable, input_buffer: enable, invert_input: normal}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void)
{
    /* Enables the clock for PORT0 controller: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port0);
    /* Enables the clock for PORT1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port1);

    const port_pin_config_t port1_8_pinA1_config = {/* Internal pull-up/down resistor is disabled */
                                                    kPORT_PullDisable,
                                                    /* Low internal pull resistor value is selected. */
                                                    kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    kPORT_LowDriveStrength,
                                                    /* Pin is configured as FC4_P0 */
                                                    kPORT_MuxAlt2,
                                                    /* Digital input enabled */
                                                    kPORT_InputBufferEnable,
                                                    /* Digital input is not inverted */
                                                    kPORT_InputNormal,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    kPORT_UnlockRegister};
    /* PORT1_8 (pin A1) is configured as FC4_P0 */
    PORT_SetPinConfig(PORT1, 8U, &port1_8_pinA1_config);

    const port_pin_config_t port1_9_pinB1_config = {/* Internal pull-up/down resistor is disabled */
                                                    kPORT_PullDisable,
                                                    /* Low internal pull resistor value is selected. */
                                                    kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    kPORT_LowDriveStrength,
                                                    /* Pin is configured as FC4_P1 */
                                                    kPORT_MuxAlt2,
                                                    /* Digital input enabled */
                                                    kPORT_InputBufferEnable,
                                                    /* Digital input is not inverted */
                                                    kPORT_InputNormal,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    kPORT_UnlockRegister};
    /* PORT1_9 (pin B1) is configured as FC4_P1 */
    PORT_SetPinConfig(PORT1, 9U, &port1_9_pinB1_config);
}
void BOARD_InitKeyboardPins(void)
{
    /* Enables the clock for PORT0 controller: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port0);
    /* Enables the clock for PORT1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port1);
    /* Enables the clock for PORT2: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port2);
    /* Enables the clock for PORT3: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port3);
    /* Enables the clock for PORT4: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port4);

    CLOCK_EnableClock(kCLOCK_Gpio0);
    CLOCK_EnableClock(kCLOCK_Gpio1);
    CLOCK_EnableClock(kCLOCK_Gpio2);
    CLOCK_EnableClock(kCLOCK_Gpio3);
    CLOCK_EnableClock(kCLOCK_Gpio4);

    gpio_pin_config_t COL_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };

    GPIO_PinInit(BOARD_KEYBOARD_COL0_GPIO, BOARD_KEYBOARD_COL0_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL1_GPIO, BOARD_KEYBOARD_COL1_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL2_GPIO, BOARD_KEYBOARD_COL2_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL3_GPIO, BOARD_KEYBOARD_COL3_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL4_GPIO, BOARD_KEYBOARD_COL4_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL5_GPIO, BOARD_KEYBOARD_COL5_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL6_GPIO, BOARD_KEYBOARD_COL6_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL7_GPIO, BOARD_KEYBOARD_COL7_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL8_GPIO, BOARD_KEYBOARD_COL8_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL9_GPIO, BOARD_KEYBOARD_COL9_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL10_GPIO, BOARD_KEYBOARD_COL10_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL11_GPIO, BOARD_KEYBOARD_COL11_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL12_GPIO, BOARD_KEYBOARD_COL12_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL13_GPIO, BOARD_KEYBOARD_COL13_GPIO_PIN, &COL_config);
    GPIO_PinInit(BOARD_KEYBOARD_COL14_GPIO, BOARD_KEYBOARD_COL14_GPIO_PIN, &COL_config);

    gpio_pin_config_t ROW_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 1U
    };

    GPIO_PinInit(BOARD_KEYBOARD_ROW0_GPIO, BOARD_KEYBOARD_ROW0_GPIO_PIN, &ROW_config);
    GPIO_PinInit(BOARD_KEYBOARD_ROW1_GPIO, BOARD_KEYBOARD_ROW1_GPIO_PIN, &ROW_config);
    GPIO_PinInit(BOARD_KEYBOARD_ROW2_GPIO, BOARD_KEYBOARD_ROW2_GPIO_PIN, &ROW_config);
    GPIO_PinInit(BOARD_KEYBOARD_ROW3_GPIO, BOARD_KEYBOARD_ROW3_GPIO_PIN, &ROW_config);
    GPIO_PinInit(BOARD_KEYBOARD_ROW4_GPIO, BOARD_KEYBOARD_ROW4_GPIO_PIN, &ROW_config);
    GPIO_PinInit(BOARD_KEYBOARD_ROW5_GPIO, BOARD_KEYBOARD_ROW5_GPIO_PIN, &ROW_config);


    const port_pin_config_t keyboard_port_config = {/* Internal pull-up/down resistor is disabled */
    		                                        kPORT_PullUp,
                                                    /* Low internal pull resistor value is selected. */
                                                    kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    kPORT_LowDriveStrength,
                                                    /* Pin is configured as FC4_P1 */
                                                    kPORT_MuxAlt0,
                                                    /* Digital input enabled */
                                                    kPORT_InputBufferEnable,
                                                    /* Digital input is not inverted */
                                                    kPORT_InputNormal,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    kPORT_UnlockRegister};


    PORT_SetPinConfig(BOARD_KEYBOARD_COL0_PORT, BOARD_KEYBOARD_COL0_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL1_PORT, BOARD_KEYBOARD_COL1_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL2_PORT, BOARD_KEYBOARD_COL2_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL3_PORT, BOARD_KEYBOARD_COL3_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL4_PORT, BOARD_KEYBOARD_COL4_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL5_PORT, BOARD_KEYBOARD_COL5_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL6_PORT, BOARD_KEYBOARD_COL6_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL7_PORT, BOARD_KEYBOARD_COL7_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL8_PORT, BOARD_KEYBOARD_COL8_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL9_PORT, BOARD_KEYBOARD_COL9_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL10_PORT, BOARD_KEYBOARD_COL10_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL11_PORT, BOARD_KEYBOARD_COL11_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL12_PORT, BOARD_KEYBOARD_COL12_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL13_PORT, BOARD_KEYBOARD_COL13_GPIO_PIN, &keyboard_port_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_COL14_PORT, BOARD_KEYBOARD_COL14_GPIO_PIN, &keyboard_port_config);

    const port_pin_config_t keyboard_port_row_config = {/* Internal pull-up/down resistor is disabled */
    		                                        kPORT_PullUp,
                                                    /* Low internal pull resistor value is selected. */
                                                    kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    kPORT_LowDriveStrength,
                                                    /* Pin is configured as FC4_P1 */
                                                    kPORT_MuxAlt0,
                                                    /* Digital input enabled */
                                                    kPORT_InputBufferEnable,
                                                    /* Digital input is not inverted */
                                                    kPORT_InputNormal,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    kPORT_UnlockRegister};


    PORT_SetPinConfig(BOARD_KEYBOARD_ROW0_PORT, BOARD_KEYBOARD_ROW0_GPIO_PIN, &keyboard_port_row_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_ROW1_PORT, BOARD_KEYBOARD_ROW1_GPIO_PIN, &keyboard_port_row_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_ROW2_PORT, BOARD_KEYBOARD_ROW2_GPIO_PIN, &keyboard_port_row_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_ROW3_PORT, BOARD_KEYBOARD_ROW3_GPIO_PIN, &keyboard_port_row_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_ROW4_PORT, BOARD_KEYBOARD_ROW4_GPIO_PIN, &keyboard_port_row_config);
    PORT_SetPinConfig(BOARD_KEYBOARD_ROW5_PORT, BOARD_KEYBOARD_ROW5_GPIO_PIN, &keyboard_port_row_config);

    const port_pin_config_t keyboard_debug_config = {/* Internal pull-up/down resistor is disabled */
    		                                        kPORT_PullUp,
                                                    /* Low internal pull resistor value is selected. */
                                                    kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    kPORT_LowDriveStrength,
                                                    /* Pin is configured as FC4_P1 */
                                                    kPORT_MuxAlt7,
                                                    /* Digital input enabled */
                                                    kPORT_InputBufferEnable,
                                                    /* Digital input is not inverted */
                                                    kPORT_InputNormal,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    kPORT_UnlockRegister};

    /* Config P1_4 as SmartDMA_PIO0, SmartDMA Keyscan Debug pin */
    PORT_SetPinConfig(PORT1, 4, &keyboard_debug_config);

}

void LPSPI3_InitPins(void)
{
    /* Enables the clock for PORT0 controller: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port1);

    const port_pin_config_t port1_0_pinB6_config = {/* Internal pull-up resistor is enabled */
                                                     kPORT_PullDown,
                                                     /* Low internal pull resistor value is selected. */
                                                     kPORT_LowPullResistor,
                                                     /* Slow slew rate is configured */
                                                     kPORT_SlowSlewRate,
                                                     /* Passive input filter is disabled */
                                                     kPORT_PassiveFilterDisable,
                                                     /* Open drain output is disabled */
                                                     kPORT_OpenDrainDisable,
                                                     /* Low drive strength is configured */
                                                     kPORT_LowDriveStrength,
                                                     /* Pin is configured as FC1_P0 */
                                                     kPORT_MuxAlt2,
                                                     /* Digital input enabled */
                                                     kPORT_InputBufferEnable,
                                                     /* Digital input is not inverted */
                                                     kPORT_InputNormal,
                                                     /* Pin Control Register fields [15:0] are not locked */
                                                     kPORT_UnlockRegister};
    /* PORT0_24 (pin B6) is configured as FC1_P0 */
    PORT_SetPinConfig(PORT1, 0U, &port1_0_pinB6_config);

//    const port_pin_config_t port0_25_pinA6_config = {/* Internal pull-up resistor is enabled */
//                                                     kPORT_PullUp,
//                                                     /* Low internal pull resistor value is selected. */
//                                                     kPORT_LowPullResistor,
//                                                     /* Slow slew rate is configured */
//                                                     kPORT_SlowSlewRate,
//                                                     /* Passive input filter is disabled */
//                                                     kPORT_PassiveFilterDisable,
//                                                     /* Open drain output is disabled */
//                                                     kPORT_OpenDrainDisable,
//                                                     /* Low drive strength is configured */
//                                                     kPORT_LowDriveStrength,
//                                                     /* Pin is configured as FC1_P1 */
//                                                     kPORT_MuxAlt2,
//                                                     /* Digital input enabled */
//                                                     kPORT_InputBufferEnable,
//                                                     /* Digital input is not inverted */
//                                                     kPORT_InputNormal,
//                                                     /* Pin Control Register fields [15:0] are not locked */
//                                                     kPORT_UnlockRegister};
//    /* PORT0_25 (pin A6) is configured as FC1_P1 */
//    PORT_SetPinConfig(PORT0, 25U, &port0_25_pinA6_config);
//
//    const port_pin_config_t port0_26_pinF10_config = {/* Internal pull-up resistor is enabled */
//                                                      kPORT_PullUp,
//                                                      /* Low internal pull resistor value is selected. */
//                                                      kPORT_LowPullResistor,
//                                                      /* Slow slew rate is configured */
//                                                      kPORT_SlowSlewRate,
//                                                      /* Passive input filter is disabled */
//                                                      kPORT_PassiveFilterDisable,
//                                                      /* Open drain output is disabled */
//                                                      kPORT_OpenDrainDisable,
//                                                      /* Low drive strength is configured */
//                                                      kPORT_LowDriveStrength,
//                                                      /* Pin is configured as FC1_P2 */
//                                                      kPORT_MuxAlt2,
//                                                      /* Digital input enabled */
//                                                      kPORT_InputBufferEnable,
//                                                      /* Digital input is not inverted */
//                                                      kPORT_InputNormal,
//                                                      /* Pin Control Register fields [15:0] are not locked */
//                                                      kPORT_UnlockRegister};
//    /* PORT0_26 (pin F10) is configured as FC1_P2 */
//    PORT_SetPinConfig(PORT0, 26U, &port0_26_pinF10_config);
//
//    const port_pin_config_t port0_27_pinE10_config = {/* Internal pull-up resistor is enabled */
//                                                      kPORT_PullUp,
//                                                      /* Low internal pull resistor value is selected. */
//                                                      kPORT_LowPullResistor,
//                                                      /* Slow slew rate is configured */
//                                                      kPORT_SlowSlewRate,
//                                                      /* Passive input filter is disabled */
//                                                      kPORT_PassiveFilterDisable,
//                                                      /* Open drain output is disabled */
//                                                      kPORT_OpenDrainDisable,
//                                                      /* Low drive strength is configured */
//                                                      kPORT_LowDriveStrength,
//                                                      /* Pin is configured as FC1_P3 */
//                                                      kPORT_MuxAlt2,
//                                                      /* Digital input enabled */
//                                                      kPORT_InputBufferEnable,
//                                                      /* Digital input is not inverted */
//                                                      kPORT_InputNormal,
//                                                      /* Pin Control Register fields [15:0] are not locked */
//                                                      kPORT_UnlockRegister};
//    /* PORT0_27 (pin E10) is configured as FC1_P3 */
//    PORT_SetPinConfig(PORT0, 27U, &port0_27_pinE10_config);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
