/**************************************************************************/
/* FILE NAME: tpu_fqd.h                       COPYRIGHT (c) MOTOROLA 2002 */
/* VERSION: 1.0                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This file defines the interface to the TPU COMM functions */
/* and provides useful #defines.                                          */
/*                                                                        */
/*========================================================================*/
/* HISTORY           ORIGINAL AUTHOR Ken Terry                            */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 1.0   K Terry      18/8/02    Initial version of function.             */
/**************************************************************************/
#ifndef _TPU_COMM_H
#define _TPU_COMM_H


#include "m_common.h"
#include "m_tpu3.h"


/* Define HSR values */
#define COMM_FORCE_STATE 2
#define COMM_START_UPDATE 3


/* Define HSQ values */
#define COMM_SENSORLESS_MATCH 0
#define COMM_SENSORLESS_LINK 2
#define COMM_SENSORED 3

/* Define Parameter RAM Locations */
#define COMM_NO_OF_PINS 0
#define COMM_NO_OF_STATES 1
#define COMM_STATE_NO 1
#define COMM_OFFSET 2
#define COMM_UPDATE_PERIOD 3
#define COMM_UPPER 4
#define COMM_LOWER 5

	
/* TPU COMM function prototypes */


void	tpu_comm_init_sensored (struct TPU3_tag *tpu, UINT8 channel, INT16 no_of_pins,   
                    INT16 update_period, INT16 comm_states[], INT16 no_of_states);
void	tpu_comm_force_state (struct TPU3_tag *tpu, UINT8 channel, INT16 state_no);
void	tpu_comm_init_sensorless_match (struct TPU3_tag *tpu, UINT8 channel, INT16 no_of_pins,   
                    INT16 counter_addr, INT16 update_period, INT16 comm_states[],
                    INT16 no_of_states);
void	tpu_comm_write_upper (struct TPU3_tag *tpu, UINT8 channel, INT16 upper);
void	tpu_comm_write_lower (struct TPU3_tag *tpu, UINT8 channel, INT16 lower);
void	tpu_comm_write_offset (struct TPU3_tag *tpu, UINT8 channel, INT16 offset);
INT16	tpu_comm_get_state_no (struct TPU3_tag *tpu, UINT8 channel);
void	tpu_comm_start_update (struct TPU3_tag *tpu, UINT8 channel);
#endif
/* ifndef _TPU_COMM_H  */


/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

