/**************************************************************************/
/* FILE NAME: halld_ex1.c                     COPYRIGHT (c) MOTOROLA 2002 */
/* VERSION: 1.0                                                           */
/*                                                                        */
/* DESCRIPTION: This program is a simple example of using the HALLD       */
/*              interface routine to configure the HALLD function for     */
/*              three-channel mode                                        */
/*========================================================================*/
/* COMPILER: Diab Data        VERSION: 4.3f                               */
/*                                                                        */
/* HISTORY                                                                */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 1.1   K Terry       25/7/02     Demo program for HALLD setup           */
/*                                                                        */
/**************************************************************************/
#include "mpc555.h"
#include "tpu_halld.h"
#include "mpc500.c"        /* Configuration routines for MPC555 EVB */
#include "mpc500_util.h"   /* Utility routines for using MPC500 devices */

void force_state( INT16 state)
{
	INT16 out_state;
	out_state = (state & 0x0001) | ((state & 0x0002) << 1) | ((state & 0x0004) << 2);
	QADC_A.PORTQA.R = out_state;
	
}
  
struct TPU3_tag *tpua = &TPU_A;   /* pointer for TPU routines */	

void delay (void) 
{
	int delay;
	for (delay = 0; delay < 0x100; delay++);
}


void main ()
{
	
	int state = 0;
	INT16 state_no;			  
	
	setup_mpc500(40);       /*Setup device and programm PLL to 40MHz*/
	
	
	/* configure TPU channels 3, 4 and 5 to run the HALLD function in
	three-channel mode, state no is stored in the low order eight bits
	of parameter 3 in channel 5 */
	
	tpu_halld_init(tpua, 3, HALLD_DIRECTION_0, 0x0055, HALLD_THREE_CHANNEL_MODE);
        tpu_halld_enable(tpua, 3, TPU_PRIORITY_MIDDLE);

	
	while(1)
	{
		state_no = tpu_halld_get_state_no(tpua, 3);
		delay();
		QADC_A.PORTQA.R = 0;
		QADC_A.DDRQA.R = 0xFF00;

		tpu_halld_set_direction(tpua, 3, HALLD_DIRECTION_0);
		for (state = 0; state < 8; state++)
		{	
			force_state (state);
			
			delay();
					
			tpua->CISR.R = 0;					
			state_no = tpu_halld_get_state_no(tpua, 3);			
		}
		tpu_halld_set_direction(tpua, 3, HALLD_DIRECTION_1);

		for (state = 0; state < 8; state++)
		{
			force_state (state);
			
			delay();
			
			tpua->CISR.R = 0;					
			state_no = tpu_halld_get_state_no(tpua, 3);
		}
	}
}


/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

