/********************************************************************* 
 * 
 * Copyright: 
 *      MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and 
 *  distribute the SOFTWARE so long as this entire notice is 
 *  retained without alteration in any modified and/or redistributed 
 *  versions, and that such modified versions are clearly identified 
 *  as such. No licenses are granted by implication, estoppel or 
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty. 
 * 
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS. 
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT 
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY 
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support 
 *  of this software 
 ********************************************************************/
/************************************************************************/
/* FILE NAME: tpu_uart.h		COPYRIGHT (c) MOTOROLA 2002	*/
/* VERSION: 1.0				    All Rights Reserved		*/
/*									*/
/* DESCRIPTION: This file defines the interface to the TPU UART 	*/
/* function and provides useful #defines.				*/
/*                                                                      */
/*=====================================================================	*/
/* HISTORY				ORIGINAL AUTHOR: Vernon Goler	*/
/* REV		AUTHOR		DATE	DESCRIPTION OF CHANGE		*/
/* ---		------		----	---------------------		*/
/* 1.0		V. GOLER      15/SEP/02	Initial Version of Function	*/
/************************************************************************/

#include "m_common.h"
#include "m_tpu3.h"

#define EOF -1

/* Define HSR values							*/
#define TPU_UART_RECEIVE	0x2
#define TPU_UART_TRANSMIT	0x3

/* Define to enable interrupts or not					*/
#define TPU_UART_NOINTERRUPT	0x0
#define TPU_UART_INTERRUPT	0x1

/* Define to select noparity, parity and type of parity			*/
#define TPU_UART_NOPARITY	0x0
#define TPU_UART_EVEN_PARITY	0x2
#define TPU_UART_ODD_PARITY	0x3

/* Define parameter RAM locations for transmitter			*/
#define TPU_UART_TRANSMIT_MATCH_RATE	1
#define TPU_UART_TRANSMIT_DATA		2
#define TPU_UART_TRANSMIT_DATA_SIZE	3

/* Define parameter RAM locations for receiver				*/
#define TPU_UART_RECEIVE_MATCH_RATE	1
#define TPU_UART_RECEIVE_DATA		2
#define TPU_UART_RECEIVE_DATA_SIZE	3

/*TPU UART function prototypes						*/
void tpu_uart_transmit_init(struct TPU3_tag *tpu, UINT8 channel, 	\
UINT8 priority, INT16 baud_rate, INT16 bits_per_data_word, 		\
UINT8 parity, UINT8 nointerrupt_interrupt);

void tpu_uart_receive_init(struct TPU3_tag *tpu, UINT8 channel, 	\
UINT8 priority, INT16 baud_rate, INT16 bits_per_data_word, 		\
UINT8 parity, UINT8 nointerrupt_interrupt);

void tpu_write_transmit_data(struct TPU3_tag *tpu, UINT8 channel, \
INT16 transmit_data);

void tpu_read_receive_data(struct TPU3_tag *tpu, UINT8 channel, \
INT16 *receive_data, UINT8 *parity_error, UINT8 *framing_error);

