/**************************************************************************/
/* FILE NAME: tpu_oc.h                       COPYRIGHT (c) MOTOROLA 2002  */
/* VERSION: 1.0                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This file defines the interface to the TPU OC functions   */
/* and provides useful #defines.                                          */
/*                                                                        */
/*========================================================================*/
/* HISTORY           ORIGINAL AUTHOR: Jeff Loeliger                       */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 1.0   J. Honnold   15/Sep/02    Initial version of function.           */
/**************************************************************************/
#ifndef _TPU_DIO_H
#define _TPU_DIO_H

#include "m_common.h"
#include "m_tpu3.h"

#define TCR1	0x0
#define TCR2	0x1

#define TPU_OC_CHANNEL_CONTROL	0x0
#define TPU_OC_OFFSET			0x1
#define TPU_OC_PARAM2			0x2
#define TPU_OC_REF_ADDR1		0x2
#define TPU_OC_CONTINUOUS		0x3
#define TPU_OC_PARAM3			0x3
#define	TPU_OC_REF_TIME			0x4
#define	TPU_OC_MATCH_TIME		0x5

/* Define HSR values */
#define TPU_OC_INIT_PULSE	0x1
#define TPU_OC_RESERVED		0x2
#define TPU_OC_CONTINUOUS	0x3

/* Define HSQ Mode values */
#define TPU_OC_ALL_CODE		0x0
#define TPU_OC_TCR_ONLY		0x2

/* Define parameter CHANNEL CONTROL RAM locations */
#define	TPU_OC_FORCE_HI		0x1
#define	TPU_OC_FORCE_LO		0x2
#define	TPU_OC_NO_FORCE		0x3

#define TPU_OC_NO_CHANGE	0x0
#define TPU_OC_HIGH			0x4
#define TPU_OC_LO			0x8
#define TPU_OC_TOGGLE		0xC

#define TPU_OC_MATCH_TCR1	0x00
#define TPU_OC_MATCH_TCR2	0x20

#define TPU_OC_OUTPUT		0x80

/* TPU OC function prototypes */
void tpu_oc_host_init_i(struct TPU3_tag *tpu, UINT8 channel, UINT16 offset, \
		UINT8 hsq_mode, UINT8 force, UINT8 change, UINT8 match_tcr, UINT8 priority ) ;

void tpu_oc_host_init_ni(struct TPU3_tag *tpu, UINT8 channel, \
		UINT16 offset, UINT8 ref_addr1, UINT8 hsq_mode, UINT8 force, \
		UINT8 change, UINT8 match_tcr, UINT8 priority ) ;

void tpu_oc_continuous(struct TPU3_tag *tpu, UINT8 channel, \
		UINT8 ratio, UINT8 ref_addr1, UINT8 ref_addr2, UINT8 ref_addr3, \
		UINT8 hsq_mode, UINT8 force, UINT8 change, UINT8 match_tcr, UINT8 priority ) ;

void tpu_oc_continuous_update(struct TPU3_tag *tpu, UINT8 channel, UINT8 ratio, \
		UINT8 ref_addr1, UINT8 ref_addr2, UINT8 force, UINT8 change, UINT8 match_tcr ) ;

UINT16 tpu_oc_read_ref_time(struct TPU3_tag *tpu, UINT8 channel ) ;

UINT16 tpu_oc_read_actual_match_time(struct TPU3_tag *tpu, UINT8 channel ) ;

#endif /* ifndef _TPU_DIO_H  */

/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/
