/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

/**************************************************************************/
/* FILE NAME: tpu_mcpwm.h                     COPYRIGHT (c) MOTOROLA 2002 */
/* VERSION: 1.0                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This file defines the interface to the TPU MCPWM function */
/* and provides useful #defines.                                          */
/*                                                                        */
/*========================================================================*/
/* HISTORY           ORIGINAL AUTHOR: Mario Ramiro Perez II               */
/*                                                                        */
/* REV     AUTHOR           DATE       DESCRIPTION OF CHANGE              */
/* ---   -----------      ---------    ---------------------              */
/* 1.0   Mario R. Perez   24 Sept 02   Initial version of function.       */
/**************************************************************************/
#ifndef _TPU_MCPWM_H
#define _TPU_MCPWM_H

#include "m_common.h"
#include "m_tpu3.h"

/* 	Define HSR values */
#define TPU_MCPWM_RESET   			0x0
#define TPU_MCPWM_SLAVEA_INVERTED   0x1
#define TPU_MCPWM_All_OTHERSLAVES	0x2
#define TPU_MCPWM_INIT_MASTER 		0x3

/* 	Define HSQ values (Modes) */
#define TPU_MCPWM_EDGE_ALLIGNED_MODE    0x0
#define TPU_MCPWM_CENTER_SLAVE_A_MODE   0x1
#define TPU_MCPWM_CENTER_SLAVE_B_MODE   0x2

/* 	Define Polarity (Inverted or Non-Inverted Types) */
#define INVERTED	0x0 
#define NONINVERTED	0x1

/*  Define mode for the Update HighTime */
#define EDGE		0x0 
#define CENTER		0x1

/* 	Define parameter RAM locations Master Channel */
/*	All Modes  */
#define TPU_MASTER_PERIOD           	0
#define TPU_MASTER_IRQRATE_PERIODCNT    1
#define TPU_MASTER_RISETIMEPTR          4
#define TPU_MASTER_FALLTIMEPTR          5

/* 	Define parameter RAM locations Edge-Aligned Mode	*/
/*	Slave A or B Channel  */
#define TPU_SLAVE_PERIOD		0
#define TPU_SLAVE_HIGHTIME		1
#define TPU_SLAVE_HIGHTIME_PTR	3
#define TPU_SLAVE_RISETIME_PTR	4
#define TPU_SLAVE_FALLTIME_PTR	5

/* 	Define parameter RAM locations Center-Aligned Mode (Inverted/Non-Inverted) */
/*	Slave A Channel	*/
#define TPU_SLAVEA_PERIOD					0	
#define TPU_SLAVEA_DEADTIME_HIGHTIMEPTR		3
#define TPU_SLAVEA_TIMEPTR1					4
#define TPU_SLAVEA_TIMEPTR2					5

/* 	Define parameter RAM locations Center-Align Mode (Inverted/Non-Inverted) */ 
/*  Slave B Channel */
#define TPU_SLAVEB_HIGHTIME			0	
#define TPU_SLAVEB_BFALLTIMEPTR		4
#define TPU_SLAVEB_BRISETIMEPTR		5

/* 	TPU MCPWM function prototypes */
void tpu_mcpwm_master_init(struct TPU3_tag *tpu, UINT8 channel, UINT8 priority, UINT16 period, 
				UINT8 irq_rate);
			
void tpu_mcpwm_slave_edgemode_init(struct TPU3_tag *tpu, UINT8 channel, UINT8 priority,   
                UINT16 period, UINT16 high_time, UINT8 high_time_ptr, UINT8 master_channel);

void tpu_mcpwm_slavea_centermode_init(struct TPU3_tag *tpu, UINT8 channel, UINT8 priority,   
                UINT16 period, UINT8 dead_time, UINT8 high_time_ptr, UINT8 polarity, 
                UINT8 master_channel);
                                                
void tpu_mcpwm_slaveb_centermode_init(struct TPU3_tag *tpu, UINT8 channel, UINT8 priority,   
                UINT16 high_time, UINT8 polarity, UINT8 slave_a_channel);
                
void tpu_mcpwm_update_hightime(struct TPU3_tag *tpu, UINT8 channel, UINT16 high_time, UINT8 mode);                

                
#endif /* ifndef _TPU_MCPWM_H 					 		*/

