#define BANK0_BASE 0xFFF00000
#define M_CR (BANK0_BASE + 0x6000)
#define M_CPID (BANK0_BASE + 0x7004)
#define M_CDID (BANK0_BASE + 0x6104)

// Write General Info
void WriteGeneralInfo()
{
	//Address Translation Enabled, DPU Disabled, Memory Protection Enabled
	*(volatile unsigned long*)M_CR = 0x48c;
	//Current program ID - 1
	*(volatile unsigned long*)M_CPID = 0x1;
	//Current data ID - 1
	*(volatile unsigned long*)M_CDID = 0x1;
}

// Write PMATT Info
void WritePMATTInfo()
{
	//Translation: 0xc0040000 -> 0xc0040000, Enabled, Segment size: 16KB, Burst Size: 4
	//PAPU On, PAPS On, Prefetch On, Cacheacle On
	*(volatile unsigned long*)(BANK0_BASE + 0x8000) = 0xc004201f;
	*(volatile unsigned long*)(BANK0_BASE + 0x8004) = 0xc0040006;

	//Translation: 0xfef15e00 -> 0xfef15e00, Enabled, Segment size: 256B, Burst Size: 1
	//PAPU On, PAPS On, Prefetch Off, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8010) = 0xfef15e97;
	*(volatile unsigned long*)(BANK0_BASE + 0x8014) = 0xfef15e00;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8020) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x8024) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8030) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x8034) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8040) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x8044) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8050) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x8054) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8060) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x8064) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8070) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x8074) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8080) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x8084) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x8090) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x8094) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x80a0) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x80a4) = 0x4;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//PAPU Off, PAPS On, Prefetch On, Cacheacle Off
	*(volatile unsigned long*)(BANK0_BASE + 0x80b0) = 0x80000002;
	*(volatile unsigned long*)(BANK0_BASE + 0x80b4) = 0x4;

}

// Write DMATT Info
void WriteDMATTInfo()
{
	//Translation: 0xc0044000 -> 0xc0044000, Enabled, Segment size: 8KB, Burst Size: 4
	//DAPU rw, DAPS rw, Prefetch On
//	*(volatile unsigned long*)(BANK0_BASE + 0x9000) = 0xc004503f;
//	*(volatile unsigned long*)(BANK0_BASE + 0x9004) = 0xc0044006;

	//Translation: 0x40000000 -> 0x40000000, Enabled, Segment size: 256B, Burst Size: 4
	//DAPU rw, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9010) = 0x400000bf;
	*(volatile unsigned long*)(BANK0_BASE + 0x9014) = 0x40000006;

	//Translation: 0xe0000000 -> 0xe0000000, Enabled, Segment size: 32KB, Burst Size: 4
	//DAPU rw, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9020) = 0xe000403f;
	*(volatile unsigned long*)(BANK0_BASE + 0x9024) = 0xe0000006;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9030) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9034) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9040) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9044) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9050) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9054) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9060) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9064) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9070) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9074) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9080) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9084) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9090) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9094) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x90a0) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x90a4) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x90b0) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x90b4) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x90c0) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x90c4) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x90d0) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x90d4) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x90e0) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x90e4) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x90f0) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x90f4) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9100) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9104) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9110) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9114) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9120) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9124) = 0x94;

	//Translation: 0x0 -> 0x0, Disabled, Segment size: 4GB, Burst Size: 1
	//DAPU --, DAPS rw, Prefetch On
	*(volatile unsigned long*)(BANK0_BASE + 0x9130) = 0x80000006;
	*(volatile unsigned long*)(BANK0_BASE + 0x9134) = 0x94;

}
