//////////////////////////////////////////
//FILE
//	$RCSfile: sc_handler.c,v $
//	$Date: 2004/10/05 08:12:57 $
//	$Revision: 1.1 $
//DESCRIPTION
//   Generic system call handler
//COPYRIGHT	
//	(c) 2003 Metrowerks Corporation
//	All rights reserved.
//HISTORY
//  $Log: sc_handler.c,v $
//  Revision 1.1  2004/10/05 08:12:57  c-dnegrea
//  added sc_handler.c, eppc_exception.asm to generic PQ3 project
//
//  Revision 1.5  2004/03/18 11:32:55  tmadan
//  set nowarn pragma for interrupt handler
//
//  Revision 1.4  2004/01/22 09:07:13  tmadan
//  Use far addressing mode for printf
//
//  
///////////////////////////////////////////

#pragma push
// forward declaration for "printf" to force compiler to use far addressing mode
#pragma section RX ".text" code_mode=far_abs
int printf(const char * , ...);       
#pragma pop

#include <stdio.h>



// declare a code type section at absolute address 0xC00
#pragma section code_type  ".abs.00000c00" 

// declare MyHandler method to belong to absolute section at address 0xC00 
// and to be an interrupt handler that saves FPR registers and SRR0/SRR1 
// registers for nested interrupts.
void __declspec(section ".abs.00000c00") __declspec(interrupt fprs SRR nowarn) MyHandler(void);


#pragma push
// force all following methods not to be deadstripped
#pragma force_active on

void MyHandler(void)
{
  /* put your code here */
  /* ... */
  
 printf("system call exception handler\r\n");
}

#pragma force_active reset
#pragma pop
