/******************************************************************************
Standard Definitions

These defines allow for easier porting to other compilers. if porting change
these defines to the required values for the chosen compiler.
******************************************************************************/

typedef unsigned char   tU08;   /*unsigned 8 bit definition */
typedef unsigned int    tU16;   /*unsigned 16 bit definition*/
typedef unsigned long   tU32;   /*unsigned 32 bit definition*/
typedef signed char     tS08;   /*signed 8 bit definition */
typedef int      		    tS16;   /*signed 16 bit definition*/
typedef long int    	  tS32;   /*signed 32 bit definition*/


#ifndef UINT8
#define	UINT8	tU08			/* unsigned 8-bit */	
#define	UINT16	tU16			/* unsigned 16-bit */
#define	UINT32	tU32			/* unsigned 32-bit */
#define	INT8	tS08			/* signed 8-bit */
#define	INT16	tS16			/* signed 16-bit */
#define	INT32	tS32			/* signed 32-bit */
#endif /* UINT8 */


#define stop()        {asm stop;}
//******************************************************************************
//common labels
#define OFF			  0
#define ON        1
#define NO			  0
#define YES       1

//=======================================================
//Select a clock mode
//=======================================================
//FBE = FLL ByPassed External Clock	 
#define FBE_32KHZ    1   /* 32 kHz crystal and 16 kHz fbus */

//FEE = FLL Enabled using External Clock
#define FEE_32K8BUS		0  /* 32 kHz crystal and 8.39 MHz fbus  */
#define FEE_32K16BUS	0  /* 32 kHz crystal and 16.775 MHz fbus  */

//FEI = FLL Enabled Internal Clock
#define FEI_8MBUS		  0  /* fbus 17.77/2 MHz; untrimmed */


//=======================================================
//Enable OSC in stop mode
#define    OSCENINOFFMODE YES

//External Clock? 
#define		 EXT_CLK  NO
#if EXT_CLK   
		 #define C1REFS   0
#else 
		 #define C1REFS   1
#endif

//=======================================================
// DO NOT MODIFY  (BELOW)
//=======================================================
//FBE = FLL ByPassed External Clock
#if FBE_32KHZ
    #define C1HGO				0		 
    #define C1RANGE			0		 
    #define C1CLKS   		0b10    //CLKS = 10 for FBE
    #define C2MFD   		0b000   //N/A for FBE
    #define C2RFD   		0b000   //N/A for FBE
    #define SYS_CLOCK   32768
    #define BUS_CLOCK   SYS_CLOCK/2
//FEE = FLL Enabled External Clock
#elif	 FEE_32K8BUS
    #define C1HGO				0
    #define C1RANGE			0
    #define C1CLKS   		0b11  //CLKS = 11 for FEE
    #define C2MFD   		0b010
    #define C2RFD   		0b000
    #define SYS_CLOCK   32768
    #define BUS_CLOCK   16777216/2   //(crystal*P*N/R)/2

#elif	 FEE_32K16BUS
    #define C1HGO				0
    #define C1RANGE			0
    #define C1CLKS   		0b11  //CLKS = 11 for FEE
    #define C2MFD   		0b110
    #define C2RFD   		0b000
    #define SYS_CLOCK   32768
    #define BUS_CLOCK   33554432/2    
    
//FEI = FLL Enabled Internal Clock
#elif	 FEI_8MBUS			 //depends on trim
    #define C1HGO				0
    #define C1RANGE			0	     //N/A for FEI
    #define C1CLKS   		0b01	 //CLKS = 01 for FEI
    #define C2MFD   		0b010
    #define C2RFD   		0b000
    #define SYS_CLOCK   8864256
    #define BUS_CLOCK   8864256
#endif

#if  (FBE_32KHZ+FEE_32K8BUS+FEE_32K16BUS+FEI_8MBUS > 1		)
#error Select only ONE clock mode!!! 
#endif

#ifndef  C2MFD
#error MFD MUST BE DEFINED.  Select a clock mode!!! 
#endif
//=======================================================
// DO NOT MODIFY  (ABOVE)
//=======================================================

void CPU_init(void);