/********************************************************************** 

Filename : lcddrv.c

Description:  Performs user friendly initialization 
              of LCD Control Register 0 and 1. Source file
              initializes LCD duty cycle and bias.  By
              providing the program with your desired frame
              frequency and given oscillator frequency, this
              program calculates the correct clock divider.
              User is also capable of enabling special modes
              like Pseudostop or Wait modes.  Front plane start
              and stop points are also entered. Finally, the 
              program enables the LCD to the on state. 
              
              Additional routines provide the user with the 
              ability to turn on and off all the LCD segments.
                
************************************************************************/

#include <MC9S08LC60.h>     /* derivative information */
#include <math.h>     /* derivative information */
#include <string.h> 
#include "lcddrv.h"

extern void time_delay(int);
extern char * LCD_pos[NUMRAMREGS_FORGLASS];
extern char  LCD_position;
extern tU08 *string1, *tstring1,*string, srollstring[128];//, *space;
const tU08 ascii[] = {  
 /* */ 0x00,0x00, 
 /*!*/ 0x00,0x00, 
 /*"*/ 0x00,0x00, 
 /*#*/ 0x00,0x00, 
 /*$*/ 0x00,0x00, 
 /*%*/ 0x00,0x00, 
 /*&*/ 0x00,0x00, 
 /*'*/ 0x00,0x00, 
 /*(*/ 0x00,0x00, 
 /*)*/ 0x00,0x00, 
 /***/ 0xe9,0x3, 
 /*+*/ 0xe0,0x00, 
 /*,*/ 0x00,0x00, 
 /*-*/ 0x40,0x00, 
 /*.*/ 0x00,0x00, 
 /* */ 0x00,0x00, 
 /*0*/ 0x16,0x34, 
 /*1*/ 0xA0,0x00, 
 /*2*/ 0x54,0x14, 
 /*3*/ 0x50,0x34, 
 /*4*/ 0x42,0x30, 
 /*5*/ 0x52,0x24, 
 /*6*/ 0x56,0x24, 
 /*7*/ 0x18,0x01, 
 /*8*/ 0x56,0x34, 
 /*9*/ 0x52,0x34, 
 /*:*/ 0x10,0x80, 
 /*;*/ 0x00,0x00, 
 /*<*/ 0x00,0x00, 
 /*=*/ 0x40,0x04, 
 /*>*/ 0x00,0x00, 
 /*?*/ 0x00,0x00, 
 /*@*/ 0x00,0x00, 
 /*A*/ 0x56,0x30,   
 /*B*/ 0xF0,0x34,  
 /*C*/ 0x16,0x04,  
 /*D*/ 0xB0,0x34,  
 /*E*/ 0x56,0x4, 		
 /*F*/ 0x56,0x0,   
 /*G*/ 0x16,0x6,  
 /*H*/ 0x46,0x30, 
 /*I*/ 0xa0,0x0, 	
 /*J*/ 0x0,0x34, 	
 /*K*/ 0xA0,0x3, 	
 /*L*/ 0x6,0x4, 	 
 /*M*/ 0x7,0x31, 	
 /*N*/ 0x7,0x32, 	
 /*O*/ 0x16,0x34, 
 /*P*/ 0x56,0x10, 
 /*Q*/ 0x16,0x36, 
 /*R*/ 0x56,0x12, 
 /*S*/ 0x52,0x24, 
 /*T*/ 0xb0,0x0, 	
 /*U*/ 0x6,0x34, 	
 /*V*/ 0xe,0x1, 	
 /*W*/ 0xa6,0x34, 
 /*X*/ 0x9,0x3, 	
 /*Y*/ 0x81,0x1, 	
 /*Z*/ 0x18,0x5, 	
 /*[ */ 0x16,0x4, 
 /*\ */ 0x1,0x2, 	
 /*] */ 0x10,0x34, 
 /*^ */ 0x3,0x00,	
 /*_ */ 0x00,0x4,	
 };
 
 
 
 
 //*************************************
 //Internal Funtions
 //*************************************
//=======================================================
//=======================================================
void CONFIG_CLKSOURCE() {

//Configure LCD input clock to be about 32.768 kHz

#if EXTERNALCLK		 //Should be 32 kHz clock
		  			LCDCLKS_SOURCE = 0;
            LCDCLKS_DIV16 = 0;	 //Disable DIV16 divider
						LCDCLKS_CLKADJ = 0;
						
#else      //Bus clock need to be divided to 32.678 kHz
		
		  			LCDCLKS_SOURCE = 1;
		  			LCDCLKS_DIV16 = LCDCLK_16;
		  			LCDCLKS_CLKADJ = LCDCLK_ADJ;
#endif
}

//=======================================================
//=======================================================
void SET_CONFIG_VSUPPLY(/*char lcd_power_mode, char lcd_glass_voltage*/ )
{ 
//	char vsupplu_temp;

#if LCDPWR_VLCD
  LCDSUPPLY_VSUPPLY = 2;
    #if DOUBLERMODE	  //valid mode is using the buffer					
          LCDSUPPLY_LCDCPMS = 0;//DOUBLER MODE  // LCD3VGLASS
					LCDSUPPLY_BBYPASS = 0;          

    #elif	 TRIPLERMODE
          LCDSUPPLY_LCDCPMS = 1;//TRILPER MODE //LCD5VGLASS
          #if LCDBUFFERSTATE
                LCDSUPPLY_BBYPASS = 0;
          #else
                LCDSUPPLY_BBYPASS = 1;          
          #endif    
    #endif
#elif LCDPWR_VLLLN
   LCDSUPPLY_VSUPPLY = 3;
#elif  LCDPWR_VDD /* 0 for pwr to vll2*/ //or 1/*for pwr to vll3*/
    #if  VDDTOVLL2_2V       //for 3V LCD glass
        LCDSUPPLY_VSUPPLY = 0;
        //#if LCD3VGLASS					
          LCDSUPPLY_LCDCPMS = 0;	//DOUBLER MODE  // LCD3VGLASS
        //#endif       
    #elif VDDTOVLL2_3D3V     //for 5V LCD glass
       LCDSUPPLY_VSUPPLY = 0 ;
        //#if LCD5VGLASS
          LCDSUPPLY_LCDCPMS = 1;  //TRILPER MODE //LCD5VGLASS
        //#endif       
       
    #elif VDDTOVLL3_3V       //for 3V LCD glass
       LCDSUPPLY_VSUPPLY = 1 ;
        //#if LCD3VGLASS						
          LCDSUPPLY_LCDCPMS = 0;//DOUBLER MODE		// LCD3VGLASS
        //#endif              
   #endif
#endif
 
  LCDSUPPLY_LCDCPEN = 1;
} 
 
//=======================================================
//=======================================================
void SET_LCDCR1_REG()
{
#if LCDINTEN 
    LCDCR1_LCDIEN = 1;
#else
    LCDCR1_LCDIEN = 0;
#endif

#if LCDINSTP3 
    LCDCR1_LCDSTP3 = 0;
#else
    LCDCR1_LCDSTP3 = 1;
#endif

#if LCDINWAIT 
    LCDCR1_LCDWAI = 0;
#else
    LCDCR1_LCDWAI = 1;
#endif
}

//=======================================================
//=======================================================
void SET_BIAS()
{
    //LC60 is designed for 1/3 bias
}					
//=======================================================
//=======================================================
void SET_DUTY() {

			/* 1/2 Duty Cycle */
#if DUTY1BY2			
        LCDCR0_DUTY1 = 0; 
        LCDCR0_DUTY0 = 1;
#elif	 DUTY1BY3
      /* 1/3 Duty Cycle */
        LCDCR0_DUTY1 = 1; 
        LCDCR0_DUTY0 = 0;
#elif	 DUTY1BY4
      /* 1/4 Duty Cycle */
        LCDCR0_DUTY1 = 1; 
        LCDCR0_DUTY0 = 1;
#endif
}

//=======================================================
//=======================================================
void  SET_LCD_FRAME_FREQU() {
  
		//user must deterime values for duty and LCLK[2:0] based on the application
		SET_DUTY();
		
#if DUTY1BY2			
      /* 1/2 Duty Cycle */
      #if D2FF128D08         
          LCDCR0_LCLK = 3;
      #elif D2FF64D04          
          LCDCR0_LCLK = 4;
      #elif D2FF32D02          
          LCDCR0_LCLK = 5;
      #elif D2FF16D01          
          LCDCR0_LCLK = 6;
      #endif
#elif	 DUTY1BY3
      /* 1/3 Duty Cycle */
      #if D3FF170D77          
          LCDCR0_LCLK = 2;
      #elif D3FF85D38          
          LCDCR0_LCLK = 3;
      #elif D3FF42D69          
          LCDCR0_LCLK = 4;
      #elif D3FF29D34          
          LCDCR0_LCLK = 5;
      #endif
#elif	 DUTY1BY4
      /* 1/4 Duty Cycle */
      #if D4FF128D08         
          LCDCR0_LCLK = 2;
      #elif D4FF64D04          
          LCDCR0_LCLK = 3;
      #elif D4FF32D02          
          LCDCR0_LCLK = 4;
      #elif D4FF16D01          
          LCDCR0_LCLK = 5;
      #endif
#endif


}
//=======================================================
//=======================================================
void BLINK_ALL_MODE(byte local_mode)
{ 
			 LCDBCTL_BLKMODE = local_mode;
}


//=======================================================
//=======================================================
void CONFIG_BLINKING(byte local_blinkmode)
{  
		 ENABLE_BLINK(OFF); 
		 LCDBCTL_BRATE = BLINKFACTOR;		 
		 //set mode
		 BLINK_ALL_MODE(local_blinkmode);	 
}  
     
//=======================================================
//=======================================================
void ENABLE_FP()
{ 
			 FPENR0 = 0xFF;
			 FPENR1 = 0xFF;
			 FPENR2 = 0xFF;
			 FPENR3 = 0xFF;
			 FPENR4 = 0xFF;
			 FPENR5 = 0xFF;
}


//=======================================
void  MAP_LCDDRIVER_TO_LCDGLASS() {
  
  
  LCD_pos[0] = &LCDRAM0;
  LCD_pos[1] = &LCDRAM1; 
  LCD_pos[2] = &LCDRAM2;
  LCD_pos[3] = &LCDRAM3;
  LCD_pos[4] = &LCDRAM4;
  LCD_pos[5] = &LCDRAM5;
  LCD_pos[6] = &LCDRAM6;
  LCD_pos[7] = &LCDRAM7;
  LCD_pos[8] = &LCDRAM8;
  LCD_pos[9] = &LCDRAM9;
  LCD_pos[10] = &LCDRAM10;
  LCD_pos[11] = &LCDRAM11;
  LCD_pos[12] = &LCDRAM12;
  LCD_pos[13] = &LCDRAM13;
  LCD_pos[14] = &LCDRAM14;
  LCD_pos[15] = &LCDRAM15;
  LCD_pos[16] = &LCDRAM16;
  LCD_pos[17] = &LCDRAM17;
  LCD_pos[18] = &LCDRAM18;
  LCD_pos[19] = &LCDRAM19;
}  
  
  
 //*************************************
 //External Funtions
 //*************************************
//=======================================================
//=======================================================
//=======================================================
//=======================================================
void ENABLE_BLINK(byte cmd_enable)
{ 
	LCDBCTL_BLINK = cmd_enable;
}

//=======================================================
//=======================================================
void ENABLE_LCD(byte cmd_enable)
{ 
			 LCDCR0_LCDEN = cmd_enable;
}

void LCD_init() {
  
  //Configure clock source
  CONFIG_CLKSOURCE();	 

  //power supply configuration
  SET_CONFIG_VSUPPLY();
  
  //Configure operation in stop/wait
  SET_LCDCR1_REG();

  //Configure  frame frequncy
  SET_LCD_FRAME_FREQU();

  //Configure blink rate
  CONFIG_BLINKING(BLINKALLSEGQ);

  //Enable Frontplanes
	ENABLE_FP();	

  //Enable LCD
	ENABLE_LCD(ON);	
	
  //Map RAM to ARRAY
  MAP_LCDDRIVER_TO_LCDGLASS();  			          
}



//=======================================================
//=======================================================
void LCD_RAM_SET_ALL(char local_lcdrammode)  {

byte i;

  //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  for (i=0; i < NUMRAMREGS_FORGLASS; i++) {
      *LCD_pos[i] =  0xF;
  }
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
  
}

//=======================================================
//=======================================================
void LCD_RAM_CLEAR_ALL(char local_lcdrammode)  {

 byte i;

  //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;

  for (i=0; i < NUMRAMREGS_FORGLASS; i++) {
      *LCD_pos[i] =  0x0;
  }

  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
  
}

//=======================================================
void LCD_RAM_CLEARALL_CMD(char local_lcdrammode)  {

  //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  //Clear LCD RAM
  LCDCMD_LCDCLR = 1;
}

//=======================================================
void LCD_BLANK(byte local_mode)  {
  LCDCMD_BLANK = local_mode;
}

//=======================================================
//=======================================================
void SET_ALL_ALPNUM(byte local_lcdrammode)  {
    //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  //Set LCDRAM
  LCDRAM0 = 0xFF;
  LCDRAM1 = LCDRAM1 | LCD_ALPNUM_SETMASK;
  LCDRAM2 = 0xFF;
  LCDRAM3 = LCDRAM3 |LCD_ALPNUM_SETMASK; 
  LCDRAM4 = 0xFF; 
  LCDRAM5 = LCDRAM5 |LCD_ALPNUM_SETMASK; 
  LCDRAM6 = 0xFF;
  LCDRAM7 = LCDRAM7 |LCD_ALPNUM_SETMASK; 
  LCDRAM8 = 0xFF;
  LCDRAM9 = LCDRAM9 |LCD_ALPNUM_SETMASK; 
  LCDRAM10 = 0xFF;
  LCDRAM11 = LCDRAM11 |LCD_ALPNUM_SETMASK;
  LCDRAM12 = 0xFF;
  LCDRAM13 = LCDRAM13 |LCD_ALPNUM_SETMASK;
  LCDRAM14 = 0xFF;
  LCDRAM15 = LCDRAM15 |LCD_ALPNUM_SETMASK;
  LCDRAM16 = 0xFF;
  LCDRAM17 = LCDRAM17 |LCD_ALPNUM_SETMASK;

  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
}

//=======================================================
//=======================================================
void CLEAR_ALL_ALPNUM(byte local_lcdrammode)  {

    //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  //Set LCDRAM
  LCDRAM0 = 0x0;
  LCDRAM1 = LCDRAM1 & ~LCD_ALPNUM_SETMASK ;
  LCDRAM2 = 0x0;
  LCDRAM3 = LCDRAM3 & ~LCD_ALPNUM_SETMASK ;
  LCDRAM4 = 0x0;
  LCDRAM5 = LCDRAM5 & ~LCD_ALPNUM_SETMASK ;
  LCDRAM6 = 0x0;
  LCDRAM7 = LCDRAM7 & ~LCD_ALPNUM_SETMASK ;
  LCDRAM8 = 0x0;
  LCDRAM9 = LCDRAM9 & ~LCD_ALPNUM_SETMASK ;
  LCDRAM10 = 0x0;
  LCDRAM11 = LCDRAM11 & ~LCD_ALPNUM_SETMASK ;
  LCDRAM12 = 0x0;
  LCDRAM13 = LCDRAM13 & ~LCD_ALPNUM_SETMASK ;
  LCDRAM14 = 0x0;
  LCDRAM15 = LCDRAM15 & ~LCD_ALPNUM_SETMASK ;
  LCDRAM16 = 0x0;
  LCDRAM17 = LCDRAM17 & ~LCD_ALPNUM_SETMASK ;

  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
}

//=======================================
void  SET_VOL(byte local_lcdrammode, byte local_st, byte local_bars) {
  
  char i;
  byte  temp_array[5];
      
  //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  //Set LCDRAM
  if (local_st == ON) {
      //LCDRAM9_FP18BP3 = 1;  //menu "VOLUME" label	 (see menu function)
      LCDRAM19_FP38BP0 = 1;  //icon

			//fill icon bars 1-5 as requested 
      for (i=0; i < 5; i++) {
    					temp_array[i] = 0;
      }							           
      for (i=0; i < local_bars; i++) {
					temp_array[i] = 1;

      } 
		  LCDRAM17_FP35BP3 = temp_array[0];	 //icon bars 1-5
      LCDRAM18_FP36BP0 = temp_array[1];
      LCDRAM19_FP38BP1 = temp_array[2];
      LCDRAM19_FP38BP2 = temp_array[3];
      LCDRAM19_FP38BP3 = temp_array[4];      
  }
  else		{
      //LCDRAM9_FP18BP3 = 0;  //menu "VOLUME" label 
      LCDRAM19_FP38BP0 = 0;  //icon
      ////icon bars 1-5
      LCDRAM17_FP35BP3 = 0;	 
      LCDRAM18_FP36BP0 = 0;
      LCDRAM19_FP38BP1 = 0;
      LCDRAM19_FP38BP2 = 0;
      LCDRAM19_FP38BP3 = 0;
  }
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
} 

//=======================================
void  SET_BATT(byte local_lcdrammode, byte local_st, byte local_bars) {
  
  char i;
  byte  temp_array[4];
      
    //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  //Set LCDRAM
  if (local_st == ON) {
      LCDRAM11_FP23BP3 = 1;  //icon

			//fill icon bars 1-4 as requested 
      for (i=0; i < 4; i++) {
    					temp_array[i] = 0;
      }							           
      for (i=0; i < local_bars; i++) {
					temp_array[i] = 1;

      } 
		  LCDRAM19_FP39BP3 = temp_array[0];	 //icon bars 1-4
      LCDRAM19_FP39BP2 = temp_array[1];
      LCDRAM19_FP39BP1 = temp_array[2];
      LCDRAM19_FP39BP0 = temp_array[3];
  }
  else		{
      //LCDRAM9_FP18BP3 = 0;  //menu items
      LCDRAM11_FP23BP3 = 0;  //icon
      ////icon bars 1-4
      LCDRAM19_FP39BP3 = 0;
      LCDRAM19_FP39BP2 = 0;
      LCDRAM19_FP39BP1 = 0;
      LCDRAM19_FP39BP0 = 0;
  }
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
} 

//=======================================
void  SET_POWERSAVE(byte local_lcdrammode, byte stop3_st) {
  
		    //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  //Set LCDRAM
      LCDRAM13_FP26BP3 = stop3_st;	 //stop3_st
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
}
//=======================================
void  SET_TIMESEGS(byte local_lcdrammode, byte am_st, byte pm_st, byte alarm_st) {

		    //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;

		  LCDRAM18_FP36BP1 = am_st;	 //am_st
      LCDRAM18_FP36BP2 = pm_st;	 //pm_st
      LCDRAM11_FP22BP3 = alarm_st;	 //alarm_st
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
}

//=======================================
void  SET_TEMPSEGS(byte local_lcdrammode, byte heat_st, byte cool_st,char degree_st) {

		    //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  //Set LCDRAM
		  LCDRAM5_FP11BP3 = heat_st;	 //heat_st
      LCDRAM7_FP15BP3 = cool_st;	 //cool_st
      LCDRAM17_FP34BP3 = degree_st;	 //degree_st
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
}

//=======================================
void  SET_DMMLABLES(byte local_lcdrammode, char kwatt_st, char volt_st,char amp_st,char om_st) {
  
		    //configure LCDRAM as SEGONOFF or SEGBLINKEN
      LCDCMD_LCDDRMS = local_lcdrammode;
        
      LCDRAM18_FP37BP0 = kwatt_st;	 //kwatt_st
      LCDRAM18_FP37BP1 = amp_st;	 //amp_st
      LCDRAM18_FP37BP2 = volt_st;	 //volt_st
      LCDRAM18_FP36BP3 = om_st;	 //om_st
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
} 
//=======================================
void  SET_LOGO(byte local_lcdrammode, byte local_st) {
  
  //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  
  //Set LCDRAM
  LCDRAM5_FP10BP3 = local_st;

  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;

} 
//=======================================
void  SET_MENU(byte local_lcdrammode, byte time_st, byte date_st, byte temp_st, byte vol_st, byte contr_st, byte mode_st, byte prog_st) {
  
   //configure LCDRAM as SEGONOFF or SEGBLINKEN
   LCDCMD_LCDDRMS = local_lcdrammode;  
   //Set LCDRAM
   LCDRAM1_FP2BP3 = time_st;  //Time  ////ERROR TOO MANY
   LCDRAM3_FP6BP3 = date_st;  //date
   LCDRAM7_FP14BP3 = temp_st;  //temp
   LCDRAM9_FP18BP3 = vol_st;  //volume
   LCDRAM15_FP30BP3 = contr_st;  //contrast
   LCDRAM15_FP31BP3 = mode_st;  //mode
   LCDRAM18_FP37BP3 = prog_st;  //program
   //default configure LCDRAM as SEGONOFF 
   LCDCMD_LCDDRMS = SEGONOFF;
} 



//=======================================
void  SET_COLONS(byte local_lcdrammode, byte col1_st, byte col2_st, byte col3_st, byte minus_st) {
  
		    //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
    
		  LCDRAM3_FP7BP2 = col1_st;	 //col1_st
      LCDRAM9_FP19BP2 = col2_st;	 //col2_st
      LCDRAM13_FP27BP2 = col3_st;	 //col3_st
    
      LCDRAM1_FP3BP3 = minus_st;	 //minus_st
      
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
} 

//=======================================
void  SET_DECIMALS(byte local_lcdrammode, byte deci1_st,byte deci2_st,byte deci3_st,char deci4_st,char deci5_st,char deci6_st,char deci7_st,char deci8_st, char deci9_st) {
     
  //configure LCDRAM as SEGONOFF or SEGBLINKEN
  LCDCMD_LCDDRMS = local_lcdrammode;
  //Set LCDRAM
  LCDRAM1_FP3BP2 = deci1_st;	 //deci1_st
  LCDRAM3_FP7BP3 = deci2_st;	 //decN_st
  LCDRAM5_FP11BP2 = deci3_st;	 //decN_st
  LCDRAM7_FP15BP2 = deci4_st;	 //decN_st
  LCDRAM9_FP19BP3 = deci5_st;	 //decN_st
  LCDRAM11_FP23BP2 = deci6_st;	 //decN_st
  LCDRAM13_FP27BP3 = deci7_st;	 //decN_st
  LCDRAM15_FP31BP2 = deci8_st;	 //decN_st
  LCDRAM17_FP35BP2 = deci9_st;	 //decN_st
  //default configure LCDRAM as SEGONOFF 
  LCDCMD_LCDDRMS = SEGONOFF;
} 


//=======================================================
void output_strg_lcd(tU08 *string, tU08 length)      
{
  tU16 i,j,l,c;
  byte t[9];

  //initialize index
  i = length-1;
  j=0; 

  //initial decimals
  for (l=0; l < NUMALPASEGS_ONGLASS; l++) {
			t[l] = OFF;
  }						           
  SET_DECIMALS(SEGONOFF,t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]);
  
  //loop through charater position        
  while ((j<NUMALPASEGS_ONGLASS) && (i != 0))
  {
      if (string[i] == 0x2E) {  //is first character period? (0x2e is period)
					t[LCD_position-1] = ON;
          SET_DECIMALS(SEGONOFF,t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]);
      }
      else        {						
          c = ((string[i]-0x20)*2);     // convert ASCII to table index (in bytes)
          if (c < 128) {            
              *LCD_pos[LCD_position*2-2] = *LCD_pos[LCD_position*2-2] | (tU08)ascii[c];
              *LCD_pos[LCD_position*2-1] = *LCD_pos[LCD_position*2-1] |(tU08)ascii[c+1];
          }
          LCD_position--;
      }
      i=i-1;
      j = j+1;        
  }
  
  //handle last character of string
  i=0;
  if (string[i] == 0x2E)  { //0x2e is period
          SET_DECIMALS(SEGONOFF,ON,t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]);
  }
  else {  // not a period
      c = ((string[i]-0x20)*2);     // convert ASCII to table index (in bytes)
      if (c < 128) {            
              *LCD_pos[LCD_position*2-2] = *LCD_pos[LCD_position*2-2] | (tU08)ascii[c];
              *LCD_pos[LCD_position*2-1] = *LCD_pos[LCD_position*2-1] | (tU08)ascii[c+1];
      }
  }
}

//=======================================================
void Scroll_String(tU08 *string, byte local_length) {

int i,j,k;

      //Initlize main loop
      string1 = string;
      
      //Display text
      for (i = 0; i < local_length; i++) {
          tstring1 = string1;
          j = 0;

          for (j = 0; j < i+1; j++) {
    				 srollstring[j] = toupper(*tstring1);
    				 tstring1++;
          }     
          LCD_position = NUMALPASEGS_ONGLASS;
          CLEAR_ALL_ALPNUM(SEGONOFF);
          time_delay(CLEAR_DELAY);
          output_strg_lcd(srollstring,j);
          time_delay(SCROLL_DELAY);
     }
     
     //Do not wrap around if text length is Zero
		 if (local_length!=0) {
		  
		    //Setup buffer with end of message to wrap around
        for (k = 0; k < NUMALPASEGS_ONGLASS; k++) {
          srollstring[k] = ' ';
        }
        i = local_length;//strlen(string);
        for (k = 0; k < NUMALPASEGS_ONGLASS; k++) {
          srollstring[NUMALPASEGS_ONGLASS-k] = 	 toupper(string[i-k]);
          if (k == i )
              k=  NUMALPASEGS_ONGLASS;
        }
        
        //wrap around end of text in display
        for (k = 0; k < NUMALPASEGS_ONGLASS; k++) {
      		srollstring[0] =  srollstring[1];
      		srollstring[1] =  srollstring[2];
      		srollstring[2] =  srollstring[3];
      		srollstring[3] =  srollstring[4];
      		srollstring[4] =  srollstring[5];
      		srollstring[5] =  srollstring[6];
      		srollstring[6] =  srollstring[7];
      		srollstring[7] =  srollstring[8];
      		srollstring[8] =  ' ' ;
          LCD_position = NUMALPASEGS_ONGLASS;
          CLEAR_ALL_ALPNUM(SEGONOFF);
          time_delay(CLEAR_DELAY);
          output_strg_lcd(srollstring,NUMALPASEGS_ONGLASS);
          time_delay(SCROLL_DELAY);
         }
		 }
		 //Get rid of any left overover decis
		 SET_DECIMALS(SEGONOFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
}