#include <MC9S08LC60.h> /* include peripheral declarations */
#include <hidef.h> /* for EnableInterrupts macro */
#include <string.h> /* include peripheral declarations */

//******************************************************
#include "lcddrv.h"
#include "sci.h"
#include "cpu.h"

char * LCD_pos[NUMRAMREGS_FORGLASS];
char  LCD_position; 
tU08 *string1, *tstring1,*string, srollstring[128]; 

//******************************************************
void time_delay(int local_delay)
{
  int i,j,k;
  for (i = 0; i <= local_delay; i++)
  {
    for (j = 0; j <= local_delay; j++)
    {
      for (k = 0; k <= local_delay; k++)
      {
        int l = 0;
      }
    }
  }
}

//******************************************************
byte  TERMIO_PutChar(byte c) {

	while (  AS1_SendChar(  (byte) &c)			);
	return 1;
}

//******************************************************
void  DefaultDisplayMessage() {

	  string = "9S08LC60";
    LCD_position = NUMALPASEGS_ONGLASS;		    
    output_strg_lcd(string, strlen(string));        	  
}

//******************************************************
void  IO_init()  {
 	//Initialize port direction - OUTPUTS; 
  //******************
 	PTADD_PTADD7 = 1;//output; LED 
 	PTADD_PTADD6 = 1;//output; LED 
 	PTADD_PTADD5 = 1;//output; LED 
 	PTBDD_PTBDD7 = 1;//output; LED 
 	PTBDD_PTBDD6 = 1;//output; LED 
 	PTBDD_PTBDD5 = 1;//output; LED 
 	PTBDD_PTBDD4 = 1;//output; LED 
 	PTBDD_PTBDD3 = 1;//output; LED
 	//Intialize data
 	PTAD_PTAD7 = 1;//output; LED 
 	PTAD_PTAD6 = 1;//output; LED 
 	PTAD_PTAD5 = 1;//output; LED 
 	PTBD_PTBD7 = 1;//output; LED 
 	PTBD_PTBD6 = 1;//output; LED 
 	PTBD_PTBD5 = 1;//output; LED 
 	PTBD_PTBD4 = 1;//output; LED 
 	PTBD_PTBD3 = 1;//output; LED
 	
 	//Intialize data
  PTCDD_PTCDD2 = 1;//output; SPEAKER 

 	//Initialize port direction - INPUTS; 
  //******************
 /*	PTCDD_PTCDD7 = 0;//input - BUTTONS
 	PTCDD_PTCDD5 = 0;//input  - BUTTONS
 	PTCDD_PTCDD4 = 0;//input - BUTTONS*/
 	PTCDD_PTCDD3 = 0;//input  - BUTTONS 

  //KBI intialization
  KBI2PE_KBIPE7 = 1; //PTC7
  KBI2PE_KBIPE6 = 1; //PTC5
  KBI2PE_KBIPE5 = 1; //PTC4
  KBI2SC_KBIE = 1;

}
//******************************************************
void main(void) {
 
  tU08 i,l;
  byte result, inputcounter, c;
  byte sci_input[30], cmdstring[30];


  //Initialize CPU and Perpherial 
  //******************
  IO_init();
  CPU_init();
  AS1_Init();
  LCD_init();
  
  //Intialize LCD glass display
  //******************
  LCD_RAM_SET_ALL(SEGONOFF);
  LCD_RAM_CLEAR_ALL(SEGONOFF);


//++++++++++++++++++++++++++++++++++++++++++++++++
  //SET_VOL; SET_BATT (lcdram_mode, char local_st, char local_bars)
  SET_VOL(SEGONOFF,ON, 2);
  SET_BATT(SEGONOFF,ON, 3);  
  SET_POWERSAVE(SEGONOFF,ON);
  SET_POWERSAVE(SEGBLINKEN,OFF);
  
  //Button Menu
  SET_MENU(SEGONOFF,ON,ON,ON,ON,ON,ON,ON);
  
  //  SET_TIMESEGS(byte local_lcdrammode, byte am_st, byte pm_st, byte alarm_st);
  SET_TIMESEGS(SEGONOFF, ON,ON,ON);
  SET_TIMESEGS(SEGBLINKEN, OFF,ON,ON);

  //  SET_TEMPSEGS(byte local_lcdrammode, byte heat_st, byte cool_st,char degree_st);
  SET_TEMPSEGS(SEGONOFF, ON,ON,OFF);
  SET_TEMPSEGS(SEGBLINKEN, OFF,OFF,OFF);
  
  //SET_DMMLABLES(kwatt_st, volt_st, amp_st,om_st) {
  SET_DMMLABLES(SEGONOFF,ON,ON,ON,ON);
  SET_DMMLABLES(SEGBLINKEN,OFF,OFF,OFF,OFF);

  //Logo
  SET_LOGO(SEGONOFF, ON);
  SET_LOGO(SEGBLINKEN, OFF);
  
  //col1,col2,col3,degree symbol 
  //SET_COLONS(ON,ON,ON,ON,OFF);
  SET_COLONS(SEGONOFF,OFF,OFF,OFF,OFF);

  //Dec1-9
  //SET_DECIMALS(ON,ON,ON,ON,ON,ON,ON,ON,ON);
  SET_DECIMALS(SEGONOFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
//++++++++++++++++++++++++++++++++++++++++++++++++

//Enable Blinking
  //******************
  ENABLE_BLINK(ON);
  
  ///EnableInterrupts
  //******************
  EnableInterrupts; /* enable interrupts */
  

  //Demo Code
  //******************
  string = "HELLO WORLD"; 
  LCD_position = NUMALPASEGS_ONGLASS;		    
  Scroll_String(string, strlen(string));

  DefaultDisplayMessage();
   
  //Initialize display counters
  l=0;
  inputcounter = 0;
  LCD_position = NUMALPASEGS_ONGLASS;	
  
  //Main LOOP	    
  while (1) {
    //Check incoming data
    result = AS1_RecvChar(&c);
    if (result == ERR_OK ) {
       sci_input[inputcounter] = c;
    	 inputcounter = inputcounter + 1;
        if (c == '\r') {
            sci_input[inputcounter-1] = '\0';
        	  string =  sci_input;
        	  Scroll_String(string, strlen(string));        
            inputcounter = 0;
        	  cmdstring[0] = ' ';
        	  for (i=0; i <= 30; i++)  sci_input[i] = 0;
        	  
        	  //Change BAT and VOL randomly
            SET_VOL(SEGONOFF,ON, 5-l);
            SET_BATT(SEGONOFF,ON, l);  
        	  if (l == 4) 	 l=0; 
        	  else l++;;
        	  
        	  //Display default message
        	  DefaultDisplayMessage(); 
     	   }

       }
    }
  
  for(;;) {
   } /* loop forever */
 }
