

#define USE_IRQ         1
#define CATCH_TRAPS     0


#define WSP_SRT    (3 + 4*USE_IRQ)

//#pragma CONST_SEG NEAR WorkSpace
#pragma CONST_SEG WorkSpace


const char _WSP_[] = {
            0x94,      /* TXS      ; move H:X into SP                         */
            0x83,      /* SWI      ; enter monitor                            */
            0x80       /* RTI      ; back to caller (done with DisabledStep)  */
#if USE_IRQ
            ,
            0x2E,      /* BIL  *0  ; wait until IRQ pin is high               */
            0xFE,
            0x83,      /* SWI      ; enter monitor                            */
            0x80       /* RTI      ; back to caller (done with DisabledStep)  */
#endif
#if CATCH_TRAPS
            ,
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80,      /* RTI      ; back to caller (done with DisabledStep)  */
            0x83,      /* SWI      ; enter monitor                            */ 
            0x80       /* RTI      ; back to caller (done with DisabledStep)  */     
#endif
};

#pragma CONST_SEG DEFAULT
/* Please define the vectors into your PRM file as shown below:

for placement:

PLACEMENT
    ...
    WorkSpace  INTO  READ_ONLY   0xFF00 TO 0xFF30; // 49 bytes of previous code located where desired 
    ...
END

vectors at the end of the PRM file:

VECTOR 0  _Startup
VECTOR 1  0x0000   // SWI, used by the Mon08, not by user
VECTOR 2  _WSP_ OFFSET 3  // IRQ vector handler
VECTOR 3  _WSP_ OFFSET 7  // PLL
VECTOR 4  _WSP_ OFFSET 9  // PIT
VECTOR 5  _WSP_ OFFSET 11  // TIMA CH0
VECTOR 6  _WSP_ OFFSET 13  // TIMA CH1
VECTOR 7  _WSP_ OFFSET 15  // TIMA CH2
VECTOR 8  _WSP_ OFFSET 17  // TIMB CH0
VECTOR 9  _WSP_ OFFSET 21  // TIMB CH1
VECTOR 10 _WSP_ OFFSET 23  // TIMB Overflow       IMPORTANT: "//" C++ comment syntax must be replaced
VECTOR 11 _WSP_ OFFSET 25  // SPI Receive         by "*/ /*"  into your PRM file.
VECTOR 12 _WSP_ OFFSET 27  // SPI Transmit
VECTOR 13 _WSP_ OFFSET 29  // msCAN Wakeup
VECTOR 14 _WSP_ OFFSET 31  // msCAN Error
VECTOR 15 _WSP_ OFFSET 33  // msCAN Receive
VECTOR 16 _WSP_ OFFSET 35  // msCAN Transmit
VECTOR 17 _WSP_ OFFSET 37  // SCI Error
VECTOR 18 _WSP_ OFFSET 39  // SCI Receive
VECTOR 19 _WSP_ OFFSET 41  // SCI Transmit
VECTOR 20 _WSP_ OFFSET 43  // Keyboard
VECTOR 21 _WSP_ OFFSET 45  // ADC

*/

