// ========================================================
//  Copyright (c)2006 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source$
//  Author:       $Author$
//  Locker:       $Locker$
//  State:        $State$
//  Revision:     $Revision$
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  
//
//
//
//  Notes:        
//
//
//
// ========================================================
#ifndef   FILTER_H
#define   FILTER_H

#include "Types.h"



// --------------------------------------------------------
// Defines
// --------------------------------------------------------

// Deceleration Digital Filter constant values for Low-pass digital filter
#define TIME_CONST  0.05                                    // Time constant for averaging deceleration values
#define SAMP_RATE   400                                     // Sample rate of system 
#define DIVIDER                      (TIME_CONST*SAMP_RATE)
#define SENSORSAMPLEINTERVAL (UINT16)(1000/SAMP_RATE/TIMERBASEINTERVALLMS)  // ms


// for proper filter operation ensure:
//#if (DECEL_LEVEL_0*DIVIDER*1.5)>65535           // 150% of max ADC value 
//#error "Too High"  
//#endif  

// --------------------------------------------------------
// Properties (public)
// --------------------------------------------------------
void FilterInit(UINT16 newvalue);
UINT16 Filter(UINT16 newvalue);


#endif 

