// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/908E624Demo/Slave/Includes/Timer.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.1.1.1 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  
//								
//
//
//  Notes:        
//
//
//
// ========================================================

#ifndef TIMER_H
#define TIMER_H

// --------------------------------------------------------
// Includes
// --------------------------------------------------------
#include "ChipSets.h"
#include "l_api.h"
#include "types.h"


// --------------------------------------------------------
// Defines
// --------------------------------------------------------
#define BUSFREQUENCY                  4915200               // Hz   
#define TBMFREQUENCY                  (4*BUSFREQUENCY)      // Hz

#define TIMERBASEINTERVALLMS          0.833                 // ms
//#define TIMERBASEINTERVALLMS          (16384/TBMFREQUENCY)

#define FLASHER_COUNT                 75       // ms

#define TIMERMAX                      4                     // No. of Channels used

#define TIMER1                        0x01                  // Timer for LowPass / Sampling of g-sensor
#define TIMER2                        0x02                  // Timer for statemachine (break)
#define TIMER3                        0x04                  // Timer for flasher
#define TIMER4                        0x08                  // Timer for ambient sensor sampling

#define TIMER1IDX                     0                     
#define TIMER2IDX                     1														
#define TIMER3IDX                     2														
#define TIMER4IDX                     3														


// --------------------------------------------------------
// Properties (public)
// --------------------------------------------------------
extern unsigned int TimerValue[TIMERMAX];                   // Counter Register

// --------------------------------------------------------
// Methodes published
// --------------------------------------------------------
void TimerInit(void);                                       // Initialize Timer and Channels
void TimerEnable(void);
void TimerDisable(void);
void TimerStart(unsigned char channel);                     // Start a channel Timer  
void TimerStop(unsigned char channel);                      // Stop a channel Timer
unsigned char TimerElapsed(unsigned char channel);          // Channel Timer Elapsed?
unsigned char TimerRunning(unsigned char channel);          // Channel Timer Running?


#endif // TIMER_H

