// ========================================================
//   Copyright (C) 2003 Motorola, Inc.
//   All Rights Reserved
//
//   The code is the property of Motorola GmbH Munich
//   Combined Technologies Operation
//   and is Motorola Confidential Proprietary Information.
//
//   The copyright notice above does not evidence any
//   actual or intended publication of such source code.
//
//
// Filename:     $Source: d:\\CVS_SERVER/windowlift/Include/Timer.h,v $
// Author:       $Author: r51199 $
// Locker:       $Locker:  $
// State:        $State: Exp $
// Revision:     $Revision: 1.6 $
//
// Functions:    
//
// History:      Use the CVS command log to display 
//               revision history information.
//
// Description:  
//
//
//
// Notes:        
//
//
//
// ========================================================

#ifndef TIMERB_H
#define TIMERB_H

#include "Types.h"

#define BUSFREQUENCY            4915200                     // Hz   
#define PWMFREQUENCY            200                         // Hz  
#define TICKSMAX                100                         // 100 steps resolution  
#define TIMBPERIOD              (UINT16)(BUSFREQUENCY/PWMFREQUENCY/TICKSMAX)     

#define ONEPERCENT              

// Output Preset
#define TIM_MODE_OUTPUT_PRESET_HIGH       (                         )   // Pin under port control; initial output level high
#define TIM_MODE_OUTPUT_PRESET_LOW        (      bMS0A              )   // Pin under port control; initial output level low

// Input capture  
#define TIM_MODE_INPUTCAPTURE_RISINGEDGE  (                   bELS0A)   // Capture on rising edge only
#define TIM_MODE_INPUTCAPTURE_FALLINGEDGE (            bELS0B       )   // Capture on falling edge only
#define TIM_MODE_INPUTCAPTURE_ONEDGE      (            bELS0B|bELS0A)   // Capture on rising or falling edge

// Output compare or PWM    
#define TIM_MODE_OUTPUTCOMPARE_SWONLY     (      bMS0A              )   // Software compare only
#define TIM_MODE_OUTPUTCOMPARE_TOGGLE     (      bMS0A       |bELS0A)   // Toggle output on compare
#define TIM_MODE_OUTPUTCOMPARE_CLEAR      (      bMS0A|bELS0B       )   // Clear output on compare
#define TIM_MODE_OUTPUTCOMPARE_SET        (      bMS0A|bELS0B|bELS0A)   // Set output on compare


// Buffered output compare or buffered PWM
#define TIM_MODE_BUF_OUTPUTCOMPARE_TOGGLE (bMS0B      |bELS0B|bELS0A)   // Toggle output on compare
#define TIM_MODE_BUF_OUTPUTCOMPARE_CLEAR  (bMS0B      |bELS0B|bELS0A)   // Clear output on compare
#define TIM_MODE_BUF_OUTPUTCOMPARE_SET    (bMS0B      |bELS0B|bELS0A)   // Set output on compare


// --------------------------------------------------------
// Properties (public)
// --------------------------------------------------------

// --------------------------------------------------------
// Methodes published
// --------------------------------------------------------
void isrTimerBOverflow(void);        




void TimerBInit(void);                                       // Initialize Timer for PWM and Channels
void TimerBEnable(void);
void TimerBDisable(void);
void TimerBSetDuty(UINT8 value);

#endif // TIMER_H

