// ============================================================================
//  Copyright (c)2006 Freescale Semiconductor Inc.  -- All Rights Reserved --
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any actual or intended 
//  publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any expressed or implied
//  warrenties, including, but not limited to, the implied warrenties of 
//  merchantability and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be liable for any direct, 
//  indirect, incidental, special, examplary, or consequential damages 
//  (including, but not limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption). However caused 
//  and on any theory of liability, whether in contract, strict liability, or
//  tort (including negligence or otherwise) arising in any way out of the use 
//  of this software, even if advised of the possibility of such damage.
// 
//  ---------------------------------------------------------------------------
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/LINDiag/l_diag.c,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.6 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display revision history information.
//
//  Description:  header file for one specific LIN diagnostic implementation
//                
//  Notes:        This file is NOT allowed to modify by user
//                
//
//
// ============================================================================
#define   L_DIAG_C 

#include "l_diag.h"


#define NodeId    255
#define MyNAD     0xA0 


// -----  Macros  -----------------------------------------
#define ldd_SPIWRITE     0
#define ldd_SPIREAD      1
#define ldd_MCUWRITE     2
#define ldd_MCUREAD      3
#define ldd_ADCREAD      4
#define ldd_TOOLS        5

// --------------------------------------------------------
void ldd_Handler(void)  {
  UINT8 tmp;


  // ----------------------------------------
  // new LIN diag debugger
  // ----------------------------------------
  if(ldd_u8_rd_SysNAD()==MyNAD)  {                                              // for this node
    ldd_u8_wr_SysNAD(ldd_u8_rd_SysNAD());                                       // echo NAD
    ldd_u8_wr_SysCMD(ldd_u8_rd_SysCMD());                                       // echo CMD

    // --------------------------------------------
    // SPI Write
    // --------------------------------------------
    if(ldd_u8_rd_SysCMD() == ldd_SPIWRITE)   {                                  // SPI_Write

#if defined(MM908E624)
      // not implemented
#else
      if(ldd_u8_rd_SysM0()!=0xFF)  {                                            // 0xFF is escape char / don't read
        SPI_Write(ldd_u8_rd_SysM0(),ldd_u8_rd_SysM1());                         
      }
      if(ldd_u8_rd_SysM2()!=0xFF)  {                                            // 0xFF is escape char / don't read
        SPI_Write(ldd_u8_rd_SysM2(),ldd_u8_rd_SysM3());                         
      }                                                                         
      if(ldd_u8_rd_SysM4()!=0xFF)  {                                            // 0xFF is escape char / don't read
        SPI_Write(ldd_u8_rd_SysM4(),ldd_u8_rd_SysM4());                         
      }                                                                         
      LinMsgStatus[SysResponseMsgIdx] = LIN_MSG_UPDATED;
#endif
     
    // --------------------------------------------
    // SPI Read
    // --------------------------------------------
    }else if(ldd_u8_rd_SysCMD() == ldd_SPIREAD)   {                             // SPI_Read

#if defined(MM908E624)
      // not implemented
#else

      if(ldd_u8_rd_SysM0()!=0xFF)  {                                            // 0xFF is escape char / don't read
        SPI_Read(ldd_u8_rd_SysM0());                                            
        ldd_u8_wr_SysS0(SPI_RegValue(ldd_u8_rd_SysM0()));
      }
      if(ldd_u8_rd_SysM1()!=0xFF)  {
        SPI_Read(ldd_u8_rd_SysM1());
        ldd_u8_wr_SysS1(SPI_RegValue(ldd_u8_rd_SysM1()));
      }
      if(ldd_u8_rd_SysM2()!=0xFF)  {
        SPI_Read(ldd_u8_rd_SysM2());
        ldd_u8_wr_SysS2(SPI_RegValue(ldd_u8_rd_SysM2()));
      }
      if(ldd_u8_rd_SysM3()!=0xFF)  {
        SPI_Read(ldd_u8_rd_SysM3());
        ldd_u8_wr_SysS3(SPI_RegValue(ldd_u8_rd_SysM3()));
      }
      if(ldd_u8_rd_SysM4()!=0xFF)  {
        SPI_Read(ldd_u8_rd_SysM4());
        ldd_u8_wr_SysS4(SPI_RegValue(ldd_u8_rd_SysM4()));
      }
      if(ldd_u8_rd_SysM5()!=0xFF)  {
        SPI_Read(ldd_u8_rd_SysM5());
        ldd_u8_wr_SysS5(SPI_RegValue(ldd_u8_rd_SysM5()));
      }
      LinMsgStatus[SysResponseMsgIdx] = LIN_MSG_UPDATED;
#endif

    // --------------------------------------------
    // MCU Read
    // --------------------------------------------
    }else if(ldd_u8_rd_SysCMD() == ldd_MCUREAD)   {                             // MCU_Read
      ldd_u16_wr_SysS01(*(UINT16 *)ldd_u16_rd_SysM01());                        
      ldd_u16_wr_SysS23(*(UINT16 *)ldd_u16_rd_SysM23());                        
      ldd_u16_wr_SysS45(*(UINT16 *)ldd_u16_rd_SysM45());
      LinMsgStatus[SysResponseMsgIdx] = LIN_MSG_UPDATED;
    // --------------------------------------------
    // MCU Write
    // --------------------------------------------
    }else if(ldd_u8_rd_SysCMD() == ldd_MCUWRITE)   {                            // MCU_Write
      if(ldd_u16_rd_SysM01() != 0xFFFF)  {                                      
        *(UINT8 *)ldd_u16_rd_SysM01() = ldd_u8_rd_SysM2();                      
      }
      LinMsgStatus[SysResponseMsgIdx] = LIN_MSG_UPDATED;
    // --------------------------------------------
    // ADC Read
    // --------------------------------------------
    }else if(ldd_u8_rd_SysCMD() == ldd_ADCREAD)   {                            


#if defined(MM908E622)
      SPI_Read(erA0MUCTL);
      tmp = SPI_RegValue(erA0MUCTL);                                            // remember (none intrusive) 
      
      if(ldd_u8_rd_SysM0()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erA0MUCTL, ldd_u8_rd_SysM0());                                // set analog mux
        ldd_u16_wr_SysS01(*ADC_Value10(ldd_u8_rd_SysM1()));                     // set mcu mux, measure, return value
      }                                                                         
      if(ldd_u8_rd_SysM2()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erA0MUCTL, ldd_u8_rd_SysM2());                                // set analog mux
        ldd_u16_wr_SysS23(*ADC_Value10(ldd_u8_rd_SysM3()));                     // set mcu mux, measure, return value
      }
      if(ldd_u8_rd_SysM4()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erA0MUCTL, ldd_u8_rd_SysM4());                                // set analog mux
        ldd_u16_wr_SysS45(*ADC_Value10(ldd_u8_rd_SysM5()));                     // set mcu mux, measure, return value
      }
      
      SPI_Write(erA0MUCTL, tmp);                                                // restore (none intrusive) 
#endif

#if defined(MM908E625)
      SPI_Read(erADOUT);
      tmp = SPI_RegValue(erADOUT);                                              // remember (none intrusive) 

      if(ldd_u8_rd_SysM0()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erADOUT, ldd_u8_rd_SysM0());                                  // set analog mux
        ldd_u16_wr_SysS01(*ADC_Value10(ldd_u8_rd_SysM1()));                     // set mcu mux, measure, return value
      }                                                                         
      if(ldd_u8_rd_SysM2()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erADOUT, ldd_u8_rd_SysM2());                                  // set analog mux
        ldd_u16_wr_SysS23(*ADC_Value10(ldd_u8_rd_SysM3()));                     // set mcu mux, measure, return value
      }
      if(ldd_u8_rd_SysM4()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erADOUT, ldd_u8_rd_SysM4());                                  // set analog mux
        ldd_u16_wr_SysS45(*ADC_Value10(ldd_u8_rd_SysM5()));                     // set mcu mux, measure, return value
      }

 			SPI_Write(erADOUT, tmp);                                                  // restore (none intrusive) 
#endif

#if defined(MM908E630)
      SPI_Read(erAMUXCR);
      tmp = SPI_RegValue(erAMUXCR);                                              // remember (none intrusive) 

      if(ldd_u8_rd_SysM0()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erAMUXCR, ldd_u8_rd_SysM0());                                  // set analog mux
        ldd_u16_wr_SysS01(*ADC_Value10(ldd_u8_rd_SysM1()));                     // set mcu mux, measure, return value
      }                                                                         
      if(ldd_u8_rd_SysM2()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erAMUXCR, ldd_u8_rd_SysM2());                                  // set analog mux
        ldd_u16_wr_SysS23(*ADC_Value10(ldd_u8_rd_SysM3()));                     // set mcu mux, measure, return value
      }
      if(ldd_u8_rd_SysM4()!=0xFF)  {                                            // 0xFF is escape char / don't SPI-MUX
        SPI_Write(erAMUXCR, ldd_u8_rd_SysM4());                                  // set analog mux
        ldd_u16_wr_SysS45(*ADC_Value10(ldd_u8_rd_SysM5()));                     // set mcu mux, measure, return value
      }

 			SPI_Write(erAMUXCR, tmp);                                                  // restore (none intrusive) 
#endif

      
      LinMsgStatus[SysResponseMsgIdx] = LIN_MSG_UPDATED;
      
    // --------------------------------------------                           
    // Tools
    // --------------------------------------------
    }else if(ldd_u8_rd_SysCMD() == ldd_TOOLS)   {                               // Tools

      if(ldd_u8_rd_SysM0()== 0x81)  {                                           // Reset ILAD
        asm JMP $2000;
      }else if(ldd_u8_rd_SysM0()== 0x82)  {                                     // Reset ILOP
        asm DCB $32;                                        
      }else if(ldd_u8_rd_SysM0()== 0x01)  {                                     // LIN Info 1
        ldd_u16_wr_SysS01(LIN_IDLETIMEOUT);  
        ldd_u8_wr_SysS2(LIN_BAUDRATE);    
        ldd_u8_wr_SysS3(LIN_SCIPRESCALERDIVISOR);    
#if defined (LIN_SYNC_SLAVE)      
        ldd_u8_wr_SysS4(1);    
#else      
        ldd_u8_wr_SysS4(0);    
#endif           
      }else if(ldd_u8_rd_SysM0()== 0x02)  {                                     // LIN Info  2
        l_ifc_ioctl_sci08(l_op_getsyncpd, &tmp);
        ldd_u8_wr_SysS0(tmp);    
        
        l_ifc_ioctl_sci08(l_op_getrxerr, &tmp);
        ldd_u8_wr_SysS1(tmp);    

        l_ifc_ioctl_sci08(l_op_gettxerr, &tmp);
        ldd_u8_wr_SysS2(tmp);  
          
        ldd_u8_wr_SysS3(255);    
        ldd_u8_wr_SysS4(255);    
        ldd_u8_wr_SysS5(255);    
      }
      LinMsgStatus[SysResponseMsgIdx] = LIN_MSG_UPDATED;
    }
  }


}
