#ifndef LINCFG_H
#define LINCFG_H
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lincfg.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Driver static configuration file for Freescale API
*														                            
* Description:  This is a template file for LIN driver configuration.
*														                            
* Notes:        
*														                            
******************************************************************************/

/*
    This definition set the number of user-defined timer clocks
    (LIN_IdleClock service calls), recognized as "no-bus-activity" 
    condition.
    This number shall not be greater than 0xFFFF.

#define LIN_IDLETIMEOUT         100u
*/


#if defined(HC08EY16)

/*
	This definition configures the LIN bus baud rate.
	Note: this value shall be set according to target MCU 
	SCI register usage.
	HC08FY4: the 8-bit value is masked by 0x37
	and put into SCBR register;
*/

#define LIN_BAUDRATE			          0x01u                   // 9600 Baud without prescaler

/*
  This definition configures the SCI Prescaler default value
  Note: the value has to be within ????
*/


#define LIN_SCIPRESCALER            0x60u                   // divide by 4 (4,9152MHz)


// --------------------------------------------------------
// Baudrate Synchronisation will be performed
#define LIN_SYNC_SLAVE                                      


#endif /* defined(HC08EY16) */


#endif /* !define (LINCFG_H) */
