#ifndef LINERR_H
#define LINERR_H

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linerr.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Error module header file
*														                            
* Description:  
*														                            
* Notes:
*														                            
******************************************************************************/

/****************************************************************************
 * All extern declarations of common-purpose RAM variables shall be here.
 ***************************************************************************/
#if defined(HC08) || defined (S08)
#if defined(CW08)
#pragma DATA_SEG SHORT ZeroSeg
#endif /* defined(CW08) */
#endif /* defined(HC08)	|| defined (S08)*/

extern LINErrCounterType LIN_ErrTxCounter;       /* Shift counter for Tx errors */
extern LINErrCounterType LIN_ErrRxCounter;       /* Shift counter for Rx errors */

#if defined(HC08) || defined (S08)
#if defined(CW08) 
#pragma DATA_SEG DEFAULT
#endif /* defined(CW08) */
#endif /* defined(HC08) || defined (S08)*/

/****************************************************************************/
/***                     Macros                                           ***/
/****************************************************************************/

#define LIN_ShiftRxErr()    LIN_ErrRxCounter >>= 1
#define LIN_ShiftTxErr()    LIN_ErrTxCounter >>= 1


/**************************************************************************
 * Function :   LIN_SetRxErr
 *
 * Description: Shift Rx error counter and set high bit
 *
 * Returns:     none
 *
 * Notes:       none
 *
 **************************************************************************/
#if defined(CW08)
#define LIN_SetRxErr()                                  \
        asm SEC;                                        \
        asm LDHX  @LIN_ErrRxCounter;                    \
        asm ROR ,X
#endif /* defined(CW08) */

#if defined(COSMIC08)
#define LIN_SetRxErr()                                  \
        _asm ("xref	_LIN_ErrRxCounter");                \
        _asm ("SEC");                                   \
        _asm ("LDHX  #_LIN_ErrRxCounter");              \
        _asm ("ROR ,X")
#endif /* defined(COSMIC08) */


/**************************************************************************
 * Function :   LIN_SetTxErr
 *
 * Description: Shift Tx error counter and set high bit
 *
 * Returns:     none
 *
 * Notes:       none
 *
 **************************************************************************/
#if defined(CW08)
#define LIN_SetTxErr()                                  \
        asm SEC;                                        \
        asm LDHX  @LIN_ErrTxCounter;                    \
        asm ROR ,X
#endif /* defined(CW08) */

#if defined(COSMIC08)
#define LIN_SetTxErr()                                  \
        _asm ("xref	_LIN_ErrTxCounter");                \
        _asm ("SEC");                                   \
        _asm ("LDHX  #_LIN_ErrTxCounter");              \
        _asm ("ROR ,X")
#endif /* defined(COSMIC08) */


#endif /* !define (LINERR_H) */
