#ifndef LINSCI_H
#define LINSCI_H

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linsci.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    SCI routins header file
*														                            
* Description:  
*														                            
* Notes:        
*														                            
******************************************************************************/

/****************************************************************************
 * All extern declarations of common-purpose RAM variables shall be here.
 ***************************************************************************/

/****************************************************************************
 * Some of the variables (more often used) can be declared using LIN_ZPAGE
 * modifier (applicable only for HC08).
 * It require to perform zero page RAM placement optimisation.
 ***************************************************************************/

#if defined(HC08) || defined (S08)
#if defined(CW08)
#pragma DATA_SEG SHORT ZeroSeg
#endif /* defined(CW08) */
#endif /* defined(HC08)	|| defined (S08)*/

extern LIN_ZPAGE LIN_BYTE LIN_TmpSCIStatus;     /* byte to clear SCI status, and to receive byte   */

#if defined(HC08) || defined (S08)
#if defined(CW08) 
#pragma DATA_SEG DEFAULT
#endif /* defined(CW08) */
#endif /* defined(HC08) || defined (S08)*/

/****************************************************************************/
/***                     Functions                                        ***/
/****************************************************************************/

#if !defined(LINAPI_1_0)
void LIN_SCIInit( void );
#endif /* !defined(LINAPI_1_0) */


/****************************************************************************/
/***                     Interrupt Driven routins                         ***/
/****************************************************************************/

#if !defined(LINAPI_1_0)

LIN_INTERRUPT LIN_ISR_SCI_Receive  ( void ); /* SCI receive interrupt */
LIN_INTERRUPT LIN_ISR_SCI_Error    ( void ); /* SCI error interrupt */

#endif /* !defined(LINAPI_1_0) */

/****************************************************************************/
/***                     Macros                                           ***/
/****************************************************************************/

#define    LIN_SCDRPut(data)     ( LIN_SCDR = (data) )


/* Tx pin inversion */
#define LIN_SCITxInvEnable()    ( LIN_SCC1 |= LIN_SCC1_TXINV )

/* Cancel Tx pin inversion */
#define LIN_SCITxInvDisable()   ( LIN_SCC1 &= ~LIN_SCC1_TXINV )


/**************************************************************************
 * Function :   LIN_SCISendWakeup
 *
 * Description: Send Wakeup message
 *
 * Returns:     none
 *
 * Notes:       Slave  -- SCI Rx interrupt used
 *
 **************************************************************************/
#define WAKEUP_BYTE             0x80

/* ------------------------------------------------------------- HC08AZ32 */
#if defined(SLAVE)
#define LIN_SCISendWakeup()                                                                     \
        LIN_TmpSCIStatus = LIN_SCS1;            /* Read SCI status register to clear it */      \
        LIN_SCDRPut(WAKEUP_BYTE)                /* Send wakeup frame */  
#endif /* defined(SLAVE) */



#endif /* !define (LINSCI_H) */