#ifndef LINSTD_H
#define LINSTD_H

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linstd.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    Define LIN driver data types
*														                            
* Description:
*														                            
* Notes:        
*														                            
******************************************************************************/


/********************************* HC 08 ************************************/

typedef unsigned char LIN_BYTE;
typedef unsigned int  LIN_WORD;
typedef unsigned long LIN_DWORD;

#if    defined(CW08)

/* disable interrupt */
#define CLRI()      asm sei
/* enable interrupt */
#define SETI()      asm cli

#define LIN_ZPAGE                           /* zero page variable placement modifier - empty,   */
                                            /* due to zero page segment is defined by           */
                                            /* HiCross compiler pragma                          */
#define LIN_INTERRUPT       interrupt void  /* interrupt service routine modifier               */

#endif /*   defined(CW08) */
#if  defined(COSMIC08)

/* disable interrupt */
#define CLRI()      _asm("sei")
/* enable interrupt */
#define SETI()      _asm("cli")

#define LIN_ZPAGE @tiny                     /* zero page variable placement modifier    */

#define LIN_INTERRUPT       @interrupt      /* interrupt service routine modifier       */

#endif /* end defined(COSMIC08)    */     

/**************************** end  HC 08 ************************************/


/* Extern declaration of lincfg.c user-defined constants */

/* NB: equivalence with LIN_CfgConst definition in lincfg.c/l_cfg.c */
extern const struct
{
    unsigned int    LIN_IdleTimeoutClocks;  /* number of LIN_IdleClock() calls per LIN idle timeout */
    unsigned char   LIN_BaudRate;           /* LIN baud rate setting */
    unsigned char   LIN_SciPreScaler;       /* default SCI Prescaler value */
    unsigned char   LIN_SciSyncPreScaler;   /* SCI Prescaler value during sync - workaround for the delemiter problem*/
    unsigned char   LIN_SyncEnable;         /* Synchronization static flag */
    unsigned char   LIN_BaudRateDivisor;    /* BaudRate divisor for sync formula */
    unsigned char   LIN_ESCIClockMultiplier; //ESCI source clock CONFIG2 register!!!!    
    

} LIN_CfgConst;

#if defined(LINAPI_1_0)
extern const l_u8               LinFlagLookup[];
extern const l_u8               LinSigMaxIdx;
extern       l_u8               LinSigFlags[];
#endif /* defined(LINAPI_1_0) */

#if defined(SLAVE)
extern const LINMsgIdType       LinMsgId[];
extern const LIN_MSGLENGTHTYPE  LinMsgLen[];
#endif /* defined(SLAVE) */

extern const LINMsgRefType      LinMsgBuf[];
extern const LIN_BYTE           LinListSize;
extern       LINStatusType      LinMsgStatus[];

extern const LIN_BYTE           LinLookupTable[];

#endif /* !define (LINSTD_H) */
