#ifndef REGS_H
#define REGS_H

/******************************************************************************
*                                                                     
*       Copyright (C) 2005 Freescale Semiconductor, Inc.              
*       All Rights Reserved								              
*														              
* Filename:     regs.h                
*														              
* Revision:      										              
*														              
* Functions:    Register definition file for HC08
*												                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/****************************************************************************/
/******************************** HC 08 *************************************/
/****************************************************************************/

#if  defined(COSMIC08)

#endif /* defined(COSMIC08) */     

#if    defined(CW08)

#define    IOBYTE(address)    (*(( volatile unsigned char*) (address)))
#define    IOWORD(address)    (*(( volatile unsigned int*) (address)))

#endif /*   defined(CW08) */

#if    defined(COSMIC08)

/*  PORTS section
 */
@tiny volatile  unsigned char LIN_PTA    @0x00;  /* port A */
@tiny volatile  unsigned char LIN_PTB    @0x01;  /* port B */
@tiny volatile  unsigned char LIN_PTC    @0x02;  /* port C */
@tiny volatile  unsigned char LIN_PTD    @0x03;  /* port D */
@tiny volatile  unsigned char LIN_DDRA   @0x04;  /* data direction port A */
@tiny volatile  unsigned char LIN_DDRB   @0x05;  /* data direction port B */
@tiny volatile  unsigned char LIN_DDRC   @0x06;  /* data direction port C */
@tiny volatile  unsigned char LIN_DDRD   @0x07;  /* data direction port D */
@tiny volatile  unsigned char LIN_PTE    @0x08;  /* port E */
@tiny volatile  unsigned char LIN_DDRE   @0x0A;  /* data direction port E */

/* SPI section - doesn't need  */

/* SCI section	*/
@tiny volatile  unsigned char LIN_SCC1   @0x10;  /* SCI control register 1 */
@tiny volatile  unsigned char LIN_SCC2   @0x11;  /* SCI control register 2 */
@tiny volatile  unsigned char LIN_SCC3   @0x12;  /* SCI control register 3 */
@tiny volatile  unsigned char LIN_SCS1   @0x13;  /* SCI status register 1  */
@tiny volatile  unsigned char LIN_SCS2   @0x14;  /* SCI status register 2  */
@tiny volatile  unsigned char LIN_SCDR   @0x15;  /* SCI data register      */
@tiny volatile  unsigned char LIN_SCBR   @0x16;  /* SCI baud rate          */

/* INTERRUPT/KEYBOARD section - doesn't need */

/* PLL section - doesn't need */

/* OPTION section */

/* TIMER A section */
@tiny volatile  unsigned char LIN_TASC   @0x20;  /* timer A status/ctrl register */
@tiny volatile  unsigned int  LIN_TACNT  @0x21;  /* timer A counter register     */
@tiny volatile  unsigned char LIN_TACNTH @0x21;  /* timer A counter high         */
@tiny volatile  unsigned char LIN_TACNTL @0x22;  /* timer A counter low          */
@tiny volatile  unsigned int  LIN_TAMOD  @0x23;  /* timer A modulo register      */
@tiny volatile  unsigned char LIN_TAMODH @0x23;  /* timer A modulo high          */
@tiny volatile  unsigned char LIN_TAMODL @0x24;  /* timer A modulo low           */
@tiny volatile  unsigned char LIN_TASC0  @0x25;  /* timer A chan 0 status/ctrl   */
@tiny volatile  unsigned int  LIN_TACH0  @0x26;  /* timer A chan 0 register      */
@tiny volatile  unsigned char LIN_TACH0H @0x26;  /* timer A chan 0 high          */
@tiny volatile  unsigned char LIN_TACH0L @0x27;  /* timer A chan 0 low           */
@tiny volatile  unsigned char LIN_TASC1  @0x28;  /* timer A chan 1 status/ctrl   */
@tiny volatile  unsigned int  LIN_TACH1  @0x29;  /* timer A chan 1 register      */
@tiny volatile  unsigned char LIN_TACH1H @0x29;  /* timer A chan 1 high          */
@tiny volatile  unsigned char LIN_TACH1L @0x2a;  /* timer A chan 1 low           */

/*  ICG section
 */
@tiny volatile  unsigned char LIN_ICGCR  @0x36; /* ICG Control         */
@tiny volatile  unsigned char LIN_ICGMR  @0x37; /* ICG Multiply        */
@tiny volatile  unsigned char LIN_ICGTR  @0x38; /* ICG Trim            */
@tiny volatile  unsigned char LIN_ICGDVR @0x39; /* ICG Divider Control */
@tiny volatile  unsigned char LIN_ICGDSR @0x3a; /* ICG Stage Control   */

/* ANALOG/DIGTAL section - doesn't need */

/* TIMER B section - doesn't need */

/* PIT section - doesn't need */

/* SIM section - doesn't need */

/* CAN section - doesn't need */

#endif /*   defined(COSMIC08) */

#if    defined(CW08)

/*  PORTS section
 */
#define    LIN_PTA        IOBYTE(0x00)       /* Port A */       
#define    LIN_PTB        IOBYTE(0x01)       /* Port B */       
#define    LIN_PTC        IOBYTE(0x02)       /* Port C */       
#define    LIN_PTD        IOBYTE(0x03)       /* Port D */       
#define    LIN_DDRA       IOBYTE(0x04)       /* Data Direction Register A */       
#define    LIN_DDRB       IOBYTE(0x05)       /* Data Direction Register B */       
#define    LIN_DDRC       IOBYTE(0x06)       /* Data Direction Register C */       
#define    LIN_DDRD       IOBYTE(0x07)       /* Data Direction Register D */       
#define    LIN_PTE        IOBYTE(0x08)       /* Port E */       
#define    LIN_DDRE       IOBYTE(0x0A)       /* Data Direction Register E */       

/* SPI section	*/

/* SCI section	*/
#define    LIN_SCC1     IOBYTE(0x10)        /* SCI control register 1               */
#define    LIN_SCC2     IOBYTE(0x11)        /* SCI control register 2               */
#define    LIN_SCC3     IOBYTE(0x12)        /* SCI control register 3               */
#define    LIN_SCS1     IOBYTE(0x13)        /* SCI status  register 1               */
#define    LIN_SCS2     IOBYTE(0x14)        /* SCI status  register 2               */
#define    LIN_SCDR     IOBYTE(0x15)        /* SCI data    register                 */
#define    LIN_SCBR     IOBYTE(0x16)        /* SCI baud rate                        */

#define    LIN_SCPSC    IOBYTE(0x17)        /* ESCI Prescaler		                */

/* ESCI Arbiter */
#define    LIN_SCIACTL  IOBYTE(0x18)        /* SCI Arbiter control	                */
#define    LIN_SCIADAT  IOBYTE(0x19)        /* SCI Arbiter data 	                */

#define     LIN_SCIA_AM1        0x80        /* Arbiter Mode Select	                */
#define     LIN_SCIA_ALOST      0x40        /* Arbitration lost flag                */
#define     LIN_SCIA_AM0        0x20        /* Arbiter Mode Select	                */
#define     LIN_SCIA_ACLK       0x10        /* Arbiter Counter Clock Select         */
#define     LIN_SCIA_AFIN       0x08        /* Arbiter Bit Time Measurement Finish  */
#define     LIN_SCIA_ARUN       0x04        /* Arbiter Counter Running              */
#define     LIN_SCIA_AROVFL     0x02        /* Arbiter Counter Overflow	            */


/*  INTERRUPT/KEYBOARD section - doesn't need */

/*  PLL section - doesn't need */

/*  OPTION section */

/*  TIMER A section */
#define    LIN_TASC   IOBYTE(0x20)  /* timer A status/ctrl register */
#define    LIN_TACNT  IOWORD(0x21)  /* timer A counter register     */
#define    LIN_TACNTH IOBYTE(0x21)  /* timer A counter high         */
#define    LIN_TACNTL IOBYTE(0x22)  /* timer A counter low          */
#define    LIN_TAMOD  IOWORD(0x23)  /* timer A modulo register      */
#define    LIN_TAMODH IOBYTE(0x23)  /* timer A modulo high          */
#define    LIN_TAMODL IOBYTE(0x24)  /* timer A modulo low           */
#define    LIN_TASC0  IOBYTE(0x25)  /* timer A chan 0 status/ctrl   */
#define    LIN_TACH0  IOWORD(0x26)  /* timer A chan 0 register      */
#define    LIN_TACH0H IOBYTE(0x26)  /* timer A chan 0 high          */
#define    LIN_TACH0L IOBYTE(0x27)  /* timer A chan 0 low           */
#define    LIN_TASC1  IOBYTE(0x28)  /* timer A chan 1 status/ctrl   */
#define    LIN_TACH1  IOWORD(0x29)  /* timer A chan 1 register      */
#define    LIN_TACH1H IOBYTE(0x29)  /* timer A chan 1 high          */
#define    LIN_TACH1L IOBYTE(0x2a)  /* timer A chan 1 low           */

/*  TIMER B section
 */
#define    LIN_TBSC   IOBYTE(0x40)  /* timer B status/ctrl register */

/*  TIMER A section for CW08 inline assembler  ???
 */
#define    _LIN_TASC   0x20 /* timer A status/ctrl register */
#define    _LIN_TACNT  0x21 /* timer A counter register     */
#define    _LIN_TACNTH 0x21 /* timer A counter high         */
#define    _LIN_TACNTL 0x22 /* timer A counter low          */
#define    _LIN_TAMOD  0x23 /* timer A modulo register      */
#define    _LIN_TAMODH 0x23 /* timer A modulo high          */
#define    _LIN_TAMODL 0x24 /* timer A modulo low           */
#define    _LIN_TASC0  0x25 /* timer A chan 0 status/ctrl   */
#define    _LIN_TACH0  0x26 /* timer A chan 0 register      */
#define    _LIN_TACH0H 0x26 /* timer A chan 0 high          */
#define    _LIN_TACH0L 0x27 /* timer A chan 0 low           */
#define    _LIN_TASC1  0x28 /* timer A chan 1 status/ctrl   */
#define    _LIN_TACH1  0x29 /* timer A chan 1 register      */
#define    _LIN_TACH1H 0x29 /* timer A chan 1 high          */
#define    _LIN_TACH1L 0x2a /* timer A chan 1 low           */

/* ICG section */
#define    LIN_ICGCR   IOBYTE(0x36)  /* ICG Control         */
#define    LIN_ICGMR   IOBYTE(0x37)  /* ICG Multiply        */
#define    LIN_ICGTR   IOBYTE(0x38)  /* ICG Trim            */
#define    LIN_ICGDVR  IOBYTE(0x39)  /* ICG Divider Control */
#define    LIN_ICGDSR  IOBYTE(0x3a)  /* ICG Stage Control   */
 
/* ANALOG/DIGTAL section - doesn't need */

/* TIMER B section - doesn't need */

/* PIT section - doesn't need */

/* SIM section - doesn't need */

/* CAN section - doesn't need */

#endif /* defined(CW08) */

/******************* Bit masks *************************/

/* define bit mask for SCI */
#define     LIN_SCC1_LOOPS      0x80        /* Loop Mode Select bit              in SCC1 */
#define     LIN_SCC1_ENSCI      0x40        /* Enable SCI bit                    in SCC1 */
#define     LIN_SCC1_TXINV      0x20        /* Transmit Invert bit               in SCC1 */
#define     LIN_SCC1_M          0x10        /* Mode (character lenght)           in SCC1 */
#define     LIN_SCC1_WAKE       0x08        /* Wake-up condition bit             in SCC1 */
#define     LIN_SCC1_ILTY       0x04        /* Idle line type bit                in SCC1 */
#define     LIN_SCC1_PEN        0x02        /* Parity Ebnable bit                in SCC1 */
#define     LIN_SCC1_PTY        0x01        /* Parity bit                        in SCC1 */

#define     LIN_SCC2_SCTIE      0x80        /* SCI Transmit interrupt enable bit in SCC2 */
#define     LIN_SCC2_TCIE       0x40        /* Transfer complited intrerrupt enable SCC2 */
#define     LIN_SCC2_SCRIE      0x20        /* SCI Recive interrupt              in SCC2 */
#define     LIN_SCC2_ILIE       0x10        /* Idle line interrupt ebable        in SCC2 */
#define     LIN_SCC2_TE         0x08        /* Transmitter enable bit            in SCC2 */
#define     LIN_SCC2_RE         0x04        /* Receiver enable bit               in SCC2 */
#define     LIN_SCC2_RWU        0x02        /* Receiver wake-up bit              in SCC2 */
#define     LIN_SCC2_SBK        0x01        /* Send Break bit                    in SCC2 */

#define     LIN_SCC3_R8         0x80        /* Received bit 8                    in SCC3 */
#define     LIN_SCC3_T8         0x40        /* Transmitted bit 8                 in SCC3 */
#define     LIN_SCC3_DMARE      0x20        /* DMA receiver enable bit           in SCC3 */
#define     LIN_SCC3_DMATE      0x10        /* DMA transfer enable bit           in SCC3 */
#define     LIN_SCC3_ORIE       0x08        /* Receiver overrun interrupt enable in SCC3 */
#define     LIN_SCC3_NEIE       0x04        /* Receiver noise error interrup enb.   SCC3 */
#define     LIN_SCC3_FEIE       0x02        /* Receiver framing error interrup enb. SCC3 */
#define     LIN_SCC3_PEIE       0x01        /* Receiver parity error interrup enb.  SCC3 */

#define     LIN_SCS1_SCTE       0x80        /* SCI transmitter empty bit         in SCS1 */
#define     LIN_SCS1_TC         0x40        /* Transmission complite bit         in SCS1 */
#define     LIN_SCS1_SCRF       0x20        /* SCI receiver full bit             in SCS1 */
#define     LIN_SCS1_IDLE       0x10        /* Receiver idle bit                 in SCS1 */
#define     LIN_SCS1_OR         0x08        /* Receiver overrun bit              in SCS1 */
#define     LIN_SCS1_NF         0x04        /* Receiver noise flag bit           in SCS1 */
#define     LIN_SCS1_FE         0x02        /* Receiver framing error bit        in SCS1 */
#define     LIN_SCS1_PE         0x01        /* Receiver parity error bit         in SCS1 */

#define     LIN_SCS2_BKF        0x02        /* Break Flag bit                    in SCS2 */
#define     LIN_SCS2_RPF        0x01        /* Reception in progress flag bit    in SCS2 */

#define     LIN_SCBR_SCP        0x30        /* SCP1 SCP0 - Baude Rate Prescaler bits SCBR */
#define     LIN_SCBR_SCR        0x07        /* SCR2 - SCR0 Baude Rate Select bits in SCBR */

/* bit masks for PIT NOT EY16!! */

#define     LIN_PSC_POF         0x80        /* PIT overflow bit */
#define     LIN_PSC_PIE         0x40        /* PIT overflow interrupt enable bit */
#define     LIN_PSC_PSTOP       0x20        /* PIT STOP bit */
#define     LIN_PSC_PRST        0x10        /* PIT Reset bit  */
#define     LIN_PSC_PPS         0x07        /* Prescaler select bits */

/* bit masks for Timer Module (TIMA) */

#define     LIN_TM_PR           0x07        /* TIM Prescaler bits */
#define     LIN_TM_TSTOP        0x20        /* TIM Stop bit */

/* bit masks for TIMA Channel x */

#define     LIN_TM_CHXF        0x80        /* Channel x flag bit                */
#define     LIN_TM_CHXIE       0x40        /* Channel x interrupt enable bit    */
#define     LIN_TM_MSXB        0x20        /* Channel x Mode Select bit B       */
#define     LIN_TM_MSXA        0x10        /* Channel x Mode Select bit A       */
#define     LIN_TM_ELSXB       0x08        /* Channel x Edge/Level Select bit B */
#define     LIN_TM_ELSXA       0x04        /* Channel x Edge/Level Select bit A */
#define     LIN_TM_TOVX        0x02        /* Channel x Toggle-On-Overflow bit  */
#define     LIN_TM_CHXMAX      0x01        /* Channel x Maximum Duty Cycle bit  */

/* Mask option registers bit */
#define     LIN_MORA_SEC        0x40        /* ROM security bit                             */
#define     LIN_MORA_LVIRSTD    0x20        /* LVI reset enable bit                         */
#define     LIN_MORA_LVIPWRD    0x10        /* LVI power enable bit                         */
#define     LIN_MORA_SSREC      0x08        /* Short stop recovery bit                      */
#define     LIN_MORA_COPRS      0x04        /* COP rate select                              */
#define     LIN_MORA_STOP       0x02        /* STOP enable bit                              */
#define     LIN_MORA_COPD       0x01        /* COP disable bit                              */
            
#define     LIN_MORB_EESEC      0x20        /* EEPROM security bit                          */

/* SIM (System Integrated) module */
#define     LIN_SRSB_SBSW        0x02        /* SIM break STOP/WAIT              */

#define     LIN_SRSR_POR         0x80        /* Power on reset bit               */
#define     LIN_SRSR_PIN         0x40        /* External reset bit               */
#define     LIN_SRSR_COP         0x20        /* Computer operated properly bit   */
#define     LIN_SRSR_ILOP        0x10        /* Illegal opcode reset bit         */
#define     LIN_SRSR_ILAD        0x08        /* Illegal addres reset bit         */
#define     LIN_SRSR_LVI         0x02        /* Low voltage inhibit reset bit    */

#define     SBFCR_BCFE       0x80        /* Break clear flag enable bit      */

/* general purpose I/O pins number */
#define     LIN_PIN0    0x01
#define     LIN_PIN1    0x02
#define     LIN_PIN2    0x04
#define     LIN_PIN3    0x08
#define     LIN_PIN4    0x10
#define     LIN_PIN5    0x20
#define     LIN_PIN6    0x40
#define     LIN_PIN7    0x80

#endif /* !define (REGS_H) */
