#define LINTMR_C
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lintmr.c                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Timeout management module 
*												                            
* Description:  
*												                            
******************************************************************************/

#include <linbase.h>

#pragma MESSAGE DISABLE C4200 /* WARNING C4200: other segment than in previous declaration */

/****************************************************************************
 * All common-purpose RAM variables shall be declared here.
 ***************************************************************************/
#if defined(HC08) || defined (S08)
#if defined(CW08)
#pragma DATA_SEG SHORT ZeroSeg
#endif /* defined(CW08) */
#endif /* defined(HC08)	|| defined (S08)*/

LIN_WORD LIN_IdleTimeout;          /* counter for idle timeout */

#if defined(HC08) || defined (S08)
#if defined(CW08) 
#pragma DATA_SEG DEFAULT
#endif /* defined(CW08) */
#endif /* defined(HC08) || defined (S08)*/

#if !defined(LINAPI_1_0)


/***************************************************************************
 * Function :   LIN_IdleClock
 *
 * Description: User time clock for Idle timeout.
 *              Update "no-bus-activity" condition counter
 *              and check, if the condition meets.
 *                 
 * Returns:     none
 *
 * Notes:       1. API Service call       
 *
 **************************************************************************/
void LIN_IdleClock( void ) 
{
    LIN_BYTE        intMask;

    LIN_DBG_SET_PORT_7;

    intMask = LIN_DisableInt();         /* Disable interrupts -- do we really need it? */

    if ( LIN_IdleTimeout != 0  )
        {
            --LIN_IdleTimeout;
        }

    LIN_EnableInt(intMask);             /* enable interrupts */    

    LIN_DBG_CLR_PORT_7;
}

#endif /* !defined(LINAPI_1_0) */

/***************************************************************************
 * Function :   LIN_SetIdleTimeout
 *
 * Description: Set/reset LIN_IdleTimeout variable from constant
 *                 
 * Returns:     none
 *
 * Notes:       
 *
 **************************************************************************/
void LIN_SetIdleTimeout( void )
{
    LIN_IdleTimeout = LIN_CfgConst.LIN_IdleTimeoutClocks;
}
