// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_FLASH.C,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.3 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  FLASH program erase Routines
//								for AdrenaLIN 68HC908EY16 MCU
//								using the ROM code
//
//  Notes:        
//
//
//
// ========================================================
#ifndef _908EY16_FLASH_C
#define _908EY16_FLASH_C

#include "Types.h"

#include "908EY16_Flash.h"
#include "908EY16_IO.h"
#include "Hicross.h"


//---------------------------------------------------------
#pragma DATA_SEG FLASH_RAM

struct tFlashInterface  FI; 

#pragma DATA_SEG DEFAULT
//---------------------------------------------------------
// returns a pointer to the 32 byte data area
UINT8 *Flash_GetDataPointer(void)  {

  return FI.Data;
}


//---------------------------------------------------------
// programs less than 32 byte !!!!
BOOLEAN Flash_ProgByte(UINT16 dstadr, UINT8 len)  {
BOOLEAN result;
  
  sei();                                                    // stop all other activities, like LIN


  // set some options
  FI.CPUSpeed = CPU_SPEED*4;                                // using ~5MHz F_bus
  FI.LastAddr = dstadr+len-1;                                     // embedded routine uses last adress in range (not count)

  // execute embedded routine  
  asm {
                LDHX dstadr;                                // start adress location in H:X
                JSR  PRGRNGE;
                LDA  #1
                BCS  SUCCESS                                // set carry indicates success
                CLRA 
SUCCESS:        STA  result    
  }


  cli();                                                    // restart other activities
  return result;
}

//---------------------------------------------------------
// The Flash organized in ROWS a 32 byte 
// Programming always has to access a complete row
// User has to make sure that the access is page wise !!!
// which means values are 32 byte and 
// adress must be XXX0, XX20, XX40 ...
//
BOOLEAN Flash_ProgRow(UINT16 adress, UINT8 *values)  {
UINT8 i;
BOOLEAN result;
  
  sei();                                                    // stop all other activities, like LIN


  // set some options
  FI.CPUSpeed = CPU_SPEED*4;                                  // using ~5MHz F_bus
  FI.LastAddr = ((UINT16)adress)+FLASH_ROWSIZE-1;            // embedded routine uses last adress in range (not count)
  for(i=0;i<FLASH_ROWSIZE;i++)
    FI.Data[0+i] = *(values+i);

  // execute embedded routine  
  asm {
                LDHX adress;                                // start adress location in H:X
                JSR  PRGRNGE;
                LDA  #1
                BCS  SUCCESS                                // set carry indicates success
                CLRA 
SUCCESS:        STA  result    
  }


  cli();                                                    // restart other activities
  return result;
}


//---------------------------------------------------------
// The Flash organized in Pages a 64 byte
// Erased can be only a whole Page (OR MASS ERASE)
// User has to make sure that the access is page wise !!!
// adress must be XX00, XX40 ...
//
//void Flash_ErasePage(UINT8 *adress)  {
void Flash_ErasePage(UINT16 adress)  {
  
  sei();                                                    // stop all other activities, like LIN
  
  // -----  set some options
  FI.CtrlByte = 0 ;                                           // delete a single page
  FI.CPUSpeed = 4*CPU_SPEED;                                  // cpu frequency times 4 (using ~5MHz F_bus)

  // -----  execute embedded routine  
  asm {
    LDHX adress;                                            // start adress location in H:X
    JSR  ERARNGE;
  }


  cli();                                                    // restart other activities
}

#endif  // _908EY16_FLASH_C


