// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_Halt.c,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.3 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  MON08 HALT support routines
//								for AdrenaLIN 68HC908EY16 MCU
//                Halt allows to stop a running application 
//                in the debugger (Mon08)
//
//
//  Notes:        removed the "workspace" mechanism as its
//                not support in CW08 >V3.0  
//
//
//
// ========================================================
#define  _908EY16_HALT_C

// --------------------------------------------------------
#include "908EY16_HALT.h"

extern void isrHWIRQ();                                     // External HW IRQ



// --------------------------------------------------------
// HC08 MON08 Target Interface
// HALT Command is realized via IRQ 
// in assembler to avoid stack disalignment (stack usage)
//
//      Timing for HALT                  
//      \IRQ   \_/      ca. 10us
//      DATA   \_______/      ca. 100us
//
//      Timing for other IRQs
//      \IRQ   \__/      
//      DATA         
// --------------------------------------------------------
void isrHALT(void) {

  if(rPORTA&bPTA0) {
    asm  JMP isrHWIRQ;                                      // normal IRQ reason
  }else{
    asm{
         __irql:   BIL __irql                               // wait till IRQ high 
              SWI
              RTI														                // do a single step and you are back in the "normal" source code
    }
  }
}


