// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_SPI.c,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.5 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  SPI support routines
//								for AdrenaLIN 68HC908EY16 MCU
//
//
//  Notes:        use global variable SPIInfo to retrieve
//								return values for SPI_Read / SPI_Write 
//
//
// ========================================================
#define  _908EY16_SPI_C

// --------------------------------------------------------
#include "908EY16_SPI.h"

//---------------------------------------------------------
#define DisableInt()        { asm tpa; asm sei; asm psha;}    
#define EnableInt()         { asm pula; asm tap; }

#define SPI_Enable()        (rSPCR |= bSPE)                 //(Macro version)
#define SPI_Disable()       (rSPCR &= ~bSPE)                //(Macro version)



// -----  global variables --------------------------------
#if   defined(CAIRON)
  static UINT8 fSPIRegs[0x0C+1];
#endif 

#if defined(SHADOW)
  static UINT8 fSPIRegs[0x11+1];
#endif 

#if defined(QUAILMAX)
  static UINT8 fSPIRegs[0x11+1];
#endif

#if defined(LEVANTAR)
  static UINT8 fSPIRegs[0x16];
#endif



// -----  funtion prototypes  -----------------------------

// --------------------------------------------------------
// SPI Master adress is calculated like this:
//
// bit7 bit6 bit5 bit4 bit3 bit2 bit1 bit0
// r/w  A4   A3   A2   A1   A0   P    X
//  |              |             |    +------  don't care
//  |              |             +-----------  parity (evens number of '1's)
//  |              +-------------------------  SPI adress
//  +----------------------------------------  r/w access  1:read   0:write
//
// parity is only evaluated during write access
// usage SPIWrite( [SPIMasterAdress[adr]] )
// usage SPIRead ( [SPIMasterAdress[adr]] )   parity is ignored for read!!

#if   defined(CAIRON)
const unsigned char SPIMasterAdress[0x0C+1] = {             //  r/w  SPI adr  parity
         (0x00<<2)       ,                                  //   0   0x00       1 (dummy,not used)
         (0x01<<2) | 0x02,                                  //   0   0x01       0
         (0x02<<2) | 0x02,                                  //   0   0x02       0
         (0x03<<2)       ,                                  //   0   0x03       1
         (0x04<<2) | 0x02,                                  //   0   0x04       0
         (0x05<<2)       ,                                  //   0   0x05       1
         (0x06<<2)       ,                                  //   0   0x06       1
         (0x07<<2) | 0x02,                                  //   0   0x07       0
         (0x08<<2) | 0x02,                                  //   0   0x08       0
         (0x09<<2)       ,                                  //   0   0x09       1
         (0x0A<<2)       ,                                  //   0   0x0A       1
         (0x0B<<2) | 0x02,                                  //   0   0x0B       0
         (0x0C<<2)                                          //   0   0x0C       1
};
#endif 

#if defined(SHADOW)
const unsigned char SPIMasterAdress[0x11+1] = {             //  r/w  SPI adr  parity
         (0x00<<2)       ,                                  //   0   0x00       1
         (0x01<<2) | 0x02,                                  //   0   0x01       0
         (0x02<<2) | 0x02,                                  //   0   0x02       0
         (0x03<<2)       ,                                  //   0   0x03       1
         (0x04<<2) | 0x02,                                  //   0   0x04       0
         (0x05<<2)       ,                                  //   0   0x05       1
         (0x06<<2)       ,                                  //   0   0x06       1
         (0x07<<2) | 0x02,                                  //   0   0x07       0
         (0x08<<2) | 0x02,                                  //   0   0x08       0
         (0x09<<2)       ,                                  //   0   0x09       1
         (0x0A<<2)       ,                                  //   0   0x0A       1
         (0x0B<<2) | 0x02,                                  //   0   0x0B       0
         (0x0C<<2)       ,                                  //   0   0x0C       1
         (0x0D<<2) | 0x02,                                  //   0   0x0D       0
         (0x0E<<2) | 0x02,                                  //   0   0x0E       0        
         (0x0F<<2)       ,                                  //   0   0x0F       1        
         (0x10<<2) | 0x02,                                  //   0   0x10       0                          
         (0x11<<2)                                          //   0   0x11       1                 
};
#endif 

#if defined(QUAILMAX)
const unsigned char SPIMasterAdress[0x11+1] = {             //  r/w  SPI adr  parity
         (0x00<<2)       ,                                  //   0   0x00       1
         (0x01<<2) | 0x02,                                  //   0   0x01       0
         (0x02<<2) | 0x02,                                  //   0   0x02       0
         (0x03<<2)       ,                                  //   0   0x03       1
         (0x04<<2) | 0x02,                                  //   0   0x04       0
         (0x05<<2)       ,                                  //   0   0x05       1
         (0x06<<2)       ,                                  //   0   0x06       1
         (0x07<<2) | 0x02,                                  //   0   0x07       0
         (0x08<<2) | 0x02,                                  //   0   0x08       0
         (0x09<<2)       ,                                  //   0   0x09       1
         (0x0A<<2)       ,                                  //   0   0x0A       1
         (0x0B<<2) | 0x02,                                  //   0   0x0B       0
         (0x0C<<2)       ,                                  //   0   0x0C       1
         (0x0D<<2) | 0x02,                                  //   0   0x0D       0
         (0x0E<<2) | 0x02,                                  //   0   0x0E       0        
         (0x0F<<2)       ,                                  //   0   0x0F       1        
         (0x10<<2) | 0x02,                                  //   0   0x10       0                          
         (0x11<<2)                                          //   0   0x11       1                 
};
#endif


//---------------------------------------------------------
//	
//   --------									   ----------
//  |        | ------SS-------> |PU	  		 |
//  |  MCU   | -----SPSCLK----> |PD   SMOS |
//  |        | -----MOSI------> |PD 			 |
//  |        | <-----MISO-----  |Tri			 |
//   --------										 ----------
//
//   PU: Pull Up   
//   PD: Pull Down 
//   Tri: TriState input 
//
//	 the right configuration of the SPI interface pins is required
//   in particular in STOP mode
//
void SPI_Init(void)  {                                      // Initialize SPI 

  // slave select SS (SS is manual handled) 
  __SS_DDR |= __SS_PIN;
  __SS_PORT|= __SS_PIN;

  // spi clock SPSCK (spi off state)                        // between spi blocks and for low power modes)
  __SPSCK_PORT &= ~__SPSCK_PIN;                             // SPICLK low
  __SPSCK_DDR	 |= __SPSCK_PIN;															// SPICLK output

  // data out MOSI (spi off state)                          // between spi blocks and for low power modes)
  __MOSI_PORT &= ~__MOSI_PIN;					                      // low
  __MOSI_DDR  |= ~__MOSI_PIN;																// output

  // data in MISO (spi off state)                           // between spi blocks and for low power modes)
  __MISO_PORT &= ~__MISO_PIN;                               // low
  __MISO_DDR  |= ~__MISO_PIN;                               // output (because input is Tristate!!


  rSPCR = bSPMSTR | bCPHA;                                  // SPI as Master, transmission format CPHA=1

#if defined(LEVANTAR)
  fSPIRegs[erSTATUS] = 0;                                   // init status register
  
  // reset status of control registers (can not be read from device)
  fSPIRegs[erMCR]    = 0b1100;
  fSPIRegs[erWUCR]   = 0b1111;
  fSPIRegs[erLINCR]  = 0b0000;
  fSPIRegs[erHSCR]   = 0b0000;
  fSPIRegs[erLSCR]   = 0b0000;
  fSPIRegs[erTIMCR]  = 0b000;
  fSPIRegs[erAMUXCR] = 0b1000;
  fSPIRegs[erCFR]    = 0b0000;
  fSPIRegs[erIMR]    = 0b1111;
  
#endif

#if defined(SHADOW)
#warning "WORKAROUND - The registers erSYSTRIM2 and erSYSTRIM3 allways read 0!!!!"
  fSPIRegs[erSYSTRIM2] = 0;
  fSPIRegs[erSYSTRIM3] = 0;
#endif  

}

//---------------------------------------------------------
#if      defined(__2_4_BIT_SPI)
void SPI_Write(UINT8 add, UINT8 data)  {
  UINT8 tmp;

  DisableInt();                                             // selective disable IRQ and remember state of I mask

  rSPCR |= bSPE;                                            // Enable SPI

  while((rSPSCR&bSPTE)==0);                                 // ok for send?
   __SS_PORT &= ~__SS_PIN;                                  // start transfer SSB-> low
  rSPDR = ((add&0x0F)<<4) | (data&0x0F);                    // load add(incl. R/W) and data
  while((rSPSCR&bSPRF)==0);                                 // ok to received? (Receiver full?)
  tmp = rSPDR;

  fSPIRegs[add] = (data&0x0F);                              // copy of written data

  fSPIRegs[erSTATUS] |= (tmp&0xF0);                         // any write returns status


  __SS_PORT |= __SS_PIN;                                    // stop transfer SSB-> high
 
  rSPCR &= ~bSPE;                                           // Disable SPI

  EnableInt();                                              // only enable IRQ if it was enabled at entry
  

}
#endif //defined(__2_4_BIT_SPI)
//---------------------------------------------------------
#if      defined(__2_4_BIT_SPI)
void SPI_Read(UINT8 add)  {
  UINT8 tmp;


if((add&0x01)&&(add!=erCFR))  {                             // if a write register!!!

  DisableInt();                                             // selective disable IRQ and remember state of I mask

  rSPCR |= bSPE;                                            // Enable SPI

  while((rSPSCR&bSPTE)==0);                                 // ok for send?
   __SS_PORT &= ~__SS_PIN;                                  // start transfer SSB-> low
  rSPDR = ((add&0x0F)<<4) | 0x00;                           // load add(incl. R/W) and anything 
  
  while((rSPSCR&bSPRF)==0);                                 // ok to received? (Receiver full?)
  tmp = rSPDR;

  fSPIRegs[add] = (tmp&0x0F);                               // read register            (low  nibble)
  fSPIRegs[erSTATUS] |= (tmp&0xF0);                         // any write returns status (high nibble)


  __SS_PORT |= __SS_PIN;                                    // stop transfer SSB-> high
 
  rSPCR &= ~bSPE;                                           // Disable SPI

  EnableInt();                                              // only enable IRQ if it was enabled at entry
  
}

}
#endif //defined(__2_4_BIT_SPI)
//---------------------------------------------------------
#if      defined(__2_4_BIT_SPI)
UINT8 SPI_RegValue(UINT8 add) {

#warning " maybe this should always return high nibble of erSTATUS???"

  return fSPIRegs[add];
}
#endif //defined(__2_4_BIT_SPI)







// --------------------------------------------------------
#if      defined(__8_BIT_SPI)

UINT8 SPI_ReadWrite(UINT8 data)  {
  UINT8 tmp;

  DisableInt();                                             // selective disable IRQ and remember state of I mask

  rSPCR |= bSPE;                                            // Enable SPI

  while((rSPSCR&bSPTE)==0);                                 // ok for send?
   __SS_PORT &= ~__SS_PIN;                                  // start transfer SSB-> low
  rSPDR = data;                                             // load data
  while((rSPSCR&bSPRF)==0);                                 // ok to received? (Receiver full?)
  tmp = rSPDR;

  __SS_PORT |= __SS_PIN;                                    // stop transfer SSB-> high
 
  rSPCR &= ~bSPE;                                           // Disable SPI

  EnableInt();                                              // only enable IRQ if it was enabled at entry
  return tmp;                                               // irq fest, da immer letzter wert!!!!????

}

#endif //defined(__8_BIT_SPI)
//---------------------------------------------------------
#if      defined(__16_BIT_SPI)
void SPI_Write(UINT8 add, UINT8 data)  {

  DisableInt();                                             // selective disable IRQ and remember state of I mask

  rSPCR |= bSPE;                                            // Enable SPI

  while((rSPSCR&bSPTE)==0);                                 // ok for send?
  __SS_PORT &= ~__SS_PIN;                                   // start transfer SSB-> low
  rSPDR = SPIMasterAdress[add];                             // transmit Byte 1 Address
  while((rSPSCR&bSPRF)==0);                                 // ok to received? (Receiver full?)
  fSPIRegs[erSYSSTAT] = rSPDR;                              // read SysStat register

  while((rSPSCR&bSPTE)==0);                                 // ok for send? 
  rSPDR = data;                                             // load data
  while((rSPSCR&bSPRF)==0);                                 // ok to received? (Receiver full?)
  fSPIRegs[add] = rSPDR;                                    // read SysStat register

  __SS_PORT |= __SS_PIN;                                    // stop transfer SSB-> high

  rSPCR &= ~bSPE;                                           // Disable SPI
 
  EnableInt();                                              // only enable IRQ if it was enabled at entry

#if defined(SHADOW)
#warning "WORKAROUND - The registers erSYSTRIM2 and erSYSTRIM3 allways read 0!!!!"

  if(add>=erSYSTRIM2)  {
    fSPIRegs[add] = data;                                   // local copy (as the SPI reg allways reads 0)  
  }
#endif  




}
#endif //defined(__16_BIT_SPI)
//---------------------------------------------------------
#if      defined(__16_BIT_SPI)
void SPI_Read(UINT8 add)  {

  DisableInt();                                             // selective disable IRQ and remember state of I mask
  
  rSPCR |= bSPE;                                            // Enable SPI

  while((rSPSCR&bSPTE)==0);                                 // ok for send?
 
  __SS_PORT &= ~__SS_PIN;                                   // start transfer SSB-> low
  rSPDR = 0x80|SPIMasterAdress[add];                        // transmit Byte 1 Address
  while((rSPSCR&bSPRF)==0);                                 // ok to received? (Receiver full?)
  fSPIRegs[erSYSSTAT] = rSPDR;                              // load SPIDataReister into ..

  while((rSPSCR&bSPTE)==0);                                 // ok for send? 
  rSPDR = 0;                                                // load data (doesn't matter)
  while((rSPSCR&bSPRF)==0);                                 // ok to received? (Receiver full?)

#if defined(SHADOW)								                        
#warning "WORKAROUND - The registers erSYSTRIM2 and erSYSTRIM3 allways read 0!!!!"
  if(add<erSYSTRIM2)  {
    fSPIRegs[add] = rSPDR;
  }else{
    (void)rSPDR;                                            // dummy read
    //fSPIRegs[add] = data;                                 // local copy (as the SPI reg always reads 0)  
  }
#else
  fSPIRegs[add] = rSPDR;
#endif  


  __SS_PORT |= __SS_PIN;                                    // stop transfer SSB-> high

  rSPCR &= ~bSPE;                                           // Disable SPI

  EnableInt();                                              // only enable IRQ if it was enabled at entry
}
#endif //defined(__16_BIT_SPI)
//---------------------------------------------------------
#if      defined(__16_BIT_SPI)
UINT8 SPI_RegValue(UINT8 add) {

  return fSPIRegs[add];
}
#endif //defined(__16_BIT_SPI)


