// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/908EY16_Vector.c,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.3 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  
//
//
//
//  Notes:        
//
//
//
// ========================================================
#define _908EY16_VECTOR_C

#include "ChipSets.h"

#define  __NOT_USED_VECTOR     0xFFFF

// --------------------------------------------------------  
//#define isrTimeBase           __NOT_USED_VECTOR
extern void isrTimeBase();                                  
// --------------------------------------------------------  
#define isrSPITransmit        __NOT_USED_VECTOR
//extern void isrSPITransmit();                                  
// --------------------------------------------------------  
#define isrSPIReceive         __NOT_USED_VECTOR
//extern void isrSPIReceive();                                  
// --------------------------------------------------------  
#define isrADCCoco            __NOT_USED_VECTOR
//extern void isrADCCoco();                                  
// --------------------------------------------------------  
#define isrKeyBoard           __NOT_USED_VECTOR
//extern void isrKeyBoard();                                  
// --------------------------------------------------------  
//#define isrESCIError          __NOT_USED_VECTOR
extern void isrESCIError();                                  
// --------------------------------------------------------  
#define isrESCITransmit       __NOT_USED_VECTOR
//extern void isrESCITransmit();                                  
// --------------------------------------------------------  
//#define isrESCIReceive        __NOT_USED_VECTOR
extern void isrESCIReceive();                                  
// --------------------------------------------------------  
//#define isrTIMBOvfl           __NOT_USED_VECTOR
extern void isrTIMBOvfl();                                  
// --------------------------------------------------------  
#define isrTIMBCH1            __NOT_USED_VECTOR
//extern void isrTIMBCH1();                                  
// --------------------------------------------------------  
#define isrTIMBCH0            __NOT_USED_VECTOR
//extern void isrTIMBCH0();                                  
// --------------------------------------------------------  
#define isrTIMAOvfl           __NOT_USED_VECTOR
//extern void isrTIMAOvfl();                                  
// --------------------------------------------------------  
#define isrTIMACH1            __NOT_USED_VECTOR
//extern void isrTIMACH1();                                  
// --------------------------------------------------------  
#define isrTIMACH0            __NOT_USED_VECTOR
//extern void isrTIMACH0();                                  
// --------------------------------------------------------  
#define isrCMIRQ              __NOT_USED_VECTOR
//extern void isrCMIRQ();                                  
// --------------------------------------------------------  
// HC08 MON08 Target Interface
// HALT Command is realized via IRQ 
// 
#if defined(MON08)
// if MON08 then map   isrHALT  -> __irqIRQ 
extern void isrHALT();                                      // External HW IRQ
#define __isrIRQ    isrHALT
#else
// if not MON08 then map   isrHWIRQ  -> __irqIRQ 
extern void isrHWIRQ();                                     // External HW IRQ
#define __isrIRQ    isrHWIRQ
#endif
// --------------------------------------------------------  
#define isrSWI                __NOT_USED_VECTOR
//extern void isrSWI();                                  
// --------------------------------------------------------  
#define Startup _Startup            
extern void _Startup();                                     // HiCross compiler startup routine declaration
// --------------------------------------------------------  


// --------------------------------------------------------  
#undef  VECTF
#define VECTF ( void ( *const ) ( ) )

// --------------------------------------------------------  
//    INTERRUPT VECTORS TABLE   
// --------------------------------------------------------  
#pragma CONST_SEG VECTORS_DATA  // vectors segment declaration

void (* const _vectab[])( ) =  {
  VECTF isrTimeBase,                                        // 0xFFDC   TIMEBASE
  VECTF isrSPITransmit,                                     // 0xFFDE   SPI Transmit
  VECTF isrSPIReceive,                                      // 0xFFE0   SPI Receive
  VECTF isrADCCoco,                                         // 0xFFE2   ADC COCO
  VECTF isrKeyBoard,                                        // 0xFFE4   KEYBOARD
  VECTF isrESCITransmit,                                    // 0xFFE6   ESCI Transmit   
  VECTF isrESCIReceive,                                     // 0xFFE8   ESCI Receive    
  VECTF isrESCIError,                                       // 0xFFEA   ESCI Error      
  VECTF isrTIMBOvfl,                                        // 0xFFEC   TIMERB OverFlow
  VECTF isrTIMBCH1,                                         // 0xFFEE   TIMERB CH1
  VECTF isrTIMBCH0,                                         // 0xFFF0   TIMERB CH0
  VECTF isrTIMAOvfl,                                        // 0xFFF2   TIMERA OverFlow
  VECTF isrTIMACH1,                                         // 0xFFF4   TIMERA CH1
  VECTF isrTIMACH0,                                         // 0xFFF6   TIMERA CH0
  VECTF isrCMIRQ,                                           // 0xFFF8   CMIRQ
  VECTF __isrIRQ,                                           // 0xFFFA   IRQ
  VECTF isrSWI,                                             // 0xFFFC   SWI
  VECTF Startup                                             // 0xFFFE   RESET
};
// --------------------------------------------------------  
