// ========================================================
//  Copyright (c)2005 Freescale Semiconductor Inc
//  All Rights Reserved
//
//  The code is the property of Freescale GmbH Munich
//  TSPG-APD-IDC Intelligent Distributed Control Operation
//
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  This software is provided by Freescale "AS IS" and any
//  expressed or implied warrenties, including, but not 
//  limited to, the implied warrenties of merchantability
//  and fitness for a particular purpose are disclaimed.
//  In no event shall Freescale or its contributors be 
//  liable for any direct, indirect, incidental, special,
//  examplary, or consequential damages (including, but not 
//  limited to, procurement of substitue goods or services;
//  loss of use, data, or profits; or business interruption)
//  However caused and on any theory of liability, whether 
//  in contract, strict liability, or tort (including 
//  negligence or otherwise) arising in any way out of the 
//  use of this software, even if advised of the possibility
//  of such damage.
// 
//
//
//  Filename:     $Source: D:/home/r51406/___CVS/CVS_Server2/MM908Exxx/CAIRON_ADC.h,v $
//  Author:       $Author: r51406 $
//  Locker:       $Locker:  $
//  State:        $State: Exp $
//  Revision:     $Revision: 1.1.1.1 $
//
//  Functions:    
//
//  History:      Use the CVS command log to display 
//                revision history information.
//
//  Description:  ADC support routines
//                for Cairon SMOS Chip
//
//
//  Notes:        
//
//
//
// ========================================================
#ifndef  CAIRON_ADC_H
#define  CAIRON_ADC_H

#include "CAIRON_IO.h"

// --------------------------------------------------------
// Published Macros
// --------------------------------------------------------
// -----  Mapping of A/D chanals  -------------------------
#define  ADC_CRHB1     (                  0)                // Current Recopy HB1 (LowSide)
#define  ADC_CRHB2     (               bSS0)                // Current Recopy HB2 (LowSide)
#define  ADC_CRHB3     (          bSS1     )                // Current Recopy HB3 (LowSide)
#define  ADC_CRHB4     (          bSS1|bSS0)                // Current Recopy HB4 (LowSide)
#define  ADC_VSUP      (     bSS2          )                // VSUP Scaler  
#define  ADC_TEMP      (     bSS2     |bSS0)                // Die Temperature
#define  ADC_PA0       (     bSS2|bSS1     )                // Analog inputs
#define  ADC_PA1       (     bSS2|bSS1|bSS0)
#define  ADC_PA2       (bSS3               )

// --------------------------------------------------------
// Published Methods
// --------------------------------------------------------

void SMOS_ADMux(UINT8 channel);                             // sets the multiplexer in the analog chip



#endif // CAIRON_ADC_H